<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_oauth2', language 'da', version '4.4'.
 *
 * @package     tool_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptrisk'] = 'Jeg forstår, at deaktivering af e-mailverifikation kan være et sikkerhedsproblem.';
$string['acceptrisk_help'] = 'Deaktivering af e-mailverifikation kan potentielt tillade en bruger at autentificere sig som en anden bruger.';
$string['authconfirm'] = 'Denne handling vil give den godkendte konto permanent API-adgang til Moodle. Hensigten er til brug for en systemkonto til håndtering af filer ejet af Moodle.';
$string['authconnected'] = 'Systemkontoen er nu forbundet til adgang offline';
$string['authnotconnected'] = 'Systemkontoen blev ikke forbundet til adgang offline';
$string['clever_service'] = 'Clever';
$string['configured'] = 'Konfigureret';
$string['configuredstatus'] = 'Konfigureret';
$string['connectsystemaccount'] = 'Forbind til en systemkonto';
$string['createfromtemplate'] = 'Opret en  OAuth 2-service ud fra en skabelon';
$string['createfromtemplatedesc'] = 'Vælg en af skabelonerne til OAuth 2-service herunder for at oprette en OAuth 2-service med en gyldig konfiguration af en af de kendte servicetyper. Det vil oprette en OAuth 2-service med alle de korrekte endepunkter og parametre der bruges til godkendelse, skønt du også vil skulle indtaste klient-id og en hemmelig kode til den nye service, før den kan tages i brug.';
$string['createnewendpoint'] = 'Opret et nyt endepunkt for udbyderen "{$a}"';
$string['createnewservice'] = 'Opret ny tjeneste:';
$string['createnewuserfieldmapping'] = 'Opret ny brugerfelttilknytning til udsteder "{$a}"';
$string['custom_service'] = 'Brugerdefineret';
$string['deleteconfirm'] = 'Er du sikker på at du vil slette identiteten på udbyderen "{$a}"? Plugins der er afhængige af denne udbyder, vil holde op med at fungere.';
$string['deleteendpointconfirm'] = 'Er du sikker på at du vil slette endepunktet "{$a->endpoint}" for udbyderen "{$a->issuer}"? Plugins der er afhængige af dette endepunkt, vil ikke længere fungere.';
$string['deleteuserfieldmappingconfirm'] = 'Er du sikker på, at du vil slette felttilknytningen af brugerfeltet for udstederen "{$a}"?';
$string['discovered'] = 'Serviceopdagelse vellykket';
$string['discovered_help'] = 'Opdagelse betyder, at OAuth 2-slutpunkterne automatisk kunne bestemmes ud fra basis-URL\'en til OAuth-tjenesten. Det er ikke nødvendigt, at alle tjenester "opdages", men hvis de ikke er det, skal slutpunkterne og oplysningerne om brugerkortlægning indtastes manuelt.';
$string['discoverystatus'] = 'Opdagelse';
$string['editendpoint'] = 'Rediger endepunkt: {$a->endpoint} for udbyderen {$a->issuer}';
$string['editendpoints'] = 'Konfigurer endepunkter';
$string['editissuer'] = 'Rediger identitetsudsteder: {$a}';
$string['edituserfieldmapping'] = 'Rediger felttilknytning af brugerfelt for udsteder {$a}';
$string['edituserfieldmappings'] = 'Konfigurer brugerfelttilknytninger';
$string['endpointdeleted'] = 'Endepunkt slettet';
$string['endpointname'] = 'Navn';
$string['endpointname_help'] = 'Nøgle, der bruges til at søge efter dette slutpunkt. Skal slutte med "_endpoint".';
$string['endpointsforissuer'] = 'Endepunkter for udbyderen: {$a}';
$string['endpointurl'] = 'URL';
$string['endpointurl_help'] = 'Dette endepunkts URL. Skal bruge protokollen https://';
$string['facebook_service'] = 'Facebook';
$string['google_service'] = 'Google';
$string['imsobv2p1_service'] = 'Open Badges';
$string['issueralloweddomains'] = 'Login-domæner';
$string['issueralloweddomains_help'] = 'Hvis udfyldt, er denne indstilling en kommasepareret liste over domæner, som logins er begrænset til, når du bruger denne udbyder.';
$string['issueralloweddomains_link'] = 'OAuth_2_login_domains';
$string['issuerbaseurl'] = 'Service base URL';
$string['issuerbaseurl_help'] = 'Basis-URL der bruges til at få adgang til tjenesten.';
$string['issuerclientid'] = 'Klient-id';
$string['issuerclientid_help'] = 'OAuth-klient-ID\'et for denne udsteder.';
$string['issuerclientsecret'] = 'Klienthemmelighed';
$string['issuerclientsecret_help'] = 'OAuth-klienthemmeligheden for denne udsteder.';
$string['issuerdeleted'] = 'Identitetsudsteder slettet';
$string['issuerdisabled'] = 'Identitetsudsteder deaktiveret';
$string['issuerenabled'] = 'Identitetsudsteder aktiveret';
$string['issuerimage'] = 'URL til logo';
$string['issuerimage_help'] = 'En billed-URL, der bruges til at vise et logo for denne udsteder. Kan vises på login-siden.';
$string['issuerloginpagename'] = 'Navn vist på login siden';
$string['issuerloginpagename_help'] = 'Hvis angivet, vil dette navn blive brugt på login-siden i stedet for tjenestens navn.';
$string['issuerloginparams'] = 'Yderligere parametre inkluderet i en login request.';
$string['issuerloginparams_help'] = 'Nogle systemer kræver yderligere parametre til en login request for at kunne læse brugerens grundlæggende profil.';
$string['issuerloginparamsoffline'] = 'Yderligere parametre inkluderet i en login-anmodning for offline adgang.';
$string['issuerloginparamsoffline_help'] = 'Hvert OAuth-system definerer en forskellig måde at anmode om offline adgang. F.eks. kræver Google de ekstra parametre: "access_type=offline&prompt=consent". Disse parametre skal være i URL forespørgselsparameterformat.';
$string['issuerloginscopes'] = 'Områder inkluderet i en login-anmodning.';
$string['issuerloginscopes_help'] = 'Nogle systemer kræver yderligere scopes for en login request for at kunne læse brugerens grundlæggende profil. De standard scopes for et OpenID Connect-kompatibelt system er "openid profile email".';
$string['issuerloginscopesoffline'] = 'Omfang inkluderet i en login-anmodning for offline adgang.';
$string['issuerloginscopesoffline_help'] = 'Hvert OAuth-system definerer en forskellig måde at anmode om offline adgang. F.eks. kræver Microsoft en ekstra scope "offline_access".';
$string['issuername'] = 'Navn';
$string['issuername_help'] = 'Navn på identitetsudstederen. Kan vises på login-siden.';
$string['issuerrequireconfirmation'] = 'Kræv verifikation via mail';
$string['issuerrequireconfirmation_help'] = 'Kræv at alle brugere verificerer deres mailadresse inden de kan logge ind med OAuth. Det gælder nylig oprettede konti som en del af loginprocessen, eller når eksisterende Moodlekonti er forbundet til et OAuth-login via matching af mailadresser.';
$string['issuers'] = 'Udstedere';
$string['issuersetup'] = 'Detaljerede instruktioner til konfiguration af de almindelige OAuth 2-tjenester';
$string['issuersetuptype'] = 'Detaljerede instruktioner til opsætning af {$a} OAuth 2 udbyder';
$string['issuershowonloginpage'] = 'Vis på loginsiden';
$string['issuershowonloginpage_help'] = 'Hvis OAuth 2 autentificeringsplugin\'et er aktiveret, vil denne loginudsteder blive vist på login-siden for at give brugerne mulighed for at logge ind med konti fra denne udsteder.';
$string['issuersservicesallow'] = 'Tillad tjenester';
$string['issuersservicesnotallow'] = 'Tillad ikke tjenester';
$string['issuerusedforinternal'] = 'Interne tjenester';
$string['issuerusedforlogin'] = 'Log ind';
$string['issuerusein'] = 'Denne tjeneste vil blive brugt';
$string['issuerusein_help'] = 'OAuth 2-tjenester kan anvendes til interne tjenester, på login-siden, eller begge dele, hvis det er nødvendigt.';
$string['issueruseineverywhere'] = 'Login-side og interne tjenester';
$string['issueruseininternalonly'] = 'Kun interne tjenester';
$string['issueruseinloginonly'] = 'Kun login-side';
$string['linkedin_service'] = 'LinkedIn';
$string['logindisplay'] = 'Vis på login siden som';
$string['loginissuer'] = 'Tillad login';
$string['microsoft_service'] = 'Microsoft';
$string['moodlenet_service'] = 'MoodleNet';
$string['nextcloud_service'] = 'Nextcloud';
$string['notconfigured'] = 'Ikke konfigureret';
$string['notdiscovered'] = 'Tjenesteopdagelse ikke lykkedes';
$string['notloginissuer'] = 'Tillad ikke login';
$string['pluginname'] = 'OAuth 2-servicer';
$string['privacy:metadata'] = 'Plugin\'et OAuth 2-servicer gemmer ingen personlige data.';
$string['savechanges'] = 'Gem ændringerne';
$string['serviceshelp'] = 'Instruktioner til opsætning af tjenesteudbyder.';
$string['systemaccountconnected'] = 'Systemkonto tilsluttet';
$string['systemaccountconnected_help'] = 'Systemkonti bruges til at give avanceret funktionalitet for plugins. De er ikke kun nødvendige for login-funktionalitet, men andre plugins, der bruger OAuth-tjenesten, kan tilbyde et reduceret sæt af funktioner, hvis systemkontoen ikke er blevet tilsluttet. For eksempel kan repositories ikke understøtte "kontrollerede links" uden en systemkonto til at udføre filoperationer.';
$string['systemaccountnotconnected'] = 'Systemkontoen er ikke tilsluttet';
$string['systemauthstatus'] = 'Systemkonto tilsluttet';
$string['usebasicauth'] = 'Godkend tokenanmodninger via HTTP-overskrifter';
$string['usebasicauth_help'] = 'Benyt HTTP Basic autentificeringsskemaet, når du sender klient-ID og adgangskode med en anmodning om opfrisknings-token. Anbefalet af OAuth 2 standarden, men muligvis ikke tilgængelig hos nogle udstedere.';
$string['userfieldexternalfield'] = 'Navn på eksternt felt';
$string['userfieldexternalfield_error'] = 'Dette felt kan ikke indeholde HTML.';
$string['userfieldexternalfield_help'] = 'Navn på feltet leveret af det eksterne OAuth-system.';
$string['userfieldinternalfield'] = 'Navn på internt felt';
$string['userfieldinternalfield_help'] = 'Navn på Moodle-brugerfeltet, der skal kortlægges fra det eksterne felt.';
$string['userfieldmappingdeleted'] = 'Brugerfeltkortlægning slettet';
$string['userfieldmappingsforissuer'] = 'Brugerfeltkortlægninger for udsteder: {$a}';
