<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_coderunner', language 'ar', version '4.4'.
 *
 * @package     qtype_coderunner
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['HIDE'] = 'إخفاء';
$string['HIDE_IF_FAIL'] = 'الإخفاء عند الفشل';
$string['HIDE_IF_SUCCEED'] = 'الإخفاء عند النجاح';
$string['SHOW'] = 'إظهار';
$string['aborted'] = 'تم إحباط الاختبار بسبب وقوع خطأ.';
$string['ace-language'] = 'لغة Ace';
$string['ace_gapfillerui_ui_source_descr'] = '"globalextra" لتأخذ النص البرمجي إلى العرض من حقل globalextra أو "test0" لتأخذه من حقل النص البرمجي الاختباري للفحص الأول';
$string['ace_ui_notready'] = 'محرر Ace غير جاهز. ربما عليك إعادة تحميل الصفحة؟';
$string['aceui_auto_switch_light_dark_descr'] = 'إسمح للمستعرض أو لنظام التشغيل بتفضيل القوالب الداكنة لتخطي القالب الفاتح المسبق التعريف من Ace.';
$string['aceui_font_size_descr'] = 'حجم خط محرر Ace';
$string['aceui_import_from_scratchpad_descr'] = 'صواب للسماح لمحرر Ace لتلقي الجواب بصيغة JSON المستعمل من قبل واجهة المستخدم في scratchpad واستخراج النص البرمجي للإجابة منه. يسهل التبديل ما بين واجهات المستخدم. أتركه على قيمة الصح ما لم تكن تريد من Ace تحرير مكونات JSON مع مفتاح "answer_code".';
$string['aceui_live_autocompletion_descr'] = 'تمكين وضع الإكمال التلقائي المباشر لمحرر Ace.';
$string['aceui_theme_descr'] = 'قالب محرر Ace. الافتراضي هو المظهر الفاتح "textmate". القالب الداكن البديل هو "tomorrow_night". القوالب الفاتحة يتم تخطيها من قبل تفضيلات المستخدم - أنظر auto_switch_dark.';
$string['addingcoderunner'] = 'تجري إضافة سؤال CodeRunner جديد';
$string['advanced_customisation'] = 'تخصيص متقدم';
$string['ajax_error'] = '*** خطأ في AJAX. لا تقم بحفظ هذا! ***';
$string['allok'] = 'تم تجاوز كل الاختبارات!';
$string['allornone'] = 'لا بد من إعطاء الترميز الاختباري إما لكل حالات الاختبار أو ليس لواحد منها.';
$string['allornothing'] = 'منح التقديرات على أساس الكل أو لا شيء';
$string['allornothing_help'] = 'إذا تم تأشير \'الكل أو لا شيء\'، ينبغي تلبية متطلبات كل حالات الفحص من قبل التسليم ليتمكن من اكتساب أي درجات. بخلاف ذلك، يتم الحصول على الدرجات عبر جمع درجات كل حالات الفحص الناجحة والتعبير عنها بشكل نسبة مقاسة إلى الدرجة العظمى الممكنة للسؤال.

يمكن تعيين الدرجات على مستوى كل حالة من حالات الفحص فقط إذا كان \'الكل أو لا شيء\' غير مؤشر.

إذا تم استعمال مظهر المُقيِّم الذي يمنح جزءاً من الدرجات لحالات الفحص، \'الكل أو لا شيء\' ينبغي عموماً أن يكون غير مؤشر.';
$string['allowattachments'] = 'السماح بالمرفقات';
$string['allowattachments_help'] = 'فيما إذا كان ينبغي السماح للطلاب بإضافة مرفقات إلى تسليماتهم، وإن كان الجواب بنعم، كم من تلك المرفقات يتم نسخها إلى مجلد تشغيل العمل، مع قائمة مفصولة بفوارز لأسماء المرفقات يتم تقديمها إلى المظهر في المتغير Twig {{ ATTACHMENTS }}. تحذير: السماح بالمرفقات قد تكون له تبعات على الأداء أو مساحة الخزن وبخاصة في مواقع مودل ذات العدد الكبير من المقررات الدراسية أو التي تسمح برفع ملفات كبيرة الحجم. مخدمات مودل ومخدمات Jobe قبل شباط 2019، تخزن كل المرفقات إلى أجل غير مسمى.';
$string['allowedfilenames'] = 'أسماء الملفات المسموح بها';
$string['allowedfilenames_help'] = 'كل أسماء الملفات المرفوعة عليها أن تحاكي التعبير الإعتيادي لـ PHP (Perl)، إذا لم يكن فارغاً. على سبيل المثال، استعمل \'.+\\\\.cpp\' للسماح بأي ملف بلغة C++ أو \'(?!Prog)\\\\.java\' للسماح بأي ملف من Java باستثناء \'Prog.java\'. فضلاً عن ذلك، أسماء الملفات ينبغي أن تحتوي فقط على حروف لاتينية، أرقام، شُرَط تحتانية، شُرط ونقاط، وينبغي أن لا تبدأ بشرطتين تحتانيتين متتابعتين (\'\\_\\_\')، كما ينبغي أن لا تتعارض مع أسماء أي من ملفات الدعم. الوصف هو رسالة نصية تُعرض على الطالب لتوضح له أنواع الملف/الملفات المتوقعة. أتركه فارغاً لعرض التعبير الإعتيادي نفسه. أتركهما فارغين كلاهما لتجاوز التحقق من التعابير الإعتيادية.';
$string['allowedfilenamesregex'] = 'أسماء الملفات المسموح بها (التعابير الاعتيادية)';
$string['allowmultiplestdins'] = 'السماح بمكتبات متعددة من stdins';
$string['answer'] = 'الجواب';
$string['answer_help'] = 'يمكن إدخال إجابة نموذجية هنا واستعمالها للتحقق من قبل كاتب السؤال وإظهارها إختيارياً للطلاب خلال المراجعة. وهي مستعملة أيضاً من قبل النص البرمجي للفحص بالجملة. يتم التحقق من صحة الإجابة غير الفارغة عند الحفظ ما لم يتم رفع التأشير من \'التحقق عند الحفظ\'';
$string['answerbox_group'] = 'مربع الجواب';
$string['answerbox_group_help'] = 'حدد عدد الصفوف المُعيَّنة لمربع الإجابة. هذا سيحدد أدنى ارتفاع لعنصر واجهة المستخدم (أي Ace) الذي يتحكم بمربع الإجابة. سيتم ضبط العرض بما يلائم النافذة. إذا كان الجواب متعدياً على المربع أفقياً أو عمودياً، ستظهر شرائط التمرير فيه.';
$string['answerboxlines'] = 'الصفوف';
$string['answerpreload'] = 'التحميل المسبق لمربع الإجابة';
$string['answerpreload_help'] = 'النص المعطى هنا سيتم تحميله مسبقاً إلى مربع الإجابة الخاص بالطالب.';
$string['answerprompt'] = 'الجواب:';
$string['answerrequired'] = 'لطفاً، أعطِ إجابة غير فارغة';
$string['answertooshort'] = 'الإجابة قصيرة جداً، ينبغي أن تتضمن على الأقل {$a} من الأحرف.';
$string['answerunchanged'] = 'ينبغي عليك إكمال الإجابة المحملة أو تحريرها.';
$string['asolutionis'] = 'إظهار/إخفاء الحل من كاتب السؤال:';
$string['atleastonetest'] = 'ينبغي عليك إعطاء حالة اختبار واحدة على الأقل لهذا السؤال.';
$string['attachmentoptions'] = 'خيارات المرفقات';
$string['attachmentsoptional'] = 'المرفقات إختيارية';
$string['attachmentsrequired'] = 'يتطلب المرفقات';
$string['attachmentsrequired_help'] = 'هذا الخيار يحدد أقل عدد مطلوب من المرفقات ليتم منح الدرجة للاستجابة.';
$string['autotagbycategoryindextitle'] = 'الوسم التلقائي لسؤال CodeRunner';
$string['autotagbycategorytitle'] = 'الوسم التلقائي لـ CodeRunner حسب الصنف';
$string['backtobulktestindex'] = 'عودة إلى صفحة فهرس الفحص بالجملة';
$string['bad_dotdotdot'] = 'استعمال خاطئ لـ \'...\'. ينبغي أن تكون في النهاية، بعد غرامتين رقميتين متزايدتين';
$string['bad_empty_splitter'] = 'لا يمكن لمقسم الاختبار أن يكون فارغاً عند استعمال مظهر الدمج';
$string['bad_new_prototype_name'] = 'تسمية خاطئة لنوع أولي جديد: مستعمل سلفاً';
$string['badacelangstring'] = 'جملة خاطئة للغة Ace';
$string['badcputime'] = 'محدد وقت وحدة المعالجة المركزية ينبغي تركه فارغاً أو أن يكون رقماً موجباً أكبر من الصفر.';
$string['bademptyprecheck'] = 'الفحص القبلي فشل مع المخرجات الآتية غير المتوقعة.';
$string['badfilenamesregex'] = 'تعبير إعتيادية غير صحيح';
$string['badfiles'] = 'اسم/أسماء الملفات غير المسموح بها: {$a}';
$string['badjson'] = 'مخرجات خاطئة من JSON مأخوذة من مخرجات مُقيِّم المُدمِج. المخرجات كانت: {$a->output}';
$string['badjsonfunc'] = 'دالة مدمجة مجهولة من JSON وهي ({$a->func})';
$string['badmemlimit'] = 'محدد الذاكرة ينبغي إما تركه فارغاً أو أن يكون رقماً غير سالب';
$string['badpenalties'] = 'نظام الغرامة ينبغي أن يكون قائمة مفصولة بفوارز لأرقام ضمن المدى [0, 100]';
$string['badquestion'] = 'خطأ في السؤال';
$string['badrandomintarg'] = 'معامل خاطئ مرسل إلى دالة JSON @randomint';
$string['badrandompickarg'] = 'معامل خاطئ مرسل إلى دالة JSON @randompic';
$string['badsandboxparams'] = 'حقل \'أخرى\' (عوامل sandbox) ينبغي إما أن يكون فارغاً أو يحتوي سجلاً صحيحاً لـ JSON';
$string['badtemplateparams'] = 'عوامل المظهر ينبغي إما أن تكون فارغة أو محتوية على سجل JSON صحيح';
$string['baduiparams'] = 'عوامل واجهة المستخدم ينبغي أن تكون فارغة أو سجل JSON صالح.';
$string['brokencombinator'] = 'كان متوقعاً {$a->numtests} من نتائج الفحص، لكن تم الحصول على {$a->numresults}. ربما هناك إفراط في المخرجات أو خطأ في السؤال؟';
$string['brokentemplategrader'] = 'مخرجات خاطئة من المُقيِّم: {$a->output}. ربما تنفيذ برنامجك قد تم إحباطه (أي بلغ أقصى استهلاك متاح للذاكرة أو تجاوز مهلة التنفيذ).';
$string['bulkquestiontester'] = 'فحوص <a href="{$a->link}">النص البرمجي للفحص بالجملة</a> حيث تم تأشير نماذج الإجابات لجميع الأسئلة ضمن السياق الحالي على أنها صحيحة. مفيد بمجرد إضافة بعض الأسئلة ذات نماذج من الإجابات؛ يفتقر إليها التنصيب الأصلي.';
$string['bulktestallincontext'] = 'إفحص الكل';
$string['bulktestcontinuefromhere'] = 'قم بالتنفيذ مرة أخرى أو الاستئناف، بادئاً من هنا';
$string['bulktestindextitle'] = 'الفحص بالجملة لـ CodeRunner';
$string['bulktestoverallresults'] = 'النتائج الإجمالية';
$string['bulktestrun'] = 'قم بتنفيذ كل فحوص الأسئلة لكل الأسئلة في النظام (بطيء، المشرف فقط)';
$string['bulktesttitle'] = 'يجري فحص الأسئلة في {$a}';
$string['cachedef_coderunner_grading_cache'] = 'يخبئ نتائج التقييم حتى نتجنب تكرار الذهاب إلى Jobe.';
$string['cachepurgecheckingkeyxoftotalnum'] = 'معالجة المفتاح {$a->x} من مجموع {$a->totalnumkeys} من المفاتيح إجمالاً (لكل المساقات)';
$string['cachepurgeindexinfo'] = 'تطهير المفاتيح القديمة ليؤدي فقط إلى حذف مُدخلات الخبء لعمليات تشغيل التقييم التي هي أقدم من وقت استبقاء خبء Coderunner كما هو مضبوط في إعدادات المشرف. تطهير الكل سيؤدي إلى حذف كل مُخلات الخبء للمساق المعني.';
$string['cachepurgeindextitle'] = 'فهرس تطهير مخبوءات Coderunner';
$string['cachepurgepagetitle'] = 'تطهير مخبوءات {$a}';
$string['cannotrunprototype'] = 'هذا نموذج أولي ولا يمكن تشغيله. إذا رغبتك باستعماله، أنشئ سؤالاً جديدًا واضبطنوع السؤال هذا.';
$string['coderunner'] = 'ترميز البرنامج';
$string['coderunner:sandboxwsaccess'] = 'السماح بالوصول إلى صندوق الرمل الخاص بـ Jobe عبر خدمات الويب';
$string['coderunner:viewhiddentestcases'] = 'مشاهدة الحالات التجريبية المخفية عند مراجعة الأسئلة';
$string['coderunner_grading_cache'] = 'يخبئ نتائج التقييم حتى نتجنب تكرار الذهاب إلى Jobe.';
$string['coderunner_help'] = 'استجابة إلى سؤال يكون وصفة لجزء من برنامج، دالة، أو برنامج كامل، يقوم المستجيب بإدخال ترميز مصدري بلغة برمجة معينة تلبي متطلبات تلك الوصفة.';
$string['coderunner_install_testsuite_failures'] = 'الفحوص التي فشلت';
$string['coderunner_install_testsuite_intro'] = 'هذه الصفحة تسمح لك بفحص أسئلة CodeRunner ذات نماذج إجابات للتأكد من أنها تعمل بشكل صحيح.';
$string['coderunner_install_testsuite_noanswer'] = 'الأسئلة التي ليس لها نماذج من الإجابات';
$string['coderunner_install_testsuite_title'] = 'حزمة فحص لنماذج إجابات CodeRunner';
$string['coderunner_install_testsuite_title_desc'] = 'إن <a href="{$a->link}">النص البرمجي لفحص نموذج الإجابة</a> يتحقق من كون الأسئلة ذات نماذج إجابات تعمل بشكل صحيح.';
$string['coderunner_link'] = 'question/type/coderunner';
$string['coderunner_question_type'] = 'نوع السؤال CodeRunner:';
$string['coderunnercategories'] = 'الأصناف ذات أسئلة CodeRunner';
$string['coderunnercontexts'] = 'السياقات ذات أسئلة CodeRunner';
$string['coderunnersettings'] = 'إعدادات CodeRunner';
$string['coderunnersummary'] = 'الإجابة هي ترميز برمجي يتم تنفيذه في سياق مجموعة من حالات الفحص لتقرير مدى صحته.';
$string['coderunnertype'] = 'نوع السؤال';
$string['coderunnertype_help'] = 'إختر لغة البرمجة ونوع السؤال. بمجرد إختيار النوع، يمكن مشاهدة التفاصيل في لوحة تفاصيل نوع السؤال أدناه.';
$string['coderunnerwssettings'] = 'إعدادات خدمات الويب لصندوق الرمل';
$string['columncontrols'] = 'جدول النتائج';
$string['columncontrols_help'] = 'خانات التأشير تحدد أي من أعمدة جدول النتائج ينبغي عرضها إلى الطالب بعد التسليم';
$string['confirm_proceed'] = 'إذا قمت بحفظ السؤال مع عدم التأشير على \'التخصيص\'، سيتم فقدان كل التخصيصات التي تم إجراؤها. أتريد المتابعة؟';
$string['confirmreset'] = 'هل تريد تجاهل كل ما أجريته في هذا السؤال وإعادة تعيين مربع الإجابة إلى قيمته الأصلية قبل التحميل؟';
$string['corruptuiparams'] = 'عوامل واجهة المستخدم لهذا السؤال أو نسخته الأولية غير كاملة. تابع بحذر.';
$string['cputime'] = 'محدد الوقت (بالثواني)';
$string['currentttlinfo'] = 'وقت استبقاء خبء تقييم Coderunner مضبوط حاليًا على TTL = {$a->seconds} من الثواني (={$a->days} من الأيام)';
$string['customisation'] = 'التخصيص';
$string['customisationcontrols'] = 'التخصيص';
$string['customise'] = 'تخصيص';
$string['datafiles'] = 'يدعم الملفات';
$string['datafiles_help'] = 'أي ملفات يتم رفعها هنا ستتم إضافتها إلى مجلد التشغيل عند تنفيذ برنامج المظهر الموسع. هذا يسمح بإضافة بيانات كبيرة أو ملفات دعم بشكل ملائم.';
$string['default_penalty_regime'] = 'نظام الغرامة الافتراضي';
$string['default_penalty_regime_desc'] = 'نظام الغرامة الافتراضي المزمع تطبيقه مع الأسئلة الجديدة، متضمناً لقائمة مفصولة بفوارز من النسب المئوية للغرامات، وينتهي إختيارياً بـ ", ..." للدلالة على متوالية عددية مستمرة.';
$string['display'] = 'أعرض';
$string['downloadquizattempts'] = 'تنزيل محاولات الاختبار';
$string['downloadquizattemptshelp'] = 'أنقر المقرر المناسب و/أو زر التنزيل
        للمقرر والاختبار اللذين ترغب بتنزيلهما. الأرقام التي ما بين الأقواس
        بعد المقررات الدراسية تمثل عدد الاختبارات في المقرر التي لديها على الأقل
        تسليم واحد. الأرقام ما بين الأقواس بعد اسم الاختبار تمثل عدد التسليمات.';
$string['duplicateprototype'] = 'تم تعريف السؤال ليكون من نوع \'{$a->crtype}\' ولكن النوع الأولي غير فريد في الأسئلة الآتية: {$a->outputstring}. يرجى إزالة كل العينات ما عدا واحدة، أو إختر نوع سؤال آخر.';
$string['editingcoderunner'] = 'يجري تحرير سؤال CodeRunner';
$string['empty_new_prototype_name'] = 'لا يمكن لتسمية نوع السؤال الجديد أن تكون فارغة';
$string['emptypenaltyregime'] = 'لا بد من تعريف نظام الغرامة (منذ الإصدار 3.1)';
$string['emptysandboxlanguage'] = 'لغة صندوق الرمل لا يمكن أن تكون فارغة عند إنشاء النوع الأولي.';
$string['enable'] = 'تمكين';
$string['enable_diff_check'] = 'تمكين زر \'إظهار الفروق\'';
$string['enable_diff_check_desc'] = 'تقديم زر \'إظهار الفروق\' للطلبة إذا كانت إجابتهم خاطئة وكان يجري استعمال التحقق بطريقة التطابق الكامل';
$string['enable_sandbox_desc'] = 'السماح باستعمال sandbox المحدد لتنفيذ تسليمات الطلاب';
$string['enable_sandbox_ws'] = 'تمكين خدمات الويب لصندوق الرمل';
$string['enable_sandbox_ws_desc'] = 'تمكين خدمات الويب مما يسمح بالوصول المباشر إلى مخدم صندوق الرمل (عادة ما يكون Jobe). ميزة تجريبية.';
$string['enablecombinator'] = 'تمكين المُدمِج';
$string['enablegradecache'] = 'تمكين قراءة/كتابة نتائج Jobe، من/إلى مخبوءات تقييم Coderunner.';
$string['enablegradecache_desc'] = 'تجريبي. الخبء هو خبء محلي في مودل (حاليًا مخزون ملفات) لتخزين نتائج تقييم الأسئلة. بشكل أساسي يهدف إلى تسريع منح الدرجات عبر استعمال النتائج المخبأة لعمليات تشغيل jobe حيثما يكون تسليم jobe نفسه قد سبق تقييمه. المهام المشغلة حاليًا (مثل مربعات جربها وتشغيلات لوحات المسودات) لن تتم تخبئتها أبدًا. ملاحظة: إذا قمت بإطفاء خبء التقييم، فهذا جيد من أجل إفراغ خبء Coderunner قبل أن تعيد تمكينه مرة أخرى حتى تكون لديك حالة معروفة عن وضع الخبء. عليك أيضًا إخلاء الخبء إذا غيرت الجانب الخلفي من Jobe (مثلاً تنصيب إصدار جديد من بايثون هناك) نظرًا لكون النتائج قد تختلف عما كانت عليه في الخبء.';
$string['enter_to_submit'] = 'إضغط Enter للتسليم...';
$string['equalitygrader'] = 'تطابق كامل';
$string['error_access_denied'] = 'الوصول إلى مخدم صندوق الرمل ممنوع';
$string['error_excessive_output'] = 'إخراج مفرط';
$string['error_jobe_unknown'] = 'خطأ مجهول من مخدم Jobe';
$string['error_json_params'] = 'مجموعة العوامل ليست بصيغة JSON صحيحة';
$string['error_loading_prototype'] = 'خطأ عند تحميل النوع الأولي. مشاكل الشبكة أو توقف المخدم، ربما!';
$string['error_loading_ui_descr'] = 'خطأ عند تحميل وصف واجهة المستخدم. مشاكل الشبكة أو توقف المخدم ربما!';
$string['error_memory_limit'] = 'حد الذاكرة تم تجاوزه';
$string['error_sandbox_server_overload'] = 'تحميل زائد لمخدم Jobe';
$string['error_submission_limit_reached'] = 'تم بلوغ حد التسليم لصندوق الرمل في Jobe';
$string['error_timeout'] = 'حد الوقت تم تجاوزه';
$string['error_unknown_language'] = 'تم طلب لغة غير معروفة';
$string['error_unknown_runtime'] = 'خطأ غير معروف وقت التشغيل';
$string['erroroninit'] = '**** خطأ عند الشروع بالسؤال ****<br>{$a->error}<br>';
$string['errorstring-accessdenied'] = 'تم رفض الوصول إلى صندوق الرمل';
$string['errorstring-autherror'] = 'لا يوجد تصريح باستعمال صندوق الرمل';
$string['errorstring-blocked-url'] = 'تم حظر الرابط. تحقق من عنوان رابط Jobe وإعدادات أمان HTTP في مودل.';
$string['errorstring-duplicate-name'] = 'إعادة تسمية الفئة؛ هذا الاسم يتضارب مع ملفات الدعم لهذا السؤال.';
$string['errorstring-jobe-failed'] = 'فشل طلب مخدم Jobe.';
$string['errorstring-jobe400'] = 'خطأ من مخدم صندوق الرمل العائد لـ Jobe:';
$string['errorstring-ok'] = 'تم';
$string['errorstring-overload'] = 'تعذر تشغيل Job بسبب فرط الحمل في المخدم. ربما عليك المحاولة مرة أخرى قريباً!';
$string['errorstring-pastenotfound'] = 'يتم طلب حالة job غير موجود';
$string['errorstring-submissionfailed'] = 'التسليم إلى صندوق الرمل قد فشل';
$string['errorstring-submissionlimitexceeded'] = 'تم بلوغ حد التسليم إلى صندوق الرمل';
$string['errorstring-unknown'] = 'خطأ غير متوقع عند تنفيذ نصوصك البرمجية. قد يكون مخدم صندوق الرمل متوقفاً أو متعرضاً إلى حملٍ عالٍ. قد يكون من الأفضل أن تحاول مجدداً بعد برهة!';
$string['errorstring-wronglangid'] = 'تمت المطالبة بلغة غير موجودة';
$string['event_sandboxwebserviceexec'] = 'تنفيذ صندوق الرمل لـ Coderunner';
$string['event_sandboxwebserviceexec_desc'] = 'تم تنفيذ المهمة بواسطة خدمة ويب صندوق الرمل لـ CodeRunner.';
$string['exit_fullscreen'] = 'الخروج من ملء الشاشة';
$string['expand'] = 'توسيع';
$string['expandtitle'] = 'إظهار أصناف الأسئلة';
$string['expected'] = 'المخرجات المتوقعة';
$string['expected_help'] = 'المخرجات المتوقعة من الفحص. تُشاهد من جهة المظهر بمثابة {{TEST.expected}}.';
$string['expectedcolhdr'] = 'المتوقع';
$string['exportthisquestion'] = 'تصدير هذا السؤال';
$string['exportthisquestion_help'] = 'هذا سيقوم بإنشاء ملف تصدير مودل بصيغة XML محتوياً على هذا السؤال فقط. مثال على كون ذلك مفيداً، هو عندما تظن أن هذا السؤال يجسد مشكلة في ملحق CodeRunner وتريد التبليغ عنها برسالة إلى المطورين.';
$string['extra'] = 'بيانات القالب الإضافية';
$string['extra_help'] = 'حقل نصي إضافي قد يكون مفيداً أحياناً للاستعمال من قبل المظهر، يتم الوصول إليه بمثابة {{TEST.extra}}';
$string['extractcodefromjson'] = 'متوافق مع Ace/Scratchpad';
$string['fail'] = 'فشل';
$string['failedhidden'] = 'برمجتك فشلت في واحد أو أكثر من الفحوص المخفية.';
$string['failedntests'] = 'فشلت في {$a->numerrors} من الفحوص';
$string['failedtesting'] = 'فشلت في الفحوص.';
$string['fails'] = 'الفشل';
$string['feedback'] = 'الإفادة';
$string['feedback_help'] = 'إختر \'يتم ضبطها من قبل الاختبار\' للسماح بخيارات مراجعة الاختبار (بشكل خاص، الإعداد \'الإفادة الخاصة\') للتحكم بعرض جدول النتائج، \'فرض العرض\' لإظهار جدول النتائج بغض النظر، و\'فرض الإخفاء\' لإخفائه في جميع الأحوال';
$string['feedback_hide'] = 'فرض الإخفاء';
$string['feedback_quiz'] = 'توضع من قبل الاختبار';
$string['feedback_show'] = 'فرض الإظهار';
$string['fileheader'] = 'ملفات الدعم';
$string['filenamesexplain'] = 'الوصف';
$string['filenamesregex'] = 'تعبير إعتيادي';
$string['filloutoneanswer'] = 'عليك إدخال الترميز المصدري الذي يلبي المواصفات. سيتم تنفيذ الترميز الذي تُدخله لتقرير مدى صحته وسيتم منح الدرجة وفقاً لذلك.';
$string['firstfailure'] = 'أول حالة فحص فاشلة: {$a}';
$string['forexample'] = 'على سبيل المثال';
$string['fullscreen'] = 'ملء الشاشة';
$string['gapfillerui_delimiters_descr'] = 'مصفوفة ذات عنصرين من النصوص المستعملة لفتح وإغلاق وصف الفجوة';
$string['gapfillerui_sync_interval_secs_descr'] = 'الفترة الزمنية بالثواني ما بين دعوات مزامنة محتويات واجهة المستخدم رجوعًا إلى إجابة السؤال. 0 معناه تعطيل المزامنة التلقائية.';
$string['gapfillerui_ui_source_descr'] = '"العمومي الإضافي" لأخذ HTML المراد عرضه من حقل العمومي الإضافي أو "test0" لأخذه من حقل النص البرمجي الاختباري للاختبار الأول';
$string['giveup'] = 'زر الإيقاف';
$string['giveup_aftermaxmarks'] = 'متاح بمجرد تعذر تحسين الدرجة';
$string['giveup_always'] = 'متاح دومًا';
$string['giveup_help'] = 'إذا تم تمكين هذا الخيار، سيرى الطلاب زرًا للتوقف عن التفاعل مع السؤال، وعرض الإفادة العامة.

يمكن إظهار \'توقف واقرأ الإفادة النهائية\' يمكن إظهاره منذ البدء، أو بمجرد عجز الطالب عن تحسين درجته، بسبب نظام الغرامات.';
$string['giveup_never'] = 'غير متاح أبدًا';
$string['globalextra'] = 'Global extra';
$string['globalextra_help'] = 'حقل نصي للاستعمال العام من قبل مؤلف القالب، مثل الحقل الإضافي لكل حالة إختبارية، ولكنه عمومي لكل الاختبارات. متاح إلى مؤلف القالب بشكل {{ QUESTION.globalextra }}.';
$string['goodemptyprecheck'] = 'نجحت';
$string['gotcolhdr'] = 'Got';
$string['grader'] = 'المقيِّم';
$string['grading'] = 'منح التقديرات';
$string['gradingcachedefinitionnotfound'] = 'غريب... يتعذر العثور على تعريف خبء تقييم Coderunner!';
$string['gradingcachefilestorenotfound'] = 'غريب... يتعذر العثور على ملف تخزين خبء تقييم Coderunner!';
$string['gradingcontrols'] = 'أدوات التحكم بمنح التقديرات';
$string['gradingcontrols_help'] = 'يقوم مُقيِّم \'التطابق الكامل\' بمنح الدرجات فقط عندما تتطابق
مخرجات التنفيذ بالضبط مع القيمة المتوقعة المعرفة من قبل
حالة الفحص. يتم تجريد كل السطور من الفراغات السابقة
واللاحقة قبل إجراء فحص المساواة.

إن المُقيِّم القريب من المساواة مشابه له ما عدا أنه يقوم أيضاً
بضغط الفراغات المتعددة وعلامات الجدولة ليجعلها فراغاً
واحداً، ويحذف كل السطور الخالية ويحول الحروف جميعاً
إلى حالتها الصغيرة.

يقوم مُقيِّم \'التعبير الإعتيادي\' باستعمال حقل \'المتوقع\'
لحالة الفحص بمثابة تعبير إعتيادي (بدون المحددات
التي من نوع PERL) ثم يفحص المخرجات للتحري
عن وجود مطابقة مع النتيجة المتوقعة في أي مكان من
الناتج.
مثال، القيمة المتوقعة \'ab.*z\' ستطابق أي ناتج يحتوي
الحرفين \'ab\' حيثما تواجدا في الناتج، والحرف \'z\' في
مكان ما بعدهما.
لفرض المطابقة مع الناتج بالكامل، إبدأ التعبير الإعتيادي
وأنهه بـ \'\\A\' و \'\\Z\' على التوالي. تستعمل مطابقة التعبير
الإعتيادي خيارات MULTILINE و DOTALL.

يفرض خيار \'مُقيِّم المظهر\' بأن مخرجات البرنامج هي
في الواقع نتيجة التقييم بحد ذاتها، بعبارة أخرى، إن المظهر
يفحص *ويُقيِّم* إجابة الطالب.
المخرجات الوحيدة من هكذا مظهر للبرنامج ينبغي أن تكون
سجل بترميز JSON.

إذا كان المظهر هو مظهر لكل فحص (أي ليس مُدمِجاً)، فعلى جملة JSON أن تصف صفاً
من جدول النتائج وينبغي أن تحتوي على الأقل على حقل \'fraction\'، والذي يتم ضربه
بـ TEST.mark لتقرير عدد الدرجات الممنوحة إلى حالة الفحص. كما أنه عادة ينبغي
أن يحتوي على حقل \'got\'، والذي هو القيمة المعروضة في عمود \'Got\' من جدول النتائج.
الأعمدة الأخرى في جدول النتائج (testcode، stdin، expected) يمكن تعريفها أيضاً
من قبل برنامج منح التقديرات باستعمال المظهر وسيتم استعمالها بدلاً من القيم من حالة الفحص.
كمثال على ذلك، إذا كانت مخرجات البرنامج هي ما يأتي:
<code>{"fraction":0.5, "got": "نصف الإجابات كانت صحيحة!"}</code>،
سيتم منح نصف الدرجات لحالة الفحص تلك بالذات، وعمود \'Got\' سيعرض النص "نصف الإجابات كانت صحيحة!". يمكن إضافة أعمدة أخرى إلى جدول النتائج عبر إضافة سمات
إضافية إلى سجل JSON فضلاً عن حقل أعمدة النتائج للسؤال نفسه.

إذا كان المظهر مُدمِجاً، ينبغي لمخرجات جملة JSON القادمة من مُقيِّم المظهر أن تحتوي مرة
أخرى على حقل \'fraction\'، ولكن هذه المرة بالنسبة إلى الدرجة الإجمالية، وقد تحتوي صفراً
أو المزيد من \'prologuehtml\'، \'testresults\'، \'epiloguehtml\'، \'columnformats\'، \'showoutputonly و \'showdifferences\'.
إن حقلي \'prologuehtml\' و \'epiloguehtml\' هما بتنسيق html ويتم عرضهما على التوالي
قبل جدول النتائج (الإختياري) وبعده. إن حقل \'testresults\'، إذا تم ذكره، هو قائمة بالقوائم
المستعملة لعرض نوع ما من جداول النتائج. الصف الأول هو رؤوس الأعمدة وكل الصفوف
الأخرى تمثل متن الجدول. توجد قيمتان خاصتان من رؤوس الأعمدة، هما: \'iscorrect\'
و \'ishidden\'. تستعمل أعمدة \'iscorrect\' لعرض تأشيرات أو تقاطعات تمثلان قيمتي
1 أو 0 على التوالي. لا يتم عرض عمود \'ishidden\' فعلياً، ولكن قيمة 0 أو 1 فيه يمكن
استعمالهما لتبديل حالة عرض الصف ما بين الإظهار والإخفاء. الطلاب لا يشاهدون الصفوف
المخفية، ولكن المقيمين والمشرفين يمكنهم رؤيتها. إذا تم تجهيز جدول \'testresults\' الإختياري،
سيكون بالإمكان أيضاً تجهيز الحقل \'columnformats\'. هذا ينبغي أن يكون قائمة من الجمل،
واحدة لكل عمود مع استبعاد عمودي \'iscorrect\' و \'ishidden\'. الجمل تحدد التنسيق المستعمل
لعرض قيم الخلايا؛ حالياً التنسيقات المدعومة هي \'%s\' لطريقة عرض الجمل الإعتيادية (والتي
تكون فيها منظفة وملفعة بعنصر \'pre\') و \'%h\' لتمثل قيمة html والتي ينبغي عدم تعريضها
لمزيد من المعالجة قبل العرض. يقوم حقل \'showdifferences\' بتشغيل عرض زر \'إظهار
الفروق\' بعد جدول النتائج إذا كان كسر الدرجة الممنوحة لا يساوي 1.0. يُستعمل حقل
\'showoutputonly\'، إذا كانت قيمته true، عندما يكون السؤال معداً فقط لعرض المخرجات
وربما الصور من عملية التنفيذ، بدون أي درجات.';
$string['graph_ui_invalidserialisation'] = 'GraphUI: سلسلة خاطئة';
$string['graphhelp'] = '- أنقر نقراً مزدوجاً على منطقة خالية لإنشاء عقدة/حالة جديدة.
- أنقر نقراً مزدوجاً على عقدة موجودة لـ "تأشيرها" كما في حالة القبول لـ Finite State Machines (FSMs).
  النقر المزدوج مرة أخرى لرفع التأشيرة.
- أنقر واسحب لنقل العقدة.
- Alt مع النقر (أو Ctrl Alt مع النقر) واسحب لنقل مخطط بياني فرعي.
- Shift مع النقر داخل عقدة واحدة ثم السحب إلى أخرى لإنشاء رابط بينهما.
- Shift مع النقر على منطقة خالية، السحب إلى عقدة لإنشاء رابط بدء (FSM فقط).
- النقر والسحب للرابط لتغيير منحناه.
- النقر على رابط/عقدة لتغيير النص الخاص به.
- النقر في نص الرابط ثم السحب لنقله.
- طباعة _ متبوعة برقم ستجعل ذلك الرقم منخفضاً عن السطر.
- طباعة \\epsilon ستنشئ رمز epsilon (وكذلك الحال مع \\alpha، \\beta إلخ).
- النقر على رابط/عقدة ثم الضغط على مفتاح Delete لإزالته (أو مفتاح function-delete في بيئة ماك).
- Ctrl+z للتراجع و Ctrl+y أو Ctrl+Shift+z للإعادة.';
$string['graphui_fontsize_descr'] = 'حجم الخط بالنقاط المستعمل لملصقات العقدة والحافة.';
$string['graphui_helpmenutext_descr'] = 'النص الذي إن لم يكن خاليًا سيستبدل نص قائمة المساعدة القياسي المعرف في نصوص لغة CodeRunner.';
$string['graphui_isdirected_descr'] = 'صواب إذا كانت الحافات موجهة';
$string['graphui_isfsm_descr'] = 'صواب إذا كان الرسم البياني يمثل، آلات الحالة المحدودة، في تلك الحالة يمكنه أن يضم حافة قادمة من العدم (حافة البدء) ويمكنه أن يمتلك عقد \'القبول\'.';
$string['graphui_lockedgelabels_descr'] = 'صواب لمنع المستخدم من تحرير ملصقات الحافة. هذا أيضًا يمنع أي حافات أخرى من امتلاك ملصقات.';
$string['graphui_lockedgepositions_descr'] = 'إذا كان صائبًا، سيمنع المستخدم من سحب الحافات لتغيير إنحنائها. قد يكون مفيدًا إذا كان مربع الإجابة محمل مسبقًا برسم بياني على الطالب أن يضع فيه ملحوظات عبر تغيير ملصقات العقد أو الحافات أو عبر إضافة/إزالة الحافات. كذلك يضمن أن الحافات المضافة من قبل الطالب مستقيمة، مثلاً رسم متعدد الأضلاع على مجموعة من النقاط المعطاة. ملاحظة، مع ذلك، لا يزال بالإمكان إضافة الحافات أو حذفها lockedgeset.';
$string['graphui_lockedgeset_descr'] = 'إذا كان صائبًا، سيمنع المستخدم من إضافة الحافات أو حذفها.';
$string['graphui_locknodelabels_descr'] = 'إذا كان صائبًا، سيمنع المستخدم من تحرير ملصقات العُقد. هذا أيضًا يمنع أي عُقد أخرى أن تكون لها ملصقات غير خالية';
$string['graphui_locknodepositions_descr'] = 'إذا كانت صوابًا، تمنع المستخدم من نقل العقد. يكون هذا مفيدًا عندما يكون مربع الإجابة مُحمّلًا مسبقًا برسم بياني يتعين على الطالب التعليق عليه بتغيير تسميات العقد أو الحواف أو بإضافة/إزالة الحواف. مع ذلك، تجدر الإشارة إلى إمكانية إضافة العقد وحذفها. انظر مجموعة عقد القفل.';
$string['graphui_locknodeset_descr'] = 'إذا كان صائبًا، سيمنع المستخدم من إضافة العُقد أو حذفها أو تبديل نوعها من/إلى القابلين';
$string['graphui_noderadius_descr'] = 'نصف قطر العُقدة بالبكسل';
$string['graphui_textoffset_descr'] = 'الإزاحة بالبكسل لملصق الرابط عن رابطه (مهمل - استعمل السحب بدلاً عنه).';
$string['hidden'] = 'مخفي';
$string['hidecheck'] = 'إخفاء الفحص';
$string['hidedetails'] = 'إخفاء التفاصيل';
$string['hidedifferences'] = 'إخفاء الفوارق';
$string['hiderestiffail'] = 'إخفاء الباقي عند الفشل';
$string['hoisttemplateparams'] = 'عوامل مظهر Hoist';
$string['howtogetmore'] = 'لمزيد من المعلومات التفصيلية، إحفظ السؤال مع إزالة التأشير من \'التحقق عند الحفظ\' ثم إفحصه يدوياً';
$string['htmlui_enable_in_editor_descr'] = 'إذا كان صوابًا، استعمل واجهة المستخدم لعرض نموذج الإجابة والتحميل المسبق للإجابة من ضمن نموذج تحرير السؤال، بدلاً عن النسخة المسلسلة. إجعله خطأ إذا كنت تستعمل Twig في حقل HTML المصدري.';
$string['htmlui_html_src_descr'] = 'يحدد مصدر ترميز HTML. ينبغي أن يكون إما \'globalextra\' أو \'prototypeextra\'.';
$string['htmlui_sync_interval_secs_descr'] = 'المهلة الزمنية بالثواني ما بين طلبات المزامنة لمحتويات واجهة المستخدم عودًا إلى إجابة السؤال. 0 لإيقاف هذا النوع من المزامنة.';
$string['htmluiloadfail'] = 'فشل تشغيل ملحق واجهة المستخدم بلغة HTML. المرجح أن سلسلة حالة JSON غير صالحة.';
$string['ideone_pass'] = 'كلمة مرور مخدم Ideone';
$string['ideone_pass_desc'] = 'كلمة المرور التي تُستعمل عند الاتصال بمخدم مهمل من Ideone (إذا كان sandbox لـ ideone مُمَكَّناً)';
$string['ideone_user'] = 'مستخدم مخدم Ideone';
$string['ideone_user_desc'] = 'اسم الدخول الذي يُستعمل عند الاتصال بمخدم مهمل من Ideone (إذا كان sandbox لـ ideone مُمَكَّناً)';
$string['illegalformat'] = 'تنسيق خاطئ ({$a->format}) في columnformats';
$string['illegaluiparamname'] = 'ما يأتي ليست معاملات صالحة لـ {$a->uiname} عند واجهة المستخدم:';
$string['info_unavailable'] = 'معلومات نوع السؤال غير متاحة بالنسبة إلى الأسئلة المخصصة.';
$string['inputcolhdr'] = 'أدخل';
$string['insufficientattachments'] = 'عدد المرفقات غير كافٍ، يتطلب {$a}.';
$string['is_prototype'] = 'استعمله بمثابة نوع أولي';
$string['iscombinatortemplate'] = 'هو مُدمِج';
$string['jobe_apikey'] = 'مفتاح واجهة برمجة التطبيق لـ Jobe';
$string['jobe_apikey_desc'] = 'مفتاح واجهة برمجة التطبيق المزمع تضمينه في كل طلبات REST الموجهة إلى مخدم Jobe (إذا تطلب الأمر). أقصاه 40 حرف. أترك فارغًا لإسقاط مفتاح واجهة برمجة التطبيق من الطلبات';
$string['jobe_canterbury_html'] = '<p style=\'color:gray; font-style:italic; font-size:smaller\'>يشتغل في مخدم جامعة Canterbury\'s Jobe.</p>';
$string['jobe_host'] = 'مخدم Jobe';
$string['jobe_host_desc'] = 'اسم المضيف لمخدم Jobe بالإضافة إلى رقم المنفذ إذا كان مختلفًا عن المنفذ 80، على سبيل المثال: jobe.somewhere.edu:4010. يتم الحصول على عنوان الرابط لطلب Jobe افتراضيًا بإضافة بادئة http إلى هذه السلسلة. وإلحاق /jobe/index.php/restapi/<REST_METHOD>. بإمكانك أيضًا تحديد البروتوكول https:// في مقدمة اسم المضيف (مثل https://jobe.somewhere.edu) إذا كان مخدم Jobe موضوعًا خلف وكيل عكسي يعمل بمثابة منصة SSL. من الممكن وضع مخدمات Jobe متعددة عبر الفصل فيما بينها بفارزة منقوطة إنجليزية من أجل التعامل مع الأحمال العالية، حيث سيتم اختيار أي منها عشوائيًا.';
$string['jobe_host_ws'] = 'مخدم Jobe لاستعماله مع خدمات الويب';
$string['jobe_host_ws_desc'] = 'ستستعمل خدمة ويب صندوق الرمل أي ما هو مُهيأة للغة المُحددة. يكون فرضيًا في أغلب الأحيان مخدم Jobe، ويتم استعمال مخدم Jobe بعينه عبر تهيئة ذلك عبر واجهة المشرف (أعلاه).
مع ذلك، لضمان أفضل أمان لخدمة الويب، يُفضل استعمال مخدم Jobe بديل، يتم ضبطه من خلال هذا الحقل. من الممكن وضع مخدمات Jobe متعددة عبر الفصل فيما بينها بفارزة منقوطة إنجليزية من أجل التعامل مع الأحمال العالية، حيث سيتم اختيار أي منها عشوائيًا. أتركه فارغًا لاستعمال الافتراضي';
$string['jobe_warning_html'] = '<p style=\'background-color:yellow\'>مشغل باستعمال مخدم Jobe لجامعة Canterbury\'s. هذا من أجل التجريب الأولي فقط. يرجى تهيئة مخدم Jobe الخاص بك في أقرب وقت ممكن. أنظر <a href=\'https://github.com/trampgeek/moodle-qtype_coderunner/blob/master/Readme.md#sandbox-configuration\' target=\'_blank\'>هنا</a>.</p>';
$string['language'] = 'لغة Sandbox';
$string['languages'] = 'اللغات';
$string['languages_help'] = 'لغة صندوق الرمل هي لغة الحاسوب المستعملة لتشغيل التسليم. عادةً، لا يتطلب هذا تعديلًا عن القيمة الموجودة في القالب الرئيسي؛ لذا، يمكنك تعديلها على مسؤوليتك الخاصة.

لغة Ace هي اللغة التي يستخدمها محرر النصوص البرمجية Ace (إن تم تمكينها) لإجابة الطالب.

افتراضيًا، هذه هي نفس لغة صندوق الرمل؛ أدخل قيمة مختلفة هنا فقط إذا كانت لغة القالب مختلفة عن اللغة التي يُتوقع من الطالب كتابتها (على سبيل المثال، إذا استُخدم قالب بايثون لمعالجة مسبقة لبرنامج C الخاص بالطالب ثم تنفيذه في عملية فرعية).

يتم تمكين الأسئلة متعددة اللغات، أي الأسئلة التي يمكن للطلاب الإجابة عليها بأكثر من لغة، عن طريق ضبط لغة Ace على قائمة لغات مفصولة بفواصل. بعد ذلك، تظهر للطلاب قائمة منسدلة لاختيار اللغة التي ستُكتب بها إجابتهم. إذا أُضيفت علامة النجمة (\'\\*\') إلى إحدى اللغات تحديدًا، فسيتم اختيار تلك اللغة كلغة افتراضية، والتي تُحدد كحالة مبدئية للقائمة المنسدلة. على سبيل المثال، قيمة لغة Ace "C,C,Java\\*,Python3" ستسمح للطالب بالتقديم بلغات C,C,Java, أو Python3، ولكن القائمة المنسدلة ستعرض في البداية لغة Java، وهي اللغة الافتراضية. إذا لم يتم تحديد أي لغة افتراضية، فستكون الحالة المبدئية للقائمة المنسدلة فارغة، ويجب على الطالب اختيار لغة.

تتطلب الأسئلة متعددة اللغات قالبًا خاصًا يستعمل متغير القالب {{ANSWER\\_LANGUAGE}} للتحكم في كيفية تنفيذ النص البرمجي للطالب. راجع نموذج نوع السؤال متعدد اللغات المدمج. يتم تعريف متغير {{ANSWER\\_LANGUAGE}}.
<i>فقط</i> للأسئلة متعددة اللغات.

إذا رغب المؤلف في تقديم إجابة نموذجية لسؤال متعدد اللغات، فيجب عليه كتابتها باللغة الافتراضية، إذا تم تحديدها، أو أول اللغات المسموح بها بخلاف ذلك.';
$string['languageselectlabel'] = 'اللغة';
$string['legacyuiparams'] = 'عوامل واجهة المستخدم لم يعد بالإمكان تعريفها ضمن حقل عوامل القالب. يرجى نقل ما يأتي إلى حقل عوامل واجهة المستخدم كبديل:';
$string['legacyuiparams2'] = 'عوامل واجهة المستخدم لم يعد بالإمكان تعريفها ضمن حقل عوامل القالب. يرجى نقل ما يأتي إلى حقل عوامل واجهة المستخدم كبديل، مع إزالة البادئة  \'{$a->uiname}_\':';
$string['listprototypeduplicates'] = 'مُعرَّف السؤال: {$a->id} <ul><li>الاسم: {$a->name}</li><li>الصنف: {$a->category}</li></ul>';
$string['loadprototypeerror'] = 'تم إرجاع إلى نوع السؤال: \'{$a->oldtype}\' <br>تعذر تحميل نوع السؤال \'{$a->crtype}\' طالما أن النوع الأولي ليس فريدًا في الأسئلة الآتية:</p>{$a->outputstring}';
$string['mark'] = 'الدرجة';
$string['marking'] = 'تعيين الدرجات';
$string['markinggroup'] = 'منح الدرجات';
$string['markinggroup_help'] = 'إذا تم تحديد خيار \'الكل أو لا شيء\'، فيجب استيفاء كل حالات الاختبار للحصول على أي درجات. وإلا، تُحسب الدرجة بجمع درجات كل حالات الاختبار الناجحة، والتعبير عنها ككسر من أقصى درجة ممكنة.
لا يمكن تحديد درجات كل حالة اختبار إلا إذا كان خيار \'الكل أو لا شيء\' غير محدد. عند استعمال مُقيِّم قوالب يمنح درجات جزئية لحالات الاختبار، تنبغي إعادةً إلغاء تحديد خيار \'الكل أو لا شيء\'.

نظام الغرامات الإلزامي هو قائمة غرامات مفصولة بفواصل (كل منها نسبة مئوية) تُطبق على التسليمات المتتالية. هذه الغرامات مطلقة وليست تراكمية. في حالة خاصة، يمكن أن تكون الغرامة الأخيرة "..." بمعنى "تمديد الغرامتين السابقتين كمتتالية حسابية حتى 100". على سبيل المثال،
<code>0,5,10,30,...</code> تعادل <code>0,5,10,30,50,70,90,100</code>.
إذا تجاوز عدد التسليمات عدد الغرامات المحددة، فسيتم استعمال آخر قيمة.
يمكن استعمال المسافات بدلاً من الفوارز كفاصل.

يمكن لمشرف النظام تعيين نظام الغرامات الافتراضي على مستوى الموقع باستعمال:
إدارة الموقع > الملاحق > أنواع الأسئلة > CodeRunner.

اضبط نظام الغرامات على \'0\' لضمان عدم وجود أي عقوبات على كل المشاركات.

يتم تجاهل نظام الغرامات ولا تُطبق أي غرامة في حال تشغيل الاختبار باستعمال سلوك \'المتكيف (بدون غرامات)\'.';
$string['maxfilesize'] = 'أقصى حجم ملفات مسموح به (بالبايت)';
$string['maxfilesize_help'] = 'إختر أقصى حجم للملفات المرفوعة (بالبايت). السماح برفع ملفات كبيرة الحجم مع صفوف كبيرة قد يكون له تأثير واضح على الأداء وعلى مساحة الخزن في كل من مخدم مودل ومخدم Jobe.';
$string['memorylimit'] = 'حد الذاكرة (ميغا بايت)';
$string['missinganswers'] = 'إجابات مفقودة';
$string['missingorbadfraction'] = 'كسر خاطئ أو مفقود في الناتج من مقيم القالب. الناتج كان: {$a->output}';
$string['missingoutput'] = 'ينبغي عليك توفير المخرجات المتوقعة من الحالة الاختبارية هذه.';
$string['missingprototype'] = 'تم تعريف هذا السؤال على أنه من نوع \'{$a->crtype}\'، ولكن النوع الأولي غير موجود، أو غير متاح في هذا السياق. يُرجى إلغاء الأمر ومحاولة (إعادة) تثبيت النوع الأولي.
لا تُجرِ التعديل إلا إذا كنتَ على دراية بما تفعله!';
$string['missingprototypes'] = 'أنواع أولية مفقودة';
$string['missingprototypewhenrunning'] = 'سؤال ناقص (النوع الأولي مفقود أو مكرر \'{$a->crtype}\'). لا يمكن تشغيله.';
$string['missinguiparams'] = 'عوامل واجهة المستخدم الآتية مطلوبة ولكن لم يتم تحديدها:';
$string['morehidden'] = 'بعض حالات الفحص المخفية فشلت أيضاً.';
$string['multipledefaults'] = 'غالباً، يمكن اختيار لغة واحدة بمثابة اللغة الافتراضية';
$string['multipleprototypes'] = 'تم العثور على أنواع أولية متعددة لـ \'{$a->crtype}\'';
$string['mustrequirefewer'] = 'لا يمكنك أن تطلب مرفقات أكثر مما تسمح به.';
$string['nearequalitygrader'] = 'مطابقة قريبة من المساواة';
$string['negativeorzeromark'] = 'الدرجة ينبغي أن تكون أكبر من الصفر';
$string['nodetailsavailable'] = 'إختر نوع السؤال لمعاينة تفاصيل المساعدة.';
$string['noerrorsallowed'] = 'برمجتك ينبغي أن تجتاز كل الفحوص لتحصل على أي درجة. حاول مجدداً';
$string['nolanguage'] = 'يرجى تحديد اللغة أولاً';
$string['nonnumericmark'] = 'درجة لا رقمية';
$string['nooutput'] = '< لا مخرجات! >';
$string['noqtype'] = 'لم يتم إختيار نوع السؤال';
$string['nosampleanswer'] = 'لا توجد إجابة نموذجية';
$string['nouiparameters'] = 'إن {$a->uiname} لواجهة المستخدم لا يأخذ أي عوامل.';
$string['options'] = 'الخيارات';
$string['ordering'] = 'الترتيب';
$string['outputdisplayarea_invalid_json'] = 'خطأعند تحليل JSON. المخرجات من الغلاف:';
$string['outputdisplayarea_invalid_mode'] = 'وضعية عرض المخرجات خاطئة:';
$string['outputdisplayarea_missing_image_extension'] = 'يتعذر عرض الصورة، قم بتضمين إمتداد الملف في اسمه:';
$string['outputdisplayarea_missing_json_fields'] = 'المخرجات التي تعرض JSON تنقصها حقول مطلوبة:';
$string['overloadoninit'] = 'الحمل الزائد على مخدم صندوق الرمل يحول دون الشروع بالسؤال';
$string['pass'] = 'ناجح';
$string['passes'] = 'ينجح';
$string['penaltyregime'] = '(نظام الغرامة: {$a} %)';
$string['penaltyregimelabel'] = 'نظام الغرامة:';
$string['pluginname'] = 'CodeRunner';
$string['pluginname_help'] = 'استعمل مربع الاختيار \'نوع السؤال\' لاختيار لغة الحاسوب ونوع السؤال اللذين سيُستعملان لتشغيل طلب الطالب.

حدد المشكلة التي يجب على الطالب كتابة برمجتها، ثم حدد مجموعة الاختبارات التي سيتم إجراؤها على طلب الطالب.';
$string['pluginname_link'] = 'question/type/coderunner';
$string['pluginnameadding'] = 'تجري إضافة سؤال CodeRunner';
$string['pluginnameediting'] = 'يجري تحرير سؤال CodeRunner';
$string['pluginnamesummary'] = 'CodeRunner: يقوم بتنفيذ برمجة الطالب المقدمة عبر sandbox';
$string['precheck'] = 'الفحص الأولي';
$string['precheck_all'] = 'الكل';
$string['precheck_disabled'] = 'مُعطَّل';
$string['precheck_empty'] = 'فارغ';
$string['precheck_examples'] = 'الأمثلة';
$string['precheck_help'] = 'حدّد الأزرار المتاحة للطلاب لإرسال إجاباتهم. عادةً ما يظهر زر "فحص" على الأقل، ولكن يمكن إخفاؤه (مثلاً للاستعمال في سياقات الإفادات المؤجلة) إذا كان الخيار <i>إخفاء الفحص</i> مؤشرًا.

إذا تم تمكين الفحص المسبق، فسيكون لدى الطلاب زر إضافي على يسار زر الفحص المعتاد لمنحهم فرصة خالية من الغرامات للتحقق من النص البرمجي الخاص بهم مقابل مجموعة فرعية من حالات اختبار الأسئلة. بعدها<ul>
<li>إذا تم تحديد \'خالٍ\' سيتم إجراء تشغيل واحد مع قالب لكل اختبار باستعمال حالة اختبار تكون فيها كل الحقول (رمز الاختبار، stdin، والمتوقع، إلخ) عبارة عن سلسلة فارغة. يُعتبر الناتج غير الفارغ فشلاً في الاختبار المسبق. يُرجى توخي الحذر: بعض أنواع الأسئلة لا تتعامل مع هذا بشكل صحيح، مثل أسئلة كتابة برنامج التي تُنتج ناتجًا.
</li><li>إذا تم تحديد \'أمثلة\'، فسيتم اختبار النص البرمجي إزاء كل الاختبارات التي تم فيها تأشير \'استعمله_كمثال\'.
</li><li>إذا تم تأشير \'محدد\'، فسيتم إضافة عنصر واجهة مستخدم إضافي إلى كل حالة اختبار للسماح للمؤلف باختيار مجموعة فرعية محددة من الاختبارات.
</li><li>إذا تم تأشير \'الكل\'، فسيتم تشغيل كل حالات الاختبار (على الرغم من أن سلوكها قد يختلف عن الفحص العادي، إذا اختار النص البرمجي للقالب ذلك).
</ul>
يمكن للقالب التحقق مما إذا كان التشغيل هو تشغيل فحص مسبق أم لا باستعمال العامل Twig {{ IS_PRECHECK }}، والتي تكون "1" أثناء تشغيل الفحص المسبق و"0" في غير ذلك.';
$string['precheck_only'] = 'فحص مسبق فقط';
$string['precheck_selected'] = 'مختارة';
$string['precheckingemptyset'] = 'يجري الفحص المسبق للأمثلة، ولكن لا يوجد أي منها!';
$string['privacy:metadata'] = 'إن ملحق نوع السؤال، CodeRunner لا يخزن أي بيانات شخصية.';
$string['proceed_at_own_risk'] = 'بصدد تحرير نوع أولي مضمن؟! تابع على مسؤوليتك الخاصة!';
$string['prototypeQ'] = 'هل هو نوع أولي؟';
$string['prototype_duplicate_alert'] = 'تكرار النوع الأولي: تكرار {$a} من الأنواع الأولية الموجودة. يمكن فقط تحميل واحد منها.';
$string['prototype_error'] = '*** فشل تحميل النوع الأولي. لا تخزن هذا! ***';
$string['prototype_load_failure'] = 'خطأ عند تحميل النوع الأولي:';
$string['prototype_missing_alert'] = 'نوع أولي مفقود: تأكد من وجود {$a} في هذا السياق.';
$string['prototypecontrols'] = 'إنشاء النوع الأولي';
$string['prototypecontrols_help'] = 'إذا كانت قيمة \'هو نوع أولي\' صحيحة، يصبح هذا السؤال نوعًا أوليًا للأسئلة الأخرى.

بعد الحفظ، سيظهر اسم نوع السؤال المحدد في القائمة المنسدلة لأنواع الأسئلة. سترث الأسئلة الجديدة المستندة إلى هذا النوع افتراضيًا كل سمات التخصيص المحددة لهذا السؤال. ستؤثر التغييرات اللاحقة على هذا السؤال على كل الأسئلة المشتقة ما لم تكن هي نفسها مخصصة، مما يؤدي إلى قطع الصلة.

تحدث وراثة النموذج الأولي على مستوى واحد فقط، لذا فإن هذا السؤال، عند حفظه كنموذج أولي، يفقد اتصاله بنوعه الأولي الأصلي، ليصير نوعًا أوليًا جديدًا بذاته.

يرجى العلم بأنه عند تصدير الأسئلة المشتقة، ينبغي عليك التأكد من تضمين هذا السؤال أيضًا في عملية التصدير، وإلا فسيكون السؤال المشتق يتيمًا عند استيراده إلى نظام آخر. كما أنك مسؤول عن تتبع الأسئلة التي تستعملها كأنواع أولية. يُنصح بشدة بإعادة تسمية السؤال إلى شيء مثل \'نوع_أولي_لنوع_سؤالي_الجديد\' لتسهيل الصيانة اللاحقة.';
$string['prototypeexists'] = 'هذا نوع أولي؛ يتعذر تغيير نوع السؤال.';
$string['prototypeextra'] = 'النوع الأولي الإضافي';
$string['prototypeextra_help'] = 'حقل نصي للاستعمال العام من قِبل مؤلفي أنواع الأسئلة، مثل الإضافات العامة، ولكنه جزء من حالة النوع الأولي. متاح لمؤلف القالب بمثابة {{ QUESTION.prototypeextra }}.';
$string['prototypeusage'] = 'استعمال النوع الأولي لسؤال CodeRunner للمساق {$a}';
$string['prototypeusageindex'] = 'المقررات الدراسية المتاحة';
$string['purgeallcachekeysbutton'] = 'تطهير كل المفاتيح';
$string['purgeoldcachekeysbutton'] = 'تطهير المفاتيح القديمة فقط';
$string['purgingallkeysmessage'] = 'يجري تطهير كل المفاتيح في المساق، بغض النظر عن وقت الاستبقاء (TTL).';
$string['purgingoldkeysmessage'] = 'يجري تطهير المفاتيح القديمة في المساق فقط، بناءً على وقت الاستبقاء. TTL = {$a->seconds} من الثواني (={$a->days} من الأيام)';
$string['qWrongBehaviour'] = 'يرجى استعمال السلوك المتكيف لكل أسئلة CodeRunner، وإلا فقد يكون هناك انخفاض كبير في الأداء. على سبيل المثال، يجب إعادة تقييم كل الأسئلة في الصفحة عند إعادة عرضها.';
$string['qtype_c_function'] = '<p>نوع من الأسئلة لكتابة دالة في لغة C. من المتوقع أن تكون إجابة الطالب دالة C كاملة، ولكن يمكن اختياريًا أن تسبقها نصود برمجية بلغة C أخرى مستقلة، مثل توجيهات المعالج المسبق ودوال الدعم.</p>
<p>عادةً ما يستدعي النص البرمجي الاختباري لهذه الأسئلة دالة الطالب مع بعض وسيطات الاختبار، ويطبع النتيجة، مثل
<pre>printf("%d\\n", someIntFunction(blah1, blah2))</pre>

حقل <i>المتوقع</i> لحالة الاختبار هو الناتج المتوقع من الاختبار.</p>
<p>
في حال عدم وجود مدخلات قياسية لأي من حالات الاختبار، يتم إنشاء برنامج اختبار واحد، يتكون من:</p>
<ol>
<li>يتضمن المعيار التالي: stdlib.h، ctype.h، string.h، stdbool.h، math.h</li>
<li>إجابة الطالب.</li>
<li>سلسلة من الكتل محاطة بأقواس لكل حالة اختبار من حالات الاختبار المعطاة.
تحتوي كل كتلة على النص البرمجي الاختباري لحالة الاختبار فقط. كما تُضاف عبارة <i>printf</i> بين كتل النص البرمجي لطباعة فاصل خاص يُستعمل لتقسيم المخرجات إلى مخرجات حالة اختبار فردية.</li>
</ol>
<p>ومع ذلك، إذا احتوت أي من حالات الاختبار على مدخلات قياسية غير فارغة، فسيتم تشغيل برامج اختبار متعددة، برنامج واحد لكل حالة اختبار.
</p><p>يتم تجاهل الحقل <i>الإضافي</i> لحالة الاختبار.</p>';
$string['qtype_c_program'] = '<p>يُستعمل هذا في أسئلة كتابة البرامج بلغة C، حيث لا يوجد نص برمجي لكل حالة اختبار، وتستعمل الاختبارات المختلفة بيانات إدخال قياسية (stdin) مختلفة. من المتوقع أن تكون إجابة الطالب عبارة عن برنامج كامل قابل للتنفيذ، يتم تشغيله كما هو، دون تعديل بواسطة CodeRunner، مرة واحدة لكل حالة اختبار. يتم تجاهل قيم النص البرمجي الاختباري والحقول الإضافية لكل حالة اختبار.</p><p>إذا كنت بحاجة إلى تعيين معاملات رابط أو تجميع خاصة للسؤال، يمكنك تخصيصه (انقر على خانة الاختيار "تخصيص")، ثم افتح مقطع <i>التخصيص المتقدم</i>، وأدخل القيم المناسبة في حقل <i>صندوق الرمل والعوامل</i>. على سبيل المثال<pre>
{"linkargs":["-lm"]</pre> للربط بمكتبة الرياضيات.';
$string['qtype_cpp_function'] = '<p>نوع من الأسئلة لأسئلة كتابة دالة في لغة C++.

من المتوقع أن تكون إجابة الطالب دالة C++ كاملة، ولكن يمكن اختياريًا أن تسبقها نصوص برمجية بلغة C++ أخرى مستقلة، مثل توجيهات المعالج المسبق ودوال الدعم.</p>
<p>في كل حالة اختبار، عادةً ما يستدعي النص البرمجي الاختباري لهذه الأسئلة دالة الطالب مع بعض وسيطات الاختبار ويطبع النتيجة، مثل
<pre>cout << someIntFunction(blah1, blah2))</pre>

حقل <i>المتوقع</i> في حالة الاختبار هو الناتج المتوقع من الاختبار.

<p>
إذا لم يكن هناك مُدخل قياسي مُقدم لأيٍّ من حالات الاختبار، فسيتم إنشاء برنامج اختبار واحد، يتكون من:</p>
<ol>
<li>يتضمن #المعيار التالي: iostream، fstream، string، math، vector، و algorithm</li>
<li><code>using namespace std;</code></li>
<li>إجابة الطالب</li>
<li>سلسلة من الكتل مُحاطة بأقواس لكل حالة اختبار مُعطاة.
تتكون كل كتلة من الحقل الإضافي (عادةً ما يكون فارغًا) لحالة الاختبار، متبوعًا بالنص البرمجي الاختباري. كما تُضاف عبارة <i>printf</i> بين كتل التعليمات البرمجية لطباعة فاصل خاص يُستخدم لتقسيم المُخرجات إلى مُخرجات حالة اختبار فردية.</li>
</ol>
<p>ومع ذلك، إذا كانت أيٌّ من حالات الاختبار تحتوي على مُدخل قياسي غير فارغ، فسيتم تشغيل برامج اختبار متعددة، برنامج واحد لكل حالة اختبار.
</p>';
$string['qtype_cpp_program'] = '<p>يُستعمل هذا في أسئلة كتابة برنامج بلغة C++، حيث لا يوجد رمز لكل حالة اختبار، وتستعمل الاختبارات المختلفة بيانات إدخال قياسية (stdin) مختلفة. من المتوقع أن تكون إجابة الطالب عبارة عن برنامج كامل قابل للتنفيذ، يُشغّل كما هو، دون تعديل بواسطة CodeRunner، مرة واحدة لكل حالة اختبار. يتم تجاهل قيم رمز الاختبار والحقول الإضافية لكل حالة اختبار.</p>';
$string['qtype_directed_graph'] = '<p>نوع من أسئلة بايثون 3 يطلب من الطالب رسم رسم بياني موجه لتلبية بعض المواصفات. يتعين على مؤلف السؤال كتابة شيفرة بايثون 3 للتحقق من الرسم البياني الناتج.</p><p>لاحظ أنه ليس من الضروري استعمال هذا النوع من الأسئلة للرسوم البيانية الموجهة، حيث تُوفر هذه الوظيفة بشكل أساسي من خلال الملحق GraphUI. إذا لم تُلبِّ معالجة الرسم البياني المُسبقة التي يُجريها هذا النوع من الأسئلة احتياجاتك، يمكنك بدلاً من ذلك استعمال سؤال بايثون 3 عادي (أو أي لغة أخرى)، وتعيين واجهة المستخدم إلى GraphUI، وتحليل نسخة الرسم البياني المُسلسل JSON (متغير Twig STUDENT_ANSWER) بنفسك. مع ذلك، يُقدم هذا النوع من الأسئلة مثالاً على كيفية استعمال الملحق GraphUI. أنقر على <i>تخصيص</i> لعرض رمز القالب.</p>
<p>تطلب المواصفات من الطالب رسم رسم بياني موجه لتلبية متطلبات معينة. قد يكون، على سبيل المثال، آلة DFA (أتمتة الحالة المحدودة الحتمية) أو آلة خراطة. سيقوم رمز حالة الاختبار و/أو الرمز الإضافي بتحليل الرسم البياني وطباعة رسالة للطالب، مثل "موافق" إذا كان الرسم البياني صحيحًا، أو رسالة خطأ مفيدة في حال عدم صحته.</p>
<p>يحلل قالب هذا السؤال الرسم البياني المتسلسل بتنسيق JSON، ويستخرج طوبولوجيته على شكل <i>رسم بياني</i> في قاموس مجاور. هذا المتغير متاح للاختبار أو الرمز الإضافي في حالة الاختبار. المفاتيح في القاموس هي أسماء العقد، إن وُجدت، أو تسميات تعريف عقد عشوائية من النموذج #1، #2، إلخ. القيم في القاموس هي قوائم من الحواف الصادرة، مرتبة حسب اسم أو مُعرّف عقدة الجوار، حيث تكون كل حافة مجموعة (neighbourId، edgeLabel). يكون كل مُدخل في قائمة الجوار على هيئة (nodeNameOrId، neighbors)، حيث أن neighbors عبارة عن قائمة من المجموعات (neighbourNodeNameOrId، edgeLabel). إذا أُعطيت للعقد أسماء، تُستعمل هذه الأسماء كمُعرّفات، وإلا، تُستعمل الأسماء #1، #2، إلخ. يتم ترتيب قائمة الجوار وقائمة الجوار حسب اسم العقدة أو مُعرّفها.

القالب مُركّب: يتم تنفيذ كلٍّ من <i>رمز الاختبار</i> و<i>الرمز الإضافي</i> لكل حالة اختبار. </p><p>على سبيل المثال، إذا كانت المواصفات مجرد "رسم رسم بياني مُوجّه بعقدتين مُسمّيتين A وB، مع حافة من A إلى B"، فقد تكون حالة الاختبار المناسبة (وإن كانت ناتج خطأ غير مُفيد) هي:
</p><pre>
if set(graph.keys()) == {\'A\', \'B\'} and len(graph[\'A\']) == 1 and len(graph[\'B\']) == 0 and graph[\'A\'][0][0] == \'B\':
     print(\'OK\')
else:
     print(\'Nope\')
</pre>
<p>بدلاً من ذلك، يمكن استعمال مجموعة من حالات الاختبار، كل منها يتحقق من أحد جوانب المواصفات. على سبيل المثال، قد تطبع حالة الاختبار الأولى المفاتيح المُرتبة، متوقعةً ظهور \'A\'، \'B. قد تطبع حالة الاختبار الثانية الحواف الصادرة من العقدة \'A\'، وهكذا.</p>';
$string['qtype_java_class'] = 'سؤال جافا لكتابة فئة، حيث يُرسل الطالب فئة كاملة كإجابة. عادةً ما يُنشئ كل اختبار كائنًا من الفئة المُحددة ويُجري عليه اختبارًا واحدًا أو أكثر. وهو ليس من نوع أسئلة التجميع، ما يعني أن كل حالة اختبار تُشغّل كبرنامج منفصل.
</p><p>يتكون البرنامج المُولّد لكل حالة اختبار من إجابة الطالب، مع إزالة السمة <i>public</i> إن وُجدت. يتبع تعريف الفئة (الذي أصبح الآن محليًا) فئة <i>__Tester__&nbsp;&nbsp;عام يحتوي على دالة <i>main</i> تُنشئ فئة Tester وتستدعي دالة <i>runTests</i> الخاصة به. تحتوي دالة <i>runTests</i> ببساطة على النص البرمجي الاختباري. راجع القالب للتوضيح. </p><p>تجدر الإشارة إلى أن الخوارزمية المستعملة لإزالة السمة العامة من الفئة التي يُقدّمها الطالب بسيطة؛ فهي لا تعمل إلا إذا وُجدت الكلمتان <i>public class</i> مرة واحدة فقط في النص البرمجي للطالب، مفصولتين بمسافة واحدة.</p>
<p>يتم تجاهل الحقل الإضافي لحالة الاختبار.</p>
<p>هذا النوع من الأسئلة غير فعال إذا كان هناك العديد من الاختبارات، حيث تُرسل مهمة تجميع وتنفيذ منفصلة إلى بيئة الاختبار لكل حالة اختبار. يمكن حل هذه المشكلة بكتابة نوع سؤال بنمط المُجمّع. راجع توثيقات برنامج تشغيل النص البرمجي (coderunner.org.nz) لمزيد من المعلومات.</p>';
$string['qtype_java_method'] = 'يُستعمل في أسئلة كتابة طريقة في لغة جافا، حيث يُطلب من الطالب كتابة طريقة تُعدّ في الأساس دالة مستقلة. عادةً ما يكون الاختبار الذي يُقدّمه المؤلف سطرًا أو سطرين من التعليمات البرمجية، والتي (على ما يبدو) تستدعي الطريقة التي يُقدّمها الطالب، كما هو الحال في لغة C. في الأساس، يُنشئ القالب فئة رئيسية تحتوي على الطريقة التي يُقدّمها الطالب (وأي طرق دعم أخرى، إذا اختار الطالب كتابتها) بالإضافة إلى طريقة "runTests" التي تُغلّف حالة (حالات) الاختبار. تُنشئ الدالة الرئيسية للفئة مثيلًا من Main وتستدعي طريقة runTests الخاصة بها. راجع النص البرمجي للقالب لمزيد من التفاصيل.';
$string['qtype_java_program'] = '<p>سؤال كتابة برنامج بلغة جافا، حيث يُرسل الطالب برنامجًا كاملاً كإجابة. يُجمّع البرنامج ويُنفّذ لكل حالة اختبار. لا يوجد رمز اختبار، بل بيانات اختبار stdin فقط، مع العلم أنه لا يتم التحقق من ذلك فعليًا: "تحذير المشتري". كما يتم تجاهل الحقول الإضافية لحالات الاختبار.</p>
<p>يصير هذا النوع من الأسئلة غير فعال للغاية إذا كان هناك العديد من حالات الاختبار، لأن كل حالة تتطلب دورة تجميع وتنفيذ كاملة في مخدم Jobe. من الممكن دمج كل الاختبارات في مهمة بايثون واحدة تُرسل إلى مخدم صندوق الرمل وتُجمّع البرنامج مرة واحدة فقط، ثم تُشغّله على كل حالة اختبار.
للاطلاع على تفاصيل هذا النهج، راجع منتدى مُنشئي الأسئلة في
coderunner.org.nz.</p>';
$string['qtype_multilanguage'] = '<p>سؤال بأسلوب "كتابة برنامج"، حيث يمكن للطالب تقديم إجابة بأي لغة من اللغات المختلفة. لغات C، وC++، وJava، وPython3، وPHP، وJavaScript (nodejs) هي لغات قياسية على مخدمات Jobe، لذا يجب أن تعمل جميعها بشكل مباشر. يسمح نوع السؤال أيضًا باستعمال لغات Perl، وRuby، وGolang، وC#، ولكن هذه اللغات تتطلب تثبيت المُجمِّعات و/أو المُفسِّرات الإضافية المناسبة على Jobe.

على سبيل المثال، استعمل <code>sudo apt-get install mono-mcs</code> لتثبيت مُجمِّع mono C#، mcs.</p>
<p>إذا قدّم مُؤلِّف السؤال إجابة نموذجية، فيمكنه تحديد لغة إجابته بإحدى ثلاث طرق: <ol><li>بإضافة مُعامل قالب مثل <code>{"answer_language": "cpp"</code> لتحديد اللغة المُستعملة.</li>
<li>باستعمال اللغة الافتراضية، إن وُجدت. يُشار إلى اللغات الافتراضية بعلامة نجمية بعد اسم اللغة في حقل "لغة Ace" ضمن لوحة التخصيص المتقدم، إذا كان المؤلف يستعمل سؤالاً مُخصصًا. بخلاف ذلك، لا توجد لغة افتراضية. </li>
<li>باستعمال أول لغة مُدرجة في حقل "لغة Ace" ضمن لوحة التخصيص المتقدم، تكون اللغة الافتراضية هي C.</li></ol></p>
<p>يحتوي مربع إجابة سؤال الطالب على قائمة منسدلة في الأعلى، حيث يجب على الطالب اختيار لغة كتابة إجابته.</p>
<p>يمكن إضافة لغات أخرى، إذا كانت مدعومة على مخدم Jobe، عن طريق إضافة اسم اللغة إلى حقل <i>AceLang</i> في نموذج تعديل السؤال، ثم توسيع القالب (انظر الشكل) للتعامل مع اللغة الجديدة.</p>
<p>يتم تشغيل النص البرمجي المُرسل كما هي لكل حالة اختبار. يتم تجاهل شيفرة الاختبار والحقول الإضافية لكل حالة اختبار.</p>';
$string['qtype_nodejs'] = '<p>نوع سؤال JavaScript، يُشغّل باستعمال nodejs. يبدأ برنامج الاختبار المطلوب تنفيذه بإجابة الطالب. ويتبع ذلك كل نص برمجي من نصوص حالات الاختبار تباعًا، مع طباعة سلسلة فاصلة بينها. ومع ذلك، في حال وجود أي مُدخلات قياسية لأيٍّ من حالات الاختبار، فسيتم إجراء تشغيل اختبار منفصل لكل حالة.</p><p>
في حال وجود خطر حدوث آثار جانبية من حالة اختبار تؤثر على حالات اختبار لاحقة، يُمكنك إضافة مُدخلات قياسية إلى أيٍّ من حالات الاختبار لفرض وضع التشغيل مرة واحدة لكل حالة اختبار.</p>';
$string['qtype_octave_function'] = '<p>نوع سؤال يحدد دالة Octave، والتي يتعين على الطالب تقديمها كاملةً. عادةً ما تستدعي كل حالة اختبار دالة الطالب مع معاملات اختبار، وتطبع النتيجة أو قيمةً مشتقةً منها. في حال عدم وجود مُدخلات قياسية في أيٍّ من الأسئلة، يتكون البرنامج من إجابة الطالب، وعبارة <code>format free</code>، والنص البرمجي الاختباري من كل حالة اختبار، بالإضافة إلى عبارة <i>disp</i> إضافية لطباعة سلسلة فاصلة بين مُخرجات حالة الاختبار.</p><p>في حال وجود أي مُدخلات قياسية، تُشغّل كل حالة اختبار على حدة.</p>';
$string['qtype_pascal_function'] = '<p>نوع سؤال باسكال، حيث يُطلب من الطالب كتابة إجراء أو دالة. يتكون البرنامج المطلوب تشغيله من إجابة الطالب متبوعةً بـ <i>testcode</i> الخاص بـ CodeRunner والمُدرج في <code>begin ... end.</code>.<br>
هذا ليس سؤالًا مُركّبًا، لذا سيتم تشغيل مهمة منفصلة لكل حالة اختبار.</p>';
$string['qtype_pascal_program'] = '<p>نوع سؤال باسكال، حيث تكون إجابة الطالب عبارة عن برنامج باسكال كامل. يُجمّع البرنامج ويُشغّل مرة واحدة لكل حالة اختبار، باستعمال المدخلات القياسية المُقدّمة في حالة الاختبار، مع تجاهل حقلي <i>testcode</i> و<i>extra</i>.</p>';
$string['qtype_php'] = '<p>سؤال PHP يكون فيه تسليم الطالب عبارة عن نص برمجي بلغة PHP. في أبسط الحالات، يبدأ النص البرمجي للطالب بـ</p><pre>
&lt;?php
</pre>ولكنه لن يغلق وسم PHP. يمكن معرفة سبب عدم الإغلاق من خلال فحص القالب: يتبع إجابة الطالب جميع النصوص البرمجية الاختبارية حالة الاختبار. إذا كنت ترغب في أن ينتهي النص البرمجي للطالب بإغلاق وسم PHP، فعليك تعديل القالب لإعادة فتح وسم PHP قبل تسلسل الاختبارات.
</p><p>سيكون ناتج كل حالة اختبار، والذي يجب أن يتطابق مع حقل <i>المتوقع</i> لحالة الاختبار، هو ناتج نص برمجي بلغة PHP الخاص بالطالب (بما في ذلك أي محتوى خارج نطاق علامتي &lt;?php...?&gt;) بالإضافة إلى ناتج النص البرمجي الاختباري.</p><p>إفحص كود القالب (بالنقر على <i>تخصيص</i>) لفهم ذلك.</p>';
$string['qtype_python2'] = '<p>نوع سؤال في بايثون 2، يمكنه التعامل مع أسئلة كتابة دالة، أو كتابة فئة، أو كتابة برنامج. لكل حالة اختبار، يُنفَّذ النص البرمجي إجابة الطالب، متبوعًا بالنص البرمجي الاختباري.
على سبيل المثال، إذا طُلب من الطالب كتابة تعريف دالة، فسيتم تنفيذ تعريفه أولًا، متبوعًا بالنص البرمجي الاختباري الذي يُقدِّمه المؤلف، والذي عادةً ما يستدعي الدالة ويطبع النتيجة أو قيمةً مُشتقةً منها.</p>
<p>إذا لم تكن هناك مُدخلات قياسية مُحدَّدة لكل حالات الاختبار، فإن السؤال يُغلِّف كل الاختبارات في عملية تشغيل واحدة، مع طباعة سلسلة فاصلة بين مُخرَجات كل حالة اختبار.
يرجى العلم أن هذا لا يُعادل بالضرورة تشغيل كل حالة اختبار على حدة. على سبيل المثال، إذا كانت هناك أي مُتغيرات عامة مُحدَّدة بواسطة النص البرمجي للطالب، فستحتفظ بقيمها عبر عمليات التشغيل المُتعدِّدة.
إذا كان من المحتمل أن يُشكل هذا مشكلة، فإن أسهل حل بديل هو تحديد أحد حقول الإدخال القياسية لحالة الاختبار كقيمة غير فارغة - وهذا يُجبر CodeRunner على استعمال وضع احتياطي لتشغيل كل حالة اختبار على حدة.</p>';
$string['qtype_python3'] = '<p>نوع سؤال في بايثون 3، يمكنه التعامل مع أسئلة كتابة دالة، أو كتابة فئة، أو كتابة برنامج. لكل حالة اختبار، يُنفَّذ النص البرمجي لإجابة الطالب، متبوعًا بالنص البرمجي الاختباري.
على سبيل المثال، إذا طُلب من الطالب كتابة تعريف دالة، فسيتم تنفيذ تعريفه أولًا، متبوعًا بالنص البرمجي الاختباري الذي يُقدِّمه المؤلف، والذي عادةً ما يستدعي الدالة ويطبع النتيجة أو قيمةً مُشتقةً منها.</p>
<p>إذا لم تكن هناك مُدخلات قياسية مُحدَّدة لكل حالات الاختبار، فإن السؤال يُغلِّف كل الاختبارات في عملية تشغيل واحدة، مع طباعة سلسلة فاصلة بين مُخرَجات كل حالة اختبار.
يرجى العلم أن هذا لا يُعادل بالضرورة تشغيل كل حالة اختبار على حدة. على سبيل المثال، إذا كانت هناك أي مُتغيرات عامة مُحدَّدة بواسطة النص البرمجي الطالب، فستحتفظ بقيمها عبر عمليات التشغيل المُتعدِّدة.
إذا كان من المحتمل أن يُشكل هذا مشكلة، فإن أسهل حل بديل هو تحديد أحد حقول الإدخال القياسية لحالة الاختبار كقيمة غير فارغة - وهذا يُجبر CodeRunner على استعمال وضع احتياطي لتشغيل كل حالة اختبار على حدة.</p>';
$string['qtype_python3_w_input'] = '<p>نوع أسئلة بايثون 3، يمكنه التعامل مع أنواع أسئلة كتابة دالة، أو كتابة فئة، أو كتابة برنامج. يختلف عن نوع أسئلة بايثون 3 الأبسط قليلاً في استبدال دالة الإدخال المعتادة في بايثون 3 بإصدار مخصص يُحاكي المدخلات القياسية إلى المخرجات القياسية أثناء استعمالها. ينتج عن ذلك مخرجات تُحاكي ما يراه الطلاب عند الاختبار باستعمال مدخلات لوحة المفاتيح. يُنصح باستعمال نوع أسئلة <i>python3</i> لأي أسئلة تتضمن استدعاءات لـ <i>input</i> في مساقات البرمجة التمهيدية، حيث من المرجح أن يرتبك الطلاب بسبب عدم تكرار الإدخال القياسي عند أخذه من ملف. </p><p>من العيوب الطفيفة لهذا النوع من الأسئلة مقارنةً بنوع أسئلة <i>python3</i> أن أي رسائل خطأ في النص البرمجي للطالب ستحتوي على أرقام أسطر مربكة، نظرًا لأن دالة الإدخال البديلة تُدرج قبل النص البرمجي للطالب.</p>
<p>في كل حالة اختبار، يتم تنفيذ النص البرمجي لإجابة الطالب متبوعًا بالنص البرمجي الاختباري. على سبيل المثال، إذا طُلب من الطالب كتابة تعريف دالة، فسيتم تنفيذ تعريفه أولاً، متبوعًا بالنص البرمجي الاختباري الذي يقدمه المؤلف، والذي عادةً ما يستدعي الدالة ويطبع النتيجة أو قيمة مشتقة منها.</p>
<p>إذا لم تكن هناك مدخلات قياسية محددة لكل حالات الاختبار، فإن السؤال يُغلّف كل الاختبارات في عملية تشغيل واحدة، مع طباعة سلسلة فاصلة بين كل مُخرَج حالة اختبار.
يرجى العلم أن هذا لا يعني بالضرورة تشغيل كل حالة اختبار على حدة. على سبيل المثال، إذا كانت هناك أي متغيرات عامة محددة بواسطة النص البرمجي للطالب، فستحتفظ بقيمها عبر عمليات التشغيل المتعددة.
إذا كان من المحتمل أن يُمثل هذا مشكلة، فإن أسهل حل بديل هو تحديد أحد حقول الإدخال القياسية لحالة الاختبار ليكون قيمة غير فارغة - وهذا يُجبر CodeRunner على تشغيل كل حالة اختبار على حدة.</p>';
$string['qtype_sql'] = '<p>نوع سؤال SQL، باستعمال sqlite3، يُشغَّل من Python3. ينبغي تنصيب sqlite3 في مخدم Jobe لهذا النوع من الأسئلة.</p>
<p>يُبحث في مجلد العمل عن الملفات ذات الامتداد \'.db\'. إذا كان هناك ملف واحد فقط، فسيتم استعماله كقاعدة بيانات sqlite3 لجميع الاختبارات.
تُصدر ملفات .db المتعددة حاليًا رسالة خطأ؛ ومن الممكن استعمال ملفات قاعدة بيانات مختلفة لكل اختبار، على سبيل المثال بترتيب مُرتَّب.</p>
<p>لكل اختبار، يتم تشغيل أمر sqlite3 النصي بالشكل</p>
<pre>.mode column<br>.headers on<br>&lt;code in extra&gt;<br>&lt;student answer&gt;<br>&lt;testcode&gt;</pre>
<p>تُستعمل نسخة جديدة من ملف قاعدة البيانات لكل حالة اختبار.&nbsp;</p>
<p>يمكن استعمال مُعامل القالب <i>columnwidths</i> لتعيين عرض أعمدة التقرير. افتراضيًا، يُعيِّن sqlite3 عرض كل عمود ليكون الحد الأقصى لثلاثة أرقام: 10، وعرض الرأس، وعرض الصف الأول من البيانات.
سلسلة نصية نموذجية مثل</p><pre><code>{"columnwidths": [10, 50, 10, 5]}
</code></pre>
<p>ستستعمل بدلاً من ذلك عرض الأعمدة 10، 50، 10، و5 للأعمدة الأربعة الأولى.</p>';
$string['qtype_undirected_graph'] = '<p>نوع من أسئلة بايثون 3 يطلب من الطالب رسم رسم بياني غير موجه لتلبية بعض المواصفات. ينبغي على مؤلف السؤال كتابة النص البرمجي بلغة بايثون 3 للتحقق من الرسم البياني الناتج.</p><p>لاحظ أنه ليس من الضروري استعمال هذا النوع من الأسئلة للرسوم البيانية غير الموجهة، حيث تُوفر هذه الوظيفة بشكل أساسي من خلال الملحق GraphUI. إذا لم تُلبِّ معالجة الرسم البياني المُسبقة التي يُجريها هذا النوع من الأسئلة احتياجاتك، يمكنك بدلاً من ذلك استعمال سؤال بايثون 3 عادي (أو أي لغة أخرى)، وتعيين واجهة المستخدم إلى GraphUI، وتحليل النسخة المُسلسلة من الرسم البياني JSON (متغير Twig STUDENT_ANSWER) بنفسك. مع ذلك، يُقدم هذا النوع من الأسئلة مثالاً على كيفية استعمال الملحق GraphUI. أنقر على <i>تخصيص</i> لعرض النص البرمجي للقالب.</p>
<p>تطلب المواصفات من الطالب رسم رسم بياني غير موجه لتلبية متطلبات معينة، مثل تمثيل بياني لمجموعة من المدن المتصلة بطرق ثنائية الاتجاه. سيقوم النص البرمجي لحالة الاختبار و/أو الرمز الإضافي بتحليل الرسم البياني وطباعة رسالة للطالب، مثل "موافق" إذا كان الرسم البياني صحيحًا، أو رسالة خطأ مفيدة في حال عدم صحته.</p>
<p>يحلل قالب هذا السؤال الرسم البياني المتسلسل بتنسيق JSON، ويستخرج طوبولوجيته على شكل <i>رسم بياني</i> لقاموس التجاور. هذا المتغير متاح للاختبار أو النص البرمجي الإضافي في حالة الاختبار. المفاتيح في القاموس هي أسماء العقد، إن وُجدت، أو تسميات تعريف عقد عشوائية من النموذج #1، #2، إلخ. القيم في القاموس هي قوائم من الحواف، مرتبة حسب اسم أو مُعرّف العقدة المجاورة، حيث تكون كل حافة مجموعة (neighbourId، edgeLabel). يكون كل مُدخل في قائمة الجوار من الشكل (nodeNameOrId، neighbors)، حيث أن neighbors عبارة عن قائمة من المجموعات (neighbourNodeNameOrId، edgeLabel). إذا أُعطيت للعقد أسماء، تُستعمل هذه الأسماء كمُعرّفات، وإلا، تُستعمل الأسماء #1، #2، إلخ. يتم ترتيب قائمة الجوار وقائمة الجوار حسب اسم العقدة أو مُعرّفها.

<p>القالب مُركّب: يتم تنفيذ كلٍّ من <i>النص البرمجي الاختباري</i> و<i>النص البرمجي الإضافي</i> لكل حالة اختبار.</p><p>على سبيل المثال، إذا كانت المواصفات مجرد "رسم رسم بياني غير مُوجّه بعقدتين مُسمّيتين A وB، مع وجود حافة بينهما"، فقد تكون حالة الاختبار المناسبة (وإن كانت ناتجة عن خطأ غير مُفيد) هي:</p><pre>
if set(graph.keys()) == {\'A\', \'B\'} and len(graph[\'A\']) == 1 and len(graph[\'B\']) == 1 and graph[\'A\'][0][0] == \'B\':
     print(\'OK\')
else:
     print(\'Nope\')
</pre>
<p>بدلاً من ذلك، يمكن استعمال مجموعة من حالات الاختبار، كل منها يتحقق من أحد جوانب المواصفات. على سبيل المثال، قد تطبع حالة الاختبار الأولى المفاتيح المُرتبة، متوقعةً ظهور \'A\'، \'B\'. أما حالة الاختبار الثانية، فقد تطبع الحواف المتصلة بالعقدة \'A\'، وهكذا.</p>';
$string['qtypehelp'] = 'مساعدة مع نوع السؤال';
$string['question_type_changed'] = 'تغيير نوع السؤال. أنقر تم لإعادة تحميل حقول التخصيص، إلغاء للاحتفاظ بحقولك المخصصة.';
$string['questioncheckboxes'] = 'التخصيص';
$string['questioncheckboxes_help'] = 'لتخصيص نوع السؤال، على سبيل المثال، لتعديل قالب السؤال أو واجهة المستخدم أو معاملات صندوق الرمل، انقر على مربع الاختيار \'تخصيص\' واقرأ التعليمات المتاحة حول عناصر النموذج الظاهرة حديثًا لمزيد من المعلومات.

عند النقر على مربع الاختيار "تصحيح أخطاء القالب"، سيظهر البرنامج المُنشأ لكل تشغيل لصندوق رمل الاختبار في المخرجات.';
$string['questionloaderror'] = 'فشل تحميل السؤال';
$string['questionpreview'] = 'استعراض';
$string['questiontype'] = 'نوع السؤال';
$string['questiontype_help'] = 'حدد نوع السؤال.

يحدد مربع الاختيار أحد الأنواع المضمنة، ويحدد كل منها لغةً معينة، وأحيانًا صندوق رمل لتنفيذ البرنامج. يحتوي كل نوع سؤال على قالب يُحدد كيفية بناء البرنامج القابل للتنفيذ من بيانات حالة الاختبار وإجابة الطالب.

يمكنك عرض القالب وتخصيصه اختياريًا بالنقر على خانة الاختيار \'تخصيص\'.

عند النقر على مربع الاختيار "تصحيح أخطاء القالب"، سيظهر البرنامج المُولَّد لكل حالة اختبار في المخرجات.';
$string['questiontype_required'] = 'ينبغي عليك اختيار نوع السؤال';
$string['questiontypedetails'] = 'تفاصيل نوع السؤال';
$string['regexgrader'] = 'تعبير إعتيادي';
$string['replacedollarscount'] = 'هذا الصنف يحتوي على {$a} من أسئلة CodeRunner.';
$string['replaceexpectedwithgot'] = 'أنقر زر &lt;&lt; لاستبدال المخرجات المتوقعة لهذه الحالة الاختبارية بالمخرجات الفعلية.';
$string['reset'] = 'إعادة تعيين الإجابة';
$string['resethover'] = 'تجاهل التغييرات وإعادة تعيين الإجابة إلى قيمتها الأصلية قبل التحميل';
$string['resultcolumnheader'] = 'الناتج';
$string['resultcolumns'] = 'أعمدة النتيجة';
$string['resultcolumns_help'] = 'يعرض جدول النتائج افتراضيًا أعمدة رمز الاختبار، stdin، الأعمدة المتوقعة والأعمدة المُحصل عليها، شريطة ألا تكون الأعمدة فارغة. يمكنك تغيير القيمة الافتراضية، و/أو رؤوس الأعمدة، بإدخال قيمة لأعمدة النتيجة (اتركها فارغة للسلوك الافتراضي).

في حال توفيرها، يجب أن يكون حقل أعمدة النتيجة قائمة مُرمّزة بصيغة JSON من مُحددات الأعمدة. كل مُحدد عمود هو في حد ذاته قائمة، عادةً ما تحتوي على عنصرين أو ثلاثة عناصر فقط. العنصر الأول هو رأس العمود، والعنصر الثاني هو الحقل من مكون نتيجة الاختبار المعروض في العمود، والعنصر الثالث الاختياري هو سلسلة نصية بتنسيق sprintf تُستعمل لعرض الحقل.

الحقول المتاحة في كائن نتيجة الاختبار القياسي هي: النص البرمجي للاختبار، stdin، والمتوقع والمُحصل عليه من الأعمدة، والإضافي، والمُستحق، والدرجة.

النص البرمجي للاختبار وstdin والمتوقع والإضافي هي الحقول من حالة الاختبار، بينما المحصل عليه هو الناتج الفعلي المُولّد والمُمنوح، والدرجة هي الدرجة الفعلية الممنوحة والدرجة القصوى لحالة الاختبار على التوالي.

يمكن لمصححي قوالب الاختبار إضافة حقولهم الخاصة، والتي يمكن أيضًا تحديدها للعرض. من الممكن أيضًا دمج حقول متعددة في عمود واحد عن طريق إضافة حقول إضافية إلى المُحدِّد: يجب أن تسبق هذه الحقول مُحدِّد تنسيق sprintf، والذي يصير إلزاميًا. على سبيل المثال، لعرض عمود "علامة الكسر" بالشكل 0.74/1.00، يمكن استعمال مُحدِّد تنسيق العمود ["علامة الكسر"، "مُنح"، "درجة"، "%.2f/%.2f"].

كحالة خاصة أخرى، يعني التنسيق %h أن حقل نتيجة الاختبار يجب اعتباره HTML جاهزًا للإخراج، ويجب ألا يخضع لمزيد من المعالجة؛ هذا مفيد فقط مع قوالب التقييم المخصصة التي تُنتج مخرجات HTML، مثل رسومات SVG.

القيمة الافتراضية لأعمدة النتائج هي [["اختبار"، "النص البرمجي للاختبار"]، ["إدخال"، "stdin"]، ["متوقع"، "متوقع"]، ["حصلت"، "حصلت"]].

لا يؤثر إعداد حقل أعمدة النتائج على استعمال مُقيّم قالب مُجمّع. يكون مُؤلّف السؤال مسؤولاً عن تنسيق جدول النتائج بالطريقة المطلوبة.';
$string['resultcolumnsnotjson'] = 'حقل أعمدة النتائج ليس بصيغة سلسلة JSON صالحة';
$string['resultcolumnsnotlist'] = 'حقل أعمدة النتائج ينبغي أن يكون بصيغة سلسلة بترميز JSON تمثل قائمة من أعمدة المُحدِّد';
$string['resultcolumnspecbad'] = 'تم العثور على مُحدد أعمدة خاطئ: ينبغي أن يكون كل منها بشكل قائمة مكونة من سلسلتين نصيتين أو أكثر';
$string['resultstring-abnormaltermination'] = 'إنهاء غير طبيعي';
$string['resultstring-compilationerror'] = 'خطأ عند التجميع';
$string['resultstring-illegalsyscall'] = 'طلب دالة غير معتمد';
$string['resultstring-internalerror'] = 'خطأ في CodeRunner (IE): يرجى إبلاغ المحاضر';
$string['resultstring-memorylimit'] = 'حد الذاكرة تم تجاوزه';
$string['resultstring-norun'] = 'بلا تشغيل';
$string['resultstring-outputlimit'] = 'مُخرجات مفرطة';
$string['resultstring-runtimeerror'] = 'خطأ عند التشغيل';
$string['resultstring-sandboxoverload'] = 'فرط تحميل في مخدم صندوق الرمل. ربما عليك إعادة المحاولةقريبًا.';
$string['resultstring-sandboxpending'] = 'خطأ في CodeRunner (PD): يرجى إبلاغ المحاضر';
$string['resultstring-sandboxpolicy'] = 'خطأ في CodeRunner (BP): يرجى إبلاغ المحاضر';
$string['resultstring-success'] = 'تم';
$string['resultstring-timelimit'] = 'حد الوقت تم تجاوزه';
$string['retestfailedquestions'] = 'إعادة فحص الأسئلة الفاشلة';
$string['run_failed'] = 'فشل تشغيل الاختبارات';
$string['sampleanswerattachments'] = 'مرفقات الإجابة النموذجية';
$string['sampleanswerattachments_help'] = 'إذا كانت الإجابة النموذجية تحتاج ملفات مرفقات، قم برفعها هنا';
$string['sandboxcontrols'] = 'صندوق الرمل';
$string['sandboxcontrols_help'] = 'تُشغَّل كل المهام في بيئة عمل Jobe، التي تفرض قيودًا على الذاكرة، ووقت وحدة المعالجة المركزية، ومخرجات الملفات، وما إلى ذلك. هنا يمكنك تعديل هذه القيود.

يُحدِّد \'حد الوقت (بالثواني)\' الحد الأقصى لوقت وحدة المعالجة المركزية بالثواني لكل تشغيل في بيئة عمل، ويُحدِّد \'حد الذاكرة (ميغا بايت)\' الحد الأقصى للذاكرة التي يُمكن تشغيلها. يستعمل المُدخل الفارغ القيمة الافتراضية لبيئة العمل (عادةً 5 ثوانٍ لحد وقت وحدة المعالجة المركزية وحجم الذاكرة يعتمد على اللغة)، ولكن قد لا تكون هذه القيم الافتراضية مناسبة للبرامج التي تتطلب موارد كثيرة. تؤدي قيمة صفر للحد الأقصى للذاكرة إلى عدم فرض أي حد. مقدار الذاكرة المُحدَّد هنا هو إجمالي الكمية اللازمة للتشغيل، بما في ذلك كل المكتبات، والمُفسِّرات، والبيئة الافتراضية، وما إلى ذلك.

يُستعمل مُدخل \'العوامل\' لتمرير بيانات إضافية خاصة ببيئة العمل، مثل خيارات التجميع ومفاتيح واجهة برمجة التطبيقات. عادةً ما يُترك فارغًا، ولكن إذا لم يكن فارغًا، فيجب أن يكون سجل JSON صالحًا. في حالة بيئة عمل Jobe، تشمل السمات المتاحة:
disklimit، وstreamsize، وnumprocs، وcompilargs، وlinkargs، وinterpreterargs. على سبيل المثال، <code>{"compileargs":["-std=c89"]</code> لسؤال C، سيُلزم الأمر بالتوافق مع C89 ولن تُستخدم أي خيارات C أخرى. راجع توثيقات Jobe لمزيد من التفاصيل. قد تتجاهل بعض بيئات العمل (مثل بيئة عمل Ideone القديمة) أيًا من هذه الإعدادات أو جميعها.

يمكن اختيار مخدم عمل مختلف عن طريق تعريف معامل مخدم jobe، واختياريًا معامل \'jobeapikey\'. على سبيل المثال، إذا تم تعيين حقل \'المعاملات\' على <code>{"jobeserver": "myspecialjobe.com"</code>، فسيتم إرسال عملية التشغيل إلى المخدم "myspecialjobe.com".';
$string['sandboxerror'] = 'خطأ من صندوق الرمل[{$a->sandbox}]: {$a->message}';
$string['sandboxparams'] = 'المعاملات';
$string['scratchpad_ui_bad_api_keys'] = 'لوحة المسودة المباشرة غير مهيئة بشكل صحيح. طول قائمة واجهة برمجة التطبيق ينبغي أن تساوي طول قائمة مخدم jobe.';
$string['scratchpad_ui_badrunwrappersrc'] = 'مصدر تشغيل الغلاف غير صحيح، يرجى التواصل مع منشئ السؤال.';
$string['scratchpad_ui_error'] = 'فشل طلب XML HTTP . خطأ في الشبكة أو CORS.';
$string['scratchpad_ui_invalidserialisation'] = 'مسلسل JSON المعطى غير صحيح، إذ ينبغي أن يتضمن حقل \\"answer_code\\".';
$string['scratchpad_ui_no_protocol'] = 'اسم مخدم Jobe ينبغي أن يبدأ بـ http:// أو https://.';
$string['scratchpad_ui_request_failed'] = 'فشل الطلب من مخدم صندوق الرمل';
$string['scratchpad_ui_templateloadfail'] = 'قالب واجهة المستخدم للوحة المسودة فشل في التحميل، يرجى إعادة تنشيط هذه الصفحة. إذا استمرت المشكلة، يرجى الإبلاغ عن ذلك.';
$string['scratchpadui_api_keys_descr'] = 'قائمة مفاتيح واجهة برمجة التطبيق لاستعمالها مع مخدمات Jobe (إذا إعطيت). إذا تركت فارغة، لن يُستعمل مفتاح واجهة برمجة التطبيق. تجريبي ومحتمل أنه غير آمن.';
$string['scratchpadui_button_name_descr'] = 'نص زر التشغيل';
$string['scratchpadui_close_delimiter_descr'] = 'محدد الإغلاق لاستعماله عند إدراج الإجابة أو النص البرمجي في لوحة المسودة في الغلاف. هذا سيستبدل القيمة الافتراضية \'|}\'.';
$string['scratchpadui_def_button_name'] = 'تشغيل';
$string['scratchpadui_def_help_text'] = '<p>يمكنك إدخال النص البرمجي في هذه اللوحة والنقر على \'تشغيل\' لتنفيذه.</p>
<p>افتراضيًا، يبدأ النص البرمجي في هذه اللوحة بمحتويات مربع الإجابة، مما يُسهّل عليك اختبار إجابتك.</p>
<p>يمكنك إلغاء تأشير خانة الاختيار \'إسبقه بالإجابة\' لتشغيل النص البرمجي في هذه اللوحة بشكل مستقل، على سبيل المثال، لاستكشاف سلوك أجزاء النص البرمجي الصغيرة.</p>';
$string['scratchpadui_def_prefix_name'] = 'البادئة مع الإجابة';
$string['scratchpadui_def_scratchpad_name'] = 'لوحة المسودة';
$string['scratchpadui_disable_scratchpad_descr'] = 'تعطيل لوحة المسودة، فعليًا سيعود إلى واجهة المستخدم في Ace من وجهة نظر الطالب.';
$string['scratchpadui_escape_descr'] = 'أفلت (JSON مع إزالة " من البداية والنهاية) ANSWER_CODE وSCRATCHPAD_CODE قبل الإدراج في الغلاف. مفيد عند إدراج النص البرمجي في سلسلة نصية. ملاحظة: لا يتم إفلات علامات الاقتباس المفردة \'.';
$string['scratchpadui_help_text_descr'] = 'نص المساعدة لإظهاره.';
$string['scratchpadui_invert_prefix_descr'] = 'يعكس معنى البادئة والتسلسل: \'1\' يعني غير مؤشر والعكس صحيح. يمكن استعماله لتبديل الحالة الافتراضية.';
$string['scratchpadui_jobe_servers_descr'] = 'قائمة بمخدمات Jobe، سيتم اختيار أحدها عشوائيًا كهدف مباشر لطلبات AJAX، بدلاً من المرور عبر مودل. تجريبي ومحتمل أنه غير آمن.';
$string['scratchpadui_open_delimiter_descr'] = 'محدد الفتح لاستعماله عند إدراج الإجابة أو النص البرمجي في لوحة المسودة في الغلاف. هذا سيستبدل القيمة الافتراضية \'|}\'.';
$string['scratchpadui_output_display_mode_descr'] = 'تحكم في كيفية عرض مخرجات البرنامج عند التشغيل، وهناك ثلاثة أوضاع:
<ul>
<li>نص: عرض المخرجات كنص، مع إمكانية تجاوز HTML. (افتراضي)</li>
<li>json: عرض البرامج التي تُخرج JSON، وهو مفيد لالتقاط بيانات stdin وعرض الصور. (مستحسن)</li>
<ul>
<li>يقبل JSON في مخرجات التشغيل مع الحقول التالية:</li>
<ul>
<li>returncode: رمز الخروج من تشغيل البرنامج.</li>
<li>stdout: نص stdout من تشغيل البرنامج.</li>
<li>stderr: نص خطأ من تشغيل البرنامج.</li>
<li>ملفات: كائن يحتوي على أسماء ملفات مرتبطة بصور مُرمّزة بصيغة base64. سيتم عرض هذه الملفات أسفل أي نص stdout.</li>
</ul>
<li>عند ضبط رمز الإرجاع على 42، سيتم إضافة حقل إدخال HTML بعد آخر stdout يتم تلقيه. عند الضغط على مفتاح الإدخال داخل حقل الإدخال، تُضاف قيمة الإدخال إلى stdin، ويُشغّل البرنامج مرة أخرى باستخدام stdin المُحدّث. يتكرر هذا إلى أن لا يتم ضبط رمز الإرجاع على 42. </li></ul>
<li>html: عرض مخرجات البرنامج بصيغة html خام داخل منطقة الإخراج. (متقدم)</li>
<ul>
<li>يمكن استعمال هذا لعرض الصور وإدراج عناصر HTML أخرى.</li>
<li>إضافة عنصر &lt;input&gt; إلى فئة coderunner-run-input سيضيف حدثًا: عند الضغط على مفتاح الإدخال داخل حقل الإدخال، تُضاف قيمة الإدخال إلى stdin، ويُشغّل البرنامج مرة أخرى باستعمال stdin المُحدّث.</li>
</ul>
</ul>';
$string['scratchpadui_params_descr'] = 'معاملات خدمة الويب لصندوق الرمل';
$string['scratchpadui_prefix_name_descr'] = 'نص الملصق لخانة التأشير العائدة للبادئة مع الإجابة';
$string['scratchpadui_run_lang_descr'] = 'اللغة المستعملة لتشغيل النص البرمجي عند النقر على زر التشغيل. هذه ينبغي أن تكون اللغة التي يكون غلافك مكتوب بها (إن كان ذلك مطبقًا).';
$string['scratchpadui_scratchpad_name_descr'] = 'اسم العرض للوحة المسودة، المستعمل لإظهارها/إخفائها.';
$string['scratchpadui_wrapper_src_descr'] = 'موقع الغلاف الذي سيتم استعماله بواسطة زر التشغيل: سيؤدي تعيينه على \'العمومي الإضافي\' إلى استخدام النص في الحقل \'الإضافي العالمي\'، وسيستخدم \'النوع الأولي الإضافي\' الحقل الإضافي للنوع الأولي.';
$string['seethisquestioninthequestionbank'] = 'مشاهدة هذا السؤال في بنك الأسئلة';
$string['showcolumns'] = 'إظهار الأعمدة:';
$string['showcolumns_help'] = 'حدد أعمدة جدول النتائج التي تريد عرضها للطلاب. سيتم إخفاء الأعمدة الفارغة بغض النظر عن ذلك.
الإعدادات الافتراضية مناسبة لمعظم الاستعمالات.';
$string['showdetails'] = 'إظهار التفاصيل';
$string['showdifferences'] = 'إظهار الفروقات';
$string['showsource'] = 'كشف أخطاء القالب';
$string['sourcecodeallruns'] = 'كشف الخطأ: النص البرمجي المصدري من كل التشغيلات الاختبارية';
$string['stdin'] = 'الإدخال القياسي';
$string['stdin_help'] = 'الإدخال القياسي إلى النص، يشاهده المظهر بمثابة {{TEST.stdin}}';
$string['student_answer'] = 'إجابة الطالب';
$string['submitbuttons'] = 'أزرار التسليم';
$string['supportscripts'] = 'نصوص الدعم';
$string['syntax_errors'] = 'خطأ/أخطاء في الصياغة';
$string['table_ui_invalidjson'] = 'واجهة المستخدم للجدول: تسلسل JSON خاطئ.';
$string['table_ui_invalidserialisation'] = 'واجهة المستخدم للجدول: تسلسل خاطئ.';
$string['table_ui_missingparams'] = 'واجهة المستخدم للجدول تحتاج المعاملات num_columns و num_rows.';
$string['tableui_column_headers_descr'] = 'قائمة من السلاسل النصية لعناوين الأعمدة.';
$string['tableui_column_width_percents_descr'] = 'قائمة من الأرقام العائمة التي توضح النسبة المئوية لعرض الجدول المتاح للتخصيص للأعمدة، بما في ذلك عمود تسمية الصف إذا كان موجودًا.';
$string['tableui_dynamic_rows_descr'] = 'إذا كان صائبًا، بتم توفير زر "إضافة صف" للسماح للمستخدمين بإضافة صفوف إلى الجدول.';
$string['tableui_lines_per_cell_descr'] = 'عدد صفوف النصوص في كل منطقة نص/خلية';
$string['tableui_locked_cells_descr'] = 'قائمة مكونة من عنصرين تُعطي إحداثيات الخلايا الأصلية (0) التي لا يمكن للمستخدم تعديلها. لا تتضمن الإحداثيات صف رأس أو عمود تسمية صف.';
$string['tableui_num_columns_descr'] = 'عدد الأعمدة في الجدول، باستثناء العمود الأقصى إلى اليمين الذي للملصق (إذا كانت الملصقات معطاة). مطلوب.';
$string['tableui_num_rows_descr'] = 'عدد الصفوف (الأولي) في الجدول، باستثناء صف العناوين العلوي (إذا كانت العناوين معطاة). مطلوب.';
$string['tableui_row_labels_descr'] = 'قائمة من السلاسل النصية لملصقات الأعمدة، أي القيم في العمود 0.';
$string['tableui_sync_interval_secs_descr'] = 'مهلة الوقت بالثواني ما بين طلبات مزامنة محتويات واجهة المستخدم رجوعًا مع إجابة السؤال. 0 معناها لا توجد هذه المزامنة التلقائية.';
$string['template'] = 'القالب';
$string['template_changed'] = 'مظهر الفحص الأولي تغير - أتريد تعطيل المُدمِج؟ [\'إلغاء\' يبقيه مُمَكَّناً.]';
$string['template_help'] = 'يُحدد القالب البرنامج (البرامج) الذي يُشغَّل في صندوق الرمل لإجابة طالب أو اختبار (اختبارات) مُحددة. هناك نوعان من القوالب:

* قالب لكل اختبار، يُحدد برنامجًا يُشغّل لحالة اختبار واحدة، و
* قالب \'مُجمّع\' يُحدد برنامجًا يجمع كل الحالات المختلفة في برنامج واحد.

تُترك خانة الاختيار \'هو مجمع\' بدون تحديد لقالب لكل اختبار، وتُؤشر لقالب مُجمّع. يفترض باقي لوحة المساعدة أنك تستعمل قالبًا لكل اختبار؛ راجع التوثيقات الكاملة لاستعمال قوالب المُجمّع.

يُعالج القالب بواسطة مُحرّك قوالب Twig (انظر http://twig.sensiolabs.org) في سياق يكون فيه STUDENT_ANSWER هو إجابة الطالب، وTEST.testcode هو النص البرمجي الاختباري الحالي. يمكن إدراج هذه القيم (وقيم حالات الاختبار الأخرى مثل TEST.expected وTEST.stdin وTEST.mark) في القالب بوضعها بين أقواس مزدوجة، مثل:

<code>{{TEST.testcode}</code>. للاستعمال مع السلاسل النصية الحرفية، ينبغي استعمال دالة هروب مناسبة، مثل: <code>{{STUDENT_ANSWER | e(\'py\')}</code> مناسبة للاستخدام مع السلاسل النصية الثلاثية المقتبسة في بايثون. دوال الهروب الأخرى هي: <code>e(\'c\')</code> و<code>e(\'java\')</code> و<code>e(\'matlab\')</code>. بعد ذلك، يُجمّع البرنامج الناتج عن Twig ويُنفّذ باستعمال لغة النوع المدمج المُختار، مع ضبط stdin على TEST.stdin. ثم يُمرّر الناتج من هذا البرنامج إلى المُقيِّم المُختار.

راجع قسم المساعدة ضمن \'مسيطرات التقييم\' لمزيد من المعلومات.

لاحظ أنه في حال استعمال قالب مُخصص لكل اختبار، سيتم إرسال مهمة تجميع وتنفيذ إلى صندوق الرمل لكل حالة اختبار، بينما تُعرّف معظم أنواع الأسئلة المُدمجة قالبًا مُجمّعًا يجمع كل حالات الاختبار في عملية تشغيل واحدة.

عند النقر على خانة اختيار \'كشف أخطاء القالب\'، سيتم عرض البرنامج المُولّد لكل عملية تشغيل في صندوق الرمل في المُخرجات.';
$string['templatecontrols'] = 'أدوات تحكم القالب';
$string['templatecontrols_help'] = 'يُحدد تأشير خانة الاختيار \'هو مُجمِّع\' أن القالب هو قالب مُجمِّع، يجمع (أو يحاول دمج) إجابة الطالب بالإضافة إلى كل حالات الاختبار في عملية تشغيل واحدة. إذا تم تأشير هذه الخانة، فستحتاج أيضًا إلى تحديد قيمة حقل test_splitter_re، وهو تعبير PHP الاعتيادي المستعمل لتقسيم مخرجات تشغيل البرنامج إلى مجموعة من عمليات التشغيل الفردية. مع ذلك، لستَ بحاجة إلى تحديد هذا إذا كنت تستخدم مُقيِّم قالب أيضًا، ففي هذه الحالة يكون النص البرمجي للقالب مسؤولًا عن تقسيم المخرجات وتصنيفها.

لا يتم تمرير متغير TEST Twig إلى قوالب المُجمِّع. بل يتم إرسال متغير TESTCASES إليها، وهو قائمة بكل الاختبارات في السؤال. يُفترض عمومًا أن يجمع البرنامج الناتج عن القالب إجابة الطالب (STUDENT_ANSWER) وكل حالات الاختبار (TESTCASES) في برنامج واحد، وعند تشغيله، يُخرج نتائج كل حالة اختبار، مفصولة بسلسلة نصية فريدة.
تُعرّف السلسلة الفاصلة بتعبير نمطي يُعطى بواسطة حقل النموذج \'test_splitter_re\' أدناه.

ومع ذلك، إذا كانت حالات الاختبار مُعرّفة بمدخلات قياسية، تصير قوالب المُجمّعات مُشكلة. إذا أنشأ القالب برنامجًا واحدًا، فما هو المدخل القياسي الذي يجب أن يكون؟ الحل الأبسط (والافتراضي) هو تشغيل حالات الاختبار واحدة تلو الأخرى، باستعمال قالب المُجمّع لبناء كل برنامج، وتمرير متغير TESTCASES إليه والذي يحتوي على اختبار واحد فقط.
تتيح هذه الحيلة لقالب المُجمّع أداء دور مزدوج: فهو يعمل كقالب لكل حالة اختبار (مع مصفوفة TESTCASES أحادية العنصر) عندما يُقدّم مُؤلّف السؤال مُدخلات قياسية، وفي الحالات الأخرى كمُجمّع سليم (مع مصفوفة TESTCASES أحادية العنصر). لتغيير هذا السلوك بحيث يستقبل المُجمّع كل حالات الاختبار، حتى مع وجود stdin، فعّل خانة الاختيار "السماح بـ stdins متعددة".

إذا نتج عن تشغيل برنامج المُجمّع أي مُخرجات إلى stderr، فسيتم تفسير ذلك على أنه خطأ في التشغيل. لضمان حصول الطالب على أكبر عدد ممكن من الاختبارات الصحيحة، يتصرف النظام كما هو الحال عند وجود مُدخلات قياسية، مع العودة إلى تشغيل كل اختبار على حدة. مع ذلك، لا ينطبق هذا على مُقيِّمي المُجمّع، إذ يتعين عليهم التعامل مع كل أخطاء وقت التشغيل بأنفسهم، ويجب عليهم دائمًا إرجاع نتيجة JSON صحيحة.';
$string['templateerror'] = 'خطأ في القالب';
$string['templategrader'] = 'مُقيِّم القالب';
$string['templateparams'] = 'عوامل القالب';
$string['templateparams_help'] = 'إذا لم يكن الحقل فارغًا، فيجب تقييمه إلى سجل بصيغة JSON. في أبسط صوره، يكون الحقل مجرد سجل JSON يُعرّف مجموعة من المتغيرات التي تُضاف إلى بيئة محرك قوالب Twig عند توسيعه للقالب (وإلى الحقول الأخرى إذا تم ضبط Twig All).

إذا تم تحديد معالج مسبق في قسم عناصر تحكم معاملات القالب، فستتم معالجة معاملات القالب أولًا بواسطة اللغة المحددة لإنتاج سجل JSON. راجع <a href="https://coderunner.org.nz/mod/url/view.php?id=199">
التوثيقات</a> لمزيد من التفاصيل.

<b>تحذير:</b> قد يؤدي استعمال معالج مسبق غير Twig إلى آثار سلبية كبيرة على الأداء إذا تم تأشير خانة الاختيار "التقييم لكل طالب"، وهو أمر ضروري عند استعماله للتوزيع العشوائي أو لتخصيص أسئلة لكل طالب. ينبغي إجراء المعالجة المسبقة قبل عرض السؤال على الطالب، وباستثناء Twig، تتم المعالجة في مخدم Jobe لصندوق الرمل. كل محاولة للإجابة على أي سؤال من هذا النوع من قِبل أي طالب ستؤدي إلى إرسال مهمة إلى ذلك المخدم. قد يؤدي هذا إلى وصول آلاف المهام إلى مخدم Jobe دفعة واحدة في بداية اختبار أو امتحان كبير، مما قد يُثقل كاهله. تحذير للمشتري!';
$string['templateparamsevalpertry'] = 'التقييم لكل الطالب';
$string['templateparamslang'] = 'المعالج القبلي';
$string['templateparamsusingsandbox'] = 'تستعمل المعالجات المسبقة، بخلاف Twig، مخدم صندوق الرمل. إذا تم ضبط "التقييم لكل طالب"، فعندما يبدأ الطالب اختبارًا، تبدأ كل هذه الأسئلة بتشغيل صندوق الرمل حتى قبل أن يُعرض السؤال. في الاختبار أو الامتحان، قد يؤدي ذلك إلى زيادة الحمل على مخدم صندوق الرمل. تنبيه المشتري!';
$string['testallincategory'] = 'فحص كل الأسئلة في هذا الصنف';
$string['testalltitle'] = 'فحص كل الأسئلة في هذا السياق';
$string['testcase'] = 'حالة الفحص {$a}';
$string['testcasecontrols'] = 'خصائص الفحص:';
$string['testcasecontrols_help'] = 'إذا تم تأشير خيار \'استعمل كمثال\'، فسيتم تضمين هذا الاختبار تلقائيًا في جدول نتائج \'على سبيل المثال:\' الخاص بالسؤال.

تحدد خانة الاختيار \'عرض\' وقت عرض حالة الاختبار هذه للطالب في جدول النتائج.

إذا تم تأشير خانة \'إخفاء الباقي في حالة الفشل\' وفشل هذا الاختبار، فسيتم إخفاء كل الاختبارات اللاحقة عن الطالب، بغض النظر عن إعداد خانة الاختيار \'عرض\'.

يحدد خيار \'العلامة\' قيمة حالة الاختبار هذه؛ ويكون ذا معنى فقط إذا لم يكن هذا سؤالًا من نوع \'الكل أو لا شيء\'.

يمكن استعمال خيار \'الترتيب\' لتغيير ترتيب حالات الاختبار عند حفظ السؤال: يتم ترتيب حالات الاختبار حسب هذا الحقل.';
$string['testcases'] = 'حالات الفحص';
$string['testcode'] = 'ترميز الفحص';
$string['testcode_help'] = 'الترميز الخاص بالفحص، مشاهد من قبل المظهر بمثابة {{TEST.testcode}}';
$string['testcolhdr'] = 'الفحص';
$string['testingquestion'] = 'يجري فحص السؤال {$a}';
$string['testsplitterre'] = 'مقسم الفحص (تعبير إعتيادي)';
$string['testtype'] = 'نوع اختبار ما قبل الفحص';
$string['testtype_both'] = 'كلاهما';
$string['testtype_help'] = 'إذا تم تمكين الفحص المسبق وتعيينه على \'محدد\'، فإن هذا الإعداد يتحكم في ما إذا كان سيتم استعمال الاختبار فقط مع تشغيل عادي، أو مع تشغيل فحص مسبق فقط، أو في كلا التشغيلين.
إذا تم تعيين الفحص المسبق على أي قيمة غير \'محدد\'، فسيتم تجاهل هذا الإعداد.';
$string['testtype_normal'] = 'تحقق فقط';
$string['testtype_precheck'] = 'تحقق أولي فقط';
$string['tooshort'] = 'الجواب قصير جدًا ليكون ذا معنى ولقد تم تجاهله بدون فرض غرامة';
$string['twigall'] = 'Twig all';
$string['twigcontrols'] = 'مسيطرات معاملات القالب';
$string['twigcontrols_help'] = 'كان يُشار إلى معاملات القالب عادةً في أثناء توسيع Twig بالشكل {{QUESTION.parameters.someparam}}. ومع ذلك، عند تأشير خانة الاختيار "معاملات قالب الرفع"، تُرفع المعاملات إلى مساحة اسم Twig العامة، ويمكن الإشارة إليها ببساطة باسم {{someparam}}.

يتيح توافق Ace/لوحة المسودة التبديل السلس بين واجهتي المستخدم لكل من Ace ولوحة المسودة. اترك الخيار محددًا إلا إذا كنت ترغب في أن يتمكن Ace من تعديل سلسلة JSON باستعمال مفتاح "answer_code"، والذي يُعتبر تسلسلًا من لوحة المسودة.

عند تحديد Twig All، يُطبق توسيع ماكرو Twig على نص السؤال، ونموذج الإجابة، والتحميل المسبق للإجابة، ومعاملات واجهة المستخدم، وكل حقول حالات الاختبار، باستعمال معاملات القالب كبيئة. ستحتاج عادةً إلى تفعيل TwigAll إذا كنت تستعمل التوزيع العشوائي ضمن معاملات القالب. لاحظ أن توسيع Twig All يحدث عند تهيئة السؤال لأول مرة، بينما يحدث توسيع Twig للقالب لاحقًا، عندما يُرسل الطالب إجابة. تتضمن بيئة توسيع القالب متغير QUESTION
Twig (جزء من سجل السؤال بأكمله)، وقد تكون بعض حقوله قد توسعت نتيجة استعمال Twig All.

يجب أن يكون النص في حقل معاملات القالب إما JSON أو ينبغي أن يُقيّم ليُنتج JSON عند معالجته بواسطة المعالج المسبق المُحدد. يُرجى العلم بأن اختيار معالج مسبق غير Twig سيؤدي إلى إرسال السؤال إلى بيئة Jobe قبل عرضه. راجع <a href="https://coderunner.org.nz/mod/url/view.php?id=199">
التوثيقات</a> لمعرفة كيفية كتابة معالج مسبق غير Twig.

في حالة استعمال معالج مسبق غير Twig، عادةً ما يكون إرسال صندوق رمل Jobe مطلوبًا لكل سؤال لكل طالب عند بدء الاختبار. إذا تم إلغاء تحديد خيار <i>التقييم لكل طالب</i>، فسيتم إرسال سؤال واحد فقط في بيئة الاختبار الافتراضية عند حفظه؛ وهذه عملية منخفضة التكلفة نسبيًا، ولكنها ليست مفيدة عادةً، لأنها تمنع بشكل أساسي أي استعمال للتوزيع العشوائي لكل طالب. مع ذلك، يمكن استعمالها لإنشاء محتوى السؤال في بعض الحالات.';
$string['twigerror'] = 'خطأ Twig {$a}';
$string['twigerrorintest'] = 'خطأ Twig عند معالجة هذا الاختبار {$a}';
$string['type_header'] = 'نوع سؤال CodeRunner';
$string['typename'] = 'نوع السؤال';
$string['typerequired'] = 'يرجى اختيار نوع السؤال (اللغة، التنسيق، إلخ)';
$string['ui_fallback'] = 'الرجوع إلى منطقة النص الخام.';
$string['uichanged'] = 'لقد تغيرت واجهة المستخدم. إحفظ الصفحة ثم أعد تحميلها لمعاينة عوامل واجهة المستخدم وتحريرها (إن وجدت).';
$string['uicontrols'] = 'إدخال واجهات المستخدم';
$string['uicontrols_help'] = 'قالب مؤلف السؤال.

تعرض القائمة المنسدلة "إجابة الطالب" قائمةً بالملاحق المتاحة. عادةً ما يُستعمل محرر Ace لكتابة أسئلة الترميز.
يمكن استعمال قيمة \'None\' لتوفير مربع نص خام فقط.

توفر قيمة \'Graph\' للمستخدم واجهة مستخدم بسيطة لرسم الرسوم البيانية، تُستعمل مع الأسئلة التي تطلب من الطالب رسم رسم بياني وفقًا لمواصفات معينة؛ وعادةً ما تحتوي هذه الأسئلة على حالة اختبار واحدة، مُقيّمة باستعمال قالب يُحلل التمثيل التسلسلي للرسم البياني، ويطبع رسالة مثل \'تم\' إذا كانت الإجابة صحيحة، أو رسالة خطأ مفيدة في حال عدم صحتها.

عنصر واجهة المستخدم \'جدول\'، الذي يعرض جدولًا لمساحات نصية ليملأها الطالب. يُستعمل هذا العنصر من قِبل نوع سؤال "python3_program_testing"، المُضمن في نماذج الأسئلة على github.

تم توثيق واجهات المستخدم \'Gapfiller\' و\'Html\' في وتوثيقات CodeRunner الرئيسية على الرابط https://github.com/trampgeek/moodle-qtype_coderunner#code-runner.

يمكن للطلاب الذين يعانون من ضعف البصر، أو المؤلفين الذين يرغبون في فحص التسلسلات (على سبيل المثال لفهم التمثيل المستعمل في واجهة المستخدم الرسومية)، تبديل استعمال كل مكونات واجهة المستخدم الإضافية في الصفحة الحالية بالضغط على Ctrl-Alt-M.

ستُستعمل أيضًا أي قيمة مُحددة لإجابة الطالب في نموذج المحرر لحقلي "الإجابة النموذجية" و"تحميل الإجابة المسبق".

في حال تحديد \'القالب يستعمل ace\'، سيُدير محرر النصوص البرمجية Ace كلاً من القالب ومربعات معاملات القالب. وإلا، فسيتم استعمال مربع نص خام.';
$string['uiparamdefault'] = 'الافتراضي';
$string['uiparamdesc'] = 'الوصف';
$string['uiparametergroup'] = 'معاملات واجهة المستخدم';
$string['uiparametergroup_help'] = 'سلسلة نصية JSON تُعرّف أي قيم لمعاملات واجهة المستخدم المطلوبة من قِبل مُكوّن واجهة المستخدم أو التي تتجاوز القيم الافتراضية. على سبيل المثال، لرسم عُقد أكبر عند استعمال واجهة المستخدم الرسومية: \'{"noderadius": 30}\'';
$string['uiparameters'] = 'معاملات واجهة المستخدم (JSON)';
$string['uiparametertablehead'] = 'إن واجهة المستخدم {$a->uiname} تأخذ المعاملات الآتية:';
$string['uiparamname'] = 'الاسم';
$string['unauthorisedbulktest'] = 'ليس لديك وصول مناسب لأي أسئلة من نوع CodeRunner';
$string['unauthoriseddbaccess'] = 'ليس مصرحاً لك باستعمال هذا النص البرمجي';
$string['unknowncombinatorgraderfield'] = 'حقل مجهول ({$a->fieldname}) في مخرجات المُقيِّم المُدمِج';
$string['unknownerror'] = 'وقع خطأ غير متوقع. قد يكون sandbox متوقفاً. حاول مجدداً بعد برهة.';
$string['unknownuiplugin'] = 'معلومات عن ملحق مجهول ({$a->pluginname}) تم طلبها.';
$string['unserializefailed'] = 'نتائج الاختبار المخزونة تعذر إلغاء مسلسلها. ربما عليك محاولة إعادة التقييم.';
$string['useace'] = 'القالب يستعمل ace';
$string['useasexample'] = 'استعمل كمثال';
$string['validateonsave'] = 'التحقق عند الحفظ';
$string['wrongnumberofformats'] = 'عدد نتائج الفحص خاطئ لتنسيقات الأعمدة. المتوقع {$a->expected}، حصلت على {$a->got}';
$string['wsbadjson'] = 'المعاملات ومعاملات الملف ينبغي أن تكون خالية أو سجل JSON صالح';
$string['wscputimeexcess'] = 'الوقت المحدد للمعالج يتخطى الوقت الأقصى لوحدة المعالجة المركزية';
$string['wsdisabled'] = 'خدمة الويب لصندوق الرمل معطلة. تحدث مع مشرف النظام';
$string['wsloggingenable'] = 'وثِّق استعمال خدمة الويب لصندوق الرمل';
$string['wsloggingenable_desc'] = 'عند تفعيل هذا الخيار، سيتم تسجيل كل عملية تنفيذ للنص البرمجي عبر خدمة الويب التجريبية. ينبغي تمكين هذا الخيار لضمان عمل ميزة خفض سرعة المستخدم.';
$string['wsmaxcputime'] = 'الوقت الأقصى لوحدة المعالجة المركزية (ثوان)';
$string['wsmaxcputime_desc'] = 'يقيد الوقت الأقصى للمعالج الذي يمكن لخدمة الويب لمخدم Jobe استعمالها، حتى وإن كانت تحدد معاملات وقت المعالج لصندوق الرمل.';
$string['wsmaxhourlyrate'] = 'أقصى معدل تسليمات بالساعة';
$string['wsmaxhourlyrate_desc'] = 'إذا حاول أحد المستخدمين تجاوز معدل التسليم هذا في أي ساعة معينة، فسيتم رفض تسليمه. 0 لعدم وجود تقييد للمعدل.';
$string['wsnoaccess'] = 'يمكن فقط للمستخدمين المسجلين لدخولهم ومن غير الضيوف الوصول إلى هذه الوظيفة';
$string['wsnolanguage'] = 'اللغة "{$a}" غير معروفة';
$string['wssubmissionrateexceeded'] = 'لقد تجاوزت المعدل الأقصى للتسليمات بالساعة لـ \'قم بتجربتها!\'. الطلب مرفوض.';
$string['xmlcoderunnerformaterror'] = 'خطأ في صيغة XML لسؤال coderunner';
