<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'uk', version '4.1'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Доступність';
$string['accessibilitydisabled'] = 'Набір інструментів доступності Brickfield не ввімкнено на цьому сайті. Щоб увімкнути, зверніться до адміністратора сайту.';
$string['accessibilityreport'] = 'Набір інструментів доступності';
$string['accessibilitytool'] = 'Інструмент доступності Brickfield';
$string['accessibilitytools'] = 'Інструменти доступності Brickfield';
$string['activate'] = 'Активувати';
$string['activated'] = 'Плагін активований і готовий до використання.';
$string['activationform'] = 'Реєстрація Brickfield';
$string['activationheader'] = 'Активація Brickfield';
$string['activationinfo'] = '<p>Щоб використовувати цей плагін, ви повинні надати дійсні ключі для цього сайту в цій формі. </p><p>Будь ласка, <a href="{$a}" data-action="send_info" target="_blank">зареєструйтеся на порталі Brickfield (відкриється в новому вікні)</a>, щоб отримати ці ключі, якщо у вас їх ще немає. </p><p>Після активації ваші ключі будуть перевірені за допомогою запланованих завдань cron<p>.';
$string['activityresults:pluginname'] = 'Звіт про доступність інструмента розбивки діяльності';
$string['activityresults:toolname'] = 'Підсумок діяльності';
$string['activityresults:toolshortname'] = 'Розбивка діяльності';
$string['advanced:pluginname'] = 'Звіт про розширений інструмент доступності';
$string['advanced:toolname'] = 'Розширений підсумок';
$string['advanced:toolshortname'] = 'Розширений';
$string['allcourses'] = 'Усі переглянуті курси ({$a})';
$string['allcoursescat'] = 'Усі переглянуті курси для категорії {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'За бажанням';
$string['analysis:disabled'] = 'Вимкнено';
$string['analysistype'] = 'Увімкнути запити на аналіз';
$string['analysistype_desc'] = 'Дозволити запит на аналіз доступності вмісту';
$string['analysistypedisabled'] = 'Аналіз вмісту вимкнено';
$string['bannercontentone'] = 'Набір інструментів доступності підприємства має повний набір функцій, які допоможуть вашій організації покращити доступність ваших курсів. <a href="{$a}">Зв’яжіться з Brickfield Education Labss</a>, щоб замовити безкоштовну демонстрацію розширених функцій.';
$string['bannercontenttwo'] = 'Створіть ефективну та інклюзивну платформу для викладання та навчання, знайшовши вміст, який не відповідає інструкціям, виправивши проблеми та забезпечивши майбутній зміст вашого курсу Moodle за допомогою доступних файлів, редактора та розширених функцій.';
$string['bannerheadingone'] = 'Оновіть набір інструментів доступності підприємства';
$string['batch'] = 'Ліміт партії';
$string['brickfield'] = 'Набір інструментів Brickfield';
$string['brickfield:viewcoursetools'] = 'Перегляд звітів за курсами';
$string['brickfield:viewsystemtools'] = 'Переглянути звіти для всіх курсів';
$string['bulkprocesscaches'] = 'Процес масового кешування';
$string['bulkprocesscourses'] = 'Перевірка доступності масової партії';
$string['buttonone'] = 'Отримайте безкоштовну демонстрацію';
$string['cachepending'] = 'Зведені дані збираються';
$string['checkdesc:alinksdontopennewwindow'] = 'Посилання, що відкриваються в новому вікні, повинні попередити користувачів заздалегідь.';
$string['checkdesc:amustcontaintext'] = 'Посилання має містити текст, щоб його можна було сприймати.';
$string['checkdesc:areadontopennewwindow'] = 'Ділянки, що використовуються в графічних картах, що відкриваються в новому вікні, повинні попередити користувачів заздалегідь.';
$string['checkdesc:areahasaltvalue'] = 'Області, які використовуються в картах зображень, не повинні пропускати альтернативний текст, схожий на зображення.';
$string['checkdesc:asuspiciouslinktext'] = 'Текст посилання має бути описовим і надавати контекст про його призначення.';
$string['checkdesc:basefontisnotused'] = 'Елементи базового шрифту (традиційно використовувані для форматування) недоступні і не повинні використовуватися.';
$string['checkdesc:blinkisnotused'] = 'Блигаючі елементи, які блимають і вимикаються, недоступні і не повинні використовуватися.';
$string['checkdesc:boldisnotused'] = 'Жирний (b) елементи не слід використовувати; замість нього слід використовувати "сильний".';
$string['checkdesc:contenttoolong'] = 'Загальна довжина вмісту сторінки не повинна перевищувати 500 слів.';
$string['checkdesc:csstexthascontrast'] = 'Колірний контраст між текстом і фоном занизький.';
$string['checkdesc:embedhasassociatednoembed'] = 'У елементах Embed (для вбудовування мультимедіа) не повинно бути відсутніх відповідних елементів "noembed".';
$string['checkdesc:headerh3'] = 'Заголовки, наступні після заголовків H3 (опція великого заголовка редактора), не повинні порушувати ієрархію заголовків сторінки.';
$string['checkdesc:headershavetext'] = 'Заголовок повинен містити текст, щоб його можна було сприймати.';
$string['checkdesc:iisnotused'] = 'Курсив (i) елементи не повинні використовуватися; Замість цього слід використовувати "em".';
$string['checkdesc:imgaltisdifferent'] = 'Замінний (альтернативний) текст зображення не повинен бути ім’ям файлу зображення.';
$string['checkdesc:imgaltistoolong'] = 'Замінний (альтернативний) текст зображення не повинен перевищувати максимально дозволеного (125) символів.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Альтернативний (альтернативний) текст зображення не повинен бути порожнім, особливо якщо на зображенні є посилання на інше місце.';
$string['checkdesc:imgaltnotplaceholder'] = 'Альтернативний (альтернативний) текст зображення не повинен бути простим текстом-заповнювачем, таким як «зображення».';
$string['checkdesc:imghasalt'] = 'Альтернативний (альтернативний) текст зображення не повинен бути відсутнім для елементів зображення, за винятком випадків, коли він є чисто декоративним і не має значення.';
$string['checkdesc:imgwithmaphasusemap'] = 'Карти зображень із областями, які можна натиснути, мають відповідати елементам "usemap" і "map".';
$string['checkdesc:legendtextnotempty'] = 'Елементи легенди, які використовуються для підписів елементів набору полів, повинні містити текст.';
$string['checkdesc:marqueeisnotused'] = 'Елементи виділення (автоматична прокрутка) недоступні і не повинні використовуватися.';
$string['checkdesc:noheadings'] = 'Відсутність заголовків робить вміст менш структурованим і важчим для читання.';
$string['checkdesc:objectmusthaveembed'] = 'У елементах об’єкта (для вбудовування зовнішніх ресурсів) не повинно бути відсутніх відповідних елементів «вбудовування».';
$string['checkdesc:objectmusthavetitle'] = 'У елементах об’єкта (для вбудовування зовнішніх ресурсів) не повинно бути пропущених відповідних описів «заголовок».';
$string['checkdesc:objectmusthavevalidtitle'] = 'Елементи об’єкта (для вбудовування зовнішніх ресурсів) повинні мати відповідні «заголовки» з текстом.';
$string['checkdesc:strikeisnotused'] = 'Не слід використовувати закреслені (закреслені) елементи; Замість цього слід використовувати "del" (видалено).';
$string['checkdesc:tabledatashouldhaveth'] = 'В ідеалі в таблицях не повинно бути заголовків.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Підсумки та підписи таблиць не повинні бути ідентичними.';
$string['checkdesc:tabletdshouldnotmerge'] = 'В ідеалі таблиці не повинні мати жодних об’єднаних осередків.';
$string['checkdesc:tablethshouldhavescope'] = 'Обсяги рядків або стовпців таблиці (використовуються для відображення рядків і стовпців у кожній клітинці) повинні бути оголошені.';
$string['checkidvalidation'] = 'Завдання перевірити наявність недійсних ідентифікаторів';
$string['checkscompleted'] = 'Перевірки виконано: {$a}';
$string['checktype'] = 'Перевірити групу';
$string['checktype:form'] = 'Форма';
$string['checktype:image'] = 'Зображення';
$string['checktype:layout'] = 'Макет';
$string['checktype:link'] = 'Посилання';
$string['checktype:media'] = 'ЗМІ';
$string['checktype:table'] = 'Таблиця';
$string['checktype:text'] = 'Текст';
$string['checktyperesults:pluginname'] = 'Звіт про інструменти доступності типів вмісту';
$string['checktyperesults:toolname'] = 'Резюме про типи вмісту';
$string['checktyperesults:toolshortname'] = 'Типи вмісту';
$string['cmpercent'] = 'Відсоток діяльності в цілому';
$string['cmpercenterrors'] = 'Загальний відсоток помилок';
$string['cmpercenttitle'] = 'Загальний % розподілу діяльності та помилок';
$string['confirmationmessage'] = 'Цей курс заплановано на аналіз. Аналіз буде завершено якнайшвидше';
$string['contactadmin'] = 'Зверніться до свого адміністратора, щоб завершити реєстрацію.';
$string['contactus'] = 'Зв\'яжіться з нами';
$string['contentfive'] = 'Автоматично виправляти застарілі теги HTML.';
$string['contentfour'] = 'Визначте, які види діяльності мають найбільші проблеми з доступністю, щоб визначити пріоритетність зусиль.';
$string['contentone'] = 'Автоматично оцінюйте вміст курсу та оцінки щодо проблем із доступністю.';
$string['contentsix'] = 'Своєчасно надавайте вчителям поради щодо створення кращого контенту.';
$string['contentthree'] = 'Надайте своїм студентам вміст у доступних форматах, включаючи аудіо, ePub та електронний шрифт Брайля.';
$string['contenttwo'] = 'Масове оновлення нечіткий або відсутній текст для веб-посилань, описів зображень і субтитрів відео.';
$string['contenttypeerrors'] = 'Загальні результати тестів змісту діяльності за курсом і за типом контенту.';
$string['contentyperesults'] = 'Загальна кількість успішних/нездалих для областей змісту на курс.';
$string['contextid'] = 'Контекст';
$string['core_course'] = 'Курс';
$string['core_question'] = 'Банки запитань';
$string['count'] = 'Рахувати';
$string['country'] = 'Країна';
$string['country_help'] = 'Країна сайту';
$string['coursecount'] = 'Кількість курсів';
$string['deletehistoricaldata'] = 'Видалити результати історичних перевірок';
$string['dependency'] = 'Залежить від';
$string['emptycategory'] = 'Не знайдено курсів для категорії {$a}';
$string['emptytagcourses'] = 'Не знайдено результатів для курсів із налаштованими тегами';
$string['enableaccessibilitytools'] = 'Увімкнути інструменти доступності';
$string['enableaccessibilitytools_desc'] = 'Набір інструментів доступності допомагає визначити проблеми доступності в курсах.';
$string['error:nocoursespecified'] = 'Для підсумкового звіту потрібен дійсний ідентифікатор курсу. Будь ласка, отримайте доступ до інструментарію доступності з курсу.';
$string['errorlink'] = 'Редагувати екземпляр помилки для {$a}';
$string['errors'] = 'Помилки: {$a}';
$string['errors:pluginname'] = 'Інструмент доступності списку помилок';
$string['errors:toolname'] = 'Підсумок списку помилок';
$string['errors:toolshortname'] = 'Список помилок';
$string['eventanalysis_requested'] = 'Запит на аналіз вмісту';
$string['eventanalysis_requesteddesc'] = 'Для курсу {$a} надіслано запит на аналіз вмісту.';
$string['eventreport_downloaded'] = 'Підсумок доступності завантажено';
$string['eventreport_downloadeddesc'] = 'Підсумок доступності завантажено для курсу {$a}.';
$string['eventreport_viewed'] = 'Звіт про доступність переглянуто';
$string['eventreport_vieweddesc'] = 'Було переглянуто звіт про доступність для курсу {$a->course}, ідентифікатор категорії {$a->category}, вкладка {$a->tab}.';
$string['failed'] = 'Не вдалося';
$string['failedcount'] = 'Не вдалося: {$a}';
$string['footerheading'] = 'Розділ нижнього колонтитула';
$string['fullcachedone'] = 'Вимкніть, щоб повторно запустити кешування';
$string['hashcorrect'] = 'Введений код правильний.';
$string['hashincorrect'] = 'Введений код неправильний.';
$string['headingfive'] = 'Виправлення HTML';
$string['headingfour'] = 'Сфокусувати зусилля';
$string['headingone'] = 'Оцініть зміст';
$string['headingsix'] = 'Підтримка продуктивності';
$string['headingthree'] = 'Доступні формати файлів';
$string['headingtwo'] = 'Санація';
$string['hideshow'] = 'Приховати/показати';
$string['icon:analytics-custom'] = 'Аналітика значок';
$string['icon:file-edit-custom'] = 'Значок редагування файлу';
$string['icon:hands-helping-custom'] = 'Значок руки допомоги';
$string['icon:search-plus-custom'] = 'Значок пошуку';
$string['icon:tools-custom'] = 'Значок інструментів';
$string['icon:wand-magic-custom'] = 'Чарівна паличка значок';
$string['inactive'] = 'Плагін неактивний і не може бути використаний. Введіть дійсні ключі реєстрації та натисніть «Активувати».';
$string['innercontextid'] = 'Внутрішній контекст';
$string['installed'] = 'Встановлено плагін';
$string['installedcli'] = 'Плагін встановлюється через командний рядок';
$string['installeddescription'] = 'Плагін встановлено, перенаправте на форму активації.';
$string['invalidaccessibilitytool'] = 'Запитано недійсний підплагін доступності.';
$string['invalidcategoryid'] = 'Недійсна категорія, перевірте введені дані';
$string['invalidcourseid'] = 'Недійсний курс, будь ласка, перевірте введені дані';
$string['invalidlinkphrases'] = 'click|click here|here|more|more here|info|info here|information|information here|read more|read more here|further information|further information here|further details|further details here';
$string['language'] = 'Мову';
$string['language_help'] = 'Мова сайту';
$string['messageprovider:warningcheckid'] = 'Попередження про недійсні перевірки';
$string['mobileservice'] = 'Мобільні послуги ввімкнено ({$a})';
$string['module'] = 'Модуль';
$string['modulename'] = 'Ім\'я';
$string['moreinfo'] = 'Більше інформації';
$string['newwindowphrases'] = 'new window|new-window|new_window';
$string['noerrorsfound'] = 'Для параметрів пошуку не знайдено поширених помилок доступності. Вітаю!';
$string['norecords'] = 'Не знайдено відповідних записів для параметрів пошуку.';
$string['notregistered'] = 'Ваш набір інструментів доступності потрібно зареєструвати.';
$string['notvalidated'] = 'Ваш набір інструментів доступності функціонує під час перевірки.';
$string['numcourses'] = 'Кількість курсів ({$a})';
$string['numfactivities'] = 'Кількість заходів ({$a})';
$string['numfiles'] = 'Кількість файлів ({$a})';
$string['numinstances'] = 'Кількість екземплярів';
$string['numusers'] = 'Кількість користувачів ({$a})';
$string['pagedesc:checktype'] = '<p>Щоб узагальнити та проаналізувати результати різних проведених перевірок, ми групуємо ці перевірки в різні типи вмісту. Отже, всі результати перевірки доступності, пов’язані з зображенням, знаходяться в групі типів вмісту «Зображення», всі результати перевірки доступності, пов’язаної з макетом, знаходяться в групі типів вмісту «Макет» тощо. </p><p>Діяльність включається як дії, ресурси або вміст області, що стосуються самих курсів. <p></p>Сторінка діаграми типів вмісту відображає розбивку помилок за групою типів вмісту: зображення, макет, посилання, медіа, таблиця та текст.</p>';
$string['pagedesc:pertarget'] = '<p>Щоб узагальнити та проаналізувати результати перевірки за діяльністю, ми групуємо ці результати перевірки в різні виявлені види діяльності.</p><p>Діяльність включається як діяльність, ресурси чи інші області вмісту, що стосуються самих курсів. Кожна дія без виявлених помилок вважається виконаною, кожна діяльність з однією чи кількома виявленими помилками вважається невдалою. </p><p>Потім відображається відношення пройдених і невдалих дій. На сторінці діаграми з розподілом активності відображається загальне співвідношення пройдених і невдалих екземплярів для кожної дії, як-от призначення, курс, мітка тощо.</p>';
$string['pagedesctitle:checktype'] = 'Пояснення типів вмісту';
$string['pagedesctitle:pertarget'] = 'Пояснення розподілу діяльності';
$string['passed'] = 'Виконано';
$string['passedcount'] = 'Виконано: {$a}';
$string['passrate'] = 'Прохідний рівень: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Кількість конкретних тестів і помилок на перевірку на курс.';
$string['perpage'] = 'Елементи для показу на сторінці';
$string['pluginname'] = 'Набір інструментів доступності';
$string['printable:downloadpdf'] = 'Завантажити PDF';
$string['printable:pluginname'] = 'Звіт про інструменти доступності підсумкового звіту';
$string['printable:printreport'] = 'Звіт для друку';
$string['printable:toolname'] = 'Зведений звіт';
$string['printable:toolshortname'] = 'Зведений звіт';
$string['privacy:metadata'] = 'Плагін звіту про перевірки доступності не зберігає жодних особистих даних.';
$string['processanalysisrequests'] = 'Обробляйте запити на аналіз контенту';
$string['registernow'] = 'Будь ласка, зареєструйтеся зараз.';
$string['registration'] = 'Реєстраційний формуляр';
$string['registrationinfo'] = '<p>Цей процес реєстрації дозволяє вам використовувати початкову версію інструментарію Brickfield для доступу до вашого зареєстрованого сайту Moodle. </p><p>Це використання регулюється умовами та положеннями <a href="{$a}" target="_blank">Brickfield Education Labs (відкривається в новому вікні)</a>, і з якими ви погоджуєтеся, використовуючи цей продукт.</p>';
$string['release'] = 'Реліз Moodle ({$a})';
$string['remaining'] = '(залишилося помилок: {$a})';
$string['response:0'] = 'Ця URL-адреса нікуди не вказує';
$string['response:404'] = 'Цю URL-сторінку не знайдено';
$string['schedule:blocknotscheduled'] = '<p>Цей курс ще не заплановано на аналіз, щоб знайти поширені проблеми доступності.</p>';
$string['schedule:notscheduled'] = '<p>Цей курс ще не заплановано для аналізу для виявлення поширених проблем із доступністю. </p><p>Натиснувши кнопку «Надіслати на аналіз», ви підтверджуєте, що хочете весь відповідний HTML-вміст курсу, наприклад описи розділів курсу, описи діяльності, запитання, сторінки , і багато іншого, які будуть заплановані для аналізу. </p><p>Цей аналіз проведе кілька загальних перевірок доступності HTML-вмісту вашого курсу, і ці результати потім відображатимуться на сторінках звітів про доступність інструментів. Аналіз оброблятиметься у фоновому режимі запланованими завданнями, тому швидкість його виконання буде залежати від часу виконання завдань та графіків виконання завдань.</p>';
$string['schedule:requestanalysis'] = 'Подати на аналіз';
$string['schedule:scheduled'] = 'Цей курс заплановано на аналіз.';
$string['schedule:sitenotscheduled'] = '<p>Глобальний (незалежний від курсу) вміст ще не заплановано для аналізу для виявлення поширених проблем із доступністю. </p><p>Натиснувши кнопку «Надіслати на аналіз», ви підтверджуєте, що хочете, щоб весь ваш відповідний глобальний (незалежний від курсу) вміст був запланований для аналізу .</p><p>Цей аналіз проведе кілька загальних перевірок доступності цього вмісту, і ці результати потім відображатимуться на сторінках звітів про доступність інструментів. Аналіз оброблятиметься у фоновому режимі запланованими завданнями, тому швидкість його виконання буде залежати від часу виконання завдань та графіків виконання завдань.</p>';
$string['schedule:sitescheduled'] = 'Глобальний (незалежний від курсу) вміст заплановано на аналіз.';
$string['secretkey'] = 'Ключ API';
$string['secretkey_help'] = 'Цей код надходить на електронну пошту після реєстрації.';
$string['sendfollowinginfo'] = '<p>Наведена нижче інформація буде періодично надсилатися лише для внесення до загальної статистики. Це не буде оприлюднено в жодному центральному списку. </p>{$a}';
$string['settings'] = 'Налаштування набору інструментів доступності';
$string['sitehash'] = 'Секретний ключ';
$string['sitehash_help'] = 'Цей код надходить на електронну пошту після реєстрації.';
$string['taberrors'] = 'Перевірте помилки';
$string['targetavetitle'] = 'Середня кількість помилок за дію';
$string['targetpercentage'] = 'Відсоток пройдених/не пропущених екземплярів за дію';
$string['targetratio'] = 'Коефіцієнт проходження діяльності';
$string['tblcheck'] = 'Перевірте';
$string['tblcheckexample'] = 'Приклад';
$string['tblcheckfailed'] = 'Не вдалося перевірити';
$string['tblchecksummary'] = 'Резюме';
$string['tbledit'] = 'Редагувати';
$string['tblerrorcount'] = 'Помилки';
$string['tblhtmlcode'] = 'Існуючий HTML-код';
$string['tblinstance'] = 'Примірник';
$string['tblline'] = 'Лінія';
$string['tbloverallpercentage'] = 'Загальні помилки %';
$string['tblpercentage'] = 'Відсоток';
$string['tblpreview'] = 'Попередній перегляд';
$string['tbltarget'] = 'Діяльність';
$string['tblupdateto'] = 'Оновити до';
$string['titleactivityresultsall'] = 'Результати за діяльністю: усі переглянуті курси ({$a->count} курси)';
$string['titleactivityresultspartial'] = 'Результати за діяльністю: курс {$a->name}';
$string['titleall'] = 'Деталі помилки: усі переглянуті курси (курси {$a->count})';
$string['titlechecktyperesultsall'] = 'Результати за типом вмісту: усі переглянуті курси ({$a->count} курси)';
$string['titlechecktyperesultspartial'] = 'Результати за типом вмісту: курс {$a->name}';
$string['titleerrorsall'] = 'Деталі помилки: усі переглянуті курси (курси {$a->count})';
$string['titleerrorscount'] = 'Деталі помилки: (показано перші {$a} помилки)';
$string['titleerrorspartial'] = 'Деталі помилки: курс {$a->name}';
$string['titlepartial'] = 'Деталі помилки: курс {$a->name}';
$string['titleprintableall'] = 'Курс {$a->name}';
$string['titleprintablepartial'] = 'Курс {$a->name}';
$string['tools'] = 'Звіти';
$string['toperrors'] = 'Основні помилки';
$string['toptargets'] = 'Невдалі дії';
$string['totalactivities'] = 'Загальна діяльність';
$string['totalactivitiescount'] = 'Загальна кількість заходів: {$a}';
$string['totalareas'] = 'Загальні площі';
$string['totalerrors'] = 'Сумарні помилки';
$string['totalgrouperrors'] = 'Загальна кількість (сума) помилок за типом вмісту';
$string['updatesummarydata'] = 'Оновити підсумкові дані сайту';
$string['usersmobileregistered'] = 'Кількість користувачів із зареєстрованими мобільними пристроями ({$a})';
$string['validationerror'] = 'Не вдалося перевірити ключ реєстрації. Перевірте правильність URL-адреси та ключів вашого зареєстрованого сайту.';
$string['warningcheckidbody'] = 'Виникла проблема з перевіркою Brickfield, яка активна, але не вказана в базі даних. Будь ласка, дослідіть.';
$string['warningcheckidsubject'] = 'Попередження перевірки ідентифікатора Brickfield Toolkit';
