<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'sv', version '4.1'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'Moodle är gratis att ladda ner och registrering är frivilligt, så vi har inte fullständig information om alla som använder den. Men, med hjälp av det vi vet genererar vi automatiskt intressanta grafer och siffror på vår Statistiksida.';
$string['aboutstatisticsheading'] = 'Moodlestatistik';
$string['aboutstatisticstitle'] = 'Moodle.org: Moodlestatistik';
$string['activeusers24hours'] = 'Inloggade användare under de senaste 24 timmarna:';
$string['activeuserspastmonth'] = 'Inloggade användare under den senaste månaden:';
$string['browsegittitle'] = 'Titta på vår källkod';
$string['cachedef_frontpagecolumn'] = 'Startsidekolumner';
$string['cachedef_usefulposts'] = 'Föreslagna inlägg';
$string['communities'] = 'Intressegrupper';
$string['communitiesmy'] = 'Mina intressegrupper';
$string['community'] = 'Intressegrupp';
$string['communityadministration'] = 'Administrera intressegrupp';
$string['communitycurrent'] = 'Aktuell intressegrupp';
$string['communityenrolme'] = 'Bli medlem i denna intressegrupp';
$string['communityenrolmentoptions'] = 'Gå med i en intressegrupp';
$string['communityintro'] = 'Moodle har en stor och mångsidig användargemenskap med över <a href="http://moodle.org/userpics">{$a->usercount} registrerade användare</a> bara på denna Moodle webbplats och som talar över <a href="http://download.moodle.org/langpack/">{$a->langcount} språk</a> i <a href="http://moodle.org/http://moodle.org/sites">{$a->countrycount} länder</a> (här finns <a href="http://moodle.org/stats">mer statistik</a>).';
$string['communityjoinbyyourself'] = 'Gå med';
$string['communityjoinbyyourselfas'] = 'Gå med som {$a->rolename}';
$string['communitynoguestaccess'] = 'Gäster kan inte gå till detta intresseområde. Vänligen försök logga in.';
$string['communitynotenrollable'] = 'Du kan inte på egen hand bli medlem i denna gemenskap. Vänligen kontakta moderatorn.';
$string['communitysomeallowguest'] = 'Vissa intressegrupper kan tillåta gäståtkomst';
$string['communityunenrolme'] = 'Lämna intressegruppen {$a}';
$string['conferencecenter'] = 'Moodle konferenscenter';
$string['connectedsites'] = 'Vissa Moodle-webbplatser har anslutits till moodle.org genom Moodle-nätverket, så att du kan logga in där direkt när du väl är autentiserad här.';
$string['donations10over'] = 'Övriga donationer på $10 och mer';
$string['donationsassociation'] = 'Gå med i <a href="https://moodleassociation.org/">Moodle Organisationen</a> - Var med och bestäm hur medlemsavgifterna ska användas i Moodles utvecklingsplan';
$string['donationsdevelopment'] = 'Utvecklingen av Moodle och underhåll av alla våra community-webbplatser kostar mycket pengar och vi välkomnar gärna extra stöd. Om du älskar Moodle eller tycker det är användbart för ditt företag, skola eller institution, vänligen gör en donation. Varje bidrag hjälper.';
$string['donationsdonatenow'] = 'Donera nu';
$string['donationsensure'] = 'Donationer säkerställer att de väsentliga kuggarna i Moodle Machine (våra utvecklare) fortsätter att skapa nya funktioner och fixa buggar, vilket gör Moodle bättre för oss alla.';
$string['donationsmoodle'] = 'Donera till Moodle';
$string['donationsopensource'] = 'Moodle är i sanning öppen källkod och helt fri från ekonomiska åtaganden för våra användare - det är så programvara ska vara!';
$string['donationsover1000'] = 'Tidigare donationer över $1000';
$string['donationsover200'] = 'Övriga donationer över $200';
$string['donationsover500'] = 'Övriga donationer över $500';
$string['donationspartner'] = 'Utnyttja tjänster från en <a href="https://moodle.com/partners/">certifierad Moodlepartner</a> -10% av deras intäkter går till Moodleprojektet.';
$string['donationsshop'] = 'Köp något från vår <a href="http://www.zazzle.com/moodle_hq/">Moodle shop</a> och använd det med stolthet!';
$string['donationsthankeveryone'] = 'Tack till alla som bidragit till Moodleprojektet';
$string['donationsthankyou'] = 'Tack';
$string['donationstitle'] = 'Donationer';
$string['donationsways'] = 'Andra sätt att bidra finansiellt till Moodle:';
$string['download_activities'] = 'Aktiviteter';
$string['download_admintools'] = 'Administratörsverktyg';
$string['download_appdocumentation'] = 'Produktdokumentation';
$string['download_appreleasenotes'] = 'Versionsinformation';
$string['download_browseall'] = 'Sök alla';
$string['download_downloadosx'] = 'Hämta Moodle för OS X (Innehåller Moodle, Apache, MySQL samt PHP för Mac OS)';
$string['download_downloadwindows'] = 'Hämta Moodle för Windows (Innehåller Moodle, Apache, MySQL samt PHP för Windows)';
$string['download_forandroid'] = 'För Android';
$string['download_forios'] = 'För iOS';
$string['download_helpbox_description'] = 'Läs dokumentationen för att komma igång eller besöka våra forum. Eller så kan du helt enkelt ta kontakt med en Moodlepartner för hjälp med hosting, installation eller andra tjänster.';
$string['download_helpbox_installing'] = 'Installera Moodle';
$string['download_helpbox_partners'] = 'Moodle Partners';
$string['download_helpbox_support'] = 'Supportforum';
$string['download_helpbox_title'] = 'Behöver du hjälp?';
$string['download_helpbox_upgrading'] = 'Uppgradera Moodle';
$string['download_hero_description'] = 'Den licensieras under <a class="link" href="http://docs.moodle.org/dev/License">GPL</a> vilket innebär att den är fri att använda.<br><br>Få mer information om den senaste Moodle-versionen.';
$string['download_hero_headline'] = 'Moodle bygger på öppen källkod.';
$string['download_langpackinfo'] = 'Språkpaket genereras automatiskt från de bidrag översättarna gör på <a href="http://lang.moodle.org/">Webbplatsen för översättningar</a>. För ytterligare detaljer, se <a href="https://docs.moodle.org/dev/Translation">Översättardokumentationen</a>.';
$string['download_langpackinstallinfo'] = 'Ytterligare språkpaket kan installeras på din Moodle-webbplats via <em>Hantera webbplats &#10132; Språk &#10132; Språkpaket</em> eller manuellt. För mer information, se <a href="https://docs.moodle.org/en/Language_packs">Dokumentation för språkpaket</a>.';
$string['download_langpackinstalltitle'] = 'Installera språkpaket';
$string['download_langpacktitle'] = 'Språkpaket för Moodle {$a}';
$string['download_mobileapp'] = 'Mobilapp';
$string['download_themes'] = 'Teman';
$string['download_viewallbuilds'] = 'Visa alla byggen (Kräver en webbserver, PHP samt en databas för att köra)';
$string['downloadcore'] = 'Vår huvudsakliga metod för distribution är via dessa baspaket. De innehåller ett antal moduler som underhålls av utvecklare och är enkla att installera på nästan alla plattformar där du har PHP och en databas som redan är installerad.';
$string['downloadcoretitle'] = 'Standardpaket i Moodle';
$string['downloadintro'] = 'Moodle tillhandahålls som öppen källkod under <a href="http://docs.moodle.org/dev/License">GPL-licens</a>. Allt vi producerar finns tillgängligt för fri nedladdning och användning.';
$string['downloadlang'] = 'I aktuella versioner av Moodle har stöd för nya språk automatiserats via administrationsmenyn på webbplatsen.  Men för vissa äldre versioner av Moodle måste nya språkpaket laddas ner manuellt.';
$string['downloadlangtitle'] = 'Språkpaket';
$string['downloadmac'] = 'Om du inte redan har konfigurerat en webbserver gör dessa allt-i-ett-paket det mycket enkelt att installera Moodle på alla Apple-datorer som kör Mac OS X.';
$string['downloadmactitle'] = 'Moodle för Mac OS X';
$string['downloadmodules'] = 'Bläddra igenom vår omfattande databas med extra moduler och plugins som kan läggas till på din Moodle-webbplats för att ge den extra funktionalitet utöver kärnpaketen.';
$string['downloadmodulestitle'] = 'Pluginmoduler';
$string['downloadthemes'] = 'Utseendet på en Moodle-webbplats kan ändras radikalt genom att använda ett annat tema.  Vi underhåller en databas med teman som Moodle-användare har skapat och delat.';
$string['downloadthemestitle'] = 'Teman';
$string['downloadviagitcvs'] = 'Andra sätt att få tillgång till Moodle är genom att <a href="http://docs.moodle.org/en/Git_for_Administrators">ladda ned från Git</a> eller <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">från CVS</a>.';
$string['downloadwin'] = 'Om du inte redan har konfigurerat en webbserver gör dessa allt-i-ett-paket det mycket enkelt att installera Moodle på alla datorer som kör Microsoft Windows.';
$string['downloadwintitle'] = 'Moodle för Windows';
$string['erroradminonly'] = 'Endast administratörer kan komma åt det här gränssnittet.';
$string['erroralreadyvoted'] = 'Du har redan röstat för {$a}';
$string['errormaxmessages'] = 'Du kan tyvärr inte skicka fler än 3 meddelanden';
$string['errornomainnews'] = 'Kunde inte hitta eller skapa ett huvudforum för webbplatsen';
$string['errorsendingmail'] = 'Ett fel uppstod när meddelandet skickades. Försök igen senare eller kontakta webbplatsadministratören.';
$string['eventdonation_created'] = 'Donationslista skapad';
$string['eventdonation_submitted'] = 'Donation gjord';
$string['events'] = 'Även om vi specialiserar oss på online-lärande är det fortfarande trevligt att träffas i ett riktigt rum!  Besök dessa länkar för mer information om våra konferenser (vi kallar dem MoodleMoots) och andra evenemang.';
$string['eventstitle'] = 'Händelser';
$string['feed_events'] = 'Händelser';
$string['feed_events_more'] = 'Fler händelser';
$string['feed_news'] = 'Nyheter';
$string['feed_news_more'] = 'Visa alla';
$string['feed_resources'] = 'Resurser';
$string['feed_useful'] = 'Föreslagna inlägg';
$string['feed_useful_more'] = 'Fler inlägg';
$string['focusbox_community'] = 'Support och samarbetsforum';
$string['focusbox_community_text'] = 'Få support och dela med dig av idéer på ditt språk.';
$string['focusbox_community_viewall'] = 'Alla samarbetsforum';
$string['focusbox_future'] = 'Var med och forma Moodles framtid';
$string['focusbox_future_crowdfund'] = 'Gräsrotsfinansierade projekt';
$string['focusbox_future_gdf'] = 'Utvecklardiskussioner';
$string['focusbox_future_research'] = 'Moodle-forskning';
$string['focusbox_future_roadmap'] = 'Utvecklingsplan';
$string['focusbox_future_text'] = 'Se vad som är på gång och bidra till att göra skillnad.';
$string['focusbox_future_ux'] = 'Diskutera Moodles användargränssnitt (UX)';
$string['focusbox_settingup'] = 'Konfigurera';
$string['focusbox_settingup_community'] = 'Gemenskapssupport';
$string['focusbox_settingup_download'] = 'Gratis nedladdning';
$string['focusbox_settingup_hosting'] = 'Hosting';
$string['focusbox_settingup_install'] = 'Installation';
$string['focusbox_settingup_own'] = 'Gör det själv';
$string['focusbox_settingup_partner'] = 'Med hjälp av en Moodlepartner';
$string['focusbox_settingup_plugins'] = 'Pluginmoduler';
$string['focusbox_settingup_support'] = 'Kommersiell support';
$string['focusbox_teaching'] = 'Undervisa med Moodle';
$string['focusbox_teaching_books'] = 'Böcker';
$string['focusbox_teaching_courses'] = 'Kurser och innehåll';
$string['focusbox_teaching_docs'] = 'Dokumentation';
$string['focusbox_teaching_text'] = 'Utforska Moodles breda utbud av funktioner och resurser.';
$string['focusbox_theproject'] = 'Moodleprojektet';
$string['focusbox_theproject_about'] = 'Om Moodle';
$string['focusbox_theproject_devs'] = 'Utvecklare';
$string['focusbox_theproject_hq'] = 'Moodle HQ';
$string['focusbox_theproject_mua'] = 'Moodle användarorganisation';
$string['focusbox_theproject_partners'] = 'Moodlepartners';
$string['focusbox_theproject_stats'] = 'Statistik';
$string['focusbox_theproject_text'] = 'Läs mer om Moodle-projektet och våra öppna samarbeten och partnerskap.';
$string['focusbox_uptodate'] = 'Håll dig uppdaterad';
$string['focusbox_uptodate_buzz'] = 'Moodle-snack';
$string['focusbox_uptodate_news'] = 'Nyheter';
$string['focusbox_uptodate_planet'] = 'Planet Moodle';
$string['focusbox_uptodate_security'] = 'Säkerhetsnyheter';
$string['focusbox_uptodate_social'] = 'Sociala media';
$string['focusbox_uptodate_text'] = 'Senaste Moodlenyheter, uppdateringar och insikter från hela världen.';
$string['generaldeveloperforum'] = 'Allmänna utvecklarforum';
$string['graphpopulation'] = 'Moodle befolkningsgraf';
$string['graphregistrationmap'] = 'Moodle - karta över registreringar';
$string['graphregistrationmapdesc'] = 'Tio i topp för registrerade sajter i {$a} länder.';
$string['graphusersites'] = 'Moodleanvändare per webbplats';
$string['heroslide_community_description'] = 'Välkommen till Moodlegemenskapen och upptäck värdet hos ett öppet, gemensamt initiativ från en av de största öppna källkods-grupperna i världen.';
$string['heroslide_community_headline'] = 'Drivs av gemenskap, med globalt stöd';
$string['heroslide_community_slidecontrol'] = 'Stöds av en global gemenskap';
$string['heroslide_donate_headline'] = 'Hjälp oss att göra skillnad med öppen och kvalitativ utbildning för alla';
$string['heroslide_getstarted40_description'] = 'Moodle LMS har en ny personlighet och en omdefinierad användarupplevelse som förbättrar onlineundervisning och lärande för lärare, elever och administratörer.';
$string['heroslide_getstarted40_headline'] = 'Moodle 4.0 - Nytt utseende och bättre användarupplevelse!';
$string['heroslide_getstarted40_slidecontrol'] = 'Moodle 4.0 är här!';
$string['heroslide_getstarted_description'] = 'Moodle är världens mest populära system för hantering av lärande. Börja skapa din utbildningswebb på några minuter!';
$string['heroslide_getstarted_headline'] = 'Att börja är lätt';
$string['heroslide_getstarted_slidecontrol'] = 'Börja idag';
$string['heroslide_global_description'] = 'Moodle finns tillgängligt på mer än 100 språk och är betrott av organisationer och institutioner, stora som små, med miljontals användare världen över.';
$string['heroslide_global_headline'] = 'Driver lärmiljöer världen över';
$string['heroslide_global_slidecontrol'] = 'Driver lärmiljöer världen över';
$string['heroslide_link_demo'] = 'Demo';
$string['heroslide_link_donate'] = 'Donera';
$string['heroslide_link_features'] = 'Funktioner';
$string['heroslide_link_forums'] = 'Samarbetsforum';
$string['heroslide_link_getstarted'] = 'Börja idag';
$string['heroslide_link_getstarted40'] = 'Få mer information om Moodle 4.0';
$string['heroslide_link_sites'] = 'Registrerade webbplatser';
$string['heroslide_link_stats'] = 'Statistik';
$string['heroslide_link_stories'] = 'Läs mer';
$string['heroslide_power40_description'] = 'Enkelt, snabbt och intuitivt! Utforska den förbättrade användarupplevelsen och de nya funktionerna i Moodle 4.0.';
$string['heroslide_power40_headline'] = 'Upplev Moodle 4.0';
$string['heroslide_power40_slidecontrol'] = 'Upplev Moodle 4.0';
$string['heroslide_power_description'] = 'Världens kostnadsfria lärplattform som hjälper dig att skapa effektiva online-miljöer för undervisning och lärande i en samarbetsinriktad, privat miljö.';
$string['heroslide_power_headline'] = 'Kraftfull. Säker. Öppen källkod.';
$string['heroslide_power_slidecontrol'] = 'Robust lärplattform med öppen källkod';
$string['heroslide_story1_description'] = '"Genom att leda i teknikaktiverat lärande kan vi underlätta studenternas upptäckande, kreativitet och möjligheter." - Professor Darrell Evans, Pro Vice-Chancellor (Lärande och Undervisande), Monash University';
$string['heroslide_story1_headline'] = 'Förbättrar undervisande och lärande överallt';
$string['heroslide_story2_description'] = 'Den globala leverantören av sjöfarts-, logistik- och marina tjänster, GAC, levererar utbildnings- och utvecklingsinitiativ till över 10 000 anställda i över 70 länder med sin Företagsakademi.';
$string['heroslide_story2_headline'] = 'Uppnå excellens inom företagsinlärning';
$string['heroslide_story3_description'] = 'Forth Valley College är en av Skottlands största högskolor och levererar mer än 750 kurser med över 20 000 aktiva användare på sina webbplatser.';
$string['heroslide_story3_headline'] = 'Tillhandahåller allsidig flexibel utbildning';
$string['heroslide_story4_description'] = 'Voluntary Service Overseas (VSO) levererar interaktivt lärande och stöd till volontärer internationellt för att möjliggöra globala utbildningsstrategier.';
$string['heroslide_story4_headline'] = 'Hjälper volontärer genomföra program för att bekämpa fattigdom';
$string['heroslide_story5_description'] = '';
$string['heroslide_story5_headline'] = '';
$string['heroslide_story_slidecontrol'] = 'Moodleberättelser från hela världen';
$string['jobs'] = 'Besök vår jobbdatabas för information om Moodle-relaterade tjänster över hela världen.';
$string['logoinfo'] = 'Namnet Moodle™ är ett registrerat varumärke som tillhör Moodle Trust.

Om du tänker använda namnet och:eller logotypen för att annonsera om generella Moodle-tjänster (t.ex. Moodle hosting, Moodle-support, Moodle-certifiering, Moodle-utbildning, Moodle-konsultation, Moodle-anpassning, Moodle-kursutveckling, Moodle-temadesign, Moodle-integrationer, Moodle-installationer etc.) eller som namnet på ett mjukvarupaket måste du söka och få direkt tillstånd skriftligen från Moodle Trust via [moodle.com helpdesk](http://moodle.com/helpdesk/), i enlighet med  efertsgna varumärkesbegränsningar.

Det finns inga begränsningar för hur du använder namnet i andra sammanhang (om du till exempel använder Moodle bara för att tillhandahålla kurser kan du använda namnet fritt för att referera till det.) Om du inte är säker i ett visst fall, fråga oss via [moodle.com helpdesk](http://moodle.com/helpdesk/). Vi ger dig gärna officiellt tillstånd skriftligen eller hjälper dig att fixa din formulering.';
$string['logotitle'] = 'Moodlelogotyp';
$string['manageads'] = 'Hantera partnerannonser';
$string['managedonations'] = 'Hantera donationer';
$string['moodleorg:manageads'] = 'Hantera partnerannonser';
$string['moodleorg:managedonations'] = 'Hantera donationsregistret';
$string['moodlepartner_corporate'] = 'Företagsutbildningar';
$string['moodlepartner_other'] = 'Övriga sektorer';
$string['moodlepartner_school'] = 'Skola';
$string['moodlepartner_university'] = 'Universitet';
$string['networkinfo'] = 'Följande Moodle-webbplatser har anslutits till moodle.org via nätverkstjänster i Moodle. Du kan ligga in på dem direkt härifrån.';
$string['networktitle'] = 'Anslutna webbplatser';
$string['newregistrations'] = 'Nya registreringar';
$string['newstitle'] = 'Meddelanden';
$string['noenrolledcoursesyet'] = 'Du är inte registrerad på några kurser ännu';
$string['partnerslogan'] = 'Moodleprojektet stöds av mer än 90 certifierade <a href="https://moodle.com/partners/">Moodle Partners</a> globalt.';
$string['permalink'] = 'Permalänk';
$string['pluginname'] = 'Moodle.org webbplats';
$string['popularissues'] = 'Populäraste ämnena';
$string['privacy:metadata:db:registerdonations'] = 'Lagrar poster med Moodledonationer';
$string['privacy:metadata:db:registerdonations:amount'] = 'Donerat belopp';
$string['privacy:metadata:db:registerdonations:name'] = 'Donatornamn';
$string['privacy:metadata:db:registerdonations:org'] = 'Donatororganisation';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'Tidpunkt för donation';
$string['privacy:metadata:db:registerdonations:url'] = 'Donator-URL';
$string['recentlyratedposts'] = 'Nyligen bedömda inlägg';
$string['recentpart'] = 'Den här sidan visar några av de som använder moodle.org idag.';
$string['registeredsites'] = 'Institutioner är inte skyldiga att informera någon när de använder Moodle, eftersom Moodle är öppen källkod. Vissa Moodle-webbplatser har dock valt att registrera sig hos oss och vi underhåller en lista över dem.';
$string['registeredsitestitle'] = 'Registrerade webbplatser';
$string['registereduserslastday'] = 'Nya användare under de senaste 24 timmarna:';
$string['registereduserstotal'] = 'Totalt antal registrerade användare:';
$string['registrationgraphalt'] = 'Samtliga registreringar över tid';
$string['registrationgraphdesc'] = 'Vi genomför <a href="http://docs.moodle.org/en/Usage">regelbundna kontroller av webbplatser</a> för att försäkra oss om att de fortfarande existerar, så ibland sjunker antalet';
$string['registrationslast6months'] = 'Registreringar under de senaste 6 månaderna';
$string['registrationslastmonths'] = 'Registreringar under de senaste {$a} månaderna';
$string['registrationstotal'] = 'Alla tidigare registreringar';
$string['resources_buzz'] = 'Snack';
$string['resources_courses'] = 'Kurser';
$string['resources_jobs'] = 'Jobb';
$string['resources_plugins'] = 'Pluginmoduler';
$string['roadmap'] = 'Utvecklingsplan för Moodle';
$string['rssdescription'] = 'Nyliga eller intressanta foruminlägg från moodle.org';
$string['rssmoodlecommore'] = 'Se alla senaste nyheter';
$string['rssmoodlecomtitle'] = 'Senaste nytt';
$string['rsstitle'] = 'Inlägg i Moodle-forum';
$string['searchmoodleorg'] = 'Sök på moodle.org';
$string['securitytitle'] = 'Säkerhetsmeddelanden';
$string['shop'] = 'Letar du efter något sätt att visa att du är en del av vår gemenskap?  Besök vår butik för att köpa skjortor, muggar och alla möjliga andra saker.';
$string['social-facebook-moodle'] = 'Officiell Moodlesida på Facebook';
$string['social-googleplus-community'] = 'Officiell Moodlegrupp på Google+';
$string['social-googleplus-moodle'] = 'Officiell Moodlesida på Google+';
$string['social-linkedin-moodle'] = 'Officiell Moodlesida på LinkedIn';
$string['social-twitter-moodle'] = 'Officiella Moodle-meddelanden, aggregerade Moodle-nyheter från Planet Moodle och Moodle buzz och användbara foruminlägg';
$string['social-twitter-moodledev'] = 'Nyheter om utveckling och uppdateringar';
$string['social-twitter-moodlehq'] = 'Tweets från Moodle HQ';
$string['social-twitter-moodlejobs'] = 'Moodle-relaterade jobberbjudanden';
$string['social-twitter-moodlenet'] = 'Delade Moodlekurser och innehåll';
$string['social-twitter-moodleplugins'] = 'Nyligen släppta Moodle-tillägg';
$string['social-twitter-moodleresearch'] = 'Nyheter och uppdateringar om den årliga Moodle Research-konferensen och Moodle-relaterad forskning';
$string['social-twitter-moodlesecurity'] = 'Moodle säkerhetsmeddelanden';
$string['social-twitter-moodlesites'] = 'Statusuppdateringar från Moodle HQs nätverk av webbplatser och tjänster';
$string['social-twitter-moodlethemes'] = 'Nyligen släppta Moodle-teman';
$string['social-youtube-moodle'] = 'Officiell Moodlekanal på YouTube';
$string['socialinfo'] = 'Vi finns på flera sociala medier för att öka medvetenheten om Moodle-projektet och dela de senaste nyheterna och händelser i Moodle-världen. Följ oss för att hålla dig uppdaterad och träffa andra i gemenskapen.';
$string['socialtitle'] = 'Sociala media';
$string['statscountries'] = 'Länder';
$string['statscourses'] = 'Kurser';
$string['statsenrolments'] = 'Kursregistreringar';
$string['statsposts'] = 'Foruminlägg';
$string['statsquestions'] = 'Frågor';
$string['statsresources'] = 'Resurser';
$string['statsteachers'] = 'Lärare';
$string['statsusers'] = 'Användare';
$string['supportbooks'] = 'Vi underhåller en lista över många Moodleböcker som finns till försäljning.';
$string['supportcommercial'] = 'Moodlepartners och certifierade tjänsteleverantörer som kan hjälpa dig implementera Moodle i din organisation.';
$string['supportdocs1'] = 'Moodle Docs är ett perfekt ställe att börja på, i synnerhet våra sidor med ofta ställda frågor (FAQ).';
$string['supportdocs2'] = 'Ett trevligt sätt att komma åt relevant dokumentation är att använda länken "Moodle-dokumentation för den här sidan" längst ner på varje sida på din egen Moodle-webbplats.';
$string['supportdocsfaq'] = 'Vanliga frågor och svar';
$string['supportdocslang'] = 'Moodledokumentation på andra språk';
$string['supportforums'] = 'Vår gemenskap för användare kommunicerar för det mesta via forum inne i "kurser" på den här Moodle-baserade webbplatsen. Du måste "registrera" Dig på kursen för att kunna göra inlägg i forum (registrering är helt frivilligt).';
$string['supportforumsenglish'] = 'De viktigaste, mest stödjande och informativa diskussionerna mellan användare och utvecklare hittar Du här:';
$string['supportforumsenglishname'] = 'Att använda Moodle';
$string['supportforumslang'] = 'Det viktigaste forumet för att lära känna moodlare på engelska är här:';
$string['supportforumslangname'] = 'Moodles lounge';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'Vi har många andra forum också, på många språk:';
$string['supportforumslistname'] = 'Lista över alla kurser';
$string['supportintro'] = 'Du är inte ensam! Det finns ett antal olika sätt att få hjälp med Moodle om Du behöver det.';
$string['syncregistrationstask'] = 'Synkronisera 1.9-webbplatsuppdateringar med moodle.net';
$string['top10countriesbyregistration'] = 'Tio i topp för registrerade länder';
$string['top10sitesbycourses'] = 'De 10 största webbplatserna räknat i kurser';
$string['top10sitesbyusers'] = 'De 10 största webbplatserna räknat i användare';
$string['url-about'] = 'http://docs.moodle.org/sv/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/sv/Features';
$string['url-install'] = 'http://docs.moodle.org/sv/Installation';
$string['url-standards'] = 'http://docs.moodle.org/sv/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/sv/';
$string['versionsused'] = 'Använda versioner';
