<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_coursemanager', language 'sr_cr', version '4.1'.
 *
 * @package     report_coursemanager
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admin_course_managerinfo'] = '<p>Ова страница даје приступ алату за Moodle администраторе. ЗА подешавања \'Менаџера курсева\', идите на Додаци > Извештаји > Менаџер курсева.</p>';
$string['admin_files_distribution_info'] = '<p>Овај алат даје извештај о различитим компонентама у складишту датотека и укупној величини за сваку од компоненти.</p>';
$string['admin_no_teacher_courses_info'] = '<p>Овај алат наводи све курсеве на којима ниједан корисник није уписан као предавач и евентуално их премешта у категорију \'Отпаци\' ако је to потребно.</p>';
$string['admin_orphan_submissions_info'] = '<p>Напуштени предати радови су датотеке које су предали полазници, који више нису уписани на курс.
 <b>Те датотеке су за предаваче невидљиве и могу се видети само ако се полазници поново упишу на курс.</b> Уколико се сваке године користе исти задаци без ресетовања, ове скривене датотеке
 могу заузети велики простор у вашам moodledata директоријуму.<br />
 Овај алат може обрисати ове скривене датотеке <b>без брисања датотека које су предали студенти који су још увек уписани на курс.<b></p>';
$string['admin_stats_info'] = '<p>Ова страница приказује статистику која је углавном заснована на извештајима које дају додатак Менаџера курсева. Такође, страница пружа статистику и о неколико аспеката који се тичу функција Менаџера курсева, као што су курсеви без предавача или курсеви у категорији \'Отпаци\'.</p>';
$string['adminnoteachercoursesnote'] = '<ul class="alert alert-info"><li>Информације о величини курса и броју активности се не израчунавају у реалном времену.</li>
<li>Информације о последњем запису предавача заснивају се на пољу edulevel у табели базе података logstore. Измењена овлашћења могу да искриве овај резултат.</li></ul>';
$string['adminnoteachercoursesweight'] = '<ul class="alert alert-warning"> Задатак за израчунавање величине је активиран. Курсеви за које величина још није израчуната неће се појавити на овом списку. Ако је потребно, покрените задатак ручно или сачекајте следеће покретање крона.';
$string['advices_for_course'] = 'препоруке';
$string['aggregationaverage'] = 'просек';
$string['aggregationboth'] = 'и просек и медијана';
$string['aggregationchoice'] = 'Изаберите начин за поређење величине курса';
$string['aggregationchoice_desc'] = 'Ако је омогућено поређење величине курса, оно може бити базирано на просечној величини или вредности медијане.';
$string['aggregationmedian'] = 'медијана';
$string['all_courses'] = 'Сви курсеви';
$string['assignwithgroups'] = 'Овај задатак је подешен на групни режим па се не може ресетовати помоћу Менаџер курсева';
$string['button_delete_cohort_confirm'] = 'Поништи упис кохорти';
$string['button_move_confirm'] = 'Потврди брисање';
$string['button_restore_confirm'] = 'Потврди рестаурацију курса';
$string['button_save_course'] = 'Резервна копија курса';
$string['button_save_questionbank'] = 'Резервна копија банке питања';
$string['capability_problem'] = 'Немате овлашћење да видите ову страницу.';
$string['category_bin'] = 'Категорија за отпатке';
$string['category_bin_desc'] = 'Ако предавач обрише курс преко контролног панела, он се премешта у ову категорију пре него што га администратор дефинитивно не обрише.';
$string['closereportmodal'] = 'Затвори прозор';
$string['collapse_show_report'] = 'Прикажи извештај';
$string['comment'] = 'Препоруке';
$string['configmenuactions'] = 'Мени са акцијама';
$string['configmenuactions_desc'] = 'Изаберите акције које ће бити приказане у менију са акцијама на контролном панелу.';
$string['configtitle'] = 'Подешавања \'Менаџера курсева\'';
$string['confirm_cohort_unenrolled_message'] = 'Све кохорте су исписане са курса.';
$string['confirm_cohort_unenrolled_title'] = 'Кохорте обрисане';
$string['confirm_course_deleted_message'] = 'Курс је премештен у категорију \'Отпаци\' и касније ће га oбрисати администратор';
$string['confirm_course_deleted_title'] = 'Курс обрисан';
$string['confirm_course_restored_message'] = 'Курс је измештен из категорије \'Отпаци\'. Имајте на уму да је рестаурирани курс још увек скривен за полазнике, па сходно томе размислите о промени подешавања ако је потребно.';
$string['confirm_course_restored_title'] = 'Курс рестауриран';
$string['course_alert_empty'] = 'Овај курс нема садржајa, осим евентуално изворног форума. Размислите о брисању овог курса ако се више не користи.<br /><b>{$a->delete_link}</b>';
$string['course_alert_heavy'] = 'Укупна величина датотека у овом курсу је заправо <b>{$a->size} Mo (мегаоктета)</b>. Размислите о сортирању датотека или ресетовању овог курса.<br /><b>{$a->heavy_link}</b';
$string['course_alert_no_student'] = '<b>Ниједан полазник није уписан на овај курс</b>. Размислите о брисању овог курса ако се више не користи.<br /><b>{$a->delete_link}</b>';
$string['course_alert_no_visit_student'] = 'Ниједан полазник није посетио овај курс више од {$a->no_teacher_time} дана. Размислите о брисању овог курса ако се више не користи.<br /><b>{$a->delete_link} | {$a->reset_link}</b>';
$string['course_alert_no_visit_teacher'] = 'Ниједан предавач није посетио овај курс више од {$a->no_teacher_time} дана. Размислите о брисању овог курса ако се више не користи.<br /><b>{$a->delete_link}</b>';
$string['course_alert_orphan_submissions'] = 'Овај курс садржи задатке са невидљивим предатим радовима, које су поставили исписани полазници. Молимо размислите о ресетовању овог курса ако можете.';
$string['course_cohort_unenrolled'] = 'Кохорте исписане';
$string['course_dashboard_viewed'] = 'Контролни панел предавача посећен';
$string['course_files_viewed'] = 'Страница са извештајем о датотекама је посећена';
$string['course_global_reset'] = 'Курс је ресетован помоћу функције Менаџера курсева';
$string['course_restored'] = 'Курс је измештен из категорије \'Отпаци\' и рестауриран.';
$string['course_state_hidden'] = 'Сакривено';
$string['course_state_trash'] = 'За брисање';
$string['course_state_visible'] = 'Видљиво';
$string['course_trash_moved'] = 'Курс је премештен у категорију \'Отпаци\'';
$string['coursemanager:admintools'] = 'Коришћење администраторске алатке у секцији Извештај';
$string['coursemanager:viewreport'] = 'Преглед извештаја на курсу ако је омогућено';
$string['coursesize'] = 'Величина курса';
$string['dashboardsettingsheading'] = 'Подешавања контролног панела';
$string['delete_already_moved'] = 'Овај курс је већ у категорију \'Отпаци\'';
$string['delete_cohort_confirm'] = 'Ова функција ће исписати са вашег курса све кохорте.<br />
Имајте на уму да ће исписивање чланова кохорте са курса учинити да нестану неки подаци као што су нпр. поруке на форумима, <b> али не и покушаји решавања теста или предати радови</b>.
Размислите о могућносту да искористите функције ресетовања за брисање личних података.
<p class="alert alert-primary"><i class="fa fa-question-circle-o"></i> <b>НАПОМЕНА :</b> у зависности од броја кохорти које треба исписати, овај процес може потрајати.</p>';
$string['delete_period'] = 'Временска назнака за брисање круса';
$string['delete_period_desc'] = 'Ове информације дају приближан временски период  потребан за брисање курса из категорије \'Отпаци\'.
 Можете написати нешто попут "почетком јула" или "на крају године". Ова информација ће бити приказане у е-пошти када предавач обрише курс као и на страници за брисање курса.';
$string['delete_send_mail'] = 'Улоге које треба сачувати приликом брисања курса';
$string['delete_send_mail_desc'] = 'Изаберите улоге које ће бити обавештене е-поштом када се курс обрише';
$string['delete_several_teachers'] = '<h4><i class="fa fa-exclamation-triangle"></i> УПОЗОРЕЊЕ: НА ОВОМ КУРСУ ИМА ВИШЕ ПРЕДАВАЧА!</h4>
Ако ови предавачи нису обавештени, урадите то сада.<br/>Брисање курса ће послати <b>аутоматско обавештење е-поштом сваком предавачу на овом курсу</b> као упозорење.<br /><br />
<h5>Остали предавачи на овом курсу:</h5>';
$string['delete_wish'] = 'Шта желите да урадите?';
$string['deletecohortsscheduled'] = 'Ваш захтев за исписивање кохорти са овог курса је регистрован  и ускоро ће бити аутоматски извршен.';
$string['deletecoursewithoutteachersconfirm'] = 'Да ли желите да преместите овај курс у категорију \'Отпаци\'?';
$string['deleteorphans'] = 'Обришите напуштене предате радове';
$string['deleteorphansubmissionsconfirm'] = 'Да ли желите да обришете напуштене предате радове у овом задатку? Ова акција је неповратна.';
$string['empty_course_alert'] = '<b>Празан курс.</b>Овај курс садржи само изворни форум. Ако није планирано додавање садржаја, размислите о брисању овог курса.';
$string['empty_files_course'] = 'Изгледа да овај курс још увек не садржи датотеке.';
$string['empty_settings'] = 'Нека подешавања недостају за овај додатак; обратите се свом Moodle администратору';
$string['empty_student_alert'] = '<b>Ниједан студент није уписан</b><br />Нема корисника који су уписани на овај курс као полазници. Ако се курс више не користи, размислите о брисању!';
$string['emptytablenoteacherincourses'] = 'Нема резултата: сви курсеви имају предавача';
$string['enableactioncohorts'] = 'Линк ка одјави из кохорти';
$string['enableactioncoursefiles'] = 'Линк ка страници са датотекама курса';
$string['enableactionparams'] = 'Линк ка подешавањима курса';
$string['enableactionreset'] = 'Линк ка поједностављеном ресетовању курса';
$string['enablecolumncohorts'] = 'Прикажи колону \'Кохорте\'';
$string['enablecolumncohorts_desc'] = 'Ако је поље означено, биће приказана љколону која садржи број кохорти уписаних на курс.';
$string['enablecolumncomparison'] = 'Прикажи колону за поређење';
$string['enablecolumncomparison_desc'] = 'Ако је поље означено, биће приказана колона где се величина сваког курса упоређује са другим курсевима. Можете бирати између медијане или просечне вредности.';
$string['enablecolumncoursesize'] = 'Прикажи колону \'Величина курса\'';
$string['enablecolumncoursesize_desc'] = 'Ако је поље означено, биће приказана колона која показује укупну величину датотека на курсу.';
$string['enablecolumnstudents'] = 'Прикажи колону \'Полазници\'';
$string['enablecolumnstudents_desc'] = 'Ако је поље означено, биће приказана колона која садржи број полазника уписаних на курс.';
$string['enablecolumnteachers'] = 'Прикажи колону \'Ппредавачи\'';
$string['enablecolumnteachers_desc'] = 'Ако је поље означено, биће приказана колона која садржи број предавача уписаних на курс.';
$string['enablecoursecontenttask'] = 'Активирајте извештаје о празним или великим курсевима';
$string['enablecoursecontenttask_desc'] = 'Ако је означено, биће активиран аутоматизовани задатак за откривање великих или курсева без садржаја.';
$string['enablemailing'] = 'Активирајте слање извештаја е-поштом';
$string['enablemailing_desc'] = 'Ако је означено, биће активиран аутоматизовани задатак за слање извештаја е-поштом. Подразумевана периодичност је сваких 30 дана.';
$string['enableorphanstask'] = 'Активирајте извештај о напуштеним предатим радовима';
$string['enableorphanstask_desc'] = 'Ако је означено, биће активиран аутоматизовани задатак за откривање Задатака са напуштеним датотекама.';
$string['enablestudentstask'] = 'Активирајте извештаје о посетама и уписима полазника';
$string['enablestudentstask_desc'] = 'Ако је означено, биће активиран аутоматизовани задатак за откривање курсева без полазника или без скорашњих посета  полазника курсу.';
$string['enableteacherstask'] = 'Активирајте извештаје о посетама и уписима предавача';
$string['enableteacherstask_desc'] = 'Ако је означено, биће активиран аутоматизовани задатак за откривање курсева без предавача или без скорашњих посета  предавача курсу.';
$string['error_category'] = 'Изабрана је погрешна категорија';
$string['filesdistributiontablecomponent'] = 'Компонента';
$string['filesdistributiontotalfiles'] = 'Број датотека';
$string['filesdistributiontotalweight'] = 'Укупна величина датотека у Mo (мегаоктетима)';
$string['global_chart'] = 'Дистрибуција величине датотека по активностима';
$string['head_average_help'] = 'Ова колона упоређује величину сваког курса са израчунатом просечном величином курса:
<ul>
<li><i class=\'fa fa-arrow-circle-down text-success\'></i> указује да је величина овог курса већа од просечне ;</li>
<li><i class=\'fa fa-arrow-circle-up text-danger\'></i> указује да је величина овог курса мања од просечне ;</li>
<li><i class=\'fa fa-question-circle text-info\'></i> указује да је величина овог курса 0 или да још увек није израчуната.</li>
</ul>';
$string['head_median_help'] = 'Ово колона упоређује величину сваког курса са израчунатом медијаном курса:
<ul>
<li><i class=\'fa fa-arrow-circle-down text-success\'></i> указује да је величина овог курса већа од медијане ;</li>
<li><i class=\'fa fa-arrow-circle-up text-danger\'></i> указује да је величина овог курса мања од медијане ;</li>
<li><i class=\'fa fa-question-circle text-info\'></i> указује да је величина овог курса 0 или да још увек није израчуната.</li>
</ul>';
$string['heavy_course'] = 'Велики курсеви';
$string['last_access_multiple_teacher_alert'] = '<b>Нема посете предавача последња/их {$a->limit_visit} месеца/и.</b><br /> Ниједан предавач већ дуже време није посетио овај курс. Ако га не користи ниједан предавач, размислите о његовом брисању!';
$string['last_access_student'] = 'Ограничење за последњи приступ полазника (у данима)';
$string['last_access_student_alert'] = '<b>Нема посете полазника последња/их {$a->limit_visit} месеца/и.</b><br /> Ниједан полазник већ дуже време није посетио овај курс. Ако је потребно, обришите га.';
$string['last_access_student_desc'] = 'Број дана од када полазник није посетио курс';
$string['last_access_teacher'] = 'Ограничење за последњи приступ предавача (у данима)';
$string['last_access_teacher_desc'] = 'Број дана од када предавач није посетио курс';
$string['last_access_unique_teacher_alert'] = '<b>Нисте посетили овај курс {$a->limit_visit} месеци.</b><br />Ви сте једини предавач на овом курсу. Ако га више не користите, размислите о брисању.';
$string['mail_message_delete_main_teacher'] = 'Поштовани/а,<br />
Курс {$a->course} је пребачен у категорију \'Отпаци\' пре него што буде комплетно обрисан {$a->delete_period}. Пре коначног брисања, још увек можете приступити овом курсу уколико желите да преузмете податке.<br />
Ако желите да повратите овај курс, преместите га из категорије \'Отпаци\' на контролном панелу Менаџера курсева.
НАПОМЕНА : {$a->count_teacher} - овај број предавача био је уписан на овај курс. Послата им је е-порука са упозорењем да сте обрисали курс. Како су и они предавачи, имају могућност да поврате курс или податке у њему, уколико је потребно.';
$string['mail_message_delete_oneteacher'] = 'Поштовани/а,<br />
Курс {$a->course} је пребачен у категорију \'Отпаци\' пре него што буде комплетно обрисан {$a->delete_period}. Пре коначног брисања, још увек можете приступити овом курсу уколико желите да преузмете податке.<br />
Ако желите да повратите овај курс, преместите га из категорије \'Отпаци\' на контролном панелу Менаџера курсева.';
$string['mail_message_delete_other_teacher'] = 'Поштовани/а,<br />
Корисник {$a->deleter} је пребацио курс {$a->course} у категорију \'Отпаци\' пре него што он буде комплетно обрисан {$a->delete_period}. Пре коначног брисања, још увек можете приступити овом курсу уколико желите да преузмете податке.<br />
Ако желите да повратите овај курс, преместите га из категорије \'Отпаци\' на контролном панелу Менаџера курсева.';
$string['mail_subject_delete'] = 'Обрисан је курс - {$a->course}';
$string['mailingddescreportempty'] = 'Ови курсеви немају никакв садржај, евентуално осим изворног Moodle форума.';
$string['mailingddescreportheavy'] = 'Чини се да је укупна величина датотека у овом курсу велика. Кликните на назив курса како бисте видели извештај о датотекама.';
$string['mailingddescreportnostudent'] = 'Нема студената уписаних на ове курсеве.';
$string['mailingddescreportnovisitstudent'] = 'Студенти већ дуже време нису посећивали ове курсеве.';
$string['mailingddescreportnovisitteacher'] = 'Предавачи, укључујући и вас, већ дуже време нису посећивали ове курсеве';
$string['mailingddescreportorphansubmissions'] = 'Неки задаци на овим курсевима имају скривене предате радове које су поставили исписани полазници. Ове датотеке могу бити веома велике и заузимати велики простор.';
$string['mailingheading'] = 'Предавачи шаљу е-пошту';
$string['mailingintro'] = '<p>Поштовани/а %userfirstname%,</p>
<p>Менаџер курсева представља скупа алата који помажу предавачима да управљају својим курсевима користећи прорачунате извештаје. Ова е-порука резимира ове извештаје и указује на курсеве код којих се јављају проблеми.</p>
<p><b>Ови извештаји имају сврху само да вашу пажњу усмере на одређене аспекте управљања вашим курсевима, као и да вам дају пример добре праксе у коришћењу Moodleа</b></p>
<p>За више информација посетите свој лични <a href="%coursemanagerlink%">Контролни панел Менаџера курсева</a>';
$string['mailingintro_setting'] = 'Садржај е-поште';
$string['mailingintro_setting_desc'] = 'Увод у извештај који се шаље е-поштом.<br>
Можете користити следеће променљиве:<br>
%userfirstname% : име корисника<br>
%userlastname% : презиме корисника<br>
%coursemanagerlink% : линк Менаџера курсева';
$string['mailingoutro'] = 'За више информација о овим извештајима, обратите се Moodle администратору или службу за подршку.';
$string['mailingoutro_setting'] = 'Завршетак е-поруке';
$string['mailingoutro_setting_desc'] = 'Крај садржаја извештаја који се шаље поштом.';
$string['mailingtask'] = 'Слање извештаја Менаџера курсева е-поштом за предаваче';
$string['mailingtitle'] = 'Менаџер курсева - Извештаји о вашим курсевима';
$string['mailingtitle_setting'] = 'Тема е-поруке';
$string['mailingtitle_setting_desc'] = 'Тема поруке која се шаље предавачима.';
$string['menucoursefilesinfo'] = 'Погледај датотеке на курсу';
$string['menucourseparameters'] = 'Подешавања курса';
$string['menudeletecourse'] = 'Обриши курс';
$string['menuenrolcohorts'] = 'Додај кохорте';
$string['menureset'] = 'Ресетуј курс';
$string['menurestorecourse'] = 'Рестаурирај курс';
$string['menuunenrolcohorts'] = 'Групно исписавање кохорти';
$string['more_information'] = 'Више информација';
$string['move_confirm'] = '<div class="alert alert-danger"><h5>Пажљиво прочитајте пре брисања</h5></div>
<p><b>Ова страница вам омогућава да курс који више не користите преместите у категорију \'Отпаци\'.</b><br/>Ако буде потврђено, овај курс ће бити премештен у одређену категорију и скривен за полазнике. Затим ће га обрисати Moodle администратор <b>{$a->delete_period}</b>.</p>
<p> Пре брисања, још увек можете приступити овом курсу или га повратити ако је то потребно. Употебите команду за рестаурацију курса на контролном панелу Менаџер курсева.</p>
<p> Пре брисања размислите о креирању резервне копије важних датотека или банке питања. Ти подаци се не могу преузети након потпуног брисања.';
$string['navbarlink'] = 'Додајте линк ка контролном панелу у навигационој траци';
$string['navbarlink_desc'] = 'Ако је означено, додаје иконицу у навигациону траку поред обавештења.';
$string['no_advices'] = '<b>Нема конкретних извештаја.</b><br />Честитамо, овај курс изгледа ок!';
$string['no_cohort'] = '<p class="alert alert-info">Ниједна кохорта није уписана на овај курс!</p>';
$string['no_content'] = 'Празни курсеви';
$string['no_course_to_show'] = '<h2>Нема курсева</h2>Нисте уписани на курсеве са улогом предавача.';
$string['no_student'] = 'Ниједан студент није уписан';
$string['no_visit_student'] = 'Нема посета полазника';
$string['no_visit_teacher'] = 'Нема посета предавача';
$string['noassign'] = 'Нема задатака на овој Moodle инстанци.';
$string['number_of_files'] = 'Број датотека';
$string['ok'] = 'Нема извештаја';
$string['orphan_submissions_alert'] = '<b>Напуштени предати радови</b><br />Овај курс има {$a->assigns} Задат(а)ка са {$a->filescount} датотеке/ка које су предали тренутно исписани полазници. Ове датотеке заузимају {$a->filesize} Mo (мегаоктета). Размотрите могућност да ресетујете или обришете ове активности.';
$string['orphan_submissions_button'] = 'Напуштени предати радови';
$string['otherteacherroledashboard'] = 'Друге предавачке улоге';
$string['otherteacherroledashboard_desc'] = 'Дефинише друге улоге предавача које треба узети у обзир (као нпр. предавач без уређивачких права), на налогу предавача на контролном панелу, као и посетама предавача курсу.';
$string['plugin'] = 'Врста активности';
$string['pluginname'] = 'Менаџер курсева';
$string['privacy:no_data_reason'] = 'Додатак \'Менаџер курсева\' не чува никакве личне податке. Он само прорачунава извештаје проучавањем садржаја курсева (подешавања, уписани полазници и предавачи, број активности...).';
$string['reportsheading'] = 'Извештаји';
$string['reportssettingsheading'] = 'Подешавања за израчунавање извештаја';
$string['reset_info'] = '<p class="alert alert-success"><i class="fa fa-info-circle"></i> Ресетовања може да обрише личне податке полазника на вашем курсу.
 <b>Оно не брише ваше датотеке или активности</b></p>
<p>Ресетовањем ће бити обрисани:<ul>
<li><b>подаци о завршетку активности</b> ;</li>
<li><b>оцене у дневнику оцена</b> ;</li>
<li><b>групе и груписања</b> ;</li>
<li><b>предати радови у оквиру активности Задатак</b> ;</li>
<li><b>поруке на форумима</b> ;</li>
<li><b>покушаји решавања теста</b> ;</li>
<li><b>уписане кохорте</b> (<span class="text-danger"><b>УПОЗОРЕЊЕ</b>: извршавање ове функције може потрајати дуго ако курс има много полазника!).</span></li></ul></p>
<p>Други подаци неће бити обрисани.</p>
<p>Ако желите да ресетујете друге активности, користите <a href="/course/view.php?id="><b>функцију ресетовања на вашем курсу</b></a>.<br /></p>
<h5 class="alert alert-primary"><i class="fa fa-question-circle-o"></i> <b>Шта желите да урадите?</b></h5>';
$string['reset_result'] = '<p><b>Курс је ресетован.</b></p>
<p><b>Подсетник</b>: ниједна датотека или активности нису обрисани. Ако желите да ресетујете све или друге активности, користите функцију ресетовања на курсу.</p>';
$string['resetcoursescheduled'] = 'Ваш захтев за ресетовање овог курса је нотиран и ускоро ће бити аутоматски извршен.';
$string['restore_already_moved'] = 'Овај курс није у категорији \'Отпаци\'!';
$string['restore_confirm'] = '<p>Ова страница ће преузети курс из категорије \'Отпаци\' и рестаурирати га у другу категорију.</p>
<p class="alert alert-info"><i class="fa fa-info-circle"></i> НАПОМЕНА : немојте рестаурирати овај курс у категорију  <b>"{$a->trash_category}"</b> : ова категорија је резервисана за курсеве који ће бити обрисани <b>{$a->delete_period}</b>.</p>';
$string['runcleanreportstask'] = 'Чистач извештаја Менаџера курсева';
$string['runcoursecontentreporttask'] = 'Извештај менаџера курсева за велике и празне курсеве';
$string['runorphansubmissionstask'] = 'Извештај Менаџера курсева за напуштене предате радове';
$string['runreportstask'] = 'Израчунавање извештаја за Менаџера курсева';
$string['runstudentvisitreporttask'] = 'Извештај Менаџера курсева за посете полазника и курсеве без полазника';
$string['runteachervisitreporttask'] = 'Извештај Менаџера курсева за посете предавача и курсеве без предавача';
$string['see_advices'] = 'Резиме извештаја';
$string['select_restore_category'] = 'Изаберите категорију у коју се курс премешта';
$string['show_report_in_course'] = 'Приказ извештаја на курсу';
$string['show_report_in_course_choices_collapse'] = 'Мени са клизачем под менијем администратора курса';
$string['show_report_in_course_choices_none'] = 'Не приказујте извештаје на курсу';
$string['show_report_in_course_choices_popover'] = 'Иконице поред наслова курса';
$string['show_report_in_course_desc'] = 'Дефинише место на курсу где ће се извештаји бити приказани';
$string['size'] = 'Величина у Mo (мегаоктетима)';
$string['stats_count_courses'] = 'Број курсева';
$string['stats_count_courses_desc'] = 'Број курсева на Moodle инстанци.';
$string['stats_count_courses_trash'] = 'Курсеви у категорији \'Отпаци\'';
$string['stats_count_courses_trash_desc'] = 'Број курсева у категорији \'Отпаци\' Менаџера курсева';
$string['stats_count_courses_without_students'] = 'Курсеви без полазника';
$string['stats_count_courses_without_students_desc'] = 'Број курсева без корисника који су уписани као полазници.';
$string['stats_count_courses_without_teachers'] = 'Курсеви без предавача';
$string['stats_count_courses_without_teachers_desc'] = 'Број курсева без корисника уписаних са улогом предавача.';
$string['stats_count_courses_without_visit_students'] = 'Курсеви без посета полазника';
$string['stats_count_courses_without_visit_students_desc'] = 'Број курсева без посете полазника у последњих {$a->lastaccessstudent} дана.';
$string['stats_count_courses_without_visit_teachers'] = 'Курсеви без посета предавача';
$string['stats_count_courses_without_visit_teachers_desc'] = 'Број курсева без посете предавача у последњих {$a->lastaccessstudents} дана.';
$string['stats_empty_courses'] = 'Празни курсеви';
$string['stats_empty_courses_desc'] = 'Број курсева који од активности имају само изворни форум.';
$string['stats_files_orphan_submissions'] = 'Укупан број датотека напуштених предатих радова';
$string['stats_files_orphan_submissions_desc'] = 'Број датотека које се сматрају предатим радовима који припадају неуписаним корисницима.';
$string['stats_heaviest_course'] = 'Највећи курс';
$string['stats_heaviest_course_desc'] = 'Највећи курс на овој Moodle инстанци, према извештајима Менаџера курсева.';
$string['stats_heavy_courses'] = 'Велики курсеви';
$string['stats_heavy_courses_desc'] = 'Курсеви који су већи од {$a->totalfilesizethreshold} Mo (мегаоктета). Овај праг је дефинисан у подешавањима Менаџера курсева.';
$string['stats_title_contents'] = 'Садржај и величина курсева';
$string['stats_title_courses'] = 'Статистика курсева';
$string['stats_title_enrolls_visits'] = 'Уписи на курсевима и посете';
$string['stats_weight_courses_orphan_submissions'] = 'Величина напуштених предатих радова';
$string['stats_weight_courses_orphan_submissions_desc'] = 'Укупна величина датотеке за напуштене предате радове';
$string['stats_weight_courses_trash'] = 'Укупна величина курсева у категорји \'Отпаци\'';
$string['stats_weight_courses_trash_desc'] = 'Укупна величина датотека активности из курсева у категорији \'Отпаци\' Менаџера курсева.';
$string['studentrolereport'] = 'Улога полазника на курсевима';
$string['studentrolereport_desc'] = 'Дефинише улогу полазника за израчунавање извештаја. Подразумевана улога је Moodle полазник.';
$string['table_actions'] = 'Акције';
$string['table_assign_name'] = 'Назив задатка';
$string['table_course_name'] = 'Назив курса';
$string['table_course_state'] = 'Видљивост';
$string['table_enrolled_cohorts'] = 'Кохорте';
$string['table_enrolled_students'] = 'Полазници';
$string['table_enrolled_teachers'] = 'Предавачи';
$string['table_files_count'] = 'Број скривених датотека';
$string['table_files_weight'] = 'Укупна величина датотека';
$string['table_recommendation'] = 'Извештаји';
$string['table_size_comparison_average'] = 'Поређење - просечна величина курса';
$string['table_size_comparison_median'] = 'Поређење - медијана величине курса';
$string['table_tool_description'] = '<p>Опис</p>';
$string['table_tool_name'] = '<p>Алат</p>';
$string['tablecountenrolledstudents'] = 'Полазници';
$string['tablecountmodules'] = 'Број активности';
$string['tablecourseweight'] = 'Величина курса';
$string['tablehascontents'] = 'Број садржаја';
$string['tablelastaccess'] = 'Последњи приступ курсу';
$string['tablelastteacher'] = 'Последњи активни предавач';
$string['tablelastteacherlog'] = 'Последњи запис о активности предавача';
$string['teacherroledashboard'] = 'Улога предавача на курсевима';
$string['teacherroledashboard_desc'] = 'Дефинише улогу предавача која може да прикаже списак курсева на контролном панелу Менаџера курсева. Подразумевана улога је Moodle предавач.';
$string['text_filter'] = 'Унесите неколико знакова назива курса';
$string['text_link_delete'] = 'Oбриши курс';
$string['text_link_reset'] = 'Ресетуј курс';
$string['title'] = 'Менаџер курсева за предаваче';
$string['title_admin_files_distribution'] = '<b>Дистрибуција датотека по компонентама</b>';
$string['title_admin_no_teacher_courses'] = '<b>Управљање курсевима без предавача</b>';
$string['title_admin_orphan_submissions'] = '<b>Управљање напуштеним предатим радовима</b>';
$string['title_admin_stats'] = '<b>Статистика</b>';
$string['title_delete_cohort_confirm'] = 'Поништи упис кохорти';
$string['title_move_confirm'] = 'Брисање курса';
$string['title_restore_confirm'] = 'Рестаурирај курс';
$string['total_filesize_alert'] = '<b>Овај курс је велик.</b><br />Погледајте <a href="course_files.php?courseid={$a->courseid}">извештај о датотекама курса</a>како бисте видели највеће датотеке.';
$string['total_filesize_threshold'] = 'Максимална величина курса (Mo-мегаоктети)';
$string['total_filesize_threshold_desc'] = 'Ако укупна величина датотека премашује ово ограничење, извештај ће бити израчунат за предметне курсеве.';
$string['totalsize'] = 'Укупна величина датотека :';
$string['trash'] = 'Овај курс је у категорији за oбрисане курсеве.';
$string['trashsettingsheading'] = 'Подешавања за категорију \'Отпаци\' и за брисање курсева';
$string['unique_filesize_threshold'] = 'Максимална величина датотеке  (Mo-мегаоктети)';
$string['unique_filesize_threshold_desc'] = 'Ако величина датотеке премашује ово ограничење, она ће бити приказана на списку великих датотека у извештају о свим датотекама на курсу.';
$string['unknown'] = 'Непознато';
$string['warn_big_files'] = 'Ове датотеке су <b>веома велике</b> :';
$string['warn_big_files_help'] = 'Ако је величина датотеке важна, размислите о следећим опцијама:
<ul>
<li>архивирајте (”зипујете”) датотеку ;</li>
<li>ако постоје слике, покушајте да смањите њихове резолуције ;</li>
<li>користите екстерни репозиторијум ако можете.</li>
<li></li>
</ul>';
$string['warn_heavy_assign'] = 'Ови задаци имају веома велике датотеке :';
$string['warn_heavy_assign_help'] = '<b>Припазите на ове задатке</b> и размислите о њиховом ресетовању или брисању када се више не буду користили.';
$string['warn_orphans'] = 'Ови задаци садрже <b>напуштене предате радове</b> :';
$string['warn_orphans_help'] = '<p>Датотеке којуе су предали исписани полазници су још увек овде.</p>
<p>Молимо вас да размотрите могућност : <ul>
<li>брисања задатака са напуштеним предатим радовима;</li>
<li>рестовања активности или целог курса.</li></ul></p>';
$string['warn_recyclebin'] = '<p class="alert alert-info"><i class="fa fa-info-circle"></i> <b>Имајте на уму да је</b> корпа за отпатке активирана на Moodleu. Oбрисане датотеке биће укључени у овај графикон све док предавач не испразни корпу за отпатке.</p>';
$string['warn_videos'] = 'Те датотеке су <b>видео клипови</b>, размислите о томе да их преместите:';
$string['warn_videos_help'] = 'Видео клипови могу бити веома велики. Ако можете, отпремите их на неки од веб сервиса намењених видео снимцима (WebTV, YouTube...).';
$string['warntextcategorytrash'] = 'УПОЗОРЕЊЕ: Ову категорију Менаџер курсева користи као место за отпатке. Очекује се да ће сви курсеви у овој категорији касније бити обрисани. Ако желите да задржите свој курс, преместите га у другу категорију.';
$string['warntextcoursetrash'] = 'УПОЗОРЕЊЕ: овај курс је у категорији \'Отпаци\' и биће обрисан касније. Преместите га у другу категорију помоћу алатке за управљање курсевима ако желите да га задржите.';
$string['watchedfilessize'] = 'Укупна величина најгледанијих датотека:';
$string['watchedfilessizedetails'] = 'Ове датотеке потичу из најчешће коришћених активности: Задатак, Ресурс, Форум, Директоријум и Мултимедијални натпис.';
$string['weight_not_calculated'] = 'Величина датотеке још није израчуната';
