<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'sl', version '4.1'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Nadzor dostopa';
$string['actionaftercorrectanswer'] = 'Dejanje po pravilnem odgovoru';
$string['actionaftercorrectanswer_help'] = 'Po pravilnem odgovoru na vprašanje so na voljo tri možnosti skoka na naslednjo stran.

* Običajno: sledenje zastavljeni poti lekcije.
* Prikaži še neogledano stran: strani se prikazujejo v naključnem vrstnem redu, brez prikaza že ogledanih strani.
* Prikaži še neodgovorjeno stran: strani se prikazujejo v naključnem vrstnem redu, z možnostjo ponovitve strani, kjer udeleženec na vprašanje še ni odgovoril pravilno';
$string['actions'] = 'Ukazi';
$string['activitylink'] = 'Povezava na naslednjo dejavnost';
$string['activitylink_help'] = 'Če želite na koncu lekcije dodati povezavo na drugo dejavnost, jo izberite v tem spustnem seznamu.';
$string['activitylinkname'] = 'Pojdi na {$a}';
$string['activityoverview'] = 'Na urniku imate lekcije';
$string['addabranchtable'] = 'Dodaj stran z vsebino';
$string['addanendofbranch'] = 'Dodaj konec veje';
$string['addanewpage'] = 'Dodaj novo stran';
$string['addaquestionpage'] = 'Dodaj stran z vprašanjem';
$string['addaquestionpagehere'] = 'Dodaj stran z vprašanjem tukaj';
$string['addbranchtable'] = 'Dodaj stran z vsebino';
$string['addcluster'] = 'Dodaj gručo';
$string['addedabranchtable'] = 'Stran z vsebino je dodana';
$string['addedanendofbranch'] = 'Konec veje je dodan';
$string['addedaquestionpage'] = 'Stran z vprašanjem je dodana';
$string['addedcluster'] = 'Gruča je dodana';
$string['addedendofcluster'] = 'Konec gruče je dodan';
$string['addendofbranch'] = 'Dodaj konec veje';
$string['addendofcluster'] = 'Dodaj konec gruče';
$string['addessay'] = 'Ustvari stran z vprašanjem tipa Esej';
$string['addmatching'] = 'Ustvari stran z vprašanjem tipa Ujemanje';
$string['addmultichoice'] = 'Ustvari stran z vprašanjem tipa Več izbir';
$string['addnewgroupoverride'] = 'Dodaj preglasitev skupine';
$string['addnewuseroverride'] = 'Dodaj preglasitev uporabnika';
$string['addnumerical'] = 'Ustvari stran z vprašanjem tipa Numerično';
$string['addpage'] = 'Dodaj stran';
$string['addshortanswer'] = 'Ustvari stran z vprašanjem tipa Kratek odgovor';
$string['addtruefalse'] = 'Ustvari stran z vprašanjem tipa Resnično/neresnično';
$string['allotheranswers'] = 'Vsi drugi odgovori';
$string['allotheranswersjump'] = 'Skok ob vseh drugih odgovorih';
$string['allotheranswersscore'] = 'Rezultat vseh drugih odgovorov';
$string['allowofflineattempts'] = 'Dovoli opravljanje lekcije brez povezave z uporabo mobilne aplikacije';
$string['allowofflineattempts_help'] = 'Če je to omogočeno, lahko uporabnik mobilne aplikacije prenese lekcijo in jo opravlja brez povezave. Prenesli se bodo tudi vsi možni odgovori in pravilni odgovori.
Opomba: Lekcije ni mogoče opravljati brez povezave, če ima nastavljeno časovno omejitev.';
$string['anchortitle'] = 'Začetek glavne vsebine';
$string['and'] = 'IN';
$string['answer'] = 'Odgovor';
$string['answeredcorrectly'] = 'odgovorilo pravilno.';
$string['answersfornumerical'] = 'Odgovori na numerična vprašanja naj bodo urejeni pari najmanjše in največje vrednosti';
$string['arrangebuttonshorizontally'] = 'Razporedi gumbe razvejanja vodoravno v načinu diaprojekcije?';
$string['attempt'] = 'Poskus: {$a}';
$string['attemptheader'] = 'Poskus';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Poskusi';
$string['attemptsdeleted'] = 'Izbrisani poskusi';
$string['attemptsremaining'] = 'Število preostalih poskusov: {$a}';
$string['available'] = 'Na voljo od';
$string['averagescore'] = 'Povprečni rezultat';
$string['averagetime'] = 'Povprečni čas';
$string['branch'] = 'Vsebina';
$string['branchtable'] = 'Vsebina';
$string['cancel'] = 'Prekliči';
$string['cannotfindanswer'] = 'Napaka: odgovora ni mogoče najti';
$string['cannotfindattempt'] = 'Napaka: poskusa ni mogoče najti';
$string['cannotfindessay'] = 'Napaka: eseja ni mogoče najti';
$string['cannotfindfirstgrade'] = 'Napaka: ocen ni mogoče najti';
$string['cannotfindfirstpage'] = 'Prve strani ni mogoče najti';
$string['cannotfindgrade'] = 'Napaka: ocen ni mogoče najti';
$string['cannotfindnewestgrade'] = 'Napaka: najnovejše ocene ni mogoče najti';
$string['cannotfindnextpage'] = 'Varnostna kopija lekcije: naslednje strani ni mogoče najti!';
$string['cannotfindpagerecord'] = 'Dodajte konec veje: zapis strani ni najden';
$string['cannotfindpages'] = 'Strani lekcije ni mogoče najti';
$string['cannotfindpagetitle'] = 'Potrdite izbris: naslova strani ni mogoče najti';
$string['cannotfindpreattempt'] = 'Zapisa prejšnjega poskusa ni mogoče najti!';
$string['cannotfindrecords'] = 'Napaka: zapisov o lekciji ni mogoče najti';
$string['cannotfindtimer'] = 'Napaka: zapisov merilnika časa lekcije ni mogoče najti (lesson_timer)';
$string['cannotfinduser'] = 'Napaka: uporabnikov ni mogoče najti';
$string['canretake'] = '{$a} lahko ponovno opravlja';
$string['casesensitive'] = 'Uporabi regularne izraze';
$string['casesensitive_help'] = 'Označite to polje za analiziranje odgovorov z regularnimi izrazi.';
$string['checkbranchtable'] = 'Preveri stran z vsebino';
$string['checkedthisone'] = 'jih je označilo to.';
$string['checknavigation'] = 'Preveri navigacijo';
$string['checkquestion'] = 'Preveri vprašanje';
$string['classstats'] = 'Statistika razreda';
$string['clicktodownload'] = 'Za prenos datoteke kliknite to povezavo.';
$string['closebeforeopen'] = 'Lekcije ni bilo mogoče posodobiti. Nastavili ste datum zaprtja, ki je pred datumom odprtja.';
$string['cluster'] = 'Gruča';
$string['clusterjump'] = 'Še neogledano vprašanje v gruči';
$string['clustertitle'] = 'Gruča';
$string['collapsed'] = 'Skrčeno';
$string['comments'] = 'Vaši komentarji';
$string['completed'] = 'Zaključeno';
$string['completederror'] = 'Končaj lekcijo';
$string['completethefollowingconditions'] = 'Izpolniti morate naslednje pogoje v lekciji: <b>{$a}</b>, preden lahko nadaljujete.';
$string['completiondetail:reachend'] = 'Obdelajte aktivnost do konca.';
$string['completiondetail:timespent'] = 'Porabite vsaj {$a} za to aktivnost';
$string['completionendreached'] = 'Zahtevan dosežek konca';
$string['completionendreached_desc'] = 'Udeleženec mora priti do konca lekcije, da zaključi to dejavnost';
$string['completiontimespent'] = 'Udeleženec mora dejavnost izvajati vsaj';
$string['completiontimespentdesc'] = 'Udeleženec mora dejavnost izvajati vsaj {$a}';
$string['completiontimespentgroup'] = 'Zahtevan čas izvajanja';
$string['conditionsfordependency'] = 'Pogoji za odvisnost';
$string['configintro'] = 'Tukaj nastavljene vrednosti določajo privzete vrednosti v obrazcu za nastavitve pri ustvarjanju nove Dejavnosti lekcije. Nastavitve, določene kot napredne, so prikazane po kliku na povezavo »Prikaži več ...«.';
$string['configmaxanswers'] = 'Privzeto največje število odgovorov na stran';
$string['configmediaclose'] = 'Prikaže gumb za zaprtje v pojavnem oknu, ki je ustvarjeno za povezano medijsko datoteko';
$string['configmediaheight'] = 'Nastavi višino pojavnega okna, prikazanega za povezane predstavnostne datoteke';
$string['configmediawidth'] = 'Nastavi širino pojavnega okna, prikazanega za povezane predstavnostne datoteke';
$string['configpassword_desc'] = 'Ali je za dostop do lekcije potrebno geslo.';
$string['configslideshowbgcolor'] = 'Barva ozadja diaprojekcije, če je omogočena';
$string['configslideshowheight'] = 'Določi višino diaprojekcije, če je omogočena';
$string['configslideshowwidth'] = 'Določi širino diaprojekcije, če je omogočena';
$string['configtimelimit_desc'] = 'Če je nastavljena časovna omejitev, se na začetku lekcije prikaže opozorilo in časovni odštevalnik. Če je nastavljeno na 0, potem ni časovne omejitve.';
$string['confirmdelete'] = 'Izbriši stran';
$string['confirmdeletionofthispage'] = 'Potrdi izbris strani';
$string['congratulations'] = 'Čestitke! Konec lekcije je dosežen.';
$string['continue'] = 'Nadaljuj';
$string['continuetoanswer'] = 'Nadaljujte za spremembo odgovorov.';
$string['continuetonextpage'] = 'Nadaljuj na naslednjo stran.';
$string['correctanswerjump'] = 'Skok ob pravilnem odgovoru';
$string['correctanswerscore'] = 'Rezultat pravilnega odgovora';
$string['correctresponse'] = 'Pravilni odgovor';
$string['createaquestionpage'] = 'Ustvari stran z vprašanjem';
$string['credit'] = 'Kreditne točke';
$string['customscoring'] = 'Točkovanje po meri';
$string['customscoring_help'] = 'Če je to omogočeno, lahko vsakemu odgovoru priredite numerično vrednost točk (pozitivno ali negativno).';
$string['deadline'] = 'Rok oddaje';
$string['defaultessayresponse'] = 'Izvajalec bo ocenil esej.';
$string['deleteallattempts'] = 'Izbriši vse poskuse v lekciji';
$string['deletedefaults'] = 'Izbrisano {$a} x privzeto';
$string['deletedpage'] = 'Izbrisana stran';
$string['deletepagenamed'] = 'Izbriši stran: {$a}';
$string['deleting'] = 'Brisanje';
$string['deletingpage'] = 'Brisanje strani: {$a}';
$string['dependencyon'] = 'Odvisno od';
$string['dependencyon_help'] = 'Ta nastavitev omogoča, da je dostop do te lekcije odvisen od udeleženčeve uspešnosti v drugi lekciji v istem predmetu. Uporabi se lahko poljubna kombinacija pogojev vezanih na "porabljen čas", "dokončanost" ali "ocena višja kot".';
$string['description'] = 'Opis';
$string['deselectallattempts'] = 'Preklic izbire vseh poskusov';
$string['detailedstats'] = 'Podrobna statistika';
$string['didnotanswerquestion'] = 'Vprašanje ni bilo odgovorjeno.';
$string['didnotreceivecredit'] = 'Ni prejetih točk';
$string['disabled'] = 'Onemogočeno';
$string['displaydefaultfeedback'] = 'Uporabi privzeti odziv';
$string['displaydefaultfeedback_help'] = 'Če to možnost nastavite na <strong>Da</strong>, se bosta v primeru brez določenega odziva pri nekem vprašanju, uporabila privzeta odziva "To je pravilen odgovor" in "To je napačen odgovor".';
$string['displayinleftmenu'] = 'Prikaži v meniju?';
$string['displayleftif'] = 'Prikaži meni, če je ocena vsaj:';
$string['displayleftif_help'] = 'Ta nastavitev določa ali mora udeleženec dobiti določeno oceno preden vidi meni lekcije. To prisili udeleženca, da gre skozi celotno lekcijo v prvem poskusu. Šele ko dobi določeno oceno, lahko uporablja meni za lažji pregled in premikanje po lekciji.';
$string['displayleftmenu'] = 'Prikaži meni';
$string['displayleftmenu_help'] = 'To bo prikazalo meni za lažje premikanje po lekciji.';
$string['displayofgrade'] = 'Prikaz ocen (samo za udeležence)';
$string['displayreview'] = 'Prikaži gumb za ponovni pregled vprašanja';
$string['displayreview_help'] = 'Če je to omogočeno, lahko po napačno odgovorjenem vprašanju udeleženec poskusi znova (vendar brez možnosti, da pridobi točke) ali nadaljuje z lekcijo. Če udeleženec klikne na drugo vpršaanje, bo sledil izbrani (napačni) odgovor. Skosi na napačne odogovore so privzeto nastavljeni na »to stran« in imajo število točk 0, zato je priporočeno, da za skos nastavite drugo stran, da udeleženci niso zmedeni.';
$string['displayscorewithessays'] = '<p>Prejeli ste {$a->score} točk od skupno {$a->tempmaxgrade} za samodejno ocenjene odgovore.</p>
<p>Eseji ({$a->essayquestions}) bodo ocenjeni in dodani v skupni rezultat naknadno.</p>
<p>Trenutni rezultat (brez esejev) je {$a->score} od {$a->grade}.</p>';
$string['displayscorewithoutessays'] = 'Trenutna ocena je {$a->score} (od {$a->grade}).';
$string['duplicatepagenamed'] = 'Podvoji stran: {$a}';
$string['edit'] = 'Uredi';
$string['editbranchtable'] = 'Uredi stran z vsebino';
$string['editcluster'] = 'Uredi gručo';
$string['editendofbranch'] = 'Uredi stran z vprašanjem (vej)';
$string['editendofcluster'] = 'Uredi stran z vprašanjem (gruča)';
$string['editessay'] = 'Uredi stran z vprašanjem tipa Esej';
$string['editingquestionpage'] = 'Urejanje strani z vprašanjem: {$a}';
$string['editlesson'] = 'Uredi {$a}';
$string['editlessonsettings'] = 'Uredi nastavitve lekcije';
$string['editmatching'] = 'Uredi stran z vprašanjem tipa Ujemanje';
$string['editmultichoice'] = 'Uredi stran z vprašanjem tipa Več izbir';
$string['editnumerical'] = 'Uredi stran z vprašanjem tipa Numerično';
$string['editoverride'] = 'Uredi preglasitev';
$string['editpage'] = 'Uredi vsebine strani';
$string['editpagecontent'] = 'Uredi vsebine strani';
$string['editquestion'] = 'Uredi stran z vprašanjem';
$string['editshortanswer'] = 'Uredi stran z vprašanjem tipa Kratek odgovor';
$string['edittruefalse'] = 'Uredi stran z vprašanjem tipa Resnično/neresnično';
$string['email'] = 'E-pošta';
$string['emailallgradedessays'] = 'Pošlji VSE ocenjene eseje po e-pošti';
$string['emailgradedessays'] = 'Pošlji e-poštna sporočila z ocenami esejev';
$string['emailsuccess'] = 'E-poštna sporočila so uspešno poslana';
$string['emptypassword'] = 'Geslo ne more biti prazno';
$string['enabled'] = 'Omogočeno';
$string['endofbranch'] = 'Konec veje';
$string['endofcluster'] = 'Konec gruče';
$string['endofclustertitle'] = 'Konec gruče';
$string['endoflesson'] = 'Konec lekcije';
$string['enteredthis'] = 'jih je vneslo to.';
$string['enterpassword'] = 'Zahtevano je geslo:';
$string['eolstudentoutoftime'] = 'Pozor: Zmanjkalo vam je časa za to lekcijo. Vaš zadnji odgovor morda ni bil upoštevan, če ste odgovorili po poteku časa.';
$string['eolstudentoutoftimenoanswers'] = 'Nobeno vprašanje ni bilo odgovorjeno. Prejetih 0 točk.';
$string['essay'] = 'Esej';
$string['essayemailmessage2'] = '<p>Esejsko vprašanje: {$a->question}</p>
<p>Podan odgovor: <em>{$a->response}</em></p>
<p>Komentarji ocenjevalca: <em>{$a->comment}</em></p>
<p>Prejetih {$a->earned} od možnih {$a->outof} točk za ta esej.</p>
<p>Ocena za lekcijo {$a->lesson} se je spremenila v {$a->newgrade}&#37;.</p>';
$string['essayemailmessagesmall'] = '<p>Prejeli ste {$a->earned} od {$a->outof} za to esejsko vprašanje.</p><p>Vaša ocena {$a->lesson} za lekcijo je bila spremenjena v {$a->newgrade}&#37;.</p>';
$string['essayemailsubject'] = 'Možna ocena za vprašanje lekcije';
$string['essaynotgradedyet'] = 'Ta esej še ni bil ocenjen';
$string['essayresponses'] = 'Esejski odgovori';
$string['essays'] = 'Eseji';
$string['essayscore'] = 'Točke za esej';
$string['eventcontentpageviewed'] = 'Stran z vsebino ogledana';
$string['eventessayassessed'] = 'Esej je ovrednoten';
$string['eventessayattemptviewed'] = 'Poskus pri eseju je ogledan';
$string['eventhighscoreadded'] = 'Najvišji rezultat je dodan';
$string['eventhighscoresviewed'] = 'Najvišji rezultat je prikazan';
$string['eventlessonended'] = 'Lekcija je končana';
$string['eventlessonrestarted'] = 'Ponovni začetek lekcije';
$string['eventlessonresumed'] = 'Nadaljevanje lekcije';
$string['eventlessonstarted'] = 'Lekcija se je začela';
$string['eventoverridecreated'] = 'Preglasitev lekcije ustvarjena';
$string['eventoverridedeleted'] = 'Preglasitev lekcije izbrisana';
$string['eventoverrideupdated'] = 'Preglasitev lekcije posodobljena';
$string['eventpagecreated'] = 'Stran je ustvarjena';
$string['eventpagedeleted'] = 'Stran je izbrisana';
$string['eventpagemoved'] = 'Stran je premaknjena';
$string['eventpageupdated'] = 'Stran je posodobljena';
$string['eventquestionanswered'] = 'Vprašanje je odgovorjeno';
$string['eventquestionviewed'] = 'Vprašanje je ogledano';
$string['false'] = 'Ne drži';
$string['fileformat'] = 'Format datoteke';
$string['finalwrong'] = 'Ne povsem.';
$string['finish'] = 'Končaj';
$string['firstanswershould'] = 'Prvi odgovor naj skoči na stran "Pravilno"';
$string['firstwrong'] = 'Odgovor je žal napačen. Bi želeli ponovno poskusiti? Tudi če bo tokrat odgovor pravilen, točk ne boste prejeli.';
$string['flowcontrol'] = 'Nadzor poteka';
$string['fractionsaddwrong'] = 'Pozitivne ocene, ki ste jih izbrali, skupaj ne sestavljajo 100 %.<br />Namesto tega sestavljajo {$a} %.<br />Se želite vrniti in popraviti to vprašanje?';
$string['fractionsnomax'] = 'Eden izmed odgovorov mora biti 100 %, da bo <br />možno dobiti polno oceno za to vprašanje.<br />Se želite vrniti in popraviti to vprašanje?';
$string['full'] = 'Razširjeno';
$string['general'] = 'Splošno';
$string['gotoendoflesson'] = 'Pojdi na konec lekcije';
$string['grade'] = 'Ocena';
$string['gradebetterthan'] = 'Ocena višja od (%)';
$string['gradebetterthanerror'] = 'Zasluži oceno višjo od {$a} odstotkov';
$string['graded'] = 'Ocenjeno';
$string['gradeessay'] = 'Ocene esejskih vprašanj ({$a->notgradedcount} neocenjenih in {$a->notsentcount} neposlanih)';
$string['gradeis'] = 'Ocena je {$a}';
$string['gradeoptions'] = 'Možnosti ocen';
$string['groupoverrides'] = 'Preglasitve skupine';
$string['groupoverridesdeleted'] = 'Preglasitve skupine so izbrisane';
$string['groupsnone'] = 'Ne morete dostopati do skupin.';
$string['handlingofretakes'] = 'Obravnava ponovnega opravljanja';
$string['handlingofretakes_help'] = 'Če je ponavljanje lekcije dovoljeno, ta nastavitev določa, ali se upošteva povprečje ali najvišja ocena vseh poskusov.';
$string['havenotgradedyet'] = 'Še ni ocenjeno.';
$string['here'] = 'sem';
$string['highscore'] = 'Najvišji rezultat';
$string['hightime'] = 'Najdaljši čas';
$string['importcount'] = 'Uvoz {$a} vprašanj';
$string['importquestions'] = 'Uvozite vprašanja';
$string['importquestions_help'] = 'Ta funkcija omogoča uvoz vprašanj v različnih formatih preko tekstovne datoteke. Več o uvozu vprašanj je na voljo <a href="https://docs.moodle.org/36/en/Import_questions">tukaj.</a>';
$string['inactiveoverridehelp'] = '* Ta preglasitev je neaktivna, saj je uporabniku omejen dostop do dejavnosti. Morda ne pripada pravi skupini ali nima določene prave vloge, lahko pa je dostop omejen drugje, ali pa je dejavnost skrita.';
$string['indicator:cognitivedepth'] = 'Lekcija kognitivno';
$string['indicator:cognitivedepth_help'] = 'Ta indikator temelji na kognitivni globini, ki jo je udeleženec dosegel v dejavnosti Lekcija.';
$string['indicator:cognitivedepthdef'] = 'Lekcija kognitivno';
$string['indicator:cognitivedepthdef_help'] = 'Udeleženec je dosegel ta odstotek kognitivne angažiranosti, ki jo ponujajo Dejavnosti lekcije v tem intervalu analize (Ravni = Brez ogleda, Ogled, Oddaja, Ogled povratnih informacij, Komentiranje povratnih informacij, Ponovna oddaja po ogledu povratnih informacij)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Lekcija socialno';
$string['indicator:socialbreadth_help'] = 'Ta kazalnik temelji na socialni širini, ki jo je študent dosegel pri dejavnosti Lekcija.';
$string['indicator:socialbreadthdef'] = 'Lekcija socialno';
$string['indicator:socialbreadthdef_help'] = 'Udeleženec je dosegel ta odstotek družbenega udejstvovanja, ki ga ponujajo Dejavnosti lekcije v tem intervalu analize (Ravni = Brez sodelovanja, Sodelujoči sam, Sodelujoči z drugimi).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Vstavljena stran';
$string['invalidfile'] = 'Neveljavna datoteka';
$string['invalidid'] = 'ID predmetnega modula ali ID lekcije je potekel';
$string['invalidlessonid'] = 'ID lekcije je napačen';
$string['invalidoverrideid'] = 'Neveljaven ID preglasitve';
$string['invalidpageid'] = 'ID strani je neveljaven';
$string['jump'] = 'Skok';
$string['jumps'] = 'Skoki';
$string['jumps_help'] = 'Vsak odgovor (za vprašanja) ali opis (za strani z vsebino) ima dodeljen skok. Skok je lahko relativen (npr. "Ta stran" ali "Naslednja stran") ali absoluten (določen z izborom imena strani).';
$string['jumpsto'] = 'Skok na <em>{$a}</em>';
$string['leftduringtimed'] = 'Zapustili ste časovno merjeno lekcijo.<br />Prosimo, kliknite Nadaljuj za ponovni začetek lekcije.';
$string['leftduringtimednoretake'] = 'Zapustili ste časovno merjeno lekcijo. Ponavljanje ali nadaljevanje <br /> ni dovoljeno.';
$string['leftduringtimedsession'] = 'Zapustili ste časovno merjeno lekcijo.';
$string['lesson:addinstance'] = 'Dodaj novo lekcijo';
$string['lesson:edit'] = 'Uredi dejavnost v lekciji';
$string['lesson:grade'] = 'Oceni eseje';
$string['lesson:manage'] = 'Upravljanje lekcije';
$string['lesson:manageoverrides'] = 'Upravljanje preglasitev lekcije';
$string['lesson:view'] = 'Ogled dejavnosti v lekciji';
$string['lesson:viewreports'] = 'Ogled poročila lekcije';
$string['lessonclosed'] = 'Ta lekcija se je zaprla v {$a}.';
$string['lessoncloses'] = 'Lekcija se bo zaprla';
$string['lessoneventcloses'] = '{$a} se zapre';
$string['lessoneventopens'] = '{$a} se odpre';
$string['lessonformating'] = 'Oblikovanje lekcije';
$string['lessonmenu'] = 'Meni lekcije';
$string['lessonnotready'] = 'Ta lekcija še ni pripravljena za izvedbo. Za pomoč kontaktirajte {$a}.';
$string['lessonnotready2'] = 'Ta lekcija še ni pripravljena za izvedbo.';
$string['lessonopen'] = 'Ta lekcija se odpre v {$a}.';
$string['lessonopens'] = 'Lekcija se bo odprla';
$string['lessonpagelinkingbroken'] = 'Prve strani ni mogoče najti. Povezovanje strani lekcije je prekinjeno. Obrnite se na administratorja.';
$string['lessonstats'] = 'Statistika lekcije';
$string['linkedmedia'] = 'Povezane predstavnostne datoteke';
$string['loginfail'] = 'Prijava ni bila uspešna. Prosimo, poskusite znova ...';
$string['lowscore'] = 'Najnižji rezultat';
$string['lowtime'] = 'Najkrajši čas';
$string['manualgrading'] = 'Oceni eseje';
$string['matchesanswer'] = 'Ujemanja z odgovori';
$string['matching'] = 'Ujemanje';
$string['matchingpair'] = 'Ujemajoči se par {$a}';
$string['maxgrade'] = 'Najvišja ocena';
$string['maxgrade_help'] = 'Ta vrednost določa najvišjo oceno za lekcijo. Če je ocena nastavljena na 0, se lekcija ne pojavi med ocenami.';
$string['maximumnumberofanswersbranches'] = 'Največje število odgovorov';
$string['maximumnumberofanswersbranches_help'] = 'Ta vrednost določa največje število odgovorov, ki jih lahko izvajalec uporabi v lekciji. Če lekcija uporablja samo vprašanja tipa "Resnično/neresnično", kot nastavitev zadostuje 2. Ta nastavitev se lahko kadarkoli spremeni, saj vpliva zgolj na to, kakšen je pogled izvajalca in ne na podatke.';
$string['maximumnumberofattempts'] = 'Največje število poskusov';
$string['maximumnumberofattempts_help'] = 'Ta nastavitev določa največje dovoljeno število poskusov pri odgovarjanju na vprašanja. Če se večkrat zaporedoma na vprašanje odgovori napačno, se bo po doseženem največjem številu poskusov udeleženec premaknil na naslednjo stran.';
$string['maximumnumberofattemptsreached'] = 'Doseženo največje dovoljeno število poskusov - Premik na naslednjo stran';
$string['mediaclose'] = 'Prikaži gumb za zaprtje';
$string['mediafile'] = 'Povezane predstavnostne datoteke';
$string['mediafile_help'] = 'V lekciji se lahko naloži in uporabi medijska datoteka. Povezava »Klikni tukaj za ogled« bo prikazana na vsaki strani lekcije v bloku, imenovanem »Povezane medijske vsebine«.';
$string['mediafilepopup'] = 'Klikni tukaj za ogled';
$string['mediaheight'] = 'Višina pojavnega okna';
$string['mediawidth'] = 'Širina pojavnega okna';
$string['messageprovider:graded_essay'] = 'Obvestilo o ocenjenem eseju';
$string['minimumnumberofquestions'] = 'Najmanjše število vprašanj';
$string['minimumnumberofquestions_help'] = 'Ta nastavitev določa najmanjše število vprašanj, ki bodo uporabljena za izračun ocene dejavnosti.';
$string['missingname'] = 'Prosimo, vpišite vzdevek';
$string['modattempts'] = 'Dovoli pregled udeležencem';
$string['modattempts_help'] = 'To bo omogočilo, da se udeleženci premikajo po lekciji od začetka.';
$string['modattemptsnoteacher'] = 'Pregled udeležencev deluje samo za udeležence.';
$string['modulename'] = 'Lekcija';
$string['modulename_help'] = 'Lekcija omogoča izvajalcu, da posreduje vsebino in/ali praktično dejavnost na zanimiv in prilagodljiv način. Lekcija je sestavljena iz zaporedja strani z vsebino, ki jih lahko po potrebi vejimo. Izvajalec lahko vključi tudi strani z vprašanji različnih tipov (več izbir, kratek odgovor ...), s čimer poveča aktivno udeležbo. Glede na izbor odgovora lahko posameznik bodisi napreduje na naslednjo stran bodisi se vrne na prejšnjo stran (oziroma preide na povsem drugo mesto v lekciji, ki ga določi izvajalec). Navigacija po lekciji je lahko preprosta ali kompleksna, odvisno od strukture predstavljenega gradiva.

Lekcija se lahko ocenjuje, ocena se zabeleži v redovalnici.

Lekcija se lahko uporabi za:

* samostojno učenje novih vsebin,
* študijo primera oz. različnih scenarijev in vaje za simulacijo odločitev,
* študij vsebine s sprotnim preverjanjem razumevanja z uporabo vprašanj';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Lekcije';
$string['move'] = 'Premakni stran';
$string['movedpage'] = 'Premaknjena stran';
$string['movepagehere'] = 'Premakni stran sem';
$string['movepagenamed'] = 'Premakni stran: {$a}';
$string['moving'] = 'Premikanje strani: {$a}';
$string['multianswer'] = 'Več pravilnih odgovorov';
$string['multianswer_help'] = 'Označite to polje, če bo med podanimi možnostmi pravilnih več odgovorov.';
$string['multichoice'] = 'Več izbir';
$string['multipleanswer'] = 'Več pravilnih odgovorov';
$string['nameapproved'] = 'Odobreno ime';
$string['namereject'] = 'Oprostite, filter je zavrnil ime.<br />Prosimo, poskusite z drugim imenom.';
$string['new'] = 'novo';
$string['nextpage'] = 'Naslednja stran';
$string['noanswer'] = 'Ni podanega odgovora. Prosimo, vrnite se in oddajte odgovor.';
$string['noattemptrecordsfound'] = 'Zapisov o poskusu ni mogoče najti: ni podeljene ocene';
$string['nobranchtablefound'] = 'Ni najdenih strani z vsebino';
$string['noclose'] = 'Ni datuma zaključka';
$string['nocommentyet'] = 'Še brez komentarja.';
$string['nocoursemods'] = 'Nobene dejavnosti ni mogoče najti';
$string['nocredit'] = 'Brez kreditnih točk';
$string['nodeadline'] = 'Brez skrajnega roka';
$string['noessayquestionsfound'] = 'V tej lekciji ni esejskih vprašanj.';
$string['nohighscores'] = 'Ni najvišjih rezultatov';
$string['nolessonattempts'] = 'Za to lekcijo še ni bilo opravljenih poskusov.';
$string['nolessonattemptsgroup'] = 'Za to lekcijo še ni bilo opravljenih poskusov s strani članov skupine {$a}.';
$string['none'] = 'Nič';
$string['nooneansweredcorrectly'] = 'Nihče ni odgovoril pravilno.';
$string['nooneansweredthisquestion'] = 'Nihče ni odgovoril na to vprašanje.';
$string['noonecheckedthis'] = 'Nihče ni preveril tega.';
$string['nooneenteredthis'] = 'Nihče ni vnesel tega.';
$string['noonehasanswered'] = 'Na esejska vprašanja še ni nihče odgovoril.';
$string['noonehasansweredgroup'] = 'Nihče v {$a} še ni odgovoril na esejsko vprašanje.';
$string['noopen'] = 'Ni datuma začetka';
$string['nooverridedata'] = 'Preglasiti morate vsaj eno nastavitev lekcije.';
$string['noretake'] = 'Te lekcije ni dovoljeno ponoviti.';
$string['normal'] = 'Normalno - sledite poti lekcije';
$string['notcompleted'] = 'Ni zaključeno';
$string['notcompletedwithdate'] = 'Ni dokončano ({$a})';
$string['notdefined'] = 'Ni definirano';
$string['notenoughsubquestions'] = 'Ni bilo določenih dovolj podvprašanj!';
$string['notenoughtimespent'] = 'To lekcijo ste končali v {$a->timespent}, kar je manj od zahtevanega časa {$a->timerequired}. Morda boste morali ponoviti lekcijo.';
$string['notgraded'] = 'Neocenjeno';
$string['notitle'] = 'Brez naslova';
$string['notyetcompleted'] = 'Lekcija se je začela, vendar še ni zaključena';
$string['numberofcorrectanswers'] = 'Število pravilnih odgovorov: {$a}';
$string['numberofcorrectanswersheader'] = 'Število pravilnih odgovorov';
$string['numberofcorrectmatches'] = 'Število nepravilnih odgovorov: {$a}';
$string['numberofpagestoshow'] = 'Število strani za prikaz';
$string['numberofpagestoshow_help'] = 'Ta nastavitev določa število strani, ki bodo prikazane v lekciji. Uporablja se samo za lekcije s stranmi, ki se prikazujejo v naključnem vrstnem redu (ko je dejanje po pravilnem odgovoru nastavljeno na »Pokaži še neogledano stran« ali »Pokaži še neodgovorjeno stran«). Če je vrednost nastavljena na nič, so prikazane vse strani.';
$string['numberofpagesviewed'] = 'Število odgovorjenih vprašanj: {$a}';
$string['numberofpagesviewedheader'] = 'Število odgovorjenih vprašanj';
$string['numberofpagesviewednotice'] = 'Število odgovorjenih vprašanj: {$a->nquestions} (Odgovoriti je potrebno najmanj na {$a->minquestions} vprašanj)';
$string['numerical'] = 'Številčno';
$string['numericanswer'] = 'Številčni odgovor';
$string['numericanswer_help'] = 'Lahko določite posamezno številko ali več številk z uporabo dvopičja. Na primer 2:5 pomeni, da je pravilen vsak odgovor med 2 in 5, vključujoč 2 in 5.';
$string['offlinedatamessage'] = 'Za ta poskus ste uporabili mobilno napravo. Podatki so bili nazadnje shranjeni na to spletno mesto pred {$a}. Preverite, da nimate neshranjenega dela.';
$string['ongoing'] = 'Prikaži trenutni rezultat';
$string['ongoing_help'] = 'Ta nastavitev omogoča sprotni izpis trenutnega rezultata udeležencem (osvojene točke v primerjavi z vsemi možnimi točkami).';
$string['ongoingcustom'] = 'Do sedaj osvojenih {$a->score} točk od {$a->currenthigh} možnih.';
$string['ongoingnormal'] = 'Pravilnih {$a->correct} odgovorov od {$a->viewed} poskusov.';
$string['onpostperpage'] = 'Samo eno sporočilo na oceno';
$string['openafterclose'] = 'Začetni datum ste določili po končnem datumu';
$string['options'] = 'Možnosti';
$string['or'] = 'ALI';
$string['ordered'] = 'Urejeno';
$string['other'] = 'Drugo';
$string['outof'] = 'Od {$a}';
$string['override'] = 'Preglasi';
$string['overridedeletegroupsure'] = 'Ali ste prepričani, da želite izbrisati preglasitev skupine {$a}?';
$string['overridedeleteusersure'] = 'Ali ste prepričani, da želite izbrisati preglasitev za uporabnika {$a}?';
$string['overridegroup'] = 'Preglasi skupino';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Preglasitve';
$string['overrideuser'] = 'Preglasi uporabnika';
$string['overrideusereventname'] = '{$a->lesson} - Preglasitev';
$string['overview'] = 'Pregled';
$string['overview_help'] = 'Lekcija je sestavljena iz več strani. Stran z vsebino je stran, ki poleg vsebine vsebuje niz povezav (skokov) do drugih strani v lekciji, npr. pripravimo jo lahko kot Kazalo vsebine. Stran z vprašanjem običajno vsebuje nekaj besedila in vprašanje. Z vsakim odgovorom na vprašanje je povezan skok. Skok je lahko <strong>relativen</strong>, npr. Ta stran ali Naslednja stran, ali <strong>absoluten</strong> (določen s točnim imenom strani ali kot Konec lekcije).';
$string['page'] = 'Stran: {$a}';
$string['page-mod-lesson-edit'] = 'Uredi stran lekcije';
$string['page-mod-lesson-view'] = 'Predogled strani lekcije';
$string['page-mod-lesson-x'] = 'Katerakoli stran lekcije';
$string['pageanswers'] = 'Odgovori na strani';
$string['pagecontents'] = 'Vsebina strani';
$string['pageresponses'] = 'Odzivi na strani';
$string['pages'] = 'Strani';
$string['pagetitle'] = 'Naslov strani';
$string['password'] = 'Geslo';
$string['passwordprotectedlesson'] = '{$a} je lekcija, zaščitena z geslom.';
$string['pleasecheckoneanswer'] = 'Preverite en odgovor';
$string['pleasecheckoneormoreanswers'] = 'Prosimo, označite enega ali več odgovorov';
$string['pleaseenteryouranswerinthebox'] = 'Prosimo, vnesite odgovor v polje';
$string['pleasematchtheabovepairs'] = 'Povežite zgornje pare';
$string['pluginadministration'] = 'Skrbništvo lekcije';
$string['pluginname'] = 'Lekcija';
$string['pointsearned'] = 'Prejete točke';
$string['postprocesserror'] = 'Med postobdelavo je prišlo do napake!';
$string['postsuccess'] = 'Objava je uspešna';
$string['practice'] = 'Lekcija za vajo';
$string['practice_help'] = 'Vaja lekcije ne bo prikazana v redovalnici.';
$string['preprocesserror'] = 'Med predobdelavo je prišlo do napake!';
$string['prerequisiteisobsolete'] = 'Predpogoj za dostop do lekcije je v opuščanju. Namesto tega uporabite omejitve dostopa.';
$string['prerequisitelesson'] = 'Predpogoj za dostop do lekcije';
$string['preview'] = 'Predogled';
$string['previewlesson'] = 'Predogled {$a}';
$string['previewpagenamed'] = 'Predogled strani: {$a}';
$string['previouspage'] = 'Prejšnja stran';
$string['privacy:metadata:attempts'] = 'Pregled poskusov na strani';
$string['privacy:metadata:attempts:answerid'] = 'ID odgovora';
$string['privacy:metadata:attempts:correct'] = 'Ali je bil poskus uspešen';
$string['privacy:metadata:attempts:pageid'] = 'ID strani';
$string['privacy:metadata:attempts:retry'] = 'Številka poskusa';
$string['privacy:metadata:attempts:timeseen'] = 'Čas poskusa';
$string['privacy:metadata:attempts:useranswer'] = 'Podrobnosti o odgovoru udeleženca';
$string['privacy:metadata:attempts:userid'] = 'ID uporabnika';
$string['privacy:metadata:branch'] = 'Pregled ogledanih strani';
$string['privacy:metadata:branch:flag'] = 'Ali je bila naslednja stran naključno izračunana';
$string['privacy:metadata:branch:nextpageid'] = 'ID naslednje strani';
$string['privacy:metadata:branch:pageid'] = 'ID strani';
$string['privacy:metadata:branch:retry'] = 'Številka poskusa';
$string['privacy:metadata:branch:timeseen'] = 'Čas ogleda strani';
$string['privacy:metadata:branch:userid'] = 'ID uporabnika';
$string['privacy:metadata:grades'] = 'Pregled ocen za vsako lekcijo';
$string['privacy:metadata:grades:completed'] = 'Datum ocene';
$string['privacy:metadata:grades:grade'] = 'Ocena';
$string['privacy:metadata:grades:userid'] = 'ID uporabnika';
$string['privacy:metadata:overrides'] = 'Pregled opravljenih preglasitev na lekcijo';
$string['privacy:metadata:overrides:available'] = 'Čas, ko lahko udeleženci pričnejo z lekcijo';
$string['privacy:metadata:overrides:deadline'] = 'Skrajni rok za dokončanje lekcije.';
$string['privacy:metadata:overrides:maxattempts'] = 'Največje število poskusov';
$string['privacy:metadata:overrides:password'] = 'Geslo za dostop do lekcije';
$string['privacy:metadata:overrides:retake'] = 'Ali je dovoljeno ponavljanje lekcije';
$string['privacy:metadata:overrides:review'] = 'Ali so dovoljeni večkratni poskusi pri vprašanjih';
$string['privacy:metadata:overrides:timelimit'] = 'Časovna omejitev za zaključek lekcije (v sekundah).';
$string['privacy:metadata:overrides:userid'] = 'ID uporabnika';
$string['privacy:metadata:timer'] = 'Pregled poskusa lekcije';
$string['privacy:metadata:timer:completed'] = 'Ali je poskus dokončan';
$string['privacy:metadata:timer:lessontime'] = 'Čas zadnje zabeležene dejavnosti';
$string['privacy:metadata:timer:starttime'] = 'Datum začetka poskusa';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Čas zadnje zabeležene dejavnosti v mobilni aplikaciji';
$string['privacy:metadata:timer:userid'] = 'ID uporabnika';
$string['privacy:metadata:userpref:lessonview'] = 'Prednostni zaslonski prikaz pri urejanju lekcije';
$string['privacy:path:essayanswers'] = 'Esejski odgovori';
$string['privacy:path:essayresponses'] = 'Esejski odgovori';
$string['privacy:path:pages'] = 'Strani';
$string['processerror'] = 'Med obdelavo je prišlo do napake!';
$string['progressbar'] = 'Vrstica napredovanja';
$string['progressbar_help'] = 'Če je omogočeno, se na dnu lekcije prikazuje vrstica napredovanja, ki izpisuje približen odstotek dokončanosti lekcije.';
$string['progressbarteacherwarning'] = 'Vrstica napredovanja se ne prikazuje: {$a}';
$string['progressbarteacherwarning2'] = 'Vrstice napredovanja ne boste videli, ker lahko to lekcijo urejate';
$string['progresscompleted'] = 'Zaključenih {$a} % lekcije';
$string['qtype'] = 'Tip strani';
$string['question'] = 'Vprašanje';
$string['questionoption'] = 'Vprašanje';
$string['questiontype'] = 'Tip vprašanja';
$string['randombranch'] = 'Naključna stran z vsebino v okviru veje';
$string['randompageinbranch'] = 'Naključno vprašanje na strani z vsebino';
$string['rank'] = 'Razvrstitev';
$string['rawgrade'] = 'Groba ocena';
$string['receivedcredit'] = 'Pridobljene kreditne točke';
$string['redisplaypage'] = 'Ponovn prikaži stran';
$string['removeallgroupoverrides'] = 'Izbriši vse preglasitve skupine';
$string['removealluseroverrides'] = 'Izbriši vse preglasitve uporabnika';
$string['report'] = 'Poročilo';
$string['reports'] = 'Poročila';
$string['response'] = 'Odgovor';
$string['retakesallowed'] = 'Dovoli ponavljanje lekcije';
$string['retakesallowed_help'] = 'Če je to omogočeno, potem lahko udeleženci lekcijo opravljajo več kot enkrat.';
$string['returnto'] = 'Vrni se na {$a}';
$string['returntocourse'] = 'Nazaj na predmet';
$string['reverttodefaults'] = 'Povrni privzete nastavitve lekcije';
$string['review'] = 'Pregled';
$string['reviewlesson'] = 'Pregled lekcije';
$string['reviewquestionback'] = 'Da, želim poskusiti ponovno';
$string['reviewquestioncontinue'] = 'Ne, želim nadaljevati z naslednjim vprašanjem';
$string['sanitycheckfailed'] = 'Preverjanje prištevnosti spodletelo: Poskus je bil izbrisan';
$string['save'] = 'Shrani';
$string['savechanges'] = 'Shrani spremembe';
$string['savechangesandeol'] = 'Shrani vse spremembe in pojdi na konec lekcije.';
$string['saveoverrideandstay'] = 'Shrani in vnesi novo preglasitev';
$string['savepage'] = 'Shrani stran';
$string['score'] = 'Rezultat';
$string['score_help'] = 'Rezultat se uporablja le, če je omogočeno točkovanje po meri. Vsakemu odgovoru se v tem primeru dodeli številčno vrednost (pozitivno ali negativno).';
$string['scores'] = 'Rezultati';
$string['search:activity'] = 'Lekcija - informacije o dejavnosti';
$string['secondpluswrong'] = 'Ne povsem. Želiš poskusiti znova?';
$string['selectallattempts'] = 'Izberi vse poskuse';
$string['selectaqtype'] = 'Izberi tip vprašanja';
$string['sent'] = 'Poslano';
$string['shortanswer'] = 'Kratek odgovor';
$string['showanunansweredpage'] = 'Prikaži še neodgovorjeno stran';
$string['showanunseenpage'] = 'Prikaži še neogledano stran';
$string['singleanswer'] = 'Samo en odgovor';
$string['skip'] = 'Preskoči navigacijo';
$string['slideshow'] = 'Predstavitev';
$string['slideshow_help'] = 'To omogoča prikaz lekcije v obliki diaprojekcije s širino, višino in barvo ozadja določeno po meri.';
$string['slideshowbgcolor'] = 'Barva ozadja predstavitve';
$string['slideshowheight'] = 'Višina predstavitve';
$string['slideshowwidth'] = 'Širina predstavitve';
$string['startlesson'] = 'Začni lekcijo';
$string['studentattemptlesson'] = '{$a->firstname} {$a->lastname}, {$a->attempt}. poskus';
$string['studentname'] = '{$a} Ime';
$string['studentoneminwarning'] = 'Pozor: Še 1 minuta ali manj za zaključek lekcije.';
$string['studentoutoftimeforreview'] = 'Opozorilo: Zmanjkalo je časa za pregled lekcije';
$string['studentresponse'] = 'Odgovor ({$a})';
$string['submit'] = 'Oddaj';
$string['submitname'] = 'Oddaj ime';
$string['teacherjumpwarning'] = 'V tej lekciji je uporabljen skok {$a->cluster} ali {$a->unseen}. Namesto tega bo uporabljen skok na naslednjo stran. Prijavite se kot udeleženec za preizkus teh skokov.';
$string['teacherongoingwarning'] = 'Trenutni rezultat je prikazan samo udeležencem. Prijavite se kot udeleženec za preizkus prikaza trenutnega rezultata.';
$string['teachertimerwarning'] = 'Odštevalnik časa deluje samo za udeležence. Prijavite se kot udeleženec za preizkus odštevalnika.';
$string['thatsthecorrectanswer'] = 'To je pravilen odgovor';
$string['thatsthewronganswer'] = 'To je napačen odgovor';
$string['thefollowingpagesjumptothispage'] = 'Sledeče strani skočijo na to stran';
$string['thispage'] = 'Ta stran';
$string['timeisup'] = 'Čas je potekel';
$string['timelimit'] = 'Časovna omejitev';
$string['timelimit_help'] = 'Če je omogočeno, se na začetku lekcije prikaže opozorilo o časovni omejitvi in odštevalnik časa. Vsi odgovori, podani po preteku časa, niso upoštevani.';
$string['timelimitwarning'] = 'Na voljo imaš <strong>{$a}</strong> za zaključek te lekcije.';
$string['timeremaining'] = 'Preostali čas';
$string['timespenterror'] = 'Za lekcijo porabite vsaj {$a} minut';
$string['timespentminutes'] = 'Porabljeni čas (min)';
$string['timetaken'] = 'Porabljeni čas';
$string['totalpagesviewedheader'] = 'Število ogledanih strani';
$string['true'] = 'Drži';
$string['truefalse'] = 'Drži/ne drži';
$string['unabledtosavefile'] = 'Naložene datoteke ni mogoče shraniti';
$string['unknownqtypesnotimported'] = '{$a} vprašanj z nepodprtimi tipi ni bilo uvoženih';
$string['unseenpageinbranch'] = 'Še neogledano vprašanje v okviru veje';
$string['unsupportedqtype'] = 'Nepodprti tip vprašanja ({$a})!';
$string['updatedpage'] = 'Posodobljena stran';
$string['updatefailed'] = 'Posodobitev ni uspela';
$string['updatepagenamed'] = 'Posodobi stran: {$a}';
$string['usemaximum'] = 'Uporabi najvišji rezultat';
$string['usemean'] = 'Uporabi povprečje';
$string['usepassword'] = 'Lekcija, zaščitena z geslom';
$string['usepassword_help'] = 'To bo udeležencem omogočilo dostop do lekcije v primeru pravilno vnesenega gesla.';
$string['useroverrides'] = 'Preglasitve uporabnika';
$string['useroverridesdeleted'] = 'Preglasitve uporabnika so izbrisane';
$string['usersnone'] = 'Noben udeleženec nima dostopa do te lekcije';
$string['viewessayanswers'] = 'Prikaži esejske odgovore';
$string['viewgrades'] = 'Poglej ocene';
$string['viewreports'] = 'Prikaži {$a->attempts} zaključenih poskusov {$a->student}';
$string['viewreports2'] = 'Ogled {$a} zaključenih poskusov';
$string['warning'] = 'Opozorilo';
$string['welldone'] = 'Dobro opravljeno!';
$string['whatdofirst'] = 'Kaj želite storiti najprej?';
$string['withselectedattempts'] = 'Z izbranimi poskusi...';
$string['wronganswerjump'] = 'Skok ob napačnem odgovoru';
$string['wronganswerscore'] = 'Točke za napačen odgovor';
$string['wrongresponse'] = 'Odziv ob nepravilnem odgovoru';
$string['youhaveseen'] = 'Videli ste že več kot eno stran te lekcije.<br />Želite nadaljevati na zadnji strani, ki ste si jo ogledali?<br />';
$string['youranswer'] = 'Vaš odgovor';
$string['yourcurrentgradeis'] = 'Vaša trenutna ocena je {$a}';
$string['yourcurrentgradeisoutof'] = 'Vaša trenutna ocena je {$a->grade} od {$a->total}';
$string['youshouldview'] = 'Odgovoriti je potrebno na vsaj: {$a}';
