<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'sk', version '4.1'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Prístupnosť';
$string['accessibilitydisabled'] = 'Súprava nástrojov dostupnosti Brickfield nie je na tomto portáli povolená. Ak chcete povoliť, kontaktujte svojho správcu Moodle.';
$string['accessibilityreport'] = 'Nástroj prístupnosti';
$string['accessibilitytool'] = 'Nástroj prístupnosti Brickfield';
$string['accessibilitytools'] = 'Nástroje prístupnosti Brickfield';
$string['activate'] = 'Aktivovať';
$string['activated'] = 'Zásuvný modul je aktivovaný a pripravený na použitie.';
$string['activationform'] = 'Registrácia Brickfield';
$string['activationheader'] = 'Aktivácia Brickfield';
$string['activationinfo'] = '<p>Ak chcete použiť tento doplnok, musíte v tomto formulári poskytnúť platné kľúče pre tento portál.</p><p>Prosím <a href="{$a}" data-action="send_info" target=" _blank">zaregistrujte sa na portáli Brickfield (otvorí sa v novom okne)</a> a získajte tieto kľúče, ak ich ešte nemáte. </p><p>Po aktivácii budú vaše kľúče overené prostredníctvom naplánovaných úloh cronu.</p>';
$string['activityresults:pluginname'] = 'Prehľad nástroja rozdelenia prístupu aktivít';
$string['activityresults:toolname'] = 'Súhrn rozpisu aktivít';
$string['activityresults:toolshortname'] = 'Rozpis aktivít';
$string['advanced:pluginname'] = 'Správa rozšíreného nástroja dostupnosti';
$string['advanced:toolname'] = 'Pokročilé zhrnutie';
$string['advanced:toolshortname'] = 'Pokročilý';
$string['allcourses'] = 'Všetky skontrolované kurzy ({$a})';
$string['allcoursescat'] = 'Všetky skontrolované kurzy pre kategóriu {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Na vyžiadanie';
$string['analysis:disabled'] = 'Zakázané';
$string['analysistype'] = 'Povoliť požiadavky na analýzu';
$string['analysistype_desc'] = 'Povoliť vyžiadanie analýzy dostupnosti obsahu';
$string['analysistypedisabled'] = 'Analýza obsahu je zakázaná';
$string['bannercontentone'] = 'Enterprise Accessibility Toolkit obsahuje celú sadu funkcií, ktoré vašej organizácii pomôžu zlepšiť dostupnosť vašich kurzov. <a href="{$a}">Kontaktujte Brickfield Education Labs</a> a rezervujte si bezplatnú ukážku pokročilých funkcií.';
$string['bannercontenttwo'] = 'Vybudujte efektívnu a inkluzívnu platformu pre výučbu a učenie nájdením obsahu, ktorý nespĺňa pokyny, opravou problémov a zabezpečením budúceho obsahu kurzu Moodle pomocou prístupných súborov, editora a vylepšených funkcií.';
$string['bannerheadingone'] = 'Upgradovať na sadu Enterprise Accessibility Toolkit';
$string['batch'] = 'Limit dávky';
$string['brickfield'] = 'Sada nástrojov Brickfield';
$string['brickfield:viewcoursetools'] = 'Zobraziť správy podľa kurzov';
$string['brickfield:viewsystemtools'] = 'Zobraziť správy pre všetky kurzy';
$string['bulkprocesscaches'] = 'Spracovať hromadné ukladanie do medzipamätí';
$string['bulkprocesscourses'] = 'Spracovať hromadnú kontrolu prístupnosti';
$string['buttonone'] = 'Získať demo zadarmo';
$string['cachepending'] = 'Spracovávajú sa hromadné údaje';
$string['checkdesc:alinksdontopennewwindow'] = 'Odkazy otvárané do nového okna by mali používateľov vopred varovať.';
$string['checkdesc:amustcontaintext'] = 'Odkaz musí obsahovať text, aby bol vnímateľný.';
$string['checkdesc:areadontopennewwindow'] = 'Oblasti používané v obrázkových mapách a otvárané do nového okna by mali používateľov vopred varovať.';
$string['checkdesc:areahasaltvalue'] = 'V oblastiach používaných v obrázkových mapách by nemal chýbať alt (alternatívny) text, podobne ako na obrázkoch.';
$string['checkdesc:asuspiciouslinktext'] = 'Text odkazu by mal byť opisný a mal by poskytovať kontext o jeho cieli.';
$string['checkdesc:basefontisnotused'] = 'Elementy základného písma (tradične používané na formátovanie) nie sú prístupné a nemali by sa používať.';
$string['checkdesc:blinkisnotused'] = 'Blikajúce prvky, ktoré sa zapínajú a vypínajú, nie sú prístupné a nemali by sa používať.';
$string['checkdesc:boldisnotused'] = 'Prvky tučného písma (b) by sa nemali používať. Namiesto toho by sa mal použiť výraz „strong“.';
$string['checkdesc:contenttoolong'] = 'Celková dĺžka obsahu stránky by nemala presiahnuť 500 slov.';
$string['checkdesc:csstexthascontrast'] = 'Farebný kontrast medzi textom a pozadím je príliš nízky.';
$string['checkdesc:embedhasassociatednoembed'] = 'Embed prvkom (na vkladanie multimédií) by nemali chýbať ich zodpovedajúce „noembed“ prvky.';
$string['checkdesc:headerh3'] = 'Hlavičky nasledujúce po hlavičkách H3 (možnosť veľkých hlavičiek editora) by nemali narúšať hierarchiu nadpisov stránky.';
$string['checkdesc:headershavetext'] = 'Hlavička musí obsahovať text, aby bola vnímateľná.';
$string['checkdesc:iisnotused'] = 'Prvky kurzívy (i) by sa nemali používať. Namiesto toho by sa malo použiť „em“.';
$string['checkdesc:imgaltisdifferent'] = 'Alternatívny (alt) text obrázka by nemal byť názov súboru obrázka.';
$string['checkdesc:imgaltistoolong'] = 'Alternatívny (alt) text obrázka by nemal presiahnuť maximálny povolený počet (125) znakov.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Alternatívny (alt) text obrázka by nemal byť prázdny, najmä ak má obrázok odkaz smerujúci inam.';
$string['checkdesc:imgaltnotplaceholder'] = 'Alternatívny (alt) text obrázka by nemal byť jednoduchým zástupným textom, ako napríklad „obrázok“.';
$string['checkdesc:imghasalt'] = 'Pri obrazových prvkoch by nemal chýbať alt (alternatívny) text obrázka, pokiaľ nie je čisto dekoratívny bez významu.';
$string['checkdesc:imgwithmaphasusemap'] = 'Obrazové mapy s oblasťami, na ktoré sa dá kliknúť, musia zodpovedať prvkom „usemap“ a „map“.';
$string['checkdesc:legendtextnotempty'] = 'Prvky legendy používané na opisovanie prvkov sady polí by mali obsahovať text.';
$string['checkdesc:marqueeisnotused'] = 'Prvky rámčeku (automatické posúvanie) nie sú prístupné a nemali by sa používať.';
$string['checkdesc:noheadings'] = 'Bez hlavičiek je obsah menej štruktúrovaný a ťažšie čitateľný.';
$string['checkdesc:objectmusthaveembed'] = 'Objektovým prvkom (na vkladanie externých zdrojov) by nemali chýbať ich zodpovedajúce „embed“ prvky.';
$string['checkdesc:objectmusthavetitle'] = 'Objektovým prvkom (na vkladanie externých zdrojov) by nemali chýbať ich zodpovedajúce „title“ opisy.';
$string['checkdesc:objectmusthavevalidtitle'] = 'Prvky objektu (na vkladanie externých zdrojov) by mali mať zodpovedajúce „titles“ s textom.';
$string['checkdesc:strikeisnotused'] = 'Prvky prečiarknutia (strike) by sa nemali používať. Namiesto toho by sa malo použiť "del" (vymazané).';
$string['checkdesc:tabledatashouldhaveth'] = 'V tabuľkách by v ideálnom prípade nemali chýbať hlavičky.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Súhrny tabuliek a titulky by nemali byť totožné.';
$string['checkdesc:tabletdshouldnotmerge'] = 'V ideálnom prípade by tabuľky nemali obsahovať žiadne zlúčené bunky.';
$string['checkdesc:tablethshouldhavescope'] = 'Mali by byť deklarované rozsahy riadkov alebo stĺpcov tabuľky (používané na mapovanie riadkov a stĺpcov ku každej bunke).';
$string['checkidvalidation'] = 'Úloha skontrolovať prípadné neplatné Id chýb';
$string['checkscompleted'] = 'Dokončené kontroly: {$a}';
$string['checktype'] = 'Skontrolovať skupinu';
$string['checktype:form'] = 'Formulár';
$string['checktype:image'] = 'Obrázok';
$string['checktype:layout'] = 'Rozloženie';
$string['checktype:link'] = 'Odkaz';
$string['checktype:media'] = 'Médiá';
$string['checktype:table'] = 'Tabuľka';
$string['checktype:text'] = 'Text';
$string['checktyperesults:pluginname'] = 'Prehľad nástroja dostupnosti typov obsahu';
$string['checktyperesults:toolname'] = 'Súhrn typov obsahu';
$string['checktyperesults:toolshortname'] = 'Typy obsahu';
$string['cmpercent'] = 'Percento aktivít celkom';
$string['cmpercenterrors'] = 'Percento chýb celkom';
$string['cmpercenttitle'] = 'Celkové % rozdelenia aktivity verzus chyby';
$string['confirmationmessage'] = 'Tento kurz bol naplánovaný na analýzu. Analýza bude dokončená najskôr
za {$a}. Vráťte sa sem potom.';
$string['contactadmin'] = 'Ak chcete dokončiť registráciu, kontaktujte svojho správcu.';
$string['contactus'] = 'Kontaktujte nás';
$string['contentfive'] = 'Automaticky opravovať zastarané značky HTML.';
$string['contentfour'] = 'Identifikujte, ktoré aktivity majú najviac problémov s prístupnosťou, aby ste mohli uprednostniť úsilie.';
$string['contentone'] = 'Automaticky vyhodnocujte obsah vášho kurzu a hodnotenia z hľadiska problémov s prístupnosťou.';
$string['contentsix'] = 'Poskytnite učiteľom včas tipy na vytváranie lepšieho obsahu.';
$string['contentthree'] = 'Poskytnite svojim študentom obsah v prístupných formátoch vrátane zvuku, ePub a elektronického Braillovho písma.';
$string['contenttwo'] = 'Hromadná aktualizácia nejasného alebo chýbajúceho textu pre webové odkazy, opisy obrázkov a titulky videí.';
$string['contenttypeerrors'] = 'Celkové výsledky testov obsahu aktivity podľa kurzu a typu obsahu.';
$string['contentyperesults'] = 'Celkový počet úspešných/neúspešných pre obsahové oblasti na kurz.';
$string['contextid'] = 'Kontextové';
$string['core_course'] = 'Kurz';
$string['core_question'] = 'Banka úloh';
$string['count'] = 'Počet';
$string['country'] = 'Krajina';
$string['country_help'] = 'Krajina portálu';
$string['coursecount'] = 'Počet kurzov';
$string['deletehistoricaldata'] = 'Odstrániť výsledky minulých kontrol';
$string['dependency'] = 'V závislosti na';
$string['emptycategory'] = 'Pre kategóriu {$a} neboli nájdené žiadne kurzy';
$string['emptytagcourses'] = 'Nenašli sa žiadne výsledky pre kurzy s nakonfigurovanými značkami';
$string['enableaccessibilitytools'] = 'Povoliť nástroje prístupnosti';
$string['enableaccessibilitytools_desc'] = 'Súprava nástrojov prístupnosti pomáha identifikovať problémy s prístupnosťou v kurzoch.';
$string['error:nocoursespecified'] = 'Táto súhrnná správa vyžaduje platné ID kurzu. Získajte prístup k súprave nástrojov prístupnosti z kurzu prostredníctvom ponuky akcií, ktorá potom poskytne toto požadované ID kurzu.';
$string['errorlink'] = 'Upraviť výskyt chyby pre {$a}';
$string['errors'] = 'Chyby: {$a}';
$string['errors:pluginname'] = 'Chybový zoznam nástroja prístupnosti';
$string['errors:toolname'] = 'Súhrn zoznamu chýb';
$string['errors:toolshortname'] = 'Zoznam chýb';
$string['eventanalysis_requested'] = 'Požadovaná analýza obsahu';
$string['eventanalysis_requesteddesc'] = 'Pre kurz {$a} bola požadovaná analýza obsahu.';
$string['eventreport_downloaded'] = 'Súhrn prístupnosti bol stiahnutý';
$string['eventreport_downloadeddesc'] = 'Súhrn prístupnosti bol stiahnutý pre ID kurzu {$a}.';
$string['eventreport_viewed'] = 'Správa o prístupnosti zobrazená';
$string['eventreport_vieweddesc'] = 'Správa o prístupnosti bola zobrazená pre ID kurzu {$a->course}, id kategórie {$a->category}, karta {$a->tab}.';
$string['failed'] = 'Zlyhalo';
$string['failedcount'] = 'Zlyhalo: {$a}';
$string['footerheading'] = 'Sekcia päty';
$string['fullcachedone'] = 'Zakázať znovu spustiť ukladanie do medzipamäte';
$string['hashcorrect'] = 'Zadaný kód je správny.';
$string['hashincorrect'] = 'Zadaný kód je nesprávny.';
$string['headingfive'] = 'Opravy HTML';
$string['headingfour'] = 'Zamerať úsilie';
$string['headingone'] = 'Vyhodnotiť obsah';
$string['headingsix'] = 'Podpora výkonu';
$string['headingthree'] = 'Prístupné formáty súborov';
$string['headingtwo'] = 'Náprava';
$string['hideshow'] = 'Skryť / zobraziť';
$string['inactive'] = 'Plugin je neaktívny a nedá sa použiť. Zadajte platné registračné kľúče a stlačte „Aktivovať“.';
$string['innercontextid'] = 'Vnútorný kontext';
$string['installed'] = 'Plugin nainštalovaný';
$string['installedcli'] = 'Plugin nainštalovaný pomocou príkazového riadka';
$string['installeddescription'] = 'Plugin bol nainštalovaný, presmerovaný na aktivačný formulár.';
$string['invalidaccessibilitytool'] = 'Vyžaduje sa neplatný subplugin prístupnosti.';
$string['invalidcategoryid'] = 'Neplatná kategória, skontrolujte prosím svoj vstup';
$string['invalidcourseid'] = 'Neplatný kurz, skontrolujte svoje údaje';
$string['invalidlinkphrases'] = 'click|click here|here|more|more here|info|info here|information|information here|read more|read more here|further information|further information here|further details|further details here';
$string['language'] = 'Jazyk';
$string['language_help'] = 'Jazyk portálu';
$string['messageprovider:warningcheckid'] = 'Varovanie pred neplatnými chybami';
$string['mobileservice'] = 'Mobilné služby povolené ({$a})';
$string['module'] = 'Modul';
$string['modulename'] = 'Názov';
$string['moreinfo'] = 'Viac informácií';
$string['noerrorsfound'] = 'Pre vaše parametre vyhľadávania sa nenašli žiadne bežné chyby dostupnosti. Gratulujeme!';
$string['norecords'] = 'Pre vaše parametre vyhľadávania sa nenašli žiadne relevantné záznamy.';
$string['notregistered'] = 'Je potrebné zaregistrovať vašu sadu nástrojov na uľahčenie prístupu.';
$string['notvalidated'] = 'Vaša sada nástrojov na uľahčenie prístupu je počas overovania funkčná.';
$string['numcourses'] = 'Počet kurzov ({$a})';
$string['numfactivities'] = 'Počet aktivít ({$a})';
$string['numfiles'] = 'Počet súborov ({$a})';
$string['numinstances'] = 'Počet inštancií';
$string['numusers'] = 'Počet používateľov ({$a})';
$string['pagedesc:checktype'] = '<p>S cieľom zhrnúť a analyzovať výsledky rôznych vykonaných kontrol zoskupujeme tieto kontroly do rôznych typov obsahu. Všetky výsledky kontroly prístupnosti súvisiacej s obrázkom sú teda v skupine typu obsahu „Obrázok“, všetky výsledky kontroly prístupnosti súvisiacej s rozložením sú v skupine typu obsahu „Rozloženie“ atď.</p><p>Zahrnuté sú aj aktivity. ako aktivity, zdroje alebo oblasti obsahu týkajúce sa samotných kurzov.</p><p>Stránka s grafom typov obsahu zobrazuje rozdelenie chýb podľa skupín typov obsahu: Obrázok, Rozloženie, Odkaz, Médiá, Tabuľka a Text.</ p>';
$string['pagedesc:pertarget'] = '<p>Aby sme zhrnuli a analyzovali výsledky kontrol podľa aktivity, zoskupujeme tieto výsledky kontrol do rôznych zistených aktivít.</p><p>Aktivity sú zahrnuté buď ako aktivity, zdroje alebo iné oblasti obsahu súvisiace s kurzmi sami. Každá aktivita bez zistených chýb sa počíta ako úspešná, každá aktivita s jednou alebo viacerými zistenými chybami sa počíta ako neúspešná. Potom sa zobrazí pomer splnených a nesplnených aktivít.</p><p>Stránka s grafom rozdelenia aktivít zobrazuje celkový pomer odovzdaných a neúspešných inštancií podľa aktivity, ako je úloha, kurz, štítok atď.</p>';
$string['pagedesctitle:checktype'] = 'Vysvetlenie typov obsahu';
$string['pagedesctitle:pertarget'] = 'Vysvetlenie rozdelenia aktivít';
$string['passed'] = 'Splnené';
$string['passedcount'] = 'Splnené: {$a}';
$string['passrate'] = 'Miera úspešnosti: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Počet konkrétnych testov a chýb na kontrolu na kurz.';
$string['perpage'] = 'Položiek zobrazených na stránku';
$string['pluginname'] = 'Sada nástrojov prístupnosti';
$string['printable:downloadpdf'] = 'Stiahnuť PDF';
$string['printable:pluginname'] = 'Súhrnná správa nástroja na uľahčenie prístupu';
$string['printable:printreport'] = 'Správa pre tlač';
$string['printable:toolname'] = 'Súhrnná správa';
$string['printable:toolshortname'] = 'Súhrnná správa';
$string['privacy:metadata'] = 'Doplnok Správa kontroly prístupnosti neukladá žiadne osobné údaje.';
$string['processanalysisrequests'] = 'Spracovať požiadavky na analýzu obsahu';
$string['registernow'] = 'Zaregistrujte sa teraz.';
$string['registration'] = 'Registračný formulár';
$string['registrationinfo'] = '<p>Tento registračný proces vám umožňuje používať štartovaciu verziu súpravy nástrojov dostupnosti Brickfield pre váš zaregistrovaný portál Moodle.</p><p>Toto použitie sa vzťahuje na <a href="{$a}" target="_blank" >Zmluvné podmienky Brickfield Education Labs (otvoria sa v novom okne)</a> a s ktorými súhlasíte používaním tohto produktu.</p>';
$string['release'] = 'Verzia Moodle ({$a})';
$string['remaining'] = '(počet zostávajúcich chýb: {$a})';
$string['response:0'] = 'Táto adresa URL nikam nesmeruje';
$string['response:404'] = 'Táto stránka URL nebola nájdená';
$string['schedule:blocknotscheduled'] = '<p> Tento kurz zatiaľ nebol naplánovaný na analýzu, aby sa zistili bežné problémy s prístupnosťou. </p>';
$string['schedule:notscheduled'] = '<p>Tento kurz ešte nebol naplánovaný na analýzu s cieľom nájsť bežné problémy s prístupnosťou.</p><p>Kliknutím na tlačidlo „Odoslať na analýzu“ potvrdzujete, že chcete všetok relevantný obsah HTML kurzu, ako napr. opisy sekcií kurzu, popisy aktivít, otázky, stránky a ďalšie, ktoré sa majú naplánovať na analýzu.</p><p>Táto analýza vykoná viacero bežných kontrol prístupnosti obsahu HTML vášho kurzu a tieto výsledky sa potom zobrazia na týchto prístupnosti stránky s prehľadmi nástrojov. Analýza bude spracovaná na pozadí naplánovanými úlohami, takže jej rýchlosť dokončenia bude závisieť od načasovania úloh a plánov spustenia úloh.</p>';
$string['schedule:requestanalysis'] = 'Odoslať na analýzu';
$string['schedule:scheduled'] = 'Tento kurz bol naplánovaný na analýzu.';
$string['schedule:sitenotscheduled'] = '<p>Globálny (nezávislý na kurze) obsah ešte nebol naplánovaný na analýzu s cieľom nájsť bežné problémy s prístupnosťou.</p><p>Kliknutím na tlačidlo „Odoslať na analýzu“ potvrdzujete, že chcete všetok relevantný globálny obsah (nezávislý od kurzu) naplánovať na analýzu.</p><p>Táto analýza vykoná viacero bežných kontrol dostupnosti tohto obsahu a tieto výsledky sa potom zobrazia na týchto stránkach prehľadov súpravy nástrojov dostupnosti. Analýza bude spracovaná na pozadí naplánovanými úlohami, takže jej rýchlosť dokončenia bude závisieť od načasovania úloh a plánov spustenia úloh.</p>';
$string['schedule:sitescheduled'] = 'Globálny (od kurzu nezávislý) obsah bol naplánovaný na analýzu.';
$string['secretkey'] = 'Kľúč API';
$string['secretkey_help'] = 'Tento kód dostanete e-mailom po registrácii.';
$string['sendfollowinginfo'] = '<p> Nasledujúce informácie budú pravidelne zasielané, aby prispeli iba k celkovým štatistikám. Nebudú zverejnené v žiadnom centrálnom zozname. </p> {$a}';
$string['settings'] = 'Nastavenie sady prístupnosti';
$string['sitehash'] = 'Súkromný kľúč';
$string['sitehash_help'] = 'Tento kód dostanete e-mailom po registrácii.';
$string['taberrors'] = 'Kontrola chýb';
$string['targetavetitle'] = 'Priemerné chyby na aktivitu';
$string['targetpercentage'] = 'Percento inštancií splnených/nesplnených na aktivitu';
$string['targetratio'] = 'Miera úspešnosti aktivity';
$string['tblcheck'] = 'Skontrolovať';
$string['tblcheckexample'] = 'Príklad';
$string['tblcheckfailed'] = 'Kontroly zlyhali';
$string['tblchecksummary'] = 'Súhrn';
$string['tbledit'] = 'Upraviť';
$string['tblerrorcount'] = 'Chyby';
$string['tblhtmlcode'] = 'Existujúci kód HTML';
$string['tblinstance'] = 'Inštancia';
$string['tblline'] = 'Čiara';
$string['tbloverallpercentage'] = 'Celkové chyby%';
$string['tblpercentage'] = 'Percento';
$string['tblpreview'] = 'Náhľad';
$string['tbltarget'] = 'Aktivita';
$string['tblupdateto'] = 'Aktualizovať na';
$string['titleactivityresultsall'] = 'Výsledky na aktivitu: všetky preskúmané kurzy ({$a->count} kurzy/ov)';
$string['titleactivityresultspartial'] = 'Výsledky za aktivitu: kurz {$a->name}';
$string['titleall'] = 'Podrobnosti o chybe: všetky preskúmané kurzy ({$a->count} kurzy/ov)';
$string['titlechecktyperesultsall'] = 'Výsledky podľa typu obsahu: všetky preskúmané kurzy ({$a->count} kurzy/ov)';
$string['titlechecktyperesultspartial'] = 'Výsledky podľa typu obsahu: kurz {$a->name}';
$string['titleerrorsall'] = 'Podrobnosti o chybách: všetky preskúmané kurzy ({$a->count} kurzy/ov)';
$string['titleerrorscount'] = 'Podrobnosti o chybách: (zobrazené prvé {$a} chyby)';
$string['titleerrorspartial'] = 'Podrobnosti o chybách: kurz {$a->name}';
$string['titlepartial'] = 'Podrobnosti o chybách: kurz {$a->name}';
$string['titleprintableall'] = 'Kurz {$a->name}';
$string['titleprintablepartial'] = 'Kurz {$a->name}';
$string['tools'] = 'Správy';
$string['toperrors'] = 'Najčastejšie chyby';
$string['toptargets'] = 'Neúspešné aktivity';
$string['totalactivities'] = 'Aktivity celkom';
$string['totalactivitiescount'] = 'Aktivity celkom: {$a}';
$string['totalareas'] = 'Celkom oblastí';
$string['totalerrors'] = 'Celkom chyby';
$string['totalgrouperrors'] = 'Celkom (súčet) chýb na typ obsahu';
$string['updatesummarydata'] = 'Aktualizovať súhrnné údaje portálu';
$string['usersmobileregistered'] = 'Počet používateľov s registrovanými mobilnými zariadeniami ({$a})';
$string['validationerror'] = 'Overenie registračného kľúča zlyhalo. Skontrolujte, či sú adresy URL a kľúče vašeho zaregistrovaného portálu správne.';
$string['warningcheckidbody'] = 'Došlo k problému s kontrolou Brickfield ktorý je aktívny, ale nie je uvedený v databáze. Preskúmajte to prosím.';
$string['warningcheckidsubject'] = 'Varovanie checkID nástroja Brickfield Toolkit';
