<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_preg', language 'ru', version '4.1'.
 *
 * @package     qtype_preg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept_leaf_control'] = '';
$string['answerno'] = 'Ответ {$a}';
$string['answersinstruct'] = '<p>Введите регулярные выражения (как минимум одно) в выбранной нотации в качестве ответов. Если дан корректный ответ, он должен совпадать минимум с одним 100% ответом.</p><p>Вы можете использовать конструкцию вида {$0} в отзывах для того, чтобы вставить захваченные части ответа студента. {$0} будет заменено совпадением в целом, {$1} - совпадением с первым подвыражением и т.д. Если выбранный движок поиска не поддерживает подвыражения, вы должны использовать только {$0}.</p>';
$string['any_leaf_control'] = '';
$string['anycrlf_leaf_control'] = '';
$string['assertfailmodeasis'] = 'Быстрый';
$string['assertfailmodedescription'] = 'Полный режим позволяет движку конечных автоматов работать на 100% верно с простыми утверждениями при генерации подсказок и добавляет поддержку сложных утверждений. Полный режим работает примерно в 2 раза медленнее. Быстрый режим может в редких случаях выдавать неверную подсказку для сложных регулярных выражений, содержащих утверждения \\b или \\B.';
$string['assertfailmodelabel'] = 'Режим поддержки утверждений';
$string['assertfailmodemerge'] = 'Полный';
$string['authoring_form_charset_flags'] = 'реальное значение (унифицированный формат)';
$string['authoring_form_charset_mode'] = 'Режим отображения для сложных символьных классов:';
$string['authoring_form_charset_userinscription'] = 'как написано в регулярных выражениях';
$string['authoring_form_check_strings'] = 'Проверить строку (строки)';
$string['authoring_form_edit_header'] = 'Регулярное выражение';
$string['authoring_form_edit_header_help'] = 'Введите регулярное выражение здесь. Вы увидите соответствующее синтаксическое дерево, объясняющий граф и и словесное описание. Нажмите «Обновить» чтобы принять изменения в регулярном выражении.';
$string['authoring_form_graph_build'] = 'Построение графа...';
$string['authoring_form_options_header'] = 'Настройки поиска совпадений';
$string['authoring_form_options_header_help'] = 'Здесь вы можете настроить поиск совпадений. Эти опции будут сохранены в форме редактирования вопроса.';
$string['authoring_form_page_header'] = 'Конструктор регулярных выражений';
$string['authoring_form_rect_selection_mode'] = 'Режим выделения прямоугольником';
$string['authoring_form_rect_selection_select'] = 'Отправить';
$string['authoring_form_testing_header'] = 'Тестирование регулярного выражения';
$string['authoring_form_testing_header_help'] = 'Здесь вы можете ввести некоторые строки (каждую строку с новой строки), чтобы проверить регулярное выражение. После нажатия кнопки "Проверить строку (строки)" результаты будут отображены справа: совпавшие части выделены зеленым цветом, не совпавшие части красным. Иконка показывает вам, со всем ли регулярным выражением совпала строка.';
$string['authoring_form_testing_textarea'] = 'Введите строки для проверки (каждую строку с новой строки)';
$string['authoring_form_text'] = 'Введите регулярное выражение:';
$string['authoring_form_tooltip'] = 'Открыть конструктор регулярных выражений';
$string['authoring_form_tree_build'] = 'Построение дерева...';
$string['backref_intersection'] = 'Использование обратных ссылок с утверждениями пока не поддерживается.';
$string['bsr_anycrlf_leaf_control'] = '';
$string['bsr_unicode_leaf_control'] = '';
$string['c_at_end_of_pattern_node_error'] = 'Синтаксическая ошибка: \\c в конце шаблона';
$string['callout_big_number_node_error'] = 'Номер {$a->addinfo} callout слишком большой, он не должен превышать 255';
$string['capital_esc_z_leaf_assert'] = 'конец строки';
$string['char_code_disallowed_node_error'] = 'Unicode-коды 0xd800 ... 0xdfff не разрешены';
$string['char_code_too_big_node_error'] = 'Код символа {$a->addinfo} слишком большой';
$string['charhintpenalty'] = 'Штраф за подсказку следующего символа';
$string['charhintpenalty_help'] = 'Штраф за подсказку следующего символа. Обычно должен быть больше, чем штраф, даваемый за каждую новую попытку ответа на вопрос без подсказки. Эти штрафы взаимоисключающие.';
$string['circumflex_leaf_assert'] = 'начало строки';
$string['collapsed_node'] = 'свернутое подвыражение';
$string['commit_leaf_control'] = '';
$string['condsubexpr_assert_expected_node_error'] = 'Ожидалось утверждение или условие';
$string['condsubexpr_too_much_alter_node_error'] = 'Синтаксическая ошибка: слишком много альтернатив на верхнем уровне в условном подвыражении в позиции с {$-> colfirst} до {$-> collast}. Используйте скобки, если вы хотите включить больше альтернатив';
$string['condsubexpr_zero_condition_node_error'] = 'Неверное условие (?(0)';
$string['correctanswer'] = 'Правильный ответ';
$string['correctanswer_help'] = 'Введите правильный ответ (не регулярное выражение) для показа студентам. Если вы оставите его пустым, preg попытается его сгенерировать сам, пытаясь сделать его наиболее похожим на ответ студента. На данный момент генерировать ответы может только движок конечных автоматов.';
$string['cr_leaf_control'] = '';
$string['crlf_leaf_control'] = '';
$string['cx_should_be_ascii_node_error'] = '\\c должно сопровождаться символом ASCII';
$string['debugheading'] = 'Отладочные настройки';
$string['defaultenginedescription'] = 'Движок поиска совпадений, используемый по умолчанию при создании нового вопроса';
$string['defaultenginelabel'] = 'Движок поиска совпадений, используемый по умолчанию';
$string['defaultlangdescription'] = 'Язык, используемый по умолчанию при создании нового вопроса';
$string['defaultlanglabel'] = 'Язык, используемый по умолчанию';
$string['defaultnotationdescription'] = 'Нотация, используемая по умолчанию при создании нового вопроса';
$string['defaultnotationlabel'] = 'Нотация, используемая по умолчанию';
$string['define_node_cond_subexpr'] = '"определение"-условного подвыражения';
$string['description_accept_leaf_control'] = 'спровоцировать удачное совпадение';
$string['description_any_leaf_control'] = 'с новой строкой совпадает любой Unicode символ новой строки';
$string['description_anycrlf_leaf_control'] = 'с новой строкой совпадает возврат каретки, перевод строки или возврат каретки, сопровождаемый переводом строки';
$string['description_bsr_anycrlf_leaf_control'] = '\\R совпадает с CR, LF, или CRLF';
$string['description_bsr_unicode_leaf_control'] = '\\R совпадает с любым Unicode символом новой строки';
$string['description_capital_esc_z_leaf_assert'] = 'конец строки';
$string['description_char'] = '<span class="text-info" class=\'font-family:"Courier New", Courier, monospace;\'>{$a->char}</span>';
$string['description_char0'] = 'ноль-символ(NUL)';
$string['description_char1'] = 'символ начала заголовка(SOH)';
$string['description_char10'] = 'символ освобождения канала данных(DLE)';
$string['description_char11'] = 'символ управления устройством(DC1)';
$string['description_char12'] = 'символ управления устройством(DC2)';
$string['description_char13'] = 'символ управления устройством(DC3)';
$string['description_char14'] = 'символ управления устройством(DC4)';
$string['description_char15'] = 'символ неподтверждения(NAK)';
$string['description_char16'] = 'символ синхронизации(SYN)';
$string['description_char17'] = 'конца текстового блока(ETB)';
$string['description_char18'] = 'символ отмены(CAN)';
$string['description_char19'] = 'конец носителя(EM)';
$string['description_char1A'] = 'подставитель(SUB)';
$string['description_char1B'] = 'esc-символ(ESC)';
$string['description_char1C'] = 'разделитель файлов(FS)';
$string['description_char1D'] = 'разделитель групп(GS)';
$string['description_char1E'] = 'разделитель записей(RS)';
$string['description_char1F'] = 'разделитель юнитов(US)';
$string['description_char2'] = 'символ начала текста(STX)';
$string['description_char20'] = 'пробел';
$string['description_char2002'] = 'en пробел';
$string['description_char2003'] = 'em пробел';
$string['description_char2009'] = 'тонкий пробел';
$string['description_char200C'] = 'zero width non-joiner';
$string['description_char200D'] = 'zero width joiner';
$string['description_char3'] = 'символ конца текста(ETX)';
$string['description_char4'] = 'символ конца передачи(EOT)';
$string['description_char5'] = 'символ запроса подтверждения(ENQ)';
$string['description_char6'] = 'символ подтверждения(ACK)';
$string['description_char7'] = 'символ звукового сигнала (BEL)';
$string['description_char7F'] = 'символ удаления(DEL)';
$string['description_char8'] = 'символ удаления(BS)';
$string['description_char9'] = 'табуляция(HT)';
$string['description_charA'] = 'перевод строки(LF)';
$string['description_charA0'] = 'неразрывный пробел';
$string['description_charAD'] = 'символ мягкого переноса';
$string['description_charB'] = 'вертикальная табуляция(VT)';
$string['description_charC'] = 'символ новой страницы(FF)';
$string['description_charD'] = 'символ возврата каретки(CR)';
$string['description_charE'] = 'shift out символ(SO)';
$string['description_charF'] = 'shift in символ(SI)';
$string['description_char_16value'] = 'символ с кодом 0x{$a->code}';
$string['description_charflag_Arabic'] = 'Арабский символ';
$string['description_charflag_Arabic_neg'] = 'Не арабский символ';
$string['description_charflag_Armenian'] = 'Армянский символ';
$string['description_charflag_Armenian_neg'] = 'не Армянский символ';
$string['description_charflag_Avestan'] = 'Авестийский символ';
$string['description_charflag_Avestan_neg'] = 'не Авестийский символ';
$string['description_charflag_Balinese'] = 'Balinese символ';
$string['description_charflag_Balinese_neg'] = 'не Balinese символ';
$string['description_charflag_Bamum'] = 'Bamum символ';
$string['description_charflag_Bamum_neg'] = 'не Bamum символ';
$string['description_charflag_Bengali'] = 'Bengali символ';
$string['description_charflag_Bengali_neg'] = 'не Bengali символ';
$string['description_charflag_Bopomofo'] = 'Bopomofo символ';
$string['description_charflag_Bopomofo_neg'] = 'не Bopomofo символ';
$string['description_charflag_Braille'] = 'Braille символ';
$string['description_charflag_Braille_neg'] = 'не Braille символ';
$string['description_charflag_Buginese'] = 'Buginese символ';
$string['description_charflag_Buginese_neg'] = 'не Buginese символ';
$string['description_charflag_Buhid'] = 'Buhid символ';
$string['description_charflag_Buhid_neg'] = 'не Buhid символ';
$string['description_charflag_C'] = 'непечатный символ или неиспользуемый код символа';
$string['description_charflag_C_neg'] = 'не непечатный символ или неиспользуемый код символа';
$string['description_charflag_Canadian_Aboriginal'] = 'Canadian Aboriginal символ';
$string['description_charflag_Canadian_Aboriginal_neg'] = 'не Canadian Aboriginal символ';
$string['description_charflag_Carian'] = 'Carian символ';
$string['description_charflag_Carian_neg'] = 'не Carian символ';
$string['description_charflag_Cc'] = 'ASCII или Latin-1 служебный символ';
$string['description_charflag_Cc_neg'] = 'не ASCII или Latin-1 служебный символ';
$string['description_charflag_Cf'] = 'непечатные символы форматирования (Unicode)';
$string['description_charflag_Cf_neg'] = 'не непечатные символы форматирования (Unicode)';
$string['description_charflag_Cham'] = 'Cham символ';
$string['description_charflag_Cham_neg'] = 'не Cham символ';
$string['description_charflag_Cherokee'] = 'Cherokee символ';
$string['description_charflag_Cherokee_neg'] = 'не Cherokee символ';
$string['description_charflag_Cn'] = 'символ, отсутствующий в Unicode,';
$string['description_charflag_Cn_neg'] = 'не символ, отсутствующий в Unicode,';
$string['description_charflag_Co'] = 'символ с кодом, выделенным для приватного использования,';
$string['description_charflag_Co_neg'] = 'не символ с кодом, выделенным для приватного использования,';
$string['description_charflag_Common'] = 'Common символ';
$string['description_charflag_Common_neg'] = 'не Common символ';
$string['description_charflag_Coptic'] = 'Coptic символ';
$string['description_charflag_Coptic_neg'] = 'не Coptic символ';
$string['description_charflag_Cs'] = 'surrogate';
$string['description_charflag_Cs_neg'] = 'не surrogate';
$string['description_charflag_Cuneiform'] = 'Cuneiform символ';
$string['description_charflag_Cuneiform_neg'] = 'не Cuneiform символ';
$string['description_charflag_Cypriot'] = 'Cypriot символ';
$string['description_charflag_Cypriot_neg'] = 'не Cypriot символ';
$string['description_charflag_Cyrillic'] = 'Cyrillic символ';
$string['description_charflag_Cyrillic_neg'] = 'не Cyrillic символ';
$string['description_charflag_Deseret'] = 'Deseret символ';
$string['description_charflag_Deseret_neg'] = 'не Deseret символ';
$string['description_charflag_Devanagari'] = 'Devanagari символ';
$string['description_charflag_Devanagari_neg'] = 'не Devanagari символ';
$string['description_charflag_Egyptian_Hieroglyphs'] = 'Egyptian Hieroglyphs символ';
$string['description_charflag_Egyptian_Hieroglyphs_neg'] = 'не Egyptian Hieroglyphs символ';
$string['description_charflag_Ethiopic'] = 'Ethiopic символ';
$string['description_charflag_Ethiopic_neg'] = 'не Ethiopic символ';
$string['description_charflag_Georgian'] = 'Georgian символ';
$string['description_charflag_Georgian_neg'] = 'не Georgian символ';
$string['description_charflag_Glagolitic'] = 'Glagolitic символ';
$string['description_charflag_Glagolitic_neg'] = 'не Glagolitic символ';
$string['description_charflag_Gothic'] = 'Gothic символ';
$string['description_charflag_Gothic_neg'] = 'не Gothic символ';
$string['description_charflag_Greek'] = 'Greek символ';
$string['description_charflag_Greek_neg'] = 'не Greek символ';
$string['description_charflag_Gujarati'] = 'Gujarati символ';
$string['description_charflag_Gujarati_neg'] = 'не Gujarati символ';
$string['description_charflag_Gurmukhi'] = 'Gurmukhi символ';
$string['description_charflag_Gurmukhi_neg'] = 'не Gurmukhi символ';
$string['description_charflag_Han'] = 'Han символ';
$string['description_charflag_Han_neg'] = 'не Han символ';
$string['description_charflag_Hangul'] = 'Hangul символ';
$string['description_charflag_Hangul_neg'] = 'не Hangul символ';
$string['description_charflag_Hanunoo'] = 'Hanunoo символ';
$string['description_charflag_Hanunoo_neg'] = 'не Hanunoo символ';
$string['description_charflag_Hebrew'] = 'Hebrew символ';
$string['description_charflag_Hebrew_neg'] = 'не Hebrew символ';
$string['description_charflag_Hiragana'] = 'Hiragana символ';
$string['description_charflag_Hiragana_neg'] = 'не Hiragana символ';
$string['description_charflag_Imperial_Aramaic'] = 'Imperial Aramaic символ';
$string['description_charflag_Imperial_Aramaic_neg'] = 'не Imperial Aramaic символ';
$string['description_charflag_Inherited'] = 'Inherited символ';
$string['description_charflag_Inherited_neg'] = 'не Inherited символ';
$string['description_charflag_Inscriptional_Pahlavi'] = 'Inscriptional Pahlavi символ';
$string['description_charflag_Inscriptional_Pahlavi_neg'] = 'не Inscriptional Pahlavi символ';
$string['description_charflag_Inscriptional_Parthian'] = 'Inscriptional Parthian символ';
$string['description_charflag_Inscriptional_Parthian_neg'] = 'не Inscriptional Parthian символ';
$string['description_charflag_Javanese'] = 'Javanese символ';
$string['description_charflag_Javanese_neg'] = 'не Javanese символ';
$string['description_charflag_Kaithi'] = 'Kaithi символ';
$string['description_charflag_Kaithi_neg'] = 'не Kaithi символ';
$string['description_charflag_Kannada'] = 'Kannada символ';
$string['description_charflag_Kannada_neg'] = 'не Kannada символ';
$string['description_charflag_Katakana'] = 'Katakana символ';
$string['description_charflag_Katakana_neg'] = 'не Katakana символ';
$string['description_charflag_Kayah_Li'] = 'Kayah Li символ';
$string['description_charflag_Kayah_Li_neg'] = 'не Kayah Li символ';
$string['description_charflag_Kharoshthi'] = 'Kharoshthi символ';
$string['description_charflag_Kharoshthi_neg'] = 'не Kharoshthi символ';
$string['description_charflag_Khmer'] = 'Khmer символ';
$string['description_charflag_Khmer_neg'] = 'не Khmer символ';
$string['description_charflag_L'] = 'буква';
$string['description_charflag_L_neg'] = 'не буква';
$string['description_charflag_Lao'] = 'Lao символ';
$string['description_charflag_Lao_neg'] = 'не Lao символ';
$string['description_charflag_Latin'] = 'Latin символ';
$string['description_charflag_Latin_neg'] = 'не Latin символ';
$string['description_charflag_Lepcha'] = 'Lepcha символ';
$string['description_charflag_Lepcha_neg'] = 'не Lepcha символ';
$string['description_charflag_Limbu'] = 'Limbu символ';
$string['description_charflag_Limbu_neg'] = 'не Limbu символ';
$string['description_charflag_Linear_B'] = 'Linear B символ';
$string['description_charflag_Linear_B_neg'] = 'не Linear B символ';
$string['description_charflag_Lisu'] = 'Lisu символ';
$string['description_charflag_Lisu_neg'] = 'не Lisu символ';
$string['description_charflag_Ll'] = 'буква в нижнем регистре';
$string['description_charflag_Ll_neg'] = 'не буква в нижнем регистре';
$string['description_charflag_Lm'] = 'спец. символ, используемый как буква,';
$string['description_charflag_Lm_neg'] = 'не спец. символ, используемый как буква,';
$string['description_charflag_Lo'] = 'буква без заглавного варианта';
$string['description_charflag_Lo_neg'] = 'не буква без заглавного варианта';
$string['description_charflag_Lt'] = 'буква в заглавном регистре';
$string['description_charflag_Lt_neg'] = 'не буква в заглавном регистре';
$string['description_charflag_Lu'] = 'буква в верхнем регистре';
$string['description_charflag_Lu_neg'] = 'не буква в верхнем регистре';
$string['description_charflag_Lycian'] = 'Lycian символ';
$string['description_charflag_Lycian_neg'] = 'не Lycian символ';
$string['description_charflag_Lydian'] = 'Lydian символ';
$string['description_charflag_Lydian_neg'] = 'не Lydian символ';
$string['description_charflag_M'] = 'метка';
$string['description_charflag_M_neg'] = 'не метка';
$string['description_charflag_Malayalam'] = 'Malayalam символ';
$string['description_charflag_Malayalam_neg'] = 'не Malayalam символ';
$string['description_charflag_Mc'] = 'пробельный символ';
$string['description_charflag_Mc_neg'] = 'не пробельный символ';
$string['description_charflag_Me'] = 'enclosing mark';
$string['description_charflag_Me_neg'] = 'не enclosing mark';
$string['description_charflag_Meetei_Mayek'] = 'Meetei Mayek символ';
$string['description_charflag_Meetei_Mayek_neg'] = 'не Meetei Mayek символ';
$string['description_charflag_Mn'] = 'не пробельный символ';
$string['description_charflag_Mn_neg'] = 'не не пробельный символ';
$string['description_charflag_Mongolian'] = 'Mongolian символ';
$string['description_charflag_Mongolian_neg'] = 'не Mongolian символ';
$string['description_charflag_Myanmar'] = 'Myanmar символ';
$string['description_charflag_Myanmar_neg'] = 'не Myanmar символ';
$string['description_charflag_N'] = 'число';
$string['description_charflag_N_neg'] = 'не число';
$string['description_charflag_Nd'] = 'десятичное число';
$string['description_charflag_Nd_neg'] = 'не десятичное число';
$string['description_charflag_New_Tai_Lue'] = 'New Tai Lue символ';
$string['description_charflag_New_Tai_Lue_neg'] = 'не New Tai Lue символ';
$string['description_charflag_Nko'] = 'Nko символ';
$string['description_charflag_Nko_neg'] = 'не Nko символ';
$string['description_charflag_Nl'] = 'letter number';
$string['description_charflag_Nl_neg'] = 'не letter number';
$string['description_charflag_No'] = 'другое число';
$string['description_charflag_No_neg'] = 'не другое число';
$string['description_charflag_Ogham'] = 'Ogham символ';
$string['description_charflag_Ogham_neg'] = 'не Ogham символ';
$string['description_charflag_Ol_Chiki'] = 'Ol_Chiki символ';
$string['description_charflag_Ol_Chiki_neg'] = 'не Ol_Chiki символ';
$string['description_charflag_Old_Italic'] = 'Old Italic символ';
$string['description_charflag_Old_Italic_neg'] = 'не Old Italic символ';
$string['description_charflag_Old_Persian'] = 'Old Persian символ';
$string['description_charflag_Old_Persian_neg'] = 'не Old Persian символ';
$string['description_charflag_Old_South_Arabian'] = 'Old South_Arabian символ';
$string['description_charflag_Old_South_Arabian_neg'] = 'не Old South_Arabian символ';
$string['description_charflag_Old_Turkic'] = 'Old_Turkic символ';
$string['description_charflag_Old_Turkic_neg'] = 'не Old_Turkic символ';
$string['description_charflag_Oriya'] = 'Oriya символ';
$string['description_charflag_Oriya_neg'] = 'не Oriya символ';
$string['description_charflag_Osmanya'] = 'Osmanya символ';
$string['description_charflag_Osmanya_neg'] = 'не Osmanya символ';
$string['description_charflag_P'] = 'пунктуация';
$string['description_charflag_P_neg'] = 'не пунктуация';
$string['description_charflag_Pc'] = 'connector punctuation';
$string['description_charflag_Pc_neg'] = 'не connector punctuation';
$string['description_charflag_Pd'] = 'тире';
$string['description_charflag_Pd_neg'] = 'не тире';
$string['description_charflag_Pe'] = 'close punctuation';
$string['description_charflag_Pe_neg'] = 'не close punctuation';
$string['description_charflag_Pf'] = 'final punctuation';
$string['description_charflag_Pf_neg'] = 'не final punctuation';
$string['description_charflag_Phags_Pa'] = 'Phags_Pa символ';
$string['description_charflag_Phags_Pa_neg'] = 'не Phags_Pa символ';
$string['description_charflag_Phoenician'] = 'Phoenician символ';
$string['description_charflag_Phoenician_neg'] = 'не Phoenician символ';
$string['description_charflag_Pi'] = 'initial punctuation';
$string['description_charflag_Pi_neg'] = 'не initial punctuation';
$string['description_charflag_Po'] = 'other punctuation';
$string['description_charflag_Po_neg'] = 'не other punctuation';
$string['description_charflag_Ps'] = 'open punctuation';
$string['description_charflag_Ps_neg'] = 'не open punctuation';
$string['description_charflag_Rejang'] = 'Rejang символ';
$string['description_charflag_Rejang_neg'] = 'не Rejang символ';
$string['description_charflag_Runic'] = 'Runic символ';
$string['description_charflag_Runic_neg'] = 'не Runic символ';
$string['description_charflag_S'] = 'символ';
$string['description_charflag_S_neg'] = 'не символ';
$string['description_charflag_Samaritan'] = 'Samaritan символ';
$string['description_charflag_Samaritan_neg'] = 'не Samaritan символ';
$string['description_charflag_Saurashtra'] = 'Saurashtra символ';
$string['description_charflag_Saurashtra_neg'] = 'не Saurashtra символ';
$string['description_charflag_Sc'] = 'денежный символ';
$string['description_charflag_Sc_neg'] = 'не денежный символ';
$string['description_charflag_Shavian'] = 'Shavian символ';
$string['description_charflag_Shavian_neg'] = 'не Shavian символ';
$string['description_charflag_Sinhala'] = 'Sinhala символ';
$string['description_charflag_Sinhala_neg'] = 'не Sinhala символ';
$string['description_charflag_Sk'] = 'символ-модификатор';
$string['description_charflag_Sk_neg'] = 'не символ-модификатор';
$string['description_charflag_Sm'] = 'математический символ';
$string['description_charflag_Sm_neg'] = 'не математический символ';
$string['description_charflag_So'] = 'символ (не математический, денежный)';
$string['description_charflag_So_neg'] = 'не символ (не математический, денежный)';
$string['description_charflag_Sundanese'] = 'Sundanese символ';
$string['description_charflag_Sundanese_neg'] = 'не Sundanese символ';
$string['description_charflag_Syloti_Nagri'] = 'Syloti_Nagri символ';
$string['description_charflag_Syloti_Nagri_neg'] = 'не Syloti_Nagri символ';
$string['description_charflag_Syriac'] = 'Syriac символ';
$string['description_charflag_Syriac_neg'] = 'не Syriac символ';
$string['description_charflag_Tagalog'] = 'Tagalog символ';
$string['description_charflag_Tagalog_neg'] = 'не Tagalog символ';
$string['description_charflag_Tagbanwa'] = 'Tagbanwa символ';
$string['description_charflag_Tagbanwa_neg'] = 'не Tagbanwa символ';
$string['description_charflag_Tai_Le'] = 'Tai_Le символ';
$string['description_charflag_Tai_Le_neg'] = 'не Tai_Le символ';
$string['description_charflag_Tai_Tham'] = 'Tai_Tham символ';
$string['description_charflag_Tai_Tham_neg'] = 'не Tai_Tham символ';
$string['description_charflag_Tai_Viet'] = 'Tai_Viet символ';
$string['description_charflag_Tai_Viet_neg'] = 'не Tai_Viet символ';
$string['description_charflag_Tamil'] = 'Tamil символ';
$string['description_charflag_Tamil_neg'] = 'не Tamil символ';
$string['description_charflag_Telugu'] = 'Telugu символ';
$string['description_charflag_Telugu_neg'] = 'не Telugu символ';
$string['description_charflag_Thaana'] = 'Thaana символ';
$string['description_charflag_Thaana_neg'] = 'не Thaana символ';
$string['description_charflag_Thai'] = 'Thai символ';
$string['description_charflag_Thai_neg'] = 'не Thai символ';
$string['description_charflag_Tibetan'] = 'Tibetan символ';
$string['description_charflag_Tibetan_neg'] = 'не Tibetan символ';
$string['description_charflag_Tifinagh'] = 'Tifinagh символ';
$string['description_charflag_Tifinagh_neg'] = 'не Tifinagh символ';
$string['description_charflag_Ugaritic'] = 'Ugaritic символ';
$string['description_charflag_Ugaritic_neg'] = 'не Ugaritic символ';
$string['description_charflag_Vai'] = 'Vai символ';
$string['description_charflag_Vai_neg'] = 'не Vai символ';
$string['description_charflag_Xan'] = 'алфавитно-числовой символ';
$string['description_charflag_Xan_neg'] = 'не алфавитно-числовой символ';
$string['description_charflag_Xps'] = 'любой POSIX пробельный символ';
$string['description_charflag_Xps_neg'] = 'не любой POSIX пробельный символ';
$string['description_charflag_Xsp'] = 'любой Perl пробельный символ';
$string['description_charflag_Xsp_neg'] = 'не любой Perl пробельный символ';
$string['description_charflag_Xwd'] = 'любой Perl символ-слово';
$string['description_charflag_Xwd_neg'] = 'не любой Perl символ-слово';
$string['description_charflag_Yi'] = 'Yi символ';
$string['description_charflag_Yi_neg'] = 'не Yi символ';
$string['description_charflag_Z'] = 'разделитель';
$string['description_charflag_Z_neg'] = 'не разделитель';
$string['description_charflag_Zl'] = 'разделитель строк';
$string['description_charflag_Zl_neg'] = 'не разделитель строк';
$string['description_charflag_Zp'] = 'разделитель параграфов';
$string['description_charflag_Zp_neg'] = 'не разделитель параграфов';
$string['description_charflag_Zs'] = 'пробельный разделитель';
$string['description_charflag_Zs_neg'] = 'не пробельный разделитель';
$string['description_charflag_alnum'] = 'буква или цифра';
$string['description_charflag_alnum_neg'] = 'не буква и не цифра';
$string['description_charflag_alpha'] = 'буква';
$string['description_charflag_alpha_neg'] = 'не буква';
$string['description_charflag_ascii'] = 'символы с кодом 0-127';
$string['description_charflag_ascii_neg'] = 'не символ с кодом 0-127';
$string['description_charflag_blank'] = 'пробел или табуляция';
$string['description_charflag_blank_neg'] = 'не пробел и не табуляция';
$string['description_charflag_cntrl'] = 'служебный символ';
$string['description_charflag_cntrl_neg'] = 'не служебный символ';
$string['description_charflag_digit'] = 'десятичное число';
$string['description_charflag_digit_neg'] = 'не десятичное число';
$string['description_charflag_dot'] = 'любой символ';
$string['description_charflag_graph'] = 'печатный символ';
$string['description_charflag_graph_neg'] = 'не печатный символ';
$string['description_charflag_lower'] = 'строчная буква';
$string['description_charflag_lower_neg'] = 'не строчная буква';
$string['description_charflag_print'] = 'печатный символ (включая пробел)';
$string['description_charflag_print_neg'] = 'не печатный символ (включая пробел)';
$string['description_charflag_punct'] = 'печатный символ (исключая буквы, цифры и пробел)';
$string['description_charflag_punct_neg'] = 'не печатный символ (исключая буквы, цифры и пробел)';
$string['description_charflag_slashd'] = 'десятичная цифра';
$string['description_charflag_slashd_neg'] = 'не десятичная цифра';
$string['description_charflag_slashh'] = 'горизонтальный белый разделитель';
$string['description_charflag_slashh_neg'] = 'не горизонтальный белый разделитель';
$string['description_charflag_slashs'] = 'белый разделитель';
$string['description_charflag_slashs_neg'] = 'не белый разделитель';
$string['description_charflag_slashv'] = 'вертикальный белый разделитель';
$string['description_charflag_slashv_neg'] = 'не вертикальный белый разделитель';
$string['description_charflag_slashw'] = 'символ слова';
$string['description_charflag_slashw_neg'] = 'не символ слова';
$string['description_charflag_space'] = 'пробел';
$string['description_charflag_space_neg'] = 'не пробел';
$string['description_charflag_upper'] = 'заглавная буква';
$string['description_charflag_upper_neg'] = 'не заглавная буква';
$string['description_charflag_word'] = 'символ-слово';
$string['description_charflag_word_neg'] = 'не символ-слово';
$string['description_charflag_xdigit'] = 'шестнадцатеричное число';
$string['description_charflag_xdigit_neg'] = 'не шестнадцатиричное число';
$string['description_charset'] = 'один из следующих символов: {$a->characters};';
$string['description_charset_neg'] = 'любой из символов кроме следующих: {$a->characters};';
$string['description_charset_neg_one'] = 'не {$a->characters}';
$string['description_charset_range'] = 'любой символ {$a}';
$string['description_circumflex_leaf_assert'] = 'начало строки';
$string['description_commit_leaf_control'] = 'если остальные шаблоны не соответствует - общие неудачи, нет предыдущей отправной точки';
$string['description_cr_leaf_control'] = 'с новой строкой совпадает только возврат каретки';
$string['description_crlf_leaf_control'] = 'с новой строкой совпадает возврат каретки, сопровождаемый переводом строки';
$string['description_define_node_cond_subexpr'] = 'описание {$a->firstoperand}';
$string['description_dollar_leaf_assert'] = 'конец строки';
$string['description_duplicate_node_subexpr'] = 'группировка (номера подмасок сбрасываются в каждой из альтернатив): [ {$a->firstoperand} ]';
$string['description_empty_leaf_meta'] = 'ничего';
$string['description_errorafter'] = '</span>';
$string['description_errorbefore'] = '<span style="color:red">';
$string['description_esc_a_leaf_assert'] = 'начало строки';
$string['description_esc_b_leaf_assert'] = 'граница слова';
$string['description_esc_b_leaf_assert_neg'] = 'не граница слова';
$string['description_esc_g_leaf_assert'] = 'первая позиция матчинга в строке';
$string['description_fail_leaf_control'] = 'спровоцировать неудачу';
$string['description_grouping_node_subexpr'] = 'группировка: [ {$a->firstoperand} ]';
$string['description_leaf_backref'] = 'текст, совпавший с подвыражением #{$a}';
$string['description_leaf_backref_name'] = 'текст, совпавший с подвыражением "{$a}"';
$string['description_leaf_options'] = '{$a}:';
$string['description_leaf_subexpr_call'] = 'вызов подмаски #{$a}';
$string['description_leaf_subexpr_call_all'] = 'вызов проверки совпадения со всем регулярным выражением';
$string['description_leaf_subexpr_call_all_recursive'] = 'рекурсивный вызов проверки совпадения со всем регулярным выражением';
$string['description_leaf_subexpr_call_name'] = 'вызов подмаски "{$a}"';
$string['description_leaf_subexpr_call_name_recursive'] = 'рекурсивный вызов подмаски "{$a}"';
$string['description_leaf_subexpr_call_recursive'] = 'рекурсивный вызов подмаски #{$a}';
$string['description_leaf_template'] = 'шаблон без параметров';
$string['description_lf_leaf_control'] = 'с новой строкой совпадает только символ новой строки';
$string['description_mark_name_leaf_control'] = 'задайте имя для {$a->name}, которое будет возвращено';
$string['description_nla_node_assert'] = 'текст далее не должен соответствовать: [{$a->firstoperand}]';
$string['description_nla_node_assert_cond'] = 'текст далее не соответсвует: [{$a->firstoperand}]';
$string['description_nlb_node_assert'] = 'предыдущий текст не должен соответствовать: [{$a->firstoperand}]';
$string['description_nlb_node_assert_cond'] = 'предшествующий текст не соответствует: [{$a->firstoperand}]';
$string['description_no_start_opt_leaf_control'] = 'no start-match optimization';
$string['description_node_alt'] = '{$a->firstoperand} или {$a->secondoperand}';
$string['description_node_alt_wcomma'] = '{$a->firstoperand}, или {$a->secondoperand}';
$string['description_node_concat'] = '{$a->firstoperand} затем {$a->secondoperand}';
$string['description_node_concat_and'] = '{$a->firstoperand} и {$a->secondoperand}';
$string['description_node_concat_short'] = '{$a->firstoperand}{$a->secondoperand}';
$string['description_node_concat_space'] = '{$a->firstoperand} {$a->secondoperand}';
$string['description_node_concat_wcomma'] = '{$a->firstoperand}, затем {$a->secondoperand}';
$string['description_node_cond_subexpr'] = 'если {$a->cond}, тогда проверить: [{$a->firstoperand}]{$a->else}';
$string['description_node_cond_subexpr_else'] = 'иначе проверить: [{$a->secondoperand}]';
$string['description_node_finite_quant'] = '{$a->firstoperand} повторяется от {$a->leftborder} до {$a->rightborder} раз(а){$a->greedy}';
$string['description_node_finite_quant_0'] = '{$a->firstoperand} повторяется не более {$a->rightborder} раз или отсутствует{$a->greedy}';
$string['description_node_finite_quant_01'] = '{$a->firstoperand} может отсутствовать{$a->greedy}';
$string['description_node_finite_quant_1'] = '{$a->firstoperand} повторяется не более {$a->rightborder} раз{$a->greedy}';
$string['description_node_finite_quant_borders_err'] = '(некорректные границы у квантификатора)';
$string['description_node_finite_quant_strict'] = '{$a->firstoperand} повторяется {$a->leftborder} раз(а){$a->greedy}';
$string['description_node_infinite_quant'] = '{$a->firstoperand} повторяется хотябы {$a->leftborder} раз(а){$a->greedy}';
$string['description_node_infinite_quant_0'] = '{$a->firstoperand} повторяется любое количество раз или отсутствует{$a->greedy}';
$string['description_node_infinite_quant_1'] = '{$a->firstoperand} повторяется любое количество раз{$a->greedy}';
$string['description_node_template'] = 'шаблон с параметрами';
$string['description_operand'] = 'операнд';
$string['description_option_J'] = 'повторение имен разрешено';
$string['description_option_U'] = 'квантификаторы не жадные';
$string['description_option_i'] = 'регистронезависимо';
$string['description_option_m'] = 'многострочный режим:';
$string['description_option_s'] = 'точка захватывает \\n';
$string['description_option_x'] = 'пробелы в выражении были проигнорированы';
$string['description_pla_node_assert'] = 'текст далее должен соответствовать: [{$a->firstoperand}]';
$string['description_pla_node_assert_cond'] = 'текст далее соответствует: [{$a->firstoperand}]';
$string['description_plb_node_assert'] = 'предыдущий текст должен соответствовать: [{$a->firstoperand}]';
$string['description_plb_node_assert_cond'] = 'предшествующий текст соответсвует: [{$a->firstoperand}]';
$string['description_prune_leaf_control'] = 'если остальные шаблоны не соответствует - перейти к следующему начальному символу';
$string['description_quant_greedy'] = '';
$string['description_quant_lazy'] = '(ленивый квантификатор)';
$string['description_quant_possessive'] = '(сверхжадный квантификатор)';
$string['description_range'] = 'от {$a->start} до {$a->end}';
$string['description_recursion_node_cond_subexpr'] = 'подмаска #{$a->number} рекурсивно сопоставляется';
$string['description_recursion_node_cond_subexpr_all'] = 'весь шаблон рекурсивно сопоставляется';
$string['description_recursion_node_cond_subexpr_name'] = 'подмаска "{$a->name}" рекурсивно сопоставляется';
$string['description_skip_leaf_control'] = 'если остальные шаблоны не соответствует - перейти к текущей позиции поиска';
$string['description_skip_name_leaf_control'] = 'если остальные шаблоны не соответствует - перейти к (*MARK:{$a})';
$string['description_small_esc_z_leaf_assert'] = 'конец строки';
$string['description_subexpr_node_cond_subexpr'] = 'подмаска #{$a->number} была успешно сопоставлена';
$string['description_subexpr_node_cond_subexpr_name'] = 'подмаска "{$a->name}" была успешно сопоставлена';
$string['description_subexpr_node_cond_subexpr_wrapper'] = 'если {$a->cond}, тогда проверить: [{$a->firstoperand}]{$a->else}';
$string['description_subexpr_node_subexpr'] = 'подмаска #{$a->number}: [ {$a->firstoperand} ]';
$string['description_subexpr_node_subexpr_name'] = 'подмаска "{$a->name} #{$a->number}": [ {$a->firstoperand} ]';
$string['description_template_brackets_opt'] = 'тект в квадратных скобках или без';
$string['description_template_brackets_req'] = 'текст в квадратных скобках';
$string['description_template_custom_parens_opt'] = 'тект в особых скобках или без';
$string['description_template_custom_parens_req'] = 'текст в в особых скобках';
$string['description_template_integer'] = 'любое число, включая + или -';
$string['description_template_parens_opt'] = 'текст в круглых скобках или без';
$string['description_template_parens_req'] = 'текст в круглых скобках';
$string['description_template_word'] = 'любое слово';
$string['description_then_leaf_control'] = 'если остальные шаблоны не соответствует - возврат к следующему чередованию';
$string['description_tool'] = 'Описание';
$string['description_tool_help'] = 'Здесь вы можете увидеть описание регулярных выражений. Нажатие на узле дерева выделится соответствующий подграф и соответствующая часть описания желтым цветом.';
$string['description_ucp_leaf_control'] = 'PCRE_UCP';
$string['description_unsetoption_J'] = 'повторение имен запрещено';
$string['description_unsetoption_U'] = 'квантификаторы жадные';
$string['description_unsetoption_i'] = 'регистрозависимо';
$string['description_unsetoption_m'] = 'не многострочный режим';
$string['description_unsetoption_s'] = 'точка не захватывает \\n';
$string['description_unsetoption_x'] = 'пробелы в выражении не были проигнорированы';
$string['description_utf16_leaf_control'] = 'режим UTF-16';
$string['description_utf8_leaf_control'] = 'режим UTF-8';
$string['different_subexpr_names_node_error'] = 'Различные имена подвыражения у подвыражения с тем же номером';
$string['dollar_leaf_assert'] = 'конец строки';
$string['doterror'] = 'Невозможно отрисовать {$a->name} для данного регулярного выражения';
$string['duplicate_subexpr_names_node_error'] = 'Два именованных подвыражения имеют одинаковые имена';
$string['empty_fa'] = 'С регулярным выражением не может совпасть ни одна строка (конечный автомат пустой).';
$string['empty_leaf_meta'] = 'ничего';
$string['engine'] = 'Движок поиска совпадений';
$string['engine_heading_descriptions'] = 'Поиск совпадений может занимать много времени и памяти. Эти настройки позволяют задать пределы использования времени и памяти движками поиска совпадений. Увеличьте их, если получаете ошибку о слишком большом регулярном выражении, но имейте ввиду производительность вашего сервера (вы также можете увеличить лимиты времени и памяти самого PHP). Уменьшите их, если получаете пустую страницу во время сохранения или работы с preg вопросом.';
$string['engine_help'] = '<p>Не существует лучшего движка поиска совпадений, поэтому вы можете выбирать тот, который подходит для конкретного вопроса.</p><p>Стандартный движок <b>PHP</b> работает через функцию preg_match() языка PHP. В нем, скорее всего, нет ошибок, он полностью поддерживает синтаксис PCRE, но не поддерживает частичные совпадения и генерацию подсказок.</p><p>Движкок <b>КА</b> написан самостоятельно; он поддерживает частичные совпадения и генерацию подсказок, но не поддерживает сложные утверждения (вы будете уведомлены, если попытаетесь сохранить вопрос с неподдерживаемыми возможностями) и может содержать ошибки.</p><p>Если вам трудно понять разницу между движками поиска совпадений, попробуйте их все и проверьте, насколько они вам подходят. Если один движок не подходит, возможно, подойдет другой.</p><p>Движок конечных автоматов, скорее всего, является наилучшим выбором, если вы не используете сложные утверждения.</p>';
$string['error_PCREincorrectregex'] = 'Некорректное регулярное выражение - ошибка синтаксиса! Ознакомьтесь с <a href="http://pcre.org/pcre.txt">документацией PCRE</a> для получения информации.';
$string['error_duringauthoringtool'] = 'Ошибки при попытке построения {$a}:';
$string['error_infiniterecursion'] = 'Регулярное выражение содержит бесконечную рекурсию';
$string['esc_a_leaf_assert'] = 'начало строки';
$string['esc_b_leaf_assert'] = 'граница слова';
$string['esc_g_leaf_assert'] = 'первая позиция матчинга в строке';
$string['exactmatch'] = 'Точное совпадение';
$string['exactmatch_help'] = '<p>По умолчанию поиск совпадений с регулярным выражением возвращает истину, если в ответе есть хотя бы одно совпадение. Точное совпадение означает, что совпадать должна строка целиком.</p><p>Установите значение Да, если вы пишете регулярное выражение для ответа целиком. Установка значения Нет дает дополнительную гибкость: вы можете указать ответ с низкой (или нулевой) оценкой, чтобы "отловить" частые ошибки студентов и дать на них отзыв. Вы также можете указывать режим точного совпадения, начиная регулярное выражение символом ^ и заканчивая его символом $.</p>';
$string['explain_any_char'] = 'Любой символ из';
$string['explain_any_char_except'] = 'Любой символ кроме';
$string['explain_begin'] = 'начало';
$string['explain_define'] = 'TODO';
$string['explain_end'] = 'конец';
$string['explain_false'] = 'ложь';
$string['explain_parameter'] = 'параметр';
$string['explain_true'] = 'истина';
$string['explain_unknow_meta'] = 'неизвестный мета-узел';
$string['explain_unknow_template'] = 'неизвестный шаблон';
$string['explaining_graph_tool'] = 'Объясняющий граф';
$string['explaining_graph_tool_help'] = 'Здесь вы можете увидеть объясняющий граф. При нажатии на узел дерева выделится соответствующий подграф темно-зеленым прямоугольником. Вы также можете выделить прямоугольником несколько узлов одновременно, включив режим выделения прямоугольником.';
$string['fa_matcher'] = 'Конечные автоматы';
$string['fa_settings_heading'] = 'Настройки движка конечных автоматов';
$string['fa_simulation_state_limit'] = 'Лимит конечного автомата при поиске совпадений: состояния';
$string['fa_simulation_state_limit_description'] = 'Когда ищется совпадение в строке с помощью регулярного выражения с обратными ссылками или рекурсией, одно состояние конечного автомата может быть достигнуто разными путями. Это значит, что создаются несколько "симуляционных состояний" для одного "структурного состояния". Эта настройка позволяет вам задать максимальное количество симуляционных состояний для всего автомата.';
$string['fa_state_limit'] = 'Лимит конечного автомата: состояния';
$string['fa_state_limit_description'] = 'Максимальное количество состояний в автомате.';
$string['fa_transition_limit'] = 'Лимит конечного автомата: переходы';
$string['fa_transition_limit_description'] = 'Максимальное количество переходов в автомате.';
$string['fail_leaf_control'] = '';
$string['greedyquant'] = 'Жадные квантификаторы';
$string['grouping_node_subexpr'] = 'группировка';
$string['groupspaircountoverlimit'] = 'Допустимое количество пар групп на одном шаге для алгоритма проверки эквивалентности конечных автоматов превышено. Это ограничение необходимо для предотвращения долгой проверки эквивалентности. Обратитесь к администратору сайта для изменения настроек алгоритма, если это необходимо.';
$string['hintcolouredstring'] = 'совпавшую часть ответа';
$string['hintgradeborder'] = 'Граница показа подсказок';
$string['hintgradeborder_help'] = 'Ответы с оценкой ниже границы показа подсказок не будут использоваться для дачи подсказок.';
$string['hintnextchar'] = 'следующий правильный символ';
$string['hintnextlexem'] = 'пока не закончится {$a}';
$string['incorrect_charset_range_node_error'] = 'Некорректные границы в символьном классе в позиции с {$a->colfirst} до {$a->collast}: левый символ "больше" правого';
$string['incorrect_quant_range_node_error'] = 'Некорректные границы квантификатора в позиции с {$a->colfirst} до {$a->collast}: левая граница больше правой';
$string['langselect'] = 'Язык';
$string['langselect_help'] = 'Для подсказки лексем вам нужно выбрать язык, который разбивает ответ на лексемы. Каждый язык имеет свои правила. Языки определяются с помощью «Блока формальных языков»';
$string['lazyquant'] = 'Ленивые квантификаторы';
$string['leaf_assert'] = 'простое утверждение';
$string['leaf_backref'] = 'обратная ссылка';
$string['leaf_charset'] = 'символьный класс';
$string['leaf_charset_error'] = 'ошибка в символьном классе';
$string['leaf_charset_except'] = 'любой символ кроме';
$string['leaf_charset_neg'] = 'отрицательный символьный класс';
$string['leaf_charset_one'] = 'символ';
$string['leaf_control'] = 'управляющая последовательность';
$string['leaf_meta'] = 'мета-символ или escape-последовательность';
$string['leaf_options'] = 'модификатор';
$string['leaf_subexpr_call'] = 'вызов подмаски';
$string['leaf_template'] = 'шаблон без параметров';
$string['lexemhintpenalty'] = 'Штраф за подсказку следующей лексемы';
$string['lexemhintpenalty_help'] = 'Штраф за подсказку следующей лексемы. Обычно должен быть больше, чем штраф, даваемый за каждую новую попытку ответа на вопрос без подсказки. Эти штрафы взаимоисключающие.';
$string['lexemusername'] = 'Синоним слова "лексема", отображаемый студентам';
$string['lexemusername_help'] = 'Возможно, студенты не знают, что атомарная часть языка называется <b>лексемой</b>. Они могут называть ее "словом", "цифрой" или чем-то другим. Вы можете задать слово, которое студенты будут видеть на кнопке подсказки лексемы.';
$string['lf_leaf_control'] = '';
$string['lnu_unsupported_node_error'] = 'Последовательности \\L, \\l, \\N{name}, \\U, и \\u не поддерживаются';
$string['mark_name_leaf_control'] = '';
$string['maxerrorsshowndescription'] = 'Максимальное число показываемых ошибок для каждого регулярного выражения в форме редактирования';
$string['maxerrorsshownlabel'] = 'Максимальное число показываемых ошибок';
$string['mergedassertion_option'] = 'Чтобы использовать сложные позитивные утверждения, необходимо включить полный режим поддержки утверждений.';
$string['mergemodeforassertion'] = 'Пожалуйста, выберите режим полной поддержки утверждений в настройках типа вопроса. В быстром режиме {$a}';
$string['missing_brackets_for_g_node_error'] = 'за \\g не стоит имя или номер в фигурных или угловых скобках, или в кавычках';
$string['missing_brackets_for_k_node_error'] = 'за \\k не стоит имя или номер в фигурных или угловых скобках, или в кавычках';
$string['missing_callout_ending_node_error'] = 'Не закрытая скобка в callout';
$string['missing_close_paren_node_error'] = 'Синтаксическая ошибка: ожидалась закрывающая круглая скобка \')\' для открывающей круглой скобки в позиции {$a->colfirst}';
$string['missing_comment_ending_node_error'] = 'Синтаксическая ошибка: ожидалась закрывающая круглая скобка для комментария в позиции с {$a->colfirst} по {$a->collast}';
$string['missing_condsubexpr_ending_node_error'] = 'Не завершённое имя условного подвыражения';
$string['missing_control_ending_node_error'] = 'Ожидалась закрывающая круглая скобка после управляющей последовательности';
$string['missing_open_paren_node_error'] = 'Синтаксическая ошибка: ожидалась открывающая круглая скобка \'(\' для закрывающей круглой скобки в позиции {$a->colfirst}';
$string['missing_subexpr_name_ending_node_error'] = 'Синтаксическая ошибка в имени подвыражения';
$string['missing_template_close_paren_node_error'] = 'Синтаксическая ошибка: ожидался конец шаблона \'(?###>)\' для начала шаблона в позиции {$a->colfirst}';
$string['missing_template_open_paren_node_error'] = 'Синтаксическая ошибка: ожидалось начало шаблона \'(?###имя<)\' для конца шаблона в позиции {$a->colfirst}';
$string['nla_node_assert'] = 'отрицательное вперёд смотрящее утверждение';
$string['nla_node_cond_subexpr'] = 'отрицательное вперёд смотрящее условное подвыражение';
$string['nlb_node_assert'] = 'отрицательное назад смотрящее утверждение';
$string['nlb_node_cond_subexpr'] = 'положительное назад смотрящее условное подвыражение';
$string['no_start_opt_leaf_control'] = '';
$string['nocorrectanswermatch'] = 'Не указано ни одного 100%-правильного ответа';
$string['node_alt'] = 'альтернатива';
$string['node_assert'] = 'назад смотрящее утверждение';
$string['node_concat'] = 'конкатенация';
$string['node_cond_subexpr'] = 'условное подвыражение';
$string['node_error'] = 'синтаксическая ошибка';
$string['node_finite_quant'] = 'конечный квантификатор';
$string['node_infinite_quant'] = 'бесконечный квантификатор';
$string['node_subexpr'] = 'подвыражение';
$string['node_template'] = 'шаблон с параметрами';
$string['nohintgradeborderpass'] = 'Не указано ни одного с оценкой выше границы подсказок. Это отключает подсказки.';
$string['nosubexprcapturing'] = 'Движок {$a} не поддерживает захват подвыражений. Пожалуйста, удалите конструкции вида {$1...9} (кроме {$0}) из отзывов, или выберите другой движок поиска совпадений';
$string['notation'] = 'Нотация регулярных выражений';
$string['notation_help'] = '<p>Вы можете указать нотацию регулярных выражений. Если вы хотите просто использовать регулярные выражения, используйте нотацию <b>Регулярное выражение</b>.</p><p>Нотация <b>Регулярное выражение (расширенная)</b> удобнее для больших регулярных выражений. Она эквивалентна опции PCRE_EXTENDED (модификатор "x" в PHP). Игнорирует неэкранированные пробелы, не находящиеся внутри символных классов и считает комментарием все от неэкранированного знака # до конца строки.</p><p>Нотация <b>Moodle shortanswer</b> позволяет использовать preg как обычный вопрос Moodle shortanswer, но с поддержкой подсказок - вам не нужно понимать регулярные выражения. Просто скопируйте ваши ответы из shortanswer вопросов. Поддерживается \'*\'.</p>';
$string['notation_mdlshortanswer'] = 'Короткий вопрос Moodle';
$string['notation_native'] = 'Регулярное выражение';
$string['notation_pcreextended'] = 'Регулярное выражение (расширенная)';
$string['objectname'] = 'вопроса';
$string['onceonly_node_subexpr'] = 'подвыражение захватываемое единожды';
$string['pathtodotempty'] = 'Невозможно отрисовать {$a->name}: путь к dot пакета graphviz пуст. Пожалуйста, обратитесь к администратору для установки <a href="http://www.graphviz.com">graphviz</a> и укажите путь к нему с помощью \'pathtodot\' опции Администрирование > Сервер > Системные пути';
$string['pathtodotincorrect'] = 'Невозможно отрисовать {$a->name}: путь к dot пакета graphviz не правильный или dot не может быть запущен. Пожалуйста, обратитесь к администратору для проверки, если <a href="http://www.graphviz.com">graphviz</a> установлен и \'pathtodot\' в опции корректен в Администрирование > Сервер > Системные пути';
$string['php_preg_matcher'] = 'расширение preg для PHP';
$string['pla_node_assert'] = 'положительное вперёд смотрящее утверждение';
$string['pla_node_cond_subexpr'] = 'положительное вперёд смотрящее условное подвыражение';
$string['plb_node_assert'] = 'положительное назад смотрящее утверждение';
$string['plb_node_cond_subexpr'] = 'положительное назад смотрящее условное подвыражение';
$string['pluginname'] = 'Регулярное выражение';
$string['pluginname_help'] = '<p>Регулярные выражения - это форма записи шаблонов, совпадающих с разными строками. Вы можете использовать их для проверки ответов студентов двумя способами: для указания полностью правильных ответов или для отлова наиболее частых ошибок и выдачи соответствующих отзывов.</p><p>Этот тип вопросов по умолчанию использует синтаксис PCRE. Существует множество уроков по созданию регулярных выражений, например, <a href="http://www.phpfreaks.com/content/print/126">example</a>. Детальное описание вы можете найти здесь: <a href="http://www.nusphere.com/kb/phpmanual/reference.pcre.pattern.syntax.htm">php manual</a>. Вам не нужно заключать регулярные выражения в разделители или указывать модификаторы - Moodle сделает это сам.</p><p>Вы также можете использовать этот тип вопросов как улучшенный вариант shortanswer (с подсказками), даже если вы ничего не знаете про регулярные выражения! Просто выберите нотацию <b>Moodle shortanswer</b> для ваших вопросов.</p>';
$string['pluginname_link'] = 'question/type/preg';
$string['pluginnameadding'] = 'Добавление вопроса с регулярными выражениями';
$string['pluginnameediting'] = 'Редактирование вопроса с регулярными выражениями';
$string['pluginnamesummary'] = 'Введите ответ в виде строки, который может быть сопоставлен с несколькими регулярными выражениями. Показываются правильные части ответов студентов. Используются поведения с несколькими попытками, которые могут дать подсказку следующего символа или лексемы.<br/>Вы можете использовать этот тип вопросов не зная регулярные выражения, но имея возможность подсказок с помощью использования нотации \'Moodle shortanswer\'.';
$string['posix_class_outside_charset_node_error'] = 'POSIX классы не допускаются за пределами символьного класса';
$string['possessivequant'] = 'Ревнивые квантификаторы';
$string['prune_leaf_control'] = '';
$string['quantifier_without_parameter_node_error'] = 'Синтаксическая ошибка: квантификатор в позиции с {$a->colfirst} до {$a->collast} не имеет операнда - нечего повторять';
$string['questioneditingheading'] = 'Настройки редактирования вопроса';
$string['recursion_leaf_assert'] = 'fictive';
$string['recursion_node_cond_subexpr'] = 'рекурсивное условное подвыражение';
$string['regex_handler'] = 'Обработчик регулярных выражений';
$string['set_unset_same_modifier_node_error'] = 'Установка и снятие {$a->addinfo} модификатора в одно и тоже время в позиции с {$a->colfirst} до {$a->collast}';
$string['simplification_equivalences_full_1'] = 'Простое утверждение является лишним, т.к. рядом уже есть такое же';
$string['simplification_equivalences_full_10'] = 'Два вложенных повторения можно заменить одним, это уменьшит время поиска совпадения';
$string['simplification_equivalences_full_11'] = 'Квантификатор "{$a->first}" эквивалентен "{$a->second}"';
$string['simplification_equivalences_full_12'] = 'Квантификатор "?" можно убрать, т.к. альтернатива может совпадать с пустотой';
$string['simplification_equivalences_full_13'] = 'Пустота в альтернативе является лишней, т.к. эта альтернатива и так совпадает с пустотой';
$string['simplification_equivalences_full_14'] = 'Квантификатор не влияет на работу регулярного выражения, его можно убрать';
$string['simplification_equivalences_full_2'] = 'Пустые скобки не влияют на работу регулярного выражения, их можно удалить';
$string['simplification_equivalences_full_2_1'] = 'Эти скобки не влияют на работу регулярного выражения, их можно удалить';
$string['simplification_equivalences_full_3'] = 'Пустые скобки не влияют на работу регулярного выражения, т.к. на них нет обратной ссылки или условной подмаски, их можно удалить';
$string['simplification_equivalences_full_3_1'] = 'Эти скобки не влияют на работу регулярного выражения и на них нет обратной ссылки или условной подмаски, их можно удалить';
$string['simplification_equivalences_full_4'] = 'Одинаковые повторяющиеся части выражения можно можно записать короче';
$string['simplification_equivalences_full_5'] = 'Квадратные скобки можно убрать, т.к. в них всего один символ';
$string['simplification_equivalences_full_6'] = 'Лучше представить при помощи квадратных скобок';
$string['simplification_equivalences_full_7'] = 'Можно вынести подвыражение за скобки';
$string['simplification_equivalences_full_8'] = 'Удобнее записать с помощью "?"';
$string['simplification_equivalences_full_8_1'] = 'Пустоту в альтернативе можно убрать, т.к. альтернатива и без него может совпадать с пустотой';
$string['simplification_equivalences_full_9'] = 'Можно убрать квантификатор "?" у альтернативы, добавив к ней пустую альтернативу';
$string['simplification_equivalences_short_1'] = 'Подряд идущие простые утверждения';
$string['simplification_equivalences_short_10'] = 'Подряд идущие повторения можно сократить';
$string['simplification_equivalences_short_11'] = 'Квантификатор можно записать короче';
$string['simplification_equivalences_short_12'] = 'Лишний квантификатор "?"';
$string['simplification_equivalences_short_13'] = 'Лишняя пустота в альтернативе';
$string['simplification_equivalences_short_14'] = 'Бесполезный квантификатор';
$string['simplification_equivalences_short_2'] = 'Пустые скобки "(?:)"';
$string['simplification_equivalences_short_2_1'] = 'Бесполезные скобки "(?:)"';
$string['simplification_equivalences_short_3'] = 'Пустые круглые скобки "()"';
$string['simplification_equivalences_short_3_1'] = 'Бесполезные круглые скобки "()"';
$string['simplification_equivalences_short_4'] = 'Можно сократить повторяющийся участок выражения';
$string['simplification_equivalences_short_5'] = 'Лишние квадратные скобки';
$string['simplification_equivalences_short_6'] = 'Можно привести к эквивалентному символьному классу';
$string['simplification_equivalences_short_7'] = 'Вынесение подвыражения из альтернативы';
$string['simplification_equivalences_short_8'] = 'Пустота в альтернативе';
$string['simplification_equivalences_short_8_1'] = 'Пустота в альтернативе';
$string['simplification_equivalences_short_9'] = 'Квантификатор "?" в альтернативе';
$string['simplification_errors_full_1'] = 'Простое утверждение "^" является лишним, т.к. оно стоит не в начале регулярного выражения';
$string['simplification_errors_full_2'] = 'Простое утверждение "$" является лишним, т.к. оно стоит не в конце регулярного выражения';
$string['simplification_errors_short_1'] = 'Лишнее простое утверждение "^"';
$string['simplification_errors_short_2'] = 'Лишнее простое утверждение "$"';
$string['simplification_tips_full_1'] = 'Возможно вы хотите разрешить любые пробельные символы (например табуляцию), для этого следует использовать "\\s" вместо пробела';
$string['simplification_tips_full_2'] = 'Возможно вы хотите разрешить более одного пробельного символа в этом месте, для этого следует использовать квантификатор "+"';
$string['simplification_tips_full_3'] = 'Круглые скобки позволяют запоминать совпадения с этим участком выражения. Если вам это не нужно, то круглые скобки можно заменить на группировку "(?:)", так совпадение будет искаться быстрее';
$string['simplification_tips_full_4'] = 'Возможно вы хотите разрешить любое количество пробельных символов в этом месте, для этого следует использовать квантификатор "*"';
$string['simplification_tips_full_5'] = 'Выражение совпадает с любой строкой, т.е. любой ответ будет завсчитан по этому варианту';
$string['simplification_tips_full_6'] = 'Возможно вы хотите игнорировать рестр, то это можно сделать используя опцию регистронечувствительности "(?i)"';
$string['simplification_tips_full_7'] = 'Что бы не копировать этот участок, вы можете дать ему имя и вызвать в другом месте';
$string['simplification_tips_full_8'] = 'Возможно вам стоит включить опцию "точное совпадение" вместо использования "^" и "$" в начале и в конце выражения';
$string['simplification_tips_full_8_alt'] = '"^" и "$" в начале и в конце выражения являются лишними, т.к. включена опция "точное совпадение"';
$string['simplification_tips_short_1'] = 'Расширить список пробельных символов';
$string['simplification_tips_short_2'] = 'Можно увеличить количество пробельных символов';
$string['simplification_tips_short_3'] = 'Лишние круглые скобки, для которых нет обратной ссылки';
$string['simplification_tips_short_4'] = 'Можно увеличить количество пробельных символов';
$string['simplification_tips_short_5'] = 'Выражение совпадает с пустотой';
$string['simplification_tips_short_6'] = 'Использовать опцию (?i) для игнорирования регистра букв';
$string['simplification_tips_short_7'] = 'Повторное использование части выражения';
$string['simplification_tips_short_8'] = 'Утверждения слева и справа, возможно использование опции "Точное совпадение"';
$string['simplification_tool'] = 'Упрощение регулярного выражения';
$string['simplification_tool_apply'] = 'Применить и следующая подсказка';
$string['simplification_tool_cancel'] = 'Отмена и следующая подсказка';
$string['simplification_tool_equivalence'] = 'Эквивалентность:';
$string['simplification_tool_error'] = 'Ошибок:';
$string['simplification_tool_help'] = 'Здесь вы можете увидеть подсказки для упрощения регулярного выражения, если они нужны. Подсказки бывают трех типов: эквивалентность (замена части выражения на более оптимальное, эквивалентное выражение), советы (предусматривают случаи, которые могли быть упущены) и ошибки (случаи, в которых регулярное выражение совпадает с любой строкой или не совпадает ни с чем).';
$string['simplification_tool_tip'] = 'Советов:';
$string['skip_leaf_control'] = '';
$string['skip_name_leaf_control'] = '';
$string['slash_at_end_of_pattern_node_error'] = 'Синтаксическая ошибка: \\ в конце шаблона';
$string['small_esc_z_leaf_assert'] = 'конец строки';
$string['subexpr_leaf_assert'] = 'fictive';
$string['subexpr_name_expected_node_error'] = 'ожидается имя подвыражения';
$string['subexpr_node_cond_subexpr'] = '"условное"-подвыражение с проверкой захвата подвыражения';
$string['subexpr_node_subexpr'] = 'подвыражение';
$string['subexpression'] = 'Подвыражение';
$string['syntax_tree_tool'] = 'Синтаксическое дерево';
$string['syntax_tree_tool_collapsing_mode'] = 'Режим свёртки';
$string['syntax_tree_tool_help'] = 'Здесь вы можете видеть синтаксическое дерево. При нажатии на узел дерева выделится соответствующее поддерево, подграф и часть в словесном описании. Вы так же можете сворачивать/разворачивать узлы, включив режим свёртки.';
$string['then_leaf_control'] = '';
$string['tobecontinued'] = '...';
$string['too_large_fa'] = 'Регулярное выражение слишком большое для движка {$a->engine} в соответствии с лимитами времени и памяти. Попробуйте другой движок, попросите администратора <a href="{$a->link}">увеличить лимиты времени и памяти</a> или упростите регулярное выражение.';
$string['toolargequant'] = 'Слишком большой квантификатор';
$string['toomanyerrors'] = '.......и ещё ошибок -  {$a}';
$string['truefalse_leaf_assert'] = 'fictive';
$string['ucp_leaf_control'] = '';
$string['unallowedhint'] = 'Выбранная подсказка не допускается из-за ограничений в настройках вопроса.  Чтобы разрешить её, установите «Разрешить подсказку {$a}» в «Да». Выбранный механизм соответствия может повлиять на пригодность подсказок.';
$string['unclosed_charset_node_error'] = 'Синтаксическая ошибка: ожидалась закрывающая квадратная скобка \']\' для символьного класса, начавшегося с позиции {$a->colfirst}';
$string['unexisting_subexpr_node_error'] = 'Подвыражение "{$a->addinfo}" не найдено';
$string['ungreedyquant'] = 'Нежадные квантификаторы';
$string['unknown_control_sequence_node_error'] = 'Неизвестная управляющая последовательность: {$a->addinfo}';
$string['unknown_error_node_error'] = 'Неизвестная ошибка';
$string['unknown_posix_class_node_error'] = 'Неизвестный POSIX класс: {$a->addinfo}';
$string['unknown_template_node_error'] = 'Неизвестный шаблон: {$a->addinfo}';
$string['unknown_unicode_property_node_error'] = 'Неизвестное Unicode свойство: {$a->addinfo}';
$string['unrecognized_pqh_node_error'] = 'Неизвестный символ после (? или (?-';
$string['unrecognized_pqlt_node_error'] = 'Неизвестный символ после (?<';
$string['unrecognized_pqp_node_error'] = 'Неизвестный символ после (?P';
$string['unsupported'] = '{$a->nodename} в позиции с {$a->linefirst}:{$a->colfirst} по {$a->linelast}:{$a->collast} не поддерживается {$a->engine}.';
$string['unsupported_modifier_node_error'] = 'Неизвестный, неправильный или не поддерживаемый модификатор(модификаторы): {$a->addinfo}';
$string['unsupportedmodifier'] = 'Ошибка: модификатор {$a->modifier} не поддерживается {$a->classname}.';
$string['usecharhint'] = 'Разрешить подсказку следующего символа';
$string['usecharhint_help'] = 'В поведениях, разрешающих несколько попыток, показывать студентам кнопку подсказки следующего символа, которая показывает один правильный символ после правильной части ответа, давая штраф за эту подсказку. Не все движки поиска совпадений поддерживают подсказки.';
$string['usehint_help'] = 'В поведениях, разрешающих несколько попыток, показывать студентам кнопку подсказки следующего символа или следующей лексемы. Не все движки поиска совпадений поддерживают подсказки.';
$string['uselexemhint'] = 'Разрешить подсказку следующей лексемы (слова, числа, знака пунктуации)';
$string['uselexemhint_help'] = '<p>В поведениях, разрешающих несколько попыток, показывать студентам кнопку подсказки следующей лексемы, которая позволяет либо завершить текущую лексему, либо показать следующую, давая штраф за эту подсказку. Не все движки поиска совпадений поддерживают подсказки.</p><p><b>Лексема</b> - это атомарная часть языка: слово, число, знак препинания и т.д.</p>';
$string['utf16_leaf_control'] = '';
$string['utf8_leaf_control'] = '';
$string['wrong_template_params_count_node_error'] = 'Неверное количество параметров шаблона: {$a->addinfo->expected} ожидалось, {$a->addinfo->given} передано';
