<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'ro', version '4.1'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Activități';
$string['addcategory'] = 'Adaugă categorie';
$string['addcategoryerror'] = 'Nu s-a putut adăuga categoria.';
$string['addexceptionerror'] = 'Eroare întâmpinată la adăugarea excepției pentru userid:gradeitem';
$string['addfeedback'] = 'Adaugă feedback';
$string['addgradeletter'] = 'Adaugă o literă notare';
$string['addidnumbers'] = 'Adaugă identificatorul numerelor';
$string['additem'] = 'Adaugă element notă';
$string['additionalfeedback'] = 'Feedback adițional';
$string['addoutcome'] = 'Adaugă un rezultat';
$string['addoutcomeitem'] = 'Adaugă element rezultat';
$string['addscale'] = 'Adaugă o scală';
$string['adjustedweight'] = 'Pondere ajustată';
$string['aggregateextracreditmean'] = 'Media notelor (cu extra credite)';
$string['aggregatemax'] = 'Cea mai mare notă';
$string['aggregatemean'] = 'Media notelor';
$string['aggregatemedian'] = 'Media notelor';
$string['aggregatemin'] = 'Cea mai mică notă';
$string['aggregatemode'] = 'Mod note';
$string['aggregatenotonlygraded'] = 'Include notele necompletate';
$string['aggregateonlygraded'] = 'Exclude notele necompletate';
$string['aggregateonlygraded_help'] = 'O notă liberă este o notă care nu apare în catalog. Aceasta poate fi din cauza unei teme necorectate sau a unui test care n-a fost terminat de cursant etc.

Această setare determină dacă notele libere vor fi incluse în cumulare sau vor fi luate în considerare ca note minime, de exemplu, 0 pentru o temă cu note între 0 şi 10.';
$string['aggregateoutcomes'] = 'Includeți rezultatele în agregare';
$string['aggregateoutcomes_help'] = 'Dacă opțiunea este activată, rezultatele vor fi incluse în cumulare. Această setare ar putea duce însă la un număr total pentru categorie incorect. ';
$string['aggregatesonly'] = 'Modificare - doar pentru agregate';
$string['aggregatesubcatsupgradedgrades'] = 'Notă: Setarea de agregare „Agregare incluzând subcategorii” a fost eliminată ca parte a unei actualizări a site-ului. Întrucât „Agregat incluzând subcategorii” a fost folosit anterior în acest curs, se recomandă să revizuiți această modificare în carnetul de note.';
$string['aggregatesum'] = 'Suma notelor';
$string['aggregateweightedmean'] = 'Media ponderată a notelor';
$string['aggregateweightedmean2'] = 'Media simplă ponderată a notelor';
$string['aggregation'] = 'Agregare';
$string['aggregation_help'] = 'Cumularea determină cum vor fi calculate notele dintr-o categorie:

* Media aritmetică - Suma tuturor notelor împărţită la numărul total de note
* Mediană - nota din mijloc, atunci când notele sunt aranjate în ordinea mărimii
* Cea mai mică notă
* Cea mai mare notă
* Modul notelor - nota care apare de cele mai multe ori în șirul de note
* Suma notelor - suma tuturor notelor, excluzând notele scalare';
$string['aggregation_link'] = 'grade/aggregation';
$string['aggregationcoef'] = 'Coeficient agregare';
$string['aggregationcoefextra'] = 'Credit suplimentar';
$string['aggregationcoefextra_help'] = 'În cazul în care alegeți să cumulați notele prin suma notelor sau media aritmetică și bifați și caseta credit suplimentar,nota maximă a elementului respectiv nu va fi adăugată la nota maximă a categoriei, care va duce la posibilitatea de a obţine nota maximă (sau note peste maximă dacă administratorul site-ului o permite) din categorie fără a avea nota maximă pentru elementul notat.

În cazul în care cumularea se stabilește prin Media Notelor (cu credite extra) şi creditul suplimentar este setat la o valoare mai mare decât zero, acest credit suplimentar va constitui factorul cu care se înmulţeşte nota înainte de a fi adăugată la totalul obținut din calculul mediei.';
$string['aggregationcoefextra_link'] = 'grade/aggregation';
$string['aggregationcoefextrasum'] = 'Credit suplimentar';
$string['aggregationcoefextrasum_help'] = 'În cazul în care caseta credit suplimentar este bifată, nota maximă a elementului nu se adaugă la nota maximă a categoriei, care va duce la posibilitatea de a obţine nota maximă (sau note peste maximă dacă administratorul site-ului o permite) din categorie fără a avea nota maximă pentru elementul notat.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Pondere extra credit';
$string['aggregationcoefextraweight_help'] = 'Dacă ponderea creditului suplimentar este stabilită la o valoare mai mare decât zero atunci nota va avea o însemnătate mai mare la cumulare. Numărul va constitui factorul cu care se înmulţeşte nota înainte de a fi adăugată la totalul obținut din calculul mediei.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Pondere element';
$string['aggregationcoefweight_help'] = 'Ponderea elementului se utilizează pentru a influenţa importanţa elementului, comparativ cu alte elemente de notare din aceeaşi categorie atunci când se cumulează notele din categoria respectivă.';
$string['aggregationcoefweight_link'] = 'grade/aggregation';
$string['aggregationhintdropped'] = '( Scăzut )';
$string['aggregationhintexcluded'] = '( Exclus )';
$string['aggregationhintextra'] = '( Credit extra )';
$string['aggregationhintnovalue'] = '( Necompletat )';
$string['aggregationofa'] = 'Agregare a {$a}';
$string['aggregationposition'] = 'Poziţie agregare';
$string['aggregationposition_help'] = 'Această setare determină dacă afișarea coloanelor sumative pentru categorii și cursuri vor fi afișate la începutul sau la sfârșitul rapoartelor catalogului.';
$string['aggregationsvisible'] = 'Tipuri de agregare disponibile';
$string['aggregationsvisiblehelp'] = 'Selectaţi toate tipurile de agregare care vor fi disponibile. Pentru selecţie multiplă apăsaţi tasta CTRL şi selectaţi elementele dorite.';
$string['allgrades'] = 'Toate notele sortate după categorie';
$string['allstudents'] = 'Toți cursanții';
$string['allusers'] = 'Toți utilizatorii';
$string['autosort'] = 'Sortare automată';
$string['availableidnumbers'] = 'Numere id disponibile';
$string['average'] = 'Media';
$string['averagesdecimalpoints'] = 'Zecimale in medii pe coloane';
$string['averagesdecimalpoints_help'] = 'Această opţiune determină dacă să se afișeze un număr diferit de zecimale pentru fiecare medie în defavoarea numărului pre-setat pentru categoria sau elementul de notat (transpunere). ';
$string['averagesdisplaytype'] = 'Tip de afișare a mediilor coloanelor';
$string['averagesdisplaytype_help'] = 'Această setare determină dacă media se va afișa ca notă reală, procent sau literă, sau dacă se va folosi tipul de afişare pre-setat pentru categoria sau elementul notat (transpunere)';
$string['backupwithoutgradebook'] = 'Copia de siguranţă nu include configurarea Catalogului';
$string['badgrade'] = 'Nota furnizată nu este corectă';
$string['badlyformattedscale'] = 'Completaţi o listă cu valori separate cu virgulă (cel puţin două valori)';
$string['baduser'] = 'Utilizatorul furnizat nu este corect';
$string['bonuspoints'] = 'Puncte bonus';
$string['bulkcheckboxes'] = 'Bulk checkboxes';
$string['calculatedgrade'] = 'Nota calculată';
$string['calculation'] = 'Calculare';
$string['calculation_help'] = 'Un calcul pentru note este o formulă utilizată pentru a determina notele. Formula trebuie să înceapă cu un semn egal (=) şi se pot utiliza operațiile matematice cunoscute, cum ar fi Max, Min şi Sum (la fel ca in M. Excel). Dacă se doreşte, și alte elemente de notare pot fi incluse în calcul, prin tastarea numerelor de identificare în paranteze pătrate duble.';
$string['calculation_link'] = 'grade/calculation';
$string['calculationadd'] = 'Adaugă calculare';
$string['calculationedit'] = 'Editare calculare';
$string['calculationsaved'] = 'Calculare salvată';
$string['calculationview'] = 'Afişează calculare';
$string['cannotaccessgroup'] = 'Ne pare rău, notele grupului selectat nu pot fi accesate.';
$string['categories'] = 'Categorii';
$string['category'] = 'Categorie';
$string['categoryedit'] = 'Modificați categoria';
$string['categoryname'] = 'Nume categorie';
$string['categorytotal'] = 'Total categorie';
$string['categorytotalfull'] = 'Total categoria {$a->category}';
$string['categorytotalname'] = 'Numele complet al categoriei';
$string['changedefaults'] = 'Schimbare setări implicite';
$string['changereportdefaults'] = 'Schimbare setări implicite de raportare';
$string['chooseaction'] = 'Selectaţi o acţiune...';
$string['choosecategory'] = 'Selectare categorie';
$string['collapsecriterion'] = 'Criteriu restrâns';
$string['combo'] = 'Meniu Tabs și Dropdown';
$string['compact'] = 'Compact';
$string['componentcontrolsvisibility'] = 'Deși nota este ascunsă, este controlată prin setările activității';
$string['contract'] = 'Categorie contract';
$string['contributiontocoursetotal'] = 'Contribuția la totalul cursului';
$string['controls'] = 'Controale';
$string['courseavg'] = 'Media cursului';
$string['coursegradecategory'] = 'Categoria notă la curs';
$string['coursegradedisplaytype'] = 'Tip de afișare a notei de la curs';
$string['coursegradedisplayupdated'] = 'Tipul de afișare a notei de la curs a fost actualizat';
$string['coursegradesettings'] = 'Setările notelor cursului';
$string['coursename'] = 'Denumire curs';
$string['coursescales'] = 'Scalele cursului';
$string['coursesettings'] = 'Setări curs';
$string['coursesettingsexplanation'] = 'Setările curs stabilesc modul în care catalogul va fi afişat participanţilor la curs.';
$string['coursesiamtaking'] = 'Cursurile la care particip';
$string['coursesiamteaching'] = 'Cursurile pe care le predau';
$string['coursetotal'] = 'Total curs';
$string['createcategory'] = 'Creează categorie';
$string['createcategoryerror'] = 'Nu s-a putut crea o nouă categorie';
$string['creatinggradebooksettings'] = 'Se creează setările catalogului';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Agregare părinte curent';
$string['curveto'] = 'curbă la';
$string['decimalpoints'] = 'Puncte zecimale generale';
$string['decimalpoints_help'] = 'Această opţiune determină numărul de zecimale afișate pentru note. Nu are nici un efect asupra calculelor notelor, care sunt făcute cu o precizie de 5 zecimale.';
$string['default'] = 'Implicit';
$string['defaultprev'] = '({$a}) implicit';
$string['deletecategory'] = 'Ştergere categorie';
$string['deletescale'] = 'Ștergere scală';
$string['disablegradehistory'] = 'Dezactivează istoric note';
$string['disablegradehistory_help'] = 'Dezactivați înregistrarea modificărilor in tabele asociate cu note. Acest lucru poate ajuta serverul să ofere viteze mai bune şi poate duce la economisirea de spaţiu în baza de date.';
$string['displaylettergrade'] = 'Afişează note sub formă de litere';
$string['displaypercent'] = 'Afişează procentaj';
$string['displaypoints'] = 'Afişează puncte';
$string['displayweighted'] = 'Afișează notele ponderate';
$string['dropdown'] = 'Meniu listă derulantă';
$string['droplow'] = 'Renunță la cea mai mică valoare';
$string['droplow_help'] = 'Această setare îți permite să specifici un număr pentru cele mai mici note care să nu fie incluse în agregare.';
$string['droplowestvalue'] = 'Setează renunțarea la cea mai mică valoare a notei';
$string['droplowestvalues'] = 'Scade {$a} cele mai mici valori';
$string['dropped'] = 'Scăzut';
$string['dropxlowest'] = 'Anulează X cele mai mici';
$string['dropxlowestwarning'] = 'Notă: Dacă utilizați renunță la x cel mai mic, notarea presupune că toate articolele din categorie au aceeași valoare punctuală. Dacă valorile punctelor diferă, rezultatele vor fi imprevizibile';
$string['duplicatedgradeitem'] = '{$a} (copie)';
$string['duplicatescale'] = 'Duplicare scală';
$string['edit'] = 'Editare';
$string['editcalculation'] = 'Editează calculare';
$string['editcalculationverbose'] = 'Editează calculare pentru {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Editează feedback';
$string['editgrade'] = 'Editează notă';
$string['editgradeletters'] = 'Editează literele notelor';
$string['editoutcome'] = 'Editează rezultatul';
$string['editoutcomes'] = 'Editează rezultatele';
$string['editscale'] = 'Editare scală';
$string['edittree'] = 'Configurare';
$string['editverbose'] = 'Editare {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Activează AJAX';
$string['enableajax_help'] = 'Adaugă funcţionalitate AJAX la raportul notelor, simplificând și accelerând calculele obișnuite.  Javascript trebuie să fie activat în browser-ul utilizatorului.';
$string['enableoutcomes'] = 'Activați rezultatele';
$string['enableoutcomes_help'] = 'Dacă este activată, elementele de notare pot fi clasificate folosind una sau mai multe scale în funcție de rezultate.';
$string['encoding'] = 'Codare';
$string['encoding_help'] = 'Selectați codificarea caracterelor folosită pentru date. (Codificarea standard este UTF-8.) Dacă codificarea greșită este selectată din greșeală, aceasta va fi vizibilă la previzualizarea datelor pentru import.';
$string['errorcalculationbroken'] = 'Probabil referință circulară sau formulă de calcul greșită';
$string['errorcalculationnoequal'] = 'Formula trebuie să înceapă cu semnul "egal" (=1+2)';
$string['errorcalculationunknown'] = 'Formulă incorectă';
$string['errorgradevaluenonnumeric'] = 'S-a obținut un caracter non-numeric pentru notă mică sau mare a cursantului';
$string['errornocalculationallowed'] = 'Nu se permit calcule pentru acest element';
$string['errornocategorisedid'] = 'Nu se poate obține un id fără categorie!';
$string['errornocourse'] = 'Nu s-au putut obţine informaţii despre curs';
$string['errorreprintheadersnonnumeric'] = 'S-a primit valoare non-numerică pentru antetele de reimprimare';
$string['errorsavegrade'] = 'Ne pare rău, nota nu a putut fi salvată.';
$string['errorsettinggrade'] = 'Eroare la salvarea "{$a->itemname}" notei pentru userid {$a-> userid}';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Eroare la actualizarea setării „Agregați numai note ne-goale” din ID-ul categoriei de note {$a->id}';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Eroare la actualizarea setării „Includeți rezultatele în agregare” a ID-ului categoriei de notă {$a->id}';
$string['errorupdatinggradecategoryaggregation'] = 'Eroare la actualizarea tipului de agregare a ID-ului categoriei de notă {$a->id}';
$string['errorupdatinggradeitemaggregationcoef'] = 'Eroare la actualizarea coeficientului de agregare (pondere sau credit suplimentar) a codului articolului ID {$a->id}';
$string['eventgradedeleted'] = 'Nota ștearsă';
$string['eventgradeexported'] = 'Notă exportată';
$string['eventgradeitemcreated'] = 'Element de notă creat';
$string['eventgradeitemdeleted'] = 'Element de notă șters';
$string['eventgradeitemupdated'] = 'Element de notă actualizat';
$string['eventgradelettercreated'] = 'Literă de notă creată';
$string['eventgradeletterdeleted'] = 'Literă de notă ștearsă';
$string['eventgradeletterupdated'] = 'Literă de notă creată';
$string['eventgradeviewed'] = 'Notele au fost văzute în catalog';
$string['eventscalecreated'] = 'Scală creată';
$string['eventscaledeleted'] = 'Scală ștearsă';
$string['eventscaleupdated'] = 'Scală actualizată';
$string['eventusergraded'] = 'Utilizator notat';
$string['excluded'] = 'Excluse';
$string['excluded_help'] = 'Dacă se bifează, nota nu va fi inclusă în nici o cumulare.';
$string['expand'] = 'Extinde categorie';
$string['expandcriterion'] = 'Expandare criteriu';
$string['export'] = 'Export';
$string['exportalloutcomes'] = 'Exportă toate rezultatele';
$string['exportas'] = 'Export ca';
$string['exportfeedback'] = 'Include feedback în export';
$string['exportfeedback_desc'] = 'Poate fi suprascris în timpul exportului.';
$string['exportformatoptions'] = 'Opțiuni pentru formatul exportului';
$string['exportonlyactive'] = 'Exclude utilizatorii suspendați';
$string['exportonlyactive_help'] = 'Include în export doar studenții a căror înscriere este activă și nu a fost suspendată';
$string['exportplugins'] = 'Exportă plugin-uri';
$string['exportsettings'] = 'Exportă setări';
$string['exportto'] = 'Exportă în';
$string['externalurl'] = 'URL extern';
$string['externalurl_desc'] = 'Dacă se folosește un catalog extern, URL-ul trebuie specificat aici';
$string['extracreditvalue'] = 'Valoare extra credit pentru {$a}';
$string['extracreditwarning'] = 'Notă: setarea tuturor articolelor pentru o categorie la credit suplimentar le va elimina efectiv din calculul calificării. Deoarece nu va exista niciun punct total';
$string['fail'] = 'Eșuat';
$string['feedback'] = 'Feedback';
$string['feedback_help'] = 'Această casetă permite să se adauge comentarii cu privire la nota ce trebuie adăugată.';
$string['feedbackadd'] = 'Adaugă feedback';
$string['feedbackedit'] = 'Editează feedback';
$string['feedbackfiles'] = 'Fișiere de feedback';
$string['feedbackforgradeitems'] = 'Feedback pentru {$a}';
$string['feedbackhistoryfiles'] = 'Istoricul fișierelor de feedback';
$string['feedbacks'] = 'Feedback-uri';
$string['feedbacksaved'] = 'Feedback salvat';
$string['feedbackview'] = 'Vizualizează feedback';
$string['finalgrade'] = 'Notă finală';
$string['finalgrade_help'] = 'În cazul în care se bifează caseta de selectare suprascrisă, nota finală va putea fi adăugată sau modificată.';
$string['fixedstudents'] = 'Coloane statice ale cursanților';
$string['fixedstudents_help'] = 'Permite coloana notelor să fie explorabilă orizontal în timp ce coloana cu studenți devine statică.';
$string['forceimport'] = 'Forțează importul';
$string['forceimport_help'] = 'Forțați importul notelor chiar dacă notele au fost actualizate după exportarea fișierului de import';
$string['forceoff'] = 'Forțează: Dezactivat';
$string['forceon'] = 'Forțează: Activat';
$string['forelementtypes'] = 'pentru {$a} selectate';
$string['forstudents'] = 'Pentru studenţi';
$string['full'] = 'Complet';
$string['fullmode'] = 'Schimbă la vizualizare completă';
$string['generalsettings'] = 'Setări generale';
$string['grade'] = 'Notă';
$string['grade_help'] = 'Nota dată a cursantului pentru munca depusă.';
$string['gradeadministration'] = 'Administrare notă';
$string['gradealreadyupdated'] = 'Notele {$a} nu au fost importate, deoarece notele din fișierul de import sunt mai vechi decât în raportul notelor. Pentru a continua importul notelor, utilizați opțiunea: obligați importul.';
$string['gradeanalysis'] = 'Analiza notelor';
$string['gradebook'] = 'Catalog';
$string['gradebookcalculationsfixbutton'] = 'Accepta modificările notelor și remediază erorile de calcul';
$string['gradebookcalculationsuptodate'] = 'Calculele din catalog sunt actualizate. Poate fi necesar să reîncărcați această pagină pentru a vedea modificările.';
$string['gradebookcalculationswarning'] = 'Notă: Au fost detectate unele erori la calcularea notelor afișate în catalog. În cazul în care cursul dumneavoastră nu a început sau este în curs de desfășurare, se recomandă ca erorile să fie remediate făcând click pe butonul de mai jos, deși acest lucru va presupune modificarea unor note. În cazul în care cursul dumneavoastră s-sa încheiat deja și notele au fost înregistrate, probabil nu doriți să remediați această problemă.

Versiunea mai nouă este {$a->currentversion}; dumneavoastră utilizați versiunea catalogului {$a->gradebookversion}. Puteți vedea o listă cu schimbările în <a href="{$a->url}">Modificările calculului în catalog</a>.';
$string['gradebookhiddenerror'] = 'Setările catalogului nu permit afişarea niciunei informaţii către cursanţi.';
$string['gradebookhistories'] = 'Istoric note';
$string['gradebooknavigationmenu'] = 'Meniul de navigare din Catalogul de note';
$string['gradebooksetup'] = 'Setare catalog de note';
$string['gradeboundary'] = 'Limita intervalului de litere a notelor';
$string['gradeboundary_help'] = 'Această setare determină numărul minim peste care notelor li se vor atribui o literă (ex. A,B,C - sistem de notare American).';
$string['gradecategories'] = 'Categorii note';
$string['gradecategory'] = 'Categorie notă';
$string['gradecategoryonmodform'] = 'Categorie notă';
$string['gradecategoryonmodform_help'] = 'Această setare setează categoria în care notele de la această activitate sunt trecute în catalog.';
$string['gradecategorysettings'] = 'Setări categorie notă';
$string['gradedisplay'] = 'Afişare notă';
$string['gradedisplaytype'] = 'Tip afişare notă';
$string['gradedisplaytype_help'] = 'Această setare determină modul în care sunt afișate notele în rapoartele de note și de utilizator.

* Scrisoare - Scrisorile sau cuvintele sunt folosite pentru a reprezenta o gamă de note, așa cum sunt definite în „Scrisori” în configurația cărții de note
* Procent - relativ la notele maxime și minime
* Real - note reale sau valori ale scalei';
$string['gradedon'] = 'Notat: {$a}';
$string['gradeexport'] = 'Export notă';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Câmpurile de profil personalizate de exportul de note';
$string['gradeexportcustomprofilefields_desc'] = 'Includeți aceste câmpuri de profil personalizate în exportul de note, separate prin virgule.';
$string['gradeexportdecimalpoints'] = 'Puncte zecimale în exportul notelor';
$string['gradeexportdecimalpoints_desc'] = 'Numărul de zecimale afișate pentru export. Poate fi suprascris în timpul exportului.';
$string['gradeexportdisplaytype'] = 'Tip de afișare a notelor din export';
$string['gradeexportdisplaytype_desc'] = 'Notele pot fi afișate ca note reale, ca procentaje (referitoare la notele minime și maxime) sau ca litere  (A, B, C etc..) în timpul exportului. Se poate suprascrie în timpul exportului.';
$string['gradeexportdisplaytypes'] = 'Tipuri de afișare a notelor din export';
$string['gradeexportuserprofilefields'] = 'Câmpurile din profilul utilizatorului afișate în exportul de note';
$string['gradeexportuserprofilefields_desc'] = 'Includeți aceste câmpuri de profil de utilizator în exportul notelor, separate prin virgulă.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Note minime și maxime inițiale';
$string['gradehelp'] = 'Ajutor la notare';
$string['gradehistorylifetime'] = 'Istoricul notelor';
$string['gradehistorylifetime_help'] = 'Aici se precizează durata de timp în care doriţi să păstraţi istoricul cu modificări din tabelele cu note. Este recomandat să-l păstraţi cât mai mult timp. Dacă vă confruntaţi cu probleme de performanţă sau nu aveți destul spațiu pentru baza de date, încercaţi să setaţi o valoare mai mică.';
$string['gradeimport'] = 'Import notă';
$string['gradeimportfailed'] = 'Importul notelor nu s-a finalizat cu succes. Detalii:';
$string['gradeitem'] = 'Element notă';
$string['gradeitemaddusers'] = 'Exclude din notare';
$string['gradeitemadvanced'] = 'Opțiuni avansate pentru elemente de notă';
$string['gradeitemadvanced_help'] = 'Selectaţi toate elementele care ar trebui să fie afişate ca fiind avansate atunci când editați elemente de notare';
$string['gradeitemislocked'] = 'Această activitate este blocată în catalog. Modificările care sunt aduse notelor în această activitate nu vor fi copiate în catalog până când acesta este deblocat.';
$string['gradeitemlocked'] = 'Notare blocată';
$string['gradeitemmembersselected'] = 'Exclus din notare';
$string['gradeitemminmax'] = 'Notele minime și maxime specificate în setările elementului notei';
$string['gradeitemnonmembers'] = 'Inclus în notare';
$string['gradeitemremovemembers'] = 'Include în notare';
$string['gradeitems'] = 'Elemente de notare';
$string['gradeitemsettings'] = 'Setări elemente notare';
$string['gradeitemsinc'] = 'Elemente de notare care să fie incluse';
$string['gradeletter'] = 'Litere note';
$string['gradeletter_help'] = 'Notele pot fi de asemenea litere: A, B, C, ..., sau cuvinte, de exemplu: Admis, Respins .... Acestea pot fi utilizate pentru a reprezenta o serie de note.';
$string['gradeletternote'] = 'Pentru a șterge o literă de notă, trebuie doar să goliți oricare dintre cele <br /> trei zone de text pentru acea literă și să faceți clic pe trimitere.';
$string['gradeletteroverridden'] = 'Literele de notă implicite sunt în prezent suprascrise.';
$string['gradeletters'] = 'Note sub formă de litere';
$string['gradelocked'] = 'Nota este blocată';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Notă maximă';
$string['grademax_help'] = 'Această setare determină nota maximă atunci când se utilizează sistemul de notare valoric (un număr cu o valoare maximă și una minimă). Nota maximă pentru o activitate este determinată pe pagina Setări Activitate.';
$string['grademin'] = 'Notă minimă';
$string['grademin_help'] = 'Această setare determină nota minimă atunci când se utilizează sistemul de notare valoric.';
$string['gradenotificationmessage'] = 'Aveți feedback nou despre munca dvs. pentru „{$a}”';
$string['gradenotificationsubject'] = 'Ați primit o notă';
$string['gradeoutcomeitem'] = 'Elementul rezultatului notei';
$string['gradeoutcomes'] = 'Rezultate';
$string['gradeoutcomescourses'] = 'Rezultate curs';
$string['gradepass'] = 'Notă de trecere';
$string['gradepass_help'] = 'Această setare determină nota minimă obligatorie pentru trecere. Nota va determina completarea activității și a finalizării cursului şi va apărea, de asemenea, în catalog unde notele de trecere sunt evidențiate cu verde, iar cele de respingere sunt evidențiate de culoarea roșie.';
$string['gradepassgreaterthangrade'] = 'Nota de trecere nu poate fi mai mare decât nota maximă posibilă {$a}';
$string['gradepointdefault'] = 'Nivel implicit al notei';
$string['gradepointdefault_help'] = 'Această setare determină valoarea implicită pentru valoarea punctelor disponibile într-un element de notă.';
$string['gradepointdefault_validateerror'] = 'Această setare trebuie să fie un număr întreg între 1 și valoarea maximă a notei.';
$string['gradepointmax'] = 'Nivel maxim al notei';
$string['gradepointmax_help'] = 'Această setare detremină valoarea maximă implicită a notei disponibilă într-o activitate.';
$string['gradepointmax_validateerror'] = 'Această setare trebuie să fie un număr întreg între 1 și 10000.';
$string['gradepreferences'] = 'Preferinţe note';
$string['gradepreferenceshelp'] = 'Preferințe de ajutor pentru note';
$string['gradepublishing'] = 'Activează afișarea';
$string['gradepublishing_help'] = 'Publicarea notelor este un mod de a importa și exporta notele printr-o adresă URL fără a fi conectat la Moodle. Dacă este activat, administratorilor și utilizatorilor cu permisiunea de a publica calificările (în mod implicit, utilizatorii cu rolul de manager) li se oferă setări de publicare a calificărilor în fiecare carnet de calificare.';
$string['gradepublishinglink'] = 'Descarcă: {$a}';
$string['gradereport'] = 'Raport al notelor';
$string['graderreport'] = 'Raportul evaluatorului';
$string['grades'] = 'Note';
$string['gradesforuser'] = 'Notele lui {$a->user}';
$string['gradesmoduledeletionpendingwarning'] = 'Avertizare: Are loc ștergerea activității! Unele note urmează să fie șterse.';
$string['gradesmoduledeletionprefix'] = '[Eliminare în curs]';
$string['gradesonly'] = 'Doar note';
$string['gradessettings'] = 'Setări note';
$string['gradetype'] = 'Tip note';
$string['gradetype_help'] = 'Există 4 tipuri de note:
* Nici una - Nici o valoare de notare disponibilă
* Valoric - O valoare numerică cu un maxim şi un minim
* Scalar - O valoare dintr-o listă (Bine, Foarte Bine etc)
* Text - numai Feedback scris;

Numai tipurile de note valorice și scalare pot fi cumulate. Tipul notelor pentru o activitate poate fi setat pe pagina setări activitate.';
$string['gradevaluetoobig'] = 'Una dintre valorile notei este mai mare decât nota maximă admisă {$a}';
$string['gradevaluetoosmall'] = 'Una dintre valorile notei este mai mică decât minimul acceptat al notei de {$a}';
$string['gradeview'] = 'Vezi nota';
$string['gradewasmodifiedduringediting'] = 'Nota la {$a->itemname} a lui {$a->username} nu a fost luată în considerare deoarece a fost actualizată mai recent de altcineva.';
$string['gradeweighthelp'] = 'Ajutor la ponderarea notelor';
$string['gradingmodulename'] = 'Notă ({$a})';
$string['groupavg'] = 'Medie grup';
$string['hidden'] = 'Ascuns';
$string['hidden_help'] = 'Dacă se bifează, notele nu vor fi afișate cursanților. Notele pot fi ascunse până la o dată anume dacă se doreşte, pentru a afișa notele doar după ce se termină corectarea.';
$string['hiddenasdate'] = 'Afişează data la care au fost asignate notele ascunse';
$string['hiddenasdate_help'] = 'În cazul în care utilizatorul nu poate vedea notele ascunse, se arată data predării în loc de "-".';
$string['hiddenuntil'] = 'Ascuns până la';
$string['hiddenuntildate'] = 'Ascuns până la: {$a}';
$string['hideadvanced'] = 'Ascunde funcţionalităţi complexe';
$string['hideaverages'] = 'Ascunde mediile';
$string['hidecalculations'] = 'Ascunde calcule';
$string['hidecategory'] = 'Ascuns';
$string['hideeyecons'] = 'Ascunde pictograme/afișează pictograme';
$string['hidefeedback'] = 'Ascunde feedback';
$string['hideforcedsettings'] = 'Ascundeți setările forțate';
$string['hideforcedsettings_help'] = 'Nu afișați setările impuse în interfața de corectat. ';
$string['hidegroups'] = 'Ascunde grupuri';
$string['hidelocks'] = 'Ascunde';
$string['hidenooutcomes'] = 'Afișează rezultatele';
$string['hidequickfeedback'] = 'Ascunde Quick Feedback';
$string['hideranges'] = 'Ascundeți intervalele';
$string['hidetotalifhiddenitems'] = 'Nu mai afișa totalurile dacă acestea conțin elemente ascunse';
$string['hidetotalifhiddenitems_help'] = 'Această setare specifică dacă totalurile care conţin elemente de notare ascunse sunt afișate cursanților sau înlocuite cu o cratimă (-). În cazul în care sunt afișate, totalul poate fi calculat fie prin excluderea, fie prin includerea elementelor ascunse.

În cazul în care elementele ascunse sunt excluse, totalul va fi diferit de cel văzut de către profesor în raportul notelor, deoarece profesorul vede întotdeauna totalurile calculate din toate elementele indiferent dacă acestea sunt ascunse sau vizibile pentru cursanți. În cazul în care elementele ascunse sunt incluse, cursanții ar putea să calculeze elementele ascunse.';
$string['hidetotalshowexhiddenitems'] = 'Afișați totalurile excluzând elementele ascunse';
$string['hidetotalshowinchiddenitems'] = 'Afișați totalurile, inclusiv elementele ascunse';
$string['hideverbose'] = 'Ascunde {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Sortează după note în ordine crescătoare';
$string['highgradedescending'] = 'Sortează după note în ordine descrescătoare';
$string['highgradeletter'] = 'Ridicat';
$string['identifier'] = 'Identifică utilizator după';
$string['idnumbers'] = 'Numere ID';
$string['ignore'] = 'Ignoră';
$string['import'] = 'Import';
$string['importas'] = 'Import ca';
$string['importcsv'] = 'Import CSV';
$string['importcsv_help'] = 'Notele pot fi importate printr-un fișier CSV cu formatul după cum urmează:

* Fiecare linie a fișierului conține o înregistrare
* Fiecare înregistrare este o serie de date separate de separatorul selectat
* Prima înregistrare conține o listă de nume de câmpuri care definesc formatul restului fișierului
* Este necesar un nume de câmp care să conțină datele de identitate a utilizatorului - fie nume de utilizator, fie număr de identificare, fie adresă de e-mail

Un fișier cu formatul corect poate fi obținut prin exportarea mai întâi a unor note. Fișierul poate fi apoi editat și salvat ca fișier CSV.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Import sub formă de rezultate personalizate (numai acest curs)';
$string['importdata'] = 'Date';
$string['importdata_help'] = 'Notele pot fi lipite direct dintr-o foaie de calcul OpenDocument sau Excel având formatul după cum urmează:

* Cel puțin o coloană trebuie să conțină date despre identitatea utilizatorului - nume de utilizator, adresa de e-mail sau numărul de identificare.
* Celelalte coloane ar trebui să aibă anteturi ca pentru activitățile existente sau elemente de notare.

O foaie de calcul formatată corect poate fi obținută prin exportarea mai întâi a unor note. Foaia de calcul poate fi apoi editată pentru a adăuga mai multe note și salvată.

Selectați și copiați coloanele pe care doriți să le importați din foaia de calcul și apoi lipiți-le în acest câmp.';
$string['importerror'] = 'A apărut o eroare, acest script nu are parametrii corecți.';
$string['importfailed'] = 'Operaţiunea de import a eşuat, nu s-a importat nicio notă.';
$string['importfeedback'] = 'Importă feedback';
$string['importfile'] = 'Importă fişier';
$string['importfilemissing'] = 'Niciun fișier nu a fost primit,mergeți înapoi la formular și asigurați-vă că încărcați un fișier valid.';
$string['importfrom'] = 'Importă din';
$string['importoutcomenofile'] = 'Fișierul încărcat este gol sau deteriorat. Vă rugăm să verificați dacă este un fișier valid. Problema a fost detectată la linia {$a}; acest lucru este declanșat de liniile de date care nu au la fel de multe coloane ca prima linie (linia de antet) sau în cazul în care fișierul importat nu are antetele prevăzute. Verificați fișierul exportat pentru un exemplu de fișier cu antet valid.';
$string['importoutcomes'] = 'Importă rezultatele';
$string['importoutcomes_help'] = 'Rezultatele pot fi importate și exportate prin intermediul fișierelor format csv (en. Comma Separated Values - Valori Separate prin Virgulă)';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Rezultat importat "{$a->name}" cu ID #{$a->id}';
$string['importplugins'] = 'Importă plugin-uri';
$string['importpreview'] = 'Previzualizare import';
$string['importsettings'] = 'Setări import';
$string['importskippednomanagescale'] = 'Nu aveți permisiunea de a adăuga o nouă scală, astfel încât rezultatul "{$a}" a fost omis deoarece necesită crearea unei noi scale';
$string['importskippedoutcome'] = 'Un rezultat cu numele prescurtat "{$a}" există deja în acest context, cel din fișierul importat a fost omis.';
$string['importstandard'] = 'Importă ca rezultate standard';
$string['importsuccess'] = 'Importul notelor a reușit';
$string['importxml'] = 'Import XML';
$string['includescalesinaggregation'] = 'Include scalele în agregare';
$string['includescalesinaggregation_help'] = 'Puteţi alege dacă notele scalare să fie sau nu incluse ca numere în cumularea notelor pentru toate cataloagele de note din toate cursurile. ATENŢIE: Modificarea acestei setări va forța recalcularea tuturor cumulărilor de note.';
$string['incorrectcourseid'] = 'ID-ul cursului nu a fost corect';
$string['incorrectcustomscale'] = '(Scală particularizată incorectă, vă rugăm să modificați)';
$string['incorrectminmax'] = 'Valoarea minimă trebuie să fie mai mică decât valoarea maximă';
$string['inherit'] = 'Moștenit';
$string['intersectioninfo'] = 'Informații student/notă';
$string['invalidgradeexporteddate'] = 'Data exportului nu este validă, deoarece este cu mai mult de un an în urmă, este în viitor sau formatul datei nu este valid.';
$string['item'] = 'Element';
$string['iteminfo'] = 'Info element';
$string['iteminfo_help'] = 'Această setare oferă spaţiu pentru a introduce informaţii despre element. Informaţia nu este afişată în altă parte.';
$string['itemname'] = 'Nume element';
$string['itemnamehelp'] = 'Numele acestui element dat de modul.';
$string['items'] = 'Elemente';
$string['itemsedit'] = 'Editare element notă';
$string['keephigh'] = 'Păstrează pe cele mai mari';
$string['keephigh_help'] = 'Dacă se selectează, această opţiune va păstra X cele mai mari note, X fiind valoarea selectată pentru această opţiune.';
$string['keephighestvalues'] = 'Păstrează cele mai {$a} mari valori';
$string['keymanager'] = 'Manager de chei';
$string['lessthanmin'] = 'Nota inserată pentru {$a->itemname} pentru {$a->username} este mai mică decât minimul permis';
$string['letter'] = 'Literă';
$string['lettergrade'] = 'Notă sub formă de literă';
$string['lettergradenonnumber'] = 'Nota mică și/sau mare au fost non-numerice pentru';
$string['letterpercentage'] = 'Literă (procentaj)';
$string['letterreal'] = 'Literă (reală)';
$string['letters'] = 'Litere';
$string['linkedactivity'] = 'Activitate corelată';
$string['linkedactivity_help'] = 'Această setare specifică o  activitate de care este legată (linked) acest element-rezultat. Puteți utiliza această funcționalitate pentru măsurarea performanţelor cursanților pe criterii ce nu au fost evaluate pentru nota acordată pe activitate.';
$string['linktoactivity'] = 'Legătură către {$a->name} activitatea {$a->title}';
$string['lock'] = 'Blocare';
$string['locked'] = 'Blocat';
$string['locked_help'] = 'Dacă se bifează, notele nu mai pot fi actualizate automat de activitățile asociate.';
$string['locktime'] = 'Blocare după';
$string['locktimedate'] = 'Blocat după: {$a}';
$string['lockverbose'] = 'Blochează: {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Cel mai mic';
$string['lowgradeletter'] = 'Mic';
$string['manageoutcomes'] = 'Administrează rezultate';
$string['manualitem'] = 'Element manual';
$string['mapfrom'] = 'Mapează din';
$string['mapfrom_help'] = 'Selectați coloana din foaia de calcul care conține date pentru identificarea utilizatorului, cum ar fi numele de utilizator, ID-ul de utilizator sau adresa de e-mail.';
$string['mappings'] = 'Mapările notelor';
$string['mappings_help'] = 'Pentru fiecare coloană de notp din foaia de calcul, selectați elementul de notă corespunzător în care să importați notele.';
$string['mapto'] = 'Mapează la';
$string['mapto_help'] = 'Selectați aceleași date de identificare precum cele selectate pentru „Mapat din”.';
$string['max'] = 'Cel mai mare';
$string['maxgrade'] = 'Notă maximă';
$string['meanall'] = 'Toate notele';
$string['meangraded'] = 'Note care sunt completate';
$string['meanselection'] = 'Notele selectate pentru mediile coloanei';
$string['meanselection_help'] = 'Această setare determină dacă celulele fără note se vor include în calculul mediei pentru fiecare categorie sau element de notă.';
$string['median'] = 'Median';
$string['min'] = 'Cel mai mic';
$string['minimum_show'] = 'Afișează nota minimă';
$string['minimum_show_help'] = 'Nota minimă se utilizează la calcularea notelor și la pondere. În cazul în care nu este afișată, nota minimă va implicit zero și nu poate fi editată.';
$string['minmaxtouse'] = 'Notele minime și maxime admise în calcul';
$string['minmaxtouse_desc'] = 'Această setare determină dacă se utilizează notele minime și maxime inițiale de la data acordării notei sau notele minime și maxime specificate în setările pentru elementul de notă, atunci când se calculează nota afișată în registrul de note. Este recomandat ca această setare să nu fie modificată într-un moment esențial, deoarece toate notele vor fi recalculate, ceea ce poate duce la o încărcare mare a serverului.';
$string['minmaxtouse_help'] = 'Această setare determină utilizarea notelor maxime și minime inițiale din momentul în care s-a primit nota, sau notele minime și maxime așa cum este specificat în setările pentru elementule notei, atunci când se calculează nota afișată în catalog.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Notă: Unele note au fost modificate în scopul de a elimina o neconcordanță din catalog cauzată de o modificare a notelor minime și maxime utilizate la calcularea notei afișate. Se recomandă ca modificările să fie revizuite și acceptate.';
$string['minmaxupgradefixbutton'] = 'Rezolvă neconcordanțele';
$string['minmaxupgradewarning'] = 'Notă: A fost detectată o inconsecvență cu unele note din cauza modificării notelor minime și maxime utilizate la calcularea notei afișate în carnetul de note. Se recomandă ca inconsecvența să fie rezolvată făcând clic pe butonul de mai jos, deși acest lucru va duce la modificarea unor note.';
$string['missingitemtypeoreid'] = 'Cheia matricei (itemtype sau eid) lipsește din al doilea param al grade_edit_tree_column_select::get_item_cell($item, $params)';
$string['missingscale'] = 'Trebuie să selectaţi o scală';
$string['mode'] = 'Mod';
$string['modgrade'] = 'Notă';
$string['modgrade_help'] = 'Selectați tipul de notare utilizat pentru această activitate. Dacă se alege „scală”, puteți alege scala din meniul derulant. Dacă utilizați note, puteți introduce nota maximă disponibilă pentru această activitate.';
$string['modgradecantchangegradetype'] = 'Nu puteți schimba tipul, deoarece există deja note pentru acest element.';
$string['modgradecantchangegradetypemsg'] = 'Unele note au fost deja acordate, astfel încât tipul de notă nu poate fi schimbat. În cazul în care doriți să schimbați nota maximă, trebuie să alegeți mai întâi dacă redimensionați sau nu notele existente.';
$string['modgradecantchangegradetyporscalemsg'] = 'Unele note au fost deja acordate, astfel încât tipul de notă și scala nu pot fi schimbate.';
$string['modgradecantchangeratingmaxgrade'] = 'Nu poți modifica nota maximă atunci când există deja note pentru o activitate cu rating.';
$string['modgradecantchangescale'] = 'Nu puteți schimba scala, deoarece există deja note pentru acest element.';
$string['modgradecategorycantchangegradetypemsg'] = 'Această categorie are asociate elemente de notare care au fost suprascrise. Prin urmare, unele note au fost deja acordate, astfel încât tipul de notă nu poate fi modificat. Dacă doriți să modificați nota maximă, trebuie mai întâi să alegeți dacă doriți sau nu să modificați din nou notele existente.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Această categorie are asociate elemente de notare care au fost surpascrise. Prin urmare, unele note au fost deja acordate, așadar tipul de notă și scala nu pot fi schimbate.';
$string['modgradecategoryrescalegrades'] = 'Rescalează notele suprascrise';
$string['modgradecategoryrescalegrades_help'] = 'Atunci când modificați notele maxime pentru un articol din notă, trebuie să specificați dacă acest lucru va determina sau nu să se schimbe și notele procentuale existente.

Dacă această opțiune este setată la „Da”, orice notă existentă va fi modificată, astfel încât gradul procentual să rămână același.

De exemplu, dacă această opțiune este setată la „Da”, modificarea notei maxime pentru un articol de la 10 la 20 ar determina recalificarea unei note de 6/10 (60%) la 12/20 (60%). Cu această opțiune setată la „Nu”, nota va rămâne neschimbată, necesitând ajustarea manuală a elementelor de notare pentru a asigura scorurile corecte.';
$string['modgradedonotmodify'] = 'Nu modifica notele existente';
$string['modgradeerrorbadpoint'] = 'Valoare nevalidă a notei. Trebuie să fie un număr întreg între 1 și {$a}';
$string['modgradeerrorbadscale'] = 'Scală nevalidă selectată. Asigurați-vă că selectați o scală de mai jos.';
$string['modgrademaxgrade'] = 'Nota maximă';
$string['modgraderescalegrades'] = 'Renotați notele existente';
$string['modgraderescalegrades_help'] = 'Când se schimbă notele maxime în catalog, trebuie să specificați dacă  acest lucru va determina și schimbarea notelor procentuale existente.

Dacă setați \'Da\', toate notele existente vor fi rescalate, astfel încât nota procentuală să rămână aceeași.

De exemplu, în cazul în care această opțiune este setată "Da", schimbarea notei maximă  de la 10 la 20 ar însemna o notă de 6/10 (60%), care urmează să fie rescalată la 12/20 (60%). Când această opțiune este setată "Nu", nota se va schimba de la 6/10 (60%), la 6/20 (30%), necesitând ajustarea manuală a elementelor de notare pentru a avea nota corectă.';
$string['modgradetype'] = 'Tip';
$string['modgradetypenone'] = 'Nici una';
$string['modgradetypepoint'] = 'Punct';
$string['modgradetypescale'] = 'Scală';
$string['morethanmax'] = 'Nota pe care aţi completat-o pentru {$a->itemname} pentru {$a->username} este mai mare decât nota maximă admisă.';
$string['moveselectedto'] = 'Transferă elemente selectate la';
$string['movingelement'] = 'Se transferă {$a}';
$string['multfactor'] = 'Multiplicator';
$string['multfactor_help'] = 'Multiplicatorul este factorul la care vor fi înmulțite toate notele pentru acest element de notat, rezultând o valoare maximă echivalentă cu nota maximă disponibilă. De exemplu, dacă multiplicatorul este 2, iar nota maximă este 10,  toate notele mai mici de 5 vor fi înmulţite cu 2, şi toate notele mai mari de 5 sunt modificate la 10.';
$string['multfactorvalue'] = 'Valoarea multiplicatorului pentru {$a}';
$string['mustchooserescaleyesorno'] = 'Trebuie să alegeți dacă doriți să rescalați sau nu notele existente';
$string['mygrades'] = 'Link-ul notelor pentru meniul utilizatorului';
$string['mygrades_desc'] = 'Această setare pemite o opțiune de a crea link către un catalog extern din meniul utilizatorului.';
$string['mypreferences'] = 'Preferinţele mele';
$string['myreportpreferences'] = 'Preferinţele mele pentru rapoarte';
$string['myself'] = 'Eu';
$string['navmethod'] = 'Metodă navigare';
$string['neverdeletehistory'] = 'Istoricul nu se şterge niciodată';
$string['newcategory'] = 'Categorie nouă';
$string['newitem'] = 'Element notă nou';
$string['newoutcomeitem'] = 'Un nou element rezultat';
$string['no'] = 'Nu';
$string['nocategories'] = 'Ctaegoriile de note nu au putut fi adăugate sau găsite în acest curs';
$string['nocategoryname'] = 'Nu a fost atribuit niciun nume de categorie.';
$string['nocategoryview'] = 'Nicio categorie pentru a vizualizată prin';
$string['nocourses'] = 'Nu există cursuri';
$string['noexistingoutcomes'] = 'Nu există rezultate.';
$string['noexistingscales'] = 'Nu există scale.';
$string['noforce'] = 'Nu obligați';
$string['nogradeletters'] = 'Nu au fost stabilite literele pentru notare';
$string['nogradesreturned'] = 'Nu au fost returnate note';
$string['noidnumber'] = 'Nu există nr. id';
$string['nolettergrade'] = 'Nu există notă sub formă de literă pentru';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Valoare non-numerică returnată pentru';
$string['nonunlockableverbose'] = 'Pentru a debloca această notă, trebuie să deblocați {$a->itemname}.';
$string['nonweightedpct'] = 'neponderat %';
$string['nooutcome'] = 'fără rezultat';
$string['nooutcomes'] = 'Elementele de rezultate trebuie să fie corelate cu rezultatul cursului (outcome), dar nu există rezultate pentru acest curs. Doriți să adăugați unul?';
$string['nopermissiontoresetweights'] = 'Nu aveți permisiunea de a reseta ponderea';
$string['nopublish'] = 'Nu publica';
$string['noreports'] = 'Nu sunteți înregistrat și nu predați cursuri pe acest site.';
$string['norolesdefined'] = 'Nu există roluri definite în Administration > Grades > General settings > Graded roles';
$string['noscales'] = 'Rezultatele trebuie să fie legate de o scală de curs sau de o scală globală, dar nu există. Doriți să adăugați o scală?';
$string['noselectedcategories'] = 'nu a fost selectată nicio categorie';
$string['noselecteditems'] = 'nu a fost selectat niciun element';
$string['notenrolled'] = 'În prezent nu sunteți înregistrat la niciun curs.';
$string['notteachererror'] = 'Pentru a putea utiliza această funcţionalitate trebuie să fiţi profesor';
$string['nousersloaded'] = 'Nu sunt utilizatori';
$string['nouserstograde'] = 'Nu sunt utilizatori care trebuie notați';
$string['numberofgrades'] = 'Număr de note';
$string['onascaleof'] = 'pe o scară de la {$a->grademin} la {$a->grademax}';
$string['operations'] = 'Operaţiuni';
$string['options'] = 'Opţiuni';
$string['others'] = 'Alții';
$string['otheruser'] = 'Utilizator';
$string['outcome'] = 'Rezultat';
$string['outcome_help'] = 'Această setare determină rezultatul pe care îl va reprezenta acest element, în catalog.';
$string['outcomeassigntocourse'] = 'Alocă alt rezultat acestui curs';
$string['outcomecategory'] = 'Creează rezultate în categorie';
$string['outcomecategorynew'] = 'Categorie nouă';
$string['outcomeconfirmdelete'] = 'Sunteți sigur(ă) că doriți să ștergeți acest rezultat "{$a}"?';
$string['outcomecreate'] = 'Adaugă un nou rezultat';
$string['outcomedelete'] = 'Șterge rezultat';
$string['outcomefullname'] = 'Nume complet';
$string['outcomeitem'] = 'Element rezultat';
$string['outcomeitemsedit'] = 'Editați itemul rezultat';
$string['outcomereport'] = 'Raport rezultate';
$string['outcomes'] = 'Rezultat';
$string['outcomescourse'] = 'Rezultate folosite în curs';
$string['outcomescoursecustom'] = 'Particularizat (fără a fi mutat )';
$string['outcomescoursenotused'] = 'Nu este utilizat în mod standard';
$string['outcomescourseused'] = 'Utilizat în mod standard (fără a fi mutat)';
$string['outcomescustom'] = 'Rezultate particularizate';
$string['outcomesdisabled'] = 'Rezultatele nu sunt activate';
$string['outcomeshortname'] = 'Nume prescurtat';
$string['outcomesstandard'] = 'Rezultate standard';
$string['outcomesstandardavailable'] = 'Rezultate standard disponibile';
$string['outcomestandard'] = 'Rezultate standard';
$string['outcomestandard_help'] = 'Se alege rezultatul tip standard care este disponibil pe tot site-ul, pentru toate cursurile.';
$string['overallaverage'] = 'Medie generală';
$string['overridden'] = 'Suprascris';
$string['overridden_help'] = 'Dacă se bifează, nota nu mai poate fi schimbată din cadrul activităților asociate.

Când o notă este editată în raportul notelor, căsuța suprascrisă se bifează automat. Cu toate acestea, poate fi de-bifată pentru a permite modificarea notei prin intermediul activităților asociate.';
$string['overriddennotice'] = 'Nota finală obţinută de dumneavoastră pentru această activitate a fost ajustată manual.';
$string['overridecat'] = 'Categoriile de note pot fi suprascrise în mod individual';
$string['overridecat_help'] = 'Dacă dezactivați  această setare, utilizatorii nu vor mai putea să suprascrie categoriile de note.';
$string['overridesitedefaultgradedisplaytype'] = 'Suprascrieți setările implicite ale site-ului';
$string['overridesitedefaultgradedisplaytype_help'] = 'Dacă se bifează, pot fi stabilite calificative și valori noi pentru notele din curs, dacă nu se dorește folosirea valorilor standard.';
$string['overrideweightofa'] = 'Suprascrieți ponderea lui {$a}';
$string['parentcategory'] = 'Categorie părinte';
$string['pass'] = 'Admis';
$string['pctoftotalgrade'] = '% din nota totală';
$string['percent'] = 'Procent';
$string['percentage'] = 'Procentaj';
$string['percentageletter'] = 'Procentaj (literă)';
$string['percentagereal'] = 'Procentaj (real)';
$string['percentascending'] = 'Sortează procentaje crescător';
$string['percentdescending'] = 'Sortează procentaje descrescător';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Offset';
$string['plusfactor_help'] = 'Pragul este un număr care se adaugă la fiecare notă pentru acest element, după ce este aplicat multiplicatorul.';
$string['plusfactorvalue'] = 'Valoare offset a {$a}';
$string['points'] = 'puncte';
$string['pointsascending'] = 'Sortează după puncte crescător';
$string['pointsdescending'] = 'Sortează după puncte descrescător';
$string['positionfirst'] = 'Primul';
$string['positionlast'] = 'Ultimul';
$string['preferences'] = 'Preferinţe';
$string['prefgeneral'] = 'General';
$string['prefletters'] = 'Note sub formă de litere și conexiuni';
$string['prefrows'] = 'Rânduri speciale';
$string['prefshow'] = 'Afișați / Ascundeți';
$string['previewrows'] = 'Previzualizează rânduri';
$string['privacy:metadata:categorieshistory'] = 'O înregistrare a versiunilor anterioare ale categoriilor de note';
$string['privacy:metadata:filepurpose'] = 'Fișiere de feedback stocate în carnetul de note al unui utilizator.';
$string['privacy:metadata:grade_import_newitem'] = 'Tabel temporar pentru stocarea noilor nume ale elementelor de notă din importul de note';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Un cod de lot unic pentru identificarea unui lot de importuri';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Utilizatorul care importă note';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Numele noului element de notă';
$string['privacy:metadata:grade_import_values'] = 'Tabel temporar pentru importul notelor';
$string['privacy:metadata:grade_import_values:feedback'] = 'Feedback notă';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Valoarea notei';
$string['privacy:metadata:grade_import_values:importcode'] = 'Un cod de lot unic pentru identificarea unui lot de importuri';
$string['privacy:metadata:grade_import_values:importer'] = 'Utilizatorul care importă notele';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Marcați dacă a fost importat doar feedback-ul';
$string['privacy:metadata:grade_import_values:userid'] = 'Utilizator a cărui notă a fost importată';
$string['privacy:metadata:grades'] = 'Un lot de note';
$string['privacy:metadata:grades:aggregationstatus'] = 'Starea agregării';
$string['privacy:metadata:grades:aggregationweight'] = 'Agregarea ponderilor';
$string['privacy:metadata:grades:feedback'] = 'Feedback-ul';
$string['privacy:metadata:grades:finalgrade'] = 'Nota';
$string['privacy:metadata:grades:information'] = 'Informații suplimentare despre notă';
$string['privacy:metadata:grades:timemodified'] = 'Ora la care a fost modificată ultima dată nota';
$string['privacy:metadata:grades:userid'] = 'ID-ul utilizatorului a cărui notă este';
$string['privacy:metadata:grades:usermodified'] = 'ID-ul utilizatorului care a modificat ultima dată înregistrarea';
$string['privacy:metadata:gradeshistory'] = 'Lista notelor anteriore';
$string['privacy:metadata:history:loggeduser'] = 'ID-ul utilizatorului care a fost conectat când a avut loc modificarea notei';
$string['privacy:metadata:history:timemodified'] = 'Momentul în care a avut loc modificarea notei';
$string['privacy:metadata:itemshistory'] = 'O înregistrare a versiunilor anterioare ale elementelor de notare';
$string['privacy:metadata:outcomes'] = 'O listă de rezultate';
$string['privacy:metadata:outcomes:timemodified'] = 'Ora când a fost modificată înregistrarea';
$string['privacy:metadata:outcomes:usermodified'] = 'Utilizatorul care a modificat ultima dată înregistrarea';
$string['privacy:metadata:outcomeshistory'] = 'O înregistrare a versiunilor anterioare ale rezultatelor';
$string['privacy:metadata:scale'] = 'O înregistrare a scalelor';
$string['privacy:metadata:scale:timemodified'] = 'Ora când ultima înregistrare a fost modificată';
$string['privacy:metadata:scale:userid'] = 'Utilizatorul care a modificat ultima dată înregistrarea';
$string['privacy:metadata:scalehistory'] = 'O înregistrare a versiunilor anterioare ale scalei';
$string['privacy:path:relatedtome'] = 'Legat de mine';
$string['privacy:request:historyactiondelete'] = 'Stergere';
$string['privacy:request:historyactioninsert'] = 'Inserare';
$string['privacy:request:historyactionupdate'] = 'Actualizare';
$string['privacy:request:unknowndeletedgradeitem'] = 'Necunoscut (elementul de notă a fost șters)';
$string['profilereport'] = 'Raport profil utilizator';
$string['profilereport_help'] = 'Raportul notelor folosit pe pagina de profil a utilizatorului.';
$string['publishing'] = 'Publicare';
$string['publishingoptions'] = 'Opțiuni de publicare a notelor';
$string['quickfeedback'] = 'Feedback rapid';
$string['quickgrading'] = 'Notare rapidă';
$string['quickgrading_help'] = 'Dacă se activează opțiunea, atunci când este activat modul de editare, o casetă de introducere a textului apare pentru fiecare notă, astfel mai multe note vor putea fi editate în acelaşi timp. Modificările vor fi salvate şi evidențiate cu o culoare diferită atunci când se face click pe butonul de actualizare.

Reţineţi că atunci când o notă este editată în raportul notelor, în dreptul ei va apărea un steguleț suprascris, semnalizând că nota nu mai poate fi schimbată din cadrul activității asociate.';
$string['range'] = 'Interval';
$string['rangedecimals'] = 'Intervalul punctelor zecimale';
$string['rangedecimals_help'] = 'Numărul de zecimale de afișat pentru interval.';
$string['rangesdecimalpoints'] = 'Zecimale afișate în intervale';
$string['rangesdecimalpoints_help'] = 'Această setare determină numărul de zecimale de afișat pentru fiecare interval sau dacă este utilizată setarea zecimalelor generale pentru categoria sau elementul de notare (moștenit).';
$string['rangesdisplaytype'] = 'Mod afişare interval';
$string['rangesdisplaytype_help'] = 'Această setare determină dacă intervalul este afişat ca note reale, procente sau litere, sau dacă se va folosi tipul de afişare pre-setat pentru categoria sau elementul notat (transpunere)';
$string['rank'] = 'Rang';
$string['rawpct'] = 'Brut %';
$string['real'] = 'Real';
$string['realletter'] = 'Real (literă)';
$string['realpercentage'] = 'Real (procentaj)';
$string['recalculatinggrades'] = 'Se recalculează notele';
$string['recovergradesdefault'] = 'Recuperați notele implicite';
$string['recovergradesdefault_help'] = 'În mod implicit, recuperați notele vechi la reînscrierea unui utilizator la un curs.';
$string['refreshpreview'] = 'Actualizați previzualizarea';
$string['regradeanyway'] = 'Notează din nou oricum';
$string['removeallcoursegrades'] = 'Şterge toate notele';
$string['removeallcoursegrades_help'] = 'Dacă este bifat, toate elementele de notare care au fost adăugate manual în catalog vor fi șterse, împreună cu notele și datele privind notele suprascrise, excluse, ascunse și blocate. Vor rămâne doar elementele clasificate asociate activităților.';
$string['removeallcourseitems'] = 'Şterge toate elementele şi categoriile';
$string['removeallcourseitems_help'] = 'Dacă este bifat, toate categoriile și elementele de notare care au fost adăugate manual în registrul de note vor fi șterse, împreună cu notele și datele privind notele suprascrise, excluse, ascunse și blocate. Vor rămâne doar elementele de notare asociate activităților.';
$string['report'] = 'Raport';
$string['reportdefault'] = 'Raport implicit ({$a})';
$string['reportplugins'] = 'Plugin-uri rapoarte';
$string['reportsettings'] = 'Setări rapoarte';
$string['reprintheaders'] = 'Arată din nou antetele';
$string['resetweights'] = 'Resetați ponderile {$a->itemname}';
$string['resetweightsshort'] = 'Resetați ponderile';
$string['respectingcurrentdata'] = 'configuraţia curentă rămâne neschimbată';
$string['rowpreviewnum'] = 'Previzualizare rânduri';
$string['rowpreviewnum_help'] = 'Datele pentru import pot fi previzualizate înainte de confirmarea importului. Această setare determină câte rânduri sunt afișate în previzualizare.';
$string['savechanges'] = 'Salvează modificări';
$string['savepreferences'] = 'Salvează preferinţe';
$string['scaleconfirmdelete'] = 'Sunteți sigur(ă) că doriți să ștergeți scala "{$a}"?';
$string['scaledpct'] = 'Scalat %';
$string['searchgroups'] = 'Caută grupuri';
$string['searchusers'] = 'Caută utilizatori';
$string['seeallcoursegrades'] = 'Afişează toate notele la curs';
$string['select'] = 'Selectează {$a}';
$string['selectalloroneuser'] = 'Selectare toţi sau un singur utilizator';
$string['selectauser'] = 'Selectaţi un utilizator';
$string['selectdestination'] = 'Selectaţi destinaţia pentru {$a}';
$string['selectgrouplink'] = 'Selectează un grup';
$string['selectuserlink'] = 'Selectează un utilizator';
$string['separator'] = 'Separator';
$string['separator_help'] = 'Selectați separatorul utilizat în fișierul CSV. (În mod normal este o virgulă)';
$string['sepcolon'] = 'Două puncte';
$string['sepcomma'] = 'Virgulă';
$string['sepsemicolon'] = 'Punct și virgulă';
$string['septab'] = 'Paragraf nou';
$string['setcategories'] = 'Stabilire categorii';
$string['setcategorieserror'] = 'Înainte de a putea stabili ponderi pentru fiecare categorie din cadrul cursului va trebui mai întâi să le definiţi.';
$string['setgradeletters'] = 'Stabilire litere notare';
$string['setpreferences'] = 'Stabilire preferinţe';
$string['setting'] = 'Setare';
$string['settings'] = 'Setări';
$string['setup'] = 'Setup';
$string['setweights'] = 'Stabilire ponderi';
$string['showactivityicons'] = 'Afişare icon-uri activitate';
$string['showactivityicons_help'] = 'Afişează imagine activitate alături de numele activității';
$string['showallgrades'] = 'Afișează toate notele';
$string['showallhidden'] = 'Arată elementele ascunse';
$string['showallstudents'] = 'Afişează toţi cursanţii';
$string['showanalysisicon'] = 'Afișați pictograma de analiză a notelor';
$string['showanalysisicon_desc'] = 'Dacă se afișează în mod implicit pictograma de analiză a notelor. Dacă modulul de activitate îl acceptă, pictograma de analiză a notelor se leagă de o pagină cu explicații mai detaliate despre notă și modul în care a fost obținută.';
$string['showanalysisicon_help'] = 'Dacă modulul de activitate îl acceptă, pictograma de analiză a notelor se leagă de o pagină cu explicații mai detaliate despre notă și modul în care a fost obținută.';
$string['showaverage'] = 'Afișează media';
$string['showaverage_help'] = 'Dacă se afișează o coloană medie. Rețineți că participanții vor putea să estimeze notele altora dacă media este calculată dintr-un număr mic de note. Din motive de performanță, media este aproximativă dacă depinde de orice element ascuns.';
$string['showaverages'] = 'Afișează mediile coloanei';
$string['showaverages_help'] = 'Dacă se activează, raportul notelor va conţine un rând suplimentar ce afişează media aritmetică pentru fiecare categorie şi element.';
$string['showcalculations'] = 'Afişează calcule';
$string['showcalculations_help'] = 'Dacă este activat, la editare, este afișată o pictogramă de calculator pentru fiecare element de notă și categorie, cu un indicator vizual că este calculat un element de notă.';
$string['showcontributiontocoursetotal'] = 'Afișează contribuția la cursul total';
$string['showcontributiontocoursetotal_help'] = 'Dacă se afișează o coloană de procente care indică cât contribuie fiecare element de calificare la procentul total al cursului utilizatorului (după aplicarea ponderării).';
$string['showeyecons'] = 'Afișează/Ascunde pictograme';
$string['showeyecons_help'] = 'Dacă se activează opțiunea, atunci când este activat modul de editare, o pictogramă arată/ascunde este afișată în dreptul fiecărei note. Astfel puteți controla vizibilitatea notei pentru cursant. ';
$string['showfeedback'] = 'Afişează feedback';
$string['showfeedback_help'] = 'Afișează coloana cu feedback?';
$string['showgrade'] = 'Afișează note';
$string['showgrade_help'] = 'Afișați coloana cu note?';
$string['showgroups'] = 'Afişează grupuri';
$string['showhiddenitems'] = 'Afişează elemente ascunse';
$string['showhiddenitems_help'] = 'Această setare determină dacă elementele de notare ascunse sunt vizibile de către cursanți.

* Arată pe cele ascunse - Denumirea elementelor de notare ascunse este afișată însă notele rămân ascunse
* Ascunse până la un moment dat - Elementele de notare care au o dată specificată în setarea "ascunde până la" sunt ascunse complet până la data stabilită, după care se va afișa întreg elementul
* Nu afişaţi - elementelele de notare ascunse rămân ascunse';
$string['showhiddenuntilonly'] = 'Ascuns doar până la';
$string['showingaggregatesonly'] = 'Se afișează doar agregatele';
$string['showingfullmode'] = 'Se afișează imaginea completă';
$string['showinggradesonly'] = 'Se afișează doar notele';
$string['showlettergrade'] = 'Afișați notele sub formă de litere';
$string['showlettergrade_help'] = 'Afișează coloane cu notele sub formă de litere?';
$string['showlocks'] = 'Arată elemente blocate';
$string['showlocks_help'] = 'Dacă se activează opțiunea, atunci când este activat modul de editare, o pictogramă blocare/deblocare va fi afișată pentru fiecare notă. Astfel se poate controla dacă nota se poate actualiza automat de către activitatea respectivă.  ';
$string['shownohidden'] = 'Nu afișa';
$string['shownooutcomes'] = 'Ascunde rezultate';
$string['shownumberofgrades'] = 'Afișează numărul de note în medii';
$string['shownumberofgrades_help'] = 'Dacă se activează opțiunea, numărul de note folosite la calcularea mediei aritmetice va fi afişat în paranteze după fiecare medie.';
$string['showonlyactiveenrol'] = 'Afișează doar înrolările active';
$string['showonlyactiveenrol_help'] = 'Această setare determină dacă doar utilizatorii activi inscriși vor fi vizibili în raportul din catalog. Dacă este dezactivată, utilizatorii suspendați nu vor fi afișați în catalog.';
$string['showpercentage'] = 'Afişează procentaj';
$string['showpercentage_help'] = 'Această setare determină dacă să se afișeze valoarea procentuală a fiecărui element al notei.';
$string['showquickfeedback'] = 'Afişează Feedback Rapid';
$string['showquickfeedback_help'] = 'Dacă se activează opțiunea, atunci când este activat modul de editare, va apărea o casetă de introducere a textului feedback cu o margine punctată în dreptul fiecărei note. Astfel este permisă adăugarea de comentarii pentru multiple note în același timp. Modificările vor fi salvate şi evidențiate atunci când se face click pe butonul de actualizare.

Reţineţi că atunci când feedback-ul este editat în raportul notelor, un steguleț de suprascriere este afișat, semnalizând faptul că feedback-ul nu mai poate fi schimbat din cadrul activității asociate.';
$string['showrange'] = 'Afișează intervalele';
$string['showrange_help'] = 'Afișează coloana pentru interval?';
$string['showranges'] = 'Afişează intervale';
$string['showranges_help'] = 'Dacă se activează opțiunea, raportul notelor va conţine un rând suplimentar care va afișa gama de note pentru fiecare categorie şi element al notei.';
$string['showrank'] = 'Afișează rang';
$string['showrank_help'] = 'Dacă se afișează poziția cursantului în raport cu restul clasei pentru fiecare element de notă.';
$string['showuserimage'] = 'Afişează imagini profil utilizatori';
$string['showuserimage_help'] = 'Afișează sau nu imaginea profilului utilizatorului lângă nume, în raportul notelor.';
$string['showverbose'] = 'Afişează {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Afișează ponderările';
$string['showweight_help'] = 'Afișează coloana pentru ponderarea notelor?';
$string['simpleview'] = 'Afişare simplificată';
$string['singleview'] = 'Vizualizare unică pentru {$a}';
$string['sitewide'] = 'În tot situl';
$string['sort'] = 'sortare';
$string['sortasc'] = 'Sortare în ordine crescătoare';
$string['sortbyfirstname'] = 'Sortare după prenume';
$string['sortbylastname'] = 'Sortare după nume';
$string['sortdesc'] = 'Sortare în ordine descrescătoare';
$string['standarddeviation'] = 'Deviaţie standard';
$string['stats'] = 'Statistici';
$string['statslink'] = 'Statistici';
$string['student'] = 'Cursant';
$string['studentsperpage'] = 'Cursanţi pe pagină';
$string['studentsperpage_help'] = 'Această opţiune determină numărul de studenţi afişat pe pagină, în raportul notelor.';
$string['studentsperpagereduced'] = 'Numărul maxim de cursanți pe pagină este redus de la {$a->originalstudentsperpage} la {$a->studentsperpage}. Luați în considerare setarea PHP max_input_vars de la {$a->maxinputvars}.';
$string['subcategory'] = 'Categorie normală';
$string['submissions'] = 'Propuneri';
$string['submittedon'] = 'Trimis: {$a}';
$string['sumofgradesupgradedgrades'] = 'Notă: Metoda de agregare „Suma notelor” a fost schimbată în „Natural” ca parte a unei actualizări a site-ului. Deoarece „Suma notelor” a fost folosită anterior în acest curs, se recomandă să revizuiți această modificare în carnetul de note.';
$string['switchtofullview'] = 'Treci la afişare completă';
$string['switchtosimpleview'] = 'Treci la afişare simplificată';
$string['tabs'] = 'Tab-uri';
$string['topcategory'] = 'Super categorie';
$string['total'] = 'Total';
$string['totalweight100'] = 'Ponderea totală este egală cu';
$string['totalweightnot100'] = 'Ponderea totală nu este egală cu';
$string['turnfeedbackoff'] = 'Dezactivează feedback';
$string['turnfeedbackon'] = 'Activează feedback';
$string['typenone'] = 'Nici una';
$string['typescale'] = 'Scală';
$string['typescale_help'] = 'Această setare determină scala utilizată atunci când se utilizează sistemul de notare scalar. Scala pentru notele activităților se stabilește pe pagina Setări Activitate.';
$string['typetext'] = 'Text';
$string['typevalue'] = 'Valoare';
$string['uncategorised'] = 'Fără categorie';
$string['unchangedgrade'] = 'Notă neschimbată';
$string['unenrolledusersinimport'] = 'Această operaţiune de import include următoarele note pentru utilizatori care nu s-au înscris la acest curs: {$a}';
$string['unlimitedgrades'] = 'Note nelimitate';
$string['unlimitedgrades_help'] = 'În mod implicit, notele sunt limitate de valorile maxime și minime ale elementului de notă. Activarea acestei setări elimină această limită și permite introducerea notelor de peste 100% direct în carnetul de note.';
$string['unlock'] = 'Deblochează';
$string['unlockverbose'] = 'Deblochează {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Neutilizat';
$string['updatedgradesonly'] = 'Exportă doar note noi sau actualizate';
$string['upgradedgradeshidemessage'] = 'Închide notificarea';
$string['upgradedminmaxrevertmessage'] = 'Anulați modificările';
$string['uploadgrades'] = 'Încarcă note';
$string['useadvanced'] = 'Foloseşte funcţionalităţi avansate';
$string['usedcourses'] = 'Cursuri utilizate';
$string['usedgradeitem'] = 'Element notare utilizat';
$string['usenooutcome'] = 'Nu folosiți niciun rezultat';
$string['usenoscale'] = 'Nu folosi scală';
$string['usepercent'] = 'Foloseşte procentaj';
$string['user'] = 'Utilizator';
$string['userenrolmentsuspended'] = 'Înscrierea utilizatorilor este suspendată';
$string['userfields_show'] = 'Afișați câmpurile utilizatorului';
$string['userfields_show_help'] = 'Afișați câmpuri suplimentare de utilizator, cum ar fi adresa de e-mail în raportul de nivelare. Câmpurile specifice afișate sunt controlate de setarea site-ului showuseridentity';
$string['usergrade'] = 'Utilizator {$a->fullname} ({$a->useridnumber}) pe elementul {$a->gradeidnumber}';
$string['userid'] = 'ID utilizator';
$string['useridnumberwarning'] = 'Utilizatorii fără număr de ID sunt excluși din export, deoarece nu pot fi importați';
$string['usermappingerror'] = 'Eroare la maparea studentului. Nu s-a putut găsi utilizatorul cu {$a->field} din "{$a->value}".';
$string['usermappingerrorcurrentgroup'] = 'Utilizatorul nu este membru al grupului actual';
$string['usermappingerrormultipleusersfound'] = 'Eroare de mapare a utilizatorilor: s-au găsit mai mulți utilizatori cu {$a->field} of "{$a->value}". Vă rugăm să utilizați un câmp de cartografiere unic.';
$string['usermappingerrorusernotfound'] = 'Eroare la mapare. Nu s-a găsit utilizatorul.';
$string['userpreferences'] = 'Preferinţe utilizator';
$string['useweighted'] = 'Utilizați ponderi';
$string['verbosescales'] = 'Scale Verbose';
$string['verbosescales_help'] = 'O scală verbose folosește cuvinte, nu numere. Setați \'Da\' dacă ambele scale, numerică și verbose, urmează să fie importate. Setați "Nu" în cazul în care doar scala numerică urmează să fie importată.';
$string['viewas'] = 'Vizualizare raport ca';
$string['viewbygroup'] = 'Grup';
$string['viewgrades'] = 'Afişează note';
$string['weight'] = 'Pondere';
$string['weight_help'] = 'O valoare utilizată pentru a determina valoarea relativă a mai multor elemente de notare într-o categorie sau într-un curs.';
$string['weightcourse'] = 'Foloseşte note ponderate în cadrul cursului';
$string['weightedascending'] = 'Sortare în ordine crescătoare în funcţie de procentajul ponderat';
$string['weighteddescending'] = 'Sortare în ordine descrescătoare în funcţie de procentajul ponderat';
$string['weightedpct'] = 'ponderat %';
$string['weightedpctcontribution'] = '% ponderat contribuţie';
$string['weightofa'] = 'Pondere a {$a}';
$string['weightorextracredit'] = 'Pondere sau extra credit';
$string['weightoverride'] = 'ajustare pondere';
$string['weightoverride_help'] = 'Debifați această opțiune pentru a reseta ponderea elementului de notă la valoarea calculată automat. Dacă este bifat va împiedica ajustarea automată a ponderii.';
$string['weights'] = 'Ponderi';
$string['weightsadjusted'] = 'Ponderile dumneavoastră au fost ajustate la totalul de 100.';
$string['weightsedit'] = 'Editare ponderi și extra credite';
$string['weightuc'] = 'Pondere calculată.';
$string['writinggradebookinfo'] = 'Setări catalog';
$string['xml'] = 'XML';
$string['yes'] = 'Da';
$string['yourgrade'] = 'Nota dumneavoastră';
