<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_kopere_bi', language 'pt_br', version '4.1'.
 *
 * @package     local_kopere_bi
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['active_enrolments'] = 'Matrículas Ativas';
$string['all_learners'] = 'Todos os estudantes';
$string['area_desc'] = 'Gera um gráfico de área';
$string['area_name'] = 'Gráfico de Área';
$string['block_add'] = 'Adicionar novo Bloco';
$string['block_delete_message'] = 'Você realmente deseja excluir este bloco e <br> seus relatórios permanentemente?';
$string['block_delete_title'] = 'Excluir Bloco';
$string['block_extra'] = 'Opções avançadas de gráfico';
$string['block_not_found'] = 'Bloco não encontrado';
$string['block_theme'] = 'Tema do bloco';
$string['block_theme_blue'] = 'Tema Azul';
$string['block_theme_dark'] = 'Tema Escuro';
$string['block_theme_green'] = 'Tema Verde';
$string['block_theme_light'] = 'Tema Claro (padrão)';
$string['block_theme_orange'] = 'Tema Laranja';
$string['block_theme_pink'] = 'Tema Rosa';
$string['blocktype_not_found'] = 'Tipo de bloco não encontrado';
$string['c_enablecompletion'] = 'Conclusão ativada';
$string['c_format'] = 'Formato do Curso';
$string['c_fullname'] = 'Nome completo do curso';
$string['c_id'] = 'ID do Curso';
$string['c_shortname'] = 'Nome curto';
$string['c_tempo'] = 'Tempo gasto';
$string['c_timemodified'] = 'Modificado em';
$string['c_visible'] = 'Visível';
$string['ca_completed_activities'] = 'Atividades concluídas';
$string['cache_time'] = 'Tempo de cache';
$string['cache_time_15min'] = '15 minutos';
$string['cache_time_1d'] = '24 horas';
$string['cache_time_1h'] = '1 hora';
$string['cache_time_30min'] = '30 minutos';
$string['cache_time_6h'] = '6 horas';
$string['cache_time_desc'] = 'Tempo que os resultados do SQL devem permanecer em cache antes de serem limpos';
$string['cache_time_no'] = 'Sem cache';
$string['cachedef_block_chart_data_15m'] = 'Cache de dados do gráfico por 15 minutos';
$string['cachedef_block_chart_data_1d'] = 'Cache de dados do gráfico por 1 dia';
$string['cachedef_block_chart_data_1h'] = 'Cache de dados do gráfico por 1 hora';
$string['cachedef_block_chart_data_30m'] = 'Cache de dados do gráfico por 30 minutos';
$string['cachedef_block_chart_data_6h'] = 'Cache de dados do gráfico por 6 horas';
$string['cachedef_block_chart_data_none'] = 'Cache de dados do gráfico sem dados';
$string['cachedef_ip_user_location'] = 'Cache de localização do usuário por IP';
$string['cachedef_mustache_nosql'] = 'Cache de dados Mustache para NoSQL';
$string['cachedef_mustache_sql'] = 'Cache de dados Mustache para SQL';
$string['case_complete'] = 'Completo';
$string['case_incomplete'] = 'Incompleto';
$string['case_never_accessed'] = 'Nunca acessado';
$string['cat_description'] = 'Descrição da categoria';
$string['cat_edit'] = 'Editar';
$string['cat_name'] = 'Nome da categoria';
$string['cat_new'] = 'Nova categoria';
$string['cat_not_found'] = 'Categoria não encontrada';
$string['cat_title'] = 'Categoria';
$string['category_delete_confirm'] = 'Exclusão de Categoria';
$string['category_delete_message'] = 'Você realmente deseja excluir a categoria <strong>{$a}</strong> e todas as páginas e blocos?';
$string['cc_id'] = 'Cursos concluídos';
$string['cc_timecompleted'] = 'Concluído em';
$string['chart_area_default'] = 'Configuração padrão do Gráfico de Área';
$string['chart_column_default'] = 'Configuração padrão do Gráfico de Colunas';
$string['chart_default_desc'] = 'Alterar este valor não afetará nenhum gráfico existente<br>Edite apenas se estiver familiarizado com Apex Charts. Veja mais em <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs</a>';
$string['chart_line_default'] = 'Configuração padrão do Gráfico de Linhas';
$string['chart_pie_default'] = 'Configuração padrão do Gráfico de Pizza';
$string['city_name'] = 'Cidade';
$string['class_not_found'] = 'Turma não encontrada';
$string['click_new_block'] = 'Clique no tipo de Bloco que deseja adicionar.';
$string['client_name'] = 'Navegador';
$string['client_version'] = 'Versão';
$string['cm_cmid'] = 'ID do Módulo do Curso';
$string['column_desc'] = 'Gera um Gráfico de Colunas';
$string['column_name'] = 'Gráfico de Colunas';
$string['completed_learners'] = 'Estudantes que concluíram os cursos';
$string['completion_status'] = 'Rastreamento';
$string['completionstate_status'] = 'Conclusão';
$string['country_name'] = 'País';
$string['course_completed'] = 'Porcentagem de conclusão';
$string['create'] = 'Criar';
$string['create_report'] = 'Criar relatório';
$string['css_extra'] = 'CSS extra';
$string['css_extra_desc'] = 'Adicione estilos CSS ou SCSS a este bloco.<br> O CSS adicionado será aplicado apenas ao conteúdo deste Bloco e não afetará nenhuma outra parte do Moodle';
$string['ctx_instanceid'] = 'Cursos matriculados';
$string['data_not_found'] = 'Nenhum dado encontrado';
$string['delete_report_text'] = 'Você realmente deseja excluir este relatório?';
$string['delete_report_title'] = 'Excluir relatório';
$string['e_enrol'] = 'Tipo de matrícula';
$string['edit_report'] = 'Editar relatório';
$string['enrol_status'] = 'Status da matrícula';
$string['enrol_timeend'] = 'Conclusão da matrícula';
$string['error_chart_renderer'] = 'Erro ao renderizar o gráfico';
$string['error_data_loader'] = 'Erro ao carregar os dados do gráfico';
$string['expired_enrolments'] = 'Matrículas expiradas';
$string['extra_langs_customs_title'] = 'Para auxiliá-lo com novas strings, deixei alguns campos em branco:';
$string['extra_langs_filter_component'] = 'Componente';
$string['extra_langs_header_identifier'] = 'Identificador';
$string['extra_langs_header_lang_key'] = 'Chave de substituição';
$string['extra_langs_header_string'] = 'Texto atual';
$string['extra_langs_title'] = 'Chaves que já existem:';
$string['extra_options'] = 'Opções avançadas do bloco';
$string['firstname'] = 'Nome do estudante';
$string['g_finalgrade'] = 'Nota final';
$string['grade'] = 'Nota';
$string['grade_course'] = 'Nota do curso';
$string['html_after'] = 'Texto adicional opcional (em Texto, HTML ou formato Mustache) exibido após o gráfico.';
$string['html_before'] = 'Texto adicional opcional (em Texto, HTML ou formato Mustache) exibido acima do gráfico';
$string['html_block'] = 'Bloco HTML com suporte a Mustache';
$string['html_block_desc'] = '<p>O HTML adicionado a este campo deve seguir o formato <strong>Mustache</strong>, permitindo a substituição dinâmica de dados em suas páginas. Use chaves duplas <code>{{ }}</code> para referenciar valores de colunas SQL diretamente no HTML, garantindo que os dados sejam corretamente inseridos.</p>
<blockquote>
    <p>Por exemplo, utilizando a seguinte consulta SQL:</p>
    <pre>SELECT firstname, lastname, email FROM mdl_user WHERE id = :userid</pre>
    <p>Você pode referenciar os valores retornados no seu HTML usando a seguinte sintaxe:</p>
    <pre>&amp;lt;p&amp;gt;E-mail: {{{email}}}&amp;lt;/p&amp;gt;
    &amp;lt;p&amp;gt;Nome completo: {{{firstname}}} {{{lastname}}}&amp;lt;/p&amp;gt;</pre>
</blockquote>
<blockquote>
    <p>Neste exemplo, quero exibir várias linhas de um resultado SQL, que retorna uma lista de usuários registrados com autenticação manual. O SQL usado para isso é:</p>
    <pre>SELECT firstname, lastname, email FROM mdl_user WHERE auth = "manual"</pre>
    <p>Para iterar sobre os resultados e exibir os dados em formato de tabela, utilizo o <code>{{#lines}}</code> no template para repetir o conteúdo para cada registro retornado. O template ficaria assim:</p>
    <pre>&amp;lt;table class="table table-bordered"&amp;gt;
    &amp;lt;tr&amp;gt;
        &amp;lt;th&amp;gt;E-mail&amp;lt;/th&amp;gt;
        &amp;lt;th&amp;gt;Nome completo&amp;lt;/th&amp;gt;
    &amp;lt;/tr&amp;gt;
    <strong>{{#lines}}</strong>
        &amp;lt;tr&amp;gt;
            &amp;lt;td&amp;gt;{{{email}}}&amp;lt;/td&amp;gt;
            &amp;lt;td&amp;gt;{{{firstname}}} {{{lastname}}}&amp;lt;/td&amp;gt;
        &amp;lt;/tr&amp;gt;
    <strong>{{/lines}}</strong>
&amp;lt;/table&amp;gt;</pre>
</blockquote>
<p>As chaves triplas <code>{{{ }}}</code> permitem que o valor seja inserido sem escapar o HTML, o que é útil para exibir conteúdo que pode conter tags HTML.</p>
<p>Para mais informações sobre o uso de templates Mustache no Moodle, consulte a documentação oficial: <a href="https://moodledev.io/docs/guides/templates" target="_blank">Guia de Templates do Moodle</a>.</p>';
$string['html_desc'] = 'Exibe um Bloco HTML com dados vindos do banco de dados';
$string['html_name'] = 'Bloco HTML';
$string['inactive_enrolments'] = 'Matrículas inativas';
$string['info_desc'] = 'Apenas informações. Ideal para exibir nome do estudante, status da matrícula, etc.';
$string['info_error_sql'] = 'Erro ao executar SQL';
$string['info_name'] = 'Linha de informação';
$string['info_sql_warning'] = 'Lembre-se de que o SQL abaixo deve retornar apenas uma linha com apenas uma coluna.';
$string['integracaoroot'] = 'Integrações';
$string['item_not_found'] = 'Item não encontrado';
$string['kopere_bi:manage'] = 'Gerenciar Business Intelligence';
$string['kopere_bi:view'] = 'Visualizar Business Intelligence';
$string['l_ip'] = 'IP';
$string['l_origin'] = 'Origem';
$string['l_timecreated'] = 'Criado em';
$string['line_desc'] = 'Gera um gráfico de linhas';
$string['line_name'] = 'Gráfico de linhas';
$string['line_sql_warning'] = '<p>Lembre-se de que o SQL abaixo deve retornar com a seguinte estrutura:</p>
<ul>
    <li>A primeira coluna deve conter o texto que será usado como nomes do eixo X.</li>
    <li>As outras colunas devem ser estruturadas da seguinte forma:
        <ul>
            <li>O nome da coluna será usado como nome da série. Você pode usar strings de tradução conforme explicado na
                <a href="?classname=bi-extra_langs&amp;method=index" target="_blank">página de strings</a>.</li>
            <li>O valor da coluna representará os dados da série no gráfico.</li>
        </ul>
    </li>
</ul>
<blockquote>No exemplo abaixo, a primeira coluna retorna o nome do curso, e a segunda coluna retorna o número de notícias para cada curso:
<pre>SELECT fullname,
       newsitems AS "Contagem de notícias do curso"
  FROM mdl_course</pre></blockquote>
<blockquote>No exemplo abaixo, além da primeira coluna ser o nome do curso, ele gera duas linhas adicionais no gráfico, com nomes de colunas traduzidos:
<pre>  SELECT c.fullname AS course_name,
         COUNT(cm.section) AS "lang::thiscourse::theme_rebel",
         COUNT(cm.module)  AS "lang::ca_completed_activities::local_kopere_bi"
    FROM mdl_course AS c
    JOIN mdl_course_modules AS cm ON c.id = cm.course
GROUP BY c.id</pre></blockquote>';
$string['loading'] = 'Carregando...';
$string['maps_1_city'] = '{a1} e mais uma cidade';
$string['maps_desc'] = 'Cria um mapa de estudantes online com base em seus IPs';
$string['maps_many_city'] = '{a1} e {a2} mais cidades';
$string['maps_name'] = 'Mapa de estudantes online';
$string['maps_online'] = '{a1} estudante online';
$string['maps_onlines'] = '{a1} estudantes online';
$string['maps_sql_warning'] = '<p>Lembre-se de que o SQL abaixo deve retornar apenas uma coluna, e essa coluna deve conter um IP válido.<br>Exemplo: o SQL <code>SELECT lastip FROM {user} WHERE lastaccess > UNIX_TIMESTAMP() - (10 * 60)</code> retorna todos os estudantes que acessaram o Moodle nos últimos 10 minutos</p>';
$string['module_count'] = 'Contagem de módulos';
$string['module_name'] = 'Nome do módulo';
$string['modulename'] = 'Business Intelligence';
$string['new_block'] = 'Novo bloco nesta página';
$string['new_block_1'] = 'Um bloco';
$string['new_block_12'] = 'Um mais dois blocos';
$string['new_block_2'] = 'Dois blocos';
$string['new_block_21'] = 'Dois mais um bloco';
$string['new_block_25'] = 'Um largo e um estreito';
$string['new_block_3'] = 'Três blocos';
$string['new_block_4'] = 'Quatro blocos';
$string['new_block_52'] = 'Um estreito e um largo';
$string['not_accessed_learners'] = 'Estudantes que não acessaram a plataforma';
$string['not_completed_learners'] = 'Estudantes que não concluíram cursos';
$string['num_activelearners'] = 'Número de estudantes ativos';
$string['num_completedlearners'] = 'Número de estudantes que concluíram cursos';
$string['num_courses'] = 'Número de cursos disponíveis';
$string['num_learners'] = 'Número total de estudantes';
$string['num_user'] = 'Número de estudantes';
$string['os_name'] = 'Sistema operacional';
$string['page_delete_confirm'] = 'Exclusão de Página';
$string['page_delete_message'] = 'Você realmente deseja excluir a página <strong>{$a}</strong> e todos os blocos?';
$string['page_description'] = 'Descrição da página';
$string['page_edit'] = 'Editar página';
$string['page_name'] = 'Nome da página';
$string['page_new_cat'] = 'Nova página';
$string['page_new_sequence'] = 'Arraste os blocos para alterar a ordem dos blocos.';
$string['page_not_found'] = 'Página não encontrada';
$string['page_preview'] = 'Pré-visualizar página';
$string['page_title_edit'] = 'Editar o título desta página';
$string['page_title_export'] = 'Exportar página';
$string['pie_desc'] = 'Cria um gráfico de pizza';
$string['pie_name'] = 'Gráfico de pizza';
$string['pie_sql_warning'] = '<p>A SQL abaixo deve retornar apenas duas colunas.</p><p>A primeira coluna será o nome da coluna, e a segunda coluna deve ser um valor numérico.</p>';
$string['pluginname'] = 'Business Intelligence';
$string['privacy:metadata:city_name'] = 'O nome da cidade de onde o usuário acessa.';
$string['privacy:metadata:client_name'] = 'O nome do cliente ou navegador usado pelo usuário.';
$string['privacy:metadata:client_type'] = 'O tipo de cliente, como navegador ou aplicativo.';
$string['privacy:metadata:client_version'] = 'A versão do cliente ou navegador.';
$string['privacy:metadata:country_code'] = 'O código do país de onde o usuário acessa.';
$string['privacy:metadata:country_name'] = 'O nome do país de onde o usuário acessa.';
$string['privacy:metadata:day'] = 'O dia do acesso.';
$string['privacy:metadata:lastip'] = 'O último endereço IP registrado do usuário.';
$string['privacy:metadata:latitude'] = 'A latitude da localização do usuário durante o acesso.';
$string['privacy:metadata:local_kopere_bi_online'] = 'Tabela que armazena informações sobre usuários atualmente online para análise.';
$string['privacy:metadata:local_kopere_bi_statistic'] = 'Tabela que armazena dados estatísticos para fins de análise.';
$string['privacy:metadata:longitude'] = 'A longitude da localização do usuário durante o acesso.';
$string['privacy:metadata:month'] = 'O mês do acesso.';
$string['privacy:metadata:os_name'] = 'O nome do sistema operacional usado pelo usuário.';
$string['privacy:metadata:os_version'] = 'A versão do sistema operacional usado pelo usuário.';
$string['privacy:metadata:seconds'] = 'Os segundos do horário de acesso.';
$string['privacy:metadata:user_id'] = 'O identificador único do usuário na plataforma.';
$string['privacy:metadata:userid'] = 'O identificador do usuário para registros específicos.';
$string['privacy:metadata:weekday'] = 'O dia da semana do acesso.';
$string['privacy:metadata:year'] = 'O ano do acesso.';
$string['reload_time'] = 'Recarregar dados a cada';
$string['reload_time_10m'] = '10 minutos';
$string['reload_time_1h'] = '1 hora';
$string['reload_time_1m'] = '1 minuto';
$string['reload_time_20m'] = '20 minutos';
$string['reload_time_2h'] = '2 horas';
$string['reload_time_30m'] = '30 minutos';
$string['reload_time_40m'] = '40 minutos';
$string['reload_time_50m'] = '50 minutos';
$string['reload_time_5m'] = '5 minutos';
$string['reload_time_desc'] = 'Recarregar dados a cada X minutos. Este valor deve ser maior que o valor do cache!';
$string['reload_time_none'] = 'Nunca';
$string['report_1_cat_description'] = 'Relatórios sobre o desempenho e progresso dos estudantes em seus cursos.';
$string['report_1_cat_title'] = 'Estudantes';
$string['report_1_categories'] = 'Categorias';
$string['report_1_description'] = 'Relatórios de status dos estudantes';
$string['report_1_modules'] = 'Módulos';
$string['report_1_title'] = 'Estudantes ativos';
$string['report_1_user_status'] = 'Status do estudante';
$string['report_1_user_summary'] = 'Resumo dos estudantes ativos';
$string['report_1_users'] = 'Estudantes';
$string['report_2_cat_description'] = 'Análises abrangentes de todos os cursos disponíveis, desempenho dos estudantes, progresso e desenvolvimento.';
$string['report_2_cat_title'] = 'Cursos';
$string['report_2_completion_progress'] = 'Percentual de progresso de conclusão';
$string['report_2_course_access_statistics'] = 'Estatísticas de acesso ao curso';
$string['report_2_course_analysis_participation_completion'] = 'Análise do curso: Participação e conclusão';
$string['report_2_course_progress'] = 'Progresso do curso';
$string['report_2_description'] = 'Relatório do curso';
$string['report_2_title'] = 'Cursos';
$string['report_2_total_engagement'] = 'Engajamento total por curso';
$string['report_3_cat_description'] = 'Relatório de todos online no Moodle';
$string['report_3_cat_title'] = 'Online';
$string['report_3_course_access_time'] = 'Tempo de acesso ao curso';
$string['report_3_course_last30days'] = 'Dados apenas dos últimos 30 dias';
$string['report_3_description'] = 'Mostra os estudantes online e as principais regiões';
$string['report_3_operating_systems'] = 'Sistemas operacionais com mais tempo de acesso';
$string['report_3_title'] = 'Estudantes online';
$string['report_3_top_browsers'] = 'Navegadores com mais tempo de acesso';
$string['report_3_top_country_access'] = 'Cidades/Países com mais tempo de acesso';
$string['report_3_users_online'] = 'Estudantes online';
$string['report_3_users_online_list'] = 'Lista de estudantes online';
$string['report_4_cat_description'] = 'Relatórios de matrícula abrangendo histórico, status atual e tendências de matrícula nos cursos.';
$string['report_4_cat_title'] = 'Matrículas';
$string['report_4_completion_0'] = 'Acompanhamento de conclusão desativado para esta atividade';
$string['report_4_completion_1'] = 'Acompanhamento manual de conclusão ativado para esta atividade';
$string['report_4_completion_2'] = 'Acompanhamento automático de conclusão ativado para esta atividade';
$string['report_4_completion_none'] = 'Conclusão desconhecida';
$string['report_4_completionstate_0'] = 'Atividade não concluída';
$string['report_4_completionstate_1'] = 'Atividade concluída, mas aprovação ou reprovação não especificada';
$string['report_4_completionstate_2'] = 'Atividade concluída com uma nota acima da exigida para aprovação';
$string['report_4_completionstate_3'] = 'Atividade concluída com uma nota abaixo da exigida para aprovação';
$string['report_4_completionstate_4'] = 'Falhou em um item oculto';
$string['report_4_completionstate_none'] = 'Conclusão desconhecida';
$string['report_4_coursesenrollmentstatus'] = 'Status de matrícula nos cursos';
$string['report_4_description'] = 'Relatórios de matrícula abrangendo histórico, status atual e tendências de matrícula nos cursos.';
$string['report_4_enrolpercourse'] = 'Matrículas por curso';
$string['report_4_title'] = 'Estatísticas';
$string['report_5_cat_description'] = 'Este relatório fornece uma visão geral dos principais métricos e informações do sistema, permitindo uma análise abrangente de seu desempenho e operação.';
$string['report_5_cat_title'] = 'Sistema';
$string['report_5_component'] = 'Componente';
$string['report_5_coursefilesizes'] = 'Arquivos do curso';
$string['report_5_coursefilesizes_title'] = 'Espaço ocupado por cada curso';
$string['report_5_description'] = 'O relatório geral oferece um resumo detalhado de todos os aspectos do sistema, incluindo dados de uso, desempenho e áreas para melhoria. Ideal para administradores e gerentes que buscam otimizar a eficiência do sistema.';
$string['report_5_filesize'] = 'Tamanho do arquivo';
$string['report_5_filesizes'] = 'Tamanhos dos arquivos';
$string['report_5_modulesdeleting'] = 'Exclusão de módulos';
$string['report_5_modulesfilesizes'] = 'Arquivos do módulo';
$string['report_5_numfiles'] = 'Número de arquivos';
$string['report_5_title'] = 'Geral';
$string['report_5_upload_title'] = 'Espaço ocupado por cada módulo';
$string['report_6_cat_description'] = 'Monitoramento e estatísticas de logins do sistema';
$string['report_6_cat_title'] = 'Relatórios de Login';
$string['report_6_login'] = 'Logins';
$string['report_6_login_report'] = 'Relatório de Login do Moodle';
$string['report_7_inactive'] = 'Matrículas Inativas';
$string['report_7_inactive_report'] = 'Relatório de Matrículas Inativas';
$string['report_7_users_not_accessed_course'] = 'Usuários registrados que não acessaram seus cursos';
$string['report_8_engagement'] = 'Engajamento';
$string['report_8_student_teacher_engagement'] = 'Relatório de Engajamento de Estudantes e Professores';
$string['report_8_teacher_access'] = 'Acesso de Professores';
$string['report_8_total_engagement_per_course'] = 'Engajamento Total por Curso';
$string['report_9_category_desc'] = 'Relatório sobre os módulos do curso';
$string['report_9_category_title'] = 'Módulos do Curso';
$string['report_9_report_1_name'] = 'Estatísticas do Módulo';
$string['report_dashboard_cat_title'] = 'Painel';
$string['report_dashboard_page_1_cursos'] = 'Cursos / Visíveis';
$string['report_dashboard_page_1_newusers'] = 'Novos usuários nos últimos 12 meses';
$string['report_dashboard_page_1_online'] = 'Online / Última hora';
$string['report_dashboard_page_1_title'] = 'Painel';
$string['report_dashboard_page_1_users'] = 'Usuários / Ativos';
$string['report_new'] = 'Novo relatório para "{$a}"';
$string['report_preview'] = 'Pré-visualizar relatório';
$string['report_save'] = 'Salvar & ir para configuração das colunas';
$string['report_title'] = 'Título do relatório';
$string['reports_selectcourse'] = 'Selecione o curso para gerar o relatório';
$string['reports_selectuser'] = 'Selecione o estudante para gerar o relatório';
$string['return_edit'] = '<< Voltar para editar';
$string['rolename'] = 'Nome da função';
$string['save'] = 'Salvar';
$string['seconds'] = 'Quanto tempo';
$string['select_report_select_type'] = 'Selecione o tipo de relatório';
$string['select_report_select_type_desc'] = 'Primeiro, escolha o tipo de relatório para este bloco';
$string['select_report_type'] = 'Tipo de relatório';
$string['select_report_type_desc'] = 'Você pode alternar entre os tipos "{$a->linha}", "{$a->área}" ou "{$a->coluna}"';
$string['setting_apex'] = 'Configurações do Apex Charts';
$string['setting_apex_desc'] = 'Edite apenas se você estiver familiarizado com o Apex Charts. Veja mais em <a target="_blank" href="https://apexcharts.com/docs/series/">apexcharts.com/docs</a>';
$string['sql_no_rows'] = 'O SQL retornou 0 linhas. Para configurar as colunas, a consulta SQL deve retornar pelo menos 1 linha.';
$string['sql_read_only'] = 'Todas as consultas SQL são protegidas por uma conexão somente leitura, e não é possível executar comandos INSERT/UPDATE/DELETE.';
$string['sql_replace_keys'] = '<h4>Chaves de substituição</h4>
<ul>
    <li><b>:userid</b> ID do Estudante para gerar o relatório.</li>
    <li><b>:courseid</b> ID do Curso para gerar o relatório.</li>
</ul>
<h4>Multi-idioma</h4>
<p>Para retornar colunas que serão traduzidas com base nos pacotes de idioma do Moodle, é necessário um formato específico que permita que as strings sejam processadas e localizadas corretamente. O formato correto é:</p>
<pre>lang::{identificador}::{componente}</pre>
<p>Onde:</p>
<ul>
    <li><b>{identificador}</b>: Representa o identificador da string, que será usado para buscar a tradução no pacote de idioma.</li>
    <li><b>{componente}</b>: Refere-se ao componente onde a string de idioma é definida e normalmente é o nome do plugin (ex: <code>mod_forum</code>, <code>local_kopere_dashboard</code>, <code>theme_degrade</code>).</li>
</ul>
<p><em>Exemplo: Se você precisar retornar uma string traduzida para o componente <code>mod_forum</code> com o identificador <code>postmessage</code>, o retorno deve ser estruturado da seguinte forma:</em></p>
<pre>SELECT "<b>lang::postmessage::mod_forum</b>" FROM mdl_forum</pre>
<p>Visite a <a href="?classname=bi-extra_langs&amp;method=index" target="_blank">página de strings</a> para ver todas as strings disponíveis.</p>';
$string['sql_replace_keys_mdl'] = '<h4>Prefixo do banco de dados</h4>
<p>Você pode sempre usar o prefixo <code>mdl_</code> mesmo que seu banco de dados use o prefixo <code>{$a}</code>.
        A inteligência de negócios tratará essa substituição.</p>';
$string['table_col_title'] = 'Título da coluna';
$string['table_column_not_configured'] = 'Colunas não configuradas nesta tabela';
$string['table_desc'] = 'Exibe uma tabela com paginação de dados.';
$string['table_edit_column'] = 'Coluna';
$string['table_first_5'] = 'Os primeiros cinco registros da consulta';
$string['table_info_topo'] = 'Primeiro, você verá uma pré-visualização dos resultados da pesquisa. Em seguida, uma série de colunas será apresentada para você nomear os títulos e definir o formato dos dados de cada coluna.';
$string['table_info_types'] = 'Agora você pode definir um nome para a coluna e depois especificar o formato desejado e se deseja alguma formatação extra com Mustache.
<ul>
    <li><strong>Sem formatação</strong>: Exibe o conteúdo exatamente como está ou aplica Mustache se você adicionar.</li>
    <li><strong>Não mostrar esta coluna</strong>: Oculta a coluna selecionada na visualização, mas os dados permanecem disponíveis para processamento com Mustache.</li>
    <ul><li>Mustache não disponível</li></ul>
    <li><strong>Números</strong>: Formata a coluna para exibir apenas valores numéricos, aplicando regras padrão de exibição de números, como separadores de milhar e decimal.</li>
    <ul><li>Mustache não disponível</li></ul>
    <li><strong>Converter coluna para nome completo "fullname()"</strong>: Executa a função <code>fullname()</code> para gerar o nome completo com base no idioma, que será armazenado nesta mesma coluna. Para isso funcionar, a coluna <code>lastname</code> é necessária e deve ser ocultada, se possível.</li>
    <li><strong>Converter ID do estudante para foto de perfil</strong>: Usa o ID desta coluna para criar a foto de perfil.</li>
    <li><strong>Campo binário para Visível/Invisível</strong>: Usa o valor binário para determinar a visibilidade, onde "0"/"falso" significa invisível e "1"/"verdadeiro" significa visível.</li>
    <li><strong>Campo binário para Ativo/Inativo</strong>: Usa o valor binário para determinar o status, onde "0"/"falso" significa Inativo e "1"/"verdadeiro" significa Ativo.</li>
    <li><strong>Campo "Hora" formatado como data</strong>: Converte o valor de tempo (timestamp) na coluna para uma data legível, exibindo apenas a data (dia/mês/ano).</li>
    <ul><li>Mustache não disponível</li></ul>
    <li><strong>Campo "Hora" formatado como data e hora</strong>: Exibe o valor de tempo (timestamp) na coluna como uma data completa, incluindo a hora (dia/mês/ano e horas:minutos).</li>
    <ul><li>Mustache não disponível</li></ul>
    <li><strong>Campo "Hora" formatado como hora</strong>: Formata o valor de tempo (timestamp) na coluna para exibir apenas a hora (horas:minutos), omitindo a data.</li>
    <ul><li>Mustache não disponível</li></ul>
</ul>';
$string['table_name'] = 'Tabela de dados';
$string['table_renderer_date'] = 'Campo "Hora" formatado como data';
$string['table_renderer_datetime'] = 'Campo "Hora" formatado como data e hora';
$string['table_renderer_filesize'] = 'Converte para tamanho de dados no disco';
$string['table_renderer_mustache'] = 'HTML da coluna
<a href="https://moodledev.io/docs/guides/templates" target="_blank">Mustache</a>';
$string['table_renderer_none'] = 'Não exibir esta coluna';
$string['table_renderer_number'] = 'Números';
$string['table_renderer_seconds'] = 'Campo "Hora" formatado como hora';
$string['table_renderer_status'] = 'Campo binário para Ativo/Inativo';
$string['table_renderer_title'] = 'Formatação da coluna';
$string['table_renderer_translate'] = 'Use get_string("identifier", "component") para traduzir a coluna';
$string['table_renderer_userfullname'] = 'Converta a coluna para o nome completo do estudante com a função "fullname()"';
$string['table_renderer_userphoto'] = 'Converte o ID do estudante para a foto de perfil';
$string['table_renderer_visible'] = 'Campo binário para Visível/Invisible';
$string['theme_palette_default'] = 'Paleta padrão';
$string['theme_palette_desc'] = 'Cores da paleta:';
$string['theme_palette_desc2'] = 'Veja todos os temas aqui';
$string['theme_palette_palette'] = 'Paleta {$a}';
$string['theme_palette_title'] = 'Paleta de cores';
$string['timecompleted'] = 'Matrícula concluída';
$string['title'] = 'Inteligência de Negócios';
$string['u_fullname'] = 'Nome completo do estudante';
$string['u_id'] = 'ID do estudante';
$string['u_idnumber'] = 'Número de identificação';
$string['ue_id'] = 'ID de matrícula';
$string['ue_status'] = 'Status da matrícula';
$string['ue_timecreated'] = 'Matrícula criada em';
$string['ue_timeend'] = 'Matrícula termina em';
$string['ul_timeaccess'] = 'Último acesso';
$string['unknown'] = 'Desconhecido';
$string['use_this_type'] = 'Use este tipo';
