<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'de', version '4.1'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'Zu erledigen';
$string['activityisscheduledfordeletion'] = 'Aktivitätslöschung läuft...';
$string['agedigitalconsentmapinvalidage'] = '\'{$a}\' ist kein gültiger Wert für das Alter.';
$string['agedigitalconsentmapinvalidcomma'] = '\'{$a}\' hat mehr oder weniger als ein Kommatrennzeichen.';
$string['agedigitalconsentmapinvalidcountry'] = '\'{$a}\' ist kein gültiger Wert für ein Land.';
$string['agedigitalconsentmapinvaliddefault'] = 'Es fehlt ein Standard- (*) Wert.';
$string['agelocationverificationdisabled'] = 'Die Überprüfung von Alter und Aufenthaltsort ist deaktiviert.';
$string['alreadyloggedin'] = 'Sie sind bereits als {$a} angemeldet. Sie müssen sich abmelden, bevor Sie sich mit anderen Daten wieder anmelden.';
$string['authnotexisting'] = 'Das Plugin zur Authorisierung existiert nicht.';
$string['backupcontainexternal'] = 'Diese Sicherungsdatei enthält externe Netzwerkverbindungen (MNET), die lokal nicht konfiguriert sind.';
$string['backuptablefail'] = 'Die Sicherungstabellen konnten nicht erstellt werden!';
$string['blockcannotconfig'] = 'Dieser Block erlaubt keine globale Konfiguration.';
$string['blockcannotinistantiate'] = 'Fehler beim Anlegen des Blocks';
$string['blockcannotread'] = 'Die Daten für die Block-ID {$a} konnten nicht gelesen werden.';
$string['blockdoesnotexist'] = 'Dieser Block existiert nicht.';
$string['blockdoesnotexistonpage'] = 'Der Block (id={$a->instanceid}) existiert nicht auf dieser Seite ({$a->url}).';
$string['blocknameconflict'] = 'Fehler: Der Block {$a->name} hat den gleichen Titel wie ein bereits existierender Block {$a->conflict}!';
$string['callbackrejectcomment'] = 'Modul verweigert das Hinzufügen dieses Kommentars';
$string['cannotaddcoursemodule'] = 'Das neue Kursmodul konnte nicht hinzugefügt werden.';
$string['cannotaddcoursemoduletosection'] = 'Das neue Kursmodul konnte im Abschnitt nicht hinzugefügt werden.';
$string['cannotaddmodule'] = 'Modul {$a} konnte nicht zur Modulliste hinzugefügt werden!';
$string['cannotaddnewmodule'] = 'Das neue Modul {$a} konnte nicht hinzugefügt werden.';
$string['cannotaddrss'] = 'Sie dürfen keine RSS Feeds hinzufügen.';
$string['cannotaddthisblocktype'] = 'Sie dürfen keinen Block \'{$a}\' zur Seite hinzufügen.';
$string['cannotassignrole'] = 'Die Rolle kann im Kurs nicht zugewiesen werden.';
$string['cannotassignrolehere'] = 'Sie dürfen die Rolle (id = {$a->roleid}) in diesem Kontext ({$a->context}) nicht zuweisen.';
$string['cannotassignselfasparent'] = 'Etwas kann nicht zu sich selbst als übergeordnete Ebene zugewiesen werden.';
$string['cannotcallscript'] = 'Das Skript kann in dieser Form nicht aufgerufen werden.';
$string['cannotcallusgetselecteduser'] = 'Sie können user_selector::get_selected_user nicht aufrufen, wenn die Mehrfachauswahl (multiselect) aktiviert ist.';
$string['cannotcreatebackupdir'] = 'Das Verzeichnis \'backupdata\' konnte nicht erstellt werden. Administrator/innen müssen die Zugriffsrechte korrigieren.';
$string['cannotcreatecategory'] = 'Kursbereich wurde nicht eingefügt.';
$string['cannotcreatedboninstall'] = '<p>Die Datenbank konnte nicht angelegt werden.</p><p>Die angegebene Datenbank existiert nicht und das genannten Nutzerkonto hat keine Rechte, die Datenbank neu anzulegen. Die Datenbank-Konfiguration muss überprüft werden.</p>';
$string['cannotcreategroup'] = 'Fehler beim Anlegen der Gruppe';
$string['cannotcreatelangbase'] = 'Fehler beim Anlegen des Verzeichnisses \'lang\'';
$string['cannotcreatelangdir'] = 'Das Verzeichnis \'lang\' wurde nicht angelegt.';
$string['cannotcreateorfindstructs'] = 'Fehler beim Suchen oder Anlegen der Kursabschnitte';
$string['cannotcreatepopupwin'] = 'Undefiniertes Element. Das Popup-Fenster konnte nicht erstellt werden';
$string['cannotcreatesitedir'] = 'Das Verzeichnis für die Website konnte nicht angelegt werden. Administrator/innen müssen die Dateirechte auf dem Server korrigieren.';
$string['cannotcreatetempdir'] = 'Das Verzeichnis \'temp\' wurde nicht angelegt.';
$string['cannotcreateuploaddir'] = 'Das Upload-Verzeichnis konnte nicht angelegt werden. Administrator/innen müssen die Dateirechte auf dem Server korrigieren.';
$string['cannotcustomisefiltersblockuser'] = 'Sie dürfen keine Filtereinstellungen im Nutzer- oder Blockkontext ändern.';
$string['cannotdeletebackupids'] = 'Frühere Sicherungs-IDs konnten nicht gelöscht werden.';
$string['cannotdeletecategorycourse'] = 'Fehler beim Löschen des Kurses \'{$a}\'';
$string['cannotdeletecategoryquestions'] = 'Einige Fragen aus der Kategorie \'{$a}\' konnten nicht gelöscht werden.';
$string['cannotdeletecourse'] = 'Sie dürfen diesen Kurs nicht löschen.';
$string['cannotdeletecustomfield'] = 'Fehler beim Löschen von Daten in nutzerdefiniertem Felder';
$string['cannotdeletedir'] = '\'{$a}\' kann nicht gelöscht werden.';
$string['cannotdeletefile'] = 'Die Datei kann nicht gelöscht werden.';
$string['cannotdeleterole'] = 'Das Löschen ist nicht möglich: {$a}';
$string['cannotdeleterolewithid'] = 'Die Rolle mit der ID {$a} konnte nicht gelöscht werden.';
$string['cannotdeletethisrole'] = 'Sie können die Rolle nicht löschen, weil sie vom System genutzt wird oder die letzte verbliebende Administrationsrolle ist.';
$string['cannotdisableformat'] = 'Das Standardformat kann nicht deaktivieren werden.';
$string['cannotdownloadcomponents'] = 'Einige Komponenten können nicht geladen werden.';
$string['cannotdownloadlanguageupdatelist'] = 'Die Liste der Sprachdateien kann nicht von download.moodle.org geladen werden.';
$string['cannotdownloadzipfile'] = 'Die ZIP-Datei kann nicht heruntergeladen werden';
$string['cannoteditcomment'] = 'Sie dürfen keinen fremden Kommentar bearbeiten.';
$string['cannoteditcommentexpired'] = 'Die Zeit zur Bearbeitung ist abgelaufen!';
$string['cannoteditpostorblog'] = 'Sie dürfen keine Blogs posten oder bearbeiten.';
$string['cannoteditsiteform'] = 'Sie können die Startseite nicht über dieses Formular bearbeiten.';
$string['cannotedituserpreferences'] = 'Diese Nutzereinstellungen können nicht geändert werden.';
$string['cannotedityourprofile'] = 'Sie können Ihr Nutzerprofil nicht bearbeiten.';
$string['cannotexecduringupgrade'] = 'Das kann während der Aktualisierung nicht ausgeführt werden.';
$string['cannotfindcategory'] = 'Für den Kursbereich kann kein Datensatz mit der ID {$a} gefunden werden.';
$string['cannotfindcomponent'] = 'Die Komponente kann nicht gefunden werden.';
$string['cannotfindcontext'] = 'Der Kontext wurde nicht gefunden.';
$string['cannotfindcourse'] = 'Der Kurs kann nicht gefunden werden.';
$string['cannotfinddocs'] = 'Die Dokumentation in der Sprache \'{$a}\' wurde nicht gefunden.';
$string['cannotfindgradeitem'] = 'Der Bewertungsaspekt wurde nicht gefunden.';
$string['cannotfindgroup'] = 'Die Gruppe wurde nicht gefunden.';
$string['cannotfindhelp'] = 'Die Hilfedateien in der Sprache \'{$a}\' wurden nicht gefunden.';
$string['cannotfindinfo'] = 'Informationen zu \'{$a}\' wurden nicht gefunden.';
$string['cannotfindlang'] = 'Das Sprachpaket \'{$a}\' wurde nicht gefunden!';
$string['cannotfindteacher'] = 'Trainer/in wurde nicht gefunden.';
$string['cannotfinduser'] = 'Nutzerkonto \'{$a}\' wurde nicht gefunden:';
$string['cannotgeoplugin'] = 'Die Verbindung zum geoPlugin-Server https://www.geoplugin.com konnte nicht hergestellt werden. Prüfen Sie die Proxyeinstellungen oder installieren Sie die Datei \'<a href="https://www.maxmind.com">MaxMind GeoLite City</a>\'.';
$string['cannotgetblock'] = 'Die Blöcke wurden nicht aus der Datenbank abgerufen.';
$string['cannotgetcats'] = 'Der Datensatzes für den Kursbereich konnte nicht abgerufen werden.';
$string['cannotgetdata'] = 'Die Daten wurden nicht gefunden.';
$string['cannotgradeuser'] = 'Nutzer/in kann nicht bewertet werden.';
$string['cannothaveparentcate'] = 'Der Kursbereich kann keinen übergeordneten Kursbereich haben!';
$string['cannotimport'] = 'Fehler beim Import';
$string['cannotimportformat'] = 'Dieses Importformat ist bisher nicht implementiert!';
$string['cannotimportgrade'] = 'Fehler beim Bewertungsimport';
$string['cannotinsertgrade'] = 'Die Bewertung kann nicht ohne Kurs-ID angelegt werden!';
$string['cannotinsertrate'] = 'Die neue Bewertung wurde nicht eingefügt ({$a->id} = {$a->rating}).';
$string['cannotinsertrecord'] = 'Der neue Datensatz mit der ID {$a} wurde nicht eingefügt.';
$string['cannotmailconfirm'] = 'Fehler beim E-Mail-Versand zur Bestätigung der Kennwortänderung';
$string['cannotmanualctrack'] = 'Die Aktivität unterstützt keine manuelle Abschlussverfolgung.';
$string['cannotmapfield'] = 'Problem bei der Zuordnung. Zwei Felder sind dem gleichen Bewertungselement {$a} zugeordnet.';
$string['cannotmarktopic'] = 'Der Abschnitt konnte nicht markiert werden.';
$string['cannotmigratedatacomments'] = 'Die Kommentare zum Datenmodul können nicht migriert werden.';
$string['cannotmodulename'] = 'Bei der Navigationserstellung kann der Modulname nicht festgestellt werden.';
$string['cannotmoduletype'] = 'Bei der Navigationserstellung kann der Modultyp nicht festgestellt werden.';
$string['cannotmovecategory'] = 'Der Kursbereich kann nicht verschoben werden.';
$string['cannotmovecourses'] = 'Fehler beim Verschieben von Kursen in eine anderen Kursbereich';
$string['cannotmoverolewithid'] = 'Die Rolle mit der ID {$a} kann nicht verschoben werden.';
$string['cannotopencsv'] = 'Die CSV-Datei kann nicht geöffnet werden.';
$string['cannotopenfile'] = 'Datei \'{$a}\' kann nicht geöffnet werden.';
$string['cannotopenforwrit'] = 'Datei \'{$a}\' kann nicht zum Schreiben geöffnet werden.';
$string['cannotopentemplate'] = 'Vorlage \'{$a}\' kann nicht geöffnet werden.';
$string['cannotopenzip'] = 'Die ZIP-Datei kann nicht geöffnet werden, möglicherweise wegen eines Fehlers in der Extension zip bei 64-Bit Betriebssystemen.';
$string['cannotoverridebaserole'] = 'Basisrollen dürfen nicht geändert werden.';
$string['cannotoverriderolehere'] = 'Sie dürfen die Rolle (id = {$a->roleid}) in diesem Kontext ({$a->context}) nicht ändern.';
$string['cannotreadfile'] = 'Die Datei \'{$a}\' kann nicht gelesen werden.';
$string['cannotreadtmpfile'] = 'Fehler beim Lesen von temporären Daten';
$string['cannotreaduploadfile'] = 'Die hochgeladene Datei konnte nicht gelesen werden.';
$string['cannotremovefrommeta'] = 'Sie können den ausgewählten Kurs nicht aus diesem Metakurs entfernen!';
$string['cannotreprocessgrades'] = 'Die Bewertungen für die Aktivität {$a} konnten nicht neu berechnet werden.';
$string['cannotresetguestpwd'] = 'Sie dürfen das Kennwort für Gäste nicht ändern.';
$string['cannotresetmail'] = 'Fehler beim Zurücksetzen und Senden des Kennwortes';
$string['cannotresetthisrole'] = 'Diese Rolle kann nicht zurückgesetzt werden.';
$string['cannotrestore'] = 'Die Wiederherstellung wurde wegen eines Fehlers nicht abgeschlossen!';
$string['cannotrestoreadminorcreator'] = 'Sie müssen Kursersteller/in oder Administrator/in sein, um die Daten in einen neuen Kurs wiederherzustellen!';
$string['cannotrestoreadminoredit'] = 'Sie müssen Trainer/in oder Administrator/in sein, um die Daten im ausgewählten Kurs wiederherzustellen!';
$string['cannotsaveagreement'] = 'Die Bestätigung konnte nicht gespeichert werden.';
$string['cannotsaveblock'] = 'Fehler beim Speichern der Block-Einstellungen';
$string['cannotsavecomment'] = 'Der Kommentar wurde nicht gespeichert.';
$string['cannotsavedata'] = 'Die Daten wurden nicht gespeichert.';
$string['cannotsavefile'] = 'Die Datei \'{$a}\' wurde nicht gespeichert!';
$string['cannotsavemd5file'] = 'Die md5-Datei wurde nicht gespeichert.';
$string['cannotsavezipfile'] = 'Die ZIP-Datei wurde nicht gespeichert.';
$string['cannotservefile'] = 'Die Datei kann nicht bereitgestellt werden. Ursache ist ein Problem mit der Serverkonfiguration.';
$string['cannotsetparentforcatoritem'] = 'Für die Kategorie oder den Kurs konnte kein übergeordneter Wert zugeordnet werden!';
$string['cannotsetpassword'] = 'Das Kennwort konnte nicht gesetzt werden!';
$string['cannotsetprefgrade'] = 'Präferenz Gesamtergebnisansicht für {$a} konnte für diese Bewertungskategorie nicht gesetzt werden.';
$string['cannotsettheme'] = 'Das Design konnte nicht gesetzt werden!';
$string['cannotsetupblock'] = 'Die Blocktabellen konnten nicht erfolgreich angelegt werden!';
$string['cannotsetupcapformod'] = 'Rechte für {$a} konnten nicht angelegt werden.';
$string['cannotsetupcapforplugin'] = 'Rechte für {$a} konnten nicht angelegt werden.';
$string['cannotshowhidecoursesincategory'] = 'Die Kurse in der Kategorie {$a} können nicht angezeigt / verborgen werden.';
$string['cannotsignup'] = 'Sie können kein neues Nutzerkonto anlegen, weil Sie bereits als {$a} angemeldet sind.';
$string['cannotswitcheditmodeon'] = 'Der Bearbeitungsmodus konnte nicht eingeschaltet werden.';
$string['cannotunassigncap'] = 'Abgelehnte Berechtigung {$a->cap} für Rolle {$a->role} konnte nicht ausgetragen werden.';
$string['cannotunassignrolefrom'] = 'Dieses Nutzerkonto konnte nicht aus der Rollenzuweisung gelöscht werden: {$a}';
$string['cannotunzipfile'] = 'Die Datei kann nicht entpackt werden';
$string['cannotupdatemod'] = '{$a} kann nicht aktualisiert werden';
$string['cannotupdatepasswordonextauth'] = 'Die Kennwortaktualisierung für die externe Authentisierung ist fehlgeschlagen: {$a}. Weitere Detail finden Sie in den Logdateien des Servers.';
$string['cannotupdateprofile'] = 'Fehler beim Aktualisieren des Nutzerdatensatzes';
$string['cannotupdaterecord'] = 'Der Datensatz mit der ID {$a} kann nicht aktualisiert werden';
$string['cannotupdaterss'] = 'RSS konnte nicht aktualisiert werden';
$string['cannotupdatesubcourse'] = 'Ein zugeordneter Kurs konnte nicht aktualisiert werden!';
$string['cannotupdateusermsgpref'] = 'Die Mitteilungseinstellungen des Nutzerkontos können nicht aktualisiert werden.';
$string['cannotupdateuseronexauth'] = 'Die Aktualisierung der Nutzerdaten für die externe Authentisierung ist fehlgeschlagen: {$a}. Schauen Sie bitte in die Logdateien des Servers, um weitere Details zu erfahren.';
$string['cannotuploadfile'] = 'Fehler beim Hochladen der Datei';
$string['cannotuseadmin'] = 'Sie müssen Administrator/in sein, um diese Seite nutzen zu können';
$string['cannotuseadminadminorteacher'] = 'Sie müssen Trainer/in oder Administrator/in sein, um diese Seite nutzen zu können';
$string['cannotusepage'] = 'Ausschließlich Trainer/innen und Administrator/innen können diese Seite nutzen';
$string['cannotusepage2'] = 'Sie dürfen diese Seite nicht verwenden.';
$string['cannotviewcategory'] = 'Sie haben nicht das Recht, die Kursliste anzuzeigen.';
$string['cannotviewprofile'] = 'Sie dürfen dieses Nutzerprofil nicht sehen';
$string['cannotviewreport'] = 'Sie dürfen diesen Bericht nicht sehen';
$string['cannotwritefile'] = 'In die Datei \'{$a}\' kann nicht geschieben werden';
$string['categoryerror'] = 'Kursbereichsfehler';
$string['categoryidnumbertaken'] = 'Die ID-Nummer wird bereits für einen anderen Kursbereich verwendet.';
$string['categorynamerequired'] = 'Die Bezeichnung des Kursbereichs ist notwendig.';
$string['categorytoolong'] = 'Kursbereichsname ist zu lang';
$string['commentmisconf'] = 'Kommentar-ID ist falsch konfiguriert';
$string['componentisuptodate'] = 'Die Komponente ist aktuell.';
$string['confirmationnotenabled'] = 'Nutzer-Bestätigung ist auf dieser Seite nicht aktiviert';
$string['confirmsesskeybad'] = 'Der \'session key\' für diese Aktion konnte nicht bestätigt werden. Dieses Sicherheitsfeature schützt Sie vor der nicht beabsichtigten Ausführung wichtiger Funktionen oder der Ausführung von Aktionen durch Dritte in Ihrem Namen. Bitte loggen Sie sich nun ggfs. neu ein.';
$string['contenttypenotfound'] = 'Der \'{$a}\' Inhaltsspeicher-Typ existiert nicht oder wurde nicht erkannt.';
$string['contentvisibilitynotfound'] = 'Die Inhaltssichtbarkeit mit Wert "{$a}" existiert nicht oder wird nicht erkannt.';
$string['couldnotassignrole'] = 'Ein schwerer Fehler ist aufgetreten, während Sie sich selber eine Rolle zuweisen wollten.';
$string['couldnotupdatenoexistinguser'] = 'Nutzer konnte nicht aktualisiert werden - Nutzer existiert nicht';
$string['couldnotverifyagedigitalconsent'] = 'Beim Versuch, das Alters zu überprüfen, ist ein Fehler aufgetreten. <br />Wenden Sie sich an die Administrator/innen.';
$string['countriesphpempty'] = 'Fehler: Die Datei countries.php im Sprachpaket \'{$a}\' ist leer oder fehlt.';
$string['coursedoesnotbelongtocategory'] = 'Der Kurs gehört nicht zu diesem Kursbereich.';
$string['courseformatnotfound'] = 'Das Kursformat \'{$a}\' existiert nicht oder wird nicht erkannt.';
$string['coursegroupunknown'] = 'Es wurde kein Kurs für die Gruppe {$a} festgelegt';
$string['courseidnotfound'] = 'Die Kurs-ID existiert nicht.';
$string['courseidnumbertaken'] = 'ID-Nummer wird bereits für anderen Kurs ({$a}) genutzt';
$string['coursemisconf'] = 'Kurs ist falsch konfiguriert.';
$string['courserequestdisabled'] = 'Die Kursanträge wurden von Administrator/innen deaktiviert.';
$string['csvcolumnduplicates'] = 'Doppelte Spalten gefunden';
$string['csvemptyfile'] = 'Die CSV-Datei ist leer';
$string['csvfewcolumns'] = 'Die Spaltenzahl ist falsch. Prüfen Sie bitte die Trennzeicheneinstellung.';
$string['csvfileerror'] = 'Fehler in der CSV-Datei. Überprüfen Sie bitte, ob die Anzahl der Überschriften und Spalten übereinstimmt und ob das Trennzeichen und die Dateikodierung korrekt sind. {$a}';
$string['csvinvalidcols'] = 'Ungültige CSV-Datei: Die erste Zeile muss die Feldbezeichner enthalten. Der Dateityp muss \'erweiterte Felder / Komma getrennt\' oder \'erweiterte Felder mit CAVV-Ergebniscode / Komma getrennt\' sein.';
$string['csvinvalidcolsnum'] = 'Ungültige CSV-Datei. Jede Zeile muss 49 oder 70 Felder enthalten.';
$string['csvloaderror'] = 'Fehler beim Laden der CSV-Datei aufgetreten: {$a}';
$string['csvnodata'] = 'Ungültige CSV-Datei – Die CSV-Datei hat Kopfzeilen, enthält aber keine Daten.';
$string['csvweirdcolumns'] = 'Ungültiges CSV-Format - die Anzahl der Datenfelder ist nicht konstant!';
$string['dbconnectionfailed'] = '<p>Fehler: Datenbankverbindung fehlgeschlagen</p>
<p>Es ist möglich, dass die Datenbank überlastet ist oder nicht ordentlich läuft.</p>
<p>Server-Administrator/innen sollten zusätzlich prüfen, ob die Datenbankdetails richtig in der config.php eingetragen sind.</p>';
$string['dbdriverproblem'] = '<p>Fehler: Datenbanktreiber-Problem aufgetreten</a>
<p>Server-Administrator/innen sollten die Servereinstellungen prüfen.</p>
<p>{$a}</p>';
$string['dbsessionbroken'] = 'Ein schwerwiegendes Problem mit der Datenbank-Session wurde erkannt<br /><br />Bitte benachrichtigen Sie die Administrator/innen des Servers';
$string['dbsessionhandlerproblem'] = 'Das Einrichten der Datenbank-Session ist fehlgeschlagen. Bitte benachrichtigen Sie die Administrator/innen des Servers';
$string['dbsessionmysqlpacketsize'] = 'Ein schwerwiegender Session-Fehler wurde erkannt. Bitte informieren Sie die Administrator/innen des Servers, dass dieses Problem auftreten kann, wenn der Wert max_allowed_packet in den MySQL-Einstellungen zu klein festgelegt wurde';
$string['dbupdatefailed'] = 'Datenbankaktualisierung fehlgeschlagen';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" kann nicht verändert werden, weil eine Verbindung mit {$a->offendingtype} "{$a->offendingname}" besteht';
$string['ddlexecuteerror'] = 'Fehler: DDL sql execution';
$string['ddlfieldalreadyexists'] = 'Feld "{$a}" existiert bereits';
$string['ddlfieldnotexist'] = 'Feld "{$a->fieldname}" existiert nicht in der Tabelle "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Tabelle "{$a}" ist bereits vorhanden';
$string['ddltablenotexist'] = 'Tabelle "{$a}" existiert nicht';
$string['ddlunknownerror'] = 'Unbekannter DDL Library Fehler';
$string['ddlxmlfileerror'] = 'XML Datenbankdatei-Fehler gefunden';
$string['ddsequenceerror'] = 'Falsche Tabellendefinition "{$a}". Es darf nur eine Auto-Spalte geben und die muss als Key definiert sein';
$string['destinationcmnotexit'] = 'Das adressierte Kursmodul existiert nicht';
$string['detectedbrokenplugin'] = 'Das Plugin \'{$a}\' ist defekt oder veraltet. Der Prozess wird abgebrochen.';
$string['dmlexceptiononinstall'] = '<p>Ein Datenbankfehler ist aufgetreten [{$a->errorcode}]. <br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Fehler beim Parsen eine SQL-Abfrage';
$string['dmlreadexception'] = 'Fehler beim Lesen der Datenbank';
$string['dmltransactionexception'] = 'Fehler bei Datenbankvorgang';
$string['dmlwriteexception'] = 'Fehler beim Schreiben der Datenbank';
$string['downgradedcore'] = 'Fehler: Der von Ihnen benutzte Code ist ÄLTER als die Version, die speziell für diese Datenbanken geschrieben wurde.';
$string['downloadedfilecheckfailed'] = 'Die Überprüfung der heruntergeladenen Datei ist gescheitert';
$string['duplicatefieldname'] = 'Doppelter Feldname \'{$a}\'';
$string['duplicatenosupport'] = 'Die \'{$a->modname}\' Aktivität konnte nicht kopiert werden, da  das {$a->modtype}-Modul den Backup- und Wiederherstellungsprozess nicht unterstützt.';
$string['duplicateparaminsql'] = 'Fehler: Doppelter Parametername in der ABfrage';
$string['duplicaterolename'] = 'Eine Rolle mit diesem Namen existiert bereits!';
$string['duplicateroleshortname'] = 'Eine Rolle mit diesem Kurznamen existiert bereits!';
$string['duplicateusername'] = 'Doppelter Anmeldename. Datensatz überspringen.';
$string['emailfail'] = 'E-Mail-Versand fehlgeschlagen';
$string['encryption_decryptfailed'] = 'Entschlüsselung fehlgeschlagen';
$string['encryption_encryptfailed'] = 'Verschlüsselung fehlgeschlagen';
$string['encryption_invalidkey'] = 'Ungültiger Schlüssel';
$string['encryption_keyalreadyexists'] = 'Schlüssel existiert bereits';
$string['encryption_nokey'] = 'Schlüssel nicht gefunden';
$string['encryption_wrongmethod'] = 'Daten passen zu keiner der unterstützten Verschlüsselungsmethoden';
$string['enddatebeforestartdate'] = 'Das Kursende muss nach dem Kursbeginn liegen.';
$string['error'] = 'Fehler aufgetreten';
$string['error_question_answers_missing_in_db'] = 'Das Finden einer passenden Antwort "{$a->answer}" in der question_answers Datenbank-Tabelle ist fehlgeschlagen. Dies trat während der Wiederherstellung der Frage mit ID {$a->filequestionid} in der Backup-Datei auf, welche der existierenden Frage mit ID {$a->dbquestionid} in der Datenbank zugeordnet wurde.';
$string['errorcleaningdirectory'] = 'Fehler beim Bereinigen des Verzeichnisses "{$a}"';
$string['errorcopyingfiles'] = 'Fehler beim Kopieren der Dateien';
$string['errorcreatingdirectory'] = 'Fehler beim Erstellen des Verzeichnisses "{$a}"';
$string['errorcreatingfile'] = 'Fehler beim Erstellen der Datei "{$a}"';
$string['errorcreatingrole'] = 'Fehler beim Anlegen der Rolle';
$string['errorfetchingrssfeed'] = 'Fehler beim Holen eines RSS Feeds';
$string['erroronline'] = 'Fehler in Zeile {$a}';
$string['erroroutput'] = 'Fehleranzeige. Die automatische Weiterleitung ist deaktiviert.';
$string['errorparsingxml'] = 'Fehler beim Parsen von XML: {$a->errorstring} in Zeile {$a->errorline}, Zeichen {$a->errorchar}';
$string['errorprocessingarchive'] = 'Fehler bei der Verarbeitung einer Archivdatei';
$string['errorreadingfile'] = 'Fehler beim Lesen der Datei "{$a}"';
$string['errorsavingrequest'] = 'Fehler beim Versuch, Ihre Abfrage zu speichern';
$string['errorsettinguserpref'] = 'Fehler beim Setzen der Nutzereinstellungen';
$string['errorunzippingfiles'] = 'Fehler beim Entpacken der Dateien';
$string['expiredkey'] = 'Abgelaufener Schlüssel';
$string['externalauthpassworderror'] = 'Nichtleeres Kennwort zur externen Authentifizierung';
$string['externalfilenolocation'] = 'Für die externe Datei wurde kein kompletter Dateipfad angegeben.';
$string['failtoloadblocks'] = 'Mindestens ein Block ist in der Datenbank registriert, kann aber nicht geladen werden!';
$string['fieldrequired'] = '"{$a}" ist ein Pflichtfeld';
$string['fileexists'] = 'Datei existiert bereits';
$string['filemismatch'] = 'Fehlerhafter Dateiname - die Datei "{$a->current}" sollte {$a->file} heißen.';
$string['filenotfound'] = 'Die gesuchte Datei wurde nicht gefunden.';
$string['filenotreadable'] = 'Datei ist nicht lesbar';
$string['filterdoesnothavelocalconfig'] = 'Der Filter {$a} erlaubt keine lokalen Einstellungen.';
$string['filternotactive'] = 'Der Filter {$a} ist momentan nicht aktiviert';
$string['filternotenabled'] = 'Filter nicht aktiviert!';
$string['filternotinstalled'] = 'Der Filter {$a} ist momentan nicht installiert';
$string['forumblockingtoomanyposts'] = 'Sie haben die Höchstzahl der zulässigen Beiträge für dieses Forum erreicht';
$string['functionalityremoved'] = 'Sie versuchen, auf eine Funktion zuzugreifen, die entfernt wurde.';
$string['generalexceptionmessage'] = 'Fehler: {$a}';
$string['gradecantregrade'] = 'Fehler bei der Bewertungsberechnung: {$a}';
$string['gradepubdisable'] = 'Das Veröffentlichen von Bewertungen ist deaktiviert';
$string['gradesneedregrading'] = 'Die Kursbewertungen müssen neu berechnet werden.';
$string['groupalready'] = 'Nutzer/in gehört bereits zur Gruppe {$a}';
$string['groupexistforcourse'] = 'Die Gruppe \'{$a}\' existiert bereits in diesem Kurs.';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Die Gruppe \'{$a->name}\' mit der ID \'{$a->idnumber}\' existiert bereits in diesem Kurs.';
$string['grouphasidnumber'] = 'Die Gruppe \'{$a}\' mit einer eigenen ID existiert und ist womöglich durch ein externes System automatisch angelegt worden. Sie haben keine Berechtigung, diese Gruppe zu entfernen.';
$string['groupinghasidnumber'] = 'Die Gruppierung "{$a}" mit einer eigenen idnumber existiert und ist womöglich durch ein externes System automatisch angelegt worden. Sie haben nicht die Berechtigung, diese Gruppierung zu entfernen.';
$string['groupingnotaddederror'] = 'Gruppierung \'{$a}\' wurde nicht hinzugefügt';
$string['groupnotaddederror'] = 'Die Gruppe \'{$a}\' wurde nicht hinzugefügt';
$string['groupnotaddedtogroupingerror'] = 'Gruppe \'{$a->groupname}\' wurde nicht zur Gruppierung \'{$a->groupingname}\' hinzugefügt';
$string['groupunknown'] = 'Die Gruppe \'{$a}\' gehört nicht zum ausgewählten Kurs.';
$string['groupusernotmember'] = 'Nutzer/in ist nicht Mitglied dieser Gruppe.';
$string['guestcantaccessprofiles'] = 'Gäste dürfen nicht auf die Nutzerprofile zugreifen. Loggen Sie sich mit Ihren persönlichen Zugangsdaten ein.';
$string['guestnocomment'] = 'Gäste dürfen keine Kommentare schreiben!';
$string['guestnoeditprofile'] = 'Gäste dürfen das Nutzerprofil nicht bearbeiten.';
$string['guestnoeditprofileother'] = 'Das Nutzerprofil für Gäste kann nicht bearbeitet werden.';
$string['guestnorate'] = 'Gäste dürfen keine Beiträge bewerten.';
$string['guestsarenotallowed'] = 'Gäste dürfen dies nicht';
$string['hackdetected'] = 'Hacker-Angriff entdeckt!';
$string['hashpoolproblem'] = 'Falscher Inhalt in der Basisdatei {$a}';
$string['headersent'] = 'Header wurde bereits gesendet';
$string['idnumbertaken'] = 'ID-Nummer wird bereits genutzt';
$string['idnumbertoolong'] = 'ID ist zu lang';
$string['importformatnotimplement'] = 'Der Import dieses Formats wird zur Zeit nicht unterstützt!';
$string['incorrectext'] = 'Die Datei hat eine falsche Dateierweiterung.';
$string['inplaceeditableerror'] = 'Fehler beim Aufruf der Aktualisierung';
$string['installproblem'] = 'Eine Wiederherstellung ist meist nicht mögllich wenn während der Installation Fehler aufgetreten sind. Erstellen Sie eine neue Datenbank oder wählen Sie einen anderen Tabellenpräfix und versuchen Sie eine neue Installation.';
$string['internalauthpassworderror'] = 'Fehlendes Kennwort oder ungültige Kennwortregeln zur internen Authentifizierung';
$string['invalidaccess'] = 'Auf diese Seite wurde nicht richtig zugegriffen';
$string['invalidaccessparameter'] = 'Ungültiger Zugriffsparameter';
$string['invalidaction'] = 'Ungültiger Aktionsparameter';
$string['invalidactivityid'] = 'Ungültige Aktivitäten-ID';
$string['invalidadminsettingname'] = 'Ungültige Admin-Einstellungen ({$a})';
$string['invalidargorconf'] = 'Keine gültigen Argumente angegeben oder falsche Server-Konfiguration';
$string['invalidarguments'] = 'Keine gültigen Argumente angegeben';
$string['invalidblockinstance'] = 'Ungültige Block-Instanz: {$a}';
$string['invalidbulkenrolop'] = 'Ungültige Nutzerverarbeitung (Bulk) angefordert';
$string['invalidcategory'] = 'Falscher Kursbereich!';
$string['invalidcategoryid'] = 'Falsche Kursbereichs-ID';
$string['invalidcomment'] = 'Falscher Kommentar';
$string['invalidcommentarea'] = 'Ungültiger Kommentarbereich';
$string['invalidcommentid'] = 'Ungültige Kommentar-ID';
$string['invalidcommentitemid'] = 'Ungültige Kommentar-ID';
$string['invalidcommentparam'] = 'Ungültiger Kommentarparameter';
$string['invalidcomponent'] = 'Ungültiger Komponentenname';
$string['invalidconfirmdata'] = 'Ungültige Bestätigungsdaten';
$string['invalidcontentid'] = 'Ungültige Inhalts-ID';
$string['invalidcontext'] = 'Ungültiger Kontext';
$string['invalidcountrycode'] = 'Ungültiger Ländercode: {$a}';
$string['invalidcourse'] = 'Ungültiger Kurs';
$string['invalidcourseformat'] = 'Ungültiges Kursformat';
$string['invalidcourseid'] = 'Sie versuchen, eine ungültige Kurs-ID zu benutzen.';
$string['invalidcourselevel'] = 'Falsche Kontext-Stufe';
$string['invalidcoursemodule'] = 'Ungültige Kursmodul-ID';
$string['invalidcoursemoduleid'] = 'Ungültige Kursmodul-ID: {$a}';
$string['invalidcoursenameshort'] = 'Ungültige Kurzbezeichnung für den Kurs';
$string['invaliddata'] = 'Übermittelte Daten sind ungültig';
$string['invaliddatarootpermissions'] = 'Während des Versuchs, ein Verzeichnis anzulegen, wurden ungültige Berechtigungen festgestellt. Aktivieren Sie das Debugging, um weitere Details zu erfahren.';
$string['invaliddevicetype'] = 'Ungültiger Gerätetyp';
$string['invalidelementid'] = 'Falsche Element-ID';
$string['invalidentry'] = 'Dies ist kein gültiger EIntrag!';
$string['invalidevent'] = 'Ungültiges Ereignis';
$string['invalidfieldname'] = '"{$a}" ist ein ungültiger Feldname.';
$string['invalidfiletype'] = '"{$a}" ist ein unzulässiger Dateityp.';
$string['invalidformatpara'] = 'Falsches Format der Auswahlparameter';
$string['invalidformdata'] = 'Falsche Formulardaten';
$string['invalidfunction'] = 'Falsche Funktion';
$string['invalidgradeitemid'] = 'Falsche Bewertungsaspekt-ID';
$string['invalidgroupid'] = 'Falsche Gruppen-ID angegeben';
$string['invalidipformat'] = 'Ungültiges IP-Adressformat';
$string['invaliditemid'] = 'Falsche Aspekt-ID';
$string['invalidkey'] = 'Falscher Schlüssel';
$string['invalidlanguagecode'] = 'Ungültiger Sprachcode: {$a}';
$string['invalidlegacy'] = 'Falsche Rollenvererbung für den Typ: {$a}';
$string['invalidmd5'] = 'Der Prüfwert ist ungültig. Versuchen Sie es bitte nochmal!';
$string['invalidmode'] = 'Ungültiger Modus ({$a})';
$string['invalidmodule'] = 'Ungültiges Modul';
$string['invalidmoduleid'] = 'Ungültige Modul-ID: {$a}';
$string['invalidmodulename'] = 'Ungültiger Modulname: {$a}';
$string['invalidnum'] = 'Ungültiger Zahlenwert';
$string['invalidnumkey'] = 'Das Feld $conditions darf keine numerischen Schlüssel enthalten. Bitte korrigieren Sie den Code!';
$string['invalidoutcome'] = 'Falsche Lernziel ID';
$string['invalidpagesize'] = 'Ungültige Seitengröße';
$string['invalidpasswordpolicy'] = 'Ungültige Kennwortregeln';
$string['invalidpaymentmethod'] = 'Falsche Zahlungsmethode: {$a}';
$string['invalidpersistenterror'] = 'Fehler: {$a}';
$string['invalidqueryparam'] = 'Fehler: Falsche Anzahl von Anfrage-Parametern. Erwartet: {$a->expected}, bekommen: {$a->actual}.';
$string['invalidratingarea'] = 'Ungültiger Bewertungsbereich';
$string['invalidrecord'] = 'Der Datensatz kann nicht in der Datenbanktabelle {$a} gefunden werden.';
$string['invalidrecordunknown'] = 'Datensatz kann nicht in der Datenbank gefunden werden';
$string['invalidrequest'] = 'Ungültige Abfrage';
$string['invalidrole'] = 'Ungültige Rolle';
$string['invalidroleid'] = 'Ungültige Rollen-ID';
$string['invalidscaleid'] = 'Falsche Skalen-ID';
$string['invalidsection'] = 'Der Datensatz des Kursmoduls enthält ungültigen Abschnitt.';
$string['invalidsesskey'] = 'Ihre Sitzung ist höchstwahrscheinlich abgelaufen. Bitte melden Sie sich erneut an.';
$string['invalidshortname'] = 'Ungültige Kurzbezeichnung für den Kurs';
$string['invalidsourcefield'] = 'Der Eintrag im Dateifeld (draft file) ist ungültig.';
$string['invalidstatedetected'] = 'Eigentlich hätte hier kein Fehler passieren dürfen: {$a}';
$string['invalidurl'] = 'Ungültige URL';
$string['invaliduser'] = 'Ungültige Nutzer/in';
$string['invaliduserdata'] = 'Ungültige Nutzerdaten: {$a}';
$string['invaliduserfield'] = 'Ungültiges Nutzerfeld: {$a}';
$string['invaliduserid'] = 'Ungültige Nutzer-ID';
$string['invalidusername'] = 'Der Anmeldename enthält ungültige Zeichen';
$string['invalidusernameblank'] = 'Der Anmeldename darf nicht leer sein';
$string['invalidxmlfile'] = '"{$a}" ist eine ungültige XML-Datei.';
$string['iplookupfailed'] = 'Die Geo-Informationen zu dieser IP-Adresse konnten nicht gefunden werden: {$a}';
$string['iplookupprivate'] = 'Private IP-Adressen können nicht lokalisiert werden';
$string['ipmismatch'] = 'IP-Adresse passt nicht';
$string['listcantmovedown'] = 'Fehler beim Verschieben des Elements nach unten, weil es bereits das letzte ist.';
$string['listcantmoveleft'] = 'Fehler beim Verschieben des Elements nach links, denn es besitzt keine Vorgänger.';
$string['listcantmoveright'] = 'Fehler beim Verschieben des Elements nach rechts, da es keinen Peer gibt, der es zu einem untergeordneten Element macht. Bewegen Sie es unter einen anderen Peer und dann können Sie es nach rechts verschieben.';
$string['listcantmoveup'] = 'Fehler beim Verschieben des Elements nach oben, weil es bereits das erste ist.';
$string['listnochildren'] = 'Keine Nachfolger (Children) zum Element gefunden.';
$string['listnoitem'] = 'Element konnte nicht gefunden werden';
$string['listnopeers'] = 'Keine Gleichen (Peers) zum Element gefunden.';
$string['listupdatefail'] = 'Datenbankfehler bei der Bearbeitung der Listenhierarchie';
$string['logfilenotavailable'] = 'Keine Logdaten verfügbar';
$string['loginasnoenrol'] = 'Das \'Einschreiben\' oder \'Abmelden\' für einen Kurs ist nicht möglich, wenn Sie als andere Person angemeldet sind.';
$string['loginasonecourse'] = 'Sie können sich in diesen Kurs nicht eintragen.<br /> Beenden Sie zuerst die Funktion "Login als", um sich dann in den anderen Kurs einzutragen.';
$string['maxareabytes'] = 'Diese Datei ist größer als der in diesem Bereich verfügbare Platz.';
$string['maxbytesfile'] = 'Die Datei {$a->file} ist zu groß. Die maximale Größe zum Hochladen ist {$a->size}.';
$string['maxdraftitemids'] = 'Ihre Datei-Uploads sind vorübergehend eingeschränkt, nachdem Sie eine große Anzahl von Dateien hochgeladen haben. Versuchen Sie es bitte später nochmal.';
$string['messageundeliveredbynotificationsettings'] = 'Die Nachricht konnte nicht gesendet werden, da persönliche Nachrichten zwischen Nutzer/innen (in den Benachrichtigungseinstellungen) von den Administrator/innen deaktiviert wurden.';
$string['messagingdisable'] = 'Die Mitteilungen sind für diese Website deaktiviert.';
$string['mimetexisnotexist'] = 'Ihr System ist nicht konfiguriert, um mimeTeX ausführen zu können. Sie müssen den C-Quellcode unter <a href="https://www.forkosh.com/mimetex.zip"> https://www.forkosh.com/mimetex.zip</a> herunterladen, kompilieren und das ausführbare Programm in das Verzeichnis moodle/filter/tex/ legen.';
$string['mimetexnotexecutable'] = 'Das spezifische Programm mimetex ist nicht ausführbar!';
$string['missing_moodle_backup_xml_file'] = 'XML-Datei im Backup fehlt: {$a}';
$string['missingcategoryrole'] = 'Rolle konnte Nutzer/in nicht zugewiesen werden: fehlende Rolle für Kategorie.';
$string['missingfield'] = 'Feld "{$a}" fehlt';
$string['missingkeyinsql'] = 'Fehler: fehlender Parameter "{$a}" in der Abfrage';
$string['missingparam'] = 'Notwendiger Parameter "{$a}" fehlt';
$string['missingparameter'] = 'Fehlender Parameter';
$string['missingrequiredfield'] = 'Einige erforderliche Felder sind nicht ausgefüllt.';
$string['missinguseranditemid'] = 'Fehlende userid und itemid';
$string['missingvarname'] = 'Erforderlicher Variablenname fehlt!';
$string['mixedtypesqlparam'] = 'Fehler: Verwechselte Typen bei den SQL-Abfrageparametern!!';
$string['mnetdisable'] = 'MNET ist deaktiviert';
$string['mnetlocal'] = 'Externe MNET-Nutzer/innen können sich nicht lokal anmelden';
$string['moduledisable'] = 'Das Modul "{$a}" wurde für diesen speziellen Kurs deaktiviert.';
$string['moduledoesnotexist'] = 'Dieses Modul gibt es nicht';
$string['moduleinstancedoesnotexist'] = 'Die Instanz dieses Moduls gibt es nicht';
$string['modulemissingcode'] = 'Im Modul {$a} fehlt der Code, um diese Funktion auszuführen.';
$string['movecatcontentstoroot'] = 'Das Verschieben des Bereichsinhalts in den Root-Bereich ist nicht zulässig. Der Inhalt muss in einen bestehenden Kursbereich verschoben werden.';
$string['movecatcontentstoselected'] = 'Kursbereichsinhalte können nicht in den ausgewählten Kursbereich verschoben werden.';
$string['movecategorynotpossible'] = 'Sie können den Kursbereich \'{$a}\' nicht in den ausgewählten Kursbereich verschieben.';
$string['movecategoryownparent'] = 'Sie können den Kursbereich \'{$a}\' nicht zu einem Unterbereich von sich selber machen.';
$string['movecategoryparentconflict'] = 'Sie können den Kursbereich \'{$a}\' nicht zu einem Unterbereich innerhalb seiner eigenen Unterbereiche machen.';
$string['mssqlrcsmodemissing'] = 'Die Datenbank verwendet nicht den Modus READ_COMMITTED_SNAPSHOT. Dies kann zu falschen Ergebnissen - besonders bei vielen zeitgleichen Zugriffen - führen. Aktivieren Sie dies für das korrekte Verhalten. Weitere Informationen finden Sie unter  <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP">Moodle Docs</a>.';
$string['multiplerecordsfound'] = 'Mehrere Datensätze gefunden, aber nur ein Datensatz wird erwartet';
$string['multiplerestorenotallow'] = 'Eine mehrfache Ausführung der Wiederherstellung ist nicht erlaubt!';
$string['mustbeloggedin'] = 'Sie müssen sich anmelden, um dies zu tun.';
$string['mustbeteacher'] = 'Diese Seite können Sie nur als Trainer/in ansehen.';
$string['myisamproblem'] = 'Die Datenbank nutzt die Database Engine MyISAM. Es wird empfohlen, stattdessen eine ACID-konforme Engine mit vollständigem Transactionsupport zu verwenden, z.B. InnoDB.';
$string['needcopy'] = 'Sie müssen zuerst etwas kopieren';
$string['needcoursecategroyid'] = 'Die Kurs-ID oder der Kursbereich muss definiert werden.';
$string['needphpext'] = 'Sie müssen {$a} -Unterstützung in Ihrer PHP-Installation hinzufügen';
$string['noadmins'] = 'Keine Adminstrator/innen!';
$string['noblocks'] = 'Keine Blöcke gefunden!';
$string['nocapabilitytousethisservice'] = 'Nutzer/in besitzt nicht die notwendige Berechtigung, um diesen Service zu nutzen';
$string['nocategorydelete'] = 'Kursbereich "{$a}" kann nicht gelöscht werden!';
$string['nocontext'] = 'Dieser Kurs hat keine gültigen Zusammenhänge.';
$string['nodata'] = 'Keine Daten';
$string['noexistingcategory'] = 'Kein Kursbereich vorhanden';
$string['nofile'] = 'Keine Datei ausgewählt';
$string['nofiltersenabled'] = 'Keine Filter aktiviert';
$string['nofolder'] = 'Gesuchtes Verzeichnis existiert nicht';
$string['noformdesc'] = 'Für diese Aktivität wurde keine Formularbeschreibungsdatei formslib gefunden.';
$string['noguest'] = 'Keine Gäste!';
$string['noinstances'] = 'In diesem Kurs gibt keine Instanzen von {$a}.';
$string['nologinas'] = 'Sie dürfen sich nicht in der Rolle dieser Person einloggen';
$string['nonmeaningfulcontent'] = 'Kein sinnvoller Inhalt';
$string['noparticipants'] = 'Keine Teilnehmer/innen für diesen Kurs gefunden';
$string['noparticipatorycms'] = 'Sie haben keine beteiligten Kursmodule für einen Bericht.';
$string['nopermissions'] = 'Sie haben aktuell nicht das Recht, dies zu tun ({$a}).';
$string['nopermissiontoaccesspage'] = 'Sie haben kein Recht, auf diese Seite zuzugreifen.';
$string['nopermissiontocomment'] = 'Sie können keine Kommentare hinzufügen';
$string['nopermissiontodelentry'] = 'Sie dürfen Diesen Kommentar nicht löschen!';
$string['nopermissiontoeditcomment'] = 'Sie dürfen keine fremden Kommentare bearbeiten!';
$string['nopermissiontohide'] = 'Kein Recht zum Verbergen!';
$string['nopermissiontoimportact'] = 'Sie haben nicht das Recht, um Aktivitäten in diesem Kurs zu importieren.';
$string['nopermissiontolock'] = 'Kein Recht zum Sperren!';
$string['nopermissiontomanagegroup'] = 'Sie haben keine Berechtigung, Gruppen zu verwalten.';
$string['nopermissiontorate'] = 'Bewertung von Beiträgen ist nicht erlaubt!';
$string['nopermissiontoshow'] = 'Kein Recht zum Anzeigen!';
$string['nopermissiontounlock'] = 'Kein Recht zum Freigeben!';
$string['nopermissiontoupdatecalendar'] = 'Sie haben aktuell kein Recht, den Termin zu aktualisieren.';
$string['nopermissiontoviewcalendar'] = 'Sie haben kein Recht, das Kalenderereignis anzuzeigen.';
$string['nopermissiontoviewgrades'] = 'Bewertungen können nicht angezeigt werden.';
$string['nopermissiontoviewletergrade'] = 'Kein Recht zur Anzeige von Notenstufen';
$string['nopermissiontoviewpage'] = 'Sie haben keinen Zugriff auf diese Seite';
$string['nosite'] = 'Die Kursübersicht wurde nicht gefunden!';
$string['nositeid'] = 'Keine Site-ID';
$string['nostartdatenoenddate'] = 'Ein Kursende kann nur festgelegt werden, wenn ein Kursbeginn eingetragen ist.';
$string['nostatstodisplay'] = 'Es sind keine anzeigbaren Daten vorhanden.';
$string['notallowedtoupdateprefremotely'] = 'Sie sind nicht berechtigt, die Nutzereinstellungen aus der Ferne zu aktualisieren.';
$string['notavailable'] = 'Dies ist zur Zeit nicht verfügbar.';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Sie sind nicht Mitglied dieser Gruppe im Kurs.';
$string['notownerofkey'] = 'Sie sind nicht der Eigentümer dieses Schlüssels';
$string['nousers'] = 'Kein Nutzer vorhanden!';
$string['oauth1accesstoken'] = 'OAuth 1.0 Fehler: Wir haben das Zugriffstoken nicht erhalten.';
$string['oauth1requesttoken'] = 'OAuth 1.0 Fehler: Wir haben das Anforderungstoken nicht erhalten - der Service Provider könnte vorübergehend nicht verfügbar sein.';
$string['oauth2refreshtokenerror'] = 'Das OAuth 2 Token konnte nicht aktualisiert werden. HTTP-Status für Remote-Endpunkt: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Das OAuth 2 Token für einen oder mehrere Aussteller konnte nicht aktualisiert werden. Weitere Informationen finden Sie in der Task-Ausgabe.';
$string['oauth2upgradetokenerror'] = 'Das OAuth 2 Token konnte nicht aktualisiert werden. HTTP-Status für Remote-Endpunkt: {$a}';
$string['onlyadmins'] = 'Diese Funktion können nur Administratoren/innen ausführen';
$string['onlyeditingteachers'] = 'Diese Funktion können nur Trainer/innen mit Bearbeitungsrecht ausführen';
$string['onlyeditown'] = 'Sie können nur eigene Informationen bearbeiten.';
$string['opensslsealerror'] = 'OpenSSL kann die Daten nicht versiegeln';
$string['opensslsignerror'] = 'OpenSSL kann die Daten nicht signieren';
$string['orderidnotfound'] = 'Die Befehls-ID {$a} wurde nicht gefunden';
$string['pagenotexist'] = '<p>Ein unerwarteter  Fehler ist aufgetreten, weil eine nicht existierende Seite aufgerufen wurde.</p>{$a}';
$string['pagenotexisttitle'] = 'Fehler 404: Datei nicht gefunden';
$string['pathdoesnotstartslash'] = 'Ungültige Argumente eingetragen. Pfad darf nicht mit Slash beginnen!';
$string['pleasereport'] = 'Wenn Sie etwas Zeit haben, informieren Sie uns bitte darüber, was Sie versucht haben, bevor der Fehler auftrat.';
$string['pluginrequirementsnotmet'] = 'Das Plugin "{$a->pluginname}" ({$a->pluginversion}) konnte nicht installiert werden. Es erfordert eine neuere Version von Moodle (Sie verwenden zur Zeit Version {$a->currentmoodle} - benötigt wird aber Version {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Das Plugin "{$a->pluginname}" {$a->pluginversion} unterstützt diese Version von Moodle {$a->moodleversion} nicht. Suchen Sie nach Plugin-Infos, um eine nutzbare Version zu finden.';
$string['prefixcannotbeempty'] = '<p>Fehler: Datenbanktabellen-Prefix kann nicht leer sein.({$a})</p>
<p>Administrator/innen müssen dieses Problem beseitigen.</p>';
$string['prefixtoolong'] = '<p>Fehler: Datenbanktabellen-Prefix ist zu lang ({$a->dbfamily})</p>
<p>Administrator/innen müssen dieses Problem anpassen. Tabellen- Prefixes in {$a->dbfamily} sind max. {$a->maxlength} Zeichen lang.</p>';
$string['privatefilesupload'] = 'Direktupload in die privaten Dateibereiche der Nutzer wird nicht mehr unterstützt. Upload in einen Entwurfsbereich und anschließende Verschiebung der Dateien mit core_user::add_user_private_files';
$string['processingstops'] = 'Der Prozess wurde an dieser Stelle gestoppt. Verbleibende Schritte wurden nicht mehr durchgeführt.';
$string['protected_cc_not_supported'] = 'Geschützte Cartridges werden nicht unterstützt.';
$string['querystringcannotbeempty'] = 'Der Abfragetext darf nicht leer sein.';
$string['redirecterrordetected'] = 'Nichtunterstützte Weiterleitung gefunden, Scriptausführung abgebrochen';
$string['refoundto'] = 'Kann ersetzt werden durch {$a}';
$string['refoundtoorigi'] = 'Ersetzt durch den Originalbetrag: {$a}';
$string['registrationdisabled'] = 'Registrierung ist auf dieser Seite deaktiviert';
$string['remotedownloaderror'] = '<p>Der Download auf Ihren Server konnte nicht ausgeführt werden. Prüfen Sie bitte die Proxy-Einstellungen, die PHP CURL Erweiterung wird dringend empfohlen.</p><p>Die Datei <a href="{$a->url}">{$a->url}</a> muss nun manuell herunter geladen, entpackt und auf den Server nach "{$a->dest}" kopiert werden. there.</p>';
$string['remotedownloadnotallowed'] = 'Der Download von Komponenten auf Ihren Server ist nicht erlaubt (allow_url_fopen ist deaktiviert). <br /><br /> Die Datei <a href="{$a->url}">{$a->url}</a> muss manuell heruntergeladen werden. Kopieren Sie die Datei nach "{$a->dest}" auf Ihren Server und entpacken Sie sie dort.';
$string['reportnotavailable'] = 'Dieser Berichtstyp ist nur für die Startseite verfügbar';
$string['requirecorrectaccess'] = 'Ungültige URL oder ungültiger Port';
$string['requireloginerror'] = 'Kurs oder Aktivität nicht benutzbar';
$string['restore_path_element_missingmethod'] = 'Die Wiederherstellungsmethode {$a} fehlt. Sie muss von den Entwickler/innen definiert werden.';
$string['restore_path_element_noobject'] = 'Wiederherstellungsobjekt {$a} ist kein Objekt.';
$string['restorechecksumfailed'] = 'Bei der Wiederherstellung sind Probleme aufgetreten. Bitte prüfen Sie die Einstellungen \'PHP memory limit\' und \'DB package size\'.';
$string['restrictedcontextexception'] = 'Missachtung von Kontextbeschränkungen beim Ausführen einer externen Funktion';
$string['restricteduser'] = 'Mit Ihrer aktuellen Anmeldung \'{$a}\' sind Sie nicht zu dieser Aktion berechtigt.';
$string['reverseproxyabused'] = 'Der Reverse Proxy ist aktiviert, so dass Sie nicht direkt auf den Server zugreifen können.<br />Wenden Sie bitte an die Server-Administrator/innen.';
$string['rpcerror'] = 'Ihre MNET-Verbindung ist fehlgeschlagen! Bitte leiten Sie die Fehlermeldung an die Administrato/innen weiter: {$a}';
$string['scheduledbackupsdisabled'] = 'Automatisch terminierte Backups wurden vom  Admin des Servers deaktiviert.';
$string['secretalreadyused'] = 'Der Link zum Bestätigen der Kennwortänderung wurde bereits benutzt. Das Kennwort wurde nicht geändert.';
$string['sectionnotexist'] = 'Dieser Abschnitt existiert nicht';
$string['sendmessage'] = 'Mitteilung senden';
$string['sendmessagesent'] = 'Danke für Ihr Feedback zu: <br>{$a}';
$string['serverconnection'] = 'Fehler beim Verbinden zum Server';
$string['servicedonotexist'] = 'Service existiert nicht';
$string['sessioncannotobtainlock'] = '<p>Die Sperre für die Sitzungs-ID {$a->id} konnte innerhalb von {$a->acquiretimeout} nicht aktiviert werden.</p>
<p>Wahrscheinlich läuft in einem anderen Browser-Tab eine andere Seite ({$a->whohaslock}) oder die Sperre wurde wegen eines Fehlers nicht freigegeben.</p>
<p>Sie können bis zum Timeout der Sitzungssperre ({$a->lockexpire}) warten oder Ihre Browsersitzung neu starten. Wenn dieser Fehler weiterhin besteht, fragen Sie bitte die Administrator/innen.</p>';
$string['sessioncookiesdisable'] = 'Fehlerhafte Verwendung von  require_key_login() - Session Cookie sollte deaktiviert werden!';
$string['sessiondiskfull'] = 'Die Session-Partition ist voll. Ein Login ist zurzeit nicht möglich. Bitte benachrichtigen Sie die Server-Administrator/innen.';
$string['sessionerroruser'] = 'Die Session ist abgelaufen. Melden Sie sich neu an.';
$string['sessionerroruser2'] = 'Ein Serverfehler ist aufgetreten, der Ihre Anmeldung betrifft. Melden Sie sich bitte neu an oder starten Sie Ihren Browser nochmal.';
$string['sessionexpired'] = 'Sitzung abgelaufen';
$string['sessionhandlerproblem'] = 'Der Session-Handler ist falsch konfiguriert';
$string['sessionipnomatch'] = 'Die IP-Adresse scheint sich seit Ihrem letzten Login geändert zu haben. Dieses Sicherheitsfeature schützt Sie vor dem Diebstahl Ihrer Identität durch Hacker, während Sie auf der Seite arbeiten. Normale Nutzer sollten diese Mitteilung nicht sehen - bitten Sie die Administrator/innen um Hilfe.';
$string['sessionipnomatch2'] = '<p>Ihre IP-Adresse hat sich geändert, seit Sie sich eingeloggt haben. Diese Sicherheitsoption schützt davor, dass Ihre Identität gestohlen werden kann, während Sie eingeloggt sind. Sie könnten diese Fehlermeldung auch erhalten, wenn Sie ein Funknetzwerk benutzen oder zwischen unterschiedlichen Netzwerken pendeln (roaming). Bitte fragen Sie für weitere Hilfe die Administrator/innen Ihrer Website. </p><p>Falls Sie weitermachen möchten, aktualisieren Sie bitte die Seite (F5-Taste).</p>';
$string['sessionwaiterr'] = 'Zeitüberschreitung beim Warten auf exklusiven Session-Zugriff.<br />Bitte warten Sie, bis Ihre laufenden Anfragen abgeschlossen sind, und versuchen Sie es anschließend nochmal.';
$string['shortnametaken'] = 'Kurzbezeichnung wird für anderen Kurs genutzt  ({$a})';
$string['sitepolicynotagreed'] = 'Datenschutzinformation nicht bestätigt. <a href="{$a}">Klicken Sie hier, um die Datenschutzinformation zu öffnen</a>.';
$string['socksnotsupported'] = 'SOCKS5 Proxy wird in PHP4 nicht unterstützt';
$string['spellcheckernotconf'] = 'Rechtschreibhilfe ist nicht eingerichtet';
$string['sslonlyaccess'] = 'Aus Sicherheitsgründen sind ausschließlich Verbindungen über HTTPS erlaubt.';
$string['statscatchupmode'] = 'Die Statistiken befinden sich im sogenannten Catchup-Modus. Bisher sind {$a->daysdone} Tage verarbeitet und {$a->dayspending} Tage werden noch bearbeitet. Prüfen Sie es später nochmal.';
$string['statsdisable'] = 'Statistik ist nicht aktiviert.';
$string['statsnodata'] = 'Für diesen Kurs liegen im genannten Zeitraum keine Daten vor.';
$string['storedfilecannotcreatefile'] = 'Die Datei kann nicht lokal angelegt werden. Überprüfen Sie die Dateirechte für moodledata und den verfügbaren Speicherplatz.';
$string['storedfilecannotcreatefiledirs'] = 'Das Verzeichnis kann nicht lokal angelegt werden. Bitte prüfen Sie die Dateirechte für moodledata.';
$string['storedfilecannotread'] = 'Die Datei kann nicht gelesen werden. Eventuell existiert sie nicht oder es gibt ein Rechteproblem.';
$string['storedfilecannotreadfile'] = 'Datei \'{$a}\' kann nicht gelesen werden. Entweder existiert die Datei nicht oder es gibt ein Berechtigungsproblem.';
$string['storedfilenotcreated'] = 'Die Datei kann nicht angelegt werden. {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Unbekannter Fehler mit lokalen Dateien ({$a})';
$string['tagdisabled'] = 'Tags sind deaktiviert!';
$string['tagnotfound'] = 'Der verwendete Tag wurde in der Datenbank nicht gefunden.';
$string['targetdatabasenotempty'] = 'Die Zieldatenbank ist nicht leer. Aus Sicherheitsgründen wurde die Übertragung abgebrochen.';
$string['textconditionsnotallowed'] = 'Ein Vergleich der Textspaltenbedingungen ist nicht zugelassen. Bitte verwenden Sie in Ihrer Abfrage sql_compare_text() . ';
$string['themenotinstall'] = 'Dieses Design ist nicht verfügbar!';
$string['tokengenerationfailed'] = 'Das neue Token kann nicht erzeugt werden';
$string['transactionvoid'] = 'Die Transaktion kann nicht geleert werden, weil sie bereits leer ist.';
$string['unenrolerror'] = 'Beim Abmelden der Person ist ein Fehler aufgetreten.';
$string['unicodeupgradeerror'] = 'Ihre Datenbank ist bisher nicht im Unicode-Format. Da die zu installierende Moodle-Version nicht in der Lage ist, Ihre Datenbank entsprechend umzuwandeln, müssten Sie zuerst auf Moodle 1.7.x aktualisieren und die Unicode-Umwandlung vornehmen. Anschließend sollte es problemlos möglich sein, auf Moodle {$a} umzusteigen.';
$string['unknowaction'] = 'Unbekannte Aktion!';
$string['unknowcategory'] = 'Kursbereich ist unbekannt!';
$string['unknowcontext'] = 'Dies ist ein unbekannter Kontext "{$a}" in get_child_contexts()!';
$string['unknowformat'] = 'Unbekanntes Format ({$a})';
$string['unknownbackupexporterror'] = 'Unbekannter Fehler bei der Importbearbeitung';
$string['unknownblockregion'] = 'Der Blockbereich \'{$a}\' ist auf dieser Seite nicht zugelassen';
$string['unknowncategory'] = 'Unbekannte Kategorie mit Kategorie-ID "{$a}"';
$string['unknowncontext'] = 'Unbekannter Kontext';
$string['unknowncourse'] = 'Unbekannter Kurs "{$a}"';
$string['unknowncourseidnumber'] = 'Unbekannte Kurs-ID "{$a}"';
$string['unknowncourserequest'] = 'Unbekannte Kursanfrage';
$string['unknowncoursesection'] = 'Unbekannter Kursabschnitt im Kurs "{$a}"';
$string['unknownevent'] = 'Unbekanntes Event';
$string['unknownfiletype'] = 'Fehler: unbekannter Filtertyp';
$string['unknowngroup'] = 'Unbekannte Gruppe \'{$a}\'';
$string['unknownhelp'] = 'Unbekanntes Hilfethema \'{$a}\'';
$string['unknownjsinrequirejs'] = 'Die JavaScript-Library \'{$a}\' kann nicht gefunden werden.';
$string['unknownmodulename'] = 'Unbekannter Modulname für das Formular';
$string['unknownrole'] = 'Unbekannte Rolle "{$a}"';
$string['unknownsortcolumn'] = 'Unbekannte Sortierungsspalte {$a}';
$string['unknownuseraction'] = 'Diese Nutzeraktion wurde nicht verstanden.';
$string['unknownuserselector'] = 'Unbekannter Nutzerauswähler';
$string['unknoworder'] = 'Unbekannte Anforderung';
$string['unknowparamtype'] = 'Unbekannter Parametertyp: {$a}';
$string['unknowquestiontype'] = 'Nicht unterstützter Fragetyp: {$a}';
$string['unknowuploadaction'] = 'Fehler: Unbekannter Uploadvorgang ({$a})';
$string['unspecifycourseid'] = 'Es muss die Kurs-ID, die Kurzbezeichnung oder ID-Nummer angegeben werden.';
$string['unsupportedevent'] = 'Ereignistyp wird nicht unterstützt';
$string['unsupportedstate'] = 'Abschlussstatus wird nicht unterstützt';
$string['unsupportedwebserver'] = 'Die Webserver-Software ({$a}) wird nicht unterstützt.';
$string['upgraderequires19'] = 'Fehler! Es wurde eine neue Moodle-Version auf dem Server installiert. Leider wird eine direkte Aktualisierung nicht unterstützt!<br/>Führen Sie zuerst eine Aktualisierung auf Moodle 1.9.19+ durch. Sie können auch zur bisher installierten Version zurückkehren, wenn Sie wieder die ursprünglichen Dateien installieren.';
$string['upgraderunning'] = 'Diese Website wird gerade aktualisiert. Versuchen Sie es später nochmal.';
$string['urlnotdefinerss'] = 'URL für RSS Feed nicht definiert';
$string['useradmineditadmin'] = 'Nur Administrator/innen können andere Administrationskonten bearbeiten.';
$string['useradminodelete'] = 'Nutzerkonten von Administrator/innen können nicht gelöscht werden.';
$string['userautherror'] = 'Unbekanntes Plugin zur Authentifizierung';
$string['userauthunsupported'] = 'Plugin zur Authentifizierung wird nicht unterstützt';
$string['useremailduplicate'] = 'Doppelte Adresse';
$string['userisfilteredout'] = 'Diese Person passt nicht zu den Filtern und Tabelleneinstellungen!';
$string['usermustbemnet'] = 'Nutzer/innen in der MNET-Zugangskontrolle müssen Remote-MNET-Nutzer/innen sein.';
$string['usernamelowercase'] = 'Der Anmeldename muss in Kleinbuchstaben sein';
$string['usernotaddederror'] = 'Fehler. Nutzer/in wurde nicht hinzugefügt';
$string['usernotaddedregistered'] = 'Nutzer wurde nicht hinzugefügt - er/sie war bereits registriert.';
$string['usernotavailable'] = 'Die Details für diese Person sind für Sie nicht verfügbar.';
$string['usernotdeletedadmin'] = 'Nutzerkonto nicht gelöscht. Nutzerkonten von Administrator/innen können nicht gelöscht werden.';
$string['usernotdeleteddeleted'] = 'Dieses Nutzerkonto ist bereits gelöscht.';
$string['usernotdeletederror'] = 'Nutzer/in nicht gelöscht. Unbekannter Fehler';
$string['usernotdeletedmissing'] = 'Nutzer/in nicht gelöscht. Der Anmeldename wurde nicht gefunden';
$string['usernotdeletedoff'] = 'Nutzer/in nicht gelöscht - Löschen ist nicht erlaubt';
$string['usernotfullysetup'] = 'Nutzerkonto unvollständig';
$string['usernotincourse'] = 'Nutzer/in ist nicht in diesem Kurs!';
$string['usernotrenamedadmin'] = 'Administrationskonten können nicht umbenannt werden.';
$string['usernotrenamedexists'] = 'Nutzer/in wurde nicht umbenannt - der eingegebene Nutzername wird bereits verwendet';
$string['usernotrenamedmissing'] = 'Nutzer/in nicht umbenannt. Der alte Anmeldename wurde nicht gefunden.';
$string['usernotrenamedoff'] = 'Nutzer/in nicht umbenannt - Umbenennen ist nicht erlaubt.';
$string['usernotupdatedadmin'] = 'Administrationskonten können nicht aktualisiert werden.';
$string['usernotupdatederror'] = 'Nutzer/in nicht aktualisiert. Unbekannter Fehler';
$string['usernotupdatednotexists'] = 'Nutzer/in nicht aktualisiert. Das Nutzerkonto existiert nicht.';
$string['userquotalimit'] = 'Sie haben die Obergrenze für Ihren Datenquota erreicht.';
$string['userselectortoomany'] = 'Die Auswahl user_selector erhielt mehr als eine/n ausgewählten Nutzer/in, obwohl die Mehrfachauswahl (multiselect) deaktiviert ist.';
$string['verifyagedigitalconsentnotpossible'] = 'Die Überprüfung des Alters ist derzeit nicht möglich.';
$string['wrongcall'] = 'Das Skript wurde falsch aufgerufen';
$string['wrongcontextid'] = 'Kontext-ID war falsch (konnte nicht gefunden werden)';
$string['wrongdestpath'] = 'Falscher Pfad';
$string['wrongroleid'] = 'Falsche Rollen-ID';
$string['wrongsourcebase'] = 'Falsche URL-Quelle';
$string['wrongusernamepassword'] = 'Nutzer/in oder Kennwort falsch';
$string['wrongzipfilename'] = 'Falscher ZIP-Dateiname';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Kurs nicht erstellt - fehlende Berechtigung';
$string['wwwrootmismatch'] = 'Ein falscher Zugriff wurde festgestellt. Entschuldigung, aber auf diesen Server sollte ausschließlich über die Adresse "{$a}" zugegriffen werden. Bitte benachrichtigen Sie die Administrator/innen Ihres Servers.';
$string['wwwrootslash'] = 'In der Datei config.php wurde eine falsche Einstellung für $CFG->wwwroot festgestellt. Es darf kein abschließender Slash \'/\' gesetzt sein.<br />Bitte benachrichtigen Sie die Administrator/innen Ihres Servers.';
$string['xmldberror'] = 'XMLDB-Fehler!';
$string['youcannotdeletecategory'] = 'Sie können den Kursbereich "{$a}" nicht löschen, da Sie seinen Inhalt weder löschen noch verschieben können.';
