<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'ro', version '4.1'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresă';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Inserează/ editează ancora';
$string['advanced:backcolor_desc'] = 'Selectați culoarea fundalului';
$string['advanced:block'] = 'Format';
$string['advanced:blockquote'] = 'Blochează citatul';
$string['advanced:blockquote_desc'] = 'Blochează citatul';
$string['advanced:bold_desc'] = 'Bold (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Inserează/ elimină lista numerotată';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Inserează caractere speciale';
$string['advanced:cleanup_desc'] = 'Remediere cod incorect';
$string['advanced:clipboard_msg'] = 'Copierea/decuparea/inserarea nu este disponibilă în Mozilla și Firefox.
Doriți informații suplimentare cu privire la acest aspect?';
$string['advanced:code'] = 'Cod';
$string['advanced:code_desc'] = 'Editează sursa HTML';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Copiază';
$string['advanced:custom1_desc'] = 'Descrierea dumneavoastră personalizată aici';
$string['advanced:cut_desc'] = 'Taie';
$string['advanced:dd'] = 'Descriere definiție';
$string['advanced:div'] = 'DIV';
$string['advanced:dt'] = 'Termeni definiție';
$string['advanced:font_size'] = 'Dimensiune font';
$string['advanced:fontdefault'] = 'Fontul family';
$string['advanced:forecolor_desc'] = 'Selectați culoarea textului';
$string['advanced:h1'] = 'Titlul 1';
$string['advanced:h2'] = 'Titlul 2';
$string['advanced:h3'] = 'Titlul 3';
$string['advanced:h4'] = 'Titlul 4';
$string['advanced:h5'] = 'Titlul 5';
$string['advanced:h6'] = 'Titlul 6';
$string['advanced:help_desc'] = 'Asistență';
$string['advanced:help_shortcut'] = 'Apăsați ALT-F10 pentru bara de instrumente. Apăsați ALT-0 pentru asistență';
$string['advanced:hr_desc'] = 'Inserează linie orizontală';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Inserează/ editează imagine';
$string['advanced:image_props_desc'] = 'Proprietăți imagine';
$string['advanced:indent_desc'] = 'Mărește spațiul';
$string['advanced:italic_desc'] = 'Italic (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Aliniază spre centru';
$string['advanced:justifyfull_desc'] = 'Aliniază complet';
$string['advanced:justifyleft_desc'] = 'Aliniază spre stânga';
$string['advanced:justifyright_desc'] = 'Aliniază spre dreapta';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '';
$string['advanced:link_desc'] = 'Inserează/ editează link';
$string['advanced:more_colors'] = 'Mai multe culori...';
$string['advanced:newdocument'] = 'Ești sigur că doriți să ștergeți toate conținuturile?';
$string['advanced:newdocument_desc'] = 'Document nou';
$string['advanced:numlist_desc'] = 'Inserează/ elimină lista numerotată';
$string['advanced:outdent_desc'] = 'Micșorează spațiul';
$string['advanced:paragraph'] = 'Paragraf';
$string['advanced:paste_desc'] = 'Lipește';
$string['advanced:path'] = 'Cale';
$string['advanced:pre'] = 'Preformatat';
$string['advanced:redo_desc'] = 'Reface (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Elimină formatarea';
$string['advanced:rich_text_area'] = 'Zonă rich text';
$string['advanced:samp'] = 'Eșantion cod';
$string['advanced:shortcuts_desc'] = 'Asistență accesibilitate';
$string['advanced:striketrough_desc'] = 'Strikethrough';
$string['advanced:style_select'] = 'Stiluri';
$string['advanced:sub_desc'] = 'Subliniat';
$string['advanced:sup_desc'] = 'Superscript';
$string['advanced:toolbar'] = 'Bară de instrumente';
$string['advanced:toolbar_focus'] = 'Treci la butoanele de instrumente - Alt+Q, treci la editor - Alt-Z, treci la cale element - Alt-X';
$string['advanced:underline_desc'] = 'Subliniază (Ctrl+U)';
$string['advanced:undo_desc'] = 'Anulează (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Deconectare';
$string['advanced:visualaid_desc'] = 'Afișează/ ascunde liniile directoare/elementele invizibile';
$string['advanced_dlg:'] = '';
$string['advanced_dlg:about_author'] = 'Autor';
$string['advanced_dlg:about_general'] = 'Despre';
$string['advanced_dlg:about_help'] = 'Asistență';
$string['advanced_dlg:about_license'] = 'Licență';
$string['advanced_dlg:about_loaded'] = 'Plugin-uri încărcate';
$string['advanced_dlg:about_plugin'] = 'Plugin';
$string['advanced_dlg:about_plugins'] = 'Plugin';
$string['advanced_dlg:about_title'] = 'Despre TinyMCE';
$string['advanced_dlg:about_version'] = 'Versiune';
$string['advanced_dlg:accessibility_help'] = 'Asistență accesibilitate';
$string['advanced_dlg:accessibility_usage_title'] = 'Utilizarea generală';
$string['advanced_dlg:anchor_invalid'] = 'Vă rugăm să specificați un nume valabil al ancorei.';
$string['advanced_dlg:anchor_name'] = 'Nume ancoră';
$string['advanced_dlg:anchor_title'] = 'Inserează/ editează ancora';
$string['advanced_dlg:charmap_title'] = 'Selectează caracterul special';
$string['advanced_dlg:charmap_usage'] = 'Utilizați săgețile stânga și dreapta, pentru a naviga.';
$string['advanced_dlg:code_title'] = 'Editor sursă HTML';
$string['advanced_dlg:code_wordwrap'] = 'Împachetarea textului';
$string['advanced_dlg:colorpicker_color'] = 'Culoare:';
$string['advanced_dlg:colorpicker_name'] = 'Nume:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Numit';
$string['advanced_dlg:colorpicker_named_title'] = 'Culorile menționate';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paletă';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paletă culori';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Picker';
$string['advanced_dlg:colorpicker_picker_title'] = 'culoare picker';
$string['advanced_dlg:colorpicker_title'] = 'Selectați o culoare';
$string['advanced_dlg:image_align'] = 'Aliniere';
$string['advanced_dlg:image_align_baseline'] = 'Bază';
$string['advanced_dlg:image_align_bottom'] = 'Partea inferioară';
$string['advanced_dlg:image_align_left'] = 'Stânga';
$string['advanced_dlg:image_align_middle'] = 'Centru';
$string['advanced_dlg:image_align_right'] = 'Dreapta';
$string['advanced_dlg:image_align_textbottom'] = 'Partea inferioară a textului';
$string['advanced_dlg:image_align_texttop'] = 'Partea superioară a textului';
$string['advanced_dlg:image_align_top'] = 'Partea superioară';
$string['advanced_dlg:image_alt'] = 'Descrierea imaginii';
$string['advanced_dlg:image_border'] = 'Margini';
$string['advanced_dlg:image_dimensions'] = 'Dimensiuni';
$string['advanced_dlg:image_hspace'] = 'Spațiu orizontal';
$string['advanced_dlg:image_list'] = 'Lista imaginilor';
$string['advanced_dlg:image_src'] = 'Adresa URL a imaginii';
$string['advanced_dlg:image_title'] = 'Inserează/ editează imaginea';
$string['advanced_dlg:image_vspace'] = 'Spațiu vertical';
$string['advanced_dlg:invalid_color_value'] = 'Valoare invalidă a culorii';
$string['advanced_dlg:link_is_email'] = 'Adresa URL pe care ați introdus-o pare să fie o adresă e-mail. Doriți să introduceți destinatul obligatoriu: prefix?';
$string['advanced_dlg:link_is_external'] = 'Adresa URL pe care ați introdus-o pare să fie un link extern. Doriți să introduceți http obligatoriu:// prefix?';
$string['advanced_dlg:link_list'] = 'Listă link';
$string['advanced_dlg:link_target'] = 'Țintă';
$string['advanced_dlg:link_target_blank'] = 'Deschideți link-ul într-o nouă fereastră';
$string['advanced_dlg:link_target_same'] = 'Deschideți link-ul în aceeași fereastră';
$string['advanced_dlg:link_title'] = 'Inserează/ editează link';
$string['advanced_dlg:link_titlefield'] = 'Denumire';
$string['advanced_dlg:link_url'] = 'Link URL';
$string['advhr:advhr_desc'] = 'Inserați linie orizontală';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '';
$string['advhr_dlg:normal'] = 'Normal';
$string['advhr_dlg:noshade'] = 'Fără umbră';
$string['advhr_dlg:size'] = 'Înălțime';
$string['advhr_dlg:width'] = 'Lățime';
$string['advhr_dlg:widthunits'] = 'Unități';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '';
$string['advimage:image_desc'] = 'Inserează/ editează imagine';
$string['advimage_dlg:align'] = 'Aliniere';
$string['advimage_dlg:align_baseline'] = 'Linie de bază';
$string['advimage_dlg:align_bottom'] = 'Partea inferioară';
$string['advimage_dlg:align_left'] = 'Stânga';
$string['advimage_dlg:align_middle'] = 'Centru';
$string['advimage_dlg:align_right'] = 'Dreapta';
$string['advimage_dlg:align_textbottom'] = 'Partea inferioară a textului';
$string['advimage_dlg:align_texttop'] = 'Partea superioară a textului';
$string['advimage_dlg:align_top'] = 'Partea superioară';
$string['advimage_dlg:alt'] = 'Descriere imagine';
$string['advimage_dlg:alt_image'] = 'Imagine alternativă';
$string['advimage_dlg:border'] = 'Margini';
$string['advimage_dlg:classes'] = 'Clase';
$string['advimage_dlg:constrain_proportions'] = 'Limitați proporțiile';
$string['advimage_dlg:dialog_title'] = 'Inserează/ editează imaginea';
$string['advimage_dlg:dimensions'] = 'Dimensiuni';
$string['advimage_dlg:example_img'] = 'Imagine de previzualizare a aspectului';
$string['advimage_dlg:general'] = 'General';
$string['advimage_dlg:height'] = 'Înălțime';
$string['advimage_dlg:hspace'] = 'Spațiu orizontal';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Listă imagini';
$string['advimage_dlg:langcode'] = 'Cod limbă';
$string['advimage_dlg:langdir'] = 'Direcție scris';
$string['advimage_dlg:list'] = 'Listă imagini';
$string['advimage_dlg:long_desc'] = 'Link descriere detaliată';
$string['advimage_dlg:ltr'] = 'De la stânga spre dreapta';
$string['advimage_dlg:map'] = 'Hartă imagini';
$string['advimage_dlg:misc'] = 'Diverse';
$string['advimage_dlg:missing_alt'] = 'Ești sigur că vrei să continui fără a include o descriere a imaginii? Fără aceasta este posibil ca imaginea să nu fie disponibilă pentru unii utilizatori cu dizabilități, pentru cei care utilizează un browser de text sau care navighează pe Web având imaginile dezactivate.';
$string['advimage_dlg:mouseout'] = 'pentru mouse out';
$string['advimage_dlg:mouseover'] = 'pentru mouse over';
$string['advimage_dlg:preview'] = 'Previzualizare';
$string['advimage_dlg:rtl'] = 'De la dreapta la stânga';
$string['advimage_dlg:src'] = 'Adresa URL a imaginii';
$string['advimage_dlg:style'] = 'Stil';
$string['advimage_dlg:swap_image'] = 'Schimbare imagine';
$string['advimage_dlg:tab_advanced'] = 'Avansat';
$string['advimage_dlg:tab_appearance'] = 'Aspect';
$string['advimage_dlg:tab_general'] = 'General';
$string['advimage_dlg:title'] = 'Denumire';
$string['advimage_dlg:vspace'] = 'Spațiu vertical';
$string['advimage_dlg:width'] = 'Lățime';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '';
$string['advlink:link_desc'] = 'Inserează/ editează link';
$string['advlink_dlg:accesskey'] = 'AccessKey';
$string['advlink_dlg:advanced_props'] = 'Proprietăți avansate';
$string['advlink_dlg:advanced_tab'] = 'Avansat';
$string['advlink_dlg:anchor_names'] = 'Ancore';
$string['advlink_dlg:classes'] = 'Clase';
$string['advlink_dlg:encoding'] = 'Codificarea caracterelor țintă';
$string['advlink_dlg:event_props'] = 'Evenimente';
$string['advlink_dlg:events_tab'] = 'Evenimente';
$string['advlink_dlg:general_props'] = 'Proprietăți generală';
$string['advlink_dlg:general_tab'] = 'General';
$string['advlink_dlg:height'] = 'Înălțime';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Adresa URL pe care ați introdus-o pare să fie o adresă e-mail. Doriți să introduceți destinatul obligatoriu: prefix?';
$string['advlink_dlg:is_external'] = 'Adresa URL pe care ați introdus-o pare să fie un link extern. Doriți să introduceți http obligatoriu:// prefix?';
$string['advlink_dlg:langcode'] = 'Cod limbă';
$string['advlink_dlg:langdir'] = 'Direcție scris';
$string['advlink_dlg:link_list'] = 'Listă link';
$string['advlink_dlg:list'] = 'Listă link';
$string['advlink_dlg:ltr'] = 'De la stânga la dreapta';
$string['advlink_dlg:mime'] = 'Tipul MIME vizat';
$string['advlink_dlg:popup'] = 'Fereastră popup JavaScript';
$string['advlink_dlg:popup_dependent'] = 'Dependent (numai Mozilla/Firefox)';
$string['advlink_dlg:popup_location'] = 'Afișează bara de localizare';
$string['advlink_dlg:popup_menubar'] = 'Afișează bara de meniu';
$string['advlink_dlg:popup_name'] = 'Nume fereastră';
$string['advlink_dlg:popup_opts'] = 'Opțiuni';
$string['advlink_dlg:popup_position'] = 'Poziție (X/Y)';
$string['advlink_dlg:popup_props'] = 'Proprietăți popup';
$string['advlink_dlg:popup_resizable'] = 'Faceți fereastra redimensionabilă';
$string['advlink_dlg:popup_return'] = 'Inserați \'reveniți fals\\';
$string['advlink_dlg:popup_scrollbars'] = 'Afișează barele derulante';
$string['advlink_dlg:popup_size'] = 'Dimensiune';
$string['advlink_dlg:popup_statusbar'] = 'Afișează bara de status';
$string['advlink_dlg:popup_tab'] = 'Popup';
$string['advlink_dlg:popup_toolbar'] = 'Afișează barele de instrumente';
$string['advlink_dlg:popup_url'] = 'Popup URL';
$string['advlink_dlg:rel'] = 'Relaționează pagina cu ținta';
$string['advlink_dlg:rev'] = 'Relaționează ținta cu pagina';
$string['advlink_dlg:rtl'] = 'De la dreapta spre stânga';
$string['advlink_dlg:style'] = 'Stil';
$string['advlink_dlg:tabindex'] = 'TabIndex';
$string['advlink_dlg:target'] = 'Țintă';
$string['advlink_dlg:target_blank'] = 'Deschide într-o fereastră nouă';
$string['advlink_dlg:target_langcode'] = 'Limbă țintă';
$string['advlink_dlg:target_name'] = 'Nume țintă';
$string['advlink_dlg:target_parent'] = 'Deschide într-o fereastră/ cadru părinte';
$string['advlink_dlg:target_same'] = 'Deschide în această fereastră/ cadru';
$string['advlink_dlg:target_top'] = 'Deschide în cadrul superior (înlocuiește toate cadrele)';
$string['advlink_dlg:title'] = 'Inserează/ editează link';
$string['advlink_dlg:titlefield'] = 'Denumire';
$string['advlink_dlg:url'] = 'Link URL';
$string['advlink_dlg:width'] = 'Lățime';
$string['advlist:circle'] = 'Cerc';
$string['advlist:def'] = 'Implicit';
$string['advlist:disc'] = 'Disc';
$string['advlist:lower_alpha'] = 'Alfa inferior';
$string['advlist:lower_greek'] = 'Greacă inferior';
$string['advlist:lower_roman'] = 'Roman inferior';
$string['advlist:square'] = 'Pătrat';
$string['advlist:types'] = 'Tipuri';
$string['advlist:upper_alpha'] = 'Upper alpha';
$string['advlist:upper_roman'] = 'Upper roman';
$string['aria:rich_text_area'] = 'Editor de text';
$string['autosave:restore_content'] = 'Restaurează conținutul salvat automat';
$string['autosave:unload_msg'] = 'Modificările pe care le-ați făcut se vor pierde în momentul în care părăsiți această pagină.';
$string['autosave:warning_message'] = 'Dacă restabiliți conținutul salvat, veți pierde tot conținutul aflat în prezent în editor.

Sunteți sigur că doriți să restabiliți conținutul salvat?';
$string['availablebuttons'] = 'Butoane disponibile';
$string['colors:000000'] = 'Înapoi';
$string['colors:000080'] = 'Albastru navy';
$string['colors:0000FF'] = 'Albastru';
$string['colors:003300'] = 'Verde închis';
$string['colors:003366'] = 'Bleu închis';
$string['colors:008000'] = 'Verde';
$string['colors:008080'] = 'Teal';
$string['colors:00CCFF'] = 'Sky blue';
$string['colors:00FF00'] = 'Lime';
$string['colors:00FFFF'] = 'Aqua';
$string['colors:333300'] = 'Olive închis';
$string['colors:333333'] = 'Gri foarte închis';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Albastru regal';
$string['colors:339966'] = 'Verde mare';
$string['colors:33CCCC'] = 'Turcoaz';
$string['colors:666699'] = 'Albastru cenușiu';
$string['colors:800000'] = 'Maro';
$string['colors:800080'] = 'Violet';
$string['colors:808000'] = 'Olive';
$string['colors:808080'] = 'Gri';
$string['colors:993300'] = 'Portocaliu ars';
$string['colors:993366'] = 'Maro';
$string['colors:999999'] = '';
$string['colors:99CC00'] = 'Galben verde';
$string['colors:99CCFF'] = 'Albastru deschis';
$string['colors:C0C0C0'] = 'Argintiu';
$string['colors:CC99FF'] = 'Prună';
$string['colors:CCFFCC'] = 'Verde pal';
$string['colors:CCFFFF'] = 'Cyan pal';
$string['colors:FF0000'] = 'Roșu';
$string['colors:FF00FF'] = 'Magenta';
$string['colors:FF6600'] = 'Portocaliu';
$string['colors:FF9900'] = 'Ambră';
$string['colors:FF99CC'] = 'Roz';
$string['colors:FFCC00'] = 'Auriu';
$string['colors:FFCC99'] = 'Piersică';
$string['colors:FFFF00'] = 'Galben';
$string['colors:FFFF99'] = 'Galben deschis';
$string['colors:FFFFFF'] = 'Alb';
$string['common:apply'] = 'Aplică';
$string['common:browse'] = 'Răsfoiește';
$string['common:cancel'] = 'Anulare';
$string['common:class_name'] = 'Clasă';
$string['common:clipboard_msg'] = 'Copierea/tăierea/inserarea nu este aplicabilă în Mozilla și Firefox.
Doriți mai multe informații cu privire la acest aspect?';
$string['common:clipboard_no_support'] = 'În prezent nu este acceptat de browser-ul dumneavoastră, puteți folosi comenzile rapide de pe tastatură.';
$string['common:close'] = 'Închide';
$string['common:edit_confirm'] = 'Doriți să utilizați modul WYSIWYG pentru această zonă de text?';
$string['common:insert'] = 'Inserează';
$string['common:invalid_data'] = 'Eroare: Au fost introduse valori invalide,acestea sunt marcate cu roșu.';
$string['common:invalid_data_min'] = '{#field} trebuie să fie un număr mare decât {#min}';
$string['common:invalid_data_number'] = '{#field} trebuie să fie un număr';
$string['common:invalid_data_size'] = '{#field} trebuie să fie un număr sau un procent';
$string['common:more_colors'] = 'Mai multe culori...';
$string['common:not_set'] = '-- Nu este setat --';
$string['common:popup_blocked'] = 'Ne pare rău, dar am observat că fereastra pop-up de blocare a dezactivat o fereastră care asigură funcționalitatea aplicației. Trebuie să dezactivați fereastra pop-up de blocare de pe acest site pentru a putea utiliza complet acest instrument.';
$string['common:update'] = 'Actualizare';
$string['common:value'] = '(valoare)';
$string['contextmenu:align'] = 'Aliniere';
$string['contextmenu:center'] = 'Centru';
$string['contextmenu:full'] = 'Complet';
$string['contextmenu:left'] = 'Stânga';
$string['contextmenu:right'] = 'Dreapta';
$string['customconfig'] = 'Configurare personalizată';
$string['customconfig_desc'] = 'Personalizați configurarea TinyMCE avansată în format JSON, de exemplu: {"opțiunea1" : "valoarea2", "opțiunea2" : "valoarea2"}. Opțiunile specificate aici vor anula setările standard plugin.';
$string['customtoolbar'] = 'Bară de instrumente editor';
$string['customtoolbar_desc'] = 'Fiecare linie conține o listă de nume de butoane separate prin virgulă, liniile goale fiind goale. Vezi <a href="{$a}" target="_blank">{$a}</a> pentru lista de butoane TinyMCE implicite.<br />Primul rând va fi afișat mereu, în timp ce vizibilitatea celei de-a două și de-a treia bare de instrumentepoate fi modificată.';
$string['directionality:ltr_desc'] = 'Direcția de la stânga la dreapta';
$string['directionality:rtl_desc'] = 'Direcția de la dreapta la stânga';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Emoții';
$string['emotions_dlg:cool'] = 'Cool';
$string['emotions_dlg:cry'] = 'Plâns';
$string['emotions_dlg:desc'] = 'Emoții';
$string['emotions_dlg:embarassed'] = 'Încurcat';
$string['emotions_dlg:foot_in_mouth'] = 'Năzdrăvănie';
$string['emotions_dlg:frown'] = 'Încruntat';
$string['emotions_dlg:innocent'] = 'Inocent';
$string['emotions_dlg:kiss'] = 'Sărut';
$string['emotions_dlg:laughing'] = 'Râset';
$string['emotions_dlg:money_mouth'] = 'Money mouth';
$string['emotions_dlg:sealed'] = 'Sigilat';
$string['emotions_dlg:smile'] = 'Zâmbet';
$string['emotions_dlg:surprised'] = 'Surprins';
$string['emotions_dlg:title'] = 'Inserează';
$string['emotions_dlg:tongue_out'] = 'Limbă scoasă';
$string['emotions_dlg:undecided'] = 'Indecis';
$string['emotions_dlg:usage'] = 'Utilizați săgeata stăngă și săgeata dreaptă pentru a naviga.';
$string['emotions_dlg:wink'] = 'A face cu ochiul';
$string['emotions_dlg:yell'] = 'Țipăt';
$string['fontselectlist'] = 'Lista fonturilor disponibile';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '';
$string['fullpage:desc'] = 'Proprietăți document';
$string['fullpage_dlg:active_color'] = 'Culoare activă';
$string['fullpage_dlg:add'] = 'Adăugați un element nou';
$string['fullpage_dlg:add_base'] = 'Element de bază';
$string['fullpage_dlg:add_comment'] = 'Nod comentariu';
$string['fullpage_dlg:add_link'] = 'Element link';
$string['fullpage_dlg:add_meta'] = 'Element meta';
$string['fullpage_dlg:add_script'] = 'Element script';
$string['fullpage_dlg:add_style'] = 'Element stil';
$string['fullpage_dlg:add_title'] = 'Element titlu';
$string['fullpage_dlg:advanced_props'] = 'Avansat';
$string['fullpage_dlg:advanced_tab'] = 'Avansat';
$string['fullpage_dlg:appearance_bgprops'] = 'Proprietăți fundal';
$string['fullpage_dlg:appearance_linkprops'] = 'Culori link';
$string['fullpage_dlg:appearance_marginprops'] = 'Margini conținut';
$string['fullpage_dlg:appearance_style'] = 'Proprietăți foaie și stil';
$string['fullpage_dlg:appearance_tab'] = 'Aspect';
$string['fullpage_dlg:appearance_textprops'] = 'Proprietăți text';
$string['fullpage_dlg:author'] = 'Autor';
$string['fullpage_dlg:base_element'] = 'Element de bază';
$string['fullpage_dlg:bgcolor'] = 'Culoare fundal';
$string['fullpage_dlg:bgimage'] = 'Imagine fundal';
$string['fullpage_dlg:bottom_margin'] = 'Marginea inferioară';
$string['fullpage_dlg:charset'] = 'Set de caractere';
$string['fullpage_dlg:comment_element'] = 'Comentariu';
$string['fullpage_dlg:content'] = 'Conținut';
$string['fullpage_dlg:copyright'] = 'Drepturi de autor';
$string['fullpage_dlg:defer'] = 'Amânare';
$string['fullpage_dlg:doctypes'] = 'Tip document';
$string['fullpage_dlg:encoding'] = 'Codificare caractere';
$string['fullpage_dlg:font_face'] = 'Aspect font';
$string['fullpage_dlg:font_size'] = 'Dimensiune font';
$string['fullpage_dlg:fontface'] = 'Familie font';
$string['fullpage_dlg:fontsize'] = 'Dimensiune font';
$string['fullpage_dlg:general_props'] = 'General';
$string['fullpage_dlg:head_elements'] = 'Elemente titlu';
$string['fullpage_dlg:hover_color'] = 'Culoare';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'Limbă HREF';
$string['fullpage_dlg:info'] = 'Informații';
$string['fullpage_dlg:langcode'] = 'Cod limbă';
$string['fullpage_dlg:langdir'] = 'Direcție scris';
$string['fullpage_dlg:langprops'] = 'Limbă și codificare';
$string['fullpage_dlg:language'] = 'Limbă';
$string['fullpage_dlg:left_margin'] = 'Marginea stângă';
$string['fullpage_dlg:link_color'] = 'Culoare link';
$string['fullpage_dlg:link_element'] = 'Element link';
$string['fullpage_dlg:ltr'] = 'De la stânga la dreapta';
$string['fullpage_dlg:media'] = 'Media';
$string['fullpage_dlg:meta_description'] = 'descriere';
$string['fullpage_dlg:meta_element'] = 'element meta';
$string['fullpage_dlg:meta_index_follow'] = 'Indexați și urmați link-urile';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indexați și nu urmați link-urile';
$string['fullpage_dlg:meta_keywords'] = 'Tastatură';
$string['fullpage_dlg:meta_noindex_follow'] = 'Nu indexați, dar urmați link-urile';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Nu indexați și nu urmați link-urile';
$string['fullpage_dlg:meta_props'] = 'Informații meta';
$string['fullpage_dlg:meta_robots'] = 'Roboți';
$string['fullpage_dlg:meta_tab'] = 'General';
$string['fullpage_dlg:meta_title'] = 'Denumire';
$string['fullpage_dlg:movedown'] = 'Deplasează elementul selectat mai jos';
$string['fullpage_dlg:moveup'] = 'Deplasează elementul selectat mai sus';
$string['fullpage_dlg:name'] = 'Nume';
$string['fullpage_dlg:properties'] = 'Proprietăți';
$string['fullpage_dlg:rel'] = 'Rel';
$string['fullpage_dlg:remove'] = 'Elimină elementul selectat';
$string['fullpage_dlg:rev'] = 'Rev';
$string['fullpage_dlg:right_margin'] = 'Marginea dreaptă';
$string['fullpage_dlg:rtl'] = 'De la dreapta la stânga';
$string['fullpage_dlg:script_element'] = 'Element script';
$string['fullpage_dlg:src'] = 'Sursă';
$string['fullpage_dlg:style'] = 'Stil';
$string['fullpage_dlg:style_element'] = 'Element stil';
$string['fullpage_dlg:stylesheet'] = 'Stil foaie';
$string['fullpage_dlg:target'] = 'Țintă';
$string['fullpage_dlg:text_color'] = 'Culoare text';
$string['fullpage_dlg:textcolor'] = 'Culoare';
$string['fullpage_dlg:title'] = 'Proprietăți document';
$string['fullpage_dlg:title_element'] = 'Element titlu';
$string['fullpage_dlg:top_margin'] = 'Marginea superioară';
$string['fullpage_dlg:type'] = 'Tip';
$string['fullpage_dlg:value'] = 'Valoare';
$string['fullpage_dlg:visited_color'] = 'Culoare vizitată';
$string['fullpage_dlg:xml_pi'] = 'Declarație XML';
$string['fullscreen:desc'] = 'Comutați pe modul ecran complet';
$string['iespell:download'] = 'Ortografia nedetectată. Doriți să instalați acum?';
$string['iespell:iespell_desc'] = 'Verifică ortografia';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Duminică, luni, marți, miercuri, joi, vineri, sâmbătă, duminică';
$string['insertdatetime:day_short'] = 'Du, lu, ma, mi, joi, vi, sâ, du';
$string['insertdatetime:insertdate_desc'] = 'Inserează data';
$string['insertdatetime:inserttime_desc'] = 'Inserează ora';
$string['insertdatetime:months_long'] = 'Ianuarie, februarie, martie, aprilie, mai, iunie, iulie, august, septembrie, octombrie, noiembrie, decembrie';
$string['insertdatetime:months_short'] = 'Ian, feb, mart, apr, mai, iun, iul, aug, sept, oct, nov, dec';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Modificați poziționarea absolută';
$string['layer:backward_desc'] = 'Înapoi';
$string['layer:content'] = 'Rând nou...';
$string['layer:forward_desc'] = 'Înainte';
$string['layer:insertlayer_desc'] = 'Inserează rând nou';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '';
$string['media:desc'] = 'Inserează/ editează media încorporată';
$string['media:edit'] = 'Editează media încorporată';
$string['media_dlg:advanced'] = 'Avansat';
$string['media_dlg:align'] = 'Aliniază';
$string['media_dlg:align_bottom'] = 'Partea inferioară';
$string['media_dlg:align_bottom_left'] = 'Partea inferioară stânga';
$string['media_dlg:align_bottom_right'] = 'Partea inferioară dreapta';
$string['media_dlg:align_center'] = 'Centru';
$string['media_dlg:align_left'] = 'Stânga';
$string['media_dlg:align_right'] = 'Dreapta';
$string['media_dlg:align_top'] = 'Partea superioară';
$string['media_dlg:align_top_left'] = 'Partea superioară stânga';
$string['media_dlg:align_top_right'] = 'Partea superioară dreapta';
$string['media_dlg:altsource1'] = 'Sursă alternativă 1';
$string['media_dlg:altsource2'] = 'Sursă alternativă 2';
$string['media_dlg:audio'] = 'Audio HTML5';
$string['media_dlg:autogotourl'] = 'Mergi automat la adresa URL';
$string['media_dlg:autohref'] = 'HREF automat';
$string['media_dlg:autostart'] = 'Pornire automată';
$string['media_dlg:balance'] = 'Echilibrează';
$string['media_dlg:base'] = 'Bază';
$string['media_dlg:baseurl'] = 'Adresă URL de bază';
$string['media_dlg:bgcolor'] = 'Fundal';
$string['media_dlg:cache'] = 'Cache';
$string['media_dlg:captioningid'] = 'Furnizare ID';
$string['media_dlg:center'] = 'Centru';
$string['media_dlg:class_name'] = 'Clasă';
$string['media_dlg:console'] = 'Consolă';
$string['media_dlg:constrain_proportions'] = 'Limitare proporții';
$string['media_dlg:controller'] = 'Controler';
$string['media_dlg:controls'] = 'Controale';
$string['media_dlg:correction'] = 'Nicio corecție';
$string['media_dlg:currentmarker'] = 'Marker curent';
$string['media_dlg:currentposition'] = 'Poziție curentă';
$string['media_dlg:defaultframe'] = 'Cadru implicit';
$string['media_dlg:embedded_audio_options'] = 'Opțiuni audio încorporate';
$string['media_dlg:embeddedaudio'] = 'Audio încorporat';
$string['media_dlg:enabled'] = 'Activat';
$string['media_dlg:enablejavascript'] = 'Activează JavaScript';
$string['media_dlg:endtime'] = 'Data încheierii';
$string['media_dlg:file'] = 'Fișier/URL';
$string['media_dlg:flash'] = 'Flash';
$string['media_dlg:flash_options'] = 'Opțiuni flash';
$string['media_dlg:flashvars'] = 'Variații flash';
$string['media_dlg:fullscreen'] = 'Ecran complet';
$string['media_dlg:general'] = 'General';
$string['media_dlg:hidden'] = 'Ascuns';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Spațiul H';
$string['media_dlg:html5_audio_options'] = 'Opțiuni audio';
$string['media_dlg:html5_video_options'] = 'Opțiuni video HTML5';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Cadru I';
$string['media_dlg:imagestatus'] = 'Status imagine';
$string['media_dlg:invokeurls'] = 'Invocă adrese URL';
$string['media_dlg:kioskmode'] = 'Modul chioșc';
$string['media_dlg:list'] = 'Listă';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Buclă';
$string['media_dlg:maintainaspect'] = 'Menține aspect';
$string['media_dlg:menu'] = 'Afișează meniu';
$string['media_dlg:mute'] = 'Surdină';
$string['media_dlg:name'] = 'Nume';
$string['media_dlg:nojava'] = 'Fără Java';
$string['media_dlg:numloop'] = 'Nume bucle';
$string['media_dlg:play'] = 'Redare automată';
$string['media_dlg:playcount'] = 'Numărătoare redare';
$string['media_dlg:playeveryframe'] = 'Redare fiecare cadru';
$string['media_dlg:poster'] = 'Afiș';
$string['media_dlg:prefetch'] = 'Preluare';
$string['media_dlg:preload'] = 'Preîncărcare';
$string['media_dlg:preload_auto'] = 'Lăsați browser-ul utilizatorului să decidă';
$string['media_dlg:preload_metadata'] = 'Preîncărcați metadatele video';
$string['media_dlg:preload_none'] = 'Nu preîncărca';
$string['media_dlg:preview'] = 'Previzualizare';
$string['media_dlg:progress'] = 'Progres';
$string['media_dlg:qt_options'] = 'Opțiuni QuickTime';
$string['media_dlg:qt_stream_warn'] = 'Resursele RTSP emise trebuie adăugate la câmpul sursă QT din fila avansată.
De aseemenea, ar trebui să adăugați o versiune non-stream la câmpul sursă.';
$string['media_dlg:qtsrc'] = 'Sursă QT';
$string['media_dlg:qtsrcchokespeed'] = 'Viteza de încărcare';
$string['media_dlg:quality'] = 'Calitate';
$string['media_dlg:quicktime'] = 'QuickTime';
$string['media_dlg:rate'] = 'Rată';
$string['media_dlg:realmedia'] = 'Real Media';
$string['media_dlg:rmp_options'] = 'Opțiuni player Real Media';
$string['media_dlg:salign'] = 'Aliniază';
$string['media_dlg:scale'] = 'Scală';
$string['media_dlg:scriptcallbacks'] = 'Revenire script';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = 'Opțiuni shockwave';
$string['media_dlg:shuffle'] = 'Amestecare';
$string['media_dlg:size'] = 'Dimensiuni';
$string['media_dlg:sound'] = 'Sunet';
$string['media_dlg:source'] = 'Sursă';
$string['media_dlg:starttime'] = 'Ora de începere';
$string['media_dlg:stretchtofit'] = 'Extinde pentru  se potrivi';
$string['media_dlg:swstretchhalign'] = 'Extinde alinierea în H';
$string['media_dlg:swstretchstyle'] = 'Extinde stil';
$string['media_dlg:swstretchvalign'] = 'Extinde alinierea în V';
$string['media_dlg:target'] = 'Țintă';
$string['media_dlg:targetcache'] = 'Cache țintă';
$string['media_dlg:title'] = 'Inserează/ editează media încorporată';
$string['media_dlg:type'] = 'Tip';
$string['media_dlg:uimode'] = 'Mod UI';
$string['media_dlg:video'] = 'Video HTML5';
$string['media_dlg:volume'] = 'Volum';
$string['media_dlg:vspace'] = 'Spațiu în V';
$string['media_dlg:windowlessvideo'] = 'Video fără ferestre';
$string['media_dlg:windowsmedia'] = 'Ferestre Media';
$string['media_dlg:wmode'] = 'WMode';
$string['media_dlg:wmp_options'] = 'Opțiuni player Windows Media';
$string['nonbreaking:nonbreaking_desc'] = 'Inserați caracter de spațiu ce nu poate fi distanțat';
$string['pagebreak:desc'] = 'Inserați pauze între pagini pentru imprimare';
$string['paste:paste_text_desc'] = 'Inserează ca text simplu';
$string['paste:paste_word_desc'] = 'Inserează din Word';
$string['paste:plaintext_mode'] = 'Inserarea este acum în modul text simplu. Dați click din nou pentru a reveni la modul regulat de inserare. După ce veți insera ceva veți reveni la modul regulat de inserare.';
$string['paste:plaintext_mode_stick'] = 'Inserarea este acum în modul text simplu. Dați click din nou pentru a reveni la modul regulat de inserare.';
$string['paste:selectall_desc'] = 'Selectează tot';
$string['paste_dlg:text_linebreaks'] = 'Păstrați distanțarea dintre linii';
$string['paste_dlg:text_title'] = 'Utilizați Ctrl+V de pe tastatura dumneavoastră pentru a insera textul în fereastră.';
$string['paste_dlg:word_title'] = 'Utilizați Ctrl+V de pe tastatura dumneavoastră pentru a insera textul în fereastră.';
$string['pluginname'] = 'Editor HTML TinyMCE (legacy)';
$string['preview:preview_desc'] = 'Previzualizare';
$string['print:print_desc'] = 'Imprimare';
$string['privacy:metadata'] = 'Plugin-ul editor TinyMCE HTML nu stochează date personale.';
$string['save:cancel_desc'] = 'Anulează toate modificările';
$string['save:save_desc'] = 'Salvare';
$string['searchreplace:delta_height'] = '';
$string['searchreplace:delta_width'] = '';
$string['searchreplace:replace_desc'] = 'Găsește/ înlocuiește';
$string['searchreplace:search_desc'] = 'Găsește';
$string['searchreplace_dlg:allreplaced'] = 'Toate aparițiile lanțului de căutare au fost înlocuite.';
$string['searchreplace_dlg:direction'] = 'Direcție';
$string['searchreplace_dlg:down'] = 'Jos';
$string['searchreplace_dlg:findnext'] = 'Găsește următorul';
$string['searchreplace_dlg:findwhat'] = 'Găsește ce';
$string['searchreplace_dlg:mcase'] = 'Caz potrivire';
$string['searchreplace_dlg:notfound'] = 'Căutarea a fost finalizată. Lanțul de căutare nu poate fi găsit.';
$string['searchreplace_dlg:replace'] = 'Înlocuiește';
$string['searchreplace_dlg:replace_title'] = 'Găsește/ înlocuiește';
$string['searchreplace_dlg:replaceall'] = 'Înlocuiește tot';
$string['searchreplace_dlg:replacewith'] = 'Înlocuiește cu';
$string['searchreplace_dlg:search_title'] = 'Găsește';
$string['searchreplace_dlg:searchnext_desc'] = 'Găsește din nou';
$string['searchreplace_dlg:up'] = 'Sus';
$string['settings'] = 'Setări generale';
$string['simple:bold_desc'] = 'Bold (Ctrl+B)';
$string['simple:bullist_desc'] = 'Inserează/ elimină lista numerotată';
$string['simple:cleanup_desc'] = 'Remediere cod incorect';
$string['simple:italic_desc'] = 'Italic (Ctrl+I)';
$string['simple:numlist_desc'] = 'Inserează/ elimină listă numerotată';
$string['simple:redo_desc'] = 'Refă (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Strikethrough';
$string['simple:underline_desc'] = 'Subliniere (Ctrl+U)';
$string['simple:undo_desc'] = 'Anulează (Ctrl+Z)';
$string['spellchecker:desc'] = 'Modificați verificarea ortografiei';
$string['spellchecker:ignore_word'] = 'Ignoră cuvântul';
$string['spellchecker:ignore_words'] = 'Ignoră tot';
$string['spellchecker:langs'] = 'Limbi';
$string['spellchecker:learn_word'] = 'Reține cuvântul';
$string['spellchecker:menu'] = 'Setările verificării ortografiei';
$string['spellchecker:no_mpell'] = 'Nu au fost găsite greșeli de ortografie.';
$string['spellchecker:no_sug'] = 'Nu există sugestii';
$string['spellchecker:sug'] = 'Sugestii';
$string['spellchecker:wait'] = 'Vă rugăm să așteptați...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '';
$string['style:desc'] = 'Editează stilul CSS';
$string['style_dlg:apply'] = 'Aplică';
$string['style_dlg:background'] = 'Fundal';
$string['style_dlg:background_attachment'] = 'Atașament';
$string['style_dlg:background_color'] = 'Culoare fundal';
$string['style_dlg:background_hpos'] = 'Poziție orizontală';
$string['style_dlg:background_image'] = 'Imagine fundal';
$string['style_dlg:background_repeat'] = 'Repetă';
$string['style_dlg:background_tab'] = 'Fundal';
$string['style_dlg:background_vpos'] = 'Poziție verticală';
$string['style_dlg:block'] = 'Blochează';
$string['style_dlg:block_display'] = 'Afișează';
$string['style_dlg:block_letterspacing'] = 'Spațiere litere';
$string['style_dlg:block_tab'] = 'Blochează';
$string['style_dlg:block_text_align'] = 'Aliniere text';
$string['style_dlg:block_text_indent'] = 'Spațiere text';
$string['style_dlg:block_vertical_alignment'] = 'Aliniere verticală';
$string['style_dlg:block_whitespace'] = 'Spațiu alb';
$string['style_dlg:block_wordspacing'] = 'Spațiere cuvinte';
$string['style_dlg:border'] = 'Margine';
$string['style_dlg:border_tab'] = 'Margine';
$string['style_dlg:bottom'] = 'Partea inferioară';
$string['style_dlg:box'] = 'Casetă';
$string['style_dlg:box_clear'] = 'Șterge';
$string['style_dlg:box_float'] = 'Lansează';
$string['style_dlg:box_height'] = 'Înălțime';
$string['style_dlg:box_tab'] = 'Casetă';
$string['style_dlg:box_width'] = 'Lățime';
$string['style_dlg:bullet_image'] = 'Imagine simbol';
$string['style_dlg:clip'] = 'Clip';
$string['style_dlg:color'] = 'Culoare';
$string['style_dlg:height'] = 'Înălțime';
$string['style_dlg:left'] = 'Stânga';
$string['style_dlg:list'] = 'Listă';
$string['style_dlg:list_tab'] = 'Listă';
$string['style_dlg:list_type'] = 'Tip';
$string['style_dlg:margin'] = 'Margine';
$string['style_dlg:overflow'] = 'Debit';
$string['style_dlg:padding'] = 'Adăugare';
$string['style_dlg:placement'] = 'Plasare';
$string['style_dlg:position'] = 'Poziție';
$string['style_dlg:positioning_tab'] = 'Poziționare';
$string['style_dlg:positioning_type'] = 'Tip';
$string['style_dlg:right'] = 'Dreapta';
$string['style_dlg:same'] = 'Același pentru tot';
$string['style_dlg:style'] = 'Stil';
$string['style_dlg:text'] = 'Text';
$string['style_dlg:text_blink'] = 'Blink';
$string['style_dlg:text_case'] = 'Caz';
$string['style_dlg:text_color'] = 'Culoare';
$string['style_dlg:text_decoration'] = 'Decorare';
$string['style_dlg:text_font'] = 'Font';
$string['style_dlg:text_lineheight'] = 'Înălțimea liniei';
$string['style_dlg:text_none'] = 'Niciuna';
$string['style_dlg:text_overline'] = 'Sybliniază';
$string['style_dlg:text_props'] = 'Text';
$string['style_dlg:text_size'] = 'Dimensiune';
$string['style_dlg:text_striketrough'] = 'Strikethrough';
$string['style_dlg:text_style'] = 'Stil';
$string['style_dlg:text_tab'] = 'Text';
$string['style_dlg:text_underline'] = 'Subliniază';
$string['style_dlg:text_variant'] = 'Variantă';
$string['style_dlg:text_weight'] = 'Valoare';
$string['style_dlg:title'] = 'Editează stilul CSS';
$string['style_dlg:toggle_insert_span'] = 'Inserați spațiu la selecție';
$string['style_dlg:top'] = 'Partea superioară';
$string['style_dlg:visibility'] = 'Vizibilitate';
$string['style_dlg:width'] = 'Valoare';
$string['style_dlg:zindex'] = 'Indexul Z';
$string['subplugintype_tinymce'] = 'Plugin';
$string['subplugintype_tinymce_plural'] = 'Plugin-uri';
$string['table:cell'] = 'Celulă';
$string['table:cell_desc'] = 'Proprietățile celulei tabelului';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '';
$string['table:col'] = 'Coloană';
$string['table:col_after_desc'] = 'Inserează coloană după';
$string['table:col_before_desc'] = 'Inserează coloană înainte';
$string['table:copy_row_desc'] = 'Copiază rândul tabelului';
$string['table:cut_row_desc'] = 'Decupează rândul tabelului';
$string['table:del'] = 'Șterge tabelul';
$string['table:delete_col_desc'] = 'Șterge coloana';
$string['table:delete_row_desc'] = 'Șterge rândul';
$string['table:desc'] = 'Inserează/ editează tabel';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '';
$string['table:merge_cells_desc'] = 'Unește celulele din tabel';
$string['table:paste_row_after_desc'] = 'Lipește rândul din tabel după';
$string['table:paste_row_before_desc'] = 'Lipește rândul din tabel înainte';
$string['table:props_desc'] = 'Proprietăți tabel';
$string['table:row'] = 'Rând';
$string['table:row_after_desc'] = 'Inserează rând după';
$string['table:row_before_desc'] = 'Inserează rând înainte';
$string['table:row_desc'] = 'Proprietățile rândului din tabel';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '';
$string['table:split_cells_desc'] = 'Desparte celulele unite din tabel';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '';
$string['table_dlg:advanced_props'] = 'Proprietăți avansate';
$string['table_dlg:advanced_tab'] = 'Avansat';
$string['table_dlg:align'] = 'Aliniere';
$string['table_dlg:align_bottom'] = 'Partea inferioară';
$string['table_dlg:align_default'] = 'Implicit';
$string['table_dlg:align_left'] = 'Stânga';
$string['table_dlg:align_middle'] = 'Centru';
$string['table_dlg:align_right'] = 'Dreapta';
$string['table_dlg:align_top'] = 'Partea superioară';
$string['table_dlg:bgcolor'] = 'Culoare fundal';
$string['table_dlg:bgimage'] = 'Imagine fundal';
$string['table_dlg:border'] = 'Margine';
$string['table_dlg:bordercolor'] = 'Culoare margini';
$string['table_dlg:caption'] = 'Legendă tabel';
$string['table_dlg:cell_all'] = 'Actualizează toate celule din tabel';
$string['table_dlg:cell_cell'] = 'Actualizează celula curentă';
$string['table_dlg:cell_col'] = 'Actualizează toate celulele din coloană';
$string['table_dlg:cell_limit'] = 'Ați depășit numărul maxim de coloane din {$cells}.';
$string['table_dlg:cell_row'] = 'Actualizează toate celule din rând';
$string['table_dlg:cell_title'] = 'Proprietățile celulelor din tabel';
$string['table_dlg:cell_type'] = 'Tip celulă';
$string['table_dlg:cellpadding'] = 'Umplere celulă';
$string['table_dlg:cellspacing'] = 'Spațierea celulelor';
$string['table_dlg:col_limit'] = 'Ați depășit numărul maxim de coloane din {$cols}.';
$string['table_dlg:colgroup'] = 'Grup coloane';
$string['table_dlg:cols'] = 'Coloane';
$string['table_dlg:frame'] = 'Cadru';
$string['table_dlg:frame_all'] = 'toate';
$string['table_dlg:frame_cols'] = 'coloane';
$string['table_dlg:frame_groups'] = 'grupuri';
$string['table_dlg:frame_none'] = 'niciuna';
$string['table_dlg:frame_rows'] = 'rânduri';
$string['table_dlg:general_props'] = 'Proprietăți generale';
$string['table_dlg:general_tab'] = 'General';
$string['table_dlg:height'] = 'Înălțime';
$string['table_dlg:id'] = 'Identificator';
$string['table_dlg:langcode'] = 'Cod limbă';
$string['table_dlg:langdir'] = 'Direcție scris';
$string['table_dlg:ltr'] = 'De la stânga la dreapta';
$string['table_dlg:merge_cells_title'] = 'Unește celulele din tabel';
$string['table_dlg:mime'] = 'Tip țintă MIME';
$string['table_dlg:missing_scope'] = 'Sunteți sigur că doriți să continuați fără să specificați scopul acestei celule antet din tabel? Fără aceasta, va fi dificil ca unii utilizatori cu dizabilități să înțeleagă conținutul sau datele afișate în tabel.';
$string['table_dlg:row_all'] = 'Actualizează toate rândurile din tabel';
$string['table_dlg:row_even'] = 'Actualizează rândurile uniforme din tabel';
$string['table_dlg:row_limit'] = 'Ați depășit numărul maxim de rânduri din {$rows}.';
$string['table_dlg:row_odd'] = 'Actualizează rândurile impare din tabel';
$string['table_dlg:row_row'] = 'Actualizează rândul curent';
$string['table_dlg:row_title'] = 'Proprietățile rândurilor din tabel';
$string['table_dlg:rowgroup'] = 'Grup rânduri';
$string['table_dlg:rows'] = 'Rânduri';
$string['table_dlg:rowtype'] = 'Tip rând';
$string['table_dlg:rtl'] = 'De la dreapta la stânga';
$string['table_dlg:rules'] = 'Reguli';
$string['table_dlg:rules_above'] = 'deasupra';
$string['table_dlg:rules_below'] = 'sub';
$string['table_dlg:rules_border'] = 'margine';
$string['table_dlg:rules_box'] = 'casetă';
$string['table_dlg:rules_hsides'] = 'laterale h';
$string['table_dlg:rules_lhs'] = 'lhs';
$string['table_dlg:rules_rhs'] = 'rhs';
$string['table_dlg:rules_void'] = 'liber';
$string['table_dlg:rules_vsides'] = 'laterale v';
$string['table_dlg:scope'] = 'Scop';
$string['table_dlg:style'] = 'Stil';
$string['table_dlg:summary'] = 'Rezumat';
$string['table_dlg:tbody'] = 'Conținut';
$string['table_dlg:td'] = 'Date';
$string['table_dlg:tfoot'] = 'Subsol';
$string['table_dlg:th'] = 'Antet';
$string['table_dlg:thead'] = 'Antet';
$string['table_dlg:title'] = 'Inserează/ editează tabel';
$string['table_dlg:valign'] = 'Aliniere verticală';
$string['table_dlg:width'] = 'Valoare';
$string['template:desc'] = 'Inserează conținutul șablonului predefinit';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Duminică, luni, marți, miercuri, joi, vineri, sâmbătă, duminică';
$string['template_dlg:day_short'] = 'Du, lu, ma, mi, joi, vi, sâ, du';
$string['template_dlg:desc'] = 'Inserează conținutul șablonului predefinit';
$string['template_dlg:desc_label'] = 'Descriere';
$string['template_dlg:label'] = 'Șablon';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Ianuarie, februarie, martie, aprilie, mai, iunie, iulie, august, septembrie, octombrie, noiembrie, decembrie';
$string['template_dlg:months_short'] = 'Ian, feb, mart, apr,mai, iun, iul, aug, sept, oct, nov, dec';
$string['template_dlg:preview'] = 'Previzualizare';
$string['template_dlg:select'] = 'Selectați un șablon';
$string['template_dlg:title'] = 'Șabloane';
$string['template_dlg:warning'] = 'Avertisment: Actualizarea unui șablon cu unul diferit poate duce la pierderea de date.';
$string['visualblocks:desc'] = 'Afișează/ ascunde elementele de blocare';
$string['visualchars:desc'] = 'Afișează/ ascunde caracterele de control vizual';
$string['wordcount:words'] = 'Cuvinte:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '';
$string['xhtmlxtras:abbr_desc'] = 'Abreviere';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '';
$string['xhtmlxtras:acronym_desc'] = 'Acronim';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '';
$string['xhtmlxtras:attribs_desc'] = 'Inserează/ editează atribute';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '';
$string['xhtmlxtras:cite_desc'] = 'Citare';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '';
$string['xhtmlxtras:del_desc'] = 'Ștergere';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '';
$string['xhtmlxtras:ins_desc'] = 'Inserare';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atribute';
$string['xhtmlxtras_dlg:attribs_title'] = 'Inserează/ editează atribute';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atribute';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Evenimente';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Cheie de acces';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Mențiune';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Clasă';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Dată/oră';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Limbă';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Direcție text';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stil';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Index tabel';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Titlu';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'De la stânga la dreapta';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'De la dreapta la stânga';
$string['xhtmlxtras_dlg:events_tab'] = 'Evenimente';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Atribute element';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Evenimente element';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Setări generale';
$string['xhtmlxtras_dlg:general_tab'] = 'General';
$string['xhtmlxtras_dlg:insert_date'] = 'Inserează data/ora curentă';
$string['xhtmlxtras_dlg:option_ltr'] = 'De la stânga la dreapta';
$string['xhtmlxtras_dlg:option_rtl'] = 'De la dreapta la stânga';
$string['xhtmlxtras_dlg:remove'] = 'Elimină';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Element de abreviere';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Element acronim';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Element citare';
$string['xhtmlxtras_dlg:title_del_element'] = 'Element ștergere';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Element inserare';
