<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pulse', language 'pt', version '4.1'.
 *
 * @package     pulse
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Ações';
$string['apply_customize'] = 'Submeter e Personalizar';
$string['apply_save'] = 'Submeter e gravar';
$string['approve'] = 'Aprovar';
$string['approved'] = 'Aprovado';
$string['approvedby'] = 'aprovado por';
$string['approvedeclined'] = 'Aprovação recusada';
$string['approvedon'] = 'Aprovado em {$a->date} por {$a->user}';
$string['approvedsuccess'] = 'Aprovação com sucesso';
$string['approveduser'] = 'Aprovado por: {$a->user}';
$string['approveuser'] = 'Aprovar utilizadores - {$a->course}';
$string['approveuserbtn'] = 'Aprovar utilizadores';
$string['box'] = 'Caixa';
$string['boxicon'] = 'Ícone da caixa';
$string['boxtype'] = 'Tipo de caixa';
$string['completereaction'] = 'Reação de conclusão';
$string['completewhenavaialble'] = 'Concluída quando disponível';
$string['completewhenavaialble_help'] = 'Se ativar esta opção, a atividade será considerada concluída quando o utilizador tiver acesso a esta (isto é, quando se verificarem as condições de acesso)';
$string['completion:approval'] = 'Aprovação requerida';
$string['completion:available'] = 'As condições devem ser cumpridas';
$string['completion:self'] = 'Marcar como concluída';
$string['completionapproverules'] = 'RegrasAprovaçãoConclusão';
$string['completioncriteria'] = 'Critérios da conclusão';
$string['completionfor'] = 'Conclusãopara';
$string['completionrequireapproval'] = 'Requer aprovação por um dos seguintes papéis';
$string['completionrequireapproval_help'] = 'Se ativar esta opção, a atividade será considera concluída quando qualquer um dos papéis selecionados aprovar o utilizador.';
$string['completionself'] = 'Aluno marcar como concluído para concluir a atividade';
$string['completionself_help'] = 'Se ativar esta opção, a atividade será considerada concluída quando o aluno a marcar como concluída na página principal da disciplina.';
$string['configintro'] = 'Definições de configuração globais do Pulse';
$string['configparams'] = 'Parâmetros de configuração';
$string['configrableparams'] = 'Parâmetros configuráveis';
$string['confirmdeletetemplate'] = 'Tem a certeza! Pretende apagar o modelo?';
$string['content'] = 'Conteúdo';
$string['content_help'] = 'O conteúdo será apresentado na página da disciplina e utilizado como conteúdo do corpo da mensagem para o convite.';
$string['courserole'] = 'Papelnadisciplina';
$string['createpreset'] = 'Criar modelo';
$string['creditesgroup'] = 'Pontuação de crédito';
$string['credits'] = 'Créditos';
$string['creditsfield'] = 'Campo de perfil de créditos do utilizador';
$string['creditsfielddesc'] = 'Selecione qualquer um dos campos de perfil personalizados do utilizador para manter os  créditos do utilizador <br>
NOTA: Bloqueie o campo selecionado para impedir que os alunos alterem os seus créditos';
$string['cssclass'] = 'Classe CSS';
$string['danger'] = 'Perigo';
$string['dark'] = 'Escuro';
$string['decline'] = 'Recusar';
$string['declined'] = 'Recusado';
$string['deletepreset'] = 'Eliminar o modelo predefinido do pulsepro';
$string['description'] = 'Descrição';
$string['detailedlog'] = 'Apresentar o registo de atividade detalhado para a tarefa agendada - utilizar apenas para fins de resolução de problemas e desativar em websites de produção';
$string['diffnotification'] = 'Utilizar o conteúdo da notificação em vez do conteúdo geral';
$string['diffnotification_help'] = 'Se ativar esta opção, o convite utilizará o conteúdo e o assunto da notificação (em vez do conteúdo geral e do título).';
$string['disabled'] = 'Desativado';
$string['dislike'] = 'Desagrado';
$string['displaymode'] = 'Modo de visualização';
$string['displaytype:contentonly'] = 'Apenas conteúdo';
$string['displaytype:notificationcontent'] = 'Ambos';
$string['displaytype:notificationonly'] = 'Apenas notificação';
$string['enable:disable'] = 'Ativar/Desativar';
$string['enabled'] = 'Ativado';
$string['enablereminder:first'] = 'Ativar o primeiro lembrete';
$string['enablereminder:first_help'] = 'Se ativar esta opção, o Pulse enviará o primeiro lembrete';
$string['enablereminder:invitation'] = 'Ativar convite';
$string['enablereminder:recurring'] = 'Ativar lembrete recorrente';
$string['enablereminder:recurring_help'] = 'Se ativar esta opção, o Pulse enviará um lembrete recorrente para os destinatários selecionados. Os lembretes recorrentes serão enviados ao utilizador no intervalo indicado até o utilizador deixar de estar inscrito ou suspenso.';
$string['enablereminder:second'] = 'Ativar segundo lembrete';
$string['enablereminder:second_help'] = 'Se ativar esta opção, o Pulse enviará um segundo lembrete aos destinatários selecionados com base na calendarização.';
$string['enrolmentemptyenddate'] = '-';
$string['enrolmentemptystartdate'] = '-';
$string['generatereport'] = 'Gerar relatório';
$string['head:firstreminder'] = 'Primeiro lembrete';
$string['head:recurringreminder'] = 'Lembrete recorrente';
$string['head:secondreminder'] = 'Segundo lembrete';
$string['instancename'] = 'Pulse';
$string['instruction'] = 'Instrução';
$string['invitation'] = 'Convite';
$string['invitation_help'] = 'Enviar o convite a todos os utilizadores com os papéis selecionados.';
$string['invitationdbpro'] = 'O convite enviado ao utilizador não foi inserido. Por favor, verifique o pulsepro';
$string['invitationnotsend'] = 'Convite não enviado ao utilizador';
$string['invitationsubject'] = 'Assunto da notificação';
$string['invitationsubject_help'] = 'Insira aqui o assunto do convite.';
$string['learnmore'] = 'Mais informações';
$string['light'] = 'Lâmpada';
$string['like'] = 'Como';
$string['logintoreact'] = 'Iniciar sessão antes de aplicar a reação';
$string['managepresets'] = 'Gerir Modelos';
$string['markcomplete'] = 'Marcar como concluída';
$string['messageprovider:mod_pulse'] = 'Enviar notificação';
$string['modulename'] = 'Pulse';
$string['modulename_help'] = 'O Pulse é o canivete suiço do professor para melhorar o envolvimento dos alunos nas disciplinas Moodle:
<ul><li><strong>Notificações</strong><br/>
Cada atividade do Pulse pode ser configurada para enviar uma notificação assim que ficar disponível para o aluno. Há uma série de marcadores que podem ser usados para personalizar a mensagem, como o primeiro nome do aluno ou o nome da disciplina. A notificação pode ser enviada para o aluno, para o professor, para o professor não editor ou para o gestor. Também são suportados outros papéis no contexto da disciplina ou do utilizador, por exemplo, encarregado de educação ou staff.</li>
<li><strong>Processo de conclusão</strong><br/>
O Pulse suporta a conclusão de atividades de três formas (para além das predefinidas do Moodle): quando disponível, quando marcada como concluída pelo aluno e quando aprovada por outro papel.</li></ul>
<p>Como em todas as coisas relacionadas com a automatização, é essencial refletir sobre o que realmente se pretende. Idealmente, escreva o que deve acontecer em cada caso. Isto também nos ajuda a prestar-lhe apoio! Se não funcionar como esperado, eis os problemas mais comuns:</p>
<ul>
<li> A disciplina não <b> iniciou</b>. O Pulse só funciona numa disciplina que esteja a decorrer atualmente —> Assegure-se que a data de início está no passado.</li>
<li> A disciplina <b>terminou</b>. O Pulse só funciona numa disciplina que esteja a decorrer atualmente —> Verifique se a data final está definida e, se estiver, certifique-se de que é no futuro.</li>
<li> A disciplina tem <b>alunos inscritos <b>. O Pulse (gratuito) só funciona para alunos —> Verifique se a disciplina tem pelo menos um utilizador inscrito com um estado de inscrição ativo.</b>.
<li> A atividade do Pulse está <b>disponível</b>. O Pulse só funciona se a atividade estiver disponível para o aluno. É esse o “gatilho” ou “condição” que utilizamos para determinar se devemos efetivamente fazer alguma coisa (por exemplo, atribuir créditos). —> Verifique se a atividade Pulse está oculta ou tem uma restrição que não é cumprida pelo aluno; em ambos os casos, estará “desativada” e não fará nada. Se não tiver a certeza, basta iniciar sessão como aluno e verificar se o aluno vê a atividade Pulse - se o aluno a vir, está ativada; se o aluno não a vir, está desativada.
<li>A <b>tarefa cron</b> não está a correr ou ainda não foi executada — a atribuição de créditos é feita através de uma tarefa agendada. Por isso, é necessário que a tarefa cron esteja a correr regularmente. O Moodle recomenda que seja feito a cada minuto, e nós só podemos sugerir que siga essa recomendação!</li>
</ul>';
$string['modulename_link'] = 'Pulse';
$string['modulenameplural'] = 'Pulses';
$string['noreaction'] = 'Sem reação';
$string['normal'] = 'Normal';
$string['notassignedgroup'] = 'O utilizador tem de fazer parte de um grupo para se poder filtrar por participantes.';
$string['notificationfooter'] = 'Rodapé da notificação';
$string['notificationfooterdesc'] = '{$a->placeholders}';
$string['notificationheader'] = 'Cabeçalho da notificação';
$string['notificationheaderdesc'] = '{$a->placeholders}';
$string['notifyusers'] = 'Notificar os alunos do curso';
$string['notsameuser'] = 'Não é o utilizador correto para aplicar a reação';
$string['pluginadministration'] = 'Administração do pulse';
$string['pluginname'] = 'Pulse';
$string['preset_template'] = 'Modelo predefinido';
$string['preset_template_help'] = 'Carregar o ficheiro de cópia de segurança do módulo pulse da atividade da disciplina';
$string['presetcreated'] = 'Modelos do Pulse criados com sucesso';
$string['presetdeleted'] = 'Modelos apagados com sucesso';
$string['preseticon'] = 'Ícone de modelo';
$string['presetlist'] = 'Lista de modelos';
$string['presetmodaltitle'] = 'Utilizar o modelo {$a->title}';
$string['presetorder'] = 'Ordem predefinida dos modelos';
$string['presets'] = 'Modelos do Pulse';
$string['presetstatus'] = 'Apresentar este modelo na lista';
$string['presetupdated'] = 'Modelos do Pulse atualizados com sucesso';
$string['previousreminders'] = 'Lembretes anteriores';
$string['primary'] = 'Primário';
$string['privacy:completion'] = 'Conclusão';
$string['privacy:invitation'] = 'Convite';
$string['privacy:metadata'] = 'O plugin Pulse não armazena quaisquer dados pessoais.';
$string['privacy:metadata:completion:approvalstatus'] = 'Estado de aprovação do utilizador';
$string['privacy:metadata:completion:approvaltime'] = 'Data em que o utilizador foi aprovado por outro.';
$string['privacy:metadata:completion:approveduser'] = 'ID do utilizador que aprovou o utilizador aluno';
$string['privacy:metadata:completion:selfcompletion'] = 'Estado da conclusão do utilizador pelo próprio';
$string['privacy:metadata:completion:selfcompletiontime'] = 'Data em que o utilizador marcou a atividade Pulse como concluída';
$string['privacy:metadata:completion:timemodified'] = 'Data de conclusão alterada';
$string['privacy:metadata:completion:userid'] = 'ID do utilizador';
$string['privacy:metadata:pulsecompletion'] = 'Conclusões das atividades dos utilizadores do Pulse';
$string['privacy:metadata:pulsemessageexplanation'] = 'Os convites são enviados aos alunos através do sistema de mensagens.';
$string['privacy:metadata:pulseusers'] = 'Lista de convites de utilizadores notificados';
$string['privacy:metadata:users:status'] = 'Estado do convite para saber se a notificação é anterior ou atual';
$string['privacy:metadata:users:timecreated'] = 'Hora do envio do convite ao utilizador.';
$string['privacy:metadata:users:userid'] = 'ID do utilizador notificado';
$string['promotionaltext'] = 'Com o Pulse Pro obtém lembretes poderosos, reações por e-mail e pode criar os seus próprios modelos.';
$string['pulse:addinstance'] = 'Adicionar um novo Pulse';
$string['pulse:notifyuser'] = 'Enviar notificação';
$string['pulse:view'] = 'Ver Pulse';
$string['pulse_subject'] = 'Pulse de {Course_FullName} ({Site_FullName})';
$string['pulsenotavailable'] = 'Instância do pulse não adicionada à disciplina';
$string['pulsenotification'] = 'Notificação do Pulse';
$string['pulsepro:viewreports'] = 'Ver modelos Pulse Pro';
$string['rate'] = 'Taxa';
$string['reaction'] = 'Reação';
$string['reaction:approve'] = '<a href="{$a->url de reação}" estilo="cor: #fff;background: #0f6fc5;padding:.375rem .75rem;text-decoration-line: none;" > Approve </a>';
$string['reaction:markcomplete'] = '<a href="{$a->reactionurl}" style="color: #fff;background: #0f6fc5;padding: .375rem .75rem;text-decoration-line: none;" >Marcar como concluída</a>';
$string['reactiondisplaytype'] = 'Localização';
$string['reactiondisplaytype_help'] = 'Escolha o local onde a reação deve ser apresentada.';
$string['reactions'] = 'Reação';
$string['reactionthankmsg'] = 'Obrigada! A sua resposta foi submetida.<br><br> <span> Pode agora fechar esta janela</span>';
$string['reactiontype'] = 'Tipo';
$string['reactiontype_help'] = 'Lista de tipos de reação.';
$string['recipients'] = 'Destinatários da notificação';
$string['recipients_help'] = 'Selecione os papéis para os quais pretende enviar a notificação. Apenas os utilizadores inscritos nesta disciplina e com o papel selecionado receberão as notificações. Tenha em atenção que os utilizadores com um papel no sistema não precisam de estar inscritos na disciplina.';
$string['remindercontent'] = 'Conteúdo da notificação';
$string['remindercontent_help'] = 'O conteúdo que introduzir aqui será enviado para os destinatários.';
$string['reminders:availabletime'] = 'Tempo de disponibilidade';
$string['reminders:first'] = 'Primeiro lembrete';
$string['reminders:recurring'] = 'Lembrete recorrente';
$string['reminders:second'] = 'Segundo lembrete';
$string['reminderschedule'] = 'Calendarização da notificação';
$string['reminderschedule_help'] = 'Define o tipo de calendarização do lembrete, <br>
                                    Se selecionar data fixa, o lembrete é enviado na data selecionada.<br>
                                    Se selecionar data relativa, o lembrete é enviado depois de decorrido o tempo selecionado. O tempo começa a contar a partir do momento em que a atividade Pulse fica disponível para o utilizador.';
$string['remindersubject'] = 'Assunto da notificação';
$string['remindersubject_help'] = 'O conteúdo será utilizado como assunto para os lembretes.';
$string['reports'] = 'Relatórios do Pulse';
$string['reportsfilename'] = 'Relatórios do Pulse - {$a->nome}';
$string['resendnotification'] = 'Reenviar a notificação';
$string['resendnotification_help'] = 'Se ativar esta opção, o lembrete do convite será reagendado e enviará o convite também aos utilizadores já notificados.';
$string['resendnotificationdesc'] = 'O convite foi programado para ser reenviado';
$string['restrictionmet'] = 'Restrição cumprida';
$string['schedule:fixeddate'] = 'Data fixa';
$string['schedule:relativedate'] = 'Data relativa';
$string['search:activity'] = 'Pulse';
$string['secondary'] = 'Secundário';
$string['selectpulse'] = 'Selecionar a instância do pulse';
$string['self'] = 'Pelo próprio';
$string['selfmarked'] = 'Marcado como concluído pelo próprio em {$a->data}';
$string['sendnotificaton'] = 'Enviar notificação do Pulse';
$string['sendnotificaton_help'] = 'Se ativar esta opção, o convite será enviado.';
$string['setup'] = 'Campo de configuração';
$string['setupcredit'] = 'Para utilizar esta funcionalidade, é necessário configurar primeiro o campo do perfil do utilizador.
Peça ao seu administrador para o configurar.';
$string['showhide'] = 'Registo de atividade detalhado';
$string['statuslabel'] = 'Ativar / Desativar';
$string['success'] = 'Sucesso';
$string['tasklimituser'] = 'Limitar utilizadores por tarefa';
$string['tasklimituserdesc'] = 'Use esta opção de configuração para limitar o número de utilizadores processados por tarefa. Reduza o número de utilizadores se a tarefa estiver a demorar muito tempo a terminar.';
$string['teacher'] = 'Professor';
$string['title'] = 'Título';
$string['title_help'] = 'O título é utilizado como nome da atividade. É utilizado como assunto para enviar o convite.';
$string['tokenexpired'] = 'Token expirado! A sua resposta não foi guardada.';
$string['update_preset'] = 'Atualizar modelo predefinido';
$string['updatecompletion'] = 'Atualizar a conclusão dos módulos Pulse';
$string['updateusercredits'] = 'Atualizar créditos de utilizador';
$string['usepreset'] = 'Usar modelo';
$string['userrole'] = 'papeldoutilizador';
$string['viewreport'] = 'Ver relatório';
$string['warning'] = 'Aviso';
