<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'el', version '4.1'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Ενέργειες για τη διεπαφή βαθμολογητή';
$string['actionsforpost'] = 'Ενέργειες για ανάρτηση';
$string['activitydate:due'] = 'Λήξη:';
$string['activityoverview'] = 'Υπάρχουν νέες αναρτήσεις στο φόρουμ';
$string['addanewdiscussion'] = 'Προσθήκη νέου θέματος συζήτησης';
$string['addanewquestion'] = 'Προσθήκη νέας ερώτησης';
$string['addanewtopic'] = 'Προσθήκη νέου θέματος';
$string['addtofavourites'] = 'Επισήμανση αυτής της συζήτησης με αστερίσκο';
$string['advancedsearch'] = 'Προχωρημένη αναζήτηση';
$string['alldiscussions'] = 'Όλες οι συζητήσεις';
$string['allforums'] = 'Όλα τα φόρουμ';
$string['allowdiscussions'] = 'Μπορεί {$a} να κάνει ανάρτηση σε αυτό το φόρουμ;';
$string['allowsallsubscribe'] = 'Αυτό το φόρουμ επιτρέπει σε οποιονδήποτε να επιλέξει αν θα κάνει εγγραφή ή όχι';
$string['allowsdiscussions'] = 'Αυτό το φόρουμ επιτρέπει σε κάθε άτομο να αρχίσει ένα θέμα συζήτησης.';
$string['allsubscribe'] = 'Εγγραφή σε όλα τα φόρουμ';
$string['allunsubscribe'] = 'Απεγγραφή από όλα τα φόρουμ';
$string['allusers'] = 'Όλοι οι χρήστες';
$string['alreadyfirstpost'] = 'Αυτή είναι ήδη η πρώτη ανάρτηση στην συζήτηση';
$string['anyfile'] = 'Οποιοδήποτε αρχείο';
$string['areaattachment'] = 'Συνημμένα';
$string['areapost'] = 'Μηνύματα';
$string['attachment'] = 'Συνημμένο';
$string['attachment_help'] = 'Μπορείτε προαιρετικά να επισυνάψετε ένα ή περισσότερα αρχεία σε μια ανάρτηση σε φόρουμ. Αν επισυνάψετε μια εικόνα, θα εμφανιστεί μετά το μήνυμα.';
$string['attachmentname'] = 'Συνημμένο {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Δεν είναι δυνατή η εξαγωγή συνημμένων χωρίς ένα αναγνωριστικό ανάρτησης';
$string['attachments'] = 'Συνημμένα';
$string['attachmentswordcount'] = 'Συνημμένα και καταμέτρηση λέξεων';
$string['authorreplyingprivatelytoauthor'] = 'Ο/Η {$a->respondant} σε απάντηση ιδιωτικά στον/στην {$a->author}';
$string['authorreplyingtoauthor'] = 'Ο/Η {$a->respondant} σε απάντηση στον/στην {$a->author}';
$string['availability'] = 'Διαθεσιμότητα';
$string['blockafter'] = 'Ανώτατο όριο αναρτήσεων για μπλοκάρισμα';
$string['blockafter_help'] = 'Αυτή η ρύθμιση καθορίζει τον μέγιστο αριθμό αναρτήσεων τις οποίες μπορεί να κάνει ένας χρήστης σε μια δεδομένη χρονική περίοδο. Οι χρήστες με την δυνατότητα mod/forum:postwithoutthrottling εξαιρούνται από όρια αναρτήσεων.';
$string['blockperiod'] = 'Χρονική περίοδος για μπλοκάρισμα';
$string['blockperiod_help'] = 'Οι μαθητές μπορούν να μπλοκαριστούν από το να κάνουν περισσότερες από ένα δεδομένο αριθμό αναρτήσεων σε μια δεδομένη χρονική περίοδο. Οι χρήστες με την δυνατότητα mod/forum:postwithoutthrottling εξαιρούνται από όρια αναρτήσεων.';
$string['blockperioddisabled'] = 'Όχι μπλοκάρισμα';
$string['blogforum'] = 'Το τυπικό φόρουμ να εμφανίζεται με μορφότυπο παρόμοιο με ιστολογίου';
$string['bynameondate'] = 'από {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Κατάσταση παρακολούθησης φόρουμ για τον χρήστη';
$string['calendardue'] = 'Το γεγονός {$a} οφείλεται (έχει καθυστερήσει)';
$string['cancelreply'] = 'Ακύρωση απάντησης';
$string['cannotadd'] = 'Δεν ήταν δυνατόν να προστεθεί η συζήτηση για αυτό το φόρουμ';
$string['cannotadddiscussion'] = 'Η προσθήκη συζητήσεων σε αυτό το φόρουμ απαιτεί συμμετοχή σε ομάδα.';
$string['cannotadddiscussionall'] = 'Δεν έχετε δικαίωμα προσθήκης νέου θέματος συζήτησης για όλους τους συμμετέχοντες.';
$string['cannotadddiscussiongroup'] = 'Δεν μπορείτε να δημιουργήσετε μια συζήτηση επειδή δεν είστε μέλος καμίας ομάδας.';
$string['cannotaddsubscriber'] = 'Δεν ήταν δυνατό να προστεθεί η δήλωση εγγραφής χρήστη με αναγνωριστικό {$a} σε αυτό το φόρουμ!';
$string['cannotaddteacherforumto'] = 'Αδυναμία προσθήκης του μετατραπέντος στιγμιοτύπου του φόρουμ διδασκόντων στην ενότητα 0 στο μάθημα';
$string['cannotcreatediscussion'] = 'Δεν ήταν δυνατή η δημιουργία νέας συζήτησης';
$string['cannotcreateinstanceforteacher'] = 'Δεν ήταν δυνατό να δημιουργηθεί το νέο στιγμιότυπο αρθρώματος μαθήματος για το φόρουμ διδάσκοντος';
$string['cannotdeletepost'] = 'Δεν είναι δυνατή η διαγραφή αυτής της ανάρτησης!';
$string['cannoteditposts'] = 'Δεν είναι δυνατή η επεξεργασία αναρτήσεων άλλων χρηστών!';
$string['cannotexportforum'] = 'Δεν μπορείτε να εξαγάγετε αυτό το φόρουμ';
$string['cannotfavourite'] = 'Λυπούμαστε, αλλά δεν έχετε την άδεια να επισημάνετε συζητήσεις με αστερίσκο.';
$string['cannotfinddiscussion'] = 'Δεν ήταν δυνατόν να βρεθεί η συζήτηση σε αυτό το φόρουμ';
$string['cannotfindfirstpost'] = 'Δεν ήταν δυνατόν να βρεθεί η πρώτη ανάρτηση σε αυτό το φόρουμ';
$string['cannotfindorcreateforum'] = 'Δεν ήταν δυνατόν να βρεθεί ή να δημιουργηθεί ένα βασικό φόρουμ ανακοινώσεων για τον ιστότοπο';
$string['cannotfindparentpost'] = 'Δεν ήταν δυνατή η εύρεση του πρώτου γονέα της ανάρτησης {$a}';
$string['cannotmovefromsingleforum'] = 'Δεν είναι δυνατό να μετακινηθεί μια συζήτηση από ένα απλό φόρουμ μιας συζήτησης';
$string['cannotmovenotvisible'] = 'Το φόρουμ δεν είναι ορατό';
$string['cannotmovetonotexist'] = 'Δεν μπορείτε να μετακινήσετε σε αυτό το φόρουμ - δεν υπάρχει!';
$string['cannotmovetonotfound'] = 'Το φόρουμ προορισμού δεν βρέθηκε σε αυτό το μάθημα.';
$string['cannotmovetosingleforum'] = 'Δεν είναι δυνατό να μετακινηθεί μια συζήτηση σε ένα απλό φόρουμ μιας συζήτησης';
$string['cannotpindiscussions'] = 'Λυπούμαστε, αλλά δεν έχετε την άδεια να καρφιτσώσετε συζητήσεις.';
$string['cannotpurgecachedrss'] = 'Δεν ήταν δυνατόν να καθαριστεί η κρυφή μνήμη των τροφοδοσιών RSS για το(α) φόρουμ προέλευσης και/ή προορισμού - ελέγξτε τα δικαιώματα των αρχείων σας';
$string['cannotremovesubscriber'] = 'Δεν ήταν δυνατόν να αφαιρεθεί η δήλωση εγγραφής χρήστη με αναγνωριστικό {$a} από αυτό το φόρουμ!';
$string['cannotreply'] = 'Δεν μπορείτε να απαντήσετε σε αυτήν την ανάρτηση';
$string['cannotsplit'] = 'Οι συζητήσεις από αυτό το φόρουμ δεν μπορούν να διαιρεθούν';
$string['cannotsubscribe'] = 'Λυπόμαστε, αλλά πρέπει να είστε μέλος ομάδας για να εγγραφείτε.';
$string['cannottrack'] = 'Δεν ήταν δυνατόν να σταματήσει η παρακολούθηση αυτού του φόρουμ';
$string['cannotunsubscribe'] = 'Δεν ήταν δυνατόν να σας απεγγράψουμε από αυτό το φόρουμ';
$string['cannotupdatepost'] = 'Δεν είναι δυνατή η ενημέρωση αυτής της ανάρτησης';
$string['cannotviewpostyet'] = 'Δεν μπορείτε να διαβάσετε τις ερωτήσεις των άλλων μαθητών σε αυτή τη συζήτηση ακόμα γιατί δεν έχετε αναρτήσει κάτι';
$string['cannotviewusersposts'] = 'Δεν υπάρχουν αναρτήσεις που να έγιναν από αυτόν τον χρήστη που να μπορείτε να δείτε.';
$string['cleanreadtime'] = 'Η ώρα που θα σημειώνονται οι παλιές αναρτήσεις ως αναγνωσμένες';
$string['clicktofavourite'] = 'Δεν έχετε επισημάνει τη συζήτηση αυτή με αστερίσκο. Κάντε κλικ για να την επισημάνετε.';
$string['clicktolockdiscussion'] = 'Κάντε κλικ για να κλειδώσετε αυτή τη συζήτηση';
$string['clicktosubscribe'] = 'Δεν έχετε εγγραφεί σε αυτή τη συζήτηση. Κάντε κλικ για να εγγραφείτε.';
$string['clicktounfavourite'] = 'Έχετε επισημάνει αυτή τη συζήτηση με αστερίσκο. Κάντε κλικ για να τον αφαιρέσετε.';
$string['clicktounlockdiscussion'] = 'Κάντε κλικ για να ξεκλειδώσετε αυτή τη συζήτηση';
$string['clicktounsubscribe'] = 'Έχετε εγγραφεί σε αυτή τη συζήτηση. Κάντε κλικ για να ξεγραφτείτε.';
$string['close'] = 'Κλείσιμο';
$string['closegrader'] = 'Κλείσιμο βαθμολογητή';
$string['completiondetail:discussions'] = 'Έναρξη συζητήσεων: {$a}';
$string['completiondetail:posts'] = 'Δημιουργία αναρτήσεων φόρουμ: {$a}';
$string['completiondetail:replies'] = 'Ανάρτηση απαντήσεων: {$a}';
$string['completiondiscussions'] = 'Ο μαθητής πρέπει να δημιουργήσει συζητήσεις:';
$string['completiondiscussionsdesc'] = 'Ο μαθητής πρέπει να δημιουργήσει τουλάχιστον {$a} συζητήσεις';
$string['completiondiscussionsgroup'] = 'Απαιτούνται συζητήσεις';
$string['completiondiscussionshelp'] = 'απαιτούνται συζητήσεις για την ολοκλήρωση';
$string['completionposts'] = 'Ο μαθητής πρέπει να αναρτήσει συζητήσεις ή απαντήσεις:';
$string['completionpostsdesc'] = 'Ο μαθητής πρέπει να αναρτήσει τουλάχιστον {$a} συζητήσεις/-η ή απαντήσεις/-η';
$string['completionpostsgroup'] = 'Απαιτούνται αναρτήσεις';
$string['completionpostshelp'] = 'απαιτούνται συζητήσεις ή απαντήσεις για την ολοκλήρωση';
$string['completionreplies'] = 'Ο μαθητής πρέπει να αναρτήσει απαντήσεις:';
$string['completionrepliesdesc'] = 'Ο μαθητής πρέπει να αναρτήσει {$a} τουλάχιστον αναρτήσεις/-η';
$string['completionrepliesgroup'] = 'Απαιτούνται απαντήσεις';
$string['completionreplieshelp'] = 'απαιτούνται απαντήσεις για την ολοκλήρωση';
$string['configcleanreadtime'] = 'Η ώρα της ημέρας για εκκαθάριση παλιών αναρτήσεων από τον πίνακα «αναγνωσμένων».';
$string['configdigestmailtime'] = 'Για τους χρήστες που επιλέγουν να τους αποστέλλονται μηνύματα ηλε.ταχυδρομείου τους σε μορφή σύνοψης, θα τους αποστέλλεται η σύνοψη ημερησίως. Αυτή η ρύθμιση καθορίζει την ώρα της ημέρας που θα γίνεται αυτό (από την επόμενη εκτέλεση της εντολής χρονο-προγραμματισμού cron μετά από αυτή την ώρα).';
$string['configdisplaymode'] = 'Ο προεπιλεγμένος τρόπος εμφάνισης συζητήσεων αν δεν έχει καθοριστεί κάποιος ακόμα.';
$string['configenablerssfeeds'] = 'Αυτός ο διακόπτης θα επιτρέψει τη δυνατότητα τροφοδοσιών RSS για όλα τα φόρουμ. Θα πρέπει όμως ακόμα, να ενεργοποιήσετε τις τροφοδοσίες χειροκίνητα στις ρυθμίσεις του κάθε φόρουμ.';
$string['configenabletimedposts'] = 'Ορίστε το σε «ναι» εάν επιθυμείτε να επιτρέψετε ρύθμιση περιόδων εμφάνισης κατά την ανάρτηση μιας νέας συζήτησης σε ένα φόρουμ';
$string['configlongpost'] = 'Οποιαδήποτε ανάρτηση μεγαλύτερη από αυτό το μήκος (σε χαρακτήρες μη συμπεριλαμβανομένου του HTML κώδικα) θεωρείται μεγάλη. Αναρτήσεις που εμφανίζονται στην πρώτη σελίδα ιστοτόπου, σε σελίδες μαθημάτων κοινωνικού μορφότυπου, ή σε προφίλ χρηστών περικόπτονται προς ένα φυσικό σημείο κάπου μεταξύ των τιμών των forum_shortpost και forum_longpost.';
$string['configmanydiscussions'] = 'Ο μέγιστος αριθμός συζητήσεων που εμφανίζονται σε ένα φόρουμ ανά σελίδα';
$string['configmaxattachments'] = 'Ο προεπιλεγμένος μέγιστος αριθμός συνημμένων που επιτρέπονται ανά ανάρτηση.';
$string['configmaxbytes'] = 'Το προεπιλεγμένο μέγιστο μέγεθος για όλα τα συνημμένα σε φόρουμ του ιστοτόπου (εξαρτάται και από τα όρια του μαθήματος και άλλων τοπικών ρυθμίσεων)';
$string['configoldpostdays'] = 'Αριθμός ημερών μέχρι να θεωρηθεί μια ανάρτηση ως αναγνωσμένη.';
$string['configreplytouser'] = 'Όταν μια ανάρτηση φόρουμ αποστέλλεται με ηλε.ταχυδρομείο, να περιέχει τη διεύθυνση του αποστολέα, ώστε οι παραλήπτες να μπορούν να απαντήσουν προσωπικά και όχι μόνο μέσω του φόρουμ; Ακόμα και αν οριστεί σε «Ναι» οι χρήστες μπορούν να επιλέξουν μέσα από το προφίλ τους να αποκρύπτουν την διεύθυνση ηλε.ταχυδρομείου τους.';
$string['configrssarticlesdefault'] = 'Εάν οι τροφοδοσίες RSS είναι ενεργοποιημένες, ορίζει τον προεπιλεγμένο αριθμό άρθρων (είτε συζητήσεις είτε αναρτήσεις).';
$string['configrsstypedefault'] = 'Εάν οι τροφοδοσίες RSS είναι ενεργοποιημένες, ορίζει τον προεπιλεγμένο τύπο δραστηριότητας.';
$string['configshortpost'] = 'Οποιαδήποτε ανάρτηση μικρότερη αυτού του μεγέθους (μη συμπεριλαμβανομένου του HTML) θεωρείται μικρή. (δείτε παρακάτω)';
$string['configsubscriptiontype'] = 'Προεπιλεγμένη ρύθμιση για τη λειτουργία εγγραφής.';
$string['configtrackingtype'] = 'Προεπιλεγμένη ρύθμιση για παρακολούθηση ανάγνωσης.';
$string['configtrackreadposts'] = 'Ρυθμίστε το σε «ναι» εάν θέλετε να παρακολουθείτε για αναγνωσμένα/μη-αναγνωσμένα για κάθε χρήστη.';
$string['configusermarksread'] = 'Εάν «ναι», ο χρήστης πρέπει να επισημαίνει χειροκίνητα μια ανάρτηση ως αναγνωσμένη. Εάν «όχι», όταν μια ανάρτηση εμφανίζεται επισημαίνεται ως αναγνωσμένη.';
$string['confirmsubscribe'] = 'Θέλετε σίγουρα να εγγραφείτε στο φόρουμ «{$a}»;';
$string['confirmsubscribediscussion'] = 'Θέλετε σίγουρα να εγγραφείτε στη συζήτηση «{$a->discussion}» στο φόρουμ «{$a}»;';
$string['confirmunsubscribe'] = 'Θέλετε σίγουρα να απεγγραφείτε από το φόρουμ «{$a}»;';
$string['confirmunsubscribediscussion'] = 'Θέλετε σίγουρα να απεγγραφείτε από τη συζήτηση «{$a->discussion}» στο το φόρουμ «{$a}»;';
$string['couldnotadd'] = 'Δεν ήταν δυνατή η προσθήκη του μηνύματός σας λόγω άγνωστου σφάλματος';
$string['couldnotdeletereplies'] = 'Λυπούμαστε, αλλά αυτή η ανάρτηση δεν μπορεί να διαγραφεί καθώς κάποιοι έχουν ήδη απαντήσει σε αυτή';
$string['couldnotupdate'] = 'Αδυναμία ενημέρωσης του μηνύματός σας λόγω άγνωστου σφάλματος';
$string['created'] = 'Δημιουργήθηκε';
$string['crontask'] = 'Ειδοποιήσεις φόρουμ (μηνύματα ηλε.ταχυδρομείου) και εργασίες συντήρησης';
$string['cutoffdate'] = 'Ημερομηνία τερματισμού (υποβολών)';
$string['cutoffdate_help'] = 'Αν οριστεί, το φόρουμ δεν θα δέχεται αναρτήσεις μετά την ημερομηνία αυτή.';
$string['cutoffdatereached'] = 'Η ημερομηνία τερματισμού αναρτήσεων σε αυτό το φόρουμ έχει περάσει, οπότε δεν μπορείτε πλέον να αναρτήσετε σε αυτό.';
$string['cutoffdatevalidation'] = 'Η ημερομηνία διακοπής δεν μπορεί να είναι νωρίτερα από την οφειλόμενη ημερομηνία.';
$string['delete'] = 'Διαγραφή';
$string['deleteddiscussion'] = 'Το θέμα συζήτησης διαγράφηκε';
$string['deletedpost'] = 'Η ανάρτηση διαγράφηκε';
$string['deletedposts'] = 'Αυτές οι αναρτήσεις έχουν διαγραφεί';
$string['deleteduser'] = 'Διαγραμμένος χρήστης';
$string['deletesure'] = 'Σίγουρα θέλετε να διαγράψετε αυτήν την ανάρτηση;';
$string['deletesureplural'] = 'Σίγουρα θέλετε να διαγράψετε αυτήν την ανάρτηση και όλες τις απαντήσεις; ({$a} αναρτήσεις)';
$string['digestmailheader'] = 'Αυτή είναι η ημερήσια σύνοψη νέων αναρτήσεων από τα φόρουμ του ιστοτόπου {$a->sitename}. Για να αλλάξετε τις προεπιλεγμένες ρυθμίσεις ηλε.ταχυδρομείου του φόρουμ, επισκεφθείτε τη σελίδα {$a->userprefs}.';
$string['digestmailpost'] = 'Αλλαγή των προτιμήσεων σύνοψης φόρουμ';
$string['digestmailpostlink'] = 'Αλλαγή των προτιμήσεων σύνοψης φόρουμ: {$a}';
$string['digestmailprefs'] = 'το προφίλ σας ως χρήστης';
$string['digestmailsubject'] = '{$a}: σύνοψη φόρουμ';
$string['digestmailtime'] = 'Ώρα αποστολής συλλογικών μηνυμάτων ηλε.ταχυδρομείου';
$string['digestsentusers'] = 'Ανασκοπήσεις ηλε.ταχυδρομείου στάλθηκαν με επιτυχία σε {$a} χρήστες.';
$string['disallowsubscribe'] = 'Οι εγγραφές δεν επιτρέπονται';
$string['disallowsubscribeteacher'] = 'Οι εγγραφές δεν επιτρέπονται (εξαιρούνται οι καθηγητές)';
$string['disallowsubscription'] = 'Εγγραφή';
$string['disallowsubscription_help'] = 'Αυτό το φόρουμ ρυθμίστηκε ώστε να μην μπορείτε να εγγραφείτε σε συζητήσεις.';
$string['discussion'] = 'Συζήτηση';
$string['discussionlistsortbycreatedasc'] = 'Ταξινόμηση κατά ημερομηνία δημιουργίας σε αύξουσα σειρά';
$string['discussionlistsortbycreateddesc'] = 'Ταξινόμηση κατά την ημερομηνία δημιουργίας σε φθίνουσα σειρά';
$string['discussionlistsortbydiscussionasc'] = 'Ταξινόμηση κατά όνομα συζήτησης σε αύξουσα σειρά';
$string['discussionlistsortbydiscussiondesc'] = 'Ταξινόμηση κατά όνομα συζήτησης σε φθίνουσα σειρά';
$string['discussionlistsortbygroupasc'] = 'Ταξινόμηση κατά ομάδα σε αύξουσα σειρά';
$string['discussionlistsortbygroupdesc'] = 'Ταξινόμηση κατά ομάδα σε φθίνουσα σειρά';
$string['discussionlistsortbylastpostasc'] = 'Ταξινόμηση κατά την ημερομηνία δημιουργίας της τελευταίας ανάρτησης σε αύξουσα σειρά';
$string['discussionlistsortbylastpostdesc'] = 'Ταξινόμηση κατά την ημερομηνία δημιουργίας της τελευταίας ανάρτησης σε φθίνουσα σειρά';
$string['discussionlistsortbyrepliesasc'] = 'Ταξινόμηση κατά τον αριθμό των απαντήσεων σε αύξουσα σειρά';
$string['discussionlistsortbyrepliesdesc'] = 'Ταξινόμηση κατά τον αριθμό των απαντήσεων σε φθίνουσα σειρά';
$string['discussionlistsortbystarterasc'] = 'Ταξινόμηση κατά όνομα αυτού που ξεκίνησε την συζήτηση, σε αύξουσα σειρά';
$string['discussionlistsortbystarterdesc'] = 'Ταξινόμηση κατά όνομα αυτού που ξεκίνησε την συζήτηση, σε φθίνουσα σειρά';
$string['discussionlocked'] = 'Αυτή η συζήτηση κλειδώθηκε κι έτσι δεν μπορείτε να απαντήσετε σε αυτή.';
$string['discussionlockingdisabled'] = 'Να μην κλειδώνονται συζητήσεις';
$string['discussionlockingheader'] = 'Κλείδωμα συζήτησης';
$string['discussionmoved'] = 'Αυτή η συζήτηση έχει μετακινηθεί στο «{$a}».';
$string['discussionmovedpost'] = 'Αυτή η συζήτηση έχει μετακινηθεί <a href="{$a->discusshref}">εδώ</a> στο φόρουμ <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Όνομα συζήτησης';
$string['discussionnownotsubscribed'] = 'Ο/Η {$a->name} ΔΕΝ θα ειδοποιηθεί για νέες αναρτήσεις στην συζήτηση «{$a->discussion}» του φόρουμ «{$a->forum}»';
$string['discussionnowsubscribed'] = 'Ο/Η {$a->name} θα ειδοποιείται για νέες αναρτήσεις στην συζήτηση «{$a->discussion}» του φόρουμ «{$a->forum}»';
$string['discussionpin'] = 'Καρφίτσωμα';
$string['discussionpinned'] = 'Καρφιτσωμένο';
$string['discussionpinned_help'] = 'Καρφιτσωμένες συζητήσεις θα εμφανίζονται στην κορυφή ενός φόρουμ';
$string['discussions'] = 'Συζητήσεις';
$string['discussionsplit'] = 'Η συζήτηση διαχωρίστηκε';
$string['discussionsstartedby'] = 'Συζητήσεις που ξεκίνησαν από τον/την {$a}';
$string['discussionsstartedbyrecent'] = 'Συζητήσεις που ξεκίνησαν πρόσφατα από τον/την {$a}';
$string['discussionsstartedbyuserincourse'] = 'Συζητήσεις που ξεκίνησαν από «{$a->fullname}» στο «{$a->coursename}»';
$string['discussionstartedby'] = 'Συζήτηση που άρχισε από τον/την {$a}';
$string['discussionsubscribed'] = 'Έχετε τώρα εγγραφεί σε αυτή τη συζήτηση.';
$string['discussionsubscribestart'] = 'Να μου αποστέλλονται ειδοποιήσεις για νέες αναρτήσεις σε αυτή τη συζήτηση';
$string['discussionsubscribestop'] = 'Δεν θέλω να ενημερώνομαι για νέες αναρτήσεις σε αυτή τη συζήτηση';
$string['discussionsubscription'] = 'Εγγραφή στη συζήτηση';
$string['discussionsubscription_help'] = 'Κάνοντας εγγραφή σε μια συζήτηση σημαίνει ότι θα λαμβάνετε ειδοποιήσεις (με ηλε.ταχυδρομείο) όταν γίνονται νέες αναρτήσεις σε αυτή τη συζήτηση.';
$string['discussionunpin'] = 'Ξεκαρφιτσώνω';
$string['discussionunsubscribed'] = 'Έχετε τώρα απεγγραφεί από αυτή τη συζήτηση.';
$string['discussthistopic'] = 'Συζήτηση αυτού του θέματος';
$string['discusstopicname'] = 'Συζητήστε το θέμα: {$a}';
$string['displayend'] = 'Τέλος εμφάνισης';
$string['displayend_help'] = 'Αυτή η ρύθμιση καθορίζει εάν πρέπει να γίνει απόκρυψη μιας ανάρτησης μετά από μια συγκεκριμένη ημερομηνία. Σημειώστε πως οι διαχειριστές μπορούν πάντα να βλέπουν αναρτήσεις σε φόρουμ.';
$string['displayenddate'] = 'Τέλος εμφάνισης: {$a}.';
$string['displaymode'] = 'Λειτουργία εμφάνισης';
$string['displayperiod'] = 'Περίοδος εμφάνισης';
$string['displaystart'] = 'Έναρξη εμφάνισης';
$string['displaystart_help'] = 'Αυτή η ρύθμιση καθορίζει εάν πρέπει να γίνει εμφάνιση μιας ανάρτησης μετά από μια συγκεκριμένη ημερομηνία. Σημειώστε πως οι διαχειριστές μπορούν πάντα να βλέπουν αναρτήσεις σε φόρουμ.';
$string['displaystartdate'] = 'Έναρξη εμφάνισης: {$a}.';
$string['displaywordcount'] = 'Εμφάνιση αριθμού λέξεων';
$string['displaywordcount_help'] = 'Αυτή η ρύθμιση καθορίζει εάν πρέπει να εμφανίζεται ή όχι το πλήθος των λέξεων κάθε ανάρτησης.';
$string['duedate'] = 'Οφειλόμενη ημερομηνία';
$string['duedate_help'] = 'Αυτό συμβαίνει όταν η ανάρτηση στο φόρουμ είναι καθυστερημένη. Αν και αυτή η ημερομηνία εμφανίζεται στο ημερολόγιο ως ημερομηνία λήξης για το φόρουμ, ανάρτηση στο φόρουμ θα εξακολουθεί να επιτρέπεται και μετά από αυτήν την ημερομηνία. Για να εμποδιστεί η ανάρτηση στο φόρουμ μετά από μια συγκεκριμένη ημερομηνία - ορίστε την ημερομηνία τερματισμού του φόρουμ.';
$string['duedatetodisplayincalendar'] = 'Προθεσμία εμφάνισης στο ημερολόγιο';
$string['eachuserforum'] = 'Κάθε άτομο θέτει ένα θέμα συζήτησης';
$string['edit'] = 'Επεξεργασία';
$string['editedby'] = 'Επεξεργασμένο από {$a->name} - αρχική υποβολή {$a->date}';
$string['editedpostupdated'] = 'Η ανάρτηση του/της {$a} ενημερώθηκε';
$string['editing'] = 'Επεξεργασία';
$string['emaildigestcompleteshort'] = 'Πλήρεις αναρτήσεις';
$string['emaildigestdefault'] = 'Προεπιλογή ({$a})';
$string['emaildigestoffshort'] = 'Χωρίς σύνοψη';
$string['emaildigestsubjectsshort'] = 'Θέματα μόνο';
$string['emaildigesttype'] = 'Επιλογές σύνοψης μηνυμάτων ηλε.ταχυδρομείου';
$string['emaildigesttype_help'] = 'Ο τύπος ειδοποίησης που θα λαμβάνετε για κάθε φόρουμ.

* Προεπιλογή - εφαρμόζεται η ρύθμιση σύνοψης που υπάρχει στο προφίλ χρήστη σας. Αν ενημερώσετε το προφίλ σας, τότε η αλλαγή θα αντικατοπτρίζεται και εδώ.
* Χωρίς σύνοψη - θα λαμβάνετε ένα μήνυμα ηλε.ταχυδρομείου ανά ανάρτηση σε φόρουμ.
* Σύνοψη - πλήρεις αναρτήσεις - θα λαμβάνετε μια σύνοψη μέσω ηλε.ταχυδρομείου ανά ημέρα που θα περιέχει το πλήρες περιεχόμενο κάθε ανάρτησης σε φόρουμ.
* Σύνοψη - θέματα μόνο - θα λαμβάνετε μια σύνοψη μέσω ηλε.ταχυδρομείου ανά ημέρα που θα περιέχει μόνο το θέμα της κάθε ανάρτησης σε φόρουμ.';
$string['emptymessage'] = 'Υπήρξε κάποιο σφάλμα στο μήνυμά σας. Ίσως το αφήσατε κενό ή το συνημμένο ήταν πολύ μεγάλο. Οι αλλαγές σας ΔΕΝ αποθηκεύτηκαν.';
$string['errorcannotlock'] = 'Δεν έχετε το δικαίωμα να κλειδώνετε συζητήσεις.';
$string['erroremptymessage'] = 'Το μήνυμα της ανάρτησης δεν μπορεί να είναι άδειο';
$string['erroremptysubject'] = 'Το θέμα της ανάρτησης δεν μπορεί να είναι άδειο.';
$string['errorenrolmentrequired'] = 'Πρέπει να εγγραφείτε σε αυτό το μάθημα για να αποκτήσετε πρόσβαση σε αυτό το περιεχόμενο';
$string['errorwhiledelete'] = 'Συνέβη ένα σφάλμα κατά την διαγραφή της καταχώρησης.';
$string['eventassessableuploaded'] = 'Έχει αναρτηθεί κάποιο περιεχόμενο.';
$string['eventcoursesearched'] = 'Το μάθημα αναζητήθηκε';
$string['eventdiscussioncreated'] = 'Η συζήτηση δημιουργήθηκε';
$string['eventdiscussiondeleted'] = 'Η συζήτηση διαγράφηκε';
$string['eventdiscussionmoved'] = 'Η συζήτηση μετακινήθηκε';
$string['eventdiscussionpinned'] = 'Η συζήτηση καρφιτσώθηκε';
$string['eventdiscussionsubscriptioncreated'] = 'Η εγγραφή στη συζήτηση δημιουργήθηκε';
$string['eventdiscussionsubscriptiondeleted'] = 'Η εγγραφή στη συζήτηση διαγράφηκε';
$string['eventdiscussionunpinned'] = 'Η συζήτηση ξεκαρφιτσώθηκε';
$string['eventdiscussionupdated'] = 'Η συζήτηση ενημερώθηκε';
$string['eventdiscussionviewed'] = 'Η συζήτηση προβλήθηκε';
$string['eventpostcreated'] = 'Η ανάρτηση δημιουργήθηκε';
$string['eventpostdeleted'] = 'Η ανάρτηση διαγράφηκε';
$string['eventpostupdated'] = 'Η ανάρτηση ενημερώθηκε';
$string['eventreadtrackingdisabled'] = 'Η ανάγνωση παρακολούθησης είναι απενεργοποιημένη';
$string['eventreadtrackingenabled'] = 'Η ανάγνωση παρακολούθησης είναι ενεργοποιημένη';
$string['eventsubscribersviewed'] = 'Οι εγγεγραμμένοι εμφανίστηκαν';
$string['eventsubscriptioncreated'] = 'Η δήλωση εγγραφής δημιουργήθηκε';
$string['eventsubscriptiondeleted'] = 'Η δήλωση εγγραφής διαγράφηκε';
$string['eventuserreportviewed'] = 'Η αναφορά χρήστη εμφανίστηκε';
$string['everyonecanchoose'] = 'Όλοι μπορούν να επιλέξουν να δηλώσουν εγγραφή';
$string['everyonecannowchoose'] = 'Όλοι έχουν τώρα την επιλογή να δηλώσουν εγγραφή';
$string['everyoneisnowsubscribed'] = 'Όλοι είναι τώρα εγγεγραμμένοι σε αυτό το φόρουμ.';
$string['everyoneissubscribed'] = 'Όλοι είναι εγγεγραμμένοι σε αυτό το φόρουμ.';
$string['existingsubscribers'] = 'Υπάρχοντες χρήστες με δήλωση συμμετοχής';
$string['export'] = 'Εξαγωγή';
$string['exportattachmentname'] = 'Εξαγωγή συνημμένου {$a} σε χαρτοφυλάκιο';
$string['exportdiscussion'] = 'Εξαγωγή όλης της συζήτησης σε χαρτοφυλάκιο';
$string['exporthumandates'] = 'Ημερομηνίες αναγνώσιμες από ανθρώπους';
$string['exporthumandates_help'] = 'Εάν οι ημερομηνίες πρέπει να εξάγονται σε μορφότυπο που να μπορεί να διαβαστεί από ανθρώπους ή ως χρονοσήμανση (ακολουθία αριθμών).';
$string['exportoptions'] = 'Επιλογές εξαγωγής';
$string['exportstriphtml'] = 'Αφαίρεση HTML';
$string['exportstriphtml_help'] = 'Εάν οι ετικέτες HTML όπως π.χ. p και br θα πρέπει να αφαιρεθούν από το μήνυμα της ανάρτησης στο φόρουμ.';
$string['favourites'] = 'Επισημασμένο με αστερίσκο';
$string['favouriteupdated'] = 'Η επιλογή σας για αστερίσκο ενημερώθηκε.';
$string['firstpost'] = 'Πρώτη ανάρτηση';
$string['forcedreadtracking'] = 'Επιτρέπεται υποχρεωτική παρακολούθηση ανάγνωσης';
$string['forcedreadtracking_desc'] = 'Επιτρέπει στα φόρουμ να ρυθμίζονται σε υποχρεωτική παρακολούθηση ανάγνωσης. Θα έχει αποτέλεσμα μειωμένη απόδοση για κάποιους χρήστες, συγκεκριμένα σε μαθήματα με πολλά φόρουμ και αναρτήσεις. Όταν είναι απενεργοποιημένο, όποιο φόρουμ ρυθμίστηκε προηγουμένως σε υποχρεωτικό τώρα θα είναι προαιρετικό.';
$string['forcesubscribed'] = 'Αυτό το φόρουμ εφαρμόζει υποχρεωτική εγγραφή για όλους';
$string['forcesubscribed_help'] = 'Αυτό το φόρουμ έχει ρυθμιστεί να μην επιτρέπει απεγγραφή από τις συζητήσεις.';
$string['forum'] = 'Φόρουμ';
$string['forum:addinstance'] = 'Προσθήκη νέου φόρουμ';
$string['forum:addnews'] = 'Προσθήκη ανακοινώσεων';
$string['forum:addquestion'] = 'Προσθήκη ερώτησης';
$string['forum:allowforcesubscribe'] = 'Επιτρέπεται υποχρεωτική εγγραφή';
$string['forum:canoverridecutoff'] = 'Ανάρτηση σε φόρουμ μετά την ημερομηνία λήξης τους';
$string['forum:canoverridediscussionlock'] = 'Απάντηση (και) σε κλειδωμένες συζητήσεις';
$string['forum:canposttomygroups'] = 'Μπορεί να γίνει ανάρτηση σε όλες τις ομάδες στις οποίες έχετε πρόσβαση';
$string['forum:cantogglefavourite'] = 'Επισήμανση συζητήσεων με αστερίσκο';
$string['forum:createattachment'] = 'Δημιουργία συνημμένων';
$string['forum:deleteanypost'] = 'Διαγραφή οποιασδήποτε ανάρτησης (οποτεδήποτε)';
$string['forum:deleteownpost'] = 'Διαγραφή προσωπικών αναρτήσεων (μέσα στη διορία)';
$string['forum:editanypost'] = 'Επεξεργασία οποιασδήποτε ανάρτησης';
$string['forum:exportdiscussion'] = 'Εξαγωγή ολόκληρης της συζήτησης';
$string['forum:exportforum'] = 'Εξαγωγή φόρουμ';
$string['forum:exportownpost'] = 'Εξαγωγή των δικών σας αναρτήσεων';
$string['forum:exportpost'] = 'Εξαγωγή ανάρτησης';
$string['forum:grade'] = 'Βαθμολόγηση του φόρουμ';
$string['forum:managesubscriptions'] = 'Διαχείριση δηλώσεων εγγραφής';
$string['forum:movediscussions'] = 'Μετακίνηση συζητήσεων';
$string['forum:pindiscussions'] = 'Καρφίτσωμα συζητήσεων';
$string['forum:postprivatereply'] = 'Απάντηση ιδιωτικά (όχι δημόσια) στις αναρτήσεις';
$string['forum:postwithoutthrottling'] = 'Εξαίρεση από ανώτατο όριο αναρτήσεων';
$string['forum:rate'] = 'Βαθμολόγηση αναρτήσεων';
$string['forum:readprivatereplies'] = 'Εμφάνιση ιδιωτικών απαντήσεων';
$string['forum:replynews'] = 'Απάντηση στις ανακοινώσεις';
$string['forum:replypost'] = 'Απάντηση στις αναρτήσεις';
$string['forum:splitdiscussions'] = 'Διαίρεση συζητήσεων';
$string['forum:startdiscussion'] = 'Έναρξη νέων συζητήσεων';
$string['forum:viewallratings'] = 'Εμφάνιση όλων των πρώτων αξιολογήσεων που δόθηκαν ατομικά';
$string['forum:viewanyrating'] = 'Εμφάνιση των συνολικών αξιολογήσεων που έλαβε ο καθένας';
$string['forum:viewdiscussion'] = 'Εμφάνιση συζητήσεων';
$string['forum:viewhiddentimedposts'] = 'Εμφάνιση κρυμμένων χρονομετρημένων αναρτήσεων';
$string['forum:viewqandawithoutposting'] = 'Πάντα να γίνεται προβολή των αναρτήσεων Ερωτήσεων και Απαντήσεων';
$string['forum:viewrating'] = 'Εμφάνιση της συνολικής βαθμολογίας που λάβατε';
$string['forum:viewsubscribers'] = 'Εμφάνιση εγγεγραμμένων';
$string['forumauthorhidden'] = 'Συγγραφέας (κρυμμένος)';
$string['forumblockingalmosttoomanyposts'] = 'Πλησιάζετε το ανώτατο όριο αναρτήσεων. Έχετε αναρτήσει {$a->numposts} φορές στα τελευταία {$a->blockperiod} και το όριο είναι {$a->blockafter} αναρτήσεις.';
$string['forumbodydeleted'] = 'Το περιεχόμενο αυτής της ανάρτησης στο φόρουμ έχει καταργηθεί και δεν είναι πλέον δυνατή η πρόσβαση.';
$string['forumbodyhidden'] = 'Αυτή η ανάρτηση είναι προς το παρόν κρυφή, πιθανότατα επειδή πρέπει να την δημοσιεύσετε πρώτα στη συζήτηση και πρέπει να σταλούν οι ειδοποιήσεις για δημοσιεύσεις φόρουμ. Μια άλλη πιθανότητα είναι ότι η τρέχουσα ώρα δεν είναι εντός της περιόδου προβολής που έχει οριστεί για την ανάρτηση.';
$string['forumgrader'] = 'Βαθμολογητής φόρουμ';
$string['forumgradingnavigation'] = 'Πλοήγηση βαθμολόγησης φόρουμ';
$string['forumgradingpanel'] = 'Πίνακας βαθμολόγησης φόρουμ';
$string['forumintro'] = 'Περιγραφή';
$string['forumname'] = 'Όνομα φόρουμ';
$string['forumposts'] = 'Αναρτήσεις φόρουμ';
$string['forums'] = 'Φόρουμ';
$string['forumsubjectdeleted'] = 'Αυτή η ανάρτηση στο φόρουμ έχει καταργηθεί';
$string['forumsubjecthidden'] = 'Θέμα (κρυμμένο)';
$string['forumtracked'] = 'Οι μη αναγνωσμένες αναρτήσεις παρακολουθούνται';
$string['forumtrackednot'] = 'Οι μη αναγνωσμένες αναρτήσεις δεν παρακολουθούνται';
$string['forumtype'] = 'Τύπος φόρουμ';
$string['forumtype_help'] = 'Υπάρχουν 5 τύποι φόρουμ:

* Απλό φόρουμ μίας συζήτησης - Ένα μοναδικό θέμα συζήτησης στο οποίο όλοι μπορούν να απαντήσουν (δεν μπορεί να χρησιμοποιηθεί για ξεχωριστές ομάδες).
* Κάθε άτομο αναρτά μία συζήτηση - Κάθε μαθητής μπορεί να αναρτήσει ακριβώς ένα νέο θέμα συζήτησης, στο οποίο μπορεί μετά να απαντήσει οποιοσδήποτε.
* Φόρουμ Ερώτησης & Απάντησης - Οι μαθητές πρέπει πρώτα να αναρτήσουν τις απόψεις τους προτού δουν τις αναρτήσεις των άλλων μαθητών.
* Τυπικό φόρουμ με μορφή ιστολογίου - Ένα ανοιχτό φόρουμ όπου οποιοσδήποτε μπορεί να αρχίσει μια νέα συζήτηση οποτεδήποτε, και στο οποίο τα θέματα συζήτησης εμφανίζονται σε μια σελίδα με συνδέσμους «Συζήτηση αυτού του θέματος».
* Τυπικό φόρουμ γενικής χρήσης - Ένα ανοιχτό φόρουμ όπου οποιοσδήποτε μπορεί να ξεκινήσει μια νέα συζήτηση οποτεδήποτε.';
$string['generalforum'] = 'Τυπικό φόρουμ γενικής χρήσης';
$string['generalforums'] = 'Γενικά φόρουμ';
$string['grade_forum_header'] = 'Βαθμολόγηση ολόκληρου του φόρουμ';
$string['grade_forum_name'] = 'Ολόκληρο το φόρουμ';
$string['grade_forum_title'] = 'Βαθμός';
$string['grade_rating_name'] = 'Αξιολόγηση';
$string['graded'] = 'Βαθμολογήθηκε';
$string['gradedby'] = 'Βαθμολογήθηκε από';
$string['gradeforrating'] = 'Βαθμός για αξιολόγηση: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Απόκρυψη βαθμού για αξιολόγηση';
$string['gradeforwholeforum'] = 'Βαθμός για το φόρουμ: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Απόκρυψη βαθμού για το φόρουμ';
$string['gradeitem:forum'] = 'Φόρουμ';
$string['gradeitemnameforrating'] = 'Αξιολόγηση {$a->name}';
$string['gradeitemnameforwholeforum'] = 'Ολόκληρο το φόρουμ {$a->name}';
$string['grades:gradesavedfor'] = 'Ο βαθμός αποθηκεύτηκε για τον/την {$a->fullname}';
$string['grades:gradesavefailed'] = 'Αδυναμία αποθήκευσης βαθμού για τον/την {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Βαθμολόγηση χρηστών';
$string['grading'] = 'Βαθμολόγηση';
$string['gradingstatus'] = 'Κατάσταση βαθμολόγησης:';
$string['hiddenforumpost'] = 'Κρυφή ανάρτηση σε φόρουμ';
$string['hidegraderpanel'] = 'Απόκρυψη πίνακα βαθμολογητή';
$string['hidepreviousrepliescount'] = 'Απόκρυψη προηγουμένων απαντήσεων ({$a})';
$string['hideusersearch'] = 'Απόκρυψη αναζήτησης χρήστη';
$string['indexoutoftotal'] = '{$a->index} στα {$a->total}';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης φόρουμ';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Φόρουμ.';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης φόρουμ';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες Φόρουμ κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή, Εμφάνιση ανατροφοδότησης, Σχόλιο στην ανατροφοδότηση, Επανυποβολή μετά την εμφάνιση της ανατροφοδότησης)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος Φόρουμ';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα Φόρουμ.';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος Φόρουμ';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες Φόρουμ κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία συμμετοχή, Συμμετέχων μόνος, Συμμετέχων με άλλους)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['inforum'] = 'σε {$a}';
$string['inreplyto'] = 'Σε απάντηση σε {$a}';
$string['introblog'] = 'Οι αναρτήσεις σε αυτό το φόρουμ αντιγράφηκαν εδώ αυτόματα από ιστολόγια χρηστών αυτού του μαθήματος, διότι αυτές οι αναρτήσεις ιστολογίου δεν είναι πλέον διαθέσιμες';
$string['intronews'] = 'Γενικά νέα και ανακοινώσεις';
$string['introsocial'] = 'Ένα ανοιχτό φόρουμ για κουβεντούλα για οτιδήποτε θέλετε.';
$string['introteacher'] = 'Ένα φόρουμ μόνο διδασκόντων για σημειώσεις και συζήτηση';
$string['invalidaccess'] = 'Η πρόσβαση σε αυτή τη σελίδα δεν ήταν σωστή';
$string['invaliddigestsetting'] = 'Έχει δοθεί μη έγκυρη ρύθμιση σύνοψης μηνυμάτων ηλε.ταχυδρομείου';
$string['invaliddiscussionid'] = 'Το αναγνωριστικό της συζήτησης ήταν λανθασμένο ή δεν υπάρχει πλέον';
$string['invalidforcesubscribe'] = 'Άκυρη κατάσταση υποχρεωτικής εγγραφής';
$string['invalidforumid'] = 'Το αναγνωριστικό του φόρουμ ήταν λανθασμένο';
$string['invalidparentpostid'] = 'Το αναγνωριστικό του γονικού της ανάρτησης ήταν λανθασμένο';
$string['invalidpostid'] = 'Μη έγκυρο αναγνωριστικό ανάρτησης - {$a}';
$string['lastpost'] = 'Τελευταία ανάρτηση';
$string['learningforums'] = 'Εκπαιδευτικά φόρουμ';
$string['lockdiscussion'] = 'Κλείδωμα αυτής της συζήτησης';
$string['lockdiscussionafter'] = 'Κλείδωμα συζητήσεων μετά από περίοδο αδράνειας';
$string['lockdiscussionafter_help'] = 'Οι συζητήσεις μπορούν να κλειδωθούν αυτόματα αφού παρέλθει ένα καθορισμένο χρονικό διάστημα από την τελευταία απάντηση. Οι χρήστες με την δυνατότητα απάντησης σε κλειδωμένες συζητήσεις μπορούν να τις ξεκλειδώσουν απαντώντας σε αυτές.';
$string['locked'] = 'Κλειδωμένη';
$string['lockupdated'] = 'Η επιλογή κλειδώματος ενημερώθηκε.';
$string['longpost'] = 'Μεγάλη ανάρτηση';
$string['mailnow'] = 'Αποστολή ειδοποιήσεων για αναρτήσεις σε φόρουμ χωρίς αναμονή για χρόνο επανεπεξεργασίας';
$string['managesubscriptionsoff'] = 'Τερματίστε τη διαχείριση των δηλώσεων εγγραφής';
$string['managesubscriptionson'] = 'Διαχείριση δηλώσεων εγγραφής';
$string['manydiscussions'] = 'Συζητήσεις ανά σελίδα';
$string['markalldread'] = 'Χαρακτηρισμός όλων των αναρτήσεων σε αυτήν τη συζήτηση ως αναγνωσμένες.';
$string['markallread'] = 'Χαρακτηρισμός όλων των αναρτήσεων σε αυτό το φόρουμ ως αναγνωσμένες.';
$string['markasread'] = 'Σημείωση ως αναγνωσμένου';
$string['markasreadonnotification'] = 'Κατά την αποστολή ειδοποίησης για ανάρτηση σε φόρουμ';
$string['markasreadonnotification_help'] = 'Όταν ειδοποιείστε για μια ανάρτηση σε φόρουμ, μπορείτε να επιλέξετε εάν αυτό θα επισημαίνει την ανάρτηση ως αναγνωσμένη όσον αφορά την παρακολούθηση του φόρουμ.';
$string['markasreadonnotificationno'] = 'Να μην επισημαίνεται η ανάρτηση ως αναγνωσμένη';
$string['markasreadonnotificationyes'] = 'Να επισημαίνεται η ανάρτηση ως αναγνωσμένη';
$string['markread'] = 'Επισήμανση ως αναγνωσμένης';
$string['markreadbutton'] = 'Επισήμανση ως <br /> αναγνωσμένης';
$string['markunread'] = 'Επισήμανση ως μη αναγνωσμένης';
$string['markunreadbutton'] = 'Επισήμανση ως <br /> μη αναγνωσμένης';
$string['maxattachments'] = 'Μέγιστος αριθμός συνημμένων';
$string['maxattachments_help'] = 'Αυτή η ρύθμιση ορίζει τον μέγιστο αριθμό αρχείων που μπορεί να επισυναφθούν σε μια ανάρτηση σε φόρουμ.';
$string['maxattachmentsize'] = 'Μέγιστο μέγεθος συνημμένου';
$string['maxattachmentsize_help'] = 'Αυτή η ρύθμιση ορίζει το μέγιστο μέγεθος συνημμένου αρχείου που μπορεί να επισυναφθεί σε μια ανάρτηση σε φόρουμ.';
$string['maxtimehaspassed'] = 'Συγγνώμη, αλλά ο μέγιστος χρόνος για την επεξεργασία αυτού του μηνύματος ({$a}) έχει παρέλθει!';
$string['message'] = 'Μήνυμα';
$string['messageinboundattachmentdisallowed'] = 'Δεν είναι δυνατή η ανάρτηση της απάντησής σας, διότι περιλαμβάνει ένα συνημμένο και το φόρουμ δεν επιτρέπει συνημμένα.';
$string['messageinboundfilecountexceeded'] = 'Δεν είναι δυνατή η ανάρτηση της απάντησής σας, διότι περιλαμβάνει περισσότερα από τον μέγιστο αριθμό συνημμένων που επιτρέπονται για το φόρουμ ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Δεν είναι δυνατή η ανάρτηση της απάντησής σας, διότι το συνολικό μέγεθος συνημμένων ({$a->filesize}) είναι μεγαλύτερο από το μέγιστο επιτρεπόμενο μέγεθος για το φόρουμ ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Δεν είναι δυνατή η ανάρτηση της απάντησής σας, διότι το φόρουμ είναι προς το παρόν μη διαθέσιμο.';
$string['messageinboundnopostforum'] = 'Δεν είναι δυνατή η ανάρτηση της απάντησής σας, διότι δεν έχετε δικαίωμα ανάρτησης στο φόρουμ {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Δεν είναι δυνατή η ανάρτηση της απάντησής σας. Έχετε υπερβεί το όριο αναρτήσεων που έχει οριστεί για αυτό το φόρουμ.';
$string['messageprovider:digests'] = 'Συνόψεις φόρουμ στα οποία έχετε εγγραφεί';
$string['messageprovider:posts'] = 'Αναρτήσεις σε φόρουμ στα οποία έχετε εγγραφεί';
$string['missingsearchterms'] = 'Οι ακόλουθοι όροι αναζήτησης εμφανίζονται μόνο στο HTML markup αυτού του μηνύματος:';
$string['modeflatnewestfirst'] = 'Εμφάνιση απαντήσεων οριζοντίως, με την πιο πρόσφατη πρώτη';
$string['modeflatoldestfirst'] = 'Εμφάνιση απαντήσεων οριζοντίως, με την παλαιότερη πρώτη';
$string['modenested'] = 'Εμφάνιση απαντήσεων σε φωλιασμένη μορφή';
$string['modenestedv2'] = 'Εμφάνιση απαντήσεων στην πειραματική φωλιασμένη μορφή';
$string['modethreaded'] = 'Εμφάνιση απαντήσεων σε νηματική μορφή';
$string['modulename'] = 'Φόρουμ';
$string['modulename_help'] = 'Το άρθρωμα δραστηριότητας φόρουμ δίνει την δυνατότητα στους συμμετέχοντες να έχουν ασύγχρονες συζητήσεις (δηλαδή συζητήσεις που λαμβάνουν χώρα σε μια εκτεταμένη χρονική περίοδο).

Υπάρχουν αρκετοί τύποι φόρουμ για να επιλέξετε, όπως ένα τυπικό φόρουμ όπου οποιοσδήποτε μπορεί να ξεκινήσει μια νέα συζήτηση οποτεδήποτε· ένα φόρουμ όπου κάθε μαθητής μπορεί να αναρτήσει ακριβώς μια συζήτηση· ή ένα φόρουμ ερώτησης και απάντησης όπου οι μαθητές πρέπει πρώτα να αναρτήσουν προτού να μπορούν να δουν τις αναρτήσεις των άλλων μαθητών. Ένας διδάσκων μπορεί να επιτρέψει αρχεία να επισυνάπτονται σε αναρτήσεις φόρουμ. Επισυναπτόμενες εικόνες εμφανίζονται στην ανάρτηση του φόρουμ.

Οι συμμετέχοντες μπορούν να εγγραφούν σε ένα φόρουμ για να λαμβάνουν ειδοποιήσεις για νέες αναρτήσεις στο φόρουμ. Ένας διδάσκων μπορεί να ορίσει την εγγραφή ως προαιρετική, υποχρεωτική ή αυτόματη ή να εμποδίσει την εγγραφή εντελώς. Αν απαιτείται, οι μαθητές μπορούν να μπλοκαριστούν από το να αναρτούν περισσότερες από έναν δεδομένο αριθμό αναρτήσεων μέσα σε δεδομένο χρονικό διάστημα· αυτό μπορεί να αποτρέψει άτομα από το να κυριαρχήσουν στις συζητήσεις.

Οι αναρτήσεις σε φόρουμ μπορούν να βαθμολογηθούν από διδάσκοντες ή μαθητές (αξιολόγηση από ομότιμους). Οι βαθμολογίες μπορούν να συναθροιστούν για να σχηματίσουν έναν τελικό βαθμό που καταγράφεται στο βαθμολόγιο.

Τα φόρουμ μπορούν να έχουν πολλές χρήσεις, όπως ως:

* Ένας κοινωνικός χώρος ώστε οι μαθητές να αλληλογνωριστούν
* Για ανακοινώσεις ενός μαθήματος (με χρήση ενός φόρουμ ανακοινώσεων με υποχρεωτική εγγραφή)
* Για συζήτηση του περιεχομένου του μαθήματος ή ανάγνωση υλικού
* Για συνέχιση διαδικτυακά ενός θέματος που τέθηκε προηγουμένως σε μια πρόσωπο με πρόσωπο σύνοδο
* Για συζήτηση μόνο για διδάσκοντες (με χρήση κρυφού φόρουμ)
* Ένα κέντρο βοήθειας όπου εκπαιδευτές και μαθητές μπορούν να δώσουν συμβουλές
* Μια περιοχή υποστήριξης ένας-προς-έναν για ιδιαίτερες επικοινωνίες διδάσκοντα-μαθητή (με χρήση φόρουμ με χωριστές ομάδες και με έναν μαθητή ανά ομάδα)
* Για επέκταση δραστηριοτήτων, για παράδειγμα «σπαζοκεφαλιές» για να σκεφτούν βαθιά και σοβαρά οι μαθητές και να προτείνουν λύσεις';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Φόρουμ';
$string['more'] = 'περισσότερα';
$string['movedmarker'] = '(Μετακινήθηκε)';
$string['movethisdiscussionlabel'] = 'Μετακίνηση της τρέχουσας συζήτησης στο καθορισμένο φόρουμ';
$string['movethisdiscussionto'] = 'Μετακίνηση αυτής της συζήτησης στο...';
$string['mustprovidediscussionorpost'] = 'Πρέπει να παρέχετε είτε ένα αναγνωριστικό συζήτησης ή αναγνωριστικό ανάρτησης για εξαγωγή.';
$string['myprofileotherdis'] = 'Συζητήσεις φόρουμ';
$string['myprofileowndis'] = 'Οι δικές μου συζητήσεις φόρουμ';
$string['myprofileownpost'] = 'Οι δικές μου αναρτήσεις φόρουμ';
$string['namenews'] = 'Ανακοινώσεις';
$string['namenews_help'] = 'Το φόρουμ ανακοινώσεων μαθήματος είναι ένα ειδικό φόρουμ για ανακοινώσεις και δημιουργείται αυτόματα όταν δημιουργείται ένα μάθημα. Ένα μάθημα μπορεί να έχει μόνο ένα φόρουμ ανακοινώσεων. Μόνο διδάσκοντες και διαχειριστές μπορούν να αναρτήσουν εδώ. Το μπλοκ «Τελευταίες ανακοινώσεις» θα εμφανίζει τις πρόσφατες ανακοινώσεις.';
$string['namesocial'] = 'Κοινωνικό φόρουμ';
$string['nameteacher'] = 'Φόρουμ διδασκόντων';
$string['newforumposts'] = 'Νέες αναρτήσεις φόρουμ';
$string['nextdiscussiona'] = 'Επόμενη συζήτηση: {$a}';
$string['nextuser'] = 'Αποθηκεύστε τις αλλαγές και προχωρήστε στον επόμενο χρήστη';
$string['noattachments'] = 'Δεν υπάρχουν συνημμένα σε αυτή τη ανάρτηση';
$string['nodiscussions'] = 'Δεν υπάρχουν ακόμα θέματα συζήτησης σε αυτό το φόρουμ';
$string['nodiscussionsstartedby'] = 'Καμία συζήτηση δεν ξεκίνησε από το χρήστη {$a}';
$string['nodiscussionsstartedbyyou'] = 'Δεν έχετε ξεκινήσει κάποια συζήτηση ακόμα';
$string['noguestpost'] = 'Λυπούμαστε, οι επισκέπτες δεν επιτρέπεται να κάνουν αναρτήσεις.';
$string['noguestsubscribe'] = 'Λυπούμαστε, οι επισκέπτες δεν επιτρέπεται να κάνουν εγγραφές.';
$string['noguesttracking'] = 'Λυπούμαστε, οι επισκέπτες δεν επιτρέπεται να ρυθμίζουν ιδιότητες παρακολούθησης.';
$string['nomorepostscontaining'] = 'Δεν βρέθηκαν άλλες αναρτήσεις που να περιέχουν το «{$a}»';
$string['nonews'] = 'Δεν έχουν αναρτηθεί ακόμα ανακοινώσεις';
$string['noonecansubscribenow'] = 'Δεν επιτρέπονται πλέον εγγραφές';
$string['nopermissiontosubscribe'] = 'Δεν έχετε το δικαίωμα να δείτε τους εγγεγραμμένους του φόρουμ';
$string['nopermissiontoview'] = 'Δεν έχετε δικαίωμα να δείτε αυτή την ανάρτηση';
$string['nopostforum'] = 'Συγνώμη, δεν επιτρέπεται να αναρτήσετε σε αυτό το φόρουμ';
$string['noposts'] = 'Καμία ανάρτηση';
$string['nopostsmadebyuser'] = 'Ο/Η {$a} δεν έχει κάνει καμία ανάρτηση';
$string['nopostsmadebyyou'] = 'Δεν έχετε αναρτήσει κάτι';
$string['noquestions'] = 'Δεν υπάρχουν ερωτήσεις ακόμα σε αυτό το φόρουμ';
$string['nosubscribers'] = 'Δεν υπάρχουν δηλώσεις εγγραφής ακόμη για αυτό το φόρουμ';
$string['notexists'] = 'Η συζήτηση δεν υπάρχει πλέον';
$string['notgraded'] = 'Μη βαθμολογημένο';
$string['nothingnew'] = 'Τίποτα καινούργιο για {$a}';
$string['notingroup'] = 'Συγγνώμη, αλλά πρέπει να είστε μέλος ομάδας για να δείτε αυτό το φόρουμ.';
$string['notinstalled'] = 'Το άρθρωμα φόρουμ δεν έχει εγκατασταθεί';
$string['notlocked'] = 'Κλείδωμα';
$string['notpartofdiscussion'] = 'Αυτή η ανάρτηση δεν είναι μέρος κάποιας συζήτησης!';
$string['notrackforum'] = 'Να μην παρακολουθούνται μη αναγνωσμένες αναρτήσεις';
$string['notsubscribed'] = 'Εγγραφείτε';
$string['nousersmatch'] = 'Δεν βρέθηκε κανένας χρήστης με τα κριτήρια που δόθηκαν';
$string['noviewdiscussionspermission'] = 'Δεν έχετε το δικαίωμα εμφάνισης συζητήσεων σε αυτό το φόρουμ.';
$string['nowallsubscribed'] = 'Έχετε τώρα εγγραφεί σε όλα τα φόρουμ στο {$a}.';
$string['nowallunsubscribed'] = 'Δεν είστε πλέον εγγεγραμμένος σε κανένα φόρουμ στο {$a}.';
$string['nowgradinguser'] = 'Βαθμολόγηση τώρα {$a}';
$string['nownotsubscribed'] = 'Ο/Η «{$a->name}» ΔΕΝ θα ειδοποιείται (με ηλε.ταχυδρομείο) για νέες αναρτήσεις στο φόρουμ «{$a->forum}».';
$string['nownottracking'] = 'Ο/Η «{$a->name}» δεν παρακολουθεί πια το φόρουμ «{$a->forum}».';
$string['nowsubscribed'] = 'Ο/Η «{$a->name}» θα ειδοποιείται (με ηλε.ταχυδρομείο) για νέες αναρτήσεις στο φόρουμ «{$a->forum}»';
$string['nowtracking'] = 'Ο/Η «{$a->name}» θα παρακολουθεί εφεξής το φόρουμ «{$a->forum}».';
$string['numberofreplies'] = 'Αριθμός απαντήσεων: {$a}';
$string['numposts'] = '{$a} αναρτήσεις';
$string['olderdiscussions'] = 'Παλαιότερες συζητήσεις';
$string['oldertopics'] = 'Παλαιότερα θέματα';
$string['oldpostdays'] = 'Ανάγνωση μετά από ημέρες';
$string['page-mod-forum-discuss'] = 'Σελίδα νήματος συζήτησης αρθρώματος φόρουμ';
$string['page-mod-forum-view'] = 'Κύρια σελίδα αρθρώματος φόρουμ';
$string['page-mod-forum-x'] = 'Οποιαδήποτε σελίδα αρθρώματος φόρουμ';
$string['parent'] = 'Εμφάνιση γονικού';
$string['parentofthispost'] = 'Γονικό αυτού του μηνύματος';
$string['permalink'] = 'Μόνιμος σύνδεσμος';
$string['permanentlinktoparentpost'] = 'Μόνιμος σύνδεσμος με την γονική αυτής της ανάρτησης';
$string['permanentlinktopost'] = 'Μόνιμος σύνδεσμος σε αυτή την ανάρτηση';
$string['pindiscussion'] = 'Καρφίτσωμα αυτής της συζήτησης';
$string['pinupdated'] = 'Η επιλογή καρφιτσώματος ενημερώθηκε.';
$string['pluginadministration'] = 'Διαχείριση φόρουμ';
$string['pluginname'] = 'Φόρουμ';
$string['postadded'] = '<p>Το μήνυμά σας προστέθηκε επιτυχώς.</p><p>Έχετε {$a} να το επεξεργαστείτε αν θέλετε να κάνετε αλλαγές.</p>';
$string['postaddedsuccess'] = 'Η ανάρτησή σας προστέθηκε με επιτυχία.';
$string['postaddedtimeleft'] = 'Έχετε {$a} για να την επεξεργαστείτε εάν θέλετε να κάνετε τυχόν αλλαγές.';
$string['postbymailsuccess'] = 'Η απάντησή σας «{$a->subject}» αναρτήθηκε με επιτυχία: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Η απάντησή σας <a href="{$a->discussionurl}">{$a->subject}</a> αναρτήθηκε με επιτυχία.';
$string['postbyuser'] = '«{$a->post}» από «{$a->user}»';
$string['postincontext'] = 'Δείτε αυτήν την ανάρτηση στα συμφραζόμενά της';
$string['postisprivatereply'] = 'Αυτή η ανάρτηση είναι ιδιωτική. Δεν είναι ορατή σε άλλους χρήστες.';
$string['postmailinfo'] = 'Αυτό είναι ένα αντίγραφο ενός μηνύματος που δημοσιεύτηκε εκεί:
 {$a}';
$string['postmailinfolink'] = 'Αυτό είναι ένα αντίγραφο ενός μηνύματος που αναρτήθηκε στο {$a->coursename}.

Για να απαντήσετε, πατήστε σε αυτόν το σύνδεσμο: {$a->replylink}';
$string['postmailnow'] = '<p> Αυτή η ανάρτηση θα αποσταλεί αμέσως με ηλε.ταχυδρομείο σε όλους τους εγγεγραμμένους στο φόρουμ.</p>';
$string['postmailreply'] = 'Για να απαντήσετε κάντε κλικ σε αυτόν τον σύνδεσμο: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Δείχνει περισσότερο ξεχωριστή γνώση';
$string['postrating2'] = 'Ξεχωριστή και συνδεδεμένη';
$string['postrating3'] = 'Δείχνει περισσότερο συνδεδεμένη γνώση';
$string['posts'] = 'Αναρτήσεις';
$string['postsfrom'] = 'Αναρτήσεις από';
$string['postsmadebyuser'] = 'Αναρτήσεις που έγιναν από τον/την {$a}';
$string['postsmadebyuserincourse'] = 'Αναρτήσεις που έγιναν από τον/την {$a->fullname} στο μάθημα {$a->coursename}';
$string['poststo'] = 'Αναρτήσεις από';
$string['posttoforum'] = 'Ανάρτηση στο φόρουμ';
$string['posttomygroups'] = 'Αναρτήστε ένα αντίγραφο σε όλες τις ομάδες';
$string['posttomygroups_help'] = 'Αναρτά ένα αντίγραφο αυτού του μηνύματος σε όλες τις ομάδες στις οποίες έχετε πρόσβαση. Οι συμμετέχοντες σε ομάδες στις οποίες δεν έχετε πρόσβαση δεν θα βλέπουν αυτήν την ανάρτηση';
$string['postupdated'] = 'Η ανάρτησή σας ενημερώθηκε';
$string['potentialsubscribers'] = 'Πιθανοί εγγεγραμμένοι';
$string['prevdiscussiona'] = 'Προηγούμενη συζήτηση: {$a}';
$string['previoususer'] = 'Αποθηκεύστε τις αλλαγές και προχωρήστε στον προηγούμενο χρήστη';
$string['privacy:digesttypenone'] = 'Δεν διατηρούμε δεδομένα σχετικά με έναν προτιμώμενο τύπο σύνοψης φόρουμ για αυτό το φόρουμ.';
$string['privacy:digesttypepreference'] = 'Έχετε επιλέξει να λάβετε τον ακόλουθο τύπο σύνοψης φόρουμ: «{$a->type}».';
$string['privacy:discussionsubscriptionpreference'] = 'Έχετε επιλέξει την ακόλουθη προτίμηση εγγραφής σε συζήτηση για αυτό το φόρουμ: «{$a->preference}»';
$string['privacy:metadata:core_rating'] = 'Το φόρουμ χρησιμοποιεί το υποσύστημα αξιολόγησης για να υποστηρίξει την αξιολόγηση των αναρτήσεων.';
$string['privacy:metadata:core_tag'] = 'Το φόρουμ χρησιμοποιεί το υποσύστημα ετικετών για να υποστηρίζει τις ετικέτες των αναρτήσεων.';
$string['privacy:metadata:forum_digests'] = 'Πληροφορίες σχετικά με τις προτιμήσεις σύνοψης για κάθε φόρουμ.';
$string['privacy:metadata:forum_digests:forum'] = 'Το φόρουμ στο οποίο έγινε εγγραφή.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Η προτίμηση σύνοψης.';
$string['privacy:metadata:forum_digests:userid'] = 'Το αναγνωριστικό του χρήστη με την προτίμηση σύνοψης.';
$string['privacy:metadata:forum_discussion_subs'] = 'Πληροφορίες σχετικά με τις εγγραφές σε μεμονωμένες συζητήσεις φόρουμ.';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Η ταυτότητα της συζήτησης στην οποία έγινε εγγραφή.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Η ώρα έναρξης της δήλωσης εγγραφής.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Το αναγνωριστικό του χρήστη με τη δήλωση εγγραφής σε συζήτηση.';
$string['privacy:metadata:forum_discussions'] = 'Πληροφορίες σχετικά με τις μεμονωμένες συζητήσεις φόρουμ που έχει δημιουργήσει ένας χρήστης.';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - τι αποθηκεύει αυτό το πεδίο';
$string['privacy:metadata:forum_discussions:name'] = 'Το όνομα της συζήτησης, όπως επιλέχθηκε από τον συγγραφέα.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Πότε τροποποιήθηκε τελευταία η συζήτηση.';
$string['privacy:metadata:forum_discussions:userid'] = 'Το αναγνωριστικό του χρήστη που δημιούργησε τη συζήτηση';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Το αναγνωριστικό του χρήστη που τροποποίησε τελευταία τη συζήτηση με κάποιο τρόπο.';
$string['privacy:metadata:forum_grades'] = 'Δεδομένα βαθμών για το φόρουμ';
$string['privacy:metadata:forum_grades:forum'] = 'Το φόρουμ που βαθμολογήθηκε';
$string['privacy:metadata:forum_grades:grade'] = 'Ο βαθμός που δόθηκε';
$string['privacy:metadata:forum_grades:userid'] = 'Ο χρήστης που βαθμολογήθηκε';
$string['privacy:metadata:forum_posts'] = 'Πληροφορίες σχετικά με τις προτιμήσεις σύνοψης για κάθε φόρουμ.';
$string['privacy:metadata:forum_posts:created'] = 'Πότε δημιουργήθηκε η ανάρτηση.';
$string['privacy:metadata:forum_posts:discussion'] = 'Η συζήτηση στην οποία βρίσκεται η ανάρτηση.';
$string['privacy:metadata:forum_posts:message'] = 'Το μήνυμα της ανάρτησης στο φόρουμ.';
$string['privacy:metadata:forum_posts:modified'] = 'Πότε τροποποιήθηκε τελευταία η ανάρτηση.';
$string['privacy:metadata:forum_posts:parent'] = 'Η γονική ανάρτηση η οποία απαντήθηκε.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Το αναγνωριστικό του χρήστη στον οποίο στάλθηκε αυτή η απάντηση.';
$string['privacy:metadata:forum_posts:subject'] = 'Το θέμα της ανάρτησης στο φόρουμ.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Το μήνυμα της ανάρτησης στο φόρουμ.';
$string['privacy:metadata:forum_posts:userid'] = 'Το αναγνωριστικό χρήστη του συγγραφέα της ανάρτησης στο φόρουμ.';
$string['privacy:metadata:forum_queue'] = 'Προσωρινή καταγραφή των αναρτήσεων που θα ταχυδρομηθούν σε μορφή σύνοψης';
$string['privacy:metadata:forum_queue:discussionid'] = 'Αναγνωριστικό συζήτησης φόρουμ';
$string['privacy:metadata:forum_queue:postid'] = 'Αναγνωριστικό ανάρτησης φόρουμ';
$string['privacy:metadata:forum_queue:timemodified'] = 'Ο χρόνος τροποποίησης της αρχικής ανάρτησης';
$string['privacy:metadata:forum_queue:userid'] = 'Ο χρήσης που χρειάζεται να ειδοποιηθεί για την ανάρτηση';
$string['privacy:metadata:forum_read'] = 'Πληροφορίες για το ποιές αναρτήσεις έχουν διαβαστεί από τον χρήστη.';
$string['privacy:metadata:forum_read:discussionid'] = 'Η συζήτηση στην οποία βρίσκεται η ανάρτηση.';
$string['privacy:metadata:forum_read:firstread'] = 'Η πρώτη φορά που η ανάρτηση διαβάστηκε.';
$string['privacy:metadata:forum_read:lastread'] = 'Η πιο πρόσφατη φορά που η ανάρτηση διαβάστηκε.';
$string['privacy:metadata:forum_read:postid'] = 'Η ανάρτηση που διαβάστηκε.';
$string['privacy:metadata:forum_read:userid'] = 'Το αναγνωριστικό του χρήστη με τον οποίο σχετίζεται αυτή η εγγραφή.';
$string['privacy:metadata:forum_subscriptions'] = 'Πληροφορίες σχετικά με τα φόρουμ στα οποία έχει εγγραφεί ο χρήστης.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Το φόρουμ στο οποίο έγινε εγγραφή.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Το αναγνωριστικό του χρήστη που σχετίζεται με αυτή τη εγγραφή σε φόρουμ.';
$string['privacy:metadata:forum_track_prefs'] = 'Πληροφορίες σχετικά με το για ποιά φόρουμ έχει επιλέξει ο χρήστης να παρακολουθείται η ανάγνωση αναρτήσεων.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Το φόρουμ που έχει παρακολούθηση ανάγνωσης ενεργοποιημένη.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Το αναγνωριστικό του χρήστη που σχετίζεται με την προτίμηση παρακολούθησης του φόρουμ.';
$string['privacy:metadata:preference:autosubscribe'] = 'Εάν θα εγγράφεστε σε συζητήσεις όταν απαντάτε σε αναρτήσεις σε αυτές.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Η προτιμώμενη σειρά ταξινόμησης της λίστας συζητήσεων';
$string['privacy:metadata:preference:maildigest'] = 'Η γενική προτίμηση σε όλο τον ιστότοπο για την σύνοψη ηλε.ταχυδρομείου.';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Το αν θα επισημαίνονται οι αναρτήσεις φόρουμ ως αναγνωσμένες κατά τη λήψη τους ως μηνύματα.';
$string['privacy:metadata:preference:trackforums'] = 'Εάν θα ενεργοποιηθεί η παρακολούθηση ανάγνωσης.';
$string['privacy:postwasread'] = 'Αυτή η ανάρτηση διαβάστηκε αρχικά στις {$a->firstread} και πιο πρόσφατα διαβάστηκε στις {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Έχετε επιλέξει να μην παρακολουθείτε ποιες αναρτήσεις έχετε διαβάσει σε αυτό το φόρουμ.';
$string['privacy:request:delete:discussion:name'] = 'Διαγραφή κατόπιν αιτήματος του συγγραφέα';
$string['privacy:request:delete:post:message'] = 'Το περιεχόμενο αυτής της ανάρτησης διαγράφηκε κατόπιν αιτήματος του συγγραφέα της.';
$string['privacy:request:delete:post:subject'] = 'Διαγραφή κατόπιν αιτήματος του συγγραφέα';
$string['privacy:subscribedtoforum'] = 'Έχετε εγγραφεί σε αυτό το φόρουμ.';
$string['privatereply'] = 'Απάντηση ιδιωτικά';
$string['privatereply_help'] = 'Μια ιδιωτική απάντηση μπορεί να προβληθεί μόνο από τον συγγραφέα της ανάρτησης που απαντήθηκε και από οποιονδήποτε χρήστη με δυνατότητα ανάγνωσης ιδιωτικών απαντήσεων.';
$string['processingdigest'] = 'Επεξεργασία μηνύματος ηλε.ταχυδρομείου ανασκόπησης για το χρήστη {$a}';
$string['processingpost'] = 'Επεξεργασία ανάρτησης {$a}';
$string['prune'] = 'Διαχωρισμός';
$string['prunedpost'] = 'Μια νέα συζήτηση έχει δημιουργηθεί από εκείνη την ανάρτηση';
$string['pruneheading'] = 'Διαχωρισμός της συζήτησης και μετακίνηση αυτής της ανάρτησης σε μια νέα συζήτηση';
$string['qandaforum'] = 'Φόρουμ Ερωτήσεων & Απαντήσεων';
$string['qandanotify'] = 'Αυτό είναι ένα φόρουμ ερωτήσεων και απαντήσεων. Για να δείτε άλλες αποκρίσεις σε αυτές τις ερωτήσεις, πρέπει πρώτα να αναρτήσετε την απάντησή σας';
$string['re'] = 'Απάντ:';
$string['readtherest'] = 'Ανάγνωση του υπόλοιπου αυτού του θέματος';
$string['removeallforumtags'] = 'Αφαίρεση όλων των ετικετών του φόρουμ';
$string['removefromfavourites'] = 'Αφαίρεση επισήμανσης αυτής της συζήτησης με αστερίσκο';
$string['replies'] = 'Απαντήσεις';
$string['repliesmany'] = '{$a} απαντήσεις μέχρι τώρα';
$string['repliesone'] = '{$a} απάντηση μέχρι τώρα';
$string['reply'] = 'Απάντηση';
$string['reply_handler'] = 'Απάντηση σε αναρτήσεις φόρουμ μέσω ηλε.ταχυδρομείου';
$string['reply_handler_name'] = 'Απάντηση σε αναρτήσεις φόρουμ';
$string['replyauthorself'] = '{$a} (εσείς)';
$string['replyforum'] = 'Απάντηση σε φόρουμ';
$string['replyingtoauthor'] = 'Απαντήσεις σε {$a}...';
$string['replyplaceholder'] = 'Γράψτε την απάντησή σας ...';
$string['replytopostbyemail'] = 'Μπορείτε να απαντήσετε σε αυτό μέσω ηλε.ταχυδρομείου.';
$string['replytouser'] = 'Χρήση διεύθυνσης ηλε.ταχυδρομείου στην απάντηση';
$string['resetdigests'] = 'Διαγραφή όλων των ανά-χρήστη προτιμήσεων συνόψεων φόρουμ';
$string['resetforums'] = 'Διαγραφή αναρτήσεων από';
$string['resetforumsall'] = 'Διαγραφή όλων των αναρτήσεων';
$string['resetsubscriptions'] = 'Διαγραφή όλων των δηλώσεων εγγραφής στο φόρουμ';
$string['resettrackprefs'] = 'Διαγραφή όλων των προτιμήσεων παρακολούθησης φόρουμ';
$string['rssarticles'] = 'Αριθμός πρόσφατων άρθρων τροφοδοσίας RSS';
$string['rssarticles_help'] = 'Αυτή η ρύθμιση ορίζει τον αριθμό των άρθρων (είτε συζητήσεων είτε αναρτήσεων) που θα συμπεριλαμβάνονται στην τροφοδοσία RSS. Γενικά επιτρέπονται 5 με 20.';
$string['rsssubscriberssdiscussions'] = 'Τροφοδοσία RSS συζητήσεων';
$string['rsssubscriberssposts'] = 'Τροφοδοσία RSS αναρτήσεων';
$string['rsstype'] = 'Τροφοδοσία RSS για αυτή τη δραστηριότητα';
$string['rsstype_help'] = 'Για να ενεργοποιήσετε την τροφοδοσία RSS για αυτήν τη δραστηριότητα, επιλέξτε είτε συζητήσεις είτε αναρτήσεις για να συμπεριληφθούν στην τροφοδοσία.';
$string['rsstypedefault'] = 'Τύπος τροφοδοσίας RSS';
$string['search'] = 'Αναζήτηση';
$string['search:activity'] = 'Φόρουμ - πληροφορίες δραστηριότητας';
$string['search:post'] = 'Φόρουμ - αναρτήσεις';
$string['searchdatefrom'] = 'Οι αναρτήσεις πρέπει να είναι νεότερες από αυτό';
$string['searchdateto'] = 'Οι αναρτήσεις πρέπει να είναι παλαιότερες από αυτό';
$string['searchforumintro'] = 'Παρακαλούμε, εισάγετε τους όρους αναζήτησης σε ένα ή περισσότερα από τα επόμενα πεδία';
$string['searchforums'] = 'Αναζήτηση στα φόρουμ';
$string['searchfullwords'] = 'Αυτές οι λέξεις πρέπει να εμφανίζονται ολόκληρες';
$string['searchnotwords'] = 'Αυτές οι λέξεις ΔΕΝ πρέπει να περιέχονται';
$string['searcholderposts'] = 'Αναζήτηση παλαιότερων μηνυμάτων...';
$string['searchphrase'] = 'Αυτή ακριβώς η φράση πρέπει να εμφανίζεται στην ανάρτηση';
$string['searchresults'] = 'Αναζήτηση στα αποτελέσματα';
$string['searchsubject'] = 'Αυτές οι λέξεις θα πρέπει να εμφανίζονται στο θέμα';
$string['searchtags'] = 'Έχει ετικέτα με όνομα';
$string['searchuser'] = 'Αυτό το όνομα θα πρέπει να ταιριάζει με το συγγραφέα';
$string['searchuserid'] = 'Το Αναγνωριστικό Moodle του συγγραφέα';
$string['searchusers'] = 'Αναζήτηση χρηστών';
$string['searchwhichforums'] = 'Επιλέξτε σε ποιά φόρουμ θα ψάξετε';
$string['searchwords'] = 'Αυτές οι λέξεις μπορούν να εμφανίζονται οπουδήποτε στην ανάρτηση';
$string['seeallposts'] = 'Δείτε όλες τις αναρτήσεις από αυτόν το χρήστη';
$string['sendstudentnotificationsdefault'] = 'Προεπιλεγμένη ρύθμιση για «Ειδοποίηση μαθητών»';
$string['sendstudentnotificationsdefault_help'] = 'Ορίστε την προεπιλεγμένη τιμή για το πλαίσιο επιλογής «Ειδοποίηση μαθητών» στην φόρμα βαθμολόγησης.';
$string['sendstudentnotificationsno'] = 'Όχι';
$string['sendstudentnotificationsyes'] = 'Ναι, αποστολή ειδοποίησης στον μαθητή';
$string['settings'] = 'Ρυθμίσεις';
$string['shortpost'] = 'Μικρή ανάρτηση';
$string['showgraderpanel'] = 'Εμφάνιση πίνακα βαθμολογητή';
$string['showingcountoftotaldiscussions'] = 'Λίστα συζητήσεων. Εμφάνιση {$a->count} από {$a-> total}';
$string['showmoreusers'] = 'Εμφάνιση περισσότερων χρηστών';
$string['showpreviousrepliescount'] = 'Εμφάνιση προηγούμενων απαντήσεων ({$a})';
$string['showsubscribers'] = 'Εμφάνιση/επεξεργασία εγγεγραμμένων';
$string['showusersearch'] = 'Εμφάνιση αναζήτησης χρήστη';
$string['singleforum'] = 'Μια απλή συζήτηση';
$string['smallmessage'] = 'Ο/Η {$a->user} ανάρτησε στο φόρουμ {$a->forumname}';
$string['smallmessagedigest'] = 'Σύνοψη φόρουμ περιλαμβάνουσα {$a} αναρτήσεις';
$string['starredonly'] = 'Αναζήτηση μόνο σε συζητήσεις με αστερίσκο';
$string['startedby'] = 'Ξεκίνησε από';
$string['subject'] = 'Θέμα';
$string['subscribe'] = 'Εγγραφείτε σε αυτό το φόρουμ';
$string['subscribeall'] = 'Εγγραφή όλων σε αυτό το φόρουμ';
$string['subscribed'] = 'Εγγεγραμμένος/η';
$string['subscribediscussion'] = 'Εγγραφή σε αυτή τη συζήτηση';
$string['subscribeenrolledonly'] = 'Λυπούμαστε, μόνο εγγεγραμμένοι στο μάθημα μπορούν να εγγραφούν στις ειδοποιήσεις αναρτήσεων στο φόρουμ.';
$string['subscribenone'] = 'Απεγγραφή όλων από αυτό το φόρουμ';
$string['subscribers'] = 'Εγγεγραμμένοι';
$string['subscriberstowithcount'] = 'Εγγεγραμμένοι στο «{$a->name}» ({$a->count})';
$string['subscribestart'] = 'Να μου αποστέλλονται ειδοποιήσεις (με ηλε.ταχυδρομείο) για νέες αναρτήσεις σε αυτό το φόρουμ';
$string['subscribestop'] = 'Δεν επιθυμώ να ειδοποιούμαι (μέσω ηλε.ταχυδρομείου) για νέες αναρτήσεις σε αυτό το φόρουμ';
$string['subscription'] = 'Εγγραφή';
$string['subscription_help'] = 'Αν εγγραφείτε σε ένα φόρουμ αυτό σημαίνει ότι θα λαμβάνετε ειδοποιήσεις (μέσω ηλε.ταχυδρομείου) για νέες αναρτήσεις φόρουμ. Συνήθως μπορείτε να επιλέξετε αν θέλετε να εγγραφείτε αλλά κάποιες φορές η εγγραφή είναι υποχρεωτική ώστε να λαμβάνουν όλοι ειδοποιήσεις.';
$string['subscriptionandtracking'] = 'Εγγραφή και παρακολούθηση';
$string['subscriptionauto'] = 'Αυτόματη εγγραφή';
$string['subscriptiondisabled'] = 'Απενεργοποίηση εγγραφής';
$string['subscriptionforced'] = 'Υποχρεωτική εγγραφή';
$string['subscriptionmode'] = 'Λειτουργία εγγραφής';
$string['subscriptionmode_help'] = 'Όταν ένας συμμετέχων εγγράφεται σε ένα φόρουμ αυτό σημαίνει ότι θα λαμβάνει ενημερώσεις αναρτήσεων στο φόρουμ.
Υπάρχουν 4 επιλογές κατάστασης ειδοποιήσεων:

* Προαιρετική εγγραφή - Οι συμμετέχοντες μπορούν να επιλέξουν εάν θα εγγραφούν
* Υποχρεωτική εγγραφή - Όλοι είναι εγγεγραμμένοι και δεν μπορούν να απεγγραφούν
* Αυτόματη εγγραφή - Όλοι είναι εγγεγραμμένοι αρχικά αλλά μπορούν να επιλέξουν να απεγγραφούν οποτεδήποτε
* Απενεργοποιημένη εγγραφή - Εγγραφές δεν επιτρέπονται';
$string['subscriptionmodeconfirm'] = 'Σίγουρα θέλετε να αλλάξετε τη λειτουργία δηλώσεων εγγραφής σε «{$a}»;';
$string['subscriptionoptional'] = 'Προαιρετική εγγραφή';
$string['subscriptions'] = 'Εγγραφές';
$string['tagarea_forum_posts'] = 'Αναρτήσεις φόρουμ';
$string['tagsdeleted'] = 'Οι ετικέτες του φόρουμ διαγράφηκαν';
$string['thisforumhasduedate'] = 'Η ημερομηνία λήξης για ανάρτηση σε αυτό το φόρουμ είναι {$a}.';
$string['thisforumisdue'] = 'Η ημερομηνία λήξης για ανάρτηση σε αυτό το φόρουμ ήταν {$a}.';
$string['thisforumisthrottled'] = 'Αυτό το φόρουμ έχει ένα όριο στον αριθμό των αναρτήσεων που μπορείτε να κάνετε σε μια δεδομένη χρονική περίοδο - {$a->blockafter} αναρτήσεις σε {$a->blockperiod}.';
$string['timed'] = 'Χρονομετρημένο';
$string['timeddiscussion'] = 'Χρονομετρημένη συζήτηση';
$string['timedhidden'] = 'Χρονική κατάσταση: Κρυμμένη από τους μαθητές';
$string['timedposts'] = 'Χρονομετρημένες αναρτήσεις';
$string['timedvisible'] = 'Χρονομετρημένη κατάσταση: Ορατή σε όλους τους χρήστες';
$string['timestartenderror'] = 'Η ημερομηνία λήξης εμφάνισης δεν μπορεί να είναι νωρίτερα από την ημερομηνία έναρξης';
$string['togglediscussionmenu'] = 'Εναλλαγή του μενού συζήτησης';
$string['togglefullscreen'] = 'Εναλλαγή πλήρους οθόνης';
$string['togglesettingsdrawer'] = 'Εναλλαγή ρυθμίσεων συρταριού';
$string['trackforum'] = 'Παρακολούθηση μη αναγνωσμένων αναρτήσεων';
$string['tracking'] = 'Παρακολούθηση';
$string['trackingoff'] = 'Μη ενεργό';
$string['trackingon'] = 'Επιβάλλεται';
$string['trackingoptional'] = 'Προαιρετικό';
$string['trackingtype'] = 'Παρακολούθηση ανάγνωσης';
$string['trackingtype_help'] = 'Η παρακολούθηση ανάγνωσης επιτρέπει στους συμμετέχοντες να ελέγχουν εύκολα ποιές αναρτήσεις δεν έχουν ακόμη δει φωτο-επισημαίνοντας κάθε νέα ανάρτηση.

Αν οριστεί σε προαιρετική, οι συμμετέχοντες μπορούν να επιλέξουν εάν θα ενεργοποιήσουν ή θα απενεργοποιήσουν την παρακολούθηση ανάγνωσης μέσω ενός συνδέσμου στο μενού ενεργειών ή στο μπλοκ διαχείρισης, ανάλογα με το αισθητικό θέμα. (Οι χρήστες πρέπει επίσης να ενεργοποιήσουν την παρακολούθηση φόρουμ στην προτιμήσεις φόρουμ τους.)

Αν η επιλογή «Επιτρέπεται υποχρεωτική παρακολούθηση ανάγνωσης» είναι ενεργοποιημένη στην διαχείριση ιστοτόπου, τότε μια περαιτέρω επιλογή είναι διαθέσιμη - η «Υποχρεωτική». Αυτό σημαίνει ότι η παρακολούθηση είναι πάντοτε ενεργοποιημένη, άσχετα με τις προτιμήσεις φόρουμ του χρήστη.';
$string['trackreadposts_header'] = 'Παρακολούθηση φόρουμ';
$string['unlockdiscussion'] = 'Ξεκλείδωμα αυτής της συζήτησης';
$string['unpindiscussion'] = 'Ξεκαρφίτσωμα αυτής της συζήτησης';
$string['unread'] = 'Μη αναγνωσμένη';
$string['unreadpost'] = 'Μη αναγνωσμένη ανάρτηση';
$string['unreadposts'] = 'Μη αναγνωσμένες αναρτήσεις';
$string['unreadpostsnumber'] = '{$a} μη αναγνωσμένες αναρτήσεις';
$string['unreadpostsone'] = 'Μία μη αναγνωσμένη ανάρτηση';
$string['unsubscribe'] = 'Απεγγραφή από αυτό το φόρουμ';
$string['unsubscribeall'] = 'Απεγγραφή από όλα τα φόρουμ';
$string['unsubscribeallconfirm'] = 'Αυτή τη στιγμή είστε εγγεγραμμένος σε {$a->forums} φόρουμ και {$a->discussions} συζητήσεις. Θέλετε σίγουρα να απεγγραφείτε από όλα τα φόρουμ και τις συζητήσεις και να απενεργοποιήσετε την αυτόματη εγγραφή σε συζητήσεις;';
$string['unsubscribeallconfirmdiscussions'] = 'Αυτήν τη στιγμή έχετε εγγραφεί σε {$a->discussions} συζητήσεις. Θέλετε πραγματικά να καταργήσετε την εγγραφή σας από όλες τις συζητήσεις και να απενεργοποιήσετε την αυτόματη εγγραφή σε συζητήσεις;';
$string['unsubscribeallconfirmforums'] = 'Αυτή τη στιγμή είστε εγγεγραμμένος σε {$a->forums} φόρουμ. Θέλετε σίγουρα να απεγγραφείτε από όλα τα φόρουμ και να απενεργοποιήσετε την αυτόματη εγγραφή σε συζητήσεις;';
$string['unsubscribealldone'] = 'Όλες οι προαιρετικές εγγραφές σε φόρουμ καταργήθηκαν. Θα λαμβάνετε ακόμα ειδοποιήσεις από φόρουμ με υποχρεωτική εγγραφή. Για να διαχειριστείτε τις ειδοποιήσεις από φόρουμ, παρακαλούμε πηγαίνετε στις ρυθμίσεις ανταλλαγής μηνυμάτων στο προφίλ σας.';
$string['unsubscribeallempty'] = 'Δεν είστε εγγεγραμμένος σε κανένα φόρουμ. Για να απενεργοποιήσετε όλες τις ειδοποιήσεις από αυτόν τον εξυπηρετητή, παρακαλούμε πηγαίνετε στις ρυθμίσεις ανταλλαγής μηνυμάτων στο προφίλ σας.';
$string['unsubscribed'] = 'Διαγραμμένος/-η';
$string['unsubscribediscussion'] = 'Απεγγραφή από αυτή τη συζήτηση';
$string['unsubscribediscussionlink'] = 'Απεγγραφή από αυτή τη συζήτηση: {$a}';
$string['unsubscribelink'] = 'Απεγγραφείτε από αυτό το φόρουμ: {$a}';
$string['unsubscribeshort'] = 'Διαγραφή';
$string['useexperimentalui'] = 'Εμφάνιση απαντήσεων στην πειραματική φωλιασμένη μορφή';
$string['usermarksread'] = 'Χειροκίνητη επισήμανση ανάγνωσης του μηνύματος';
$string['usernavigation'] = 'Πλοήγηση χρήστη';
$string['usersforumposts'] = 'Αναρτήσεις φόρουμ χρήστη';
$string['viewalldiscussions'] = 'Εμφάνιση όλων των συζητήσεων';
$string['viewconversation'] = 'Εμφάνιση συζήτησης';
$string['viewgrades'] = 'Εμφάνιση βαθμών';
$string['viewparentpost'] = 'Εμφάνιση γονικής ανάρτησης';
$string['viewthediscussion'] = 'Εμφάνιση της συζήτησης';
$string['warnafter'] = 'Ανώτατο όριο αναρτήσεων για προειδοποίηση';
$string['warnafter_help'] = 'Οι μαθητές μπορούν να προειδοποιηθούν καθώς πλησιάζουν τον μέγιστο αριθμό αναρτήσεων που επιτρέπονται σε μια δεδομένη περίοδο. Αυτή η ρύθμιση καθορίζει μετά από πόσες αναρτήσεις θα προειδοποιούνται. Οι χρήστες με την δυνατότητα mod/forum:postwithoutthrottling εξαιρούνται από τα όρια αναρτήσεων.';
$string['warnformorepost'] = 'Προειδοποίηση! Υπάρχουν περισσότερες από μια συζητήσεις σε αυτό το φόρουμ - χρήση της πιο πρόσφατης';
$string['yournewquestion'] = 'Η νέα σας ερώτηση';
$string['yournewtopic'] = 'Το νέο σας θέμα συζήτησης';
$string['yourreply'] = 'Η απάντησή σας';
