<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'install', language 'cs', version '4.1'.
 *
 * @package     install
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['admindirerror'] = 'Adresář pro správu (admin) není zadán správně.';
$string['admindirname'] = 'Adresář se soubory pro správu serveru';
$string['admindirsetting'] = 'Na některých serverech je URL adresa /admin vyhrazena pro speciální účely (např. pro ovládací panel). Na takových serverech může dojít ke kolizi se standardním umístěním stránek pro správu Moodlu. Máte-li tento problém, přejmenujte adresář admin ve vaší instalaci Moodlu a do tohoto pole zadejte jeho nový název. Příklad: <br /> <br /><b>moodleadmin</b><br /> <br />
To opraví administrátorské odkazy v Moodlu.';
$string['admindirsettinghead'] = 'Nastavování adresáře \'admin\'...';
$string['admindirsettingsub'] = 'Na některých serverech je URL adresa /admin vyhrazena pro speciální účely (např. pro ovládací panel). Na takových serverech může dojít ke kolizi se standardním umístěním stránek pro správu Moodlu. Máte-li tento problém, přejmenujte adresář admin ve vaší instalaci Moodlu a do tohoto pole zadejte jeho nový název. Příklad: <br /> <br /><b>moodleadmin</b><br /> <br />
To opraví administrátorské odkazy v Moodlu.';
$string['availablelangs'] = 'Dostupné jazykové balíčky';
$string['caution'] = 'Varování';
$string['chooselanguage'] = 'Vyberte jazyk';
$string['chooselanguagehead'] = 'Vyberte jazyk';
$string['chooselanguagesub'] = 'Zvolte si jazyk tohoto průvodce instalací. Vybraný jazyk bude též nastaven jako výchozí jazyk stránek, ale to půjde případně později změnit.';
$string['cliadminemail'] = 'E-mailová adresa nového správce';
$string['cliadminpassword'] = 'Heslo hlavního správce';
$string['cliadminusername'] = 'Uživatelské jméno hlavního správce';
$string['clialreadyconfigured'] = 'Konfigurační soubor config.php již existuje. Spusťte admin/cli/install_database.php, pokud chcete provést instalaci databáze.';
$string['clialreadyinstalled'] = 'Konfigurační soubor config.php již existuje. Spusťte admin/cli/upgrade.php, pokud chcete provést upgrade vašich stránek.';
$string['cliinstallfinished'] = 'Instalace byla úspěšně dokončena.';
$string['cliinstallheader'] = 'Moodle {$a} - průvodce instalací z příkazové řádky';
$string['climustagreelicense'] = 'V neinteraktivním režimu musíte souhlasit s licencí explicitním uvedením parametru --agree-license';
$string['cliskipdatabase'] = 'Přeskočit instalaci databáze.';
$string['clisupportemail'] = 'E-mailová adresa podpory';
$string['clitablesexist'] = 'Databázové tabulky již existují; CLI instalace nemůže pokračovat.';
$string['compatibilitysettings'] = 'Kontrola nastavení PHP...';
$string['compatibilitysettingshead'] = 'Kontrola nastavení PHP...';
$string['compatibilitysettingssub'] = 'Pro správný běh Moodlu by váš server měl vyhovět ve všech následujících testech.';
$string['configfilenotwritten'] = 'Instalačnímu skriptu se nepodařilo automaticky vytvořit soubor config.php s vaší konfigurací -- proces webového serveru zřejmě nemá právo zapisovat do adresáře s instalací Moodlu. Můžete ručně zkopírovat následující kód do souboru s názvem config.php a uložit jej do kořenového adresáře vaší instalace Moodlu.';
$string['configfilewritten'] = 'Soubor config.php byl úspěšně vytvořen.';
$string['configurationcomplete'] = 'Konfigurace dokončena';
$string['configurationcompletehead'] = 'Konfigurace dokončena';
$string['configurationcompletesub'] = 'Moodle se pokusil uložit soubor s konfigurací do kořenového adresáře instalace Moodlu.';
$string['database'] = 'Databáze';
$string['databasehead'] = 'Nastavení databáze';
$string['databasehost'] = 'Databázový server';
$string['databasename'] = 'Název databáze';
$string['databasepass'] = 'Heslo k databázi';
$string['databaseport'] = 'Port pro připojení k databázi';
$string['databasesocket'] = 'Unix socket';
$string['databasetypehead'] = 'Vyberte databázový ovladač';
$string['databasetypesub'] = 'Moodle podporuje několik typů databázových serverů. Prosím, kontaktujte správce serveru, pokud nevíte, který typ použít.';
$string['databaseuser'] = 'Uživatel pro připojení k databázi';
$string['dataroot'] = 'Datový adresář';
$string['datarooterror'] = 'Zadaný datový adresář se nepodařilo nalézt nebo vytvořit. Buď opravte zadanou cestu, nebo vytvořte adresář ručně.';
$string['datarootpermission'] = 'Přístupová práva k datovému adresáři';
$string['datarootpublicerror'] = 'Zadaný datový adresář (dataroot) je přímo dostupný přes WWW. Zvolte jiné umístění.';
$string['dbconnectionerror'] = 'Nepodařilo se připojit k databázi, kterou jste zadali. Zkontrolujte prosím nastavení databáze.';
$string['dbcreationerror'] = 'Chyba při vytváření databáze. Nelze vytvořit databázi zadaného jména a nastavení.';
$string['dbhost'] = 'Hostitelský server';
$string['dbpass'] = 'Heslo';
$string['dbport'] = 'Port';
$string['dbprefix'] = 'Předpona tabulek';
$string['dbtype'] = 'Typ';
$string['directorysettings'] = '<p>Potvrďte prosím základní adresy této instalace Moodlu.</p>

<p><b>Webová adresa:</b>
Zadejte úplnou webovou adresu, na níž bude Moodle dostupný. Jsou-li vaše stránky dostupné na více URL, vyberte z nich tu, kterou budou vaši studenti používat nejčastěji. Na konci adresy neuvádějte lomítko.</p>

<p><b>Adresář Moodlu:</b>
Zadejte úplnou cestu k adresáři s touto instalací. Ujistěte se, že jsou v ní správně uvedena malá/VELKÁ písmena.</p>

<p><b>Datový adresář:</b>
Potřebujete diskový prostor, kam bude Moodle ukládat nahrané (uploadované) soubory. K tomuto adresáři musí mít proces webového serveru právo ke čtení I ZÁPISU (webový server bývá spouštěn pod uživatelem \'nobody\' nebo \'apache\' nebo podobně). Tento adresář by ale zároveň neměl být dostupný přímo přes webové rozhraní (může obsahovat neveřejná data).</p>';
$string['directorysettingshead'] = 'Potvrďte prosím adresy této instalace Moodlu.';
$string['directorysettingssub'] = '<b>Webová adresa</b>:
zadejte úplnou webovou adresu, na níž bude Moodle dostupný. Jsou-li vaše stránky dostupné na více URL, vyberte z nich tu, kterou budou vaši studenti používat nejčastěji. Na konci adresy neuvádějte lomítko.
<br />
<br />
<b>Adresář Moodlu</b>:
zadejte úplnou cestu k adresáři s touto instalací. Ujistěte se, že jsou v ní správně uvedena malá/VELKÁ písmena.
<br />
<br />
<b>Datový adresář</b>:
potřebujete diskový prostor, kam bude Moodle ukládat nahrané soubory.  Tento adresář musí být čitelný a zapisovatelný uživatelem webového serveru (obvykle „nikdo“ nebo „apache“), ale nesmí být přístupný přímo přes web. Pokud neexistuje, instalační program se adrešář pokusí vytvořit.';
$string['dirroot'] = 'Adresář Moodlu';
$string['dirrooterror'] = 'Parametr \'Adresář Moodlu\' není zřejmě správně nastaven - v zadaném umístění se nepodařilo najít instalaci Moodlu. Parametru níže byla nastavena výchozí hodnota.';
$string['download'] = 'Stáhnout';
$string['downloadlanguagebutton'] = 'Stáhnout jazykový balíček "{$a}"';
$string['downloadlanguagehead'] = 'Stáhnout jazykový balíček';
$string['downloadlanguagenotneeded'] = 'V instalaci lze nyní pokračovat v jazyce "{$a}".';
$string['downloadlanguagesub'] = 'Nyní máte možnost stáhnout si některý z jazykových balíčků Moodlu a pokračovat v tomto jazyce.<br /><br />Pokud si momentálně nemůžete nebo nechcete stáhnout jazykový balíček, bude instalační proces pokračovat v angličtině. Jazykové balíčky si budete moci stáhnout i později po ukončení instalace.';
$string['doyouagree'] = 'Souhlasíte s tím? (ano / ne):';
$string['environmenthead'] = 'Kontrola programového prostředí...';
$string['environmentsub'] = 'Nyní se prověřuje, zda vybrané komponenty vašeho systému splňují požadavky instalace.';
$string['environmentsub2'] = 'Každé vydání Moodle vyžaduje určitou minimální verzi PHP a několik povinných rozšíření PHP. Plná kontrola prostředí se provádí před každým instalací a upgrade. Prosím, kontaktujte správce serveru, pokud nevíte, jak nainstalovat novou verzi, nebo povolit rozšíření PHP.';
$string['errorsinenvironment'] = 'Kontrola serverového prostředí selhala!';
$string['fail'] = 'Selhalo';
$string['fileuploads'] = 'Nahrávání souborů';
$string['fileuploadserror'] = 'Mělo by být zapnuto';
$string['fileuploadshelp'] = '<p>Na vašem serveru zřejmě není možné nahrávat soubory.</p>

<p>Moodle může být i přesto nainstalován, bez této funkce ale nebudete moci nahrávat žádné soubory (např. studijní materiály, fotografie uživatelů atd.).</p>

<p>Chcete-li povolit nahrávání souborů, budete muset vy (nebo správce serveru) upravit hlavní soubor php.ini na serveru a změnit nastavení
<b>file_uploads</b> na \'1\'.</p>';
$string['inputdatadirectory'] = 'Datový adresář:';
$string['inputwebadress'] = 'Webová adresa:';
$string['inputwebdirectory'] = 'Adresář s instalací Moodle:';
$string['installation'] = 'Instalace';
$string['invaliddbprefix'] = 'Neplatná předpona. Předpona se může skládat pouze z malých písmen a podtržítka.';
$string['langdownloaderror'] = 'Bohužel, jazyk "{$a}" se nepodařilo nainstalovat. Instalace bude pokračovat v angličtine.';
$string['langdownloadok'] = 'Podařilo se úspěšně nainstalovat jazykový balíček "{$a}". Instalace bude pokračovat v tomto jazyce.';
$string['memorylimit'] = 'Limit paměti';
$string['memorylimiterror'] = 'Limit paměti pro PHP skripty je nastaven relativně nízko ... v budoucnu byste mohli narazit na problémy.';
$string['memorylimithelp'] = '<p>Limit paměti pro PHP skripty je na vašem serveru momentálně nastaven na {$a}.</p>

<p>To může později způsobovat Moodlu problémy, zvláště při větším množství modulů a/nebo uživatelů.</p>

<p>Je-li to možné, doporučujeme vám nastavit v PHP vyšší limit, např. 40M. Můžete to provést několika způsoby:</p>
<ol>
<li>Můžete-li, překompilujte PHP s volbou <i>--enable-memory-limit</i>.
Moodle si tak bude sám moci nastavit potřebný limit.</li>
<li>Máte-li přístup k souboru php.ini, změňte nastavení <b>memory_limit</b>
na hodnotu blízkou 40M. Nemáte-li taková práva, požádejte správce vašeho webového serveru, aby toto nastavení provedl on.</li>
<li>Na některých serverech můžete v kořenovém adresáři Moodlu vytvořit soubor .htaccess s následujícím řádkem:
<blockquote><div>php_value memory_limit 40M</div></blockquote>
<p>Bohužel, v některých případech tím vyřadíte z provozu <b>všechny</b> PHP stránky (při jejich prohlížení uvidíte chybová hlášení), takže budete muset soubor .htaccess zase odstranit.</p></li>
</ol>';
$string['mysqliextensionisnotpresentinphp'] = 'PHP není korektně nakonfigurováno, aby mohlo s MySQL serverem komunikovat s podporou rozšíření MySQLi. Zkontrolujte nastavení v souboru php.ini nebo překompilujte PHP.';
$string['nativeauroramysql'] = 'Aurora MySQL (native/auroramysql)';
$string['nativeauroramysqlhelp'] = '<p> Databáze je místem, kde je uložena většina nastavení a dat Moodle a musí být zde nakonfigurována. </p>
<p> Název databáze, uživatelské jméno a heslo jsou povinná pole; předpona tabulky je volitelná. </p>
<p> Název databáze může obsahovat pouze alfanumerické znaky, dolar ($) a podtržítko (_). </p>
<p> Pokud databáze aktuálně neexistuje a vámi zadaný uživatel má oprávnění, pokusí se Moodle vytvořit novou databázi se správnými oprávněními a nastavením. </p>
<p> Tento ovladač není kompatibilní se starším modulem MyISAM. </p>';
$string['nativemariadb'] = 'MariaDB (native/mariadb)';
$string['nativemariadbhelp'] = '<p>Nyní je potřeba nakonfigurovat databázi, kde bude uložena většina dat Moodlu.</p>
<p>Databáze bude vytvořena, pokud má uživatel s daným uživatelským jménem a heslem potřebná oprávnění. Předpona názvů tabulek je volitelná.</p>
<p>Název databáze může obsahovat pouze alfanumerické znaky, dolar ($) a podtržítko (_).</p>
<p>Pokud databáze v současné době neexistuje, a určený uživatel má oprávnění, Moodle se pokusí vytvořit novou databázi se správným oprávněním a nastavením.</p>
<p>Tento ovladač není kompatibilní s předchozím engine MyISAM.</p>';
$string['nativemysqli'] = 'MySQL Improved (native/mysqli)';
$string['nativemysqlihelp'] = '<p>Nyní je potřeba nakonfigurovat databázi, kde bude uložena většina dat Moodlu.</p>
<p>Databáze bude vytvořena, pokud má uživatel s daným uživatelským jménem a heslem potřebná oprávnění. Předpona názvů tabulek je volitelná.</p>
<p>Název databáze může obsahovat pouze alfanumerické znaky, dolar ($) a podtržítko (_).</p>
<p>Pokud databáze v současné době neexistuje, a určený uživatel má oprávnění, Moodle se pokusí vytvořit novou databázi se správným oprávněním a nastavením.</p>';
$string['nativeoci'] = 'Oracle (native/oci)';
$string['nativeocihelp'] = 'Nyní je potřeba nakonfigurovat databázi, kde bude uložena většina dat Moodlu.
Tato databáze již musí být vytvořena a uživatel s daným uživatelským jménem a heslem k ní musí mít přístup. Předpona názvů tabulek je povinná.';
$string['nativepgsql'] = 'PostgreSQL (native/pgsql)';
$string['nativepgsqlhelp'] = '<p>Nyní je potřeba nakonfigurovat databázi, kde bude uložena většina dat Moodlu.</p>
<p>Databáze bude vytvořena, pokud má uživatel s daným uživatelským jménem a heslem potřebná oprávnění. Předpona názvů tabulek je volitelná.</p><p>
Databáze již musí existovat a uživatel musí mít práva ke čtení a zápisu.</p>';
$string['nativesqlsrv'] = 'SQL*Server Microsoft (native/sqlsrv)';
$string['nativesqlsrvhelp'] = 'Nyní je potřeba nakonfigurovat databázi, kde bude uložena většina dat Moodlu.
Tato databáze již musí být vytvořena a uživatel s daným uživatelským jménem a heslem k ní musí mít přístup. Předpona názvů tabulek je povinná.';
$string['nativesqlsrvnodriver'] = 'Microsoft ovladače pro SQL Server pro PHP nejsou nainstalovány nebo správně nastaveny.';
$string['ociextensionisnotpresentinphp'] = 'PHP nebylo korektně nakonfigurováno pro komunikaci s Oracle přes rozšíření OCI8. Zkontrolujte váš php.ini nebo překompilujte PHP.';
$string['pass'] = 'V pořádku';
$string['paths'] = 'Cesty';
$string['pathserrcreatedataroot'] = 'Datový adresář ({$a->dataroot}) nemůže být tímto průvodcem instalací vytvořen.';
$string['pathshead'] = 'Potvrdit cesty';
$string['pathsrodataroot'] = 'Do datového adresáře nelze zapisovat.';
$string['pathsroparentdataroot'] = 'Do nadřazeného adresáře ({$a->parent}) nelze zapisovat. Datový adresář ({$a->dataroot}) nemůže být tímto průvodcem instalací vytvořen.';
$string['pathssubadmindir'] = 'Na některých serverech je URL adresa /admin vyhrazena pro speciální účely (např. pro ovládací panel). Na takových serverech může dojít ke kolizi se standardním umístěním stránek pro správu Moodle. Máte-li tento problém, přejmenujte adresář <eM>admin</em> ve vaší instalaci Moodle a sem zadejte jeho nový název - například <em>moodleadmin</em>. Všechny generované odkazy na stránky správy Moodle budou používat tento nový název.';
$string['pathssubdataroot'] = '<p>Moodle potřebuje prostor, kam si bude ukládat nahrané soubory a další údaje. .</p>
<p>K tomuto adresáři musí mít proces webového serveru právo ke čtení i k zápisu (webový server bývá většinou spouštěn pod uživatelem "www-data" nebo "apache"). .</p>
<p>Tento adresář ale zároveň nesmí být dostupný přímo přes webové rozhraní. .</p>
<p>Instalační skript se pokusí tento adresář vytvořit, pokud nebude existovat..</p>';
$string['pathssubdirroot'] = '<p>Absolutní cesta k adresáři s instalací Moodle.</p>';
$string['pathssubwwwroot'] = '<p>Zadejte úplnou webovou adresu, na níž bude Moodle dostupný, t.j. adresa, kterou zadají uživatelé do adresního řádku svého prohlížeče, aby spustili Moodle.</p>
<p>Moodle potřebuje jedinečnou adresu, není možné jej provozovat na několika URL současně. Používáte-li několik veřejných domén, musíte si sami nastavit permanentní přesměrování na jednu z nich a tu pak použít.</p>
<p> Pokud je váš server dostupný z vnější a z vnitřní sítě pod různými IP adresami, použijte jeho veřejnou adresu a nastavte si váš DNS server tak, že ji mohou používat i uživatelé z vnitřní sítě.</p>
<p>Pokud aktuální adresa není správná, změňte URL adresu v adresním řádku prohlížeče a spusťte instalaci.</p>';
$string['pathsunsecuredataroot'] = 'Umístění datového adresáře není bezpečné';
$string['pathswrongadmindir'] = 'Adresář pro správu serveru (admin) neexistuje';
$string['pgsqlextensionisnotpresentinphp'] = 'PHP nebylo korektně nakonfigurováno pro komunikaci s PostgreSQL přes rozšíření PGSQL. Zkontrolujte váš php.ini nebo překompilujte PHP.';
$string['phpextension'] = '{$a} PHP rozšíření';
$string['phpversion'] = 'Verze PHP';
$string['phpversionhelp'] = '<p>Moodle vyžaduje PHP alespoň verze 5.6.5 PHP nebo 7.1 (7.0.x má určitá omezení jádra).</p>
<p>Nyní používáte PHP verzi {$a}.</p>
<p>PHP musíte upgradovat, nebo přejít k hostiteli s vyšší verzí!</p>';
$string['releasenoteslink'] = 'Informace o této verzi Moodle naleznete v poznámkách k vydání na {$a}';
$string['safemode'] = 'Bezpečný režim (Safe Mode)';
$string['safemodeerror'] = 'Se zapnutým bezpečným režimem (Safe Mode) může mít Moodle problémy.';
$string['safemodehelp'] = '<p>Moodle může mít při zapnutém bezpečném režimu řadu problémů, v neposlední řadě je to pravděpodobně nebude povoleno vytvářet nové soubory.</p>

<p>Bezpečný režim používají obvykle pouze paranoidní veřejní poskytovatelé webového prostoru, takže možná bude stačit najít si pro váš Moodle jiného poskytovatele.</p>

<p>Můžete zkusit pokračovat v instalaci, ale připravte se na problémy.</p>';
$string['sessionautostart'] = 'Session Auto Start';
$string['sessionautostarterror'] = 'Mělo by být vypnuto';
$string['sessionautostarthelp'] = '<p>Moodle vyžaduje podporu session a nebude bez ní fungovat.</p>

<p>Podporu session můžete povolit v souboru php.ini  ... hledejte parametr session.auto_start.</p>';
$string['sqliteextensionisnotpresentinphp'] = 'PHP není správně nakonfigurováno s rozšířením SQLite. Zkontrolujte prosím soubor php.ini, nebo překompilujte PHP.';
$string['upgradingqtypeplugin'] = 'Aktualizace modulu typu otázky';
$string['welcomep10'] = '{$a->installername} ({$a->installerversion})';
$string['welcomep20'] = 'Tuto stránku vidíte, protože jste úspěšně nainstalovali a spustili  balíček <strong>{$a->packname} {$a->packversion}</strong>. Gratulujeme!';
$string['welcomep30'] = 'Tato verze <strong>{$a->installername}</strong> obsahuje aplikace k vytvoření prostředí, ve kterém bude provozován váš <strong>Moodle</strong>. Jmenovitě se jedná o:';
$string['welcomep40'] = 'Balíček rovněž obsahuje <strong>Moodle ve verzi {$a->moodlerelease} ({$a->moodleversion})</strong>.';
$string['welcomep50'] = 'Použití všech aplikací v tomto balíčku je vázáno jejich příslušnými licencemi. Kompletní balíček <strong>{$a->installername}</strong> je software s <a href="https://www.opensource.org/docs/definition_plain.html"> otevřeným kódem (open source)</a> a je šířen pod licencí <a href="https://www.gnu.org/copyleft/gpl.html">GPL</a>.';
$string['welcomep60'] = 'Následující stránky vás v několik jednoduchých krocích nastavením <strong>Moodlu</strong> na vašem počítači. Můžete přijmout výchozí nastavení, nebo si je upravit podle svých potřeb.';
$string['welcomep70'] = 'Stisknutím níže uvedeného tlačítka "Další" pokračujte v nastavení vaší instalace Moodlu.';
$string['wwwroot'] = 'Webová adresa';
$string['wwwrooterror'] = 'Parametr \'Webová adresa\' je zřejmě nastaven nesprávně -- v zadaném umístění se nepodařilo najít instalaci Moodlu. Ve formuláři níže byla automaticky nastavena výchozí hodnota.';
