<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'enrol_lti', language 'no', version '4.1'.
 *
 * @package     enrol_lti
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addcontent'] = 'Legg til innhold';
$string['adddeployment:deploymentid'] = 'Distribusjon ID';
$string['adddeployment:deploymentid_help'] = 'Hver distribusjon av verktøyet (dette nettstedet) i en plattform vil bli tildelt en distribusjons-ID som er unik for registreringen. Implementerings-ID-en må registreres med verktøyet (denne siden) før lanseringer fra den respektive verktøydistribusjonen tillates.';
$string['adddeployment:invaliddeploymentiderror'] = 'Ugyldig distribusjons ID. Denne Distribusjons ID-en eksisterer allerede for dette app registreringen.';
$string['adddeployment:name'] = 'Navn på Distribusjon';
$string['addtocourse'] = 'Legg til kurs';
$string['addtogradebook'] = 'Legg til karakterbok';
$string['allowframeembedding'] = 'Merk: det anbefales at portalinnstillingen "Tillat innbygging" er aktivert slik at LTI-verkøty vises i en ramme og ikke i et nytt vindu.';
$string['authltimustbeenabled'] = 'Merk: Denne modulen krever at LTI-autentiseringsmodulen også er aktivert';
$string['cartridgeurl'] = 'URL til informasjonskapsel';
$string['cookiesarerequired'] = 'Cookies blokkeres av nettleseren din';
$string['cookiesarerequiredinfo'] = 'Dette verktøyet kan ikke starte siden nettleseren din blokkerer tredjeparts cookies.
<br><br>
For å bruke dette verktøyet kan du prøve å sende nettleserens cookieinnstillinger eller prøver en annen nettleser.';
$string['copiedtoclipboard'] = '{$a} kopiert til utklippstavlen';
$string['copytoclipboard'] = 'Kopiere til utklippstavle';
$string['couldnotestablishproxy'] = 'Etableringen av proxy med forbruker var mislykket.';
$string['customproperties'] = 'Egendefinerte egenskaper';
$string['deeplinkingurl'] = 'Dyp koblings URL';
$string['deletedactivity'] = 'Slett aktivitet';
$string['deletedactivityalt'] = 'Aktiviteten som er delt av denne forekomsten, er slettet';
$string['deletedactivitydescription'] = 'Aktiviteten som er delt av denne forekomsten, er slettet. Du kan velge en annen aktivitet å dele ved å redigere forekomsten eller, hvis det ikke lenger er nødvendig, kan du ganske enkelt slette forekomsten. Hvis du sletter forekomsten, fjernes eventuelle tilknyttede brukerregistreringer.';
$string['deploymentadd'] = 'Legg til en distribusjon';
$string['deploymentaddnotice'] = 'distribusjon lagt til';
$string['deploymentdelete'] = 'Slett distribusjon';
$string['deploymentdeleteconfirm'] = 'Advarsel: Sletting av en distribusjon vil resultere i tap av tilgang for alle brukere som følger ressurslenker knyttet til denne verktøydistribusjonen på plattformen. Synkroniseringstjenester for medlemmer og karakterer vil også bli fjernet for disse ressursene. Er du sikker på at du vil slette distribusjons-ID \'{$a}\'?';
$string['deploymentdeletenotice'] = 'Distribusjon slettet';
$string['deploymentid'] = 'Distribusjon ID';
$string['deployments'] = 'Distribusjoner';
$string['deploymentsinfo'] = 'En deploy-ID vil bli generert av plattformen når verktøyet gjøres tilgjengelig i en kontekst. Dette kan skje ved registreringstidspunktet, eller kan skje senere, når verktøyet gjøres tilgjengelig for et bestemt kurs eller kategori. Deploy-ID-en må angis her før lanseringer tillates.';
$string['details'] = 'Detaljer';
$string['editplatformdetails'] = 'Rediger plattformdetaljer';
$string['endpointltiversionnotice'] = 'Verktøyendepunktene nedenfor er kun for manuell LTI 1.3-oppsett. For tidligere versjoner (1.1/2.0), kan detaljer for forbrukere finnes på siden \'Publisert som LTI-verktøy\', tilgjengelig via kursnavigasjon.';
$string['enrolenddate'] = 'Sluttdato';
$string['enrolenddate_help'] = 'Hvis aktivert vil brukere bare ha tilgang frem til denne datoen.';
$string['enrolenddateerror'] = 'Sluttdatoen for påmeldingen kan ikke være før startdatoen';
$string['enrolisdisabled'] = 'Innstillingen "Publiser som LTI-verktøy" er deaktivert.';
$string['enrolltiversionincorrect'] = 'Ressursen er ikke satt opp for bruk over eldre LTI (versjon 1.1/2.0). Ta kontakt med administratoren av dette verktøyet.';
$string['enrolmentfinished'] = 'Påmeldingen er avsluttet';
$string['enrolmentnotstarted'] = 'Påmeldingen har ikke åpnet ennå';
$string['enrolperiod'] = 'Påmeldingsvarighet';
$string['enrolperiod_help'] = 'Lengden en påmelding er gyldig fra brukeren melder seg inn via det eksterne systemet. Hvis deaktivert vil påmeldingen ikke ha noen utløpstid.';
$string['enrolstartdate'] = 'Startdato';
$string['enrolstartdate_help'] = 'Hvis aktivert, vil brukere bare ha tilgang fra denne datoen.';
$string['existingregistrationerror'] = 'Det finnes allerede en registrering for denne utstederen og klient-ID-en.';
$string['failedrequest'] = 'Forespørsel feilet. Årsak: {$a->reason}';
$string['frameembeddingnotenabled'] = 'For å få tilgang til LTI-verktøyet, vennligst klikk på lenken nedenfor.';
$string['gradesync'] = 'Karaktersynkronisering';
$string['gradesync_help'] = 'Om karakterer fra LTI-verktøyet skal sendes til det eksterne systemet (LTI mottakeren)';
$string['incorrecttoken'] = 'Oppgitt token var feil. Vennligst sjekk URL-en og prøv igjen eller kontakt administratoren for dette LTI-verktøyet.';
$string['invalidexpiredregistrationurl'] = 'Ugyldig eller utløpt registrerings-URL. Vennligst sjekk URL-en og prøv igjen.';
$string['invalidrequest'] = 'Ugyldig forespørsel';
$string['invalidtoolconsumer'] = 'Ugyldig LTI-verktøymottaker';
$string['jwksurl'] = 'JWKS URL';
$string['launchdetails'] = 'Oppstartsdetaljer';
$string['launchdetails_help'] = 'En URL til informasjonskapsel (også kalt konfigurasjons-URL) og en hemmelig token kreves for å sette opp LTI-verktøyet.';
$string['launchurl'] = 'OppstartsURL';
$string['loginurl'] = 'Start påloggings URL';
$string['lti13'] = 'LTI fordel';
$string['lti13launchdetails'] = 'Lanserings detaljer';
$string['lti13launchdetails_help'] = 'Lanserings-URL og egendefinerte egenskaper kreves bare når du manuelt konfigurerer en ressurskobling i plattformen. Der det er mulig, bør lærere favorisere prosessen med innholdsvalg (dypkobling) for å lage ressurslenker';
$string['lti:config'] = 'Konfiguer instanser for "Publiser som LTI-verktøy"';
$string['lti:unenrol'] = 'Meld deltakerne ut av kurset';
$string['ltiadvdynregerror:invalidopenidconfigjson'] = 'Det oppsto et problem med å hente OpenID-konfigurasjonen fra plattformen. Resultatet var ikke gyldig JSON. Dette kan også være forårsaket av blokkerte vertskonfigurasjoner. Sørg for at nettstedet ditt er konfigurert til å koble til plattformens domene, og prøv igjen med en ny registrerings-URL.';
$string['ltiadvlauncherror:invaliddeployment'] = 'Ugyldig startdata eller verktøykonfigurasjon. Implementeringen ble ikke funnet (distribusjons-ID: {$a}).';
$string['ltiadvlauncherror:invalidid'] = 'Ugyldige lanseringsdata. Ressursen \'{$a}\' er utilgjengelig eller eksisterer ikke.';
$string['ltiadvlauncherror:invalidregistration'] = 'Ugyldig startdata eller verktøykonfigurasjon. En plattformregistrering ble ikke funnet (utsteder: {$a->plattform}, klient-ID: {$a->clientid}).';
$string['ltiadvlauncherror:missingid'] = 'Ugyldige lanseringsdata. Det tilpassede kravfeltet «id» er nødvendig for å starte en aktivitet eller ressurs over LTI Advantage.';
$string['ltilegacy'] = 'Eldre LTI (1.1/2.0)';
$string['ltilegacydeprecatednotice'] = 'Eldre LTI (1.1/2.0)-verktøy er avviklet. Innhold skal nå deles med LTI Advantage.';
$string['ltiversion'] = 'LTI versjon';
$string['ltiversion_help'] = 'Versjonen av LTI som vil bli brukt for å få tilgang til det publiserte innholdet.

LTI Advantage lar innhold publiseres til forhåndsregistrerte plattformer uten at det er nødvendig å gjøre endringer på plattformen hver gang nytt innhold publiseres. Sikkerhetskontrakten er mellom plattformen og verktøyet.

Eldre versjoner (1.1 og 2.0), krever at det opprettes en ny verktøyregistrering på forbrukeren for hvert stykke nylig publisert innhold fordi hvert stykke publisert innhold har sin egen sikkerhetskontrakt med forbrukersiden og må settes opp på en sak pr. saksgrunnlag.';
$string['managedeployments'] = 'Administrer distribusjoner';
$string['maxenrolled'] = 'Maks antall påmeldte deltakere';
$string['maxenrolled_help'] = 'Det maksimale antallet eksterne brukere som skal få tilgang til dette LTI-verktøyet. Hvis satt til 0 vil antallet eksterne brukere være ubegrenset.';
$string['maxenrolledreached'] = 'Det maksimale antallet eksterne brukere tillatt i dette LTI-verktøyet har blitt nådd.';
$string['membersync'] = 'Brukersynkronisering';
$string['membersync_help'] = 'Om en cronjobb skal synkronisere påmeldte brukere i det eksterne systemet med påmeldinger i dette kurset ved å opprette en ny brukerkonto for hver eksterne bruker når det er nødvendig og samtidig melde de inn og ut når det er nødvendig.

Hvis denne innstillingen er satt til Nei, vil det opprettes en brukerkonto hver gang en ekstern bruker får tilgang til verktøyet og de vil automatisk bli påmeldt kurset.';
$string['membersyncmode'] = 'Brukersynkroniseringsmodus';
$string['membersyncmode_help'] = 'Om eksterne brukere skal meldes inn og/eller meldes ut fra dette kurset.';
$string['membersyncmodeenrolandunenrol'] = 'Meld inn nye og meldt ut manglende brukere';
$string['membersyncmodeenrolnew'] = 'Meld inn nye brukere';
$string['membersyncmodeunenrolmissing'] = 'Meld ut manglende brukere';
$string['moodle'] = 'Moodle';
$string['nodeployments'] = 'Ingen verktøy distribusjoner funnet';
$string['nopublishedcontent'] = 'Ingen ressurser eller aktiviteter er publisert ennå';
$string['noregisteredplatforms'] = 'Ingen registrerte plattformer';
$string['notoolsprovided'] = 'Ingen LTI-verktøy tilbys';
$string['opensslconfiginvalid'] = 'LTI 1.3 krever at en gyldig openssl.cnf er konfigurert og tilgjengelig for webserveren din. Kontakt nettstedadministratoren for å konfigurere og aktivere openssl for denne portalen.';
$string['opentool'] = 'Åpne LTI-verktøy';
$string['platformdetails'] = 'Plattformdetaljer';
$string['platformdetailsinfo'] = 'Når verktøyet er satt opp i plattformen, må detaljer fra plattformen registreres her for å fullføre registreringen.
<ul>
<li>For dynamiske registreringer vil denne informasjonen ha blitt satt automatisk og ingen ytterligere endringer er nødvendig</li>
<li>For manuelle registreringer må denne informasjonen kopieres manuelt fra plattformen.</li>
</ul>';
$string['pluginname'] = 'Publiser som LTI-verktøy';
$string['pluginname_desc'] = 'Funksjonen "Publiser som LTI-verktøy", vil sammen med LTI-autentiseringsmodulen tillate eksterne brukere tilgang til utvalgte kurs og aktiviteter. Med andre ord vil Moodle da fungere som en LTI-tilbyder.';
$string['privacy:metadata:enrol_lti_users'] = 'Listen med brukere påmeldt via en LTI-tilbyder';
$string['privacy:metadata:enrol_lti_users:lastaccess'] = 'Når brukeren siste var aktiv i kurset';
$string['privacy:metadata:enrol_lti_users:lastgrade'] = 'Den siste karakteren som ble registrert på brukeren.';
$string['privacy:metadata:enrol_lti_users:timecreated'] = 'Når brukeren ble meldt inn.';
$string['privacy:metadata:enrol_lti_users:userid'] = 'Brukerens ID';
$string['provisioningmode'] = 'Første lansering';
$string['provisioningmode_help'] = 'Denne innstillingen bestemmer hvordan kontoer håndteres ved første lansering. Flere moduser støttes:
<ul>
<li>Bare nye kontoer (automatisk). Kontoer opprettes automatisk for brukere som starter fra plattformen. Dette er standard for elevlanseringer.</li>
<li>Eksisterende og nye kontoer (forespørsel). Brukeren vil få et valg om hva som skal gjøres. De kan velge å koble til en eksisterende konto, eller få opprettet en ny konto for dem. Dette er det mest fleksible alternativet og standard for lærerlanseringer.</li>
<li>Kun eksisterende kontoer (forespørsel). Brukeren vil bli bedt om å koble til en eksisterende konto og kan ikke få tilgang til verktøyressursene uten å gjøre det.</li>
</ul>';
$string['provisioningmodestudentlaunch'] = 'Første lansering for studenter';
$string['provisioningmodeteacherlaunch'] = 'Første lansering for lærere';
$string['publishedcontent'] = 'Publisert innhold';
$string['publishedcontent_help'] = 'En publisert ressurs eller aktivitet kan brukes i registrerte plattformer via flyten for innholdsvalg (dyplinking). I tillegg kan en ressurskobling opprettes manuelt i plattformen ved å bruke lanserings-URLen og de egendefinerte egenskapene som er oppgitt.';
$string['registeredplatforms'] = 'Registrerte plattformer';
$string['registeredplatformsltiversionnotice'] = 'Plattformene som er oppført nedenfor er registrert for LTI 1.3-kommunikasjon. For tidligere versjoner er forbrukerregistrering ikke nødvendig.';
$string['registerplatform:accesstokenurl'] = 'Tilgangstoken-URL';
$string['registerplatform:accesstokenurl_help'] = 'Nettadressen som forespørsler om tilgangstoken vil bli sendt til av verktøyet. Vil bli levert av plattformen.';
$string['registerplatform:authrequesturl'] = 'URL for autentiserings forespørsel';
$string['registerplatform:authrequesturl_help'] = 'URL-en som OpenID Connect-autentiseringsforespørsler sendes til av verktøyet. Vil bli levert av plattformen.';
$string['registerplatform:clientid'] = 'klient ID';
$string['registerplatform:clientid_help'] = 'En streng som brukes til å identifisere verktøyregistreringen på plattformen. Vil bli levert av plattformen.';
$string['registerplatform:duplicateregistrationerror'] = 'Ugyldig klient ID. Denne klient ID-en er allerede registrert for den oppgitte plattform ID-en.';
$string['registerplatform:invalidurlerror'] = 'Ugyldig URL. Har du inkludert http:// or https://?';
$string['registerplatform:jwksurl'] = 'URL for offentlig nøkkelsett';
$string['registerplatform:jwksurl_help'] = 'Det offentlige nøkkelsettet eller JWKS URL, brukes til å hente plattformens offentlige nøkkel. Vil bli levert av plattformen.';
$string['registerplatform:name'] = 'Plattform navn';
$string['registerplatform:name_help'] = 'Et kort navn som beskriver plattformen. Dette kan endres når som helst.';
$string['registerplatform:platformid'] = 'Plattform-ID (utsteder)';
$string['registerplatform:platformid_help'] = 'URL-en som identifiserer tredjeparts læringsplattform. Vil bli levert av plattformen.';
$string['registerplatformadd'] = 'Registrer en plattform';
$string['registerplatformaddnotice'] = 'Plattform registrering lagt til';
$string['registerplatformdelete'] = 'Slett plattform registrering';
$string['registerplatformdeleteconfirm'] = 'URL-en som identifiserer tredjeparts læringsplattform. Vil bli levert av plattformen.';
$string['registerplatformdeletenotice'] = 'Plattform registrering slettet';
$string['registerplatformedit'] = 'Endre registrering';
$string['registerplatformeditnotice'] = 'Plattform registrering oppdatert';
$string['registration'] = 'Registreringsinfo for LTI-verktøyet';
$string['registrationdeeplinklabel'] = 'Legg til innhold fra {$a}';
$string['registrationdynamic'] = 'Dynamisk registrering';
$string['registrationmanual'] = 'Manuell registrering';
$string['registrationresourcelinklabel'] = 'Lanser innhold fra {$a}';
$string['registrationstatus'] = 'Status';
$string['registrationstatusactive'] = 'Aktiv';
$string['registrationstatuspending'] = 'Venter';
$string['registrationurl'] = 'RegistreringsURL';
$string['registrationurl_help'] = 'Dersom en registrerings-URL (også kalt proxy-URL) benyttes, vil LTI-verktøyet bli automatisk konfigurert.';
$string['registrationurlinfomessage'] = 'Hvis plattformen støtter dynamisk registrering, bruk registrerings-URLen nedenfor. For mer informasjon om dynamisk registrering, se dokumentasjonen <a href="{$a}">Publiser som LTI-verktøy</a>.';
$string['remotesystem'] = 'Eksternt system';
$string['requirecompletion'] = 'Krev kurs- eller aktivitetsfullføring for å synkronisere karakterer.';
$string['returnurlnotset'] = 'Retur-URL er ikke satt';
$string['roleinstructor'] = 'Rolle for lærer';
$string['roleinstructor_help'] = 'Rollen tildelt til eksterne lærere i dette LTI-verktøyet.';
$string['rolelearner'] = 'Rolle for student';
$string['rolelearner_help'] = 'Rollen tildelt il eksterne deltakere i dette LTI-verktøyet.';
$string['secret'] = 'Hemmelig streng';
$string['secret_help'] = 'En streng som deles med det eksterne systemet (LTI forbrukeren) for å gi tilgang til LTI-verktøyet.';
$string['sharedexternaltools'] = 'Publisert som LTI-verktøy';
$string['successfulregistration'] = 'Vellykket registrering';
$string['tasksyncgrades'] = 'Publiser som LTI-verktøy med resultatsynkronisering';
$string['tasksyncmembers'] = 'Publiser som LTI-verktøy med brukersynkroniseirng';
$string['tooldetails'] = 'Verktøydetaljer';
$string['toolsprovided'] = 'Publiserte LTI-verktøy';
$string['toolsprovided_help'] = 'Et LTI-verktøy kan deles med andre portaler ved at de får tilgang til oppstartsinformasjonen eller en registrerings-URL.';
$string['tooltobeprovided'] = 'LTI-verktøy som skal publiseres.';
$string['toolurl'] = 'URL til LTI-verktøy';
$string['userdefaultvalues'] = 'Standard brukerverdier';
$string['viewplatformdetails'] = 'Vis plattformdetaljer';
$string['viewtoolendpoints'] = 'Vis verktøy endepunkter';
