<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_treestudyplan', language 'nl', version '4.1'.
 *
 * @package     local_treestudyplan
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_association'] = 'Toevoegen';
$string['advanced_backup'] = 'Backup naar bestand';
$string['advanced_backup_page'] = 'Backup actieve tabblad';
$string['advanced_backup_plan'] = 'Backup studieplan';
$string['advanced_backup_restore'] = 'Backup and import';
$string['advanced_bulk_course_timing'] = 'Stel start- en einddatum in';
$string['advanced_bulk_course_timing_desc'] = 'Stel de start- en einddatum van alle cursussen in het actieve tabblas in op die van de perioden waarin ze geplaatst zijn';
$string['advanced_cascade_cohortsync'] = 'Site-groep sync doorzetten';
$string['advanced_cascade_cohortsync_desc'] = 'Voeg een site-group synchronisatie aanmelding toe aan alle cursussen in dit studieplan, voor alle gekoppelde site-groepen';
$string['advanced_cascade_cohortsync_title'] = 'Site-groep synchronisatie doorzetten';
$string['advanced_confirm_header'] = 'Weet je het zeker?';
$string['advanced_converted'] = 'verwerkt';
$string['advanced_course_manipulation_title'] = 'Cursussen aanpassen';
$string['advanced_create_from_template'] = 'Nieuw van template';
$string['advanced_error'] = 'fout';
$string['advanced_export'] = 'Exporteer naar bestand';
$string['advanced_export_csv_page'] = 'Exporteer actieve tabblad naar CSV';
$string['advanced_export_csv_plan'] = 'Exporteer studeeplan naar CSV';
$string['advanced_failed'] = 'mislukt';
$string['advanced_force_scale_button'] = 'Toepassen';
$string['advanced_force_scale_confirm'] = 'Weet je zeker dat je de beoordeling van alle gekoppelde activiteiten wilt omzetten?';
$string['advanced_force_scale_desc'] = 'Stel bij alle aan dit studieplan als leerdoel gekoppelde activiteiten de beoordeling in op de geselecteerde resultaatschaal. Dit werkt alleen als er nog geen resultaten zijn toegekend.';
$string['advanced_force_scale_title'] = 'Schaal overschrijven';
$string['advanced_import_from_file'] = 'Vanuit bestand';
$string['advanced_locked'] = 'locked';
$string['advanced_multiple'] = 'meerdere';
$string['advanced_pick_scale'] = 'Kies resultaatschaal';
$string['advanced_purge'] = 'Verwijderen';
$string['advanced_purge_page'] = 'Tabblad verwijderen';
$string['advanced_purge_page_expl'] = 'Het actieve tabblad permanent verwijderen.';
$string['advanced_purge_plan'] = 'Studieplan verwijderen';
$string['advanced_purge_plan_expl'] = 'Dit hele studieplan permanent verwijderen.';
$string['advanced_restore'] = 'Laden vanuit bestand';
$string['advanced_restore_lines'] = 'Importeer inhoud uit de backup van een tabblad';
$string['advanced_restore_pages'] = 'Importeer tabbladen uit de backup van een studieplan';
$string['advanced_skipped'] = 'overgeslagen';
$string['advanced_tools'] = 'Geavanceerd';
$string['advanced_tools_heading'] = 'Geavanceerde tools';
$string['advanced_warning'] = 'De geavanceerde tools zijn krachtige hulpmiddelen die met beleid moeten worden gebruikt. Gebruik deze alleen als je zeker weet hoe je deze moet gebruiken.';
$string['advanced_warning_title'] = 'Waarschuwing';
$string['aggregation_all'] = 'Voltooi alle';
$string['aggregation_any'] = 'Voltooi één van deze';
$string['aggregation_one'] = 'Behaal';
$string['aggregation_overall_all'] = 'Je voltooit de module door alles van het volgende';
$string['aggregation_overall_any'] = 'Je voltooit de module door één of meer van het volgende';
$string['aggregation_overall_one'] = 'Je voltooit de module door het volgende';
$string['allgraded'] = 'Alles beoordeeld';
$string['associate_coaches'] = 'Zoek coaches';
$string['associate_cohorts'] = 'Zoek om te koppelen';
$string['associate_users'] = 'Zoek om te koppelen';
$string['associated_coaches'] = 'Gekoppelde coaches';
$string['associated_cohorts'] = 'Gekoppelde site-groepen';
$string['associated_users'] = 'Gekoppelde gebruikers';
$string['associations'] = 'Koppelingen';
$string['associations_empty'] = 'Geen koppelingen';
$string['associations_search'] = 'Zoeken';
$string['autocohortsync_name'] = 'Studyplan automatisch site-group synchronisatie doorzetten';
$string['back'] = 'Terug';
$string['badgedisabled'] = 'Deze badge is op dit moment niet beschikbaar';
$string['badgeinfo'] = 'Meer details';
$string['badgeissuedstats'] = 'Voortgang van uitgifte';
$string['badges'] = 'Badges';
$string['badgesearchinstruction'] = 'Typ 3 of meer tekens om te beginnen met zoeken';
$string['bistate_aggregator_desc'] = 'Doelen zijn behaald of niet (o.a. niet gestart, bezig en niet behaald). Vereiste leerdoelen zijn mogelijk. Per studieplan wordt ingesteld bij hoeveel doelen het resultaat voltooid, goed of uitstekend is.';
$string['bistate_aggregator_title'] = 'Handmatig: Behaald + Vereiste leerdoelen';
$string['cfg_grades'] = 'Configureer betekenis van beoordelingen en schalen';
$string['cfg_grades_desc'] = '';
$string['cfg_grades_desc_head'] = 'Stel hier in op welke manier resultaten voor doelen worden geïnterpreteerd.';
$string['cfg_grades_grades'] = 'Instellen betekenis puntenbeoordeling';
$string['cfg_grades_scales'] = 'Instellen betekenis resultaatschalen';
$string['cfg_help'] = 'Studieplan plug-in documentatie (Engels)';
$string['cfg_manageshares'] = 'Beheer door instelling gedeelde studieplanvoortgang';
$string['cfg_plans'] = 'Studieplannen beheren';
$string['cfg_uploadshares'] = 'Upload door instelling gedeelde studieplanvoortgang';
$string['choose_aggregation_style'] = 'Kies berekening van eindresultaten';
$string['cleanup_name'] = 'Dagelijkse onderhoudtaak voor studieplannen';
$string['coacheditmode'] = 'Bewerk inhoud';
$string['coaches'] = 'Coaches';
$string['coaching_plans'] = 'Studieplannen die ik coach';
$string['cohorts'] = 'Site-groepen';
$string['competency_aggregator_desc'] = 'Gebruik de bij de cursus ingestelde competenties';
$string['competency_aggregator_title'] = 'Cursuscompetenties';
$string['competency_details'] = 'Details';
$string['competency_heading'] = 'Competentie';
$string['competency_not_configured'] = 'De cursuscompetenties zijn nog niet ingesteld.';
$string['completed'] = 'Voltooid';
$string['completed_fail'] = 'Onvoldoende';
$string['completed_pass'] = 'Behaald';
$string['completion_completed'] = 'Voltooid';
$string['completion_completed_badge'] = 'Uitgegeven';
$string['completion_excellent'] = 'Uitstekend';
$string['completion_failed'] = 'Onvoldoende';
$string['completion_good'] = 'Goed';
$string['completion_incomplete'] = 'Niet gestart';
$string['completion_incomplete_badge'] = 'Niet uitgegeven';
$string['completion_not_configured'] = 'De cursusvoltooiing is nog niet ingesteld.';
$string['completion_not_enabled'] = 'Cursusvoltooiing is niet ingeschakeld';
$string['completion_passed'] = 'Behaald';
$string['completion_pending'] = 'Wacht op beoordelen';
$string['completion_progress'] = 'In ontwikkeling';
$string['condition_50'] = 'De helft van de onderdelen moeten afgerond zijn';
$string['condition_67'] = '2/3 van de onderdelen moeten afgerond zijn';
$string['condition_all'] = 'Alle onderdelen moeten afgerond zijn';
$string['condition_any'] = 'Minimaal één onderdeel moet afgerond zijn';
$string['condition_default'] = 'Standaard';
$string['configure_competency'] = 'Cursuscompetenties instellen';
$string['configure_completion'] = 'Voltooiing instellen';
$string['confirm_cancel'] = 'Annuleren';
$string['confirm_ok'] = 'Doorgaan';
$string['context'] = 'Categorie';
$string['core_aggregator_desc'] = 'Gebruik de ingesteld cursusvoltooiing';
$string['core_aggregator_title'] = 'Moodle cursusvoltooiing';
$string['course-invalid'] = 'Storing';
$string['course_period_span'] = 'Duurt';
$string['course_period_span_desc'] = 'Als de ruimte na deze cursus leeg is, kan de cursus worden uitgespreid over meerdere perioden.';
$string['course_timing_desc'] = 'De start- en einddatum van de cursus, komen niet overeen met die van de periode(n) waarin je hem hebt gedropt.';
$string['course_timing_hidewarning'] = 'Laat deze waarschuwing niet meer zien';
$string['course_timing_off'] = 'Cursustiming en periodetiming komen niet overeen. Klik hier om bij te werken.';
$string['course_timing_ok'] = 'Cursustiming en periodetiming komen overeen';
$string['course_timing_question'] = 'Wil je de start- en eindtijd van de cursus aanpassen naar doe van de periode(n)?';
$string['course_timing_rememberchoice'] = 'Onthoud mijn keuze voor toekomstige mismatches tussen cursus en periode';
$string['course_timing_title'] = 'Cursustiming en periodetiming komen niet overeen';
$string['course_timing_warning'] = 'Je hebt geen rechten om de start- en eindtijd van deze cursus aan te passen. Aanpassen van cursus naar periodetiming is niet beschikbaar.';
$string['courses'] = 'Cursussen';
$string['coursetiming_future'] = 'Toekomstige cursus';
$string['coursetiming_past'] = 'Eerdere cursus';
$string['coursetiming_present'] = 'Actieve cursus';
$string['csvcolumnmissing'] = 'Er ontbreken een of meer noodzakelijke kolommen in je CSV bestand: {$a}. Tip: Controleer of de namen van de kolommen goed gespeld zijn.';
$string['currentpage'] = 'Actief tabblad:';
$string['dateexpire'] = 'Veloopt op';
$string['dateissued'] = 'Afgegeven op';
$string['default_line_name'] = 'Cursussen';
$string['default_line_shortname'] = 'Cursussen';
$string['defaultaggregation'] = 'Standaard verwerkingsmethode';
$string['delete_association'] = 'Verwijderen';
$string['drophere'] = 'Sleep hierheen';
$string['duration'] = 'Duur';
$string['edit_plan'] = 'Studieplan bewerken';
$string['editmode_modules_hidden'] = 'Modules verborgen tijdens bewerken';
$string['error'] = 'Fout';
$string['error:cannotviewcategory'] = 'Fout: Je hebt geen rechten om deze category of context te bekijken: {$a}';
$string['error:coachdisabled'] = 'De coach functie is uitgeschakeld';
$string['error:invalid_invitekey'] = 'Je moet een uitnodiging hebben om via deze portal informatie te bekijken';
$string['error:invitationsdisabled'] = 'De optie om een studieplan te kunnen delen is uitgeschakeld op deze site.';
$string['error:nocategoriesvisible'] = 'Fout: Je kunt geen cursussen in een categorie bekijken. Daarom blijft de cursuslijst leeg';
$string['error:nostudyplaneditaccess'] = 'Fout: Je hebt geen rechten om studieplannen in deze categorie of context te beheren: {$a}';
$string['error:nostudyplanviewaccess'] = 'Fout: Je hebt geen rechten om studieplannen in deze categorie of context te bekijken: {$a}';
$string['error:nosuchcompetency'] = 'Waarschuwing: deze competentie is niet langer beschikbaar.';
$string['error:usernotassociated'] = 'Fout: De gevraagde student is niet gekoppeld aan dit studieplan';
$string['flow'] = 'Flow';
$string['grade_include'] = 'Doel';
$string['grade_points'] = 'Maximum aantal points';
$string['grade_require'] = 'Verplicht';
$string['graded'] = 'Beoordeeld';
$string['incomplete'] = 'Niet gestart';
$string['individuals'] = 'Individueel';
$string['infofield_position_above'] = 'Boven cursusresultaten';
$string['infofield_position_below'] = 'Onder cursusresultaten';
$string['infofield_position_footer'] = 'Footer';
$string['infofield_position_header'] = 'Header';
$string['invalid_invitekey_title'] = 'Uitnodiging vereist';
$string['invite_button_new'] = 'Nieuwe uitnodiging';
$string['invite_confirm_delete'] = 'Weet je zeker dat je de uitnodiging voor {$a} wilt intrekken/verwijderen?';
$string['invite_confirm_resend'] = 'Weet je zeker dat je de uitnodiging opnieuw wil verzenden naar {$a}?';
$string['invite_date'] = 'Datum';
$string['invite_desc_edit'] = 'Uitnodiging bewerken';
$string['invite_desc_new'] = 'Nieuwe uitnodiging maken';
$string['invite_description'] = 'Je kunt je ouders/verzorgers een uitnodiging sturen waarmee je live inzage in jouw studieplan en voortgang met  ze deelt. Degene die de uitnodiging krijgt kan jouw studieplan inzien totdat je de uitnodiging weer intrekt.';
$string['invite_email'] = 'Email';
$string['invite_identifier'] = 'Instellingslabel';
$string['invite_locked_error'] = 'Je kunt deze uitnodiging niet bewerken omdat die is vergrendeld.';
$string['invite_mail_managed_text'] = '<p>Beste {$a->invitee}, </p>
<p>We willen je graag uitnodigen om het studieplan en de studievoortgang van {$a->user} te bekijken.</p>
<p>Via de link hieronder kun je op elk moment het meest recente resultatenoverzicht bekijken. Je kunt deze link ook bewaren als bookmark in je browser.</p>
<p>Klik op de volgende link om het studieplan te bekijken:<br>
<a href="{$a->link}">{$a->link}</a></p>
<p>Met vriendelijke groet, <br>
het schoolbestuur</p>';
$string['invite_mail_subject'] = 'Gedeeld rapport van {$a->sender}';
$string['invite_mail_text'] = '<p>Beste {$a->invitee}, </p>
<p>Bij deze wil ik je graag uitnodigen om mijn studieplan en studievoortgang te bekijken.</p>
<p>Via de link hieronder kun je op elk moment het meest recente resultatenoverzicht bekijken. Je kunt deze link ook bewaren als bookmark in je browser.</p>
<p>Klik op de volgende link om het studieplan te bekijken:<br>
<a href="{$a->link}">{$a->link}</a></p>
<p>Met vriendelijke groet, <br>
{$a->sender}</p>';
$string['invite_manage_description'] = 'Op deze pagina kun je door de instelling gedeelde studieplanvoortgang beheren, bijvoorbeeld als er een wettelijke plicht is om studentenvoortgang te delen met ouders of verzorgers. Om met meerdere situaties rekening te kunnen houden hebben deze door de instelling gestuurde uitnodigingen om het studieplan van een student te bekijken een vervaldatum. Deze kan worden ingesteld op b.v. de leeftijd van meerderjarigheid van een student. Na de vervaldatum kan de uitnodiging door de student zelf kan worden bewerkt en verwijderd.';
$string['invite_manage_nomadatoryshares'] = 'Er zijn op dit moment geen';
$string['invite_manage_nouserselected'] = 'Kies een gebruiker om door instelling gedeelde studieplanvoortgang voor te beheren';
$string['invite_manage_resent_msg'] = 'De uitnodiging voor {$a->username} naar {$a->name}&lt;{$a->email}&gt; is verstuurd';
$string['invite_manage_selectuser'] = 'Selecteer gebruiker om uitnodigingen voor inzage te bekijken';
$string['invite_manage_tablecaption'] = 'Door instelling gedeelde studieplanvoortgang';
$string['invite_name'] = 'Naam';
$string['invite_notlocked'] = 'Vrij';
$string['invite_resent_msg'] = 'De uitnodiging naar {$a->name}<{$a->email}> is verzonden';
$string['invite_selectuser'] = 'Selecteer gebruiker';
$string['invite_table_empty'] = 'Geen openstaande uitnodigingen';
$string['invite_tablecaption'] = 'Actieve uitnodigingen';
$string['invite_tooltip_delete'] = 'Vewijderen';
$string['invite_tooltip_edit'] = 'Bewerken';
$string['invite_tooltip_resend'] = 'Opnieuw vesturen';
$string['invite_tooltip_testlink'] = 'Bekijk wat de anderen zien';
$string['invite_unlock_date'] = 'Uitnodiging vrijgegeven per';
$string['invite_unlocked'] = 'Vrijgegeven';
$string['item_configuration'] = 'Module configureren';
$string['item_delete_message'] = 'Weet je zeker dat je {item} {name} wilt verwijderen uit leerlijn {line} in {period}?';
$string['line_can_enrol'] = 'Je kunt jezelf inschrijven voor deze leerlijn';
$string['line_cannot_enrol'] = 'Je kunt je niet zelf inschrijven voor deze leerlijn';
$string['line_enrol'] = 'Inschrijven';
$string['line_enrol_question'] = 'Wil je jezelf inschrijven voor {$a}?';
$string['line_enrol_student_question'] = 'Wil je {$a} inschrijven voor deze leerlijn?';
$string['line_enrollable:0'] = 'Geen inschrijving nodig';
$string['line_enrollable:1'] = 'Inschrijving door student zelf';
$string['line_enrollable:2'] = 'Inschrijving door gebruiker met rol';
$string['line_enrollable:3'] = 'Inschrijving door student zelf of gebruiker met rol';
$string['line_enrolled'] = 'Ingeschreven';
$string['line_enrolled_in'] = 'Ingeschreven in {$a}';
$string['line_enrollment'] = 'Inschrijving';
$string['line_enrollments'] = 'Inschrijvingen';
$string['line_is_enrolled'] = 'Je bent ingeschreven voor deze leerlijn';
$string['line_notenrolled'] = 'Niet ingeschreven';
$string['line_unenrol'] = 'Uitschrijven';
$string['line_unenrol_student_question'] = 'Wil je {$a} uitschrijven voor deze leerlijn?';
$string['link_coach'] = 'Coach op studieplannen';
$string['link_editplan'] = 'Studieplannen beheren';
$string['link_myreport'] = 'Mijn studieplan';
$string['link_viewplan'] = 'Studieplannen';
$string['manage_invites'] = 'Studieplan delen';
$string['min_completed'] = 'Drempelwaarde voor voltooid';
$string['min_progress'] = 'Drempelwaarde voor ontwikkeling';
$string['myreport_teachermode'] = 'Studieplannen waar ik les aan geef';
$string['name'] = 'Naam';
$string['nav_invited'] = 'Studieplan op uitnodiging bekijken';
$string['no_form_data'] = 'Er is iets misgegaan met de ingevoerde gegevens. Waarschijnlijk heb je een afbeelding ingevoegd in een formaat dat niet ondersteund wordt. Controleer je gegevens en probeer het opnieuw.';
$string['no_templates'] = 'Er zijn geen templates beschikbaar. Zet het vinkje \'Bruikbaar als template\' aan bij een studieplan om deze als template te kunnen gebruiken.';
$string['noenddate'] = '∞';
$string['nogrades'] = 'Geen items';
$string['not_enrolled'] = 'Niet ingeschreven';
$string['open'] = 'Openen';
$string['overall'] = 'Cursus voltooid';
$string['overviewreport:all'] = 'Resultatenoverzicht';
$string['overviewreport:period'] = 'Resultatenoverzicht voor deze periode';
$string['period'] = 'Periode';
$string['period_default_fullname'] = 'Periode {$a}';
$string['period_default_shortname'] = 'P{$a}';
$string['period_edit'] = 'Periode aanpassen';
$string['periods'] = 'Perioden';
$string['pluginname'] = 'Studieplannen';
$string['privacy:metadata'] = 'Deze plug-in slaat een koppeling op tussen de gebruiker en diens persoonlijk gekoppelde studieplannen. Ook kan een gebruiker op basis van uitnodiging diens studieplan delen met een ander daarvoor worden gebruikers-id en email-adres en door de gebruiker opgegeven naam van de ontvanger opgeslagen.';
$string['privacy:metadata:coach'] = 'Koppelt een gebruiker als coach aan een studieplan';
$string['privacy:metadata:coach:studyplan_id'] = 'ID van gekoppeld studieplan';
$string['privacy:metadata:coach:user_id'] = 'Gebruikers-ID';
$string['privacy:metadata:invit'] = 'De gegevens van actieve uitnodigingen om iemands studieplannen te bekijken';
$string['privacy:metadata:invit:date'] = 'Datum waarop de uitnodiging is aangemaakt';
$string['privacy:metadata:invit:email'] = 'E-Mail adres van de ontvanger';
$string['privacy:metadata:invit:identifier'] = 'Label dat de onderwijsinstelling voor deze uitnodiging heeft';
$string['privacy:metadata:invit:name'] = 'Naam/Beschrijving die de gebruiker opgeeft voor de ontvanger';
$string['privacy:metadata:invit:unlockdate'] = 'Als dit is ingesteld, kan de uitnodiging tot dat moment niet worden bewerkt of verwijderd.';
$string['privacy:metadata:invit:user_id'] = 'Gebruikers-ID van de gebruiker';
$string['privacy:metadata:lineuser'] = 'Registreert een gebruiker als ingeschreven in een leerlijn';
$string['privacy:metadata:lineuser:enrolled'] = 'Of de gebruiker is ingeschreven of niet';
$string['privacy:metadata:lineuser:enrolledby'] = 'Optioneel: ID van een andere gebruiker die de inschrijving heeft gedaan.';
$string['privacy:metadata:lineuser:line_id'] = 'ID van de leerlijn';
$string['privacy:metadata:lineuser:timeenrolled'] = 'Moment van inschrijven';
$string['privacy:metadata:lineuser:user_id'] = 'Gebruikers-ID';
$string['privacy:metadata:teachers'] = 'Cachetabel tussen gebruikers en studieplannen waarin ze als leraar aan cursussen zijn gekoppeld';
$string['privacy:metadata:teachers:studyplan_id'] = 'Het studieplan waarin de leraar minimaal één cursus geeft.';
$string['privacy:metadata:teachers:teacher_id'] = 'Gebruikers-ID van de leraar';
$string['privacy:metadata:user'] = 'Persoonlijke koppelingen tussen gebruiker en studieplan';
$string['privacy:metadata:user:studyplan_id'] = 'ID van gekoppeld studieplan';
$string['privacy:metadata:user:user_id'] = 'Gebruikers-ID';
$string['refreshteacherlist_name'] = 'Ververs lijst van studieplannen voor leraar';
$string['report'] = 'Voortgangsrapport';
$string['report_index'] = 'Studieplannen van studenten inzien';
$string['report_invited'] = 'Voortgang van {$a}';
$string['required'] = 'Verplicht';
$string['required_goal'] = 'Verplicht leerdoel';
$string['result'] = 'Resultaat';
$string['results'] = 'Resultaten';
$string['search'] = 'Zoek';
$string['select_conditions'] = 'Voorwaarde voor afronding';
$string['select_grades'] = 'Resultaten die meetellen';
$string['select_scaleitem'] = 'Kies...';
$string['selected'] = 'Kies';
$string['selectstudent'] = 'Kies een student';
$string['selectstudent_btn'] = 'Selecteer overzicht';
$string['selectstudent_details'] = 'Kies een student uit de lijst om zijn/haar voortgang in dit studieplan te bekijken';
$string['send'] = 'Verzenden';
$string['setting_aggregation_mode'] = 'Standaard verwerkingsmethode';
$string['setting_bistate_accept_pending_submitted'] = 'Accepteer nog niet beoordeelde doelen als "in ontwikkeling"';
$string['setting_bistate_heading'] = 'Standaardwaarden voor Behaald + Vereiste leerdoelen';
$string['setting_bistate_support_failed'] = 'Onvoldoende ingeschakeld';
$string['setting_bistate_thresh_completed'] = 'Drempelwaarde voor voltooid (%)';
$string['setting_bistate_thresh_excellent'] = 'Drempelwaarde voor uitstekend (%)';
$string['setting_bistate_thresh_good'] = 'Drempelwaarde voor goed (%)';
$string['setting_bistate_thresh_progress'] = 'Drempelwaarde voor "in ontwikkeling" (%)';
$string['setting_competency_detailfield'] = 'Detailinfo competentie';
$string['setting_competency_displayname'] = 'Weergavetitel competentie';
$string['setting_competency_heading'] = 'Standaardwaarden voor cursuscompetenties';
$string['setting_competency_support_failed'] = 'Onvoldoende ingeschakeld';
$string['setting_competency_thresh_completed'] = 'Drempelwaarde voor voltooid (%)';
$string['setting_continueperiodnumberingnewpage'] = 'Perioden doornummeren op nieuw tabblad';
$string['setting_copystudylinesnewpage'] = 'Bestaande leerlijnen overnemen op nieuw tabblad';
$string['setting_courseprogressbar'] = 'Toon voortgangsbalk in cursus';
$string['setting_csync_autoremove_field'] = 'Automatisch verwijderen';
$string['setting_csync_creategroup_field'] = 'Groepen aanmaken';
$string['setting_csync_enable_field'] = 'Automatisch koppelen inschakelen';
$string['setting_csync_heading'] = 'Site-groepen die aan een studieplan gekoppeld zijn automatisch als site-groep synchronisatie koppelen aan alle cursussen in het studieplan.';
$string['setting_csync_remember_manual_csync_field'] = 'Bewaar bestaande site-group syncs';
$string['setting_csync_role_field'] = 'Synchronisatierol';
$string['setting_csync_users_field'] = 'Gekoppelde gebruikers automatisch inchrijven';
$string['setting_defaulticon'] = 'Standaard afbeelding voor studieplan';
$string['setting_display_field'] = 'Weergavenaam cursus';
$string['setting_display_heading'] = 'Weergave';
$string['setting_enablecoach'] = 'Coach rol inschakelen';
$string['setting_enableplansharing'] = 'Studieplan delen toestaan';
$string['setting_feature_heading'] = 'Functies';
$string['setting_hivizdropslots'] = 'Extra zichtbare sleepvelden';
$string['setting_infofield1_field'] = 'Laat gegevens zien uit cursusveld (1)';
$string['setting_infofield1_position'] = 'Plaats van cursusveld (1)';
$string['setting_infofield1_title'] = 'Titel voor gegevens uit cursusveld (1)';
$string['setting_infofield2_field'] = 'Laat gegevens zien uit cursusveld (2)';
$string['setting_infofield2_position'] = 'Plaats van cursusveld (2)';
$string['setting_infofield2_title'] = 'Titel voor gegevens uit cursusveld (2)';
$string['setting_infofield3_field'] = 'Laat gegevens zien uit cursusveld (3)';
$string['setting_infofield3_position'] = 'Plaats van cursusveld (3)';
$string['setting_infofield3_title'] = 'Titel voor gegevens uit cursusveld (3)';
$string['setting_infofield4_field'] = 'Laat gegevens zien uit cursusveld (4)';
$string['setting_infofield4_position'] = 'Plaats van cursusveld (4)';
$string['setting_infofield4_title'] = 'Titel voor gegevens uit cursusveld (4)';
$string['setting_infofield5_field'] = 'Laat gegevens zien uit cursusveld (5)';
$string['setting_infofield5_position'] = 'Plaats van cursusveld (5)';
$string['setting_infofield5_title'] = 'Titel voor gegevens uit cursusveld (5)';
$string['setting_infofields_heading'] = 'Extra cursusinformatie in popup';
$string['setting_limitcourselist'] = 'Cursusenlijst beperken tot categorie';
$string['setting_primary_nav_autofill'] = '<i>Aangepast menu items</i> automatisch aanvullen';
$string['setting_showprevnextarrows'] = 'Toon pijltjes naast de studentselectie drop-down';
$string['setting_timelessperiods'] = 'Tabbladen en periodes zonder tijd';
$string['setting_toolboxcoursesonly'] = 'Toon alleen cursussen in toolbox';
$string['setting_toolboxleft'] = 'Toolbox standaard links';
$string['settingdesc_aggregation_mode'] = 'Kies de standaard verwerkingsmethode voor nieuwe studieplannen';
$string['settingdesc_bistate_accept_pending_submitted'] = 'Neem leerdoelen waarbij bewijs is ingeleverd, maar wat nog niet is beoordeeld mee als "in ontwikkeling", zolang er nog geen beoordeling is';
$string['settingdesc_bistate_heading'] = 'Stel de standaardwaarden in voor deze verzamelmethode';
$string['settingdesc_bistate_support_failed'] = 'Vink aan om "Onvoldoende" weer te kunnen geven als resultaat voor een module';
$string['settingdesc_bistate_thresh_completed'] = 'Minimumpercentage behaalde doelen voor "Voltooid"';
$string['settingdesc_bistate_thresh_excellent'] = 'Minimumpercentage behaalde doelen voor "Uitstekend"';
$string['settingdesc_bistate_thresh_good'] = 'Minimumpercentage behaalde doelen voor "Goed"';
$string['settingdesc_bistate_thresh_progress'] = 'Minimumpercentage van doelen die niet onvoldoende mogen zijn voor resultaat "in ontwikkeling".<br><strong>Alleen van toepassing als Onvoldoende resultaten zijn ingeschakeld</strong>';
$string['settingdesc_competency_detailfield'] = 'Veld dat wordt gebruikt voor korte competentie details.';
$string['settingdesc_competency_displayname'] = 'Veld dat wordt gebruikt als titel voor een competentie';
$string['settingdesc_competency_heading'] = 'Stel de standaardwaarden in voor deze verzamelmethode';
$string['settingdesc_competency_support_failed'] = 'Vink aan om "Onvoldoende" weer te kunnen geven als eind resultaat voor een cursus';
$string['settingdesc_competency_thresh_completed'] = 'Minimumpercentage behaalde competenties voor "Behaald"';
$string['settingdesc_continueperiodnumberingnewpage'] = 'Bij aanmaken van een nieuw tabblad, wordt de standaardnaam van perioden doorgenummerd (b.v. P5, P6, P7, P8) in plaats van herstart (P1, P2, P3, P4)';
$string['settingdesc_copystudylinesnewpage'] = 'Bij aanmaken van een nieuw tabblad wordt een lege kopie van de leerlijnen van het vorige bestaande tabblad overgenomen';
$string['settingdesc_courseprogressbar'] = 'Laat een voortgangsbalk zien in de cursuspopup.';
$string['settingdesc_csync_autoremove_field'] = 'Verwijder synchronisaties in cursussen als deze uit het studieplan worden verwijderd.';
$string['settingdesc_csync_creategroup_field'] = 'Maak voor elke site-groep synchronisatie een groep aan.';
$string['settingdesc_csync_enable_field'] = 'Automatische koppelen van site-groep synchronisatie inschakelen.';
$string['settingdesc_csync_heading'] = '';
$string['settingdesc_csync_remember_manual_csync_field'] = 'Markeer site-group synchronisaties die eerder handmatig zijn aangemaakt, zodat deze niet worden verwijderd als ze uit het studieplan worden gehaald.';
$string['settingdesc_csync_role_field'] = 'Welke rol te gebruiken voor automatische site-groep sync koppelingen.';
$string['settingdesc_csync_users_field'] = 'Ook alle gebruikers die expliciet aan een studieplan gekoppeld zijn inschrijven in de cursussen van dat studieplan.';
$string['settingdesc_defaulticon'] = 'Stel standaard afbeelding in om weer te geven als een studieplan geen eigen afbeelding heeft ingesteld.';
$string['settingdesc_display_field'] = 'Kies welk veld gebruikt moet worden als weergavenaam van een cursus.';
$string['settingdesc_display_heading'] = 'Configuratie voor de weergave van de studieplannen.';
$string['settingdesc_enablecoach'] = 'Een coach kan aan een specifiek studieplan gekoppeld worden om deze te bewerken en studentresultaten te bekijken.';
$string['settingdesc_enableplansharing'] = 'Sta studenten toe om hun studieplannen te delen met anderen via een unieke link.';
$string['settingdesc_feature_heading'] = 'Stel functies van de studieplanplugin in.';
$string['settingdesc_hivizdropslots'] = 'Maak de velden waar cursussen heen gesleept kunnen worden extra goed zichtbaar.';
$string['settingdesc_infofield1_field'] = 'Kies cursusveld om informatie uit te tonen';
$string['settingdesc_infofield1_position'] = 'Waar de gegevens komen te staan in het cursusvenster';
$string['settingdesc_infofield1_title'] = 'Titel for cursusveld. Een regel per taal. Eindig met "|<langcode>" om taal aan te geven';
$string['settingdesc_infofield2_field'] = 'Kies cursusveld om informatie uit te tonen';
$string['settingdesc_infofield2_position'] = 'Waar de gegevens komen te staan in het cursusvenster';
$string['settingdesc_infofield2_title'] = 'Titel for cursusveld. Een regel per taal. Eindig met "|<langcode>" om taal aan te geven';
$string['settingdesc_infofield3_field'] = 'Kies cursusveld om informatie uit te tonen';
$string['settingdesc_infofield3_position'] = 'Waar de gegevens komen te staan in het cursusvenster';
$string['settingdesc_infofield3_title'] = 'Titel for cursusveld. Een regel per taal. Eindig met "|<langcode>" om taal aan te geven';
$string['settingdesc_infofield4_field'] = 'Kies cursusveld om informatie uit te tonen';
$string['settingdesc_infofield4_position'] = 'Waar de gegevens komen te staan in het cursusvenster';
$string['settingdesc_infofield4_title'] = 'Titel for cursusveld. Een regel per taal. Eindig met "|<langcode>" om taal aan te geven';
$string['settingdesc_infofield5_field'] = 'Kies cursusveld om informatie uit te tonen';
$string['settingdesc_infofield5_position'] = 'Waar de gegevens komen te staan in het cursusvenster';
$string['settingdesc_infofield5_title'] = 'Titel for cursusveld. Een regel per taal. Eindig met "|<langcode>" om taal aan te geven';
$string['settingdesc_infofields_heading'] = 'Kies tot 5 extra velden om in het cursuspopupvenster te laten zien.';
$string['settingdesc_limitcourselist'] = 'Beperk de lijst met beschikbare cursussen om in een studieplan te slepen tot  de cateogrie waarin het studieplan zich bevindt.';
$string['settingdesc_primary_nav_autofill'] = 'Om in het primaire navigatiemenu de studieplan links te tonen (vooral in Moodle 4.x), moeten regels worden toegevoegd in <b>Uiterlijk</b>&nbsp;-&nbsp;<b>Thema&nbsp;instellingen</b>&nbsp;<b>Aangepast&nbsp;menu&nbsp;items</b><br>Zet deze functie hier uit als dat niet gewenst is, b.v. als je Moodle (3.11 of lager) thema flat navigation gebruikt.';
$string['settingdesc_showprevnextarrows'] = 'Laat pijltjes zien voor de vorige en volgende student naast de drop-down box om een student te selecteren.';
$string['settingdesc_timelessperiods'] = 'Gebruik geen tijdinformatie in perioden en tabbladen';
$string['settingdesc_toolboxcoursesonly'] = 'Verberg de tabbladen "flow" en "badges" in de toolbox en toon alleen de cursussen.';
$string['settingdesc_toolboxleft'] = 'Toon de toolbox met cursussen en componenten standaard links in plaats van rechts.';
$string['settingspage'] = 'Studieplan instellingen';
$string['settingspage_csync'] = 'Site-groepen en gebruikerskoppelingen doorzetten naar cursussen';
$string['share_badge'] = 'Bewijs delen';
$string['share_report'] = 'Delen';
$string['showoverview'] = 'Docentenweergave';
$string['student_from_plan_enrolled'] = 'student in dit studieplan is in deze cursus ingeschreven';
$string['student_not_tracked'] = 'Niet ingeschreven in deze cursus';
$string['students_from_plan_enrolled'] = 'studenten in dit studieplan zijn in deze cursus ingeschreven';
$string['studyitem_confirm_remove'] = 'Weet je zeker dat je module {$a} wilt verwijderen?';
$string['studyline_add'] = 'Nieuwe leerlijn';
$string['studyline_color'] = 'Achtergrondkleur';
$string['studyline_confirm_remove'] = 'Weet je zeker dat je leerlijn {$a} wilt verwijderen?';
$string['studyline_edit'] = 'Leerlijn bewerken';
$string['studyline_editmode'] = 'Leerlijnen bewerken';
$string['studyline_enrollable'] = 'Inschrijven';
$string['studyline_enrolroles'] = 'Rollen mogen inschrijven';
$string['studyline_name'] = 'Naam';
$string['studyline_name_ph'] = '';
$string['studyline_remove'] = 'Leerlijn verwijderen';
$string['studyline_shortname'] = 'Korte naam';
$string['studyline_shortname_ph'] = '';
$string['studyplan_add'] = 'Nieuw studieplan';
$string['studyplan_confirm_remove'] = 'Weet je zeker dat je studieplan {$a} wilt verwijderen?';
$string['studyplan_context'] = 'Categorie';
$string['studyplan_description'] = 'Beschrijving';
$string['studyplan_description_ph'] = '';
$string['studyplan_details'] = 'Meer info';
$string['studyplan_duration'] = 'Duur';
$string['studyplan_edit'] = 'Studieplan bewerken';
$string['studyplan_emptytemplate'] = 'Leeg studieplan';
$string['studyplan_enddate'] = 'Einddatum';
$string['studyplan_fromtemplate'] = 'Baseer plan op template';
$string['studyplan_future'] = 'Toekomstige studieplannen';
$string['studyplan_icon'] = 'Afbeelding for this studyplan';
$string['studyplan_idnumber'] = 'Opleidings-ID';
$string['studyplan_idnumber_ph'] = '';
$string['studyplan_name'] = 'Volledige Naam';
$string['studyplan_name_ph'] = '';
$string['studyplan_noneselected'] = 'Kies een studieplan uit de lijst';
$string['studyplan_past'] = 'Eerdere studieplannen';
$string['studyplan_periods'] = 'Aantal periodes in studieplan';
$string['studyplan_present'] = 'Actieve studieplannen';
$string['studyplan_remove'] = 'Studieplan verwijderen';
$string['studyplan_report'] = 'Studieplan resultatenoverzicht';
$string['studyplan_select'] = 'Studieplan';
$string['studyplan_select_placeholder'] = 'Selecteer studieplan';
$string['studyplan_shortname'] = 'Korte naam';
$string['studyplan_shortname_ph'] = '';
$string['studyplan_slots'] = 'Aantal kolommen in studieplan';
$string['studyplan_startdate'] = 'Startdatum';
$string['studyplan_suspend'] = 'Studieplan tijdelijk uitschakelen';
$string['studyplan_suspend_details'] = 'Inkijken van studieplan tijdelijk uitschakelen, behalve voor beheerders.';
$string['studyplan_template'] = 'Bruikbaar als template';
$string['studyplan_template_details'] = 'Dit studieplan kan worden gebruikt als template voor nieuwe studieplannen';
$string['studyplanpage'] = 'Studieplan-tabblad';
$string['studyplanpage_add'] = 'Nieuw studieplan-tabblad';
$string['studyplanpage_confirm_remove'] = 'Weet je zeker dat je studieplan-tabblad {$a} wilt verwijderen?';
$string['studyplanpage_edit'] = 'Studieplan-tabblad bewerken';
$string['studyplanpage_info_periodsextended'] = 'Let op! Je hebt perioden toegevoegd aan dit tabblad. Deze nieuwe perioden hebben een ingeschatte start- en eindttijd die mogelijk na de ingestelde eindtijd van het tabblad liggen. Controleer daarom de start- en eindtijden van elke periode.';
$string['studyplanpage_remove'] = 'Studieplan-tabblad verwijderen';
$string['suspended'] = 'Tijdelijk uitgeschakeld';
$string['tool-badge'] = 'Badge';
$string['tool-finish'] = 'Eindpunt';
$string['tool-junction'] = 'Kruispunt';
$string['tool-start'] = 'Start/Vervolgpunt';
$string['toolbar-right'] = 'Deze balk rechts tonen';
$string['toolbox'] = 'Onderdelen';
$string['toolbox_toggle'] = 'Cursussen en elementen invoegen';
$string['treestudyplan:coach'] = 'Beschikbaar als coach';
$string['treestudyplan:configure'] = 'Studieplannen configureren';
$string['treestudyplan:editstudyplan'] = 'Studieplannen beheren';
$string['treestudyplan:forcescales'] = 'Gevorderd: Studieplanbeheerder kan alle opdrachten in studieplan instellen op specifieke resultaatschaal (alleen handmatige modes)';
$string['treestudyplan:lineunenrol'] = 'Beheer inschrijvingen van studenten in leerlijnen';
$string['treestudyplan:manageshares'] = 'Beheer door instelling gedeelde studieplanvoortgang';
$string['treestudyplan:selectowngradables'] = 'Docenten kunnen in hun eigen cursussen zelf activiteiten selecteren in een studieplan (docentenweergave, alleen handmatige modes)';
$string['treestudyplan:viewuserreports'] = 'Studieplannen van anderen bekijken';
$string['tristate_aggregator_desc'] = 'Leerdoelen kunnen reviseren, voltooid of uitstekend beoordeeld worden. Per modules kan worden ingesteld wel deel (standaard 50%) nodig is voor behalen van module';
$string['tristate_aggregator_title'] = 'Handmatig: Voortgang/Behaald/Goed Stijl';
$string['ungraded'] = 'Nog beoordelen';
$string['unknown'] = 'Beoordelingen onbekend';
$string['unrated'] = 'Niet beoordeeld';
$string['unsubmitted'] = 'Geen inzendingen';
$string['uploadshares'] = 'Upload door instelling gedeelde studieplanvoortgang';
$string['uploadshares_created'] = 'Aantal uitnodigingen aangemaakt: {$a}';
$string['uploadshares_errors'] = 'Aantal fouten: {$a}';
$string['uploadshares_help'] = 'Upload hier een CSV bestand met door de instelling te delen studievoortgang. In het CSV bestand moeten de volgende kolommen staan (exact zo aangegeven in de eerste regel): <ul><li><b>userid</b> Gebruikersid van de student wienst studieplanvoortgang wordt gedeeld</li><li><b>inviteename</b> Naam van de ontvanger.</li><li><b>inviteemail</b> Email address van de ontvanger.</li><li><b>unlockdate</b> De datum waarop de uitnodiging vrijgegeven wordt en de gebruker deze zelf kan bewerken of verwijderen</li><li><b>identifier</b> <i>(optioneel)</i> Een label om toe te voegen aan deze uitnodiging</li>';
$string['uploadshares_result:created'] = 'Aangemaakt';
$string['uploadshares_result:dateinvalid'] = 'Ongeldige datum';
$string['uploadshares_result:datepast'] = 'Vrijgavedatum in het verleden';
$string['uploadshares_result:emailinvalid'] = 'Ongeldig emailadres';
$string['uploadshares_result:exists'] = 'Bestaat al';
$string['uploadshares_result:updated'] = 'Bijgewerkt';
$string['uploadshares_result:usernotfound'] = 'Gebruiker niet gevonden';
$string['uploadshares_results'] = 'Resultaat van uploaden door instelling gedeelde studieplanvoortgang';
$string['uploadshares_skipped'] = 'Aantal regels overgeslagen: {$a}';
$string['uploadshares_total'] = 'Aantal regels verwerkt: {$a}';
$string['uploadshares_updated'] = 'Aantal uitnodigingen bijgewerkt: {$a}';
$string['users'] = 'Gebruikers';
$string['view_completion_report'] = 'Bekijk gedetailleerd voltooiingsoverzicht';
$string['view_feedback'] = 'Feedback bekijken';
$string['view_plan'] = 'Studieplannen bekijken';
$string['warning_incomplete_nograderq'] = 'Omdat het behalen van een cijfer niet als voorwaarde is aangegeven, telt het behalen van een voldoende resultaat niet mee voor voitooiing';
$string['warning_incomplete_pass'] = 'Er is een voldoende resultaat gegeven, maar de opdracht is nog niet voltooid. Bekijk de voltooiingsvoorwaarden en check bij de docent.';
$string['when'] = 'zodra';
