<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'webservice', language 'pt_br', version '4.1'.
 *
 * @package     webservice
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessexception'] = 'Exceção de controle de acesso';
$string['actwebserviceshhdr'] = 'Protocolos ativos para web services';
$string['addaservice'] = 'Adicionar serviço';
$string['addcapabilitytousers'] = 'Verificar capacidades do usuário';
$string['addcapabilitytousersdescription'] = 'Usuários devem possuir duas capacidades - webservice:createtoken e uma capacidade englobando os protocolos utilizados, por exemplo webservice/rest:use, webservice/soap:use. Para alcançar isto, crie um papel web services com as capacidades permitidas e associe ao usuário com papel web services como um papel de sistema';
$string['addexternalservice'] = 'Adicionar serviço externo';
$string['addfunction'] = 'Adicionar função';
$string['addfunctionhelp'] = 'Selecione a função para adicionar ao serviço.';
$string['addfunctions'] = 'Adicionar funções';
$string['addfunctionsdescription'] = 'Selecionar funções necessárias para o novo serviço criado.';
$string['addrequiredcapability'] = 'Associar/desassociar a capacidade requerida';
$string['addservice'] = 'Adicionar um novo serviço: {$a->name} (id: {$a->id})';
$string['addservicefunction'] = 'Adicione funções ao serviço "{$a}"';
$string['allusers'] = 'Todos usuários';
$string['apiexplorer'] = 'Explorador da API';
$string['apiexplorernotavalaible'] = 'API explorador ainda não disponível.';
$string['arguments'] = 'Argumentos';
$string['authmethod'] = 'Método de autenticação';
$string['callablefromajax'] = 'Pode ser chamado do AJAX';
$string['cannotcreatetoken'] = 'Sem permissão para criar um token de web service para o serviço {$a}.';
$string['cannotgetcoursecontents'] = 'Impossível obter conteúdos do curso';
$string['checkusercapability'] = 'Verificar capacidade do usuário';
$string['checkusercapabilitydescription'] = 'O usuário precisa ter as permissões apropriadas de acordo com os protocolos usados, por exemplo, webservice/rest:use, webservice/soap:use. Para conseguir isto, cria um papel para o web service com permissões sobre o protocolo e atribua-o  para o web service no nível do site.';
$string['configwebserviceplugins'] = 'Por questões de segurança, apenas protocolos que estão em uso devem ser habilitados.';
$string['context'] = 'Contexto';
$string['createservicedescription'] = 'Um serviço é um conjunto de funções web service. Você irá permitir a usuários acessar o novo serviço. Na página <strong>Adicionar serviço</strong> marque \'Habilitar\' e \'Usuários autorizados\'. Selecione \'Não exigir permissão\'.';
$string['createserviceforusersdescription'] = 'Um serviço é um conjunto de funções web service. Você irá permitir a usuários acessar o novo serviço. Na página <strong>Adicionar serviço</strong> marque \'Habilitar\' e \'Usuários autorizados\'. Selecione \'Não exigir permissão\'.';
$string['createtoken'] = 'Criar token';
$string['createtokenforuser'] = 'Criar um token para um usuário';
$string['createtokenforuserdescription'] = 'Criar um token para o usuário do web service.';
$string['createuser'] = 'Crie um usuário específico';
$string['createuserdescription'] = 'Um usuário Web Services é necessário para representar o sistema controlando o Moodle.';
$string['criteriaerror'] = 'Faltam permissões para buscar em um critério.';
$string['default'] = 'Padrão para "{$a}"';
$string['deleteaservice'] = 'Excluir serviço';
$string['deleteservice'] = 'Excluir o serviço: {$a->name} (id: {$a->id})';
$string['deleteserviceconfirm'] = 'Apagar um serviço irá também apagar os tokes relacionados a este serviço. Você realmente quer apagar o serviço externo "{$a}"?';
$string['deletetoken'] = 'Excluir token';
$string['deletetokenconfirm'] = 'Você realmente quer apagar este token do web service <strong>{$a->user}</strong> no serviço <strong>{$a->service}</strong>?';
$string['deprecated'] = 'Descontinuado';
$string['disabledwarning'] = 'Todos os protocolos para web service estão desabilitados. A configuração "Habilitar web services" pode ser encontrada em Características avançadas.';
$string['doc'] = 'Documentação';
$string['docaccessrefused'] = 'Você não tem permissão para ver a documentação para este token';
$string['downloadfiles'] = 'Pode baixar os arquivos';
$string['downloadfiles_help'] = 'Se habilitado, qualquer usuário pode baixar arquivos com suas chaves de segurança. Certamente eles estarão restritos aos arquivos que tem permissão para baixar no site.';
$string['editaservice'] = 'Editar serviço';
$string['editexternalservice'] = 'Editar serviço externo';
$string['editservice'] = 'Editar o serviço: {$a->name} (id: {$a->id})';
$string['enabled'] = 'Ativado';
$string['enabledocumentation'] = 'Ativar documentação do desenvolvedor';
$string['enabledocumentationdescription'] = 'Documentação detalhada dos web services está disponível para protocolos habilitados.';
$string['enableprotocols'] = 'Ativar protocolos';
$string['enableprotocolsdescription'] = 'Ao menos um protocolo deve estar habilitado. Por razões de segurança, apenas protocolos utilizados devem estar habilitados.';
$string['enablews'] = 'Habilitar web services';
$string['enablewsdescription'] = 'Web services devem ser habilitados em Características avançadas.';
$string['entertoken'] = 'Digite uma chave de segurança / token:';
$string['error'] = 'Erro: {$a}';
$string['errorcatcontextnotvalid'] = 'Você não pode executar funções no contexto da categoria (Id da categoria: {$a->catid}). O erro de contexto foi: {$a->message}';
$string['errorcodes'] = 'Mensagem de erro';
$string['errorcoursecontextnotvalid'] = 'Você não pode executar funções no contexto do curso (Id do curso: {$a->courseid}). O erro de contexto foi: {$a->message}';
$string['errorinvalidparam'] = 'O parâmetro "{$a}" é inválido.';
$string['errornotemptydefaultparamarray'] = 'O parâmetro de descrição do web service chamado \'{$a}\' é uma estrutura singular ou múltipla. O padrão só pode ser um vetor vazio. Verifique a descrição do web service.';
$string['erroroptionalparamarray'] = 'O parâmetro de descrição do web service chamado \'{$a}\' é uma estrutura singular ou múltipla. Este não pode ser declarado com VALUE_OPTIONAL. Verifique a descrição do web service.';
$string['eventwebservicefunctioncalled'] = 'Chamada da função do web service';
$string['eventwebserviceloginfailed'] = 'Login do web service falhou';
$string['eventwebserviceservicecreated'] = 'Web service criado';
$string['eventwebserviceservicedeleted'] = 'Web service excluído';
$string['eventwebserviceserviceupdated'] = 'Web service atualizado';
$string['eventwebserviceserviceuseradded'] = 'Usuário de web service adicionado';
$string['eventwebserviceserviceuserremoved'] = 'Usuário de web service removido';
$string['eventwebservicetokencreated'] = 'Token Web service criado';
$string['eventwebservicetokensent'] = 'Token de web service enviado';
$string['execute'] = 'Executar';
$string['executewarnign'] = 'Aviso: Caso pressionar executar sua base de dados será modificada e mudanças não poderão ser revertidas automaticamente! Se não tem certeza não faça.';
$string['externalservice'] = 'Serviço externo';
$string['externalservicefunctions'] = 'Funções de serviço externo';
$string['externalservices'] = 'Serviços externos';
$string['externalserviceusers'] = 'Usuários de serviço externo';
$string['failedtolog'] = 'Falhou ao logar';
$string['filenameexist'] = 'Nome de arquivo já existe: {$a}';
$string['forbiddenwsuser'] = 'Não é possível criar token para usuários não confirmados, excluídos, suspensos ou visitantes.';
$string['function'] = 'Função';
$string['functions'] = 'Funções';
$string['generalstructure'] = 'Estrutura geral';
$string['information'] = 'Informação';
$string['installexistingserviceshortnameerror'] = 'Já existe um web service com nome breve "{$a}". Não é possível instalar/atualizar um outro web service com o mesmo nome breve.';
$string['installserviceshortnameerror'] = 'Erro de codificação: o nome breve do web service "{$a}" pode conter apenas caracteres alfanuméricos (letras e números), sublinhado (_), hífen (-) ou ponto final (.)';
$string['invalidextparam'] = 'Parâmetro inválido api externa:{$a}';
$string['invalidextresponse'] = 'Resposta externa da api inválida : {$a}';
$string['invalidiptoken'] = 'Token inválido - seu IP não é suportado';
$string['invalidtimedtoken'] = 'Token inválido - token expirado';
$string['invalidtoken'] = 'Token inválido - token não encontrado';
$string['iprestriction'] = 'Restrição de IP';
$string['iprestriction_help'] = 'O usuário terá que chamar o web service a partir dos IPs listados (separado por vírgulas).';
$string['key'] = 'Chave';
$string['keyshelp'] = 'As chaves são usadas para acessar sua conta Moodle a partir de aplicações externas.';
$string['loginrequired'] = 'Restrito a usuários logados';
$string['manageprotocols'] = 'Gerenciar protocolos';
$string['managetokens'] = 'Gerenciar tokens';
$string['missingcaps'] = 'Faltando capacidades';
$string['missingcaps_help'] = 'Lista das permissões declaradas para o serviço que o usuário  não possui. Algumas funcionalidades do serviço podem não estar disponíveis sem essas permissões.';
$string['missingpassword'] = 'Faltando senha';
$string['missingrequiredcapability'] = 'A permissão {$a} é obrigatória.';
$string['missingusername'] = 'Faltando identificação de usuário';
$string['missingversionfile'] = 'Erro de codificação: arquivo version.php está ausente para o componente {$a}';
$string['nameexists'] = 'Este nome está em uso por outro serviço';
$string['nocapabilitytouseparameter'] = 'O usuário não tem a capacidade necessária para usar o parâmetro {$a}';
$string['nofunctions'] = 'Não há funções para esse serviço.';
$string['norequiredcapability'] = 'Capacidade não exigida';
$string['notoken'] = 'O token está vazio.';
$string['onesystemcontrolling'] = 'Permitir um sistema externo para controlar o Moodle';
$string['onesystemcontrollingdescription'] = 'Os passos seguintes ajudam você a configurar os serviços web do Moodle para permitir que um sistema externo interaja com Moodle. Isso inclui a criação de um método de autenticação do token (chave de segurança).';
$string['onlyseecreatedtokens'] = 'Você pode ver somente os tokens que você criou.';
$string['operation'] = 'Operação';
$string['optional'] = 'Opcional';
$string['passwordisexpired'] = 'Senha expirada.';
$string['phpparam'] = 'XML-RPC (Estrutura PHP)';
$string['phpresponse'] = 'XML-RPC (Estrutura PHP)';
$string['postrestparam'] = 'Código PHP para REST (Requisição POST)';
$string['potusers'] = 'Usuários não autorizados';
$string['potusersmatching'] = 'Não há usuários autorizados conferindo';
$string['print'] = 'Imprimir todos';
$string['privacy:metadata:serviceusers'] = 'Uma lista de usuários que podem utilizar um determinado serviço externo';
$string['privacy:metadata:serviceusers:iprestriction'] = 'IP restrito para usar o serviço';
$string['privacy:metadata:serviceusers:timecreated'] = 'A data de criação do registro';
$string['privacy:metadata:serviceusers:userid'] = 'O ID do usuário';
$string['privacy:metadata:serviceusers:validuntil'] = 'A data final de validade da autorização';
$string['privacy:metadata:tokens'] = 'Um registro de tokens para interagir com o Moodle por meio de serviços web ou aplicativos móveis.';
$string['privacy:metadata:tokens:creatorid'] = 'O ID do usuário que criou o token';
$string['privacy:metadata:tokens:iprestriction'] = 'IP restrito para usar este token';
$string['privacy:metadata:tokens:lastaccess'] = 'A data em que o token foi usado pela última vez';
$string['privacy:metadata:tokens:privatetoken'] = 'Um token mais confidencial ocasionalmente usado para validar certas operações, como SSO';
$string['privacy:metadata:tokens:timecreated'] = 'A data que o token foi criado';
$string['privacy:metadata:tokens:token'] = 'O token do usuário';
$string['privacy:metadata:tokens:tokentype'] = 'O tipo de token';
$string['privacy:metadata:tokens:userid'] = 'O ID do usuário cujo token é';
$string['privacy:metadata:tokens:validuntil'] = 'O token é válido até a data';
$string['privacy:request:notexportedsecurity'] = 'Não exportado por motivo de segurança';
$string['protocol'] = 'Protocolo';
$string['removefunction'] = 'Remover';
$string['removefunctionconfirm'] = 'Você deseja remover a função "{$a->function}" do serviço "{$a->service}"?';
$string['requireauthentication'] = 'Este método requer autenticação com permissão xxx.';
$string['required'] = 'Obrigatório';
$string['requiredcapability'] = 'Capacidade exigida';
$string['requiredcapability_help'] = 'Se definido, somente usuários com a capability exigida poderá acessar o serviço.';
$string['requiredcaps'] = 'Capacidades exigidas';
$string['resettokencomplete'] = 'O token selecionado foi "resetado"';
$string['resettokenconfirm'] = 'Você realmente quer reiniciar esta chave do web service para  <strong>{$a->user}</strong> no serviço <strong>{$a->service}</strong>?';
$string['resettokenconfirmsimple'] = 'Você realmente que reiniciar esta chave? Qualquer links salvos contendo a chave antiga não funcionarão mais.';
$string['response'] = 'Resposta';
$string['restcode'] = 'REST';
$string['restexception'] = 'REST';
$string['restoredaccountresetpassword'] = 'Conta restaurada precisa reiniciar a senha antes de obter um token.';
$string['restparam'] = 'REST (parâmetros POST)';
$string['restrictedusers'] = 'Apenas usuários autorizados';
$string['restrictedusers_help'] = 'Esta configuração determina se todos os usuários com permissões para criar token para "web services" podem gerar um token para este serviço através das suas páginas de chaves de segurança ou se apenas usuários autorizados podem realizar esta ação.';
$string['securitykey'] = 'Chave de segurança (token)';
$string['securitykeys'] = 'Chaves de segurança';
$string['selectauthorisedusers'] = 'Selecione usuários autorizados';
$string['selectedcapability'] = 'Selecionado';
$string['selectedcapabilitydoesntexit'] = 'A configuração atual exige a permissão ({$a}) não existe mais. Por favor altere-a e salve as alterações.';
$string['selectservice'] = 'Selecione um serviço';
$string['selectspecificuser'] = 'Selecione um usuário específico';
$string['selectspecificuserdescription'] = 'Adicionar o usuário do web services como um usuário autorizado.';
$string['service'] = 'Serviço';
$string['servicehelpexplanation'] = 'Um serviço é um conjunto de funções. Um serviço pode ser acessado por todos os usuários ou apenas usuários específicos.';
$string['servicename'] = 'Nome do serviço';
$string['servicenotavailable'] = 'Web service não disponível (não existe ou talvez não desabilitado).';
$string['servicerequireslogin'] = 'Web service não disponível. (A sessão foi finalizada ou expirou).';
$string['servicesbuiltin'] = 'Serviços construídos';
$string['servicescustom'] = 'Serviços personalizados';
$string['serviceusers'] = 'Usuários autorizados';
$string['serviceusersettings'] = 'Configurações de usuário';
$string['serviceusersmatching'] = 'Usuários autorizados que conferem';
$string['serviceuserssettings'] = 'Alterar configurações para os usuários autorizados';
$string['shortnametaken'] = 'Nome curto já está sendo usado para outro serviço ({$a})';
$string['simpleauthlog'] = 'Login de autenticação simples';
$string['step'] = 'Etapa';
$string['supplyinfo'] = 'Mais detalhes';
$string['testauserwithtestclientdescription'] = 'Simula acesso externo ao serviço usando o cliente de teste do web service. Antes de fazer isso, faça login com o um usuário que possua a permissão moodle/webservice:createtoken e obtenha uma chave de segurança (token) via configurações de perfil. Você usará esse token no cliente de teste e escolha um protocolo habilitado com autenticação via token.<strong>AVISO: As funções testadas SERÃO EXECUTADAS para esse usuário, portanto seja cuidadoso ao escolher o que testar!</strong>';
$string['testclient'] = 'Cliente de testes do web service';
$string['testclientdescription'] = '* O cliente de teste para web services <strong>executa</strong> as funções <strong>REALMENTE</strong>. Não teste funções que você não conhece.<br/>* Todas as funções  web service existentes  ainda não são implementadas no cliente de teste.<br/>* Para verificar se um usuário não pode acessar algumas, funções, você pode testar algumas funções não permitidas.<br/>* Para ver mensagens de erro mais significativas configure o debug para <strong>{$a->mode}</strong> em {$a->atag}.';
$string['testwithtestclient'] = 'Teste o serviço';
$string['testwithtestclientdescription'] = 'Simula acesso externo ao usando o cliente de teste do web service. Use um protocolo habilitado com autenticação via token.<strong>AVISO: As funções testadas SERÃO EXECUTADAS para esse usuário, portanto seja cuidadoso ao escolher o que testar!</strong>';
$string['token'] = 'Token';
$string['tokenauthlog'] = 'Autenticação com token';
$string['tokencreatedbyadmin'] = 'Só pode ser reajustado pelo administrador (*)';
$string['tokencreator'] = 'Criador';
$string['tokenfilter'] = 'Filtro de tokens';
$string['tokenfilterreset'] = 'Mostrar todos os tokens';
$string['tokenfiltersubmit'] = 'Mostrar apenas tokens combinando';
$string['unknownoptionkey'] = 'Chave de opção desconhecida ({$a})';
$string['unnamedstringparam'] = 'Um parâmetro string está sem nome.';
$string['updateusersettings'] = 'Atualizar';
$string['uploadfiles'] = 'Pode fazer upload de arquivos';
$string['uploadfiles_help'] = 'Se habilitado, qualquer usuário pode fazer upload de arquivos com suas chaves de segurança para sua própria área de arquivos privados ou uma de "rascunho". São aplicados todas as quotas referentes a arquivos dos usuários.';
$string['userasclients'] = 'Usuários como clientes com tokens';
$string['userasclientsdescription'] = 'Os passos a seguir ajudam você a configurar o web service do Moodle para usuários como clientes. Estes passos também ajudam a configurar o método de autenticação recomendado, token (chaves seguras). Neste caso, o usuário gera seu token a partir da página de chaves seguras via "Minhas configurações de perfil"';
$string['usermissingcaps'] = 'Faltando capacidades: {$a}';
$string['usernameorid'] = 'Identificação de usuário / id de usuário';
$string['usernameorid_help'] = 'Informe uma identificação de usuário ou id de usuário.';
$string['usernameoridnousererror'] = 'Não foram encontrados usuários com esta identificação/id de usuário.';
$string['usernameoridoccurenceerror'] = 'Mais do que um usuário encontrado com esta identificação, por favor insira o id do usuário.';
$string['usernotallowed'] = 'O usuário não tem permissão para este serviço. Primeiro você necessita permitir este usuário na página de administração de usuários {$a}';
$string['userservices'] = 'Serviços de usuário: {$a}';
$string['usersettingssaved'] = 'As configurações do usuário salvas';
$string['validuntil'] = 'Válido até';
$string['validuntil_help'] = 'Se definido, o serviço será inativado após esta data para este usuário.';
$string['webservice'] = 'Web services';
$string['webservices'] = 'Web services';
$string['webservicesoverview'] = 'Resumo';
$string['webservicetokens'] = 'Tokens para web service';
$string['wrongusernamepassword'] = 'Identificação de usuário ou senha incorretos';
$string['wsaccessuserdeleted'] = 'Acesso recusado ao web service para usuário excluído: {$a}';
$string['wsaccessuserexpired'] = 'Acesso ao web service recusado pela senha expirada para o para o username: {$a}';
$string['wsaccessusernologin'] = 'Acesso recusado ao web service para usuário com autenticação "nenhum login": {$a}';
$string['wsaccessusersuspended'] = 'Acesso recusado ao web service para usuário suspenso: {$a}';
$string['wsaccessuserunconfirmed'] = 'Acesso recusado ao web service para usuário não confirmado: {$a}';
$string['wsclientdoc'] = 'Documentação do cliente de web service do Moodle';
$string['wsdocapi'] = 'Documentação da API';
$string['wsdocumentation'] = 'Web documentação de serviço';
$string['wsdocumentationdisable'] = 'Documentação do web service desativada.';
$string['wsdocumentationintro'] = 'Para criar um cliente sugerimos que você leia o {$a->doclink}';
$string['wsdocumentationlogin'] = 'ou insira seu usuário e senha do web service:';
$string['wspassword'] = 'Senha do web service';
$string['wsusername'] = 'Identificação de usuário do web service';
