<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'completion', language 'lo', version '4.1'.
 *
 * @package     completion
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievinggrade'] = 'ການບັນລຸໄດ້ຄະແນນ';
$string['achievingpassinggrade'] = 'ການສຳເລັດຄະແນນຜ່ານ';
$string['activities'] = 'ກິດຈະກໍາ';
$string['activitiescompleted'] = 'ການສຳເລັດກິດຈະກໍາ';
$string['activitiescompletednote'] = 'ໝາຍເຫດ: ຕ້ອງເຮັດສຳເລັດກິດຈະກໍາເພື່ອໃຫ້ກິດຈະກໍາປະກົດຂຶ້ນຢູ່ໃນລາຍການຂ້າງເທິງ.';
$string['activitieslabel'] = 'ກິດຈະກໍາ / ແຫຼ່ງຂໍ້ມູນ';
$string['activityaggregation'] = 'ເງື່ອນໄຂທີ່ຕ້ອງການ';
$string['activityaggregation_all'] = 'ທຸກກິດຈະກຳທີ່ເລືອກທີ່ຈະສຳເລັດ';
$string['activityaggregation_any'] = 'ກິດຈະກຳໃດໜຶ່ງທີ່ເລືອກທີ່ຈະສຳເລັດ';
$string['activitycompletion'] = 'ການສຳເລັດກິດຈະກຳ';
$string['activitycompletionupdated'] = 'ບັນທຶກການປ່ຽນແປງ';
$string['activitygradenotrequired'] = 'ບໍ່ຈຳເປັນຕ້ອງໃຫ້ຄະແນນ';
$string['activitygradetopassnotset'] = 'ກິດຈະກໍານີ້ບໍ່ມີຄະແນນທີ່ຖືກຕ້ອງທີ່ຈະຜ່ານທີ່ກໍານົດໄວ້. ມັນອາດຈະຖືກຕັ້ງຢູ່ໃນພາກຊັ້ນຮຽນຂອງການຕັ້ງຄ່າກິດຈະກໍາ.';
$string['affectedactivities'] = 'ການປ່ຽນແປງຈະມີຜົນກັບກິດຈະກໍາ <b>{$a}</b> ຫຼື ແຫຼ່ງຂໍ້ມູນຕໍ່ໄປນີ້:';
$string['aggregationmethod'] = 'ວິທີການລວມ';
$string['all'] = 'ທັງໝົດ';
$string['any'] = 'ອັນໃດໜຶ່ງ';
$string['approval'] = 'ການອະນຸມັດ';
$string['areyousureoverridecompletion'] = 'ທ່ານແນ່ໃຈບໍ່ວ່າ ທ່ານຕ້ອງການລົບລ້າງສະຖານະການສໍາເລັດຂອງການເຄື່ອນໄຫວນີ້ສໍາລັບຜູ້ໃຊ້ນີ້ ແລະ ໝາຍມັນ "{$a}"?';
$string['badautocompletion'] = 'ເມື່ອທ່ານເລືອກການເຮັດສຳເລັດອັດຕະໂນມັດ, ທ່ານຍັງຕ້ອງເປີດນຳໃຊ້ຢ່າງໜ້ອຍໜຶ່ງຄວາມຕ້ອງການ (ດ້ານລຸ່ມ).';
$string['badcompletiongradeitemnumber'] = 'ບໍ່ສາມາດເປີດໃຊ້ຄະແນນທີ່ຈຳເປັນສຳລັບ <b>{$a}</b> ໄດ້ເພາະວ່າການໃຫ້ຄະແນນຕາມ {$a} ບໍ່ໄດ້ຖືກເປີດນຳໃຊ້.';
$string['bulkactivitycompletion'] = 'ການສຳເລັດການແກ້ໄຂກິດຈະກຳຈຳນວນຫຼາຍ';
$string['bulkactivitydetail'] = 'ເລືອກກິດຈະກຳທີ່ທ່ານຕ້ອງການແກ້ໄຂເປັນຊຸດ.';
$string['bulkcompletiontracking'] = 'ການຕິດຕາມສຳເລັດ';
$string['bulkcompletiontracking_help'] = '<strong>ບໍ່ມີ:</strong> ຢ່າບົ່ງບອກເຖິງການສໍາເລັດກິດຈະກໍາ

<strong>ດ້ວຍຕົວເອງ:</strong> ນັກຮຽນສາມາດໝາຍກິດຈະກໍາດ້ວຍຕົນເອງວ່າສໍາເລັດແລ້ວ

<strong>ດ້ວຍເງື່ອນໄຂ:</strong> ສະແດງກິດຈະກຳວ່າ ສຳເລັດ ເມື່ອຄົບເງື່ອນໄຂ';
$string['checkactivity'] = 'ກ່ອງເຄື່ອງໝາຍສຳລັບກິດຈະກຳ / ແຫຼ່ງຂໍ້ມູນ: {$a}';
$string['checkall'] = 'ກວດເບິ່ງ ຫຼື ຍົກເລີກການເລືອກກິດຈະກໍາ ແລະ ແຫຼ່ງຂໍ້ມູນທັງໝົດ';
$string['checkallsection'] = 'ກວດເບິ່ງ ຫຼື ຍົກເລີກການເລືອກກິດຈະກໍາ ແລະ ແຫຼ່ງຂໍ້ມູນທັງໝົດຢູ່ໃນພາກສ່ວນຕໍ່ໄປນີ້: {$a}';
$string['completeactivity'] = 'ສໍາເລັດກິດຈະກໍາ';
$string['completed'] = 'ສຳເລັດແລ້ວ';
$string['completedunlocked'] = 'ປົດລັອກຕົວເລືອກສຳເລັດແລ້ວ';
$string['completedunlockedtext'] = 'ເມື່ອທ່ານບັນທຶກການປ່ຽນແປງ, ສະຖານະການສໍາເລັດສໍາລັບນັກຮຽນທຸກຄົນຈະຖືກລຶບ. ຖ້າເຈົ້າປ່ຽນໃຈກ່ຽວກັບເລື່ອງນີ້, ຢ່າບັນທຶກຟອມ.';
$string['completedwarning'] = 'ຕົວເລືອກຄວາມສຳເລັດຖືກລັອກ';
$string['completedwarningtext'] = 'ການເຄື່ອນໄຫວນີ້ໄດ້ຖືກໝາຍວ່າ ສຳເລັດແລ້ວ ສຳລັບຜູ້ເຂົ້າຮ່ວມ {$a} ຄົນ. ການປ່ຽນຕົວເລືອກການສໍາເລັດຈະລຶບສະຖານະການສໍາເລັດຂອງເຂົາເຈົ້າ ແລະ ອາດຈະເຮັດໃຫ້ເກີດຄວາມສັບສົນ. ດັ່ງນັ້ນທາງເລືອກທີ່ໄດ້ຖືກລັອກ ແລະ ບໍ່ຄວນຈະໄດ້ຮັບການປົດລັອກເວັ້ນເສຍແຕ່ວ່າມີຄວາມຈໍາເປັນຢ່າງແທ້ຈິງ.';
$string['completion'] = 'ການຕິດຕາມສຳເລັດ';
$string['completion-alt-auto-enabled'] = 'ລະບົບໝາຍລາຍການນີ້ວ່າສົມບູນຕາມເງື່ອນໄຂ: {$a}';
$string['completion-alt-auto-fail'] = 'ສຳເລັດແລ້ວ: {$a} (ບໍ່ໄດ້ຮັບຄະແນນຜ່ານ)';
$string['completion-alt-auto-n'] = 'ບໍ່ສຳເລັດ: {$a}';
$string['completion-alt-auto-n-override'] = 'ບໍ່ສຳເລັດ: {$a->modname} (ຕັ້ງໂດຍ {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'ສຳເລັດແລ້ວ: {$a} (ໄດ້ຮັບຄະແນນຜ່ານ)';
$string['completion-alt-auto-y'] = 'ສຳເລັດແລ້ວ: {$a}';
$string['completion-alt-auto-y-override'] = 'ສຳເລັດແລ້ວ: {$a->modname} (ຕັ້ງໂດຍ {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'ນັກຮຽນສາມາດໝາຍລາຍການນີ້ວ່າ ສໍາເລັດ ດ້ວຍຕົນເອງ: {$ a}';
$string['completion-alt-manual-n'] = 'ບໍ່ສຳເລັດ: {$a}. ເລືອກເພື່ອໝາຍວ່າສຳເລັດແລ້ວ.';
$string['completion-alt-manual-n-override'] = 'ບໍ່ສຳເລັດ: {$a->modname} (ຕັ້ງໂດຍ {$a->overrideuser}). ເລືອກເພື່ອໝາຍວ່າສຳເລັດແລ້ວ.';
$string['completion-alt-manual-y'] = 'ສຳເລັດແລ້ວ: {$a}. ເລືອກເພື່ອໝາຍວ່າ ບໍ່ສຳເລັດ.';
$string['completion-alt-manual-y-override'] = 'ສໍາເລັດ: {$ a->modname} (ຕັ້ງໂດຍ {$a->overrideuser}). ເລືອກເພື່ອໝາຍວ່າ ບໍ່ສຳເລັດ.';
$string['completion-fail'] = 'ສຳເລັດແລ້ວ (ບໍ່ໄດ້ຮັບຄະແນນຜ່ານ)';
$string['completion-n'] = 'ບໍ່ສຳເລັດ';
$string['completion-n-override'] = 'ບໍ່ສຳເລັດ (ຕັ້ງໂດຍ {$a})';
$string['completion-pass'] = 'ສໍາເລັດແລ້ວ (ໄດ້ຮັບຄະແນນຜ່ານ)';
$string['completion-y'] = 'ສຳເລັດແລ້ວ';
$string['completion-y-override'] = 'ສຳເລັດແລ້ວ (ຕັ້ງໂດຍ {$a})';
$string['completion_automatic'] = 'ສະແດງກິດຈະກໍາໃຫ້ສໍາເລັດເມື່ອຄົບເງື່ອນໄຂ';
$string['completion_help'] = 'ຖ້າເປີດໃຊ້ງານ, ການສໍາເລັດກິດຈະກໍາຖືກຕິດຕາມ, ບໍ່ວ່າຈະດ້ວຍຕົນເອງ ຫຼື ອັດຕະໂນມັດ, ອີງຕາມເງື່ອນໄຂສະເພາະ. ເງື່ອນໄຂຫຼາຍອັນອາດຈະຖືກຕັ້ງຖ້າຕ້ອງການ. ຖ້າເປັນແນວນັ້ນ, ກິດຈະກໍາຈະຖືກພິຈາລະນາວ່າ ສຳເລັດ ເມື່ອທຸກເງື່ອນໄຂຄົບຖ້ວນ.';
$string['completion_link'] = 'activity/completion';
$string['completion_manual'] = 'ນັກຮຽນສາມາດໝາຍກິດຈະກໍາດ້ວຍຕົນເອງວ່າສໍາເລັດແລ້ວ';
$string['completion_none'] = 'ຢ່າຊີ້ບອກເຖິງການສໍາເລັດກິດຈະກໍາ';
$string['completionactivitydefault'] = 'ໃຊ້ກິດຈະກຳເລີ່ມຕົ້ນ';
$string['completiondefault'] = 'ການຕິດຕາມຄວາມສຳເລັດເລີ່ມຕົ້ນ';
$string['completiondisabled'] = 'ປິດໃຊ້ງານແລ້ວ, ບໍ່ສະແດງຢູ່ໃນການຕັ້ງຄ່າກິດຈະກໍາ';
$string['completionduration'] = 'ການລົງທະບຽນ';
$string['completionenabled'] = 'ເປີດໃຊ້ງານແລ້ວ, ຄວບຄຸມຜ່ານການສໍາເລັດ ແລະ ການຕັ້ງຄ່າກິດຈະກໍາ';
$string['completionexpected'] = 'ຄາດວ່າຈະສຳເລັດໃນວັນທີ';
$string['completionexpected_help'] = 'ການຕັ້ງຄ່ານີ້ລະບຸວັນທີທີ່ກິດຈະກໍາຄາດວ່າຈະສໍາເລັດ. ເມື່ອວັນທີ່ຈະມາເຖິງ, ກິດຈະກໍາໄດ້ລະບຸໄວ້ຢູ່ໃນກ່ອງເສັ້ນເວລາໃນແຜງໜ້າປັດ.';
$string['completionexpecteddesc'] = 'ຄາດວ່າຈະສຳເລັດໃນວັນທີ {$a}';
$string['completionexpectedfor'] = '{$a->instancename} ຄວນຈະສໍາເລັດ';
$string['completionicons'] = 'ກ່ອງໝາຍຕິກສຳເລັດ';
$string['completionicons_help'] = 'ໝາຍຕິກຢູ່ຂ້າງຊື່ກິດຈະກຳອາດຈະຖືກໃຊ້ເພື່ອຊີ້ບອກເວລາກິດຈະກໍາສໍາເລັດ.

ຖ້າກ່ອງທີ່ມີເສັ້ນຂອບຈຸດສະແດງໃຫ້ເຫັນ, ເຄື່ອງໝາຍຕິກຈະປະກົດຂຶ້ນໂດຍອັດຕະໂນມັດ ເມື່ອທ່ານເຮັດສຳເລັດກິດຈະກຳຕາມເງື່ອນໄຂທີ່ຄູສອນກຳນົດໄວ້.

ຖ້າປ່ອງທີ່ມີຂອບເຕັມຖືກສະແດງ, ທ່ານສາມາດຄລິກໃສ່ມັນເພື່ອໝາຍໃສ່ຫ້ອງດັ່ງກ່າວເມື່ອທ່ານຄິດວ່າທ່ານໄດ້ສໍາເລັດກິດຈະກໍາແລ້ວ. (ການຄລິກມັນອີກເທື່ອໜຶ່ງຈະເອົາໝາຍຕິກອອກຖ້າທ່ານປ່ຽນໃຈ.)';
$string['completionmenuitem'] = 'ສຳເລັດ';
$string['completionnotenabled'] = 'ບໍ່ສຳເລັດການເປີດນຳໃຊ້';
$string['completionnotenabledforcourse'] = 'ລາຍວິຊານີ້ບໍ່ໄດ້ຖືກເປີດໃຊ້';
$string['completionnotenabledforsite'] = 'ບໍ່ໄດ້ເປີດໃຊ້ການເຮັດສຳເລັດໃນເວັບໄຊທ໌ນີ້';
$string['completionondate'] = 'ວັນທີ່';
$string['completionondatevalue'] = 'ວັນເວລາທີ່ລາຍວິຊາຈະຖືກໝາຍວ່າ ສຳເລັດ';
$string['completionpassgrade'] = 'ຕ້ອງການຄະແນນຜ່ານ';
$string['completionpassgrade_desc'] = 'ນັກຮຽນຕ້ອງໄດ້ຮັບຄະແນນຜ່ານເພື່ອສຳເລັດກິດຈະກຳນີ້';
$string['completionpassgrade_help'] = 'ຖ້າເປີດໃຊ້ງານ, ກິດຈະກຳໄດ້ພິຈາລະນາວ່າສຳເລັດເມື່ອໄດ້ຮັບຄະແນນຜ່ານ.';
$string['completionsettingslocked'] = 'ລັອກການຕັ້ງຄ່າການສຳເລັດແລ້ວ';
$string['completionupdated'] = 'ປັບປຸງການສຳເລັດໃຫ້ກັບກິດຈະກຳ <b>{$a}</b> ແລ້ວ';
$string['completionusegrade'] = 'ຄະແນນທີ່ຕ້ອງການ';
$string['completionusegrade_desc'] = 'ນັກຮຽນຕ້ອງໄດ້ຮັບຄະແນນເພື່ອໃຫ້ກິດຈະກໍານີ້ສໍາເລັດ';
$string['completionusegrade_help'] = 'ຖ້າເປີດນຳໃຊ້, ກິດຈະກໍາຖືວ່າສໍາເລັດເມື່ອນັກຮຽນໄດ້ຮັບຄະແນນ. ຖ້າຄະແນນຜ່ານສໍາລັບກິດຈະກໍາຖືກກໍານົດ, ຈາກນັ້ນໄອຄອນຜ່ານ ແລະ ບໍ່ຜ່ານ ຈະຖືກສະແດງຢູ່ໃນບົດລາຍງານການສໍາເລັດກິດຈະກໍາ.';
$string['completionview'] = 'ຕ້ອງການເບິ່ງ';
$string['completionview_desc'] = 'ນັກຮຽນຕ້ອງເບິ່ງກິດຈະກໍານີ້ເພື່ອໃຫ້ມັນສໍາເລັດ';
$string['configcompletiondefault'] = 'ການຕັ້ງຄ່າເລີ່ມຕົ້ນສຳລັບການຕິດຕາມຄວາມສຳເລັດເມື່ອສ້າງກິດຈະກຳໃໝ່.';
$string['configenablecompletion'] = 'ຖ້າເປີດໃຊ້ງານ, ອາດຈະຕັ້ງເງື່ອນໄຂການສໍາເລັດລາຍວິຊາ ແລະ ກິດຈະກໍາ. ແນະນໍາໃຫ້ກໍານົດເງື່ອນໄຂການສໍາເລັດກິດຈະກໍາ ເພື່ອໃຫ້ຂໍ້ມູນທີ່ມີຄວາມໝາຍຖືກສະແດງໃຫ້ຜູ້ຊົມໃຊ້ເຫັນໄດ້ໃນຫຼັກສູດຂອງເຂົາເຈົ້າຢູ່ໃນແຜງໜ້າປັດ.';
$string['confirmselfcompletion'] = 'ຢືນຢັນການສໍາເລັດດ້ວຍຕົນເອງ';
$string['courseaggregation'] = 'ຕ້ອງການເງື່ອນໄຂ';
$string['courseaggregation_all'] = 'ທຸກວິຊາທີ່ເລືອກທີ່ຈະສຳເລັດ';
$string['courseaggregation_any'] = 'ວິຊາໃດໜຶ່ງທີ່ເລືອກທີ່ຈະສຳເລັດ';
$string['coursealreadycompleted'] = 'ທ່ານໄດ້ສຳເລັດຫຼັກສູດນີ້ແລ້ວ';
$string['coursecomplete'] = 'ສຳເລັດລາຍວິຊາ';
$string['coursecompleted'] = 'ສຳເລັດລາຍວິຊາແລ້ວ';
$string['coursecompletedmessage'] = '<p>ຂໍສະແດງຄວາມຍິນດີ!</p><p>ທ່ານໄດ້ສຳເລັດລາຍວິຊາ <a href="{$a->courselink}"> {$a->coursename}</a>.</p>';
$string['coursecompletion'] = 'ການສຳເລັດລາຍວິຊາ';
$string['coursecompletioncondition'] = 'ເງື່ອນໄຂ: {$a}';
$string['coursecompletionnavigation'] = 'ຈົບຫຼັກສູດການນຳທາງຂັ້ນສາມ';
$string['coursegrade'] = 'ຄະແນນລາຍວິຊາ';
$string['coursesavailable'] = 'ລາຍວິຊາທີ່ມີໃຫ້';
$string['coursesavailableexplaination'] = 'ໝາຍເຫດ: ເງື່ອນໄຂການສຳເລັດລາຍວິຊາຕ້ອງໄດ້ກໍານົດໄວ້ ເພື່ອໃຫ້ຫຼັກສູດປະກົດຂຶ້ນໃນລາຍການຂ້າງເທິງ.';
$string['criteria'] = 'ມາດຖານ';
$string['criteriagroup'] = 'ກຸ່ມມາດຖານ';
$string['criteriarequiredall'] = 'ມາດຖານທັງໝົດລຸ່ມນີ້ແມ່ນຈຳເປັນ';
$string['criteriarequiredany'] = 'ມາດຖານທັງໝົດລຸ່ມນີ້ແມ່ນຈຳເປັນ';
$string['csvdownload'] = 'ດາວໂຫລດໃນຮູບແບບສະເປຣດຊີດ (UTF-8 .csv)';
$string['datepassed'] = 'ວັນທີ່ຜ່ານ';
$string['days'] = 'ວັນ';
$string['daysoftotal'] = '{$a->days} ຈາກ {$a->total}';
$string['defaultcompletion'] = 'ການສໍາເລັດກິດຈະກໍາເລີ່ມຕົ້ນ';
$string['defaultcompletionupdated'] = 'ບັນທຶກການປ່ຽນແປງແລ້ວ';
$string['deletecompletiondata'] = 'ລຶບຂໍ້ມູນການສໍາເລັດ';
$string['dependencies'] = 'ການເພິ່ງພາອາໄສ';
$string['dependenciescompleted'] = 'ຮຽນຈົບວິຊາອື່ນໆ';
$string['detail_desc:receivegrade'] = 'ໄດ້ຮັບຄະແນນ';
$string['detail_desc:receivepassgrade'] = 'ໄດ້ຮັບຄະແນນຜ່ານ';
$string['detail_desc:view'] = 'ເບິ່ງ';
$string['done'] = 'ສຳເລັດ';
$string['editcoursecompletionsettings'] = 'ແກ້ໄຂການຕັ້ງຄ່າການສຳເລັດລາຍວິຊາ';
$string['enablecompletion'] = 'ເປີດນຳໃຊ້ການຕິດຕາມຄວາມສຳເລັດ';
$string['enablecompletion_help'] = 'ຖ້າເປີດໃຊ້ງານ, ອາດຈະກໍານົດເງື່ອນໄຂສໍາເລັດກິດຈະກໍາຢູ່ໃນການຕັ້ງຄ່າກິດຈະກໍາ ແລະ/ຫຼື ເງື່ອນໄຂສໍາເລັດລາຍວິຊາອາດຈະຖືກຕັ້ງ. ແນະນໍາໃຫ້ເປີດການໃຊ້ງານນີ້ ເພື່ອວ່າຂໍ້ມູນທີ່ມີຄວາມໝາຍຖືກສະແດງຢູ່ໃນພາບລວມຂອງລາຍວິຊາຢູ່ໃນແຜງໜ້າປັດ.';
$string['enrolmentduration'] = 'ໄລຍະເວລາການລົງທະບຽນ';
$string['enrolmentdurationlength'] = 'ຜູ້ໃຊ້ຕ້ອງໄດ້ສືບຕໍ່ລົງທະບຽນສໍາລັບ';
$string['err_noactivities'] = 'ຂໍ້ມູນການສຳເລັດບໍ່ໄດ້ຖືກເປີດນຳໃຊ້ສຳລັບກິດຈະກຳໃດໜຶ່ງ, ສະນັ້ນບໍ່ສາມາດສະແດງອັນໃດໄດ້. ທ່ານສາມາດເປີດນຳໃຊ້ຂໍ້ມູນການສຳເລັດໄດ້ໂດຍການແກ້ໄຂການຕັ້ງຄ່າສຳລັບກິດຈະກຳໃດໜຶ່ງ.';
$string['err_nocourses'] = 'ການສຳເລັດລາຍວິຊາບໍ່ໄດ້ຖືກເປີດໃຊ້ສໍາລັບວິຊາອື່ນ, ສະນັ້ນບໍ່ສາມາດສະແດງວິຊາໃດໄດ້. ທ່ານສາມາດເປີດໃຊ້ການສຳເລັດລາຍວິຊາໄດ້ໃນການຕັ້ງຄ່າລາຍວິຊາ.';
$string['err_nograde'] = 'ຄະແນນຜ່ານວິຊາບໍ່ໄດ້ຖືກກໍານົດໄວ້ສໍາລັບລາຍວິຊານີ້. ເພື່ອເປີດໃຊ້ປະເພດເກນນີ້ ທ່ານຕ້ອງສ້າງຄະແນນຜ່ານສໍາລັບລາຍວິຊານີ້.';
$string['err_noroles'] = 'ບໍ່ມີໜ້າທີ່ທີ່ມີຄວາມສາມາດ moodle/course:markcomplete ໃນລາຍວິຊານີ້.';
$string['err_nousers'] = 'ບໍ່ມີນັກຮຽນຢູ່ໃນລາຍວິຊານີ້ ຫຼື ກຸ່ມຄົນທີ່ຂໍ້ມູນການຮຽນຈົບໄດ້ຖືກສະແດງ. (ຂໍ້ມູນຄວາມສຳເລັດຈະສະແດງສະເພາະຜູ້ໃຊ້ທີ່ມີຄວາມສາມາດ \'ສະແດງໃນບົດລາຍງານການສຳເລັດ\'. ຄວາມສາມາດດັ່ງກ່າວແມ່ນອະນຸຍາດໃຫ້ມີໜ້າທີ່ເລີ່ມຕົ້ນຂອງນັກຮຽນເທົ່ານັ້ນ, ສະນັ້ນຖ້າບໍ່ມີນັກຮຽນ, ທ່ານຈະເຫັນຂໍ້ຄວາມນີ້.)';
$string['err_settingslocked'] = 'ນັກຮຽນໜຶ່ງຄົນ ຫຼື ຫຼາຍຄົນໄດ້ປະຕິບັດຄົບມາດຖານແລ້ວ ສະນັ້ນການຕັ້ງຄ່າໄດ້ຖືກລັອກໄວ້. ການປົດລັອກການຕັ້ງຄ່າມາດຕະຖານສໍາເລັດຈະລຶບທຸກຂໍ້ມູນຜູ້ໃຊ້ທີ່ມີຢູ່ແລ້ວ ແລະ ອາດຈະເຮັດໃຫ້ເກີດຄວາມສັບສົນ.';
$string['err_system'] = 'ເກີດຄວາມຜິດພາດພາຍໃນຂຶ້ນຢູ່ໃນລະບົບການສໍາເລັດ. (ຜູ້ບໍລິຫານລະບົບສາມາດເປີດໃຊ້ຂໍ້ມູນການດີບັກເພື່ອເບິ່ງລາຍລະອຽດເພີ່ມເຕີມ.)';
$string['eventcoursecompleted'] = 'ສຳເລັດລາຍວິຊາແລ້ວ';
$string['eventcoursecompletionupdated'] = 'ປັບປຸງລາຍວິຊາສຳເລັດແລ້ວ';
$string['eventcoursemodulecompletionupdated'] = 'ປັບປຸງການສຳເລັດກິດຈະກຳລາຍວິຊາແລ້ວ';
$string['eventdefaultcompletionupdated'] = 'ເລີ່ມຕົ້ນສໍາລັບການປັບປຸງການສໍາເລັດກິດຈະກໍາລາຍວິຊາ';
$string['excelcsvdownload'] = 'ດາວໂຫຼດໃນຮູບແບບທີ່ເຂົ້າກັນໄດ້ກັບ Excel (.csv)';
$string['failed'] = 'ລົ້ມເຫຼວ';
$string['fraction'] = 'ເສດສ່ວນ';
$string['graderequired'] = 'ຄະແນນລາຍວິຊາທີ່ຕ້ອງການ';
$string['gradexrequired'] = '{$a} ທີ່ຕ້ອງການ';
$string['hiddenrules'] = 'ບາງການຕັ້ງຄ່າສະເພາະກັບ <b>{$a}</b> ໄດ້ຖືກເຊື່ອງໄວ້. ເພື່ອເບິ່ງບໍ່ເລືອກກິດຈະກໍາອື່ນ';
$string['inprogress'] = 'ກຳລັງດຳເນີນງານຢູ່';
$string['manual'] = 'ດ້ວຍຕົວເອງ';
$string['manualcompletionby'] = 'ການສໍາເລັດດ້ວຍຕົນເອງໂດຍຜູ້ອື່ນ';
$string['manualcompletionbynote'] = 'ໝາຍເຫດ: ຄວາມສາມາດ moodle/course:markcomplete ຕ້ອງໄດ້ຮັບອະນຸຍາດໃຫ້ມີໜ້າທີ່ປາກົດຢູ່ໃນລາຍການ.';
$string['manualselfcompletion'] = 'ການເຮັດສຳເລັດດ້ວຍຕົນເອງ';
$string['manualselfcompletionnote'] = 'ໝາຍເຫດ: ກ່ອງການສຳເລັດດ້ວຍຕົນເອງຄວນເພີ່ມລາຍວິຊາໃສ່ ຖ້າເປີດໃຊ້ການສໍາເລັດດ້ວຍຕົນເອງ.';
$string['markcomplete'] = 'ໝາຍສຳເລັດ';
$string['markedcompleteby'] = 'ໝາຍສຳເລັດໂດຍ {$a}';
$string['markingyourselfcomplete'] = 'ໝາຍຕົວເອງວ່າສຳເລັດ';
$string['modifybulkactions'] = 'ແກ້ໄຂຄຳສັ່ງທີ່ທ່ານຕ້ອງການແກ້ໄຂເປັນຊຸດ';
$string['moredetails'] = 'ລາຍລະອຽດເພີ່ມເຕີມ';
$string['nocriteriaset'] = 'ບໍ່ມີມາດຖານການສຳເລັດສຳລັບລາຍວິຊານີ້';
$string['nogradeitem'] = 'ບໍ່ສາມາດເປີດໃຊ້ຄະແນນທີ່ຕ້ອງການສຳລັບ <b>{$a}</b> ໄດ້ເນື່ອງຈາກກິດຈະ ກຳບໍ່ໄດ້ໃຫ້ຄະແນນ.';
$string['notcompleted'] = 'ບໍ່ສຳເລັດ';
$string['notenroled'] = 'ທ່ານຍັງບໍ່ໄດ້ລົງທະບຽນໃນລາຍວິຊານີ້';
$string['nottracked'] = 'ປະຈຸບັນນີ້ທ່ານບໍ່ໄດ້ຖືກຕິດຕາມໂດຍການສຳເລັດໃນລາຍວິຊານີ້';
$string['notyetstarted'] = 'ຍັງບໍ່ໄດ້ເລີ່ມ';
$string['overallaggregation'] = 'ຂໍ້ກຳນົດການສຳເລັດ';
$string['overallaggregation_all'] = 'ລາຍວິຊາສຳເລັດເມື່ອທຸກເງື່ອນໄຂບັນລຸ';
$string['overallaggregation_any'] = 'ລາຍວິຊາສຳເລັດເມື່ອເງື່ອນໄຂໃດໜຶ່ງໄດ້ບັນລຸ';
$string['pending'] = 'ລໍຖ້າ';
$string['periodpostenrolment'] = 'ໄລຍະເວລາຫຼັງຈາກການລົງທະບຽນ';
$string['privacy:metadata:completionstate'] = 'ຖ້າກິດຈະກໍາດັ່ງກ່າວສໍາເລັດ';
$string['privacy:metadata:course'] = 'ຕົວລະບຸລາຍວິຊາ';
$string['privacy:metadata:coursecompletedsummary'] = 'ເກັບຮັກສາຂໍ້ມູນກ່ຽວກັບຜູ້ໃຊ້ຜູ້ທີ່ຜ່ານເກນເງື່ອນໄຂໃນລາຍວິຊາ';
$string['privacy:metadata:coursemoduleid'] = 'ລະຫັດປະຈຳຕົວກິດຈະກຳ';
$string['privacy:metadata:coursemodulesummary'] = 'ເກັບຮັກສາຂໍ້ມູນການສຳເລັດກິດຈະກຳໃຫ້ກັບຜູ້ໃຊ້';
$string['privacy:metadata:coursesummary'] = 'ເກັບຮັກສາຂໍ້ມູນການສຳເລັດລາຍວິຊາໃຫ້ກັບຜູ້ໃຊ້.';
$string['privacy:metadata:gradefinal'] = 'ໄດ້ຮັບຄະແນນສຸດທ້າຍສຳລັບການສຳເລັດລາຍວິຊາ';
$string['privacy:metadata:overrideby'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ຂອງບຸກຄົນຜູ້ທີ່ລົບລ້າງການສໍາເລັດກິດຈະກໍາ';
$string['privacy:metadata:reaggregate'] = 'ຖ້າການສຳເລັດລາຍວິຊາໄດ້ຖືກຮວບຮວມຄືນໃໝ່.';
$string['privacy:metadata:timecompleted'] = 'ເວລາທີ່ລາຍວິຊາດັ່ງກ່າວສຳເລັດ.';
$string['privacy:metadata:timeenrolled'] = 'ເວລາທີ່ຜູ້ໃຊ້ໄດ້ລົງທະບຽນເຂົ້າໃນລາຍວິຊາ';
$string['privacy:metadata:timemodified'] = 'ເວລາທີ່ການສໍາເລັດກິດຈະກໍາຖືກດັດແກ້';
$string['privacy:metadata:timestarted'] = 'ເວລາເລີ່ມລາຍວິຊາ.';
$string['privacy:metadata:unenroled'] = 'ຖ້າຜູ້ໃຊ້ໄດ້ຖືກຍົກເລີກການລົງທະບຽນຈາກລາຍວິຊາ';
$string['privacy:metadata:userid'] = 'ລະຫັດປະຈຳຕົວຜູ້ໃຊ້ຂອງບຸກຄົນທີ່ມີລາຍວິຊາ ແລະ ຂໍ້ມູນການສໍາເລັດກິດຈະກໍາ';
$string['privacy:metadata:viewed'] = 'ຖ້າໄດ້ເບິ່ງກິດຈະກໍາແລ້ວ';
$string['progress'] = 'ຄວາມຄືບໜ້າຂອງນັກຮຽນ';
$string['progress-title'] = '{$a->user}, {$a->activity}: {$a->state} {$a->date}';
$string['progresstotal'] = 'ຄວາມຄືບໜ້າ: {$a->complete} / {$a->total}';
$string['recognitionofpriorlearning'] = 'ການຮັບຮູ້ການຮຽນຮູ້ລ່ວງໜ້າ';
$string['remainingenroledfortime'] = 'ຍັງເຫຼືອການລົງທະບຽນສໍາລັບໄລຍະເວລາທີ່ກໍານົດໄວ້';
$string['remainingenroleduntildate'] = 'ຍັງເຫຼືອການລົງທະບຽນຈົນເຖິງວັນທີທີ່ລະບຸ';
$string['reportpage'] = 'ກຳລັງສະແດງຜູ້ໃຊ້ {$a->from} ຫາ {$a->to} ຈາກທັງໝົດ {$a->total}.';
$string['requiredcriteria'] = 'ເງື່ອນໄຂທີ່ຕ້ອງການ';
$string['resetactivities'] = 'ລຶບລ້າງທຸກກິດຈະກຳ ແລະ ແຫຼ່ງຂໍ້ມູນທີ່ໄດ້ກວດແລ້ວ';
$string['restoringcompletiondata'] = 'ກຳລັງຂຽນຂໍ້ມູນທີ່ສົມບູນ';
$string['roleaggregation'] = 'ຕ້ອງການເງື່ອນໄຂ';
$string['roleaggregation_all'] = 'ທັງໝົດໜ້າທີ່ທີ່ເລືອກເພື່ອໝາຍໃນເວລາເງື່ອນໄຂເປັນໄປຕາມທີ່ກຳນົດໄວ້';
$string['roleaggregation_any'] = 'ໜ້າທີ່ໃດໜຶ່ງທີ່ໄດ້ເລືອກເພື່ອໝາຍໃນເວລາເງື່ອນໄຂບັນລຸໄດ້';
$string['roleidnotfound'] = 'ບໍ່ພົບລະຫັດປະຈຳຕົວໜ້າທີ່ {$a}';
$string['saved'] = 'ບັນທຶກແລ້ວ';
$string['seedetails'] = 'ເບິ່ງລາຍລະອຽດ';
$string['select'] = 'ເລືອກ';
$string['self'] = 'ຕົວເອງ';
$string['selfcompletion'] = 'ການສຳເລັດດ້ວຍຕົວເອງ';
$string['showcompletionconditions'] = 'ສະແດງເງື່ອນໄຂການສໍາເລັດກິດຈະກໍາ';
$string['showcompletionconditions_help'] = 'ເງື່ອນໄຂການສໍາເລັດກິດຈະກໍາສະແດງໃຫ້ເຫັນຢູ່ໃນໜ້າກິດຈະກໍາສະເໝີ. ການຕັ້ງຄ່ານີ້ກໍານົດວ່າເງື່ອນໄຂການສໍາເລັດກິດຈະກໍາຍັງສະແດງຢູ່ຂ້າງລຸ່ມ ແຕ່ລະກິດຈະກໍາຢູ່ໃນ ໜ້າລາຍວິຊາ.';
$string['showinguser'] = 'ກຳລັງສະແດງຜູ້ໃຊ້';
$string['todo'] = 'ສິ່ງທີ່ຕ້ອງເຮັດ';
$string['unenrolingfromcourse'] = 'ຖອນການລົງທະບຽນຈາກລາຍວິຊາ';
$string['unenrolment'] = 'ຍົກເລີກການລົງທະບຽນ';
$string['unit'] = 'ໜ່ວຍງານ';
$string['unlockcompletion'] = 'ປົດລັອກຕົວເລືອກການສໍາເລັດ';
$string['unlockcompletiondelete'] = 'ປົດລັອກຕົວເລືອກການສໍາເລັດ ແລະ ລຶບຂໍ້ມູນການສໍາເລັດຂອງຜູ້ໃຊ້';
$string['updateactivities'] = 'ປັບປຸງສະຖານະການສໍາເລັດຂອງກິດຈະກໍາທີ່ກວດແລ້ວ';
$string['usealternateselector'] = 'ໃຊ້ຕົວເລືອກລາຍວິຊາສຳຮອງ';
$string['usernotenroled'] = 'ຜູ້ໃຊ້ບໍ່ໄດ້ລົງທະບຽນຢູ່ໃນລາຍວິຊານີ້';
$string['viewcoursereport'] = 'ເບິ່ງບົດລາຍງານລາຍວິຊາ';
$string['viewingactivity'] = 'ກຳລັງເບິ່ງ {$a}';
$string['withconditions'] = 'ດ້ວຍເງື່ອນໄຂ';
$string['writingcompletiondata'] = 'ການຂຽນຂໍ້ມູນການສໍາເລັດ';
$string['xdays'] = '{$a} ວັນ';
$string['yourprogress'] = 'ຄວາມຄືບໜ້າຂອງທ່ານ';
