<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'qtype_musictheory', language 'fr', version '4.1'.
 *
 * @package     qtype_musictheory
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abmajor'] = 'La&#9837; majeur';
$string['abminor'] = 'La&#9837; mineur';
$string['acc_b'] = '&#9837;';
$string['acc_bb'] = '♭♭';
$string['acc_n'] = '&#9838;';
$string['acc_sharp'] = '&#9839;';
$string['acc_x'] = 'x';
$string['alto'] = 'Clef d’ut (alto)';
$string['altoclef'] = 'Clef d’ut (alto)';
$string['anmajor'] = 'La majeur';
$string['anminor'] = 'La mineur';
$string['answerlbl'] = 'Réponse';
$string['asharpminor'] = 'La&#9839; mineur';
$string['aug10'] = 'Dixième augmentée';
$string['aug11'] = 'Onzième augmentée';
$string['aug12'] = 'Douzième augmentée';
$string['aug13'] = 'Treizième augmentée';
$string['aug2'] = 'Seconde augmentée';
$string['aug3'] = 'Tierce augmentée';
$string['aug4'] = 'Quarte augmentée';
$string['aug5'] = 'Quinte augmentée';
$string['aug6'] = 'Sixte augmentée';
$string['aug6thfr'] = 'Sixte française';
$string['aug6thgr'] = 'Sixte allemande';
$string['aug6thit'] = 'Sixte italienne';
$string['aug7'] = 'Septième augmentée';
$string['aug8'] = 'Octave augmentée';
$string['aug9'] = 'Neuvième augmentée';
$string['augmented'] = 'Augmenté(e)';
$string['bass'] = 'Clef de fa';
$string['bassclef'] = 'Clef de fa';
$string['bbmajor'] = 'Si&#9837; majeur';
$string['bbminor'] = 'Si&#9837; mineur';
$string['bnmajor'] = 'Si majeur';
$string['bnminor'] = 'Si mineur';
$string['cbmajor'] = 'Do&#9837; majeur';
$string['chordquality'] = 'Espèces d’accord';
$string['chordquality-random'] = 'Espèces d’accord possibles';
$string['chordquality_write_questionastext'] = 'Entrée de réponse d’espèce d’accord';
$string['chordquality_write_questionastext_help'] = '<p>Entrez les notes de l’accord, séparées par des
 virgules, sans espace. Utilisez la syntaxe suivante :</p>
 <p>[Nom de note en majuscule (do = \'C\', ré = \'D\', mi = \'E\', fa = \'F\', sol = \'G\', la = \'A\', si = \'B\')][Altération
 (bécarre = \'n\', dièse = \'#\', bémol = \'b\', double-dièse = \'x\', double-bémol = \'bb\')]4, etc. </p>
 <p>Exemple aléatoire : <b>réponse=>Cn4,En4,G#4</b></p>';
$string['chordquality_write_questionasui'] = 'Entrée de réponse réponse d’espèce d’accord';
$string['chordquality_write_questionasui_help'] = '<p>Entrez les notes de l’accord en cliquant sur la
 portée, après avoir sélectionné l’altération voulue avec la barre d’outils de droite. Pour
 effacer une note, cliquez sur celle-ci à nouveau.</p>';
$string['chordroot'] = 'Fondamentale';
$string['clef'] = 'Clef';
$string['clef-random'] = 'Clefs possibles';
$string['cnmajor'] = 'Do majeur';
$string['cnminor'] = 'Do mineur';
$string['considerregister'] = 'Inclure le registre';
$string['considerregister_help'] = 'Indique si le registre de la note devrait
être inclus dans la question.';
$string['correctansweris'] = 'La réponse correcte est:';
$string['correctansweris_morethanone'] = 'L’une des réponses correctes possibles est:';
$string['csharpmajor'] = 'Do&#9839; majeur';
$string['csharpminor'] = 'Do&#9839; mineur';
$string['dbmajor'] = 'Ré&#9837; majeur';
$string['dim10'] = 'Dixième diminuée';
$string['dim11'] = 'Onzième diminuée';
$string['dim12'] = 'Douzième diminuée';
$string['dim13'] = 'Treizième diminuée';
$string['dim2'] = 'Seconde diminuée';
$string['dim3'] = 'Tierce diminuée';
$string['dim4'] = 'Quarte diminuée';
$string['dim5'] = 'Quinte diminuée';
$string['dim6'] = 'Sixte diminuée';
$string['dim7'] = 'Septième diminuée';
$string['dim8'] = 'Octave diminuée';
$string['dim9'] = 'Neuvième diminuée';
$string['diminished'] = 'Diminué(e)';
$string['dirasc'] = 'Au-dessus de la note de départ';
$string['dirdesc'] = 'Au-dessous de la note de départ';
$string['direction'] = 'Direction';
$string['displaykeysignature'] = 'Afficher l’armature';
$string['dnmajor'] = 'Ré majeur';
$string['dnminor'] = 'Ré mineur';
$string['dsharpminor'] = 'Ré&#9839; mineur';
$string['ebmajor'] = 'Mi&#9837; majeur';
$string['ebminor'] = 'Mi&#9837; mineur';
$string['emptykeysignature'] = 'Armature vide';
$string['enmajor'] = 'Mi majeur';
$string['enminor'] = 'Mi mineur';
$string['fnmajor'] = 'Fa majeur';
$string['fnminor'] = 'Fa mineur';
$string['fsharpmajor'] = 'Fa&#9839; majeur';
$string['fsharpminor'] = 'Fa&#9839; mineur';
$string['gbmajor'] = 'Sol&#9837; majeur';
$string['givennoteelementgroup'] = 'Note de départ';
$string['gnmajor'] = 'Sol majeur';
$string['gnminor'] = 'Sol mineur';
$string['grandstaff'] = 'Système de portée (Clefs de sol et fa)';
$string['gsharpminor'] = 'Sol&#9839; mineur';
$string['harmonicfunction_write_questionastext'] = 'Entrée de réponse de fonction harmonique';
$string['harmonicfunction_write_questionastext_help'] = '<p>Entrez les notes de la fonction harmonique, séparées par des virgules, sans espace. Utilisez la syntaxe suivante :</p>
 <p>[Nom de note en majuscule (do = \'C\', ré = \'D\', mi = \'E\', fa = \'F\', sol = \'G\', la = \'A\', si = \'B\')][Altération
 (bécarre = \'n\', dièse = \'#\', bémol = \'b\', double-dièse = \'x\', double-bémol = \'bb\')]4, etc. </p>
 <p>Exemple aléatoire : <b>réponse=>Cn4,En4,G#4</b></p>';
$string['harmonicfunction_write_questionasui'] = 'Entrée de réponse de fonction harmonique';
$string['harmonicfunction_write_questionasui_help'] = '<p>Entrez les notes de la fonction harmonique en cliquant sur la
 portée, après avoir sélectionné l’altération voulue avec la barre d’outils de droite. Pour
 effacer une note, cliquez sur celle-ci à nouveau.</p>';
$string['harmonicfunctiontype-random'] = 'Fonctions harmoniques possibles';
$string['hfidentifyresponsetypes'] = 'Fonctions harmoniques possibles dans la réponse';
$string['hftype_aug6th'] = 'Sixte augmentée';
$string['hftype_diatonictriad'] = 'Triade diatonique';
$string['hftype_dom7th'] = 'Septième de dominante';
$string['hftype_extendeddom'] = 'Neuvième, onzième ou treizième de dominante';
$string['hftype_leadingtone7thfullydim'] = 'Septième diminuée';
$string['hftype_leadingtone7thhalfdim'] = 'Septième de sensible';
$string['hftype_neapolitan'] = 'Accord napolitain';
$string['hftype_nondom7th'] = 'Septième (excepté V)';
$string['hftype_secdom7th'] = 'Dominante secondaire (accord de septième)';
$string['hftype_secdomtriad'] = 'Dominante secondaire)';
$string['hftype_secltfullydim'] = 'Septième diminuée secondaire';
$string['hftype_seclthalfdim'] = 'Septième de sensible secondaire)';
$string['hftype_seclttriad'] = 'Accord de sensible secondaire (triade)';
$string['hftype_secnondom7th'] = 'Function secondaire, sauf V (accord de septième)';
$string['hftype_secnondomtriad'] = 'Function secondaire, sauf V (triade)';
$string['includealterations'] = 'Inclure les altérations';
$string['includealterations_help'] = 'Indique si les altérations devraient être
 inclues dans la question.';
$string['includestaticnote'] = 'Inclure une note fixe';
$string['interval_write_questionastext'] = 'Entrée de réponse d’intervalle';
$string['interval_write_questionastext_help'] = '<p>Entrez la note de réponse, sans espaces,
 en utilisant la syntaxe suivante:</p>
 <p>[Nom de note en majuscule (do = \'C\', ré = \'D\', mi = \'E\', fa = \'F\', sol = \'G\', la = \'A\', si = \'B\')]
 [Altération (bécarre = \'n\', dièse = \'#\', bémol = \'b\', double-dièse = \'x\', double-bémol = \'bb\')]
 [Registre (un chiffre entre 1 et 6, suivant la numérotation
 américaine, e.g. La 440Hz = 4)]</p><p>Exemples:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['interval_write_questionasui'] = 'Entrée de réponse d’intervalle';
$string['interval_write_questionasui_help'] = '<p>Entrez la note de réponse en cliquant sur la
 portée, après avoir sélectionné l’altération voulue avec la barre d’outils de droite. Pour
 effacer la note, cliquez sur celle-ci à nouveau.</p>';
$string['javascriptrequired'] = 'Ce texte est normalement remplacé par un interface
 graphique, qui requiert que Javascript sois activé dans votre navigateur.';
$string['keyboard_input_questionasui'] = 'Entrée de réponse au clavier';
$string['keyboard_input_questionasui_help'] = '<p>Entrez la note en cliquant sur le clavier. Pour
 effacer la note, cliquez sur celle-ci à nouveau.</p>';
$string['keymode'] = 'Tonalité';
$string['keysignature_write_questionastext'] = 'Entrée de réponse d’armature';
$string['keysignature_write_questionastext_help'] = '<p>Entrez une liste (entre 1 et 7)
 d’altérations séparées par des virgules, sans espace, en utilisant la syntaxe suivante :</p>
 <p>[Nom de note en majuscule (do = \'C\', ré = \'D\', mi = \'E\', fa = \'F\', sol = \'G\', la = \'A\', si = \'B\')]
 [Altération (dièse = \'#\', bémol = \'b\')] [Registre (un chiffre entre 2 et 5, suivant la numérotation
 américaine, e.g. La 440Hz = 4)], etc. </p><p>Exemple : <b>A#4,F#4,G#4</b></p>';
$string['keysignature_write_questionasui'] = 'Entrée de réponse d’armature';
$string['keysignature_write_questionasui_help'] = '<p>Entrez les altérations en cliquant sur la
  portée, après avoir sélectionné l’altération voulue avec la barre d’outils de droite. Pour
  effacer une altération, cliquez sur celle-ci à nouveau.</p>';
$string['lbl_harmonicfunction'] = 'Fonction harmonique';
$string['maj10'] = 'Dixième majeure';
$string['maj13'] = 'Treizième majeure';
$string['maj2'] = 'Seconde majeure';
$string['maj3'] = 'Tierce majeure';
$string['maj6'] = 'Sixte majeure';
$string['maj7'] = 'Septième majeure';
$string['maj9'] = 'Neuvième majeure';
$string['major'] = 'Majeur';
$string['min10'] = 'Dixième mineure';
$string['min13'] = 'Treizième mineure';
$string['min2'] = 'Seconde mineure';
$string['min3'] = 'Tierce mineure';
$string['min6'] = 'Sixte mineure';
$string['min7'] = 'Septième mineure';
$string['min9'] = 'Neuvième mineure';
$string['minor'] = 'Mineur';
$string['mode-random'] = 'Mode possibles';
$string['musicqtype'] = 'Type d’exercise';
$string['musictheory_gradingstrategy'] = 'Stragégie de correction';
$string['musictheory_gradingstrategy_help'] = '<p>La stratégie de correction indique comment
 la réponse sera corrigée.</p>
 <p><b>Tout ou rien</b>: La réponse est comparée à la solution. Si la réponse est correcte,
 une note parfaite est donnée. Si la réponse est incorrecte, une note de zéro est donnée.
 </p>';
$string['musictheory_gradingstrategy_scale-write'] = 'Stragégie de correction';
$string['musictheory_gradingstrategy_scale-write_help'] = '<p>La stratégie de correction indique comment
 la réponse sera corrigée.</p>
 <p><b>Tout ou rien</b>: La réponse est comparée à la solution. Si la réponse est correcte,
 une note parfaite est accordée. Si la réponse est incorrecte, une note de zéro est donnée.
 </p>
 <p><b>Crédit partiel pour chaque note de gamme correcte</b>:
 Cette stratégie de correction divise la note de question par le nombre de notes de gamme à
 entrer, et accorde une note partielle pour chaque note de gamme correcte.</p>';
$string['musictheory_intervalelementgroup'] = 'Intervalle';
$string['musictheory_intervalelementgroup_help'] = 'Indique le type d’intervalle.';
$string['musictheory_intervalelementgroup_random'] = 'Intervalles possibles';
$string['nosectonic'] = '[Pas de tonique secondaire]';
$string['note_write_questionastext'] = 'Entrée de réponse de note';
$string['note_write_questionastext_help'] = '<p>Entrez la note de réponse, sans espaces,
 en utilisant la syntaxe suivante:</p>
 <p>[Nom de note en majuscule (do = \'C\', ré = \'D\', mi = \'E\', fa = \'F\', sol = \'G\', la = \'A\', si = \'B\')]
 [Altération (bécarre = \'n\', dièse = \'#\', bémol = \'b\', double-dièse = \'x\', double-bémol = \'bb\')]
 [Registre (un chiffre entre 1 et 6, suivant la numérotation
 américaine, e.g. La 440Hz = 4)]</p><p>Exemples:
 </p><ul><li><b>Gn5</b></li><li><b>A#4</b></li><li><b>Ebb3</b></li></ul>';
$string['note_write_questionasui'] = 'Entrée de réponse de note';
$string['note_write_questionasui_help'] = '<p>Entrez la note de réponse en cliquant sur la
 portée, après avoir sélectionné l’altération voulue avec la barre d’outils de droite. Pour
 effacer la note, cliquez sur celle-ci à nouveau.</p>';
$string['notea'] = 'La';
$string['noteb'] = 'Si';
$string['notec'] = 'Do';
$string['noted'] = 'Ré';
$string['notee'] = 'Mi';
$string['notef'] = 'Fa';
$string['noteg'] = 'Sol';
$string['notelbl'] = 'Note';
$string['per11'] = 'Onzième parfaite';
$string['per12'] = 'Douzième parfaite';
$string['per4'] = 'Quarte parfaite';
$string['per5'] = 'Quinte parfaite';
$string['per8'] = 'Octave parfaite';
$string['perfect'] = 'Parfait';
$string['pluginname'] = 'Musique - Théorie';
$string['pluginname_help'] = 'Ce type de question permet la création de plusieurs
 exercises concernant la théorie de la musique, en utilisant un interface graphique.';
$string['pluginname_link'] = 'question/type/musictheory';
$string['pluginnameadding'] = 'Ajouter une question : Musique - Théorie';
$string['pluginnameediting'] = 'Configurer une question : Musique - Théorie';
$string['pluginnamesummary'] = 'Permet la création de plusieurs exercices concernant la théorie de la musique.';
$string['possiblescalesinresponse'] = 'Types de gamme possibles dans la réponse';
$string['privacy:metadata'] = 'Le plugin de type question de théorie musicale ne stocke aucune donnée personnelle.';
$string['qtype_chordquality-identify'] = 'Identifier une espèce d’accord';
$string['qtype_chordquality-identify-random'] = 'Identifier une espèce d’accord (aléatoire)';
$string['qtype_chordquality-write'] = 'Entrer une espèce d’accord';
$string['qtype_chordquality-write-random'] = 'Entrer une espèce d’accord (aléatoire)';
$string['qtype_harmonicfunction-identify'] = 'Identifier une fonction harmonique';
$string['qtype_harmonicfunction-identify-random'] = 'Identifier une fonction harmonique (aléatoire)';
$string['qtype_harmonicfunction-write'] = 'Entrer une function harmonique';
$string['qtype_harmonicfunction-write-random'] = 'Entrer une function harmonique (aléatoire)';
$string['qtype_interval-identify'] = 'Identifier un intervalle';
$string['qtype_interval-identify-random'] = 'Identifier un intervalle (aléatoire)';
$string['qtype_interval-write'] = 'Entrer un intervalle';
$string['qtype_interval-write-random'] = 'Entrer un intervalle (aléatoire)';
$string['qtype_keyboard-input'] = 'Entrer une note au clavier';
$string['qtype_keysignature-identify'] = 'Identifier une armature';
$string['qtype_keysignature-identify-random'] = 'Identifier une armature (aléatoire)';
$string['qtype_keysignature-write'] = 'Entrer une armature';
$string['qtype_keysignature-write-random'] = 'Entrer une armature (aléatoire)';
$string['qtype_musictheory_strategy_all_or_nothing'] = 'Tout ou rien';
$string['qtype_musictheory_strategy_chordqualitywrite_allornothing'] = 'Tout ou rien';
$string['qtype_musictheory_strategy_harmonicfunctionid_allornothing'] = 'Tout ou rien';
$string['qtype_musictheory_strategy_harmonicfunctionwrite_allornothing'] = 'Tout ou rien';
$string['qtype_musictheory_strategy_keyboard_allornothing'] = 'Tout ou rien';
$string['qtype_musictheory_strategy_note_allornothing'] = 'Tout ou rien';
$string['qtype_musictheory_strategy_scale_creditbynote'] = 'Crédit partiel pour chaque note de gamme correcte';
$string['qtype_note-identify'] = 'Identifier une note';
$string['qtype_note-identify-random'] = 'Identifier une note (aléatoire)';
$string['qtype_note-write'] = 'Entrer une note';
$string['qtype_note-write-random'] = 'Entrer une note (aléatoire)';
$string['qtype_scale-identify'] = 'Identifier une gamme';
$string['qtype_scale-identify-random'] = 'Identifier une gamme (aléatoire)';
$string['qtype_scale-write'] = 'Entrer une gamme';
$string['qtype_scale-write-random'] = 'Entrer une gamme (aléatoire)';
$string['quality-random'] = 'Qualiticatifs possibles';
$string['qualityaug'] = 'Augmenté(e)';
$string['qualitydim'] = 'Diminué(e)';
$string['qualitymaj'] = 'Majeur';
$string['qualitymin'] = 'Mineur';
$string['qualityper'] = 'Parfait';
$string['questionoptions'] = 'Options de la question';
$string['questiontext'] = 'Texte de la question';
$string['questiontext_chordquality_identify'] = 'Identifiez la note fondamentale et l’espèce de l’accord suivant';
$string['questiontext_chordquality_write'] = 'Entrez l’accord suivant';
$string['questiontext_harmonicfunction_identify'] = 'Identifiez la fonction harmonique suivante';
$string['questiontext_harmonicfunction_write'] = 'Entrez la fonction harmonique suivante';
$string['questiontext_help'] = 'Ce champ n’est pas requis. Si vous le laissez vide, un texte
 pour cette question sera généré automatiquement. Si vous entrez du texte dans ce champ,
 ce texte replacera celui généré automatiquement.';
$string['questiontext_interval_identify'] = 'Identifiez l’intervalle suivant';
$string['questiontext_interval_write_above'] = 'Entrez l’intervalle suivant <b>au-dessus</b> de la note de départ';
$string['questiontext_interval_write_below'] = 'Entrez l’intervalle suivant <b>au-dessous</b> de la note de départ';
$string['questiontext_keyboard_input'] = 'Entrez la note suivante au clavier';
$string['questiontext_keysignature_identify_major'] = 'Déterminez la tonalité majeure
 représentée par l’armature suivante';
$string['questiontext_keysignature_identify_minor'] = 'Déterminez la tonalité mineure
 représentée par l’armature suivante';
$string['questiontext_keysignature_write'] = 'Entrez l’armature suivante';
$string['questiontext_note_identify'] = 'Identifiez la note suivante';
$string['questiontext_note_write'] = 'Entrez la note suivante';
$string['questiontext_scale_identify'] = 'Identifiez la gamme suivante';
$string['questiontext_scale_write'] = 'Entrez la gamme suivante en direction ascendante';
$string['questiontext_scale_write_melodic'] = 'Entrez la gamme suivante en direction
ascendante et descendante';
$string['rootposition'] = '[Position fondamentale]';
$string['scale_write_questionastext'] = 'Entrée de réponse de gamme';
$string['scale_write_questionastext_help'] = '<p>Entrez les notes de la gamme, séparées par des
 virgules, sans espace, et en incluant la tonique déjà affichée. Utilisez la syntaxe suivante :</p>
 <p>[Nom de note en majuscule (do = \'C\', ré = \'D\', mi = \'E\', fa = \'F\', sol = \'G\', la = \'A\', si = \'B\')]
 [Altération (bécarre = \'n\', dièse = \'#\', bémol = \'b\', double-dièse = \'x\', double-bémol = \'bb\')]
 [Registre (un chiffre entre 2 et 6, suivant la numérotation
 américaine, e.g. La 440Hz = 4)], etc. </p>
 <p>Exemple aléatoire : <b>Tonique = An4, réponse=>An4,Bb4,C#5,D#5,E#5,F#5,G#5,An5</b></p>';
$string['scale_write_questionasui'] = 'Entrée de réponse de gamme';
$string['scale_write_questionasui_help'] = '<p>Entrez les notes de la gamme en cliquant sur la
 portée, après avoir sélectionné l’altération voulue avec la barre d’outils de droite. Pour
 effacer une note, cliquez sur celle-ci à nouveau.</p>
 <p>Prenez note que les altérations demeurent en effet jusqu’à la fin de la portée.</p>';
$string['scaletype'] = 'Type de gamme';
$string['scaletype-random'] = 'Types de gamme possibles dans la réponse';
$string['scaletype_harmonic'] = 'mineur, harmonique';
$string['scaletype_major'] = 'majeur';
$string['scaletype_melodic'] = 'mineur, mélodique';
$string['scaletype_natural'] = 'mineur, naturelle';
$string['selectakey'] = 'Sélectionnez une tonalité';
$string['selectanoption'] = 'Sélectionnez';
$string['selectaquality'] = 'Sélectionnez un qualificatif';
$string['selectasize'] = 'Sélectionnez un nom';
$string['size-random'] = 'Noms possibles';
$string['size10'] = 'Dixième';
$string['size11'] = 'Onzième';
$string['size12'] = 'Douzième';
$string['size13'] = 'Treizième';
$string['size2'] = 'Seconde';
$string['size3'] = 'Tierce';
$string['size4'] = 'Quarte';
$string['size5'] = 'Quinte';
$string['size6'] = 'Sixte';
$string['size7'] = 'Septième';
$string['size8'] = 'Octave';
$string['size9'] = 'Neuvième';
$string['tenor'] = 'Clef d’ut (ténor)';
$string['tenorclef'] = 'Clef d’ut (ténor)';
$string['tonic'] = 'Tonique';
$string['treble'] = 'Clef de sol';
$string['trebleclef'] = 'Clef de sol';
$string['updatemusicqtype'] = 'Mettre les options à jour';
$string['validation_harmonicfunctionnotsupported'] = 'Cette fonction harmonique n’est pas supportée ou est non valide.';
$string['validation_harmonicfunctiontypenotselected'] = 'Le type de fonction correspondant à la fonction harmonique spécifée doit être sélectionné.';
$string['validation_interval_novalidcombo'] = 'Les options d’intervalles possibles sélectionnées
 ne produisent pas au moins un type d’interval valide.';
$string['validation_intervaloutsidestaff'] = 'Le registre de la note de départ produit un
 intervalle qui en dehors de la portée avec la clef indiquée.';
$string['validation_invalidchordquality'] = 'Cette espèce d’accord ne peut pas être construit sur cette fondamentale.';
$string['validation_invalidinterval_above'] = 'Cet intervalle ne peut être écrit au-dessus de la note de départ.';
$string['validation_invalidinterval_below'] = 'Cet intervalle ne peut être écrit au-dessous de la note de départ.';
$string['validation_noteoutsidekeyboard'] = 'Cette note est hors des limites du clavier.';
$string['validation_noteoutsidestaff'] = 'Le registre de cette note se situe en
 dehors de la portée avec la clef indiquée.';
$string['validation_possiblescaletypenotselected'] = 'Le type de gamme correspondant au type de gamme spécifé doit être sélectionné.';
$string['validation_possiblescaletypesnotselected_random'] = 'Les types de gamme possibles dans la réponse
 doivent inclure tous les types de gamme possibles';
$string['validation_qualitymismatch'] = 'Cette combinaison de nom d’intervalle et de qualificatif est non valide.';
$string['validation_samestaticandgivennote'] = 'La note de départ et la réponse ne peuvent pas correspondre à la même touche
 sur le clavier.';
$string['validation_scale_invalidtonic'] = 'Tonique non valide pour le type de gamme sélectionné.';
$string['validation_scaleoutsidestaff'] = 'Le registre de la note de départ produit une gamme
 qui en dehors de la portée avec la clef indiquée';
$string['validationerror_chordquality_identify'] = 'Réponse incomplète. Il faut sélectionner la note fondamentale et son altération, ainsi que l’espèce d’accord.';
$string['validationerror_empty'] = 'Veuillez entrer une réponse.';
$string['validationerror_harmonicfunction_identify'] = 'Réponse incomplète. Tous les menus déroulants doivent être sélectionnés.';
$string['validationerror_incompletechordquality'] = 'Réponse incomplète. Nombre de notes dans cet accord';
$string['validationerror_incompleteharmonicfunction'] = 'Réponse incomplète. Nombre de notes dans cette fonction harmonique';
$string['validationerror_interval_identify'] = 'Réponse incomplète. Il faut sélectionner un
 nom d’intervalle et un qualiticatif d’interval.';
$string['validationerror_invalidsyntax'] = 'Syntaxe de réponse non valide.';
$string['validationerror_note_identify'] = 'Réponse incomplète. Il faut sélectionner le
 nom de la note, l’altération et le registre.';
$string['validationerror_note_identify_ltr_acc'] = 'Réponse incomplète. Il faut sélectionner le
 nom de la note et l’altération.';
$string['validationerror_note_identify_ltr_reg'] = 'Réponse incomplète. Il faut sélectionner le
 nom de la note et le registre.';
$string['validationerror_notewrite_twonotesingrandstaff'] = 'Deux notes ont été entrées. Il ne faut entrer qu’une seule note.';
$string['validationerror_scale_identify'] = 'Réponse incomplète. Tous les menus déroulants doivent être sélectionnés.';
$string['validationerror_scale_incomplete'] = 'Réponse incomplète. Il faut entrer une total de
 8 notes, incluant la tonique fournie.';
$string['validationerror_scale_incomplete_melodic'] = 'Réponse incomplète. Il faut entrer une total de
 15 notes, incluant la tonique fournie.';
$string['validationerror_whitespace'] = 'Syntaxe de réponse non valide: veuillez enlever tous les
 espaces dans votre réponse.';
