<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_program', language 'id', version '4.1'.
 *
 * @package     tool_program
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutthefile'] = 'Tentang berkas';
$string['action'] = 'Tindakan';
$string['actions'] = 'Tindakan';
$string['active'] = 'Aktif';
$string['activeprograms'] = 'Program aktif';
$string['activeprogramslink'] = '<a href="{$a->href}">{$a->count} program aktif</a>';
$string['addcourses'] = 'Tambahkan kursus';
$string['addcourseslist'] = 'Pilih kursus';
$string['addcourseslist_help'] = 'Satu atau lebih kursus dapat dipilih.';
$string['addset'] = 'Tambahkan set';
$string['addsetorcourse'] = 'Tambahkan set atau kursus';
$string['afterallocationwindowstarts'] = 'Setelah alokasi dimulai';
$string['afterallocationwindowstartswithrelativedate'] = '{$a} setelah alokasi dimulai';
$string['afterduedate'] = 'Setelah tanggal jatuh tempo';
$string['afterduedatewithrelativedate'] = '{$a} setelah tanggal jatuh tempo';
$string['afterstartdate'] = 'Setelah tanggal mulai';
$string['afterstartdatewithrelativedate'] = '{$a} setelah tanggal mulai';
$string['afteruserallocationdate'] = 'Setelah tanggal alokasi pengguna';
$string['afteruserallocationdatewithrelativedate'] = '{$a} setelah tanggal alokasi pengguna';
$string['allinanyorder'] = 'Semua dalam urutan apa pun';
$string['allinorder'] = 'Semua dalam urutan';
$string['allocatetoprogram'] = 'Alokasikan ke program';
$string['allocateusers'] = 'Alokasikan pengguna';
$string['allocationdate'] = 'Tanggal alokasi';
$string['allocationdateonorafter'] = 'Tanggal alokasi pada atau setelah';
$string['allocationenddate'] = 'Tanggal akhir alokasi';
$string['allocationenddate_help'] = 'Tanggal akhir untuk mengalokasikan pengguna ke program ini';
$string['allocationfor'] = 'Alokasi untuk \'{$a}\'';
$string['allocationsource'] = 'Sumber alokasi';
$string['allocationstartdate'] = 'Tanggal mulai alokasi';
$string['allocationstartdate_help'] = 'Tanggal mulai untuk mengalokasikan pengguna ke program ini';
$string['allocationwindow'] = 'Jendela alokasi';
$string['allocationwindowendedon'] = 'Jendela alokasi untuk program ini berakhir pada {$a}.';
$string['allocationwindowstartson'] = 'Jendela alokasi untuk program ini dimulai pada {$a}.';
$string['allowdirectallocation'] = 'Izinkan alokasi langsung';
$string['allowdirectallocation_help'] = 'Memungkinkan alokasi langsung pengguna ke dalam program ini';
$string['archive'] = 'Arsip';
$string['archived'] = 'Diarsip';
$string['archivedconfirmation'] = 'Apakah Anda yakin ingin mengarsip program \'{$a}\'? Program yang diarsip tidak akan tersedia lagi bagi manajer atau peserta didik dan hanya dapat dilihat dalam laporan historis.';
$string['archivedon'] = 'Diarsip pada';
$string['archivedprograms'] = 'Program yang diarsip';
$string['assfirstchildof'] = 'Sebagai anak pertama dari "{$a}"';
$string['associatedcertification'] = 'Sertifikasi terasosiasi';
$string['associatedcertifications'] = 'Sertifikasi terasosiasi';
$string['associatedcertificationswitheditlinks'] = 'Sertifikasi terasosiasi dengan tautan untuk sunting';
$string['atleast'] = 'Setidaknya';
$string['autocreategroups'] = 'Tambahkan ke grup kursus';
$string['autocreategroups_help'] = 'Saat pengguna terdaftar dalam program kursus, mereka dapat secara otomatis ditambahkan ke grup yang sama. Grup dengan nama yang sama dengan program akan dibuat secara otomatis di setiap kursus. Untuk kursus yang dibagi antara penyewa, nama penyewa juga akan ditambahkan ke nama grup.';
$string['autocreategroupsnone'] = 'Tidak';
$string['autocreategroupsprogram'] = 'Buat grup untuk program ini';
$string['availability'] = 'Ketersediaan';
$string['available'] = 'Tersedia';
$string['baseset'] = 'Set dasar';
$string['beforeenddate'] = 'Sebelum tanggal akhir';
$string['beforeenddatewithrelativedate'] = '{$a} sebelum tanggal akhir';
$string['calendar'] = 'Jadwal';
$string['calendarduedate'] = 'Tanggal jatuh tempo untuk program {$a}';
$string['calendarenddate'] = 'Tanggal akhir untuk program {$a}';
$string['certification'] = 'Sertifikasi';
$string['certificationduedate'] = 'Tanggal jatuh tempo sertifikasi';
$string['certificationmsgactive'] = 'Sertifikasi <strong>"{$a->fullname}"</strong> harus diselesaikan pada <strong>{$a->date}</strong>';
$string['certificationmsgcompleted'] = 'Sertifikasi <strong>"{$a->fullname}"</strong> selesai';
$string['certificationmsgcompletedexpired'] = 'Sertifikasi <strong>"{$a->fullname}"</strong> selesai. Masa berlakunya akan habis pada
<strong>{$a->date</strong>';
$string['certificationmsgduedatenotset'] = 'Sertifikasi <strong>"{$a->fullname}"</strong> belum menetapkan tanggal jatuh tempo';
$string['certificationmsgexpired'] = 'Sertifikasi <strong>"{$a->fullname}"</strong> habis masa berlakunya pada <strong>{$a->date</strong>';
$string['certificationmsgoverdue'] = 'Sertifikasi <strong>"{$a->fullname}"</strong> jatuh tempo pada <strong>{$a->date}</strong>';
$string['certifications'] = 'Sertifikasi';
$string['close'] = 'Tutup';
$string['completeallinanyorder'] = 'Selesaikan semua dalam urutan apa pun';
$string['completeallinorder'] = 'Selesaikan semua dalam urutan';
$string['completeatleast'] = 'Selesaikan setidaknya';
$string['completed'] = 'Selesai';
$string['completedprogramslink'] = '<a href="{$a->href}">{$a->count} program yang telah selesai</a>';
$string['completion'] = 'Penyelesaian';
$string['completion_help'] = 'Jenis penyelesaian yang akan diterapkan pada set:

* <strong>Semua dalam urutan:</strong> Pengguna harus menyelesaikan semua kursus dalam urutan yang ditentukan
* <strong>Semua dalam urutan apa pun:</strong> Pengguna harus menyelesaikan semua kursus dalam urutan apa pun
* <strong>Setidaknya X:</strong> Pengguna harus menyelesaikan setidaknya sejumlah kursus yang ditentukan dalam urutan apa pun';
$string['completionatleast'] = 'Penyelesaian setidaknya';
$string['completioncriteria'] = 'Kriteria penyelesaian';
$string['completioncriteriagroup'] = 'Penyelesaian';
$string['completioncriteriagroup_help'] = 'Silakan pilih kriteria penyelesaian untuk set khusus ini';
$string['completiondate'] = 'Tanggal penyelesaian';
$string['completiondateonorafter'] = 'Tanggal penyelesaian pada atau setelah';
$string['conditionprogramcompleted'] = 'Program selesai';
$string['conditionprogramcompletedalldescription'] = 'Pengguna yang berstatus \'Selesai\' di semua program berikut: \'{$a->programname}\'';
$string['conditionprogramcompletedalldescriptionwithdate'] = 'Pengguna yang berstatus \'Selesai\' di semua program berikut: \'{$a->programname}\'<br />
Tanggal penyelesaian pada atau setelah \'{$a->conditiondate}\'';
$string['conditionprogramcompletedanydescription'] = 'Pengguna yang berstatus \'Selesai\' di setidaknya salah satu program berikut: \'{$a->programname}\'';
$string['conditionprogramcompletedanydescriptionwithdate'] = 'Pengguna yang berstatus \'Selesai\' di setidaknya salah satu program berikut: \'{$a->programname}\'<br />
Tanggal penyelesaian adalah pada atau setelah \'{$a->conditiondate}\'';
$string['conditionprogramcompleteddescription'] = 'Pengguna yang berstatus \'Selesai\' dalam program \'{$a}\'';
$string['conditionprogramcompleteddescriptionwithdate'] = 'Pengguna yang berstatus \'Selesai\' dalam program \'{$a->programname}\'<br />
Tanggal penyelesaian pada atau setelah \'{$a->conditiondate}\'';
$string['conditionprogramnotcompleted'] = 'Program belum selesai';
$string['conditionprogramnotcompleteddescription'] = 'Pengguna yang tidak memiliki status \'Selesai\' dalam program \'{$a}\'';
$string['conditionprogramoverdue'] = 'Program terlambat';
$string['conditionprogramoverduedescription'] = 'Pengguna yang berstatus \'Terlambat\' dalam program \'{$a}\'';
$string['conditionprogramoverduedescriptionwithdate'] = 'Pengguna yang berstatus \'Terlambat\' dalam program \'{$a->programname}\'<br />
Tanggal jatuh tempo pada atau setelah \'{$a->conditiondate}\'';
$string['conditionprogramsuspended'] = 'Program ditangguhkan';
$string['conditionprogramsuspendeddescription'] = 'Pengguna yang berstatus \'Ditangguhkan\' dalam program \'{$a}\'';
$string['conditionprogramsuspendeddescriptionwithdate'] = 'Pengguna yang berstatus \'Ditangguhkan\' dalam program \'{$a->programname}\'<br />
Tanggal penangguhan pada atau setelah \'{$a->conditiondate}\'';
$string['conditionuserallocated'] = 'Pengguna dialokasikan untuk program';
$string['conditionuserallocateddescription'] = 'Pengguna dialokasikan untuk program \'{$a}\'';
$string['conditionuserallocateddescriptionwithdate'] = 'Pengguna yang dialokasikan untuk program \'{$a->programname}\'<br />
Tanggal alokasi adalah pada atau setelah \'{$a->conditiondate}\'';
$string['conditionusernotallocated'] = 'Pengguna tidak dialokasikan ke program';
$string['conditionusernotallocateddescription'] = 'Pengguna tidak dialokasikan ke program \'{$a}\'';
$string['confirmdeallocateusers'] = 'Tindakan ini akan menghapus alokasi dan data terkait untuk semua pengguna yang dipilih. Tindakan ini tidak dapat dibatalkan.';
$string['confirmdeallocateusersheader'] = 'De-alokasi pengguna';
$string['confirmdeletecourse'] = 'Apakah Anda yakin ingin menghapus kursus \'{$a}\' dari program?';
$string['confirmdeleteprogram'] = 'Apakah Anda yakin ingin menghapus program \'{$a}\' dan semua data terasosiasi? Tindakan ini tidak dapat dibatalkan.';
$string['confirmdeleteset'] = 'Apakah Anda yakin ingin menghapus set \'{$a}\' dan menghapus kursus apa pun di dalamnya?';
$string['confirmdeleteuserallocation'] = 'Apakah Anda yakin ingin menghapus alokasi pengguna \'{$a}\' dan data terasosiasi secara menyeluruh? Tindakan ini tidak dapat dibatalkan.';
$string['confirmduplicate'] = 'Salinan akan dibuat, termasuk konten dan jadwal program, tetapi tidak termasuk pengguna. Kolom nomor ID program akan dihapus.';
$string['confirmrecalculateprogress'] = 'Biasanya jika pengaturan program diubah setelah beberapa siswa telah menyelesaikan program, program mereka tetap dalam status \'Selesai\' meskipun mereka tidak lagi memenuhi persyaratan penyelesaian. Tindakan ini memungkinkan Anda untuk mengatur ulang dan menghitung ulang penyelesaian program. Ini tidak akan memengaruhi kursus program atau sertifikasi tertaut.
<br />Tindakan ini tidak dapat dibatalkan. Apakah Anda yakin ingin melanjutkan?';
$string['confirmresetprogress'] = 'Apakah Anda yakin ingin mengatur ulang kemajuan \'{$a}\'? Tindakan ini akan:<br /><br />
<ul>
<li>mengatur ulang program</li>
<li>mengatur ulang semua kursus dalam program ini</li>
<li>menghapus semua data penyelesaian</li>
</ul>
Tindakan ini mungkin memerlukan waktu beberapa menit untuk diselesaikan dan tidak dapat dibatalkan.';
$string['confirmresetusersprogramusers'] = 'Untuk semua pengguna yang dipilih, tindakan ini akan:<br /><br />
<ul>
<li>mengatur ulang program</li>
<li>mengatur ulang semua kursus dalam program ini</li>
<li>menghapus semua data penyelesaian</li>
</ul>
Tindakan ini mungkin memerlukan waktu beberapa menit untuk diselesaikan dan tidak dapat dibatalkan.';
$string['containscourse'] = 'Berisi kursus';
$string['content'] = 'Konten';
$string['copy'] = 'Salin';
$string['course'] = 'Kursus';
$string['coursealreadyinset'] = 'Kursus sudah ada di set ini';
$string['coursecompletiondisabled'] = 'Pelacakan penyelesaian untuk kursus ini tidak diaktifkan. Pembelajar akan melihatnya sebagai belum selesai di dasbor mereka dan mungkin tidak dapat menyelesaikan program.';
$string['coursecriteriadisabled'] = 'Pelacakan penyelesaian untuk kursus ini diaktifkan, tetapi tidak ada kriteria yang dikonfigurasi.';
$string['courseinformation'] = 'Informasi kursus';
$string['coursenotavailable'] = 'Kursus tidak tersedia';
$string['coursesinset'] = 'Kursus dalam set (dipisahkan koma)';
$string['coursesinsetlines'] = 'Kursus dalam set (satu per baris)';
$string['coursesinsetlineslinks'] = 'Kursus dalam set dengan tautan (satu per baris)';
$string['coursesinsetlinks'] = 'Kursus dalam set dengan tautan (dipisahkan koma)';
$string['criteriaall'] = 'Semua program yang dipilih telah diselesaikan';
$string['criteriaany'] = 'Setidaknya salah satu program yang dipilih telah selesai';
$string['criteriaany_help'] = 'Ketika pengguna telah menyelesaikan satu program, menyelesaikan program kedua tidak akan memicu tindakan lagi';
$string['criteriaeach'] = 'Setiap kali pengguna menyelesaikan salah satu program yang dipilih';
$string['criteriaeach_help'] = 'Setara dengan membuat beberapa aturan, satu untuk setiap program yang dipilih';
$string['dateoverriden'] = 'Tanggal ditimpa';
$string['datetypeabsolute'] = 'Pilih tanggal';
$string['datetypenone'] = 'Belum diatur';
$string['dayssinceallocation'] = 'Hari sejak alokasi';
$string['daystakingprogram'] = 'Hari pengambilan program';
$string['deallocateusers'] = 'De-alokasi pengguna';
$string['default'] = 'Bawaan';
$string['deleteallocation'] = 'Hapus alokasi';
$string['deleteuserallocation'] = 'Hapus alokasi pengguna';
$string['description'] = 'Deskripsi';
$string['directallocationdisabled'] = 'Alokasi langsung ke program ini dinonaktifkan';
$string['displaycompletedcourses'] = 'Kursus yang diselesaikan dalam program';
$string['displaycompletiondate'] = 'Tanggal penyelesaian program';
$string['displayprogramduedate'] = 'Tanggal jatuh tempo program';
$string['displayprogramid'] = 'ID program internal yang digunakan dalam URL';
$string['displayprogramname'] = 'Nama program';
$string['dontchange'] = 'Jangan ubah';
$string['duedate'] = 'Jatuh tempo';
$string['duedate_help'] = 'Tanggal jatuh tempo untuk program ini';
$string['duedateonorafter'] = 'Tanggal jatuh tempo pada atau setelah';
$string['duplicate'] = 'Duplikat';
$string['dynamic'] = 'Dinamis';
$string['dynamicrules'] = 'Aturan dinamis';
$string['dynamicrulesplugincheck'] = 'Melihat daftar aturan dinamis tidak mungkin dilakukan tanpa pengaya tool_dynamicrule';
$string['dynamicrulewarningdeallocation'] = 'Pengguna hanya dapat dibatalkan alokasinya jika mereka dialokasikan oleh aturan dinamis lainnya, alokasi manual tidak akan terpengaruh.';
$string['editallocation'] = 'Sunting alokasi';
$string['editprogramname'] = 'Sunting nama program';
$string['editsetname'] = 'Sunting nama set';
$string['editstatusanddates'] = 'Sunting status dan tanggal';
$string['editstatusanddatesbulk'] = 'Sunting status dan tanggal untuk beberapa pengguna';
$string['enddate'] = 'Tanggal akhir';
$string['enddate_help'] = 'Edit status dan tanggal untuk program ini';
$string['enrol'] = 'Daftar';
$string['enrolled'] = 'Terdaftar';
$string['entityprogram'] = 'Program';
$string['entityprogramcompletion'] = 'Penyelesaian pengguna';
$string['entityprogramcontent'] = 'Konten program';
$string['entityprogramitem'] = 'Item program';
$string['entityprogramusers'] = 'Alokasi pengguna';
$string['errorallocationenddatenostartdate'] = 'Tanggal akhir alokasi tidak dapat berupa tanggal relatif jika tanggal awal alokasi tidak ditetapkan';
$string['errorallocationenddatepreviousstartdate'] = 'Tanggal akhir alokasi tidak boleh sebelum tanggal awal alokasi';
$string['errorbasesetnotfound'] = 'Set dasar tidak ditemukan';
$string['errorcannotallocate'] = 'Tidak dapat mengalokasikan pengguna ke suatu program (alokasi sudah ada atau tidak diizinkan)';
$string['errorcannotresetprogram'] = 'Tidak dapat mengatur ulang program';
$string['errorcantallocateusers'] = 'Tidak dapat mengalokasi pengguna';
$string['errorcantcreateset'] = 'Tidak dapat membuat set';
$string['errorcantdeletenotarchivedprogram'] = 'Tidak dapat menghapus program yang tidak diarsip';
$string['errorcantselfenrol'] = 'Tidak dapat mendaftar sendiri';
$string['errorcertificationnotfound'] = 'Sertifikasi tidak ditemukan';
$string['errorcouldnotallocate'] = 'Tidak dapat mengalokasikan pengguna \'{$a->originaluserfullname}\' ke program \'{$a->program}\'';
$string['errorduedatepreviousstartdate'] = 'Tanggal jatuh tempo tidak boleh sebelum tanggal mulai';
$string['errorenddatepreviousduedate'] = 'Tanggal akhir tidak boleh sebelum tanggal jatuh tempo';
$string['errorenddatepreviousstartdate'] = 'Tanggal akhir tidak boleh sebelum tanggal mulai';
$string['errorhelperactionnotallowed'] = 'Tindakan pembantu tidak diizinkan';
$string['erroridnumberuniquetenant'] = 'Nomor ID ini sudah digunakan di program lain';
$string['errorinvaliddate'] = 'Tanggal tidak valid';
$string['errorinvalidprogram'] = 'Program tidak valid';
$string['errorinvalidprogramitemmove'] = 'Pemindahan item program tidak valid';
$string['errorloadingprogram_mobile'] = 'Galat saat memuat program';
$string['errormissingenrolprogramplugin'] = 'Pengaya pendaftaran program tidak ada';
$string['errornopermissionallocateusers'] = 'Tidak ada izin untuk mengalokasikan pengguna ke program';
$string['errornopermissionmanageprograms'] = 'Tidak ada izin untuk mengelola program';
$string['errornopermissionmanageusers'] = 'Tidak ada izin untuk mengelola pengguna';
$string['errornopermissionviewallocatedusers'] = 'Tidak ada izin untuk melihat pengguna yang dialokasikan dalam program';
$string['errornopermissionviewprograms'] = 'Tidak ada izin untuk melihat program';
$string['errornopermissionviewreports'] = 'Tidak ada izin untuk melihat laporan';
$string['errornostudentsrolefound'] = 'Tidak ada peran siswa yang ditemukan';
$string['errornothingtoexportforprograms'] = 'Tidak ada yang perlu diekspor untuk program bersama: {$a}';
$string['errorprogramnotfound'] = 'Program tidak ditemukan';
$string['errorreporttypedoesnotexist'] = 'Tipe laporan tidak ada';
$string['errorsameidnumber'] = 'Program dengan nomor ID yang sama sudah ada';
$string['errorsomeprogramsdontexist'] = 'Beberapa program tidak ada';
$string['errorusercantbeallocated'] = 'Pengguna tidak dapat dialokasikan';
$string['eventcourseadded'] = 'Kursus ditambahkan';
$string['eventcourseremoved'] = 'Kursus dihapus';
$string['eventcourseupdated'] = 'Kursus diperbarui';
$string['eventprogramcompleted'] = 'Program selesai';
$string['eventprogramcreated'] = 'Program dibuat';
$string['eventprogramdeleted'] = 'Program dihapus';
$string['eventprogramupdated'] = 'Program diperbarui';
$string['eventsetcompleted'] = 'Set selesai';
$string['eventsetcreated'] = 'Set dibuat';
$string['eventsetdeleted'] = 'Set dihapus';
$string['eventsetupdated'] = 'Set diperbarui';
$string['eventuserallocated'] = 'Pengguna dialokasikan';
$string['eventuserdeallocated'] = 'Pengguna dide-alokasikan';
$string['export_content'] = 'Pengaturan';
$string['export_content_help'] = 'Program, nama, deskripsi, tanggal, tag, dll.';
$string['export_dynamic_rules'] = 'Aturan dinamis';
$string['export_dynamic_rules_help'] = 'Semua konfigurasi aturan dinamis untuk program ini.';
$string['export_user_allocations'] = 'Alokasi pengguna program';
$string['export_user_allocations_help'] = 'Termasuk alokasi pengguna untuk program ini. Salinan pengguna itu sendiri tidak akan disertakan.';
$string['exportonlyallocationspostfix'] = '(hanya alokasi pengguna)';
$string['exportprogramsdescription'] = 'Program dengan kursusnya, alokasi pengguna, dan aturan dinamis komponen';
$string['fullprogramreport'] = 'Laporan program lengkap';
$string['futureallocation'] = 'Alokasi mendatang';
$string['gotoprogram'] = 'Pergi ke program';
$string['hidden'] = 'Tersembunyi';
$string['hiddenfromlearners'] = 'Tersembunyi dari pelajar';
$string['idnumber'] = 'Nomor ID';
$string['import_content'] = 'Pengaturan';
$string['import_content_help'] = 'Program, nama, deskripsi, tanggal, tag, dll.';
$string['import_dynamic_rules'] = 'Aturan dinamis';
$string['import_dynamic_rules_help'] = 'Semua konfigurasi aturan dinamis untuk program ini.';
$string['import_user_allocations'] = 'Alokasi pengguna program';
$string['import_user_allocations_help'] = 'Termasuk alokasi pengguna untuk program ini.';
$string['importcannotallocate'] = 'Tidak mungkin untuk mengalokasikan pengguna \'{$a->originaluserfullname}\' ke program \'{$a->program}\', alokasi sudah ada atau tidak diizinkan';
$string['importlogfailed'] = 'Tidak dapat mengimpor program \'{$a->fullname}\'';
$string['importlogidnumberexists'] = 'Program dengan nomor ID \'{$a->originalidnumber}\' sudah ada';
$string['importlogsuccess'] = 'Membuat program baru \'<a href="{$a->url}">{$a->fullname}</a>\' dengan {$a->setscount} set, {$a->coursescount} kursus';
$string['importlogsuccessuserallocations'] = 'Mengalokasikan pengguna \'{$a->userfullname}\' ke dalam program \'{$a->program}\'';
$string['include_shared_entities'] = 'Sertakan entitas bersama';
$string['include_shared_entities_help'] = 'Dengan mengaktifkan opsi ini, berkas yang diekspor juga akan berisi:

* Semua program bersama yang tersedia di penyewa saat ini
* Semua program kursus di luar kategori kursus penyewa saat ini';
$string['inprogress'] = 'Dalam kemajuan';
$string['keepprogramdefaults'] = 'Tetapkan bawaan program';
$string['lessthanaday'] = 'Kurang dari sehari';
$string['locked'] = 'Terkunci';
$string['lockedreasonparent'] = 'Tidak tersedia kecuali: set {$a} tersedia.';
$string['lockedreasonpreviouscourse'] = 'Tidak tersedia kecuali: kursus sebelumnya {$a} ditandai sebagai selesai.';
$string['lockedreasonpreviousset'] = 'Tidak tersedia kecuali: set sebelumnya {$a} ditandai sebagai selesai.';
$string['maincompletion'] = 'Penyelesaian utama';
$string['managedusersoverdue'] = 'Beberapa anggota tim memiliki program yang terlambat.';
$string['manual'] = 'Manual';
$string['mappingerrorprogramnotfound'] = 'Program {$a} tidak ditemukan';
$string['mappingnoticenoidnumber'] = 'Program tersebut ditemukan berdasarkan nama karena nomor ID kosong. Sebaiknya berikan nomor ID pada program';
$string['messageprovider:programcompleted'] = 'Program selesai';
$string['messageprovider:programuserallocated'] = 'Pengguna dialokasikan ke program';
$string['messageprovider:programuserdeallocated'] = 'Pengguna dide-alokasikan dari program';
$string['missingcompletion'] = 'Kriteria penyelesaian hilang';
$string['missingcourse'] = 'Kursus hilang';
$string['missingfullname'] = 'Nama program hilang.';
$string['missingprogram'] = 'Program hilang';
$string['missingsetname'] = 'Nama set hilang';
$string['name'] = 'Nama';
$string['never'] = 'Tidak pernah';
$string['newnameforset'] = 'Nama baru untuk \'{$a}\'';
$string['newprogram'] = 'Nama program';
$string['notarchived'] = 'Tidak diarsip';
$string['notavailable'] = 'Tidak tersedia';
$string['notcompleted'] = 'Tidak selesai';
$string['notenrolledprograms_mobile'] = 'Anda tidak terdaftar dalam program apa pun';
$string['notificationduedate'] = 'Program ini akan jatuh tempo pada {$a}<br /><br />';
$string['notificationprogramcompleted'] = 'Hai {$a->userfullname},<br /><br />
Selamat telah menyelesaikan program \'{$a->programname}\'!<br /><br />
Anda dapat meninjau kembali kursus dalam program tersebut kapan saja. Program lengkap dapat ditemukan di halaman \'Kursus saya\'.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationprogramuserallocated'] = 'Hai {$a->userfullname},<br /><br />
Selamat datang di program \'{$a->programname}\', yang dapat Anda temukan di halaman \'Kursus saya\'.<br /><br />
{$a->duedatemsg}
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationprogramuserdeallocated'] = 'Hai {$a->userfullname},<br /><br />
Program \'{$a->programname}\' kini telah ditutup dan tidak dapat diakses lagi.<br /><br />
{$a->sitename}<br />
{$a->siteurl}';
$string['notificationsubjectprogramcompleted'] = 'Selamat - \'{$a}\' selesai!';
$string['notificationsubjectprogramuserallocated'] = 'Selamat datang di \'{$a}\'';
$string['notificationsubjectprogramuserdeallocated'] = '\'{$a}\' ditutup';
$string['notset'] = 'Tidak disetel';
$string['notsuspended'] = 'Tidak ditangguhkan';
$string['notvisible'] = 'Tidak terlihat';
$string['nousersselected'] = 'Anda perlu memilih setidaknya satu pengguna';
$string['numbercoursesinprogramunique'] = 'Jumlah kursus (unik)';
$string['numbercoursesinset'] = 'Jumlah kursus dalam set';
$string['numbercurrentallocatedusers'] = 'Jumlah pengguna yang saat ini dialokasikan';
$string['open'] = 'Buka';
$string['outcomeallocation'] = 'Alokasikan pengguna ke program';
$string['outcomeallocationdescdate'] = 'Alokasikan pengguna ke program {$a->programname}<br />
{$a->startdatestr}<br />
Dengan pengguna yang ditangguhkan: {$a->suspendedusers}';
$string['outcomeallocationdesckeepdate'] = 'Batalkan penangguhan dan biarkan tanggal mulai/akhir program yang ada';
$string['outcomeallocationdesckeepstartdate'] = 'Tetapkan tanggal mulai program bawaan';
$string['outcomeallocationdescstartdate'] = 'Tanggal mulai program: \'{$a->startdate}\'';
$string['outcomeallocationdescsuspendchangedate'] = 'Batalkan penangguhan dan ubah tanggal mulai/akhir program';
$string['outcomeallocationdontmodify'] = 'Jangan memodifikasi alokasi';
$string['outcomeallocationsuspendedusers'] = 'Dengan pengguna yang ditangguhkan';
$string['outcomeallocationsuspendedusers_help'] = 'Tindakan yang harus dilakukan ketika pengguna sudah dialokasikan tetapi alokasinya ditangguhkan atau diakhiri';
$string['outcomeallocationunsuspend'] = 'Batalkan penangguhan, biarkan tanggal mulai/akhir program yang ada';
$string['outcomeallocationunsuspendchangedate'] = 'Batalkan penangguhan, ubah tanggal mulai/akhir program';
$string['outcomedeallocate'] = 'De-alokasikan pengguna dari program';
$string['outcomedeallocatesuspend'] = 'Tangguhkan alokasi yang ada';
$string['outcomedeallocation'] = 'De-alokasikan pengguna dari program';
$string['outcomedeallocationdescription'] = 'De-alokasikan pengguna dari program \'{$a}\'';
$string['outcomedeallocationdescriptionsuspend'] = 'Tangguhkan alokasi pengguna yang ada dari program \'{$a}\'';
$string['overdue'] = 'Terlambat';
$string['overdueprogramslink'] = '<a href="{$a->href}">{$a->count} program yang terlambat</a>';
$string['parentname'] = 'Nama induk';
$string['pending'] = 'Tertunda';
$string['pendingreasonhiddencourse'] = 'Beberapa kursus yang diperlukan untuk membuka kursus ini tidak tersedia. Silakan hubungi administrator situs.';
$string['pendingreasonparent'] = 'Akan otomatis ditandai sebagai selesai ketika: set {$a} tersedia.';
$string['pendingreasonpreviouscourse'] = 'Akan otomatis ditandai sebagai selesai ketika: kursus sebelumnya {$a} ditandai sebagai selesai.';
$string['pendingreasonpreviousset'] = 'Akan otomatis ditandai sebagai selesai ketika: set sebelumnya {$a} ditandai sebagai selesai.';
$string['pluginname'] = 'Program';
$string['previewprogramname'] = 'Pratinjau nama program';
$string['privacy:metadata:core_tag'] = 'Tag ditambahkan ke program';
$string['privacy:metadata:program_set_completion'] = 'Informasi tentang penyelesaian rangkaian program.';
$string['privacy:metadata:program_set_completion:completeddate'] = 'Tanggal pengguna menyelesaikan set.';
$string['privacy:metadata:program_set_completion:setid'] = 'Set yang sudah selesai.';
$string['privacy:metadata:program_set_completion:timemodified'] = 'Waktu penyelesaian set yang dimodifikasi.';
$string['privacy:metadata:program_set_completion:userid'] = 'Pengguna yang menyelesaikan set.';
$string['privacy:metadata:program_users'] = 'Informasi tentang alokasi program pengguna.';
$string['privacy:metadata:program_users:allocationtype'] = 'Sumber dari mana pengguna dialokasikan.';
$string['privacy:metadata:program_users:certificationid'] = 'Sertifikasi yang dialokasikan untuk (jika berlaku).';
$string['privacy:metadata:program_users:duedate'] = 'Tanggal jatuh tempo program.';
$string['privacy:metadata:program_users:duedatelocked'] = 'Apakah tanggal jatuh tempo program bawaan ditimpa.';
$string['privacy:metadata:program_users:enddate'] = 'Tanggal akhir program untuk pengguna ini.';
$string['privacy:metadata:program_users:enddatelocked'] = 'Apakah tanggal berakhirnya program bawaan ditimpa.';
$string['privacy:metadata:program_users:programid'] = 'Program yang dialokasikan.';
$string['privacy:metadata:program_users:startdate'] = 'Tanggal mulai program untuk pengguna ini.';
$string['privacy:metadata:program_users:startdatelocked'] = 'Apakah tanggal mulai program bawaan ditimpa.';
$string['privacy:metadata:program_users:status'] = 'Apakah pengguna telah ditangguhkan dari program.';
$string['privacy:metadata:program_users:timemodified'] = 'Waktu alokasi pengguna yang dimodifikasi.';
$string['privacy:metadata:program_users:userid'] = 'ID pengguna yang dialokasikan ke program.';
$string['program:allocateuser'] = 'Alokasikan pengguna ke program';
$string['program:configurecustomfields'] = 'Konfigurasikan kolom kustom program';
$string['program:coursereset'] = 'Atur ulang program kursus';
$string['program:edit'] = 'Sunting program';
$string['programdescription'] = 'Deskripsi program';
$string['programdescription_help'] = 'Deskripsi program ditampilkan pada informasi program dan halaman sampul.';
$string['programduedate'] = 'Tanggal jatuh tempo program';
$string['programfullname'] = 'Nama program';
$string['programfullname_help'] = 'Nama program ditampilkan pada halaman daftar kursus.';
$string['programidnumber'] = 'Nomor ID program';
$string['programidnumber_help'] = 'Nomor ID suatu program hanya digunakan saat mencocokkan program dengan sistem eksternal dan tidak ditampilkan di mana pun di situs. Jika program memiliki nama kode resmi, nama tersebut dapat dimasukkan, jika tidak, bidang tersebut dapat dibiarkan kosong.';
$string['programimage'] = 'Gambar program';
$string['programimage_help'] = 'Gambar program ditampilkan pada halaman daftar kursus.';
$string['programinformation'] = 'Informasi program';
$string['programname'] = 'Nama program';
$string['programnamewitheditlink'] = 'Nama program dengan tautan untuk sunting';
$string['programnamewithimage'] = 'Nama program dengan gambar';
$string['programnamewithimageandeditlink'] = 'Nama program dengan gambar dan tautan untuk sunting';
$string['programnamewithimageandviewlink'] = 'Nama program dengan gambar dan tautan untuk melihat';
$string['programnamewithviewlink'] = 'Nama program dengan tautan untuk melihat';
$string['programparentsetname'] = 'Nama set induk';
$string['programprogress'] = 'Kemajuan program';
$string['programprogressexport'] = 'kemajuan program {$a}';
$string['programprogresswithreportlinks'] = 'Kemajuan program dengan tautan laporan';
$string['programreset'] = 'Pengaturan ulang program';
$string['programrules'] = 'Aturan program';
$string['programs'] = 'Program';
$string['programscustomfield'] = 'Kolom kustom program';
$string['programsetname'] = 'Nama set';
$string['programsoverview_mobile'] = 'Ikhtisar program';
$string['programstatus'] = 'Status program';
$string['programtags'] = 'Tag program';
$string['programtags_help'] = 'Tag untuk program ini';
$string['programtenant'] = 'Penyewa program';
$string['programuserallocations'] = 'Alokasi pengguna program';
$string['programvisibility'] = 'Visibilitas program';
$string['programvisibility_help'] = 'Pengaturan ini menentukan apakah program ditampilkan pada daftar kursus pengguna atau tidak.';
$string['progress'] = '{$a} selesai';
$string['progressoverview'] = 'Ikhtisar kemajuan';
$string['progressoverviewfor'] = 'Ikhtisar kemajuan untuk {$a}';
$string['progresspercent'] = 'Kemajuan';
$string['progressreport'] = 'Laporan kemajuan';
$string['recalculateprogramcompletion'] = 'Hitung ulang penyelesaian program';
$string['recalculateprogramcompletion_help'] = 'Penyelesaian program akan dihitung ulang untuk semua pengguna program. Perlu diketahui bahwa jika pengguna telah menyelesaikan program dan konten baru telah ditambahkan ke program, pengguna mungkin harus menyelesaikan program lagi. Tindakan ini dapat memakan waktu beberapa menit untuk diselesaikan dan tidak dapat dibatalkan.';
$string['reg_wpprograms'] = 'Jumlah program ({$a})';
$string['reportprogramsallocationcompletion'] = 'Alokasi dan penyelesaian pengguna program';
$string['reset'] = 'Atur ulang';
$string['resetprogress'] = 'Atur ulang program';
$string['resetusersprogram'] = 'Atur ulang program pengguna';
$string['restore'] = 'Pulihkan';
$string['review'] = 'Tinjau';
$string['rolemanager'] = 'Manajer program';
$string['rolemanagerdescription'] = 'Memungkinkan untuk membuat dan mengelola program dalam penyewa saat ini dan mengalokasikan pengguna kepada mereka';
$string['scheduleupdatesuccess'] = 'Jadwal berhasil diperbarui';
$string['seecontent_mobile'] = 'Lihat konten';
$string['selectactiveandarchivedprograms'] = 'Pilih semua program yang aktif dan diarsip';
$string['selectallactiveprograms'] = 'Pilih semua program yang aktif';
$string['selectallprogramsinthisfile'] = 'Pilih semua program dalam berkas ini';
$string['selectatleastoneprogram'] = 'Pilih setidaknya satu program';
$string['selectcourses'] = 'Pilih kursus';
$string['selectmanually'] = 'Pilih secara manual...';
$string['selectprogramcondition'] = 'Program';
$string['selectprogramcondition_help'] = 'Pilih program yang akan diasosiasikan dengan kondisi ini';
$string['selectprogramoutcome'] = 'Program';
$string['selectprogramoutcome_help'] = 'Pilih program yang akan diasosiasikan dengan tindakan ini';
$string['selectprogramstoallocate'] = 'Program';
$string['selectprogramstoallocate_help'] = 'Pilih program tempat pengguna akan dialokasikan';
$string['separatetenantsingroupswarning'] = 'Dalam kursus yang dibagikan antar penyewa, pengguna dari setiap penyewa akan ditambahkan ke grup terpisah.';
$string['set'] = 'Set';
$string['setname'] = 'Nama';
$string['setname_help'] = 'Silakan pilih nama untuk set tersebut';
$string['setofcourses'] = 'Set kursus';
$string['setsandcoursesnotfound_mobile'] = 'Tidak ada set atau kursus yang ditemukan';
$string['startdate'] = 'Tanggal mulai';
$string['startdate_help'] = 'Tanggal mulai program ini';
$string['status'] = 'Status';
$string['status_help'] = 'Status ditangguhkan akan menyembunyikan program ini dari pengguna ini.';
$string['suspended'] = 'Ditangguhkan';
$string['suspendeddateonorafter'] = 'Tanggal ditangguhkan pada atau setelahnya';
$string['tagarea_tool_program'] = 'Program';
$string['tags'] = 'Tag';
$string['timecreated'] = 'Dibuat pada';
$string['timemodified'] = 'Terakhir dimodifikasi pada';
$string['timesuspended'] = 'Ditangguhkan pada';
$string['toomanyprogramstoshow'] = 'Terlalu banyak program untuk ditampilkan';
$string['type'] = 'Tipe';
$string['userduedate'] = 'Tanggal jatuh tempo';
$string['userduedate_help'] = 'Pilih tanggal jatuh tempo program untuk pengguna ini.';
$string['userenddate'] = 'Tanggal akhir';
$string['userenddate_help'] = 'Pilih tanggal saat program ini tidak akan terlihat oleh pengguna ini.';
$string['userlist'] = 'Pilih pengguna';
$string['userlist_help'] = 'Pilih pengguna untuk dialokasikan ke program ini';
$string['users'] = 'Pengguna';
$string['usersallocatedsuccess'] = 'Alokasi pengguna {$a} berhasil dibuat';
$string['usersallocationnotavailable'] = 'Alokasi pengguna tidak tersedia';
$string['usersdeallocatedsuccess'] = '{$a} pengguna) berhasil dide-alokasikan';
$string['userseditedsuccess'] = '{$a} pengguna berhasil dimodifikasi';
$string['usersrecalculationcompletion'] = 'Penyelesaian program dihitung ulang untuk {$a} pengguna';
$string['usersresetprogramsuccess'] = 'Program telah diatur ulang untuk {$a} pengguna';
$string['usersskipped'] = '{$a} pengguna dilewati karena opsi ini tidak tersedia bagi mereka';
$string['userstartdate'] = 'Tanggal mulai';
$string['userstartdate_help'] = 'Pilih tanggal saat pengguna ini dapat memulai program. Tanggal ini hanya akan berlaku untuk pengguna ini.';
$string['visible'] = 'Terlihat';
$string['warningcourseinvisible'] = 'Peringatan: Kursus ini tidak terlihat oleh siswa.';
