<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'hsuforum', language 'es_mx', version '4.1'.
 *
 * @package     hsuforum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessible'] = 'Accesible';
$string['activityoverview'] = 'Hay nuevas publicaciones en foro';
$string['addanewdiscussion'] = 'Añadir un nuevo tópico de discusión';
$string['addanewtopic'] = 'Agregar nueva discusión';
$string['addareply'] = 'Agrega tu respuesta';
$string['addyourdiscussion'] = 'Añadir su discusión';
$string['advancedsearch'] = 'Búsqueda avanzada';
$string['ajaxrequesterror'] = 'No pudo completarse la solicitud, por favor, inténtelo de nuevo.';
$string['all'] = 'Todo';
$string['allforums'] = 'Todos los foros';
$string['allowanonymous'] = 'Permitir publicaciones anónimas';
$string['allowanonymous_help'] = 'Si elige esta opción, el nombre del autor de cada publicación sera omitido al ver el foro';
$string['allowdiscussions'] = '¿Puede un/una {$a} publicar en este foro?';
$string['allowsallsubscribe'] = 'Este foro les permite a todos elegir si se suscriben o no';
$string['allowsdiscussions'] = 'Este foro le permite a cada persona iniciar un tema/tópico de discusión';
$string['allsubscribe'] = 'Suscribirse a todos los foros';
$string['allunsubscribe'] = 'Des-suscribirse de todos los foros';
$string['alreadyfirstpost'] = 'Esta ya es la primera publicación en la discusión';
$string['anonymousalternatename'] = 'Anónima';
$string['anonymousfirstname'] = 'Anónima';
$string['anonymousfirstnamephonetic'] = 'Anónima';
$string['anonymouslastname'] = 'Usuario';
$string['anonymouslastnamephonetic'] = 'Usuario';
$string['anonymousrecentactivity'] = 'Podría haber actividad reciente en este foro, pero no pueden mostrarse los detalles porque el foro es anónimo.';
$string['anonymouswarning'] = 'Al mover este tópico/tema de discusión, Usted podría revelar información anónima. ¿Está Usted seguro de querer hacer esto?';
$string['anyfile'] = 'Cualquier archivo';
$string['areapost'] = 'Mensajes';
$string['articledateformat'] = '%l:%M%P %b %e, %Y';
$string['attachment'] = 'Anexos';
$string['attachment_help'] = 'Usted puede anexar opcionalmente uno o más archivos a una publicación en foro. Si Usted anexa una imagen, se mostrará después del  mensaje.';
$string['attachmentnopost'] = 'Usted no puede exportar anexos sin una ID del post';
$string['attachments'] = 'Anexos';
$string['attachments:x'] = 'Anexos: {$a}';
$string['author'] = 'Autor';
$string['blockafter'] = 'Publicar el límite permitido';
$string['blockafter_help'] = 'Esta configuración indica el número máximo de publicaciones que un usuario puede crear en un periodo de tiempo específico. Los usuarios con el permiso mod/hsuforum:postwithoutthrottling no se ven afectados por el límite.';
$string['blockperiod'] = 'Periodo de tiempo del bloqueo.';
$string['blockperiod_help'] = 'Los estudiantes pueden ser bloqueados al publicar más del número de publicaciones definido en un periodo de tiempo específico. Los usuarios con el permiso mod/hsuforum:postwithoutthrottling no se ven afectados por el límite.';
$string['blockperioddisabled'] = 'No bloquear';
$string['blogforum'] = 'Mostrar el foro en formato tipo blog';
$string['bynameondate'] = 'por {$a->name} - {$a->date}';
$string['byx'] = 'por {$a}';
$string['cannnotdeletesinglediscussion'] = 'Lo sentimos, pero ¡ Usted no tiene permitido eliminar esa discusión !';
$string['cannotadd'] = 'No pudo añadirse la discusión a este foro';
$string['cannotadddiscussion'] = 'Añadir discusiones al foro requiere membresía de grupo.';
$string['cannotadddiscussionall'] = 'No tiene permiso de agregar un nuevo tema de discusión para todos los participantes.';
$string['cannotadddiscussiongroup'] = 'No puedes crear una discusión porque no eres miembro de ningún grupo.';
$string['cannotaddsubscriber'] = '¡No se pudo agregar al usuario con id {$a} a este foro!';
$string['cannotaddteacherforumto'] = 'No se pudo agregar la instancia del foro a la sección 0 del curso.';
$string['cannotcreatediscussion'] = 'No se pudo crear la nueva discusión.';
$string['cannotcreateinstanceforteacher'] = 'No se pudo crear la nueva instancia del curso para el foro del profesor';
$string['cannotdeletepost'] = '¡Usted no puede eliminar esta publicación!';
$string['cannoteditposts'] = '¡No puede editar las publicaciones de otras personas!';
$string['cannotfinddiscussion'] = 'No se pudo encontrar la discusión en este foro';
$string['cannotfindfirstpost'] = 'No se pudo encontrar la primera publicación en este foro';
$string['cannotfindorcreateforum'] = 'No se pudo encontrar o crear el foro principal de novedades para el sitio';
$string['cannotfindparentpost'] = 'No se pudo encontrar el antecesor de la publicación {$a}';
$string['cannotmakeprivatereplies'] = 'Lo sentimos, pero no tiene permitido realizar respuestas privadas en este foro';
$string['cannotmovefromsingleforum'] = 'No puede mover la discusión de un foro de discusión de tema único';
$string['cannotmovenotvisible'] = 'Foro no visible';
$string['cannotmovetonotexist'] = '¡No puede mover a ese foro - no existe!';
$string['cannotmovetonotfound'] = 'El foro destino no se encuentra en este curso.';
$string['cannotmovetosingleforum'] = 'No puede mover la discusión a un foro de discusión de tema único';
$string['cannotpurgecachedrss'] = 'No se pudo limpiar la caché de noticias RSS para los foros  fuente/destino - revise su archivo de permisos del foro';
$string['cannotremovesubscriber'] = '¡No puede cancelar la suscripción del usuario {$a} de este foro!';
$string['cannotreply'] = 'Usted no puede contestar a esta publicación';
$string['cannotsplit'] = 'Las discusiones de este foro no pueden ser divididas';
$string['cannotsubscribe'] = 'Lo sentimos, pero debe pertenecer a un grupo de miembros para suscribirse.';
$string['cannottrack'] = 'No se pudo dejar de seguir ese foro';
$string['cannotunsubscribe'] = 'No se pudo cancelar su suscripción a ese foro';
$string['cannotupdatepost'] = 'Usted no puede actualizar esta publicación';
$string['cannotviewpostyet'] = 'Usted aún no puede leer las preguntas de otros estudiantes en la discusión porque Usted todavía no ha publicado';
$string['cannotviewusersposts'] = 'No hay publicaciones hechas por este usuario que usted pueda ver.';
$string['cansubscribediscerror'] = 'No tiene permitido suscribirse a esta discusión';
$string['cleanreadtime'] = 'Marcar publicaciones antiguas como leidas';
$string['clicktocollapse'] = 'Haga clic para ocultar el mensaje publicado y cualquier respuesta';
$string['clicktoexpand'] = 'Haga clic para ver el mensaje publicado y cualquier respuesta';
$string['collapseall'] = 'Colapsarlo todo';
$string['completiondetail:discussions'] = 'Iniciar discusiones: {$a}';
$string['completiondetail:posts'] = 'Hacer publicaciones en foro: {$a}';
$string['completiondetail:replies'] = 'Publicar respuestas: {$a}';
$string['completiondiscussions'] = 'El estudiante debe crear las discusiones:';
$string['completiondiscussionsdesc'] = 'El estudiante debe crear al menos {$a} discusión(es)';
$string['completiondiscussionsgroup'] = 'Necesita discusiones';
$string['completiondiscussionshelp'] = 'se requieren discusiones para completar';
$string['completionposts'] = 'El estudiante debe publicar discusiones o respuestas';
$string['completionpostsdesc'] = 'El estudiante debe publicar al menos {$a} discusión(es) o respuestas';
$string['completionpostsgroup'] = 'Requiere publicaciones';
$string['completionpostshelp'] = 'se requieren discusiones o respuestas para completar';
$string['completionreplies'] = 'El estudiante debe publicar respuestas:';
$string['completionrepliesdesc'] = 'El estudiante debe publicar al menos {$a} respuestas';
$string['completionrepliesgroup'] = 'Requerir respuestas';
$string['completionreplieshelp'] = 'se requieren respuestas para completar';
$string['completionusegradeerror'] = 'No necesita calificación porque este foro no es calificado. Usted puede quitar el requisito de finalización o Usted puede hacer este foro calificado.';
$string['configcleanreadtime'] = 'Hora del día para limpiar las publicaciones antiguas de la tabla de \'lectura\'.';
$string['configdigestmailtime'] = 'Gente que elige recibir correos electrónicos en forma de resumen recibirá un Email de resumen diariamente. Esta configuración controla a que hora del día se enviará el correo (el cron que corra después de la hora indicada lo mandará).';
$string['configenablerssfeeds'] = 'Este indicador habilita la posibilidad de canales de noticias RSS para todos los foros. También sera necesario habilitar esta configuracion manualmente en cada foro.';
$string['configenabletimedposts'] = 'Seleccione "Si" si quiere permitir la visualización de periodos de tiempo al publicar en un nuevo foro de discusión.';
$string['confighiderecentposts'] = 'Seleccione "si" para dejar de mostrar las publicacione recientes en la página del curso.';
$string['configlongpost'] = 'Cualquier publicación mayor a este tamaño (en caracteres, no incluyendo HTML) es considerada grande. Las publicaciones mostradas en: la página inical del sitio, páginas sociales del curso, ó perfiles de usuario, se muestran más cortas en un tamaño entre los valores de hsuforum_shortpost y hsuforum_longpost.';
$string['configmanydiscussions'] = 'El número máximo de discusiones visibles en un foro por pagina';
$string['configmaxattachments'] = 'Número máximo de anexos permitidos por publicación.';
$string['configmaxbytes'] = 'Tamaño máximo para los anexos en los foros del sitio (restringido por los límites del curso y otras configuraciones locales)';
$string['configoldpostdays'] = 'Número de días de antiguedad para considerar un post como leído.';
$string['configreplytouser'] = 'Cuando una publicación del foro es enviada por correo, ¿debería contener la direccion del usuario para que se puedan contactar personalmente en lugar de hacerlo a través del foro? Incluso si elige esta opción, los usuarios pueden elegir  mantener su dirección de correo privada.';
$string['configrssarticlesdefault'] = 'Si los canales RSS están habilitados, establece el número predeterminado de artículos (ya sean discusiones o publicaciones).';
$string['configrsstypedefault'] = 'Si las fuentes RSS están habilitadas, establece el tipo de actividad predeterminado.';
$string['configshortpost'] = 'Cualquier publicación menor a este tamaño (en caracteres sin incluir HTML) es considerada pequeña (ver abajo).';
$string['configsubscriptiontype'] = 'Configuraciones por defecto para el modo de suscripción.';
$string['configusermarksread'] = 'Si elige "si", el usuario debe marcar manualmente las publicaciones leídas. Si elige "no", al ver una publicación se marca como leída.';
$string['confirmsubscribe'] = '¿Está seguro de querer suscribirse al foro "{$a}"?';
$string['confirmunsubscribe'] = '¿Esta seguro de querer dejar de seguir el foro "{$a}"?';
$string['couldnotadd'] = 'No se pudo agregar su publicación debido a un error desconocido.';
$string['couldnotdeletereplies'] = 'Lo sentimos, no se puede borrar ya que ha recibido  respuestas';
$string['couldnotupdate'] = 'No se pudo actualizar su publicación debido a un error desconocido';
$string['createdbynameondate'] = 'Creado por {$a->name} en {$a->date}';
$string['crontask'] = 'Trabajos de envío de correo electrónico y mantenimiento';
$string['csv'] = 'CSV';
$string['date'] = 'Fecha';
$string['default'] = 'Por defecto';
$string['delete'] = 'Borrar';
$string['deleteattachments'] = 'Borrar anexos';
$string['deleteattachmentx'] = 'Borrar {$a}';
$string['deleteddiscussion'] = 'El tema de discusión ha sido eliminado';
$string['deletedpost'] = 'La publicación ha sido eliminada';
$string['deletedposts'] = 'Esas publicaciones han sido eliminadas';
$string['deletesure'] = '¿Está seguro de querer eliminar esta publicación?';
$string['deletesureplural'] = '¿Está seguro de querer eliminar esta publicación y todas sus respuestas? ({$a} publicaciones)';
$string['digestmailheader'] = 'Este es su resumen diario de nuevas publicaciones de los foros en {$a->sitename}. Para cambiar sus preferencias de correo del foro, vaya a {$a->userprefs}.';
$string['digestmailpost'] = 'Cambie sus preferencias de resumen del foro';
$string['digestmailpostlink'] = 'Cambiar sus preferencias del resumen del foro: {$a}';
$string['digestmailprefs'] = 'su perfil de usuario';
$string['digestmailsubject'] = '{$a}: resumen del foro';
$string['digestmailtime'] = 'Hora para mandar el correo de resumen';
$string['digestsentusers'] = 'Correo de resumen enviado exitosamente a {$a} usuarios.';
$string['disallowsubscribe'] = 'Suscripciones no permitidas';
$string['disallowsubscribeteacher'] = 'Suscripciones no permitidas (exceptuando a profesores)';
$string['discussion'] = 'Discusión';
$string['discussion:x'] = 'Discusión: {$a}';
$string['discussiondisplay'] = 'Mostrar discusión';
$string['discussionforum'] = 'Discusión para hilo {$a}';
$string['discussionlocked'] = 'Esta discusión ha sido bloqueada, por lo que Usted ya no puede responder a ella.';
$string['discussionlockingdisabled'] = 'No bloquear discusiones';
$string['discussionlockingheader'] = 'Bloqueo de discusiones';
$string['discussionmoved'] = 'Esta discusión ha sido movida a "{$a}"';
$string['discussionmovedpost'] = 'Esta discusión ha sido movida a <a href="{$a->discusshref}">aquí</a> en el foro <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Nombre de la discusión';
$string['discussionpinned'] = 'Fijada';
$string['discussionpinned_help'] = 'Discusiones fijadas aparecerán en la parte superior de un foro.';
$string['discussions'] = 'Discusiones';
$string['discussionsortkey:created'] = 'Fecha de creación';
$string['discussionsortkey:lastreply'] = 'Reciente';
$string['discussionsortkey:replies'] = 'Más activo';
$string['discussionsortkey:subscribe'] = 'Suscrito';
$string['discussionsplit'] = 'La discusión ha sido dividida';
$string['discussionsstartedby'] = 'Discusiones iniciadas por {$a}';
$string['discussionsstartedbyrecent'] = 'Discusiones recientemente iniciadas por {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discusiones iniciadas por {$a->fullname} en {a->coursename}';
$string['discussionsubscribers'] = 'Seguidores de la discusión';
$string['discussionsummary'] = 'Una tabla de todas las discusiones del foro sobre {$a}. El encabezado Nombre apellido es una combinación del nombre, apellido y foto del usuario.';
$string['discussthistopic'] = 'Discutir este asunto';
$string['displaydiscussionreplies'] = 'Mostrar respuestas a discusión';
$string['displayend'] = 'Fin de la discusión';
$string['displayend_help'] = 'Esta configuración especifica si es que una publicación en foro debería de ocultarse después de una cierta fecha. Tenga en cuenta que los administradores siempre podrán ver las publicaciones en foros.';
$string['displayperiod'] = 'Período a mostrar';
$string['displaystart'] = 'Inicio de mostrado';
$string['displaystart_help'] = 'Esta configuración especifica si una publicación del foro debe mostrarse a partir de una fecha determinada. Tenga en cuenta que los administradores siempre pueden ver las publicaciones del foro.';
$string['displaywordcount'] = 'Mostrar conteo de palabras';
$string['displaywordcount_help'] = 'Esta configuración especifica si es que debe o no mostrarse el número de palabras de cada publicación.';
$string['eachuserforum'] = 'Cada persona publica una discusión';
$string['edit'] = 'Editar';
$string['editedby'] = 'Editado por {$a->name} - envío original {$a->date}';
$string['editedpostupdated'] = 'La publicación de {$a} fue actualizada';
$string['editing'] = 'Editando';
$string['editingpost'] = 'Editando publicación';
$string['emaildigestcompleteshort'] = 'Publicaciones completas';
$string['emaildigestdefault'] = 'Por defecto ({$a})';
$string['emaildigestoffshort'] = 'Sin resumen';
$string['emaildigestsubjectsshort'] = 'Solamente asuntos';
$string['emaildigesttype'] = 'Opciones del resumen de Email';
$string['emaildigesttype_help'] = 'El tipo de notificación que recibirás para cada foro.

* Predeterminado: sigue la configuración de resumen que se encuentra en tu perfil de usuario. Si actualiza su perfil, ese cambio también se reflejará aquí;
* Sin resumen: recibirá un correo electrónico por cada publicación en el foro;
* Resumen: publicaciones completas: recibirá un correo electrónico de resumen por día que contendrá el contenido completo de cada publicación en el foro;
* Resumen: solo temas: recibirá un correo electrónico de resumen por día que contendrá solo el tema de cada publicación en el foro.';
$string['emptymessage'] = 'Algo no estaba bien con tu publicación. Quizás la dejaste en blanco o el archivo adjunto era demasiado grande. Tus cambios NO se han guardado.';
$string['erroremptymessage'] = 'El mensaje a publicar no puede estar vacío';
$string['erroremptysubject'] = 'El asunto del mensaje a publicar no puede estar vacío';
$string['errorenrolmentrequired'] = 'Usted necesita estar inscrito en este curso para acceder a este contenido';
$string['errortimestartgreater'] = 'La hora de inicio no puede ser después de la hora de fin.';
$string['errorwhiledelete'] = 'Ocurrió un error al eliminar registro.';
$string['eventassessableuploaded'] = 'Se ha publicado contenido';
$string['eventcoursesearched'] = 'Curso buscado';
$string['eventdiscussioncreated'] = 'Discusión creada';
$string['eventdiscussiondeleted'] = 'Discusión eliminada';
$string['eventdiscussionmoved'] = 'Discusión movida';
$string['eventdiscussionpinned'] = 'Discusión fijada';
$string['eventdiscussionunpinned'] = 'Discusión des-fijada';
$string['eventdiscussionupdated'] = 'Discusión actualizada';
$string['eventdiscussionviewed'] = 'Discusión vista';
$string['eventpostcreated'] = 'Publicación creada';
$string['eventpostdeleted'] = 'Publicación eliminada';
$string['eventpostupdated'] = 'Publicación actualizada';
$string['eventreadtrackingdisabled'] = 'Monitoreo de lectura deshabilitado';
$string['eventreadtrackingenabled'] = 'Monitoreo de lectura habilitado';
$string['eventsubscribersviewed'] = 'Suscriptores vistos';
$string['eventsubscriptioncreated'] = 'Suscripción creada';
$string['eventsubscriptiondeleted'] = 'Suscripción eliminada';
$string['eventuserreportviewed'] = 'Reporte de usuario visto';
$string['everyonecanchoose'] = 'Todos pueden elegir estar suscritos';
$string['everyonecannowchoose'] = 'Ahora todos pueden elegir estar suscritos';
$string['everyoneisnowsubscribed'] = 'Ahora todos están  suscritos a este foro';
$string['everyoneissubscribed'] = 'Todos están suscritos a este foro';
$string['existingsubscribers'] = 'Suscriptores existentes';
$string['expandall'] = 'Expandir todo';
$string['export'] = 'Exportar';
$string['exportattachments'] = 'Exportar anexos';
$string['exportdiscussion'] = 'Exportar discusión completa a portafolios';
$string['exportformat'] = 'Formato de exportación';
$string['forcessubscribe'] = 'Este foro forza a todos a estar sucritos';
$string['forum'] = 'Foro';
$string['forumauthorhidden'] = 'Autor (oculto)';
$string['forumblockingalmosttoomanyposts'] = 'Usted se está acercando al umbral de publicaciones. Usted ha publicado {$a->numposts} veces en los últimos {$a->blockperiod} y el límite es de {$a->blockafter} publicaciones.';
$string['forumbodydeleted'] = 'El contenido de este foro ha sido eliminado y ya no puede ser accesado.';
$string['forumbodyhidden'] = 'Esta publicación no puede ser vista por usted, probablemente porque usted no ha publicado en la discusión, el tiempo máximo para editar todavía no ha pasado, la discusión no ha iniciado o la discusión ha expirado.';
$string['forumintro'] = 'Descripción';
$string['forumname'] = 'Nombre del foro';
$string['forumposts'] = 'Publicaciones en foro';
$string['forums'] = 'Foros';
$string['forumsubjectdeleted'] = 'Esta publicación del foro ha sido eliminada';
$string['forumsubjecthidden'] = 'Asunto (oculto)';
$string['forumtracked'] = 'Las publicaciones no leídas están siendo monitoreadas';
$string['forumtrackednot'] = 'Las publicaciones no leídas NO están siendo monitoreadas';
$string['forumtype'] = 'Tipo de foro';
$string['forumtype_help'] = 'Hay 5 tipos de foros:

* Una discusión única simple - Un solo tópico de discusión al cual todos pueden contestar (no puede usarse con grupos separados)
* Cada persona publica una discusión - Cada estudiante puede publicar exactamente un nuevo tópico de discusión, al cual todos pueden contestar
* Foro de Preguntas y Respuestas - Los estudiantes primeramente deben publicar sus perspectivas antes de ver las publicaciones de otros estudiantes
* Foro estándar mostrado en un formato similar a blog - Un foro abierto en donde cualquiera puede iniciar una nueva discusión en cualquier momento, y en el cual los tópicos de discusión son mostrados en una página con enlaces para "Discutir este tópico"
* Foro estándar para uso general - Un foro abierto donde cualquiera puede iniciar una discusión en cualquier momento';
$string['general'] = 'General';
$string['generalforum'] = 'Foro estandar para uso general';
$string['generalforums'] = 'Foros generales';
$string['grade'] = 'Calificación';
$string['gradeitem:posts'] = 'Publicaciones';
$string['gradetype'] = 'Tipo de calificación';
$string['gradetype_help'] = 'El tipo de calificación es usado para determinar el método de calificar.

* Ninguno: el foro no es calificado.
* Manual: el foro tiene que ser calificado manualmente por el profesor vía el Libro de calificaciones.
* Valoración: usar valoraciones para generar una calificación.';
$string['gradetypemanual'] = 'Manual';
$string['gradetypenone'] = 'Ninguno/a';
$string['gradetyperating'] = 'Valoración';
$string['gradingmethodpreview'] = 'Criterio para calificar';
$string['hiddenforumpost'] = 'Publicación oculta de foro';
$string['hiderecentposts'] = 'Ocultar Publicaciones recientes';
$string['hsuforum:addinstance'] = 'Añadir un nuevo foro';
$string['hsuforum:addnews'] = 'Añadir anuncios';
$string['hsuforum:addquestion'] = 'Añadir pregunta';
$string['hsuforum:allowforcesubscribe'] = 'Permitir forzar suscripción';
$string['hsuforum:allowprivate'] = 'Permitirle al usuario responder privadamente';
$string['hsuforum:canoverridediscussionlock'] = 'Contestar a discusiones bloqueadas';
$string['hsuforum:canposttomygroups'] = 'Puede publicar a todos los grupos a los que usted tenga acceso';
$string['hsuforum:createattachment'] = 'Crear anexos';
$string['hsuforum:deleteanypost'] = 'Eliminar cualquier publicación (en cualquier momento)';
$string['hsuforum:deleteownpost'] = 'eliminar publicaciones propias (dentro del tiempo límite)';
$string['hsuforum:editanypost'] = 'Editar cualquier publicación';
$string['hsuforum:exportdiscussion'] = 'Exportar la discusión completa';
$string['hsuforum:exportownpost'] = 'Exportar la publicación propia';
$string['hsuforum:exportpost'] = 'Exportar publicación';
$string['hsuforum:managesubscriptions'] = 'Gestionar suscriptores';
$string['hsuforum:movediscussions'] = 'Mover discusiones';
$string['hsuforum:postwithoutthrottling'] = 'Eximir del umbral del foro';
$string['hsuforum:rate'] = 'Valorar publicaciones';
$string['hsuforum:replynews'] = 'Responder a anuncios';
$string['hsuforum:replypost'] = 'Contestar a las publicaciones';
$string['hsuforum:revealpost'] = 'Revelarse Usted mismo en un foro anónimo';
$string['hsuforum:splitdiscussions'] = 'Dividir discusiones';
$string['hsuforum:startdiscussion'] = 'Iniciar nuevas discusiones';
$string['hsuforum:viewallratings'] = 'Ver todas las valoraciones crudas dadas por individuoes';
$string['hsuforum:viewanyrating'] = 'Ver valkoraciones totales que todos recibieron';
$string['hsuforum:viewdiscussion'] = 'Ver discusiones';
$string['hsuforum:viewhiddentimedposts'] = 'Ver publicaciones ocultas por tiempo';
$string['hsuforum:viewposters'] = 'Ver publicadores del foro';
$string['hsuforum:viewqandawithoutposting'] = 'Siempre ver publicacioens de Preguntas y Respuestas';
$string['hsuforum:viewrating'] = 'Ver la valoración total que Usted recibió';
$string['hsuforum:viewsubscribers'] = 'ver suscrioptores';
$string['id'] = 'id';
$string['indicator:cognitivedepth'] = 'Foro cognitivo';
$string['indicator:cognitivedepth_help'] = 'Este indicador está basado en la profundidad cognitiva alcanzada por el estudiante en una actividad de Foro.';
$string['indicator:socialbreadth'] = 'Foro social';
$string['indicator:socialbreadth_help'] = 'Este indicador está basado en la amplitud social alcanzada por el estudiante en una actividad de Foro.';
$string['inforum'] = 'en {$a}';
$string['inprivatereplyto'] = 'en respuesta privada a';
$string['inreplyto'] = 'en respuesta a';
$string['introblog'] = 'Las publicaciones de este foro se copiaron aquí automáticamente de los blogs de los usuarios de este curso porque esas entradas de blog ya no están disponibles.';
$string['intronews'] = 'Noticias y avisos generales';
$string['introsocial'] = 'Un foro abierto para chatear sobre cualquier tema que desee';
$string['introteacher'] = 'Un for solamente para notas y discusión del profesor';
$string['invalidaccess'] = 'Esta página no fue accesada correctamente';
$string['invaliddigestsetting'] = 'Se proporcionó una configuración de resumen de correo inválida';
$string['invaliddiscussionid'] = 'La ID de la discusión era incorrecta o ya no existe';
$string['invalidforcesubscribe'] = 'Modo de forzar suscripción a foro inválido';
$string['invalidforumid'] = 'ID del foro era incorrecta';
$string['invalidparentpostid'] = 'ID de publicación paterna era incorrecta';
$string['invalidpostid'] = 'ID de publicación inválida - {$a}';
$string['javascriptdisableddisplayformat'] = 'JavaScript ha sido  deshabilitado en su navegador. Por favor, habilite JavaScript y vuelva a cargar la página o seleccione una visualización de discusión diferente.';
$string['jsondecodeerror'] = 'No se pudo descodificar respuesta; por favor inténtelo nuevamente.';
$string['lastpostbyx'] = 'Última publicación por {$a->name} en {$a->time}';
$string['lastposttimeago'] = 'Último/a {$a}';
$string['learningforums'] = 'Foros de aprendizaje';
$string['loadmorediscussions'] = 'Cargar más discusiones';
$string['lockdiscussionafter'] = 'Bloquear discusiones después de período de inactividad';
$string['lockdiscussionafter_help'] = 'Las discusiones pueden bloquearse automáticamente después de que transcurra un tiempo determinado desde la última respuesta.

Los usuarios con la capacidad de responder a discusiones bloqueadas pueden desbloquear una discusión respondiéndola.';
$string['longpost'] = 'Publicación larga';
$string['mailnow'] = 'Enviar notificaciones sin retraso de tiempo de edición';
$string['manageforumsubscriptions'] = 'Gestionar suscripciones del foro';
$string['managesubscriptionsoff'] = 'Terminar de gestionar suscripciones';
$string['managesubscriptionson'] = 'Gestionar suscriptores';
$string['manualwarning'] = 'La calificación de actividades aún no está disponible. La calificación solo está disponible a través del Libro de calificaciones del curso.';
$string['manydiscussions'] = 'Discusiones por página';
$string['markalldread'] = 'Marcar todas las publicaciones en esta discusión como leídas.';
$string['markallread'] = 'Marcar todas las publicaciones en este foro como leídas.';
$string['markasreadonnotification'] = 'Al enviar notificaciones de publicaciones en el foro';
$string['markasreadonnotification_help'] = 'Cuando se le notifique de una publicación en un foro, puede elegir si desea marcar la publicación como leída a los efectos del seguimiento del foro.';
$string['markasreadonnotificationno'] = 'No marcar esta publicación como leída';
$string['markasreadonnotificationyes'] = 'Marcar la publicación como leída';
$string['markread'] = 'Maracr como leído';
$string['markreadbutton'] = 'Marcar como <br />leído';
$string['markunread'] = 'Marcar como no-leído';
$string['markunreadbutton'] = 'Marcar como <br />no-leído';
$string['maxattachments'] = 'Número máximo de anexos';
$string['maxattachments_help'] = 'Esta configuración especifica el número máximo de archivos que se pueden adjuntar a una publicación del foro.';
$string['maxattachmentsize'] = 'Tamño máximo del anexo';
$string['maxattachmentsize_help'] = 'Esta configuración especifica el tamaño máximo del archivo que puede ser anexado a una publicación del foro.';
$string['maxtimehaspassed'] = '¡Lo siento, pero el tiempo máximo para editar esta publicación ({$a}) ha pasado!';
$string['message'] = 'Mensaje';
$string['messageinboundattachmentdisallowed'] = 'No se puede publicar su respuesta porque incluye un archivo adjunto y el foro no permite archivos adjuntos.';
$string['messageinboundfilecountexceeded'] = 'No se puede publicar su respuesta, ya que incluye más del número máximo de archivos adjuntos permitidos para el foro ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'No se puede publicar su respuesta debido a que el tamaño total del archivo adjunto ({$a->filesize}) es mayor que el tamaño máximo permitido para el foro ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'No se puede publicar su respuesta debido a que el foro no está disponible actualmente.';
$string['messageinboundnopostforum'] = 'No se puede publicar tu respuesta porque no tienes permiso para publicar en el foro {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'No se puede publicar tu respuesta. Has superado el límite de publicaciones establecido para este foro.';
$string['messageisrequired'] = 'Se requiere el mensaje';
$string['messageplaceholder'] = 'Escriba su publicación';
$string['messageprovider:digests'] = 'Suscrito a resúmenes de OpenForum';
$string['messageprovider:posts'] = 'Suscrito a publicaciones de Open forum';
$string['missingsearchterms'] = 'Los siguientes términos de búsqueda aparecen únicamente en el marcado HTML de este mensaje:';
$string['modeflatfirstname'] = 'Mostrar respuestas planas, por nombre de usuario';
$string['modeflatlastname'] = 'Mostrar respuestas planas, por apellido de usuario';
$string['modeflatnewestfirst'] = 'Mostrar respuestas planas, con las más nuevas primero';
$string['modeflatoldestfirst'] = 'Mostrar respuestas en forma plana, las más antiguas primero';
$string['modenested'] = 'Mostrar respuestas en forma anidada';
$string['modethreaded'] = 'Mostrar respuestas en forma de hilo';
$string['modulename'] = 'Open Forum (Foro Abierto)';
$string['modulename_help'] = 'El módulo de actividad Foro abierto permite a los participantes tener discusiones asincrónicas, es decir, discusiones que se llevan a cabo durante un período prolongado de tiempo.

Hay varios tipos de foros para elegir, como un foro estándar donde cualquiera puede iniciar una nueva discusión en cualquier momento; un foro donde cada estudiante puede publicar exactamente una discusión; o un foro de preguntas y respuestas donde los estudiantes deben publicar primero antes de poder ver las publicaciones de otros estudiantes. Un profesor puede permitir que se adjunten archivos a las publicaciones del foro. Las imágenes adjuntas se muestran en la publicación del foro.

Los participantes pueden suscribirse a un foro para recibir notificaciones de nuevas publicaciones en el foro. Un profesor puede configurar el modo de suscripción como opcional, forzado o automático, o evitar la suscripción por completo. Si es necesario, se puede bloquear a los estudiantes para que no publiquen más de una cantidad determinada de publicaciones en un período de tiempo determinado; esto puede evitar que las personas dominen las discusiones.

Las publicaciones del foro pueden ser calificadas por profesores o estudiantes (evaluación de pares). Las calificaciones se pueden agregar para formar una calificación final que se registra en el libro de calificaciones.

Los foros tienen muchos usos, como por ejemplo:

* Un espacio social para que los estudiantes se conozcan
* Para anuncios de cursos (utilizando un foro de noticias con suscripción obligatoria)
* Para debatir el contenido del curso o leer materiales
* Para continuar en línea un tema planteado previamente en una sesión presencial
* Para debates solo entre profesores (utilizando un foro oculto)
* Un centro de ayuda donde los tutores y los estudiantes pueden dar consejos
* Un área de apoyo individual para comunicaciones privadas entre estudiantes y profesores (utilizando un foro con grupos separados y con un estudiante por grupo)
* Para actividades de extensión, por ejemplo, "acertijos" para que los estudiantes reflexionen y sugieran soluciones';
$string['modulename_link'] = 'mod/hsuforum/view';
$string['modulenameplural'] = 'Open Forums (Foros Abiertos)';
$string['more'] = 'más';
$string['movedmarker'] = '(Movido)';
$string['movethisdiscussionto'] = 'Mover esta discusión a ...';
$string['mustprovidediscussionorpost'] = 'Debe proporcionar una identificación de discusión o una identificación de publicación para exportar';
$string['myprofileotherdis'] = 'Discusiones de Open Forum';
$string['myprofileotherpost'] = 'Publicaciones de Open Forum';
$string['myprofileowndis'] = 'Mis discusiones de Open Forum';
$string['myprofileownpost'] = 'Mis publicaciones de Open Forum';
$string['namenews'] = 'Anuncios';
$string['namenews_help'] = 'El foro de Anuncios del curso es un foro especial para anuncios y es creado automáticamente cuando se crea un curso. Un curso solamente puede tener un solo foro de Novedades. Solamente los profesores y administradores pueden publicar en el foro de Novedades. El bloque de ""Últimas noticias" mostrará anuncios recientes.';
$string['namesocial'] = 'Foro social';
$string['nested'] = 'Anidado';
$string['newforumposts'] = 'Publicaciones recientes del foro';
$string['nextdiscussion'] = 'Discusiones más nuevas';
$string['nextdiscussionx'] = '({$a}) Siguiente>';
$string['noattachments'] = 'No hay anexos a esta publicación';
$string['nodiscussionsstartedby'] = '{$a} no ha iniciado ninguna discusión';
$string['nodiscussionsstartedbyyou'] = 'Usted aun no ha iniciado ninguna discusión';
$string['noguestpost'] = 'Lo sentimos; los invitados no tienen permitido publicar.';
$string['noguesttracking'] = 'Lo sentimos; los invitados no tienen permitido configurar opciones de monitoreo.';
$string['nomorepostscontaining'] = 'No se encontraron más publicaciones que contengan \'{$a}\'';
$string['nonanonymous'] = 'No anónimamente';
$string['nonews'] = 'Aun no se han publicado anuncios.';
$string['noonecansubscribenow'] = 'Ahora las suscripciones están deshabilitadas';
$string['nopermissiontosubscribe'] = 'Usted no tiene permiso para ver suscriptores del foro';
$string['nopermissiontoview'] = 'Usted no tiene permiso para ver esta publicación';
$string['nopostforum'] = 'Lo sentimos; usted no tiene permiso para publicar a este foro';
$string['noposts'] = 'Sin publicaciones';
$string['nopostsmadebyuser'] = '{$a} no ha hecho ninguna  publicación';
$string['nopostsmadebyyou'] = 'Usted no ha hecho ninguna  publicación';
$string['nosubscribers'] = 'Aun no hay suscriptores para este foro';
$string['notexists'] = 'Ya no existe la discusión';
$string['nothingnew'] = 'Nada nuevo para {$a}';
$string['notingroup'] = 'Lo sentimos, pero usted necesita ser parte de un grupo para ver este foro.';
$string['notinstalled'] = 'El módulo de foro no está instalado';
$string['notpartofdiscussion'] = 'Esta publicación no es parte de una discusión';
$string['notrackforum'] = 'No monitorear publicaciones no leídas';
$string['notuploadedfile'] = 'Hubo un problema al subir su archivo; por favor inténtelo nuevamente';
$string['noviewdiscussionspermission'] = 'Usted no tiene permiso para ver discusiones en este foro';
$string['nowallsubscribed'] = 'Ahora usted está suscrito a todos los foros en {$a}.';
$string['nowallunsubscribed'] = 'Ahora usted está des-suscrito de todos los foros en {$a}.';
$string['nownotsubscribed'] = '{$a->name} NO será notificado acerca de nuevas publicaciones en \'{$a->forum}\'';
$string['nownottracking'] = '{$a->name} ya no está monitoreando \'{$a->forum}\'.';
$string['nowsubscribed'] = '{$a->name} será notificado acerca de nuevas publicaciones en \'{$a->forum}\'';
$string['nowtracking'] = '{$a->name} ahora está monitoreando \'{$a->forum}\'.';
$string['numposts'] = '{$a} publicaciones';
$string['olderdiscussions'] = 'Discusiones más antiguas';
$string['oldertopics'] = 'Asuntos más antiguos';
$string['oldpostdays'] = 'Leer después de días';
$string['onediscussion'] = '1 discusión';
$string['onereply'] = '1 respuesta';
$string['openmode0'] = 'Sin discusiones, sin respuestas';
$string['openmode1'] = 'Sin discusiones, pero las respuestas están permitidad';
$string['openmode2'] = 'Las discusiones y respuestas están permitidas';
$string['options'] = 'Opciones';
$string['orderdiscussionsby'] = 'Ordenar por';
$string['overviewnumpostssince'] = '{$a} publicaciones desde el último ingreso';
$string['overviewnumunread'] = '{$a} total sin leer';
$string['page-mod-hsuforum-discuss'] = 'Página del hilo de discusión del módulo Foro';
$string['page-mod-hsuforum-view'] = 'Página principal de módulo Foro';
$string['page-mod-hsuforum-x'] = 'Cualquier página de módulo Foro';
$string['parent'] = 'Mostrar padre';
$string['parentofthispost'] = 'Padre de esta publicación';
$string['participants'] = 'Participantes';
$string['plaintext'] = 'Texto simple';
$string['pluginadministration'] = 'Adm,inistración del foro';
$string['pluginname'] = 'Open Forum (Foro Abierto)';
$string['postadded'] = '<p>Su publicación fue exitosamente añadida.</p> <p>Usted tiene {$a} para editarla por si quisiera hacerle algún cambio.</p>';
$string['postaddedsuccess'] = 'Su publicación fue añadida exitosamente';
$string['postaddedtimeleft'] = 'Usted tiene {$a} para editar por si quisiera hacer algún cambio.';
$string['postbymailsuccess'] = 'Felicitaciones; su publicación del foro con el asunto "{$a->subject}" fue exitosamente añadida. Puede verla en {$a->discussionurl}.';
$string['postbymailsuccess_html'] = 'Felicitaciones; su  publicación en foro <a href="{$a->discussionurl}"> </a> con el asunto de "{$a->subject}" fue exitosamente publicada.';
$string['postbyuser'] = '{$a->post} por {$a->user}';
$string['postbyx'] = 'Publicación por {$a}';
$string['postbyxinprivatereplytox'] = 'Contestación privada a {$a->parent} de parte de {$a->author}';
$string['postbyxinreplytox'] = '{$a->parentpost} Contestación a {$a->parent} de parte de {$a->author}';
$string['postcreated'] = 'Publicación creada';
$string['postdeleted'] = 'Publicación eliminada';
$string['postincontext'] = 'Ver esta publicación en contexto';
$string['postmailinfolink'] = 'Esta es una copia de un mensaje publicado en {$a->coursename}.

Para responder, haga clic en este enlace: {$a->replylink}';
$string['postmailnow'] = '<p>Esta publicación se enviará inmediatamente a todos los suscriptores del foro.</p>';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postoptions'] = 'Publicar opiniones';
$string['postrating1'] = 'Principalmente conocimiento separado';
$string['postrating2'] = 'Separado y conectado';
$string['postrating3'] = 'Principalmente conocimiento conectado';
$string['posts'] = 'Publicaciones';
$string['postsfor'] = 'Publicaciones para';
$string['postsmadebyuser'] = 'Publicaciones hechas por {$a}';
$string['postsmadebyuserincourse'] = 'Publicaciones hechas por {$a->fullname} en {$a->coursename}';
$string['posttoforum'] = 'Publicar al foro';
$string['posttomygroups'] = 'Publicar una copia a todos los grupos';
$string['posttomygroups_help'] = 'Publica una copia de este mensaje en todos los grupos a los que tienes acceso. Los participantes de los grupos a los que no tienes acceso no verán esta publicación.';
$string['postupdated'] = 'Su publicación fue actualizada';
$string['postwasupdated'] = 'La publicación fue actualizada';
$string['potentialsubscribers'] = 'Suscriptores potenciales';
$string['prevdiscussionx'] = '< Anterior ({$a})';
$string['previousdiscussion'] = 'Discusión más antigua';
$string['print'] = 'Imprimir';
$string['privacy:digesttypepreference'] = 'Ha elegido recibir el siguiente tipo de resumen del foro: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Ha elegido la siguiente preferencia de suscripción a la discusión para este foro: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'El Foro Abierto utiliza el subsistema de calificación para respaldar la calificación de las publicaciones.';
$string['privacy:metadata:core_tag'] = 'El Foro Abierto utiliza el subsistema de etiquetas para respaldar el etiquetado de publicaciones.';
$string['privacy:metadata:hsuforum_digests'] = 'Información sobre las preferencias de resumen para cada Foro Abierto.';
$string['privacy:metadata:hsuforum_digests:hsuforum'] = 'El Foro Abierto está suscrito a.';
$string['privacy:metadata:hsuforum_digests:maildigest'] = 'La preferencia del resumen';
$string['privacy:metadata:hsuforum_digests:userid'] = 'El ID del usuario con la preferencia de resumen.';
$string['privacy:metadata:hsuforum_discussions'] = 'Información sobre las discusiones individuales del foro que un usuario ha creado.';
$string['privacy:metadata:hsuforum_discussions:assessed'] = 'Tipo de calificación para la discusión';
$string['privacy:metadata:hsuforum_discussions:name'] = 'El nombre de la discusión, elegido por el autor.';
$string['privacy:metadata:hsuforum_discussions:timemodified'] = 'La hora en que se modificó la discusión por última vez.';
$string['privacy:metadata:hsuforum_discussions:userid'] = 'El ID del usuario que creó la discusión.';
$string['privacy:metadata:hsuforum_discussions:usermodified'] = 'El ID del usuario que modificó la discusión por última vez de alguna manera.';
$string['privacy:metadata:hsuforum_posts'] = 'Información sobre las preferencias de resumen para cada Foro Abierto.';
$string['privacy:metadata:hsuforum_posts:created'] = 'La hora en que se creó la publicación.';
$string['privacy:metadata:hsuforum_posts:discussion'] = 'La discusión en la que se encuentra el post.';
$string['privacy:metadata:hsuforum_posts:message'] = 'El mensaje de la publicación del Foro Abierto.';
$string['privacy:metadata:hsuforum_posts:modified'] = 'La hora en que se modificó la publicación por última vez.';
$string['privacy:metadata:hsuforum_posts:parent'] = 'La publicación principal a la que se respondió.';
$string['privacy:metadata:hsuforum_posts:subject'] = 'El tema de la publicación del Foro Abierto.';
$string['privacy:metadata:hsuforum_posts:userid'] = 'El ID del usuario que creó la publicación en el Foro Abierto.';
$string['privacy:metadata:hsuforum_queue'] = 'Información para realizar un seguimiento de las publicaciones que se enviarán por correo.';
$string['privacy:metadata:hsuforum_queue:discussionid'] = 'El ID de la discusión.';
$string['privacy:metadata:hsuforum_queue:postid'] = 'El ID de la publicación.';
$string['privacy:metadata:hsuforum_queue:timemodified'] = 'La hora modificada de la publicación original.';
$string['privacy:metadata:hsuforum_queue:userid'] = 'El ID del usuario que va a ser notificado.';
$string['privacy:metadata:hsuforum_read'] = 'Información sobre qué publicaciones han sido leídas por el usuario.';
$string['privacy:metadata:hsuforum_read:discussionid'] = 'La discusión en la que se encuentra la publicación.';
$string['privacy:metadata:hsuforum_read:firstread'] = 'La primera vez que se leyó la publicación.';
$string['privacy:metadata:hsuforum_read:lastread'] = 'La hora más reciente en que se leyó la publicación.';
$string['privacy:metadata:hsuforum_read:postid'] = 'La publicación que fue leída.';
$string['privacy:metadata:hsuforum_read:userid'] = 'El ID del usuario al que se relaciona este registro.';
$string['privacy:metadata:hsuforum_subscriptions'] = 'Información sobre a qué foros abiertos se ha suscrito el usuario.';
$string['privacy:metadata:hsuforum_subscriptions:forum'] = 'El foro al que se suscribió.';
$string['privacy:metadata:hsuforum_subscriptions:userid'] = 'El ID del usuario al que se relaciona esta suscripción del Foro Abierto.';
$string['privacy:metadata:hsuforum_subscriptions_disc'] = 'Información sobre las suscripciones a discusiones individuales del Foro Abierto.';
$string['privacy:metadata:hsuforum_subscriptions_disc:discussion'] = 'El ID de la discusión a la que se suscribió.';
$string['privacy:metadata:hsuforum_subscriptions_disc:userid'] = 'El ID del usuario con la suscripción a la discusión.';
$string['privacy:metadata:hsuforum_track_prefs'] = 'Información sobre qué foros ha elegido el usuario para realizar un seguimiento de las lecturas de publicaciones.';
$string['privacy:metadata:hsuforum_track_prefs:forumid'] = 'El Foro Abierto que tiene habilitado el seguimiento de lectura.';
$string['privacy:metadata:hsuforum_track_prefs:userid'] = 'El ID del usuario al que se relaciona esta preferencia de seguimiento de Open Forum.';
$string['privacy:metadata:preference:autosubscribe'] = 'Si desea o no suscribirse a las discusiones al responder a las publicaciones dentro de ellas.';
$string['privacy:metadata:preference:maildigest'] = 'La preferencia para todo el sitio de resumen de Email.';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Si desea marcar las publicaciones del foro como leídas al recibirlas como mensajes.';
$string['privacy:metadata:preference:trackforums'] = 'Si es que se habilita o no el monitoreo de lectura';
$string['privacy:postwasread'] = 'Esta publicación se leyó por primera vez en {$a->firstread} y se leyó más recientemente en {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Ha elegido no realizar un seguimiento de las publicaciones que ha leído en este foro.';
$string['privacy:request:delete:discussion:name'] = 'Eliminar a solicitud del autor';
$string['privacy:request:delete:post:message'] = 'El contenido de esta publicación ha sido eliminado a solicitud de su autor.';
$string['privacy:request:delete:post:subject'] = 'Eliminar a solicitud del autor';
$string['privacy:subscribedtoforum'] = 'Usted está suscrito a este foro.';
$string['privatereplies'] = 'Permitir respuestas privadas';
$string['privatereplies_help'] = 'Con esta función, los instructores pueden enviar una respuesta privada a una publicación del foro. Esta respuesta solo la puede ver el estudiante que realizó la publicación o la respuesta original y es invisible para el resto de los estudiantes.';
$string['privaterepliesdisabledglobally'] = 'Las respuestas privadas han sido deshabilitadas globalmente.';
$string['privatereply'] = 'Respuesta privada';
$string['privatereply_help'] = 'Si marca esta casilla, esta publicación solo será visible para el usuario al que le está respondiendo. Además, nadie podrá responder a esta publicación.';
$string['privatereplybyx'] = 'Respuesta privada por {$a}';
$string['processingdigest'] = 'Procesando resumen de Email para usuario {$a}';
$string['processingpost'] = 'Procesando publicaciónt {$a}';
$string['prune'] = 'Dividir';
$string['prunedpost'] = 'Se ha creado una nueva discusión a partir de esa publicación.';
$string['pruneheading'] = 'Dividir la discusión y mover esta publicación a una nueva discusión';
$string['qandaforum'] = 'Foro de Preguntas y Respuestas';
$string['qandanotify'] = 'Este es un foro de preguntas y respuestas. Para ver otras respuestas a estas preguntas, primero debes publicar tu respuesta.';
$string['readtherest'] = 'Leer el resto de este tópico';
$string['removeallforumtags'] = 'Eliminar todas las etiquetas del foro';
$string['replies'] = 'Contestaciones';
$string['repliesmany'] = '{$a} contestaciones hasta ahora';
$string['repliesone'] = '{$a} contestación hasta ahora';
$string['repliesx'] = 'Contestaciones: {$a}';
$string['reply'] = 'Responder';
$string['reply_handler'] = 'Responder a las publicaciones del Foro Abierto por correo electrónico';
$string['reply_handler_name'] = 'Respuesta a publicaciones Open Forum';
$string['replybuttontitle'] = 'Respuesta a {$a}';
$string['replybyx'] = 'Respuesta por {$a}';
$string['replyforum'] = 'Responder al foro';
$string['replytopostbyemail'] = 'Usted puede responder a esto vía email.';
$string['replytouser'] = 'Usar dirección Email en respuesta';
$string['replytox'] = 'Responder a {$a}';
$string['resetdigests'] = 'Eliminar todas las preferencias de resumen del foro por usuario';
$string['resetforums'] = 'Eliminar publicaciones de';
$string['resetforumsall'] = 'Eliminar todas las publicaciones';
$string['resetsubscriptions'] = 'Eliminar todas las suscripciones al foro';
$string['resettrackprefs'] = 'Eliminar todas las preferencias de seguimiento del foro';
$string['reveal'] = 'Revelarse usted mismo en este post';
$string['reveal_help'] = 'Si está marcada, su nombre se mostrará en la publicación y ya no será anónimo.';
$string['rssarticles'] = 'Número de artículos recientes de RSS';
$string['rssarticles_help'] = 'Esta configuración especifica la cantidad de artículos (ya sean discusiones o publicaciones) que se incluirán en la fuente RSS. Generalmente, se aceptan entre 5 y 20.';
$string['rsssubscriberssdiscussions'] = 'Canal RSS de discusiones';
$string['rsssubscriberssposts'] = 'Canal RSS de publicaciones';
$string['rsstype'] = 'Canal RSS de esta actividad';
$string['rsstype_help'] = 'Para habilitar la fuente RSS para esta actividad, seleccione las discusiones o publicaciones que desea incluir en la fuente.';
$string['rsstypedefault'] = 'Tipo de fuente RSS';
$string['search'] = 'Buscar';
$string['search:activity'] = 'Foro abierto - información de actividad';
$string['search:post'] = 'Foro abierto - publicaciones';
$string['searchdatefrom'] = 'Las publicaciones deben ser más recientes que esto';
$string['searchdateto'] = 'Las publicaciones deben ser más antiguas que esto';
$string['searchforumintro'] = 'Por favor escriba los términos de la búsqueda en uno o más de los campos siguientes:';
$string['searchforums'] = 'Buscar';
$string['searchfullwords'] = 'Estas palabras deberían aparecer como palabras completas';
$string['searchnotwords'] = 'Estas palabras NO DEBERÍAN estar incluidas';
$string['searcholderposts'] = 'Buscar publicaciones más antiguas...';
$string['searchphrase'] = 'Esta frase exacta debe aparecer en la publicación';
$string['searchresults'] = 'Resultados de la búsqueda';
$string['searchsubject'] = 'Estas palabras deberían estar en el asunto';
$string['searchtags'] = 'Está etiquetado con';
$string['searchuser'] = 'El nombre debería coincidir con el autor';
$string['searchuserid'] = 'La ID Moodle del autor';
$string['searchwhichforums'] = 'elegir cuales foros buscar';
$string['searchwords'] = 'Estas palabras pueden aparecer en cualquier lugar en la publicación';
$string['seeallposts'] = 'Ver todas la publicaciones hechas por este usuario';
$string['shortpost'] = 'Publicación corta';
$string['showbookmark'] = 'Permitir marcar publicaciones como favoritas';
$string['showbookmark_help'] = 'Si está habilitado, las publicaciones del foro se pueden marcar como favoritas.';
$string['showbookmarkdisabledglobally'] = 'Los marcadores se han deshabilitado globalmente a nivel del plugin.';
$string['showdiscussionsubscribers'] = 'Mostrar/editar suscriptores a discusión';
$string['showrecent'] = 'Mostrar publicaciones recientes en página del curso';
$string['showrecent_help'] = 'Si está habilitado, esto mostrará publicaciones recientes en la página del curso.';
$string['showsubscribers'] = 'Mostrar editar suscriptores al foro';
$string['showsubstantive'] = 'Permitir marcar como sustantiva';
$string['showsubstantive_help'] = 'Si está habilitada, esta función permite a los instructores marcar publicaciones que tienen un valor sustancial.';
$string['showsubstantivedisabledglobally'] = 'La señalización sustantiva se ha deshabilitado globalmente a nivel del plugin.';
$string['singleforum'] = 'Una discusión única simple';
$string['smallmessage'] = '{$a->user} publicó en {$a->forumname}';
$string['smallmessagedigest'] = 'Resumen del foro que contiene {$a} mensajes';
$string['sortdiscussions'] = 'Ordenar discusiones';
$string['sortdiscussionsby'] = 'Ordenar';
$string['sortdiscussionsbysronlytext'] = 'Al activar el botón de clasificación se actualizará el contenido de la página.';
$string['splitprivatewarning'] = 'Usted está dividiendo una respuesta privada. después de dividirla, esta publicación ya no será privada.';
$string['startedby'] = 'Iniciado por';
$string['startedbyx'] = 'Iniciado por {$a}';
$string['startedbyxgroupx'] = 'Iniciado por {$a->name} para grupo {$a->group}';
$string['subject'] = 'Asunto';
$string['subjectbyprivateuserondate'] = '{$a->subject} (private) por {$a->author} en {$a->date}';
$string['subjectbyuserondate'] = '{$a->subject} by {$a->author} en {$a->date}';
$string['subjectisrequired'] = 'Se necesita Asunto';
$string['subjectplaceholder'] = 'Su asunto';
$string['submit'] = 'Enviar';
$string['subscribe'] = 'Suscribirse a este foro';
$string['subscribeall'] = 'Suscribir a todos a este foro';
$string['subscribed'] = 'Suscrito';
$string['subscribedisc'] = 'Suscribirse a esta discusión';
$string['subscribeenrolledonly'] = 'Lo sentimos, sólo los usuarios registrados pueden suscribirse a las notificaciones de publicaciones del foro.';
$string['subscribenone'] = 'Des-suscribir a todos de este foro';
$string['subscribers'] = 'Suscriptores';
$string['subscriberstowithcount'] = 'Suscriptores a "{$a->name}" ({$a->count})';
$string['subscribeshort'] = 'Suscribir';
$string['subscribestart'] = 'Enviarme notificaciones de nuevas publicaciones en este foro';
$string['subscribestop'] = 'No quiero recibir notificaciones de nuevas publicaciones en este foro.';
$string['subscription'] = 'Suscripción';
$string['subscription_help'] = 'Si estás suscrito a un foro, significa que recibirás notificaciones de nuevas publicaciones en el foro. Por lo general, puedes elegir si deseas estar suscrito, aunque a veces la suscripción es obligatoria para que todos reciban notificaciones.';
$string['subscriptionauto'] = 'Auto suscripción';
$string['subscriptiondisabled'] = 'Suscripción deshabilitada';
$string['subscriptionforced'] = 'Suscripción forzosa';
$string['subscriptionmode'] = 'Modo de suscripción';
$string['subscriptionmode_help'] = 'Cuando un participante está suscrito a un foro, significa que recibirá notificaciones de publicaciones en el foro. Hay 4 opciones de modo de suscripción:

* Suscripción opcional: los participantes pueden elegir si desean suscribirse
* Suscripción forzada: todos están suscritos y no pueden cancelar la suscripción
* Suscripción automática: todos están suscritos inicialmente, pero pueden optar por cancelar la suscripción en cualquier momento
* Suscripción deshabilitada: no se permiten las suscripciones';
$string['subscriptionoptional'] = 'Suscripción opcional';
$string['subscriptions'] = 'Suscripciones';
$string['substantive'] = 'Sustantiva';
$string['switchtoaccessible'] = 'Cambiar a la vista accesible';
$string['tagarea_hsuforum_posts'] = 'Publicaciones en foro';
$string['tagsdeleted'] = 'Se han eliminado las etiquetas del foro';
$string['thisforumisthrottled'] = 'Este foro tiene un límite en la cantidad de publicaciones que puedes hacer en un período de tiempo determinado; actualmente está establecido en {$a->blockafter} publicación(es) en {$a->blockperiod}';
$string['thisisanonymous'] = 'Este foro es anónimo';
$string['timedhidden'] = 'Estado cronometrado: Oculto de los estudiantes';
$string['timedposts'] = 'Publicaciones cronometradas';
$string['timedvisible'] = 'Estado cronometrado: visible para todos los usuarios';
$string['timestartenderror'] = 'La fecha de finalización de la visualización no puede ser anterior a la fecha de inicio';
$string['toggle:bookmark'] = 'Marcador';
$string['toggle:subscribe'] = 'Suscribir';
$string['toggle:substantive'] = 'Sustantiva';
$string['toggled:bookmark'] = 'Marcado';
$string['toggled:subscribe'] = 'Suscrito';
$string['toggled:substantive'] = 'Marcada Sustantiva';
$string['totaldiscussions'] = 'Publicaciones: {$a}';
$string['totalposts'] = 'Total de publicaciones';
$string['totalpostsanddiscussions'] = 'Total de publicaciones: {$a}';
$string['totalrating'] = 'Valoración: {$a}';
$string['totalreplies'] = 'Respuestas: {$a}';
$string['totalsubstantive'] = 'Publicaciones Sustantivas: {$a}';
$string['trackforum'] = 'Monitorear publicaciones no leídas';
$string['trackingoptions'] = 'Opciones de monitoreo';
$string['trackreadposts_header'] = 'Monitoreo del foro';
$string['tree'] = 'Árbol';
$string['unread'] = 'Nuevo';
$string['unreadposts'] = 'Publicaciones sin leer';
$string['unreadpostsnumber'] = '{$a} publicaciones sin leer';
$string['unreadpostsone'] = '1 publicación sin leer';
$string['unreadx'] = 'Sin leer: {$a}';
$string['unsubscribe'] = 'Des-suscribir de este foro';
$string['unsubscribeall'] = 'Des-suscribir de todos los foros';
$string['unsubscribeallconfirm'] = 'Ahora usted está suscrito a los foros de {$a}. ¿Realmente desea cancelar la suscripción a todos los foros y desactivar la suscripción automática a los foros?';
$string['unsubscribealldone'] = 'Se eliminaron todas las suscripciones opcionales a los foros. Usted seguirá recibiendo notificaciones de los foros con suscripción obligatoria. Para administrar las notificaciones de los foros, vaya a Mensajería en la configuración de Mi perfil.';
$string['unsubscribeallempty'] = 'Usted no está suscrito a ningún foro. Para desactivar todas las notificaciones de este servidor, vaya a Mensajería en la configuración de Mi perfil.';
$string['unsubscribed'] = 'Des-suscrito';
$string['unsubscribedisc'] = 'Des-suscribirse a esta discusión';
$string['unsubscribediscussion'] = 'Des-suscribirse de esta discusión';
$string['unsubscribediscussionlink'] = 'Des-suscribirse de esta discusión: {$a}';
$string['unsubscribelink'] = 'Des-suscribirse de este foro: {$a}';
$string['unsubscribeshort'] = 'Des-suscribir';
$string['useadvancededitor'] = 'Usar editor avanzado y opciones adicionales';
$string['userdateformat'] = '%l:%M%P %b %e, %Y';
$string['usermarksread'] = 'Marcado de lectura de mensajes manuales';
$string['validationerrorsx'] = 'Hubo {$a->count} errores con su envío: {$a->errors}';
$string['validationerrorx'] = 'Hubo un error con su envío: {$a}';
$string['viewalldiscussions'] = 'Ver todas las discusiones';
$string['viewposters'] = 'Ver publicadores';
$string['viewthediscussion'] = 'Ver la discusión';
$string['warnafter'] = 'Publicar umbralpara advertencia';
$string['warnafter_help'] = 'Los estudiantes pueden ser advertidos conforme se acercan al número máximo de publicaciones permitidas en un período dado. Esta configuración especifica después de cuantas publicaciones ellos son advertidos. Los usuarios con la capacidad  mod/hsuforum:postwithoutthrottling están exentos de esos límites d epublicaciones.';
$string['warnformorepost'] = '¡Advertencia! Hay más de una discusión en este foro - usando la más reciente';
$string['xdiscussions'] = '{$a} discusiones';
$string['xreplies'] = '{$a} respuestas';
$string['xunread'] = '{$a} nuevos';
$string['yournewquestion'] = 'Su nueva pregunta';
$string['yournewtopic'] = 'Su nuevo tópico de discusión';
$string['yourreply'] = 'Su respuesta';
