<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'uk', version '4.1'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'ЗРОБИТИ';
$string['activityisscheduledfordeletion'] = 'Видалення триває...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" не є дійсним значенням для віку.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" має більше або менше одного роздільника коми.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" не є дійсним значенням для країни.';
$string['agedigitalconsentmapinvaliddefault'] = 'Значення за замовчуванням (*) відсутнє.';
$string['agelocationverificationdisabled'] = 'Перевірку віку та місцезнаходження вимкнено';
$string['alreadyloggedin'] = 'Ви вже ввійшли як {$a},  потрібно спочатку вийти, щоб увійти під іншим ім’ям.';
$string['authnotexisting'] = 'Модуль авторизації не існує';
$string['backupcontainexternal'] = 'Цей резервний файл містить зовнішні Moodle Мережеві вузли, які не налаштовані локально';
$string['backuptablefail'] = 'Резервне копіювання таблиць НЕ вдалося створити успішно!';
$string['blockcannotconfig'] = 'Цей блок не підтримує глобальну конфігурацію';
$string['blockcannotinistantiate'] = 'Проблема в елементі об’єкту блок';
$string['blockcannotread'] = 'Не вдається прочитати дані для blockid= {$a}';
$string['blockdoesnotexist'] = 'Цього блоку не існує';
$string['blockdoesnotexistonpage'] = 'Цього блоку (id={$a->instanceid}) не існує на цій сторінці ({$a->url}).';
$string['blocknameconflict'] = 'Конфлікт імен: блок {$a->name} має однакову назву із зовнішнім блоком: {$a->conflict}!';
$string['callbackrejectcomment'] = 'Зворотній коментар відмінив цей коментар';
$string['cannotaddcoursemodule'] = 'Не вдалося додати новий модуль курсу';
$string['cannotaddcoursemoduletosection'] = 'Не вдалося додати новий модуль курсу до цієї секції';
$string['cannotaddmodule'] = '{$a}  модуль не може бути включеним до списку модулів!';
$string['cannotaddnewmodule'] = 'Не вдалося додати новий модуль {$a}';
$string['cannotaddrss'] = 'У вас немає дозволу на додавання RSS-каналів';
$string['cannotaddthisblocktype'] = 'Ви не можете додати блок {$a} на цю сторінку.';
$string['cannotassignrole'] = 'Не вдається призначити роль в курсі';
$string['cannotassignrolehere'] = 'Вам не дозволено призначати цю роль (id = {$a->roleid}) в цьому контексті ({$a->context})';
$string['cannotassignselfasparent'] = 'Не можна призначити себе як батька!';
$string['cannotcallscript'] = 'Ви не можете викликати цей скрипт таким чином';
$string['cannotcallusgetselecteduser'] = 'Ви не можете викликати user_selector::get_selected_user, якщо включено множинний вибір.';
$string['cannotcreatebackupdir'] = 'Не створюється каталог backupdata. Потрібен адміністратор сайту, щоб підправити права доступу до файлів.';
$string['cannotcreatecategory'] = 'Категорія не вставлена';
$string['cannotcreatedboninstall'] = '<p>Не вдається створити базу даних.</p> <p>Вказаної бази даних не існує і такий користувач не має права на створення бази даних.</p> <p>Адміністратор сайту повинен перевірити налаштування бази даних.</p>';
$string['cannotcreategroup'] = 'Помилка створення групи';
$string['cannotcreatelangbase'] = 'Помилка: не створюється каталог базової мови';
$string['cannotcreatelangdir'] = 'Не створюється каталог lang';
$string['cannotcreateorfindstructs'] = 'Помилка пошуку або створення секційної структури в цьому курсі';
$string['cannotcreatepopupwin'] = 'Невизначений елемент - не створюється спливаюче вікно';
$string['cannotcreatesitedir'] = 'Не вдається створити каталог сайту. Адміністратор сайту повинен виправити права доступу до файлів.';
$string['cannotcreatetempdir'] = 'Не можу створити каталог temp';
$string['cannotcreateuploaddir'] = 'Не вдається створити каталог upload. Адміністратор сайту повинен виправити права доступу до файлів.';
$string['cannotcustomisefiltersblockuser'] = 'Ви не можете змінювати налаштування фільтрів у опціях користувача або в контекстах блоку.';
$string['cannotdeletebackupids'] = 'Не вдалося видалити ідентифікатор попередньої резервної копії';
$string['cannotdeletecategorycourse'] = 'Курс \'{$a}\'  не видалено.';
$string['cannotdeletecategoryquestions'] = 'Не видаляються питання з категорії \'{$a}';
$string['cannotdeletecourse'] = 'У вас немає прав для видалення цього курсу';
$string['cannotdeletecustomfield'] = 'Помилка видалення даних користувацького поля';
$string['cannotdeletedir'] = 'Не видаляється ({$a})';
$string['cannotdeletefile'] = 'Не вдається видалити цей файл';
$string['cannotdeleterole'] = 'Це не може бути видалено, оскільки {$a}';
$string['cannotdeleterolewithid'] = 'Не вдається видалити роль з кодом {$a}';
$string['cannotdeletethisrole'] = 'Ви не можете видаляти цю роль, оскільки вона використовується системою, або через те, що це остання роль з можливостями адміністратора.';
$string['cannotdisableformat'] = 'Формат за замовчуванням не можна вимкнути.';
$string['cannotdownloadcomponents'] = 'Не можу завантажити компоненти.';
$string['cannotdownloadlanguageupdatelist'] = 'Не вдається завантажити список мовних пакетів з download.moodle.org';
$string['cannotdownloadzipfile'] = 'Не можу завантажити ZIP-файл.';
$string['cannoteditcomment'] = 'Цей коментар не ваш, щоб змінювати!';
$string['cannoteditcommentexpired'] = 'Ви не можете це змінювати. Час минув!';
$string['cannoteditpostorblog'] = 'Ви не можете писати або редагувати блоги';
$string['cannoteditsiteform'] = 'Ви не можете редагувати сайт курсу за допомогою цієї форми';
$string['cannotedituserpreferences'] = 'Не можна редагувати параметри цього користувача';
$string['cannotedityourprofile'] = 'Вибачте, але ви не можете редагувати свій профіль';
$string['cannotexecduringupgrade'] = 'Не можна виконати під час оновлення';
$string['cannotfindcategory'] = 'Не вдається знайти категорію запису з бази даних по ID - {$a}';
$string['cannotfindcomponent'] = 'Не можу знайти компоненти.';
$string['cannotfindcontext'] = 'Не можу знайти контекст';
$string['cannotfindcourse'] = 'Не можу знайти курс';
$string['cannotfinddocs'] = 'Не можу знайти файли документації для мови "{$a}"';
$string['cannotfindgradeitem'] = 'Не можу знайти елемент оцінювання';
$string['cannotfindgroup'] = 'Не вдалося знайти групу';
$string['cannotfindhelp'] = 'Не можу знайти файли допомоги  для мови "{$a}"';
$string['cannotfindinfo'] = 'Не можу знайти інформацію для: "{$a}"';
$string['cannotfindlang'] = 'Не можу знайти "{$a}" мовний пакет!';
$string['cannotfindteacher'] = 'Не можу знайти викладача';
$string['cannotfinduser'] = 'Не можу знайти користувача названого "{$a}"';
$string['cannotgeoplugin'] = 'Не вдається підключитися до сервера geoPlugin на https://www.geoplugin.com. Перевірте налаштування проксі або встановіть файл даних MaxMind GeoLite City.';
$string['cannotgetblock'] = 'Не вдалося відновити блоки з бази даних';
$string['cannotgetcats'] = 'Не можу отримати запис категорії';
$string['cannotgetdata'] = 'Не можу отримати дані';
$string['cannotgradeuser'] = 'Не можу оцінити цього користувача';
$string['cannothaveparentcate'] = 'Категорія курсу не має батьківської!';
$string['cannotimport'] = 'Помилка імпорту';
$string['cannotimportformat'] = 'На жаль, імпорт цього формату ще не реалізовано!';
$string['cannotimportgrade'] = 'Помилка імпорту балів';
$string['cannotinsertgrade'] = 'Не можу вставити елемент оцінки без коду курсу!';
$string['cannotinsertrate'] = 'Не вдалося вставити новий рейтинг ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'Не вставляється новий запис коду  {$a}';
$string['cannotmailconfirm'] = 'Помилка надсилання підтвердження зміни пароля';
$string['cannotmanualctrack'] = 'Діяльність не надає можливості вручну відслідковувати проходження';
$string['cannotmapfield'] = 'Виявлено зіткнення розміщень - двоє полів вміщують той же елемент оцінювання {$a}';
$string['cannotmarktopic'] = 'Не можу відмітити цю секцію в цьому курсі';
$string['cannotmigratedatacomments'] = 'Не можу перенести дані коментарів модуля';
$string['cannotmodulename'] = 'Не вдалося отримати ім\'я модуля для побудови навігації';
$string['cannotmoduletype'] = 'Не вдалося отримати тип модуля для побудови навігації';
$string['cannotmovecategory'] = 'Не вдається перемістити категорію';
$string['cannotmovecourses'] = 'Неможливо перемістити курси зі своєї категорії в іншу.';
$string['cannotmoverolewithid'] = 'Не вдалося перемістити роль з кодом {$a}';
$string['cannotopencsv'] = 'Не вдалося відкрити CSV-файл';
$string['cannotopenfile'] = 'Не вдалося відкрити файл ({$a})';
$string['cannotopenforwrit'] = 'Не вдалося відкрити для запису : {$a}';
$string['cannotopentemplate'] = 'Не вдалося відкрити тимчасовий файл ({$a})';
$string['cannotopenzip'] = 'Не вдається відкрити zip-файл, ймовірно, через помилку розширення zip у 64-розрядній ОС.';
$string['cannotoverridebaserole'] = 'Не вдалося перевизначити права основної ролі';
$string['cannotoverriderolehere'] = 'Вам не дозволяється перевизначати права цієї ролі (id = {$a->roleid}) в цьому контексті ({$a->context})';
$string['cannotreadfile'] = 'Не вдалося прочитати файл ({$a})';
$string['cannotreadtmpfile'] = 'Помилка читання тимчасового файлу';
$string['cannotreaduploadfile'] = 'Не вдалося прочитати завантажений файл';
$string['cannotremovefrommeta'] = 'Не вдалося видалити обраний курс з цього мета-курсу!';
$string['cannotreprocessgrades'] = 'Не вдається повторно опрацювати оцінки для діяльності  {$a}';
$string['cannotresetguestpwd'] = 'Ви не можете скинути пароль гостя';
$string['cannotresetmail'] = 'Помилка перевстановлення пароля та надсилання вам';
$string['cannotresetthisrole'] = 'Неможливо скинути цю роль';
$string['cannotrestore'] = 'Сталася помилка, і відновлення не може бути завершено!';
$string['cannotrestoreadminorcreator'] = 'Ви повинні бути автором курсів або користувачем з правами адміністратора для відновлення в новий курс!';
$string['cannotrestoreadminoredit'] = 'Ви повинні бути викладачем або користувачем з правами адміністратора для відновлення у вибраний курс!';
$string['cannotsaveagreement'] = 'Не вдалося зберегти ваше погодження';
$string['cannotsaveblock'] = 'Помилка збереження конфігурації блоку';
$string['cannotsavecomment'] = 'Не можу зберегти коментар';
$string['cannotsavedata'] = 'Не можу зберегти дані';
$string['cannotsavefile'] = 'Не можу зберегти файл "{$a}"!';
$string['cannotsavemd5file'] = 'Не можу зберегти md5-файл.';
$string['cannotsavezipfile'] = 'Не можу зберегти ZIP-файл.';
$string['cannotservefile'] = 'Неможливо обслуговувати файл через проблему конфігурації сервера.';
$string['cannotsetparentforcatoritem'] = 'Не можу встановити батьківську категорію для категорії або елементу курсу!';
$string['cannotsetpassword'] = 'Не можу встановити пароль користувачу!';
$string['cannotsetprefgrade'] = 'Не можу встановити параметри для позиції об’єднання {$a} в цій категорії оцінювання';
$string['cannotsettheme'] = 'Не можу встановити тему!';
$string['cannotsetupblock'] = 'Таблиці блоків не налаштовані потрібним чином!';
$string['cannotsetupcapformod'] = 'Не можу встановити властивості для {$a}';
$string['cannotsetupcapforplugin'] = 'Не можу встановити властивості для {$a}';
$string['cannotshowhidecoursesincategory'] = 'Не можу показати/приховати курси в категорії {$a}.';
$string['cannotsignup'] = 'Ви не можете створити новий обліковий запис, оскільки ви вже зайшли як {$a}.';
$string['cannotswitcheditmodeon'] = 'Не вдалося ввімкнути режим редагування';
$string['cannotunassigncap'] = 'Не вдалося скасувати застарілу властивість {$a->cap} з ролі {$a->role}';
$string['cannotunassignrolefrom'] = 'Не вдалося скасувати для цього користувача роль з кодом: {$a}';
$string['cannotunzipfile'] = 'Не можу розпакувати архівний файл.';
$string['cannotupdatemod'] = 'Не вдалося оновити {$a}';
$string['cannotupdatepasswordonextauth'] = 'Помилка оновлення пароля для зовнішньої реєстрації: {$a}. Перегляньте логи сервера для детальнішої інформації.';
$string['cannotupdateprofile'] = 'Помилка при оновленні запису користувача';
$string['cannotupdaterecord'] = 'Не вдається оновити запис з кодом {$a}';
$string['cannotupdaterss'] = 'Не можу оновити RSS';
$string['cannotupdatesubcourse'] = 'Не вдається оновити дочірній курс!';
$string['cannotupdateusermsgpref'] = 'Не можу оновити параметри повідомлення користувача';
$string['cannotupdateuseronexauth'] = 'Помилка оновлення даних для зовнішньої реєстрації: {$a}. Перегляньте логи сервера для детальнішої інформації.';
$string['cannotuploadfile'] = 'Помилка під час завантаження файлу';
$string['cannotuseadmin'] = 'Вам потрібно бути адміністратором, щоб використовувати цю сторінку';
$string['cannotuseadminadminorteacher'] = 'Вам потрібно бути викладачем або адміністратором, щоб використовувати цю сторінку';
$string['cannotusepage'] = 'Тільки викладачі або адміністратори можуть використовувати цю сторінку';
$string['cannotusepage2'] = 'Вибачте, але вам мабуть недозволено використовувати цю сторінку';
$string['cannotviewcategory'] = 'Ви не маєте дозволу на перегляд цього списку курсів.';
$string['cannotviewprofile'] = 'Ви не можете переглядати профіль цього користувача.';
$string['cannotviewreport'] = 'Ви не можете переглядати цей звіт';
$string['cannotwritefile'] = 'Не можу записати до файлу ({$a})';
$string['categoryerror'] = 'Помилка категорії';
$string['categoryidnumbertaken'] = 'Такий ідентифікатор вже використовується іншою категорією';
$string['categorynamerequired'] = 'Потрібно вказати назву категорії';
$string['categorytoolong'] = 'Назва категорії занадто довга';
$string['commentmisconf'] = 'Неправильний код коментаря';
$string['componentisuptodate'] = 'Компонент останньої редакції.';
$string['confirmationnotenabled'] = 'На цьому сайті не ввімкнено підтвердження користувача';
$string['confirmsesskeybad'] = 'Вибачте, але код вашої сесії не може бути підтвердженим. Ця особливість безпеки попереджає випадкове або навмисне виконання важливих функцій від вашого імені. Будь ласка, подумайте перед виконанням цієї функції.';
$string['contenttypenotfound'] = 'Тип банку вмісту "{$a}" не існує або не розпізнається.';
$string['contentvisibilitynotfound'] = 'Видимість вмісту зі значенням \'{$a}\' не існує або не розпізнається.';
$string['couldnotassignrole'] = 'При спробі призначити вам роль, виникла серйозна але не розпізнана помилка';
$string['couldnotupdatenoexistinguser'] = 'Не можу оновити користувача - оскільки такого користувача не існує';
$string['couldnotverifyagedigitalconsent'] = 'Під час спроби перевірити вік цифрової згоди сталася помилка. Зв’яжіться з адміністратором.';
$string['countriesphpempty'] = 'Помилка: Файл countries.php в мовному пакеті {$a} пустий або відсутній.';
$string['coursedoesnotbelongtocategory'] = 'Курс не належить до цієї категорії';
$string['courseformatnotfound'] = 'Формат курсу \'{$a}\' не існує або не розпізнається.';
$string['coursegroupunknown'] = 'Курс, який відповідає групі {$a}, не визначений';
$string['courseidnotfound'] = 'Ідентифікатор курсу не існує.';
$string['courseidnumbertaken'] = 'Такий код вже використовується для іншого курсу ({$a})';
$string['coursemisconf'] = 'Неправильний курс';
$string['courserequestdisabled'] = 'Вибачте, але запрошений курс був відключений адміністратором';
$string['csvcolumnduplicates'] = 'Знайдено дублювання колонок.';
$string['csvemptyfile'] = 'CSV-файл порожній.';
$string['csvfewcolumns'] = 'Недостатньо стовпців, перевірте налаштування роздільника';
$string['csvfileerror'] = 'З форматом файлу CSV щось не так. Будь ласка, перевірте, чи збігається кількість заголовків і стовпців, а також правильність роздільника та кодування файлу. {$a}';
$string['csvinvalidcols'] = '<b>Неправильний CSV файл:</b>  Перший рядок повинен містити "Заголовки полів" , а файл повинен бути <br />"Окремі поля/Розділені комою"';
$string['csvinvalidcolsnum'] = 'Неправильний CSV файл - кожен рядок повинен включати 49 або 70 полів';
$string['csvloaderror'] = 'Помилка під час завантаження CSV файлу!';
$string['csvnodata'] = 'Недійсний файл CSV – файл CSV має заголовки, але не містить жодних даних.';
$string['csvweirdcolumns'] = 'Неправильний CSV-формат файлу - кількість колонок не постійна!';
$string['dbconnectionfailed'] = '<p>Помилка: не вдалося встановити з’єднання з базою даних</p> <p>Цілком можливо, що база даних перевантажена або в іншому випадку не працює належним чином </p><p> адміністратор сайту повинні також перевірити, що база даних деталі були правильно вказані в config.php </ P>';
$string['dbdriverproblem'] = '<p>Помилка: виявлено проблему з драйвером бази даних</p> <p>Адміністратору сайту потрібно перевірити налаштування сервера</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Виявлено серйозну проблему з сесією бази даних.<br /><br />Будь лака, повідомте системного адміністратора.';
$string['dbsessionhandlerproblem'] = 'Не вдалося створити сесію бази даних.<br /><br />Будь лака, повідомте системного адміністратора.';
$string['dbsessionmysqlpacketsize'] = 'Виявлено серйозну помилку сесії.<br /><br />Будь лака, повідомте системного адміністратора, ця проблема, швидше за все, викликана малим значенням у значення параметра max_allowed_packet в MySQL.';
$string['dbupdatefailed'] = 'Помилка оновлення бази даних';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" не вдалося модифікувати. Знайдена залежність з {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Помилка виконання DDL SQL';
$string['ddlfieldalreadyexists'] = 'Поле "{$a}" вже існує';
$string['ddlfieldnotexist'] = 'Поле "{$a->fieldname}" не існує в таблиці "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'Таблиця "{$a}" вже існує';
$string['ddltablenotexist'] = 'Таблиці "{$a}" не існує';
$string['ddlunknownerror'] = 'Невідома помилка DDL бібліотеки';
$string['ddlxmlfileerror'] = 'Знайдено помилки в XML файлі бази даних';
$string['ddsequenceerror'] = 'Неправильно визначена таблиця "{$a}", там може бути тільки одна колонка з автоматичною нумерацією, яка повинна бути визначена як ключ.';
$string['destinationcmnotexit'] = 'Призначеного модуля курсу не існує';
$string['detectedbrokenplugin'] = 'Плагін {$a} несправний або застарілий; вибачте, ви не можете продовжувати.';
$string['dmlexceptiononinstall'] = '<p>Виникла помилка бази даних [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Помилка аналізу SQL-запиту';
$string['dmlreadexception'] = 'Помилка читання бази даних';
$string['dmltransactionexception'] = 'Помилка транзакції бази даних';
$string['dmlwriteexception'] = 'Помилка запису до бази даних';
$string['downgradedcore'] = 'ПОМИЛКА!!! Код сайту, який ви використовуєте, СТАРІШИЙ від версії бази даних!';
$string['downloadedfilecheckfailed'] = 'Помилка завантаження файлу.';
$string['duplicatefieldname'] = 'Виявлено дублювання імені поля:  "{$a}"';
$string['duplicatenosupport'] = 'Модуль \'{$a->modname}\' не можна продублювати, оскільки модуль {$a->modtype} не підтримує резервне копіювання та відновлення.';
$string['duplicateparaminsql'] = 'ПОМИЛКА: дублюється ім\'я параметра в запиті';
$string['duplicaterolename'] = 'Вже існує роль з такою назвою!';
$string['duplicateroleshortname'] = 'Вже існує роль з такою короткою назвою!';
$string['duplicateusername'] = 'Дублювання псевдоімені - запис пропущено';
$string['emailfail'] = 'Відправлення електронної пошти не вдалося';
$string['encryption_decryptfailed'] = 'Не вдалося розшифрувати';
$string['encryption_encryptfailed'] = 'Помилка шифрування';
$string['encryption_invalidkey'] = 'Недійсний ключ';
$string['encryption_keyalreadyexists'] = 'Ключ уже існує';
$string['encryption_nokey'] = 'Ключ не знайдено';
$string['encryption_wrongmethod'] = 'Дані не відповідають підтримуваному методу шифрування';
$string['enddatebeforestartdate'] = 'Дата закінчення курсу має бути після дати початку.';
$string['error'] = 'Сталася помилка';
$string['error_question_answers_missing_in_db'] = 'Не вдалося знайти відповідь, яка відповідає "{$a->answer}" в таблиці question_answers бази даних. Це трапилося під час відновлення з файлу резервної копії питання з id {$a->filequestionid}, який в базі даних відповідає існуючому питанню з id {$a->dbquestionid}.';
$string['errorcleaningdirectory'] = 'Помилка при очищенні каталогу "{$a}"';
$string['errorcopyingfiles'] = 'Помилка при копіюванні файлів';
$string['errorcreatingdirectory'] = 'Помилка при створенні каталогу "{$a}"';
$string['errorcreatingfile'] = 'Помилка при створенні файлу "{$a}"';
$string['errorcreatingrole'] = 'Помилка при створенні ролі';
$string['errorfetchingrssfeed'] = 'Помилка вибірки RSS-каналу.';
$string['erroronline'] = 'Помилка в рядку {$a}';
$string['erroroutput'] = 'Виведено помилку, тому автоматичне перенаправлення відключено.';
$string['errorparsingxml'] = 'Помилка розбору XML: {$a->errorstring} в рядку {$a->errorline}, символ {$a->errorchar}';
$string['errorprocessingarchive'] = 'Помилка при архівуванні файлу';
$string['errorreadingfile'] = 'Помилка при читанні файлу "{$a}"';
$string['errorsavingrequest'] = 'Виникла помилка при спробі зберегти Ваш запит.';
$string['errorsettinguserpref'] = 'Помилка встановлення параметрів користувача';
$string['errorunzippingfiles'] = 'Помилка при розпакуванні файлів';
$string['expiredkey'] = 'Застарілий ключ';
$string['externalauthpassworderror'] = 'Непорожній пароль для перевірки зовнішньої аутентифікації';
$string['externalfilenolocation'] = 'Зовнішній файл не має локального шляху';
$string['failtoloadblocks'] = 'Один або кілька блоків, зареєстрованих в базі даних, не вдалося завантажити!';
$string['fieldrequired'] = '"{$a}" - обов\'язкове поле';
$string['fileexists'] = 'Файл існує';
$string['filemismatch'] = 'Невідповідність в імені файлу. Файл  "{$a->current}"  повинен бути {$a->file}';
$string['filenotfound'] = 'Вибачте, але запитаний файл не знаходиться';
$string['filenotreadable'] = 'Файл не читається';
$string['filterdoesnothavelocalconfig'] = 'Фільтр {$a} не дозволяє місцеві конфігурації.';
$string['filternotactive'] = 'Фільтр {$a} в даний час не активний';
$string['filternotenabled'] = 'Фільтр не включено!';
$string['filternotinstalled'] = 'Фільтр {$a} зараз не встановлено';
$string['forumblockingtoomanyposts'] = 'Ви перевищили можливу кількість повідомлень встановлену для цього форуму.';
$string['functionalityremoved'] = 'Ви намагаєтеся отримати доступ до вилучених функцій.';
$string['generalexceptionmessage'] = 'Виняток - {$a}';
$string['gradecantregrade'] = 'Виникла помилка при обрахуванні оцінки: {$a}';
$string['gradepubdisable'] = 'Публікація оцінок відключена';
$string['gradesneedregrading'] = 'Оцінки курсу повинні бути перераховані';
$string['groupalready'] = 'Користувач вже входить до групи  {$a}';
$string['groupexistforcourse'] = 'Група "{$a}" вже створена на цьому курсі';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: Група "{$a->name}" з кодом "{$a->idnumber}" вже існує на курсі';
$string['grouphasidnumber'] = 'Група "{$a}" має код та може бути автоматично створена в зовнішній системі. Ви не маєте прав для видалення цієї групи.';
$string['groupinghasidnumber'] = 'Групування "{$a}" має код та може бути автоматично створене в зовнішній системі. Ви не маєте прав для видалення цього групування.';
$string['groupingnotaddederror'] = 'Групування "{$a}" не додано';
$string['groupnotaddederror'] = 'Групу "{$a}" не створено';
$string['groupnotaddedtogroupingerror'] = 'Група "{$a->groupname}" не додана до групування  "{$a->groupingname}"';
$string['groupunknown'] = 'Група {$a} не пов\'язана з вказаним курсом';
$string['groupusernotmember'] = 'Користувач не є членом цієї групи.';
$string['guestcantaccessprofiles'] = 'Гості не можуть бачити профілі користувачів. Зайдіть під своїм ім’ям для продовження.';
$string['guestnocomment'] = 'Гостям не дозволено залишати коментарі!';
$string['guestnoeditprofile'] = 'Гість не може редагувати свій обліковий запис';
$string['guestnoeditprofileother'] = 'Обліковий запис гостя не редагується';
$string['guestnorate'] = 'Гості не можуть оцінювати записи';
$string['guestsarenotallowed'] = 'Гостю не дозволено цього робити';
$string['hackdetected'] = 'Виявлено хакерську атаку!';
$string['hashpoolproblem'] = 'Неправильний пул файл контенту {$a}.';
$string['headersent'] = 'Заголовки вже було відправлено';
$string['idnumbertaken'] = 'Такий код вже використовується на іншому курсі';
$string['idnumbertoolong'] = 'Код занадто довгий';
$string['importformatnotimplement'] = 'Вибачте, імпорт цього формату поки що не підтримується!';
$string['incorrectext'] = 'Файл має неправильне розширення';
$string['inplaceeditableerror'] = 'Помилка виклику процесу оновлення';
$string['installproblem'] = 'Зазвичай не має можливості відновитися при виникненні помилки під час встановлення, можливо вам доведеться створити нову базу даних або використати інший префікс, якщо ви хочете повторити встановлення.';
$string['internalauthpassworderror'] = 'Пароль неправильний або не відповідає внутрішній політиці паролів';
$string['invalidaccess'] = 'Доступ до цієї сторінки був некоректний';
$string['invalidaccessparameter'] = 'Неправильний параметр доступу';
$string['invalidaction'] = 'Неправильний параметр дії';
$string['invalidactivityid'] = 'Неправильний код діяльності';
$string['invalidadminsettingname'] = 'Неправильна адміністративна установка ({$a})';
$string['invalidargorconf'] = 'Поступили неправильні аргументи або неправильна конфігурація сервера';
$string['invalidarguments'] = 'Поступили неправильні аргументи';
$string['invalidblockinstance'] = 'Неправильний блок для: {$a}';
$string['invalidbulkenrolop'] = 'Неприпустима операція запрошеного гуртового зарахування.';
$string['invalidcategory'] = 'Неправильна категорія!';
$string['invalidcategoryid'] = 'Неправильний ідентифікатор категорії!';
$string['invalidcomment'] = 'Неправильний коментар';
$string['invalidcommentarea'] = 'Неправильна область коментаря';
$string['invalidcommentid'] = 'Недійсний ідентифікатор коментаря';
$string['invalidcommentitemid'] = 'Недійсний ідентифікатор елемента коментаря';
$string['invalidcommentparam'] = 'Неправильні параметри коментаря';
$string['invalidcomponent'] = 'Неправильна назва компоненту';
$string['invalidconfirmdata'] = 'Неправильні дані підтвердження';
$string['invalidcontentid'] = 'Недійсний ідентифікатор вмісту';
$string['invalidcontext'] = 'Неправильний контекст';
$string['invalidcountrycode'] = 'Недійсний код країни: {$a}';
$string['invalidcourse'] = 'Неправильний курс';
$string['invalidcourseformat'] = 'Неправильний формат курсу';
$string['invalidcourseid'] = 'Ви намагаєтеся використати неправильний код курсу ({$a})';
$string['invalidcourselevel'] = 'Неправильний рівень контексту';
$string['invalidcoursemodule'] = 'Неправильний код модуля курсу';
$string['invalidcoursemoduleid'] = 'Недійсний ідентифікатор модуля курсу: {$a}';
$string['invalidcoursenameshort'] = 'Неправильна коротка назва курсу';
$string['invaliddata'] = 'Представлені дані недійсні';
$string['invaliddatarootpermissions'] = 'Виявлено неправильні права при спробі створення каталогу. Перемикніть в режим тестування для детальної інформації.';
$string['invaliddevicetype'] = 'Неправильний тип пристрою';
$string['invalidelementid'] = 'Неправильний ідентифікатор елемента!';
$string['invalidentry'] = 'Це не дійсний запис!';
$string['invalidevent'] = 'Неправильна подія';
$string['invalidfieldname'] = '"{$a}" неправильне ім\'я поля';
$string['invalidfiletype'] = '"{$a}" неправильний тип файлу';
$string['invalidformatpara'] = 'Неправильний формат для вибору параметру';
$string['invalidformdata'] = 'Неправильна форма даних';
$string['invalidfunction'] = 'Неправильна функція';
$string['invalidgradeitemid'] = 'Неправильний ідентифікатор елемента оцінки';
$string['invalidgroupid'] = 'Вказано неправильний ідентифікатор групи';
$string['invalidipformat'] = 'Некоректний формат ІР-адреси';
$string['invaliditemid'] = 'Неправильний ідентифікатор елемента';
$string['invalidkey'] = 'Неправильний ключ';
$string['invalidlanguagecode'] = 'Недійсний код мови: {$a}';
$string['invalidlegacy'] = 'Неправильно визначена спадковість для типу: {$a}';
$string['invalidmd5'] = 'Перевірка змінної повернула її помилку - спробуйте знову';
$string['invalidmode'] = 'Неправильний режим ({$a})';
$string['invalidmodule'] = 'Неправильний модуль';
$string['invalidmoduleid'] = 'Неправильний код модуля: {$a}';
$string['invalidmodulename'] = 'Неправильна назва модуля: {$a}';
$string['invalidnum'] = 'Неправильне числове значення';
$string['invalidnumkey'] = 'Масив $conditions не може містити цифрові ключі. Будь ласка, виправте код!';
$string['invalidoutcome'] = 'Неправильний ідентифікатор результату';
$string['invalidpagesize'] = 'Неправильний розмір сторінки';
$string['invalidpasswordpolicy'] = 'Невідповідність політиці паролів';
$string['invalidpaymentmethod'] = 'Неправильний метод оплати: {$a}';
$string['invalidpersistenterror'] = 'Помилка: {$a}';
$string['invalidqueryparam'] = 'ПОМИЛКА: Неправильна кількість параметрів запиту. Очікується {$a->expected}, отримано {$a->actual}.';
$string['invalidratingarea'] = 'Неправильна область оцінювання';
$string['invalidrecord'] = 'Не вдається знайти запис даних у таблиці бази даних {$a}.';
$string['invalidrecordunknown'] = 'Не вдається знайти запис даних у базі даних.';
$string['invalidrequest'] = 'Недійсний запит';
$string['invalidrole'] = 'Неправильна роль';
$string['invalidroleid'] = 'Неправильний код ролі';
$string['invalidscaleid'] = 'Неправильний ідентифікатор масштабу';
$string['invalidsection'] = 'Запис модуля курсу містить неприпустимі секції';
$string['invalidsesskey'] = 'Ваш сеанс, швидше за все, минув. Будь ласка, увійдіть ще раз.';
$string['invalidshortname'] = 'Недійсна назва короткого курсу';
$string['invalidsourcefield'] = 'Неправильне поле джерела файлів проекту';
$string['invalidstatedetected'] = 'Щось пішло не так: {$a}. Це не повинно було нормально закінчитися.';
$string['invalidurl'] = 'Неправильний URL';
$string['invaliduser'] = 'Неправильний користувач';
$string['invaliduserdata'] = 'Неправильні дані користувача: {$a}';
$string['invaliduserfield'] = 'Неправильне поле користувача: {$a}';
$string['invaliduserid'] = 'Недійсний ідентифікатор користувача';
$string['invalidusername'] = 'Вказане псевдоім’я містить неприпустимі символи';
$string['invalidusernameblank'] = 'Ім’я користувача не може бути порожнім';
$string['invalidxmlfile'] = '"{$a}" неправильний XML файл';
$string['iplookupfailed'] = 'Не вдається знайти геоінформацію про ІР-адресу {$a}';
$string['iplookupprivate'] = 'Не можна показати приватну ІР-адресу';
$string['ipmismatch'] = 'Невідповідність ІР адреси клієнта';
$string['listcantmovedown'] = 'Не вдалося перемістити елемент вниз, оскільки він є останнім із аналогів.';
$string['listcantmoveleft'] = 'Помилка переміщення елементу вліво, не має батьківського елементу.';
$string['listcantmoveright'] = 'Помилка переміщення елементу вправо, не має підпорядкованих елементів для переміщення. Перемістіть спочатку в інший список, а потім переміщуйте вправо.';
$string['listcantmoveup'] = 'Не вдалося перемістити елемент вгору, оскільки він є першим із аналогів.';
$string['listnochildren'] = 'Не знайдено підпорядкованих елементів';
$string['listnoitem'] = 'Елементів не знайдено.';
$string['listnopeers'] = 'Списків не знайдено.';
$string['listupdatefail'] = 'Помилка операції при редагуванні списку.';
$string['logfilenotavailable'] = 'Запис подій не дозволений';
$string['loginasnoenrol'] = 'Ви не можете використовувати реєстрацію, або нереєстрацію поки ви в режимі "Зайти як".';
$string['loginasonecourse'] = 'Ви не можете зайти до цього курсу.<br /> Вам потрібно змінити поточну сесію "Зайти як", перед тим як заходити в будь-які інші курси.';
$string['maxareabytes'] = 'Файл більше ніж залишилося місця в цій області.';
$string['maxbytesfile'] = 'Файл {$a->file} занадто великий. Максимальний розмір, який ви можете завантажити - {$a->size}.';
$string['maxdraftitemids'] = 'Завантаження файлів тимчасово обмежено після того, як ви завантажили велику кількість файлів. Зачекайте і повторіть спробу.';
$string['messageundeliveredbynotificationsettings'] = 'Не вдалося надіслати повідомлення, оскільки особисті повідомлення між користувачами (у налаштуваннях сповіщень) було вимкнено адміністратором сайту.';
$string['messagingdisable'] = 'Повідомлення відключені на цьому сайті';
$string['mimetexisnotexist'] = 'Ваша система не налаштована на запуск mimeTeX. Вам потрібно отримати вихідний код C із <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, скомпілювати його та помістити виконуваний файл у свій каталог moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'mimetex користувача не виконуваний!';
$string['missing_moodle_backup_xml_file'] = 'Резервній копії не вистачає XML файлу: {$a}';
$string['missingcategoryrole'] = 'Не вдалося призначити роль користувачеві: відсутня роль для категорії.';
$string['missingfield'] = 'Поле "{$a}" відсутнє';
$string['missingkeyinsql'] = 'ПОМИЛКА: в запиті не вистачає параметра "{$a}"';
$string['missingparam'] = 'Не вистачає обов’язкового параметра ({$a})';
$string['missingparameter'] = 'Не вистачає параметра';
$string['missingrequiredfield'] = 'Деякі обов\'язкові поля відсутні';
$string['missinguseranditemid'] = 'Не вистачає userid та itemid';
$string['missingvarname'] = 'Не вистачає обов’язкової назви змінної';
$string['mixedtypesqlparam'] = 'ПОМИЛКА: змішані типи параметрів SQL запиту!';
$string['mnetdisable'] = 'Moodle мережу відключено';
$string['mnetlocal'] = 'Віддалені користувачі MNET не можуть увійти локально';
$string['moduledisable'] = 'Модуль ({$a}) був відключений для цього курсу';
$string['moduledoesnotexist'] = 'Цього модуля не існує';
$string['moduleinstancedoesnotexist'] = 'Примірника цього модуля не існує';
$string['modulemissingcode'] = 'В модулі {$a} відсутня частина коду, яка повинна виконувати цю функцію';
$string['movecatcontentstoroot'] = 'Переміщення вмісту категорії до root заборонено. Ви повинні перемістити вміст до існуючої категорії!';
$string['movecatcontentstoselected'] = 'Деякий вміст категорії не можна перемістити у вибрану категорію.';
$string['movecategorynotpossible'] = 'Ви не можете переміщувати категорію \'{$a}\' у вибрану вами категорію.';
$string['movecategoryownparent'] = 'Ви не можете створити категорію \'{$a}\' як батьківську саму до себе.';
$string['movecategoryparentconflict'] = 'Ви не можете створити категорію \'{$a}\' як підкатегорію однієї з власних підкатегорій.';
$string['mssqlrcsmodemissing'] = 'База даних не використовує потрібний режим READ_COMMITTED_SNAPSHOT, що може призвести до неправильних результатів, особливо для потужних конкурентних сценаріїв. Будь ласка, включіть це для коректної поведінки. Більше інформації ви можете знайти в <a href="https://docs.moodle.org/en/Installing_MSSQL_for_PHP#Configuration">Документації Moodle</a>.';
$string['multiplerecordsfound'] = 'Знайдено кілька записів, хоча очікувався тільки один.';
$string['multiplerestorenotallow'] = 'Не допускається виконувати кілька оновлень!';
$string['mustbeloggedin'] = 'Ви повинні увійти, щоб мати можливість це робити';
$string['mustbeteacher'] = 'Ви повинні бути викладачем, щоб переглядати цю сторінку';
$string['myisamproblem'] = 'Таблиці бази даних, використовують тип MyISAM, рекомендується використовувати ACID сумісні з повною підтримкою транзакцій, такі як InnoDB.';
$string['needcopy'] = 'Спочатку потрібно щось скопіювати!';
$string['needcoursecategroyid'] = 'Спочатку потрібно вказати код курсу або категорію';
$string['needphpext'] = 'Вам потрібно додати підтримку {$a} у вашій РНР інсталяції';
$string['noadmins'] = 'Немає адміністраторів!';
$string['noblocks'] = 'Не знайдено блоків!';
$string['nocapabilitytousethisservice'] = 'Для користувача не вимагається використання цього сервісу';
$string['nocategorydelete'] = 'Категорія \'{$a}\' не може бути видаленою!';
$string['nocontext'] = 'Вибачте, але цей курс не має дійсного контексту.';
$string['nodata'] = 'Немає даних';
$string['noexistingcategory'] = 'Не існує категорії';
$string['nofile'] = 'Файл не вказано';
$string['nofiltersenabled'] = 'Фільтри не включено';
$string['nofolder'] = 'Потрібного каталогу не існує';
$string['noformdesc'] = 'Не знайдено форму опису formslib для цієї діяльності.';
$string['noguest'] = 'Не для гостей!';
$string['noinstances'] = 'Немає екземплярів {$a} у цьому курсі!';
$string['nologinas'] = 'Ви не можете увійти в систему як цей користувач';
$string['nonmeaningfulcontent'] = 'Беззмістовне наповнення';
$string['noparticipants'] = 'Не знайдені учасники для цього курсу';
$string['noparticipatorycms'] = 'Вибачте, але ви не маєте ніяких створених модулів курсу, щоб звітувати про них.';
$string['nopermissions'] = 'Вибачте, але наразі у вас немає дозволів на це ({$a}).';
$string['nopermissiontoaccesspage'] = 'Ви не маєте доступу до цієї сторінки.';
$string['nopermissiontocomment'] = 'Ви не можете додавати коментарі';
$string['nopermissiontodelentry'] = 'Ви не можете видалити цей коментар!';
$string['nopermissiontoeditcomment'] = 'Ви не можете редагувати записи інших!';
$string['nopermissiontohide'] = 'Немає права приховувати!';
$string['nopermissiontoimportact'] = 'Ви не маєте відповідних прав для імпортування діяльностей до цього курсу';
$string['nopermissiontolock'] = 'Немає права закривати!';
$string['nopermissiontomanagegroup'] = 'Ви не маєте відповідних прав для управління групами';
$string['nopermissiontorate'] = 'Оцінювання записів не дозволено!';
$string['nopermissiontoshow'] = 'Не можете бачити це!';
$string['nopermissiontounlock'] = 'Немає права відкривати!';
$string['nopermissiontoupdatecalendar'] = 'Вибачте, але у вас немає дозволу оновлювати подію календаря.';
$string['nopermissiontoviewcalendar'] = 'Нажаль у вас немає дозволу на перегляд подій у календарі.';
$string['nopermissiontoviewgrades'] = 'Неможливо переглянути оцінки.';
$string['nopermissiontoviewletergrade'] = 'Немає права переглядати буквені оцінки';
$string['nopermissiontoviewpage'] = 'Вам не дозволено переглядати цю сторінку';
$string['nosite'] = 'Не знайдено верхній рівень курсу!';
$string['nositeid'] = 'Немає коду сайту';
$string['nostartdatenoenddate'] = 'Дата закінчення курсу може бути встановлена, лише якщо також встановлена дата початку.';
$string['nostatstodisplay'] = 'На жаль, немає даних для показу';
$string['notallowedtoupdateprefremotely'] = 'Вам не дозволено оновлювати параметри цього користувача віддалено';
$string['notavailable'] = 'Це зараз не доступно';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Ви не є членом цієї групи на курсі';
$string['notownerofkey'] = 'Ви не є власником цього ключа';
$string['nousers'] = 'Немає такого користувача!';
$string['oauth1accesstoken'] = 'OAuth 1.0 Помилка: Ми не отримали сигнал доступу.';
$string['oauth1requesttoken'] = 'Помилка OAuth 1.0: ми не отримали маркер запиту – можливо, постачальник послуг тимчасово не працює.';
$string['oauth2refreshtokenerror'] = 'Не вдалося оновити маркер OAuth 2. Статус HTTP для віддаленої кінцевої точки: {$a}';
$string['oauth2refreshtokentaskerror'] = 'Не вдалося оновити маркер OAuth 2 для одного або кількох емітентів. Перегляньте вихідні дані завдання, щоб дізнатися більше.';
$string['oauth2upgradetokenerror'] = 'Не вдалося оновити маркер OAuth 2. Статус HTTP для віддаленої кінцевої точки: {$a}';
$string['onlyadmins'] = 'Тільки адміністратори можуть це робити.';
$string['onlyeditingteachers'] = 'Тільки викладач-редактор може це робити';
$string['onlyeditown'] = 'Ви можете редагувати тільки свою власну інформацію';
$string['opensslsealerror'] = 'OpenSSL не може запечатати дані';
$string['opensslsignerror'] = 'OpenSSL не може підписати дані';
$string['orderidnotfound'] = 'Код замовлення {$a} не знайдено';
$string['pagenotexist'] = 'Під час спроби переглянути неіснуючу сторінку сталася незвичайна помилка:{$a}';
$string['pagenotexisttitle'] = '404 Помилка: Файл не знайдено';
$string['pathdoesnotstartslash'] = 'Надано неправильні аргументи, шлях не повинен починатися зі слешу!';
$string['pleasereport'] = 'Якщо у вас є час, будь ласка, дайте нам знати, що ви намагалися зробити, коли сталася помилка:';
$string['pluginrequirementsnotmet'] = 'Розширення "{$a->pluginname}" ($a->pluginversion) не було встановлено. Воно вимагає новішої версії Moodle (ви використовуєте {$a->currentmoodle}, а потрібна {$a->requiremoodle}).';
$string['pluginunsupported'] = 'Плагін "{$a->pluginname}" {$a->pluginversion} не підтримує цю версію Moodle {$a->moodleversion}. Знайдіть інформацію про плагін, щоб знайти підтримувані версії.';
$string['prefixcannotbeempty'] = '<p>Помилка: префікс таблиці бази даних не може бути порожнім ({$a})</p> <p>Адміністратор сайту повинен виправити цю проблему.</p>';
$string['prefixtoolong'] = '<p>Помилка: префікс таблиці бази даних занадто довгий ({$a->dbfamily})</p> <p>Адміністратор сайту повинен виправити цю проблему. Максимальна довжина для префіксу таблиці повинна бути в межах від {$a->dbfamily} до {$a->maxlength} символів.</p>';
$string['privatefilesupload'] = 'Пряме завантаження до особистих файлів користувача більше не підтримується. Завантажуйте в область чернеток, а потім переміщуйте файли за допомогою core_user::add_user_private_files';
$string['processingstops'] = 'Процес зупинено тут. Решта записів проігноровано';
$string['protected_cc_not_supported'] = 'Захищені картриджі не підтримуються.';
$string['querystringcannotbeempty'] = 'Рядок запиту не може бути порожнім.';
$string['redirecterrordetected'] = 'Виявлено непідтримуване перенаправлення, виконання сценарію припиняється';
$string['refoundto'] = 'Може бути повернуто до {$a}';
$string['refoundtoorigi'] = 'Повернено до початкової кількості: {$a}';
$string['registrationdisabled'] = 'Реєстрація на цьому сайті вимкнена';
$string['remotedownloaderror'] = 'Завантаження компонентів до вашого серверу зазнало невдачі, будь ласка перевірте налаштування проксі, та врахуйте рекомендацію встановлення PHP cURL.<br /><br /> Вам доведеться завантажити файл <a href="{$a->url}">{$a->url}</a> вручну, скопіювати його до "{$a->dest}" на вашому сервері та розпакувати там.';
$string['remotedownloadnotallowed'] = 'Завантаження компонентів на ваш сервер не дозволено (змінна allow_url_fopen відключена).<br /><br />Вам потрібно завантажити <a href="{$a->url}">$a->url</a> файл вручну, скопіювати його до "{$a->dest}" на вашому сервері та розпакувати там.';
$string['reportnotavailable'] = 'Цей тип звіту доступний тільки для курсу сайту';
$string['requirecorrectaccess'] = 'Неправильний URL або порт.';
$string['requireloginerror'] = 'Курс або діяльність не доступні.';
$string['restore_path_element_missingmethod'] = 'Відсутній метод відновлення {$a}. Він повинен бути визначеним розробниками.';
$string['restore_path_element_noobject'] = 'Відновлюваний об’єкт {$a} не є об’єктом.';
$string['restorechecksumfailed'] = 'Виникла проблема з відновленням інформації збереженої у вашій сесії. Перевірте обмеження розміру пам\'яті в РНР та пакетах БД. Відновлення зупинено.';
$string['restrictedcontextexception'] = 'На жаль, виконання зовнішньої функції порушує обмеження контексту.';
$string['restricteduser'] = 'Вибачте, але ваш поточний обліковий запис "{$a}" не дозволяє робити це.';
$string['reverseproxyabused'] = 'Зворотний проксі-сервер увімкнено, тому до сервера неможливо отримати прямий доступ. Зверніться до адміністратора сервера.';
$string['rpcerror'] = 'Оп-па! Зв’язок з вашою Moodle мережею не вдався! Ось вам повідомлення про помилку, з яким ви можете піти до вашого адміністратора: {$a}';
$string['scheduledbackupsdisabled'] = 'Резервне копіювання за розкладом відключено адміністратором сервера';
$string['secretalreadyused'] = 'Посилання на підтвердження зміни пароля вже використано, пароль не змінено';
$string['sectionnotexist'] = 'Такої секції не існує';
$string['sendmessage'] = 'Надіслати повідомлення';
$string['sendmessagesent'] = 'Дякуємо за відгук про:<br>{$a}';
$string['serverconnection'] = 'Помилка з’єднання з сервером';
$string['servicedonotexist'] = 'Сервісу не існує';
$string['sessioncannotobtainlock'] = '<p>Не вдалося отримати блокування для ідентифікатора сеансу {$a->id} протягом {$a->acquiretimeout}.</p>
<p>Ймовірно, що інша сторінка ({$a->whohaslock}) все ще працює на іншій вкладці веб-переглядача, або вона не зняла блокування через помилку. </p><p>Ви можете дочекатися часу очікування блокування сеансу ({$a->lockexpire}) або перезапустити сеанс браузера. Якщо ця помилка не зникає, повідомте про це адміністратора сервера.<p>';
$string['sessioncookiesdisable'] = 'Не коректне використання equire_key_login() - сесійні куки повинні бути відключені!';
$string['sessiondiskfull'] = 'Сеансовий розділ заповнений. Наразі неможливо увійти. Будь ласка, повідомте адміністратора сервера.';
$string['sessionerroruser'] = 'Час вашої сесії вичерпався. Будь ласка, увійдіть ще раз.';
$string['sessionerroruser2'] = 'Виявлено помилку сервера, яка впливає на ваш сеанс входу. Будь ласка, увійдіть знову або перезапустіть браузер.';
$string['sessionexpired'] = 'Сеанс закінчився';
$string['sessionhandlerproblem'] = 'Обробник сесії неправильно налаштований';
$string['sessionipnomatch'] = 'Вибачте, але ваша ІР-адреса змінилася після вашого першого входу. Ця особливість безпеки попереджає вхід від вашого імені інших користувачів на сайт. Звичайно користувачі не отримують цього повідомлення - зверніться до адміністратора за допомогою.';
$string['sessionipnomatch2'] = 'Вибачте, але ваша ІР-адреса змінилася з часу вашо останнього входження. Ці заходи безпеки запобігають крадіжці хакерами ваших даних на цьому сайті. Ви можете побачити цю помилку, якщо користуєтеся бездротовими мережами, або якщо використовуєте роумінг між різними мережами. Будь ласка, зверніться до вашого адміністратора за додатковою допомогою.<br /><br /> Якщо ви бажаєте продовжити, натисніть F5 для перезавантаження цієї сторінки.';
$string['sessionwaiterr'] = 'Вийшов час очікування закриття сесії.<br />Зачекайте доки закінчеться поточний запит та повторіть спробу.';
$string['shortnametaken'] = 'Така коротка назва вже використовується на іншому курсі';
$string['sitepolicynotagreed'] = 'Політика сайту не погоджена: <a href="{$a}">натисніть тут</a>, щоб відкрити політику сайту.';
$string['socksnotsupported'] = 'SOCKS5-проксі не підтримується в PHP4';
$string['spellcheckernotconf'] = 'Перевірка орфографії не налаштована';
$string['sslonlyaccess'] = 'З точки зору безпеки дозволено тільки https з’єднання, вибачте.';
$string['statscatchupmode'] = 'Статистика знаходиться зараз в режимі реконструкції. Процес триває вже {$a->daysdone} днів і очікується ще {$a->dayspending}. Через деякий час перевірте ще раз!';
$string['statsdisable'] = 'Статистика не включена';
$string['statsnodata'] = 'Не існує даних для такої комбінації курсу та часового періоду';
$string['storedfilecannotcreatefile'] = 'Не вдається створити файл локального пулу файлів. Будь ласка, перевірте права доступу до кореня даних і доступного місця на диску.';
$string['storedfilecannotcreatefiledirs'] = 'Неможливо створити локальні каталоги пулу файлів. Будь ласка, перевірте дозволи в root-каталозі.';
$string['storedfilecannotread'] = 'Не читається файл, можливо його не існує або є проблеми з правами доступу';
$string['storedfilecannotreadfile'] = 'Не вдається прочитати файл \'{$a}\'. Файл не існує, або є проблема з дозволом.';
$string['storedfilenotcreated'] = 'Не вдається створити файл {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Невідоме виключення, пов\'язане з локальними файлами ({$a})';
$string['tagdisabled'] = 'Мітки відключені!';
$string['tagnotfound'] = 'Вказану мітку не знайдено в базі даних';
$string['targetdatabasenotempty'] = 'Цільова база даних не є порожнім. Передача перервана з міркувань безпеки.';
$string['textconditionsnotallowed'] = 'Порівняння умов колонки тексту не допускається. Будь ласка, використовуйте sql_compare_text() у запиті.';
$string['themenotinstall'] = 'Така тема не встановлена!';
$string['tokengenerationfailed'] = 'Неможливо створити новий маркер.';
$string['transactionvoid'] = 'Транзакція не може бути анульована, оскільки вона вже була анульована';
$string['unenrolerror'] = 'Трапилася помилка при спробі відрахувати цю особу';
$string['unicodeupgradeerror'] = 'На жаль, ваша база даних не в форматі Unicode, а ця версія Moodle не підтримує міграцію до Unicode. Будь ласка, оновіть спочатку версію Moodle до 1.7.x та зробіть міграцію бази даних до Unicode на адміністративній сторінці. Після цього ви будете готові оновитися до Moodle {$a}';
$string['unknowaction'] = 'Незрозуміла дія!';
$string['unknowcategory'] = 'Невідома категорія!';
$string['unknowcontext'] = 'Невідомий контекст ({$a}) в get_child_contexts!';
$string['unknowformat'] = 'Невідомий формат ({$a})';
$string['unknownbackupexporterror'] = 'Невідома помилка при підготовці інформації до імпорту';
$string['unknownblockregion'] = 'Блоковий регіон \'{$a}\' не визнається на цій сторінці.';
$string['unknowncategory'] = 'Невідома категорія з ідентифікатором категорії "{$a}"';
$string['unknowncontext'] = 'Невідомий контекст.';
$string['unknowncourse'] = 'Невідома назва курс"{$a}"';
$string['unknowncourseidnumber'] = 'Невідомий Код Курсу "{$a}"';
$string['unknowncourserequest'] = 'Запрошено невідомий курс';
$string['unknowncoursesection'] = 'Невідома секція курсу в курсі "{$a}"';
$string['unknownevent'] = 'Невідома подія';
$string['unknownfiletype'] = 'Невідомий тип фільтру';
$string['unknowngroup'] = 'Невідома група "{$a}"';
$string['unknownhelp'] = 'Невідомий розділ довідки {$a}';
$string['unknownjsinrequirejs'] = 'Не вдається знайти бібліотеку JavaScript {$a}.';
$string['unknownmodulename'] = 'Невідома назва модуля для форми';
$string['unknownrole'] = 'Невідома роль "{$a}"';
$string['unknownsortcolumn'] = 'Невідома колонка сортування {$a}';
$string['unknownuseraction'] = 'На жаль, я не розумію такої дії користувача.';
$string['unknownuserselector'] = 'Невідомий вибір користувача';
$string['unknoworder'] = 'Невідоме замовлення';
$string['unknowparamtype'] = 'Невідомий тип параметра: {$a}';
$string['unknowquestiontype'] = 'Непідтримуваний тип питання {$a}';
$string['unknowuploadaction'] = 'Помилка: невідома дія завантаження ({$a})';
$string['unspecifycourseid'] = 'Потрібно вказати код курсу, коротку назву або idnumber';
$string['unsupportedevent'] = 'Непідтримуваний тип події';
$string['unsupportedstate'] = 'Непідтримуваний стан завершення';
$string['unsupportedwebserver'] = 'Програмне забезпечення веб сервера ({$a}) не підтримується, вибачте.';
$string['upgraderequires19'] = 'Помилка: На сервер було встановлено нову версію Moodle, нажаль оновлення з попередньої версії не підтримується.<br /> Будь ласка, оновіть спочатку до 1.9.x. Ви можете також повернутися до попереднього стану записавши назад оригінальні файли вашої версії.';
$string['upgraderunning'] = 'Сайт оновлюється, повторіть спробу пізніше.';
$string['urlnotdefinerss'] = 'Не визначена URL адреса для RSS каналу';
$string['useradmineditadmin'] = 'Тільки адміністратору дозволено редагувати облікові записи інших адміністраторів.';
$string['useradminodelete'] = 'Облікові записи адміністратора не можна видалити.';
$string['userautherror'] = 'Невідомий модуль аутентифікації';
$string['userauthunsupported'] = 'Модуль аутентифікації тут не підтримується';
$string['useremailduplicate'] = 'Дублювання адрес';
$string['userisfilteredout'] = 'Цей користувач не відповідає фільтрам і параметрам таблиці!';
$string['usermustbemnet'] = 'Користувачі у списку контролю доступу Мережі Moodle повинні бути віддаленими користувачами цієї мережі';
$string['usernamelowercase'] = 'Ім’я користувача має бути з малого регістру';
$string['usernotaddederror'] = 'Користувач не доданий - помилка';
$string['usernotaddedregistered'] = 'Користувач не доданий - вже зареєстрований';
$string['usernotavailable'] = 'Інформація про даного користувача вам не доступна.';
$string['usernotdeletedadmin'] = 'Користувача, не видаленого як облікові записи адміністратора, видалити не можна.';
$string['usernotdeleteddeleted'] = 'Цього користувача вже видалено.';
$string['usernotdeletederror'] = 'Користувача не видалено - помилка';
$string['usernotdeletedmissing'] = 'Користувача не видалено - не знайдено імені користувача';
$string['usernotdeletedoff'] = 'Користувача не видалено - видалення не дозволено';
$string['usernotfullysetup'] = 'Користувач не повністю налаштований';
$string['usernotincourse'] = 'Цей користувач не в цьому курсі!';
$string['usernotrenamedadmin'] = 'Не можна перейменовувати облікові записи адміністраторів';
$string['usernotrenamedexists'] = 'Користувач не перейменований - вказане нове ім\'я вже використовується';
$string['usernotrenamedmissing'] = 'Користувач не перейменований - не знайдено старе ім\'я';
$string['usernotrenamedoff'] = 'Користувач не перейменований - перейменування не дозволено';
$string['usernotupdatedadmin'] = 'Не можна оновлювати облікові записи адміністраторів';
$string['usernotupdatederror'] = 'Користувача не оновлено - помилка';
$string['usernotupdatednotexists'] = 'Користувача не оновлено - такого не існує';
$string['userquotalimit'] = 'Ви досягли межі квоти для ваших фалів.';
$string['userselectortoomany'] = 'user_selector повернув більше одного користувача, хоча множинного вибору не може бути.';
$string['verifyagedigitalconsentnotpossible'] = 'На жаль, підтвердження цифрової згоди наразі неможливе.';
$string['wrongcall'] = 'Цей сценарій викликано неправильно';
$string['wrongcontextid'] = 'Код контексту неправильний (немає такого)';
$string['wrongdestpath'] = 'Неправильний шлях призначення.';
$string['wrongroleid'] = 'Неправильний код ролі!';
$string['wrongsourcebase'] = 'Неправильне джерело базового URL.';
$string['wrongusernamepassword'] = 'Неправильні псевдо або пароль';
$string['wrongzipfilename'] = 'Неправильне ім\'я ZIP-архіву';
$string['wscouldnotcreateecoursenopermission'] = 'WS - Не вдалося створити курс - відсутні права';
$string['wwwrootmismatch'] = 'Виявлено не коректний доступ, цей сервер допускає тільки "{$a}" адреси, вибачте.<br /> Повідомте адміністратора серверу.';
$string['wwwrootslash'] = 'Виявлено не коректний $CFG->wwwroot в config.php, він не повинен містити слеш. <br /> Повідомте адміністратора серверу.';
$string['xmldberror'] = 'Помилка XMLDB!';
$string['youcannotdeletecategory'] = 'Ви не можете видалити категорію \'{$a}\' оскільки ви не можете ні видалити її контент, ні перемістити його в інше місце.';
