<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_ldap', language 'af', version '4.1'.
 *
 * @package     auth_ldap
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['auth_ldap_ad_create_req'] = 'Kan nie die nuwe rekening in Aktiewe Leêrgids skep nie. Maak seker dat daar aan al die behoeftes om te verseker dat hierdie werk, voldoen is (LDAPS konneksie, bind gebruiker met genoegsame regte, ens.)';
$string['auth_ldap_attrcreators'] = 'Lys van groepe of kontekste wie se lede toegelaat word om eienskappe te skep. Skei veelvuldige gorepe met \':\'. Gewoonlik iets soos \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_attrcreators_key'] = 'Eienskap skeppers';
$string['auth_ldap_auth_user_create_key'] = 'Skep gebruikers ekstern';
$string['auth_ldap_bind_dn'] = 'Spesifiseer hier as jy \'BIND-user\' wil gebruik om vir gebruikers te soek. Iets soos \'cn=ldapuser,ou=public,o=org\'';
$string['auth_ldap_bind_dn_key'] = 'Onderskeide naam';
$string['auth_ldap_bind_pw'] = 'Wagwoord vir BIND-gebruiker.';
$string['auth_ldap_bind_pw_key'] = 'Wagwoord';
$string['auth_ldap_bind_settings'] = 'BIND instellings';
$string['auth_ldap_changepasswordurl_key'] = 'Wagwoord verandering URL';
$string['auth_ldap_contexts'] = 'Lys van kontekste waar gebruikers gevestig is. Verdeel verskillende kontekste met \';\'. Byvoorbeeld: \'ou=users,o=org; ou=others,o=org\'';
$string['auth_ldap_contexts_key'] = 'Kontekste';
$string['auth_ldap_create_context'] = 'Indien jy die skep van gebruikers met e-pos bevestiging onstper, spesifiseer die konteks waar gebruikers geskep word. Hierdie konteks moet verkil van ander gebruikers om sekuriteitskwessies te voorkom. Jy hoef nie hierdie konteks by ldap_context-variable te voeg nie: Moodle sal outomaties vir gebruikers vanuit hierdie konteks soek. .<br /><b>Nota!</b> Jy moet die metode user_create() in die leêr auth/ldap/auth.php wysig om gebruiker skepping te laat werk.';
$string['auth_ldap_create_context_key'] = 'Konteks vir nuwe gebruikers.';
$string['auth_ldap_create_error'] = 'Daar was \'n fout tydens die skepping van die gebruiker in LDAP.';
$string['auth_ldap_expiration_desc'] = 'Selekteer \'{$a->no}\' om te verhoed dat daar vir vervalle wagwoorde gekontroleer word of \'{$a->ldapserver}\' om die wagwoord se vervaldatum direk vanaf die LDAP bediener te lees.';
$string['auth_ldap_expiration_key'] = 'Verval';
$string['auth_ldap_expiration_warning_desc'] = 'Hoeveelheid dae voordat wagwoord vervaldatum waaarskuwings uitgereik word.';
$string['auth_ldap_expiration_warning_key'] = 'Verval waarskuwing';
$string['auth_ldap_expireattr_desc'] = 'Opsioneel: Oorheers die LDAP eienskap wat wagwoord vervaltyd stoor.';
$string['auth_ldap_expireattr_key'] = 'Verval eienskap';
$string['auth_ldap_graceattr_desc'] = 'Opsioneel: Oorheers grasie inteken eienskap';
$string['auth_ldap_gracelogin_key'] = 'Grasie inteken eienskap';
$string['auth_ldap_gracelogins_desc'] = 'Onstper LDAP grasie inteken ondersteuning. Nadat die wagwooord verval het kan die gebruiker steeds inteken totdat die grasie inteken-telling 0 is. Deur hierdie instelling te onstper word daar \'n grasie inteken-boodskap vertoon indien die wagwoord verval het.';
$string['auth_ldap_gracelogins_key'] = 'Grasie intekens';
$string['auth_ldap_groupecreators'] = 'Lys van groepe of kontekste wie se lede groepe mag skep. Skei veelvuldige groepe met \';\'. Gewoonlik iets soos \'cn=teachers,ou=staff,o=myorg\'';
$string['auth_ldap_groupecreators_key'] = 'Groep skeppers';
$string['auth_ldap_host_url'] = 'Spesifiseer LDAP gasheer in URL formaat, byvoorbeeld \'ldap://ldap.myorg.com/\' of \'ldaps://ldap.myorg.com/\'. Skei veelvuldige bedieners met \';\' om ondersteuning vanaf die parallel rugsteun-bediener te ontvang.';
$string['auth_ldap_host_url_key'] = 'Gasheer URL';
$string['auth_ldap_ldap_encoding'] = 'Enkodering deur die LDAP bediener gebruik: heel moontlik die utf-8. Indien LDAP v2 geselekteer word, sal Aktiewe Leêrgids sy saamgestelde enkodering soos cp1252 of cp1250 gebruik.';
$string['auth_ldap_ldap_encoding_key'] = 'LDAP enkodering';
$string['auth_ldap_login_settings'] = 'Inteken instellings';
$string['auth_ldap_memberattribute'] = 'Opsioneel: Oorheers gebruiker lid-eienskap wanneer \'n gebruiker aan \'n groep behoort. Gewoonlik \'lid\'';
$string['auth_ldap_memberattribute_isdn'] = 'Oorheers hantering van lid-eienskap waardes';
$string['auth_ldap_memberattribute_isdn_key'] = 'Lid-eienskap gebruik dn';
$string['auth_ldap_memberattribute_key'] = 'Lid eienskap';
$string['auth_ldap_no_mbstring'] = 'Jy het die mbstring uitbreiding nodig om gebruikers in die Aktiewe Leêrgids te skep.';
$string['auth_ldap_noconnect'] = 'LDAP-module kan nie aan die bediener konnekteer nie: {$a}';
$string['auth_ldap_noconnect_all'] = 'LDAP-module kan nie aan enige bedieners konnekteer nie: {$a}';
$string['auth_ldap_noextension'] = 'Dit lyk nie asof die PHP LDAP module teenwoordig is nie. Maak asseblief seker dat dit geïnstalleer ien ontsper is ondien jy hierdie verifikasie inprop wil gebruik';
$string['auth_ldap_objectclass'] = 'Opsioneel: Oorheers objectClass wat gebruik word om gebruikers te benoem of te soek op ldap_user_type. Gewoonlik hoef \'n mens nie hierdie te verander nie.';
$string['auth_ldap_objectclass_key'] = 'Objek klas';
$string['auth_ldap_opt_deref'] = 'Bepaal hoe aliasse gedurende soektogte hanteer word. Selekteer een van die volgende waardes: "Nee" (LDAP_DEREF_NEVER) of "Ja" (LDAP_DEREF_ALWAYS)';
$string['auth_ldap_opt_deref_key'] = 'Onverwys aliasse';
$string['auth_ldap_passtype'] = 'Spesifiseer die formaat van nuwe of veranderde wagwoorde in LDAP bediener';
$string['auth_ldap_passtype_key'] = 'Wagwoord formaat';
$string['auth_ldap_passwdexpire_settings'] = 'LDAP wagwoord verval instellings';
$string['auth_ldap_preventpassindb'] = 'Selekteer ja om te verhoed dat wagwoorde in Moodle se DB gestoor word.';
$string['auth_ldap_preventpassindb_key'] = 'Voorkom voorlopige berging van wagwoorde';
$string['auth_ldap_rolecontext'] = '{$a->localname} konteks';
$string['auth_ldap_rolecontext_help'] = 'LDAP konteks gebruik om <i>{$a->localname}</i> afbeelding te selekteer. Skei veelvuldige groepe met \';\'. Gewoonlik iets soos"cn={$a->shortname},ou=first-ou-with-role-groups,o=myorg; cn={$a->shortname},ou=second-ou-with-role-groups,o=myorg".';
$string['auth_ldap_search_sub'] = 'Soek gebruikers vanaf subkontekste.';
$string['auth_ldap_search_sub_key'] = 'Soek subkontekste';
$string['auth_ldap_server_settings'] = 'LDAP bediener instellings';
$string['auth_ldap_suspended_attribute'] = 'Opsioneel: Wanneer aangebied sal hierdie eienskap gebruik word om die plaaslik geskape gebruikersrekening te ontsper of op te skort.';
$string['auth_ldap_suspended_attribute_key'] = 'Opgeskorte eienskap';
$string['auth_ldap_unsupportedusertype'] = 'auth: ldap user_create() ondersteun nie geselkteerde gebruiker-tipe nie: {$a}';
$string['auth_ldap_update_userinfo'] = 'Dateer gebruikersinligting op (naam, van, adres, ens.) vanaf LDAP na Moodle. Spesifiseer "Data afbeelding" instellings soos nodig.';
$string['auth_ldap_user_attribute'] = 'Opsioneel: Oorheers die einskap wat gebruik word om gebruikers te benoem of te soek. Gewoonlik \'cn\'.';
$string['auth_ldap_user_attribute_key'] = 'Gebruiker eienskap';
$string['auth_ldap_user_exists'] = 'LDAP gebruikersnaam bestaan reeds';
$string['auth_ldap_user_settings'] = 'Gebruiker opkyk instellings';
$string['auth_ldap_user_type'] = 'Selekteer hoe gebruikers in LDAP gestoor word. Hierdie instelling spesifiseer ook hoe inteken verval, grasie intekens en gebruiker skepping sal werk.';
$string['auth_ldap_user_type_key'] = 'Gebruiker tipe';
$string['auth_ldap_usertypeundefined'] = 'config.user_type nie gedefinieër of funksie ldap_expirationtime2unix ondersteun nie geselekteerde tipe nie!';
$string['auth_ldap_usertypeundefined2'] = 'config.user_type nie gedefinieër of funksie ldap_unixi2expirationtime ondersteun nie geselekteerde tipe nie!';
$string['auth_ldap_version'] = 'Die weergawe van die LDAP protokol wat jou bediener tans gebruik.';
$string['auth_ldap_version_key'] = 'Weergawe';
$string['auth_ldapdescription'] = 'Hierdie metode verskaf verifikasie teen \'n eksterne LDAP bediener, Indien die gegewe gebruikersnaam en wagwoord geldig is, skep Moodle \'n nuwe gebruiker inskrywing in sy databasis. Hierdie inprop kan gebruikerseienskappe vanaf LDAP lees en gesogte velde in Moodle vooraf invul. Vir opvolgende intekens word slegs die gebruikersnaam en wagwoord gekontroleer.';
$string['auth_ldapextrafields'] = 'Hierdie velde is opsioneel.  Jy kan kies om sommige Moodle gebruikersvelde vooraf in te vul met informasie van die <b>LDAP fields</b> wat jy hier spesifiseer. Indien jy hierdie veld leeg los, sal niks vanaf LDAP oorgedra word nie en Moodle verstek-inligting sal gebruik word. </p><p> In iedergeval sal die gebruiker in staat wees om al hierdie velde te redigeer nadat hulle ingeteken het.';
$string['auth_ldapnotinstalled'] = 'Kan nie LDAP verifikasie gebruik nie. Die PHP LDAP module is nie geïnstalleer nie.';
$string['auth_ntlmsso'] = 'NTLM SSO';
$string['auth_ntlmsso_enabled'] = 'Stel na ja om \'Single Sign On\' met die NTLM domein te poog. Let wel dat hierdie addisionele opstelling op die bediener vereis om te werk. Ondersoek die dokumentasie vir verdere details: <a href="https://docs.moodle.org/en/NTLM_authentication">NTLM authentication</a>.';
$string['auth_ntlmsso_enabled_key'] = 'Ontsper';
$string['auth_ntlmsso_ie_fastpath'] = 'Stel in om die NTML SSO vinnige baan te onstper (hierdie laat sekere stappe opsy indien die kliënt se blaaier MS Internet Explorer is).';
$string['auth_ntlmsso_ie_fastpath_attempt'] = 'Poog NTLM met alle blaaiers';
$string['auth_ntlmsso_ie_fastpath_key'] = 'MS IE vinnige baan?';
$string['auth_ntlmsso_ie_fastpath_yesattempt'] = 'Ja, poog NTLM op ander blaaiers';
$string['auth_ntlmsso_ie_fastpath_yesform'] = 'Ja, al die ander blaaiers gebruik die standaard inteken vorm.';
$string['auth_ntlmsso_maybeinvalidformat'] = 'Nie in staat om die gebruikersnaam van die REMOTE_USER opskrif te onttrek nie. Is die saamgestelde formaat korrek>';
$string['auth_ntlmsso_missing_username'] = 'Jy moet ten minste %username% in die afstandsgebruikersnaam formaat spesifiseer.';
$string['auth_ntlmsso_remoteuserformat'] = 'Indien jy \'NTLM\' in \'Verifikasie tipe\' gekies het, kan jy die afstandsgebruikersnaam formaat hier spesifiseer. As jy hierdie leeg laat, sal die verstek DOMAIN\\username formaat gebruik word. Jy kan die opsionele <b>%domain%</b> plekhouer gebruik om te spesifiseer waar die domein naam verskyn en die verpligte <b>%username%</b> plekhouer om te spesifiseer waar die gebruikersnaam verskyn. <br /><br />Sommige formate wat wydverspreid gebruik word is: <tt>%domain%\\%username%</tt> (MS Windows verstek), <tt>%domain%/%username%</tt>, <tt>%domain%+%username%</tt> en slegs <tt>%username%</tt> (indien daar geen domein deel is nie).';
$string['auth_ntlmsso_remoteuserformat_key'] = 'Afstandsgebruiker formaat';
$string['auth_ntlmsso_subnet'] = 'Indien ingestel, sal dit slegs SSO met kliënte in hierdie subnet poog. Formaat:  xxx.xxx.xxx.xxx/bitmask. Skei veelvuldige subnette met \',\' (komma).';
$string['auth_ntlmsso_subnet_key'] = 'Subnet';
$string['auth_ntlmsso_type'] = 'Die verifikasie metode wat in die web-bediener saamgestel is om die gebruikers te verifieër (indien ondeker, kies NTLM).';
$string['auth_ntlmsso_type_key'] = 'Verifikasie tipe';
$string['cannotmaprole'] = 'Die rol "{$a->rolename}" kan nie uitgebeeld word nie omdat die kort naam "{$a->shortname}" te lank is en/of koppeltekens bevat. Om toe te laat dat die uitgebeeld word, moet die kort naam afgeskaal word tot \'n maksimum van {$a->charlimit} karakters en enige koppeltekens moet verwyder word. <a href="{$a->link}">Edit the role</a>';
$string['connectingldap'] = 'Besig om aan LDAP bediener te koppel...';
$string['connectingldapsuccess'] = 'Die konnektering aan jou LDAP bediener was suksesvol.';
$string['creatingtemptable'] = 'Besig om tydelike tabel te skep {$a}';
$string['diag_contextnotfound'] = 'Konteks {$a} bestaan nie of kan nie deur BIND DN gelees word nie.';
$string['diag_emptycontext'] = 'Leë konteks gevind.';
$string['diag_genericerror'] = 'LDAP fout {$a->code} met lees van {$a->subject}: {$a->message}.';
$string['diag_rolegroupnotfound'] = 'Groep {$a->group} vir rol {$a->localname} bestaan nie of kan nie deur BIND DN gelees word nie.';
$string['diag_toooldversion'] = 'Dit is hoogs onwaarskynlik dat \'n moderne LDAP bediener LDAPv2 protokol gebruik. Verkeerde instellings kan waardes in gebruikersvelde korrupteer. Praat met jou LDAP administrateur.';
$string['didntfindexpiretime'] = 'password_expire() het nie die vervaldatum tyd gevind nie.';
$string['didntgetusersfromldap'] = 'Het nie enige gebruikers van LDAP -- fout? -- besig om die program te verlaat.';
$string['gotcountrecordsfromldap'] = 'Het {$a} rekords van LDAP gekry.';
$string['ldapnotconfigured'] = 'Die LDAP gasheer URL is nie tans gekonfigureer nie.';
$string['morethanoneuser'] = 'Meer as een gebruikersrekord in LDAP gevind. Slegs die eerste een gaan gebruik word.';
$string['needbcmath'] = 'Jy het die BCMath uitbreiding nodig om vervalle wagwoord kontolering met Aktiewe Leêrgids te gebruik.';
$string['needmbstring'] = 'Jy het die mbstring uitbreiding nodig om wagwoorde in Aktiewe Leêrgids te gebruik.';
$string['nodnforusername'] = 'Fout in user_update_password(). Geen DN vir: {$a->username}';
$string['noemail'] = 'Het probeer om vir jou \'n e-pos te stuur, maar het misluk!';
$string['notcalledfromserver'] = 'Behoort nie van die webbediener geroep te word nie!';
$string['noupdatestobedone'] = 'Geen opdaterings om gedoen te word nie.';
$string['nouserentriestoremove'] = 'Geen gebruikersinskrywings om te verwyder nie.';
$string['nouserentriestorevive'] = 'Geen gebruikersinskrywings om op t wek nie.';
$string['nouserstobeadded'] = 'Geen gebruikersinskrywings om by te voeg nie.';
$string['ntlmsso_attempting'] = 'Poog \'Single Sign On\' deur NTLM...';
$string['ntlmsso_failed'] = 'Outo-inteken het misluk, probeer die normale intekenblad...';
$string['ntlmsso_isdisabled'] = 'NTLM SSO is buite werking gestel.';
$string['ntlmsso_unknowntype'] = 'Onbekende ntlmsso tipe!';
$string['pagedresultsnotsupp'] = 'LDAP ondersteun nie resultate beperk per bladsy nie (of jou PHP weergawe bied nie ondersteuning hiervoor nie, of Moodle is gekonfigureer om LDP protokol weergawe 2 te gebruik, of Moodle kan nie jou LDAP bediener kontak om te sien of hierdie tipe ondersteuning beskikbaar is nie.)';
$string['pagesize'] = 'Maak seker dat hierdie waarde kleiner is as jou LDAP bediener resultaat gestelde grootte limiet (die maksimum getal inskrywings wat in \'n enkele navraag teruggegee kan word)';
$string['pagesize_key'] = 'Bladsy grootte';
$string['pluginname'] = 'LDAP bediener';
$string['pluginnotenabled'] = 'Inprop nie onstper nie!';
$string['privacy:metadata'] = 'Die LDAP bediener verifikasie inprop stoor nie enige persoonlike data nie.';
$string['renamingnotallowed'] = 'Gebruiker herbenaming nie toegelaat in LDAP nie.';
$string['rootdseerror'] = 'Fout tydens navraag oor rootDSE vir Aktiewe Leêrgids.';
$string['start_tls'] = 'Gebruik gewone LDAP diens (poort 389) met TLS enkripsie.';
$string['start_tls_key'] = 'Gebruik TLS';
$string['syncroles'] = 'Sinchroniseer stelsel rolle van LDAP';
$string['synctask'] = 'LDAP gebruikers sinchronisasie taak';
$string['systemrolemapping'] = 'Stelsel rol afbeelding';
$string['updatepasserror'] = 'Fout in user_update_password(). Foutkode: {$a->errno};Foutstring: {$a->errstring}';
$string['updatepasserrorexpire'] = 'Fout in user_update_password() wanneer wagwoord vervaltyd gelees word. Foutkode: {$a->errno}; Foutstring: {$a->errstring}';
$string['updatepasserrorexpiregrace'] = 'Fout in user_update_password() wanneer vervaltyd en / of grasie grasie intekens gewysig word. Foutkode: {$a->errno}; Foutstring: {$a->errstring}';
$string['updateremfail'] = 'Fout tydens opdatering van LDAP rekord. Foutkode: {$a->errno}; Foutstring: {$a->errstring}<br/>Key ({$a->key}) - ou Moodle waarde: \'{$a->ouvalue}\' nuwe waarde: \'{$a->nuvalue}\'';
$string['updateremfailamb'] = 'Het misluk om LDAP met dubbelsinnige veld op te dateer {$a->key}; Ou Moodle waarde: \'{$a->ouvalue}\', nuwe waarde: \'{$a->nuvalue}\'';
$string['updateusernotfound'] = 'Kon nie gebruiker vind terwyl opdatering ekstern plaasgevind het nie. Details volg: soek basis:  \'{$a->userdn}\'; soek filter: \'(objectClass=*)\'; soek eienskappe: {$a->attribs}';
$string['user_activatenotsupportusertype'] = 'auth: ldap user_activate() ondersteun nie geselekteerde gebruikerstipe nie: {$a}';
$string['user_disablenotsupportusertype'] = 'auth: ldap user_disable() ondersteun nie geselekteerde gebruikerstipe nie: {$a}';
$string['useracctctrlerror'] = 'Fout om userAccountControl vir {$a} te kry';
$string['userentriestoadd'] = 'Gebruikersinkrywings om by te voeg: {$a}';
$string['userentriestoremove'] = 'Gebruikersinskrywings wat verwyder moet word: {$a}';
$string['userentriestorevive'] = 'Gebruikersinskrywings wat opgewek moet word: {$a}';
$string['userentriestoupdate'] = 'Gebruikersinskrywings wat opgedateer moet word: {$a}';
$string['usernotfound'] = 'Gebruiker nie in LDAP gevind nie.';
