<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'competency', language 'ja', version '4.1'.
 *
 * @package     competency
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allchildrenarecomplete'] = 'すべての子が完了する';
$string['competencies'] = 'コンピテンシ';
$string['competenciesarenotenabled'] = 'コンピテンシは有効にされていません。';
$string['competenciessettings'] = 'コンピテンシ設定';
$string['completeplanstask'] = '期限が近づいている学習プランを完了する';
$string['coursecompetencyoutcome_complete'] = 'コンピテンシを完了する';
$string['coursecompetencyoutcome_evidence'] = 'エビデンスを添付する';
$string['coursecompetencyoutcome_none'] = '何もしない';
$string['coursecompetencyoutcome_recommend'] = 'レビューのために送信する';
$string['coursemodulecompetencyoutcome_complete'] = 'コンピテンシを完了する';
$string['coursemodulecompetencyoutcome_evidence'] = 'エビデンスを添付する';
$string['coursemodulecompetencyoutcome_none'] = '何もしない';
$string['coursemodulecompetencyoutcome_recommend'] = 'レビューのために送信する';
$string['deletecompetencyratings'] = 'コンピテンシ評定を削除する';
$string['duplicateditemname'] = '{$a} (コピー)';
$string['enablecompetencies'] = 'コンピテンシを有効にする';
$string['enablecompetencies_desc'] = 'コンピテンシで学習プランに沿ってユーザを評価できます。';
$string['errorcannotchangeapastduedate'] = '期限を経過しました。変更できません。';
$string['errorcannotsetduedateinthepast'] = '期限を過去には設定できません。';
$string['errorcannotsetduedatetoosoon'] = '期限が近すぎます。';
$string['errorcompetencyrule'] = '不明なコースコンピテンシルール「 {$a} 」です。';
$string['errorcoursecompetencyrule'] = '不明なコースコンピテンシルール「 {$a} 」です。';
$string['errorinvalidcourse'] = '無効なコースです。';
$string['errornocompetency'] = '{$a} コンピテンシが見つかりませんでした。';
$string['errorplanstatus'] = '不明な学習プラン「 {$a} 」ステータスです。';
$string['errorscalealreadyused'] = 'すでに使用されているため、尺度を変更できません。';
$string['errorscaleconfiguration'] = 'あなたはデフォルトおよび熟達アイテムを選択して尺度を設定する必要があります。';
$string['errorusercomptencystatus'] = '不明なユーザコンピテンシステータス「 {$a} 」です。';
$string['eventcompetencycreated'] = 'コンピテンシが作成されました。';
$string['eventcompetencydeleted'] = 'コンピテンシが削除されました。';
$string['eventcompetencyframeworkcreated'] = 'コンピテンシフレームワークが作成されました。';
$string['eventcompetencyframeworkdeleted'] = 'コンピテンシフレームワークが削除されました。';
$string['eventcompetencyframeworkupdated'] = 'コンピテンシフレームワークが更新されました。';
$string['eventcompetencyframeworkviewed'] = 'コンピテンシフレームワークが閲覧されました。';
$string['eventcompetencyupdated'] = 'コンピテンシが更新されました。';
$string['eventcompetencyviewed'] = 'コンピテンシが閲覧されました。';
$string['eventevidencecreated'] = 'エビデンスが作成されました。';
$string['eventplanapproved'] = '学習プランが承認されました。';
$string['eventplancompleted'] = '学習プランが完了しました。';
$string['eventplancreated'] = '学習プランが作成されました。';
$string['eventplandeleted'] = '学習プランが削除されました。';
$string['eventplanreopened'] = '学習プランが再オープンされました。';
$string['eventplanreviewrequestcancelled'] = '学習プランレビューリクエストがキャンセルされました。';
$string['eventplanreviewrequested'] = '学習プランレビューがリクエストされました。';
$string['eventplanreviewstarted'] = '学習プランレビューが開始されました。';
$string['eventplanreviewstopped'] = '学習プランレビューが中断されました。';
$string['eventplanunapproved'] = '学習プランが承認されませんでした。';
$string['eventplanunlinked'] = '学習プランがリンク解除されました。';
$string['eventplanupdated'] = '学習プランが更新されました。';
$string['eventplanviewed'] = '学習プランが閲覧されました。';
$string['eventtemplatecreated'] = '学習プランテンプレートが作成されました。';
$string['eventtemplatedeleted'] = '学習プランテンプレートが削除されました。';
$string['eventtemplateupdated'] = '学習プランテンプレートが更新されました。';
$string['eventtemplateviewed'] = '学習プランテンプレートが閲覧されました。';
$string['eventusercompetencyplanviewed'] = 'ユーザコンピテンシプランが閲覧されました。';
$string['eventusercompetencyrated'] = 'ユーザコンピテンシが評定されました。';
$string['eventusercompetencyratedincourse'] = 'ユーザコンピテンシがコースで評定されました。';
$string['eventusercompetencyratedinplan'] = 'ユーザコンピテンシが学習プランで評定されました。';
$string['eventusercompetencyreviewrequestcancelled'] = 'ユーザコンピテンシレビューリクエストがキャンセルされました。';
$string['eventusercompetencyreviewrequested'] = 'ユーザコンピテンシレビューがリクエストされました。';
$string['eventusercompetencyreviewstarted'] = 'ユーザコンピテンシレビューが開始されました。';
$string['eventusercompetencyreviewstopped'] = 'ユーザコンピテンシレビューが中断されました。';
$string['eventusercompetencyviewed'] = 'ユーザコンピテンシが閲覧されました。';
$string['eventusercompetencyviewedincourse'] = 'ユーザコンピテンシがコースで閲覧されました。';
$string['eventusercompetencyviewedinplan'] = 'ユーザコンピテンシが学習プランで閲覧されました。';
$string['eventuserevidencecreated'] = '事前学習エビデンスが作成されました。';
$string['eventuserevidencedeleted'] = '事前学習エビデンスが削除されました。';
$string['eventuserevidenceupdated'] = '事前学習エビデンスが更新されました。';
$string['evidence_competencyrule'] = 'コンピテンシのルールが合致しません。';
$string['evidence_coursecompleted'] = 'コース「 {$a} 」が完了しました。';
$string['evidence_coursemodulecompleted'] = '活動「 {$a} 」が完了しました。';
$string['evidence_courserestored'] = 'コース「 {$a} 」と共に評定がリストアされました。';
$string['evidence_evidenceofpriorlearninglinked'] = '事前学習エビデンス「 {$a} 」がリンクされました。';
$string['evidence_evidenceofpriorlearningunlinked'] = '事前学習エビデンス「 {$a} 」がリンク解除されました。';
$string['evidence_manualoverride'] = 'コンピテンシ評定が手動設定されました。';
$string['evidence_manualoverrideincourse'] = 'コンピテンシ評定がコース「 {$a} 」で手動設定されました。';
$string['evidence_manualoverrideinplan'] = 'コンピテンシ評定が学習プラン「 {$a} 」で手動設定されました。';
$string['invalidevidencedesc'] = '無効なエビデンス説明';
$string['invalidgrade'] = '無効な評定';
$string['invalidpersistenterror'] = 'エラー: {$a}';
$string['invalidplan'] = '無効な学習プラン';
$string['invalidtaxonomy'] = '無効な分類: {$a}';
$string['invalidurl'] = 'URLが有効ではありません。「http://」または「https://」で始まっていることをご確認ください。';
$string['nouserplanswithcompetency'] = 'このコンピテンシに学習プランは含まれていません。';
$string['planstatusactive'] = 'アクティブ';
$string['planstatuscomplete'] = '完了';
$string['planstatusdraft'] = '下書き';
$string['planstatusinreview'] = 'レビュー中';
$string['planstatuswaitingforreview'] = 'レビュー待ち';
$string['pointsrequiredaremet'] = '必須評点に合致する';
$string['privacy:evidence:action:complete'] = '評価されていない場合、コンピテンシを完了します。';
$string['privacy:evidence:action:log'] = 'ログアクションです。';
$string['privacy:evidence:action:override'] = 'コンピテンシ評価をオーバーライドします。';
$string['privacy:metadata:competency'] = 'コンピテンシのレコードです。';
$string['privacy:metadata:competency_coursecomp'] = 'コースにリンクされたコンピテンシのレコードです。';
$string['privacy:metadata:competency_coursecompsetting'] = 'コースで設定されたコンピテンシのレコードです。';
$string['privacy:metadata:competency_evidence'] = 'コンピテンシの状態に影響するエビデンスのレコードです。';
$string['privacy:metadata:competency_framework'] = 'コンピテンシフレームワークのレコードです。';
$string['privacy:metadata:competency_modulecomp'] = 'モジュールにリンクされたコンピテンシのレコードです。';
$string['privacy:metadata:competency_plan'] = '学習プランのレコードです。';
$string['privacy:metadata:competency_plancomp'] = '学習プラン内のコンピテンシのレコードです。';
$string['privacy:metadata:competency_relatedcomp'] = 'コンピテンシ間の関係性に関するレコードです。';
$string['privacy:metadata:competency_template'] = '学習プランテンプレートのレコードです。';
$string['privacy:metadata:competency_templatecohort'] = 'コーホートに関連する学習プランテンプレートのレコードです。';
$string['privacy:metadata:competency_templatecomp'] = '学習プランテンプレート内のコンピテンシのレコードです。';
$string['privacy:metadata:competency_usercomp'] = 'コンピテンシのユーザ状態のレコードです。';
$string['privacy:metadata:competency_usercompcourse'] = 'コース内コンピテンシのユーザ状態のレコードです。';
$string['privacy:metadata:competency_usercompplan'] = '学習プラン内コンピテンシの状態のレコードです。';
$string['privacy:metadata:competency_userevidence'] = '事前学習エビデンスのレコードです。';
$string['privacy:metadata:competency_userevidencecomp'] = '事前学習エビデンスに関連するコンピテンシのレコードです。';
$string['privacy:metadata:core_comments'] = '学習プランおよびコンピテンシに付けられたコメントです。';
$string['privacy:metadata:evidence:action'] = 'エビデンスと共に実行されたアクションのタイプです。';
$string['privacy:metadata:evidence:actionuserid'] = 'ユーザにより実行されたアクションです。';
$string['privacy:metadata:evidence:desca'] = '翻訳可能なエビデンス説明の任意パラメータです。';
$string['privacy:metadata:evidence:desccomponent'] = '翻訳可能なエビデンス説明のコンポーネントです。';
$string['privacy:metadata:evidence:descidentifier'] = '翻訳可能なエビデンス説明のIDです。';
$string['privacy:metadata:evidence:grade'] = 'エビデンスに関連する評定です。';
$string['privacy:metadata:evidence:note'] = 'エビデンスに添付されたローカライズされていないノートです。';
$string['privacy:metadata:evidence:url'] = 'エビデンスに関連するURLです。';
$string['privacy:metadata:plan:description'] = '学習プランの説明です。';
$string['privacy:metadata:plan:duedate'] = '学習プランの期限です。';
$string['privacy:metadata:plan:name'] = '学習プランの名称です。';
$string['privacy:metadata:plan:reviewerid'] = '学習プランのレビュアのIDです。';
$string['privacy:metadata:plan:status'] = '学習プランのステータスです。';
$string['privacy:metadata:plan:userid'] = '学習プランのユーザのIDです。';
$string['privacy:metadata:timecreated'] = 'レコードが作成された日時です。';
$string['privacy:metadata:timemodified'] = 'レコードが編集された日時です。';
$string['privacy:metadata:usercomp:grade'] = 'コンピテンシに付与された評点です。';
$string['privacy:metadata:usercomp:proficiency'] = '熟達度に達しているか示します。';
$string['privacy:metadata:usercomp:reviewerid'] = 'レビュアのIDです。';
$string['privacy:metadata:usercomp:status'] = 'コンピテンシのステータスです。';
$string['privacy:metadata:usercomp:userid'] = 'コンピテンシのユーザのIDです。';
$string['privacy:metadata:userevidence:description'] = 'エビデンスの説明です。';
$string['privacy:metadata:userevidence:name'] = '事前学習エビデンスの名称です。';
$string['privacy:metadata:userevidence:url'] = 'エビデンスに関連するURLです。';
$string['privacy:metadata:usermodified'] = 'レコードを作成または修正したユーザです。';
$string['privacy:path:plans'] = '学習プランです。';
$string['privacy:path:relatedtome'] = '私に関連します。';
$string['privacy:path:userevidence'] = '事前学習エビデンスです。';
$string['pushcourseratingstouserplans'] = 'コース評定を個別の学習プランに転送する';
$string['pushcourseratingstouserplans_desc'] = 'コースコンピテンシの評価時に更新する個人の学習プランのためのコース設定デフォルト値です。';
$string['syncplanscohorts'] = '学習プランテンプレートコーホートからプランを同期する';
$string['taxonomy_behaviour'] = '行動';
$string['taxonomy_competency'] = 'コンピテンシ';
$string['taxonomy_concept'] = 'コンセプト';
$string['taxonomy_domain'] = 'ドメイン';
$string['taxonomy_indicator'] = '指標';
$string['taxonomy_level'] = 'レベル';
$string['taxonomy_outcome'] = 'アウトカム';
$string['taxonomy_practice'] = 'プラクティス';
$string['taxonomy_proficiency'] = '熟達度';
$string['taxonomy_skill'] = 'スキル';
$string['taxonomy_value'] = '値';
$string['usercommentedonacompetency'] = '{$a->fullname} がコンピテンシ「 {$a->competency} 」にコメントしました:

{$a->comment}

詳細は次をご覧ください: {$a->url}';
$string['usercommentedonacompetencyhtml'] = '<p>{$a->fullname} がコンピテンシ「 {$a->competency} 」にコメントしました:</p>
<div>{$a->comment}</div>
<p>詳細は次をご覧ください: <a href="{$a->url}">{$a->urlname}</a></p>';
$string['usercommentedonacompetencysmall'] = '{$a->fullname} がコンピテンシ「 {$a->competency} 」にコメントしました。';
$string['usercommentedonacompetencysubject'] = '{$a} がコンピテンシにコメントしました。';
$string['usercommentedonaplan'] = '{$a->fullname} が学習プラン「 {$a->plan} 」にコメントしました:

{$a->comment}

詳細は次をご覧ください: {$a->url}';
$string['usercommentedonaplanhtml'] = '<p>{$a->fullname} が学習プラン「 {$a->plan} 」にコメントしました:</p>
<div>{$a->comment}</div>
<p>詳細は次をご覧ください: <a href="{$a->url}">{$a->urlname}</a></p>';
$string['usercommentedonaplansmall'] = '{$a->fullname} が学習プラン「 {$a->plan} 」にコメントしました。';
$string['usercommentedonaplansubject'] = '{$a} が学習プランにコメントしました。';
$string['usercompetencystatus_idle'] = '待機';
$string['usercompetencystatus_inreview'] = 'レビュー中';
$string['usercompetencystatus_waitingforreview'] = 'レビュー待ち';
$string['userplans'] = '学習プラン';
