<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'workshop', language 'hu', version '4.1'.
 *
 * @package     workshop
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitydate:assessmentsclose'] = 'Értékelések lezárulnak:';
$string['activitydate:assessmentsclosed'] = 'Értékelések lezárultak:';
$string['activitydate:assessmentsopen'] = 'Értékelések megnyílnak:';
$string['activitydate:assessmentsopened'] = 'Értékelések megnyíltak:';
$string['activitydate:submissionsclose'] = 'Leadások lezárulnak:';
$string['activitydate:submissionsclosed'] = 'Leadások lezárultak:';
$string['activitydate:submissionsopen'] = 'Leadások megnyílnak:';
$string['activitydate:submissionsopened'] = 'Leadások megnyíltak:';
$string['aggregategrades'] = 'Értékelések újraszámolása';
$string['aggregation'] = 'Értékelések összegzése';
$string['allocate'] = 'Leadott munkák hozzárendelése';
$string['allocatedetails'] = 'elvárt: {$a->expected}<br />leadott: {$a->submitted}<br />hozzárendelendő: {$a->allocate}';
$string['allocation'] = 'Leadott munkák hozzárendelése';
$string['allocationconfigured'] = 'Hozzárendelés beállítva';
$string['allocationdone'] = 'Hozzárendelés kész';
$string['allocationerror'] = 'Hozzárendelési hiba';
$string['allowedfiletypesforoverallfeedback'] = 'Visszajelzéshez csatolható állományok';
$string['allowedfiletypesforoverallfeedback_help'] = 'A visszajelzéshez csatolható állományok körét vesszővel ellátott listával szűkítheti. Ha üresen hagyja, mindenféle állománytípus engedélyezett lesz.';
$string['allowedfiletypesforoverallfeedback_link'] = 'admin/tool/filetypes/index';
$string['allowedfiletypesforsubmission'] = 'Leadott munkához csatolható állományok';
$string['allowedfiletypesforsubmission_help'] = 'A leadott munkához csatolható állományok körét vesszővel ellátott listával szűkítheti. Ha üresen hagyja, mindenféle állománytípus engedélyezett lesz.';
$string['allowedfiletypesforsubmission_link'] = 'admin/tool/filetypes/index';
$string['allsubmissions'] = 'Minden leadott ({$a}) munka';
$string['alreadygraded'] = 'Már értékelve';
$string['areaconclusion'] = 'Összegzés szövege';
$string['areainstructauthors'] = 'Leadási tudnivalók';
$string['areainstructreviewers'] = 'Értékelési tudnivalók';
$string['areaoverallfeedbackattachment'] = 'Általános visszajelzési csatolmányok';
$string['areaoverallfeedbackcontent'] = 'Általános visszajelzési szövegek';
$string['areasubmissionattachment'] = 'Leadott munka csatolmányai';
$string['areasubmissioncontent'] = 'Leadott szövegek';
$string['assess'] = 'Értékelés';
$string['assessedexample'] = 'Értékelt példamunka';
$string['assessedsubmission'] = 'Értékelt leadott munka';
$string['assessingexample'] = 'Példamunka értékelése';
$string['assessingsubmission'] = 'Leadott munka értékelése';
$string['assessment'] = 'Értékelés';
$string['assessmentby'] = '<a href="{$a->url}">{$a->name}</a> értékelte';
$string['assessmentbyfullname'] = 'Értékelte {$a}';
$string['assessmentbyyourself'] = 'Saját értékelés';
$string['assessmentdeleted'] = 'Értékelés hozzárendelése törölve';
$string['assessmentend'] = 'Értékelés határideje';
$string['assessmentendbeforestart'] = 'Az értékelés határideje nem előzheti meg az értékelhetőségi időtartamot.';
$string['assessmentenddatetime'] = 'Értékelés határideje: {$a->daydatetime} ({$a->distanceday})';
$string['assessmentendevent'] = '{$a} értékelés határideje';
$string['assessmentform'] = 'Értékelő űrlap';
$string['assessmentofsubmission'] = '<a href="{$a->submissionurl}">{$a->submissiontitle}</a> <a href="{$a->assessmenturl}">értékelése</a>';
$string['assessmentreference'] = 'Referenciaértékelés';
$string['assessmentreferenceconflict'] = 'Nem lehet olyan példaleadást értékelni, amelyhez referenciaértékelést adott meg.';
$string['assessmentreferenceneeded'] = 'Referenciaértékeléshez értékelnie kell ezt a példamunkát. A leadott munka értékeléséhez kattintson a \'Tovább\' gombra.';
$string['assessments'] = 'Értékelések';
$string['assessmentsettings'] = 'Értékelési beállítások';
$string['assessmentstart'] = 'Értékelés elkezdése';
$string['assessmentstartdatetime'] = 'Értékelhető {$a->daydatetime} időponttól ({$a->distanceday})';
$string['assessmentstartevent'] = '{$a} megnyílik értékelésre';
$string['assessmentweight'] = 'Értékelési súly';
$string['assignedassessments'] = 'Értékelendő hozzárendelt leadott munkák';
$string['assignedassessmentsnone'] = 'Önnek nincs értékelendő hozzárendelt leadott munkája';
$string['backtoeditform'] = 'Vissza az űrlap szerkesztéséhez';
$string['byfullname'] = 'név: <a href="{$a->url}">{$a->name}</a>';
$string['byfullnamewithoutlink'] = 'készítette  {$a}';
$string['calculategradinggrades'] = 'Leadott munkák értékelésének kiszámítása';
$string['calculategradinggradesdetails'] = 'elvárt: {$a->expected}<br />kiszámított: {$a->calculated}';
$string['calculatesubmissiongrades'] = 'Leadott munkák értékelésének kiszámítása';
$string['calculatesubmissiongradesdetails'] = 'elvárt: {$a->expected}<br />kiszámított: {$a->calculated}';
$string['chooseuser'] = 'Felhasználó kiválasztása...';
$string['clearaggregatedgrades'] = 'Minden összegzett értékelés törlése';
$string['clearaggregatedgrades_help'] = 'A leadott munkákra kiszámított összegzett értékelések és az értékelések értékelései visszaállítódnak. Az Értékelések értékelése szakaszban ezek kiszámítására újra lehetőség lesz.';
$string['clearaggregatedgradesconfirm'] = 'Biztosan törli a leadott munkákra kiszámított összegzett értékeléseket és az értékelések értékeléseit?';
$string['clearassessments'] = 'Értékelések törlése';
$string['clearassessments_help'] = 'A leadott munkákra kiszámított összegzett értékelések és az értékelések értékelései visszaállítódnak. Az értékelő űrlapok kitöltésére vonatkozó információk megőrződnek, de az értékelőknek újból meg kell nyitniuk az értékelő űrlapokat, majd az értékelések újraszámításához ismét el kell őket menteniük.';
$string['clearassessmentsconfirm'] = 'Biztosan kitörli minden értékelés értékelését? Az adatokat egyedül nem fogja tudni visszaállítani, az értékelőknek újból értékelniük kell minden hozzárendelt leadott munkát.';
$string['conclusion'] = 'Összegzés';
$string['conclusion_help'] = 'Az összegzés a résztvevők számára a tevékenység végén megjelenő szöveg.';
$string['configexamplesmode'] = 'Példaértékelés alapbeállítása a műhelymunkákban';
$string['configgrade'] = 'A műhelymunkákban a leadott munkára kapható legjobb értékelés alapértelmezése';
$string['configgradedecimals'] = 'Értékelések megjelenítése során a tizedesjel után használt számjegyek alapértelmezett száma.';
$string['configgradinggrade'] = 'A műhelymunkákban az értékelésre kapható legjobb értékelés alapértelmezése';
$string['configmaxbytes'] = 'A portál összes műhelymunkájában leadható munka alapbeállítás szerinti maximális mérete (a kurzuskorlátok és más helyi beállítások függvényében)';
$string['configstrategy'] = 'A műhelymunkák alapértelmezett értékelési stratégiája';
$string['createsubmission'] = 'Leadott munka hozzáadása';
$string['crontask'] = 'Háttérfeldolgozás a műhelymodulhoz';
$string['daysago'] = '{$a} nappal ezelőtt';
$string['daysleft'] = '{$a} nap van hátra';
$string['daystoday'] = 'ma';
$string['daystomorrow'] = 'holnap';
$string['daysyesterday'] = 'tegnap';
$string['deadlinesignored'] = 'Az időkorlátozás Önre nem vonatkozik.';
$string['deletesubmission'] = 'Leadás törlése';
$string['editassessmentform'] = 'Értékelő űrlap szerkesztése';
$string['editassessmentformstrategy'] = 'Értékelő űrlap szerkesztése ({$a})';
$string['editingassessmentform'] = 'Értékelő űrlap szerkesztése folyamatban';
$string['editingsubmission'] = 'Leadott munka szerkesztése';
$string['editsubmission'] = 'Leadott munka szerkesztése';
$string['err_multiplesubmissions'] = 'Az űrlap szerkesztése közben a leadott munka másik változatának mentésére került sor. Egy felhasználótól csak egy leadott munkára van lehetőség.';
$string['err_removegrademappings'] = 'Nem sikerül törölni a nem használt értékelésmegfeleltetéseket';
$string['evaluategradeswait'] = 'Kérjük várjon, amíg a leadott munkák értékelése megtörténik!';
$string['evaluation'] = 'Értékelés értékelése';
$string['evaluationmethod'] = 'Értékelés értékelési módszer';
$string['evaluationmethod_help'] = 'Az értékelés értékelési módszere szabja meg az értékelésre adott értékelés kiszámításának módját. Ha nem elégedett az eredménnyel, más beállításokkal újraszámolhatja az értékeléseket.';
$string['evaluationsettings'] = 'Értékelés értékelési beállítások';
$string['eventassessableuploaded'] = 'Leadott munkát töltöttek fel.';
$string['eventassessmentevaluated'] = 'Értékelés elbírálva';
$string['eventassessmentevaluationsreset'] = 'Értékelések elbírálása visszaállítva';
$string['eventassessmentreevaluated'] = 'Értékelés újból elbírálva';
$string['eventphaseautomaticallyswitched'] = 'Szakasz automatikusan átváltva';
$string['eventphaseswitched'] = 'Szakasz átváltva';
$string['eventsubmissionassessed'] = 'Leadott munka értékelve';
$string['eventsubmissionassessmentsreset'] = 'Leadott munkák értékelése törölve';
$string['eventsubmissioncreated'] = 'Leadott munka létrehozva';
$string['eventsubmissiondeleted'] = 'Leadás törölve';
$string['eventsubmissionreassessed'] = 'Leadott munka újraértékelve';
$string['eventsubmissionupdated'] = 'Leadott munka frissítve';
$string['eventsubmissionviewed'] = 'Leadott munka megtekintve';
$string['example'] = 'Példamunka';
$string['exampleadd'] = 'Példamunka hozzáadása';
$string['exampleassess'] = 'Példamunka értékelése';
$string['exampleassessments'] = 'Értékelendő példamunkák';
$string['exampleassesstask'] = 'Példák értékelése';
$string['exampleassesstaskdetails'] = 'elvárt: {$a->expected}<br />értékelt: {$a->assessed}';
$string['examplecomparing'] = 'Példamunka értékeléseinek egybevetése';
$string['exampledelete'] = 'Példa törlése';
$string['exampledeleteconfirm'] = 'Biztosan törli a következő példamunkát? A leadott munka törléséhez kattintson a \'Tovább\' gombra.';
$string['exampleedit'] = 'Példa szerkesztése';
$string['exampleediting'] = 'Példa szerkesztése folyamatban';
$string['exampleneedassessed'] = 'Először értékelnie kell az összes példamunkát.';
$string['exampleneedsubmission'] = 'Először le kell adnia munkáját és értékelnie kell az összes példamunkát.';
$string['examplesbeforeassessment'] = 'A példák a saját leadás után érhetők el, és értékelésükre még a csoporttársi értékelés előtt sort kell keríteni';
$string['examplesbeforesubmission'] = 'A példákat a saját munka leadása előtt értékelni kell.';
$string['examplesmode'] = 'A példaértékelés módja';
$string['examplesubmissions'] = 'Példamunkák';
$string['examplesvoluntary'] = 'A példamunka értékelése önkéntes.';
$string['exportsubmission'] = 'Oldal exportálása';
$string['feedbackauthor'] = 'Visszajelzés a szerzőnek';
$string['feedbackauthorattachment'] = 'Csatolmány';
$string['feedbackby'] = '{$a} visszajelzése';
$string['feedbackreviewer'] = 'Visszajelzés az értékelőnek';
$string['feedbacksettings'] = 'Visszajelzés';
$string['formataggregatedgrade'] = '{$a->grade}';
$string['formataggregatedgradeover'] = '<del>{$a->grade}</del><br /><ins>{$a->over}</ins>';
$string['formatpeergrade'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span>';
$string['formatpeergradeover'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span>';
$string['formatpeergradeoverweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">(<del>{$a->gradinggrade}</del> / <ins>{$a->gradinggradeover}</ins>)</span> @ <span class="weight">{$a->weight}</span>';
$string['formatpeergradeweighted'] = '<span class="grade">{$a->grade}</span> <span class="gradinggrade">({$a->gradinggrade})</span> @ <span class="weight">{$a->weight}</span>';
$string['givengrades'] = 'Adott értékelések';
$string['grade_grading_name'] = 'Értékelés';
$string['grade_submission_name'] = 'Leadott munka';
$string['gradecalculated'] = 'A leadott munkára adott, számított értékelés';
$string['gradedecimals'] = 'Tizedesjegyek az értékelésekben';
$string['gradegivento'] = '&gt;';
$string['gradeinfo'] = 'Értékelés: {$a->received} / {$a->max}';
$string['gradeitemassessment'] = '{$a->workshopname} (értékelés)';
$string['gradeitemsubmission'] = '{$a->workshopname} (leadott munka)';
$string['gradeover'] = 'Leadott munkára adott értékelés felülírása';
$string['gradereceivedfrom'] = '&lt;';
$string['gradesreport'] = 'Műhelymunka értékelések jelentés';
$string['gradetopassgrading'] = 'Értékelés ponthatára';
$string['gradetopasssubmission'] = 'Leadott munka ponthatára';
$string['gradinggrade'] = 'Értékelésre adott értékelés';
$string['gradinggrade_help'] = 'Ez a beállítás adja meg a leadott munkák értékeléséért kapható legjobb értékelést.';
$string['gradinggradecalculated'] = 'Értékelésre adott, számított értékelés';
$string['gradinggradeof'] = 'Értékelésre adott értékelés (/ {$a})';
$string['gradinggradeover'] = 'Értékelésre adott értékelés felülírása';
$string['gradingsettings'] = 'Értékelési beállítások';
$string['groupnoallowed'] = 'Ebben a műhelymunkában nem érhet el csoportokat';
$string['iamsure'] = 'Igen, biztosan.';
$string['indicator:cognitivedepth'] = 'Kognitív  műhely';
$string['indicator:cognitivedepth_help'] = 'Ez a jelző a tanuló által egy műhelymunka során elért kognitív mélységet mutatja.';
$string['indicator:cognitivedepthdef'] = 'Kognitív műhely';
$string['indicator:cognitivedepthdef_help'] = 'A résztvevő az elemzési időszak alatt a Műhely tevékenységei során kognitív elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs megtekintés, Megtekintés, Leadás, Visszajelzés megtekintése, Visszajelzéshez kapcsolódó megjegyzés, Újbóli leadás visszajelzés megtekintése után)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Társas műhely';
$string['indicator:socialbreadth_help'] = 'Ez a jelző a tanuló által egy műhelymunka során elért társas lefedettséget mutatja.';
$string['indicator:socialbreadthdef'] = 'Társas műhely';
$string['indicator:socialbreadthdef_help'] = 'A résztvevő az elemzési időszak alatt a Műhely tevékenységei során társas elfoglaltság terén ezt a százalékot érte el (Szintek - Nincs részvétel, Egyedüli részvétel, Másokkal együtt való részvétel)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Infó';
$string['instructauthors'] = 'Utasítások a leadott munkához';
$string['instructreviewers'] = 'Utasítások az értékeléshez';
$string['introduction'] = 'Leírás';
$string['latesubmissions'] = 'Későn leadott munkák';
$string['latesubmissions_desc'] = 'Munkák határidő utáni leadásának engedélyezése';
$string['latesubmissions_help'] = 'Bekapcsolása esetén a szerzők munkájukat a leadási határidő után vagy az értékelési szakaszban is leadhatják. A későn leadott munkákat azonban nem lehet szerkeszteni.';
$string['latesubmissionsallowed'] = 'Későn leadott munkák megengedettek';
$string['legacyallocationplugincron'] = 'Műhely régi cron hozzárendelése';
$string['maxbytes'] = 'Leadott munka mellékletének maximális mérete';
$string['modulename'] = 'Műhelymunka';
$string['modulename_help'] = 'A Műhelymunka tevékenységmodul lehetővé teszi a tanulók munkájának gyűjtését, ellenőrzését és tanulótárs általi értékelését.

A tanulók digitális tartalmakat (állományokat), például Word-dokumentumokat, táblázatokat stb. adhatnak le, vagy a szövegszerkesztővel közvetlenül szöveget írhatnak be egy mezőbe.

A leadott munkák értékelése a tanár által meghatározott többféle értékelési kritériumot magában foglaló űrlapon történik. A tanulótárs általi értékelést és az értékelő űrlap használatát a tanár által biztosított leadásmintákon és mintaértékeléseken lehet előre gyakorolni. A tanulók egy vagy több társuk leadott munkáját is értékelhetik. Ha szükséges, mind a leadott munkák, mind az értékelők névtelensége megőrizhető.

A tanulók a műhelymunkára két értékelést kapnak: egyet leadott munkájukra, egyet pedig társaik leadott munkájának értékelésére. Mindkét értékelés bekerül az értékelésnaplóba.';
$string['modulename_link'] = 'mod/workshop/view';
$string['modulenameplural'] = 'Műhelymunkák';
$string['myassessments'] = 'Értékeléseim';
$string['mysubmission'] = 'Leadott munkám';
$string['nattachments'] = 'Leadott munkák csatolmányainak maximális száma';
$string['noexamples'] = 'A műhelymunkában még nincs példa';
$string['noexamplesformready'] = 'Példamunkák megadása előtt el kell készíteni az értékelési űrlapot';
$string['nogradeyet'] = 'Még nincs értékelés';
$string['nosubmissionfound'] = 'A felhasználóhoz nincs leadott munka';
$string['nosubmissions'] = 'A műhelymunkában még nincs leadott munka';
$string['nosubmissiontype'] = 'Legalább egy leadási típussal rendelkezni kell';
$string['notassessed'] = 'Még nincs értékelve';
$string['nothingfound'] = 'Nincs semmi megjelenítendő';
$string['nothingtoreview'] = 'Nincs mit felülvizsgálni';
$string['notoverridden'] = 'Nincs felülírva';
$string['noworkshops'] = 'A kurzusban nincs műhelymunka';
$string['noyoursubmission'] = 'Még nem adta le munkáját.';
$string['nullgrade'] = '-';
$string['overallfeedback'] = 'Általános visszajelzés';
$string['overallfeedbackfiles'] = 'Általános visszajelzési csatolmányok maximális száma';
$string['overallfeedbackmaxbytes'] = 'Globális visszajelzés mellékletének maximális mérete';
$string['overallfeedbackmode'] = 'Általános visszajelzési üzemmód';
$string['overallfeedbackmode_0'] = 'Kikapcsolva';
$string['overallfeedbackmode_1'] = 'Bekapcsolva és választható';
$string['overallfeedbackmode_2'] = 'Bekapcsolva és kötelező';
$string['overallfeedbackmode_help'] = 'Bekapcsolása esetén az értékelőlap alján megjelenik egy szövegmező. Az értékelők a leadott munka globális értékelését itt rögzítik, vagy további magyarázatot fűznek értékelésükhöz.';
$string['page-mod-workshop-x'] = 'Műhelymodul tetszőleges oldala';
$string['participant'] = 'Résztvevő';
$string['participantrevierof'] = 'A résztvevő ezt értékeli:';
$string['participantreviewedby'] = 'A résztvevőt ez felülvizsgálja:';
$string['phaseassessment'] = 'Értékelési szakasz';
$string['phaseclosed'] = 'Lezárva';
$string['phaseevaluation'] = 'Értékelés értékelési szakasz';
$string['phasesetup'] = 'Beállítási szakasz';
$string['phasesoverlap'] = 'A leadási és az értékelési szakasz nem eshet egybe!';
$string['phasesubmission'] = 'Leadási szakasz';
$string['pluginadministration'] = 'Műhelymunka adminisztrálása';
$string['pluginname'] = 'Műhelymunka';
$string['prepareexamples'] = 'Példamunkák előkészítése';
$string['previewassessmentform'] = 'Előnézet';
$string['privacy:metadata:aggregatedgradinggrade'] = 'Az adott műhelymunka során a felhasználó által készített összes értékelés összesített értékelése';
$string['privacy:metadata:assessmentgrade'] = 'Az értékelésben javasolt összesített értékelés a leadott munkára';
$string['privacy:metadata:assessmentgradinggrade'] = 'Az értékelésre adott értékelés';
$string['privacy:metadata:assessmentgradinggradeover'] = 'Az értékelésre adott értékelés kézzel fölülírt értéke';
$string['privacy:metadata:assessmentid'] = 'Az értékelés azonosítója';
$string['privacy:metadata:authorid'] = 'A leadott munka szerzőjének az azonosítója';
$string['privacy:metadata:dimensiongrade'] = 'Az adott értékelési kritériumnál adott értékelés';
$string['privacy:metadata:dimensionid'] = 'Az értékelési kritériumok azonosítója';
$string['privacy:metadata:example'] = 'A rekord egy példamunka-e';
$string['privacy:metadata:feedbackauthor'] = 'Visszajelzés a szerzőnek';
$string['privacy:metadata:feedbackauthorformat'] = 'A szerzőnek szóló visszajelzés szövegformája';
$string['privacy:metadata:feedbackreviewer'] = 'Visszajelzés az értékelést leadó felhasználónak';
$string['privacy:metadata:feedbackreviewerformat'] = 'Az értékelést leadó felhasználónak szóló visszajelzés szövegformája';
$string['privacy:metadata:late'] = 'A leadott munka határidő után érkezett-e';
$string['privacy:metadata:peercomment'] = 'Az értékelést leadó felhasználó megjegyzése az adott értékeléshez';
$string['privacy:metadata:peercommentformat'] = 'Az adott értékeléshez fűzött megjegyzés szöveges formája';
$string['privacy:metadata:preference:perpage'] = 'Hány leadott munkát kíván a felhasználó egy oldalon látni';
$string['privacy:metadata:preference:viewlet-allexamples-collapsed'] = 'A \'Példamunkák\' nézet összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-allsubmissions-collapsed'] = 'A \'Műhelymunka leadott munkáiról szóló jelentés\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-assessmentform-collapsed'] = 'Az \'Értékelő űrlap\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-assignedassessments-collapsed'] = 'Az \'Értékelendő kiosztott leadott munkák\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-cleargrades-collapsed'] = 'A \'Műhelymunka eszközkészlete\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-conclusion-collapsed'] = 'A \'Megállapítás\' nézet összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-examples-collapsed'] = 'Az \'Értékelendő példamunkák\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-examplesfail-collapsed'] = 'Az \'Értékelendő példamunkák\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-gradereport-collapsed'] = 'A \'Műhelymunka értékelések jelentés\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-instructauthors-collapsed'] = 'A \'Leadott munkákhoz kapcsolódó utasítások\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-instructreviewers-collapsed'] = 'Az \'Értékelési utasítások\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-intro-collapsed'] = 'A \'Bevezetés\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-overallfeedback-collapsed'] = 'Az \'Összegző visszajelzés\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-ownsubmission-collapsed'] = 'A \'Leadott munkája\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-publicsubmissions-collapsed'] = 'A \'Közzétett leadott munkák\' nézetének összecsukott/kibontott állapota.';
$string['privacy:metadata:preference:viewlet-yourgrades-collapsed'] = 'Az \'Értékelései\' nézet összecsukott/kibontott állapota.';
$string['privacy:metadata:published'] = 'Minden résztvevő megkapja-e a leadott munkát a műhelymunka lezárásakor';
$string['privacy:metadata:reviewerid'] = 'Az értékelést leadó felhasználó azonosítója';
$string['privacy:metadata:strategy'] = 'A rekord értékeit értelmező, értékelési stratégiával foglalkozó segédprogram neve';
$string['privacy:metadata:submissioncontent'] = 'A leadott munka tartalma';
$string['privacy:metadata:submissioncontentformat'] = 'A leadott munka tartalmának szövegformája';
$string['privacy:metadata:submissiongrade'] = 'A leadott munkáért járó összesített értékelés tizedesjegyben 0..100 között';
$string['privacy:metadata:submissiongradeover'] = 'Az összesített értékelés kézzel fölülírt értéke';
$string['privacy:metadata:submissionid'] = 'A leadott munka azonosítója';
$string['privacy:metadata:submissiontitle'] = 'A leadott munka címe';
$string['privacy:metadata:subsystem:corefiles'] = 'A műhelymodul a leadott munka szövegébe beágyazott / hozzá mellékelt állományokat tárol';
$string['privacy:metadata:subsystem:coreplagiarism'] = 'A műhelymodul támogatja a tiltott másolás megelőzését';
$string['privacy:metadata:timeaggregated'] = 'Az összesített értékelés utolsó kiszámításának az ideje';
$string['privacy:metadata:timecreated'] = 'Mikor jött lére az adatbázisrekord';
$string['privacy:metadata:timemodified'] = 'Mikor módosult utoljára az adatbázisrekord';
$string['privacy:metadata:userid'] = 'Azon felhasználó azonosítója, akinek az összesített értékelését kiszámították';
$string['privacy:metadata:weight'] = 'Az értékelés súlya';
$string['privacy:metadata:workshopaggregations'] = 'Az értékelés összesített értékeléseit tárolja';
$string['privacy:metadata:workshopassessments'] = 'A műhelymunka leadott munkáinak hozzárendelt értékeléseire vonatkozó adatokat tárol';
$string['privacy:metadata:workshopgrades'] = 'Az értékelő űrlapok értékelésekkel és megjegyzésekkel való kitöltésére vonatkozó adatokat tárol';
$string['privacy:metadata:workshopid'] = 'A műhelymunka azonosítója';
$string['privacy:metadata:workshopsubmissions'] = 'A műhelymunka leadott munkáira vonatkozó adatokat tárol';
$string['privacy:request:delete:content'] = 'A tartalmat (a felhasználó kérésére vagy lejárat miatt) töröltük.';
$string['privacy:request:delete:title'] = '[Törölve]';
$string['publishedsubmissions'] = 'Közzétett leadott munkák';
$string['publishsubmission'] = 'Leadott munka közzététele';
$string['publishsubmission_help'] = 'A közzétett leadott munkákat a többiek a műhelymunka lezárását követően érhetik el.';
$string['reassess'] = 'Újraértékelés';
$string['receivedgrades'] = 'Kapott értékelések';
$string['recentassessments'] = 'Műhelymunka értékelései:';
$string['recentsubmissions'] = 'Műhelymunka leadott munkái:';
$string['resetassessments'] = 'Az összes értékelés törlése';
$string['resetassessments_help'] = 'Választhat úgy, hogy csak a kijelölt értékeléseket törli a leadott munkák érintetlenül hagyása mellett. Leadott munkák törlése esetén velük törlődnek az értékeléseik is. A művelet kiterjed a példamunkák értékeléseire is.';
$string['resetphase'] = 'Átváltás a beállítási szakaszra.';
$string['resetphase_help'] = 'Bekapcsolása esetén minden műhelymunka a kezdeti beállítási szakaszba kerül.';
$string['resetsubmissions'] = 'Minden leadott munka törlése';
$string['resetsubmissions_help'] = 'Minden leadott munka értékelésével együtt törlődik. A példamunkákat ez nem érinti.';
$string['saveandclose'] = 'Mentés és bezárás';
$string['saveandcontinue'] = 'Mentés és a szerkesztés folytatása';
$string['saveandpreview'] = 'Mentés és előzetes megtekintés';
$string['saveandshownext'] = 'Mentés és a következő megjelenítése';
$string['search:activity'] = 'Műhelytevékenységek';
$string['selfassessmentdisabled'] = 'Önértékelés kikapcsolva';
$string['showingperpage'] = 'Oldalanként {$a} tétel megjelenítése';
$string['showingperpagechange'] = 'Módosítás ...';
$string['someuserswosubmission'] = 'Legalább egy szerző még nem adta le munkáját';
$string['sortasc'] = 'Növekvő sorrendben';
$string['sortdesc'] = 'Csökkenő sorrendben';
$string['strategy'] = 'Értékelési stratégia';
$string['strategy_help'] = 'Az értékelési stratégia határozza meg a használandó értékelő űrlapot és a leadott munkák értékelési módját. 4 lehetőség elérhető:

* Összegző értékelés - Meghatározott szempontok szerint megjegyzések és értékelések adása is
* Megjegyzések - Meghatározott szempontok szerint megjegyzések írása, de nincs értékelés
* Hibaszám - Meghatározott állítások mentén megjegyzések és igen/nem értékelés adása
* Rubrika - Meghatározott feltételek alapján szint szerinti értékelés adása';
$string['strategyhaschanged'] = 'A műhelymunka értékelési stratégiája módosult az űrlap szerkesztésre való megnyitása óta.';
$string['submission'] = 'Leadott munka';
$string['submissionattachment'] = 'Csatolmány';
$string['submissionby'] = 'Leadta: {$a}';
$string['submissioncontent'] = 'Leadott munka tartalma';
$string['submissiondeleteconfirm'] = 'Biztosan törli az alábbi leadott munkát?';
$string['submissiondeleteconfirmassess'] = 'Biztosan törli az alábbi leadott munkát? Vele együtt {$a->count} értékelést is törölni fog, ami befolyásolhatja a bírálók értékeléseit.';
$string['submissionend'] = 'Leadott munkák határideje';
$string['submissionendbeforestart'] = 'A leadás határideje nem előzheti meg a leadási időtartamot.';
$string['submissionenddatetime'] = 'Leadott munkák határideje: {$a->daydatetime} ({$a->distanceday})';
$string['submissionendevent'] = '{$a} leadási határidő';
$string['submissionendswitch'] = 'A leadás határideje után átváltás a következő szakaszra';
$string['submissionendswitch_help'] = 'Ha van megadva leadási határidő és a négyzet be van jelölve, a műhelymunka a leadási határidő után automatikusan értékelési szakaszba kapcsol.
Bekapcsolása esetén ajánlatos az ütemezett hozzárendelést is beállítani, ellenkező esetben akkor sem lehet az értékelést elvégezni, ha a műhelymunka már az értékelési szakaszba jutott.';
$string['submissiongrade'] = 'Leadott munkára adott értékelés';
$string['submissiongrade_help'] = 'Ez a beállítás határozza meg a leadott munkára adható legjobb értékelést.';
$string['submissiongradeof'] = 'Leadott munkára adott értékelés (/ {$a})';
$string['submissionlastmodified'] = 'Utolsó módosítás';
$string['submissionrequiredcontent'] = 'Írjon be szöveget vagy adjon hozzá egy állományt.';
$string['submissionrequiredfile'] = 'Adjon hozzá egy állományt vagy írjon be szöveget.';
$string['submissionsallocation'] = 'Leadott munkák kiosztása';
$string['submissionsettings'] = 'Leadott munka beállításai';
$string['submissionsreport'] = 'Műhely leadott munkáiról szóló jelentés';
$string['submissionstart'] = 'Munkák leadásának kezdete';
$string['submissionstartdatetime'] = 'Leadható ekkortól:  {$a->daydatetime} ({$a->distanceday})';
$string['submissionstartevent'] = '{$a} megnyílik leadásra';
$string['submissiontitle'] = 'Cím';
$string['submissiontypedisabled'] = 'A műhelymunka esetén ez a leadási típus nem elérhető.';
$string['submissiontypefileavailable'] = 'A csatolmány <span class="accesshide"> elérhető</span>';
$string['submissiontypefilerequired'] = '<span class="accesshide">Csatolmány </span>Szükséges';
$string['submissiontypes'] = 'Leadási típusok';
$string['submissiontypetextavailable'] = 'Online szöveg<span class="accesshide"> elérhető</span>';
$string['submissiontypetextrequired'] = '<span class="accesshide">Online szöveg </span>Szükséges';
$string['submittednotsubmitted'] = 'Leadta ({$a->submitted}) / nem adta le ({$a->notsubmitted})';
$string['subplugintype_workshopallocation'] = 'Leadások hozzárendelésének módja';
$string['subplugintype_workshopallocation_plural'] = 'Leadások hozzárendelésének módjai';
$string['subplugintype_workshopeval'] = 'Értékelés értékelési módszer';
$string['subplugintype_workshopeval_plural'] = 'Értékelés értékelési módszerek';
$string['subplugintype_workshopform'] = 'Értékelési stratégia';
$string['subplugintype_workshopform_plural'] = 'Értékelési stratégiák';
$string['switchingphase'] = 'Szakasz átváltása folyamatban';
$string['switchphase'] = 'Szakasz átváltása';
$string['switchphase10'] = 'Átváltás a beállítási szakaszra';
$string['switchphase10info'] = 'A műhelymunkát <strong>beállítási szakaszba</strong> fogja átkapcsolni. Ezalatt a felhasználók nem módosíthatják leadott munkáikat vagy értékeléseiket. A tanárok ebben a szakaszban módosíthatják a műhelymunka beállításait és az értékelő űrlapok értékelési stratégiáját.';
$string['switchphase20'] = 'Átváltás a leadási szakaszra';
$string['switchphase20info'] = 'A műhelymunkát <strong>leadási szakaszba</strong> fogja átkapcsolni. Ezalatt a tanulók leadhatják munkájukat (ha van beállítva, akkor a leadott munkához való hozzáférés időtartama alatt). A tanárok a leadott munkákat kioszthatják csoporttársak általi ellenőrzésre.';
$string['switchphase30'] = 'Átváltás a felmérési szakaszra';
$string['switchphase30auto'] = '({$a->distanceday}) {$a->daydatetime} után a műhelymunka automatikusan értékelési szakaszba kerül.';
$string['switchphase30info'] = 'A műhelymunkát <strong>értékelési szakaszba</strong> fogja átkapcsolni. Ezalatt az érrtékelők értékelhetik a nekik kiosztott munkákat (ha van beállítva, akkor az értékeléshez való hozzáférés időtartama alatt).';
$string['switchphase40'] = 'Átváltás az értékelési szakaszra';
$string['switchphase40info'] = 'A műhelymunkát <strong>Értékelés értékelése szakaszba</strong> fogja átkapcsolni. Ezalatt a felhasználók nem módosíthatják leadott munkáikat vagy értékeléseiket. A tanárok az értékelés értékelő eszközökkel kiszámíthatják a végső értékelést és visszajelzést küldhetnek az értékelőknek.';
$string['switchphase50'] = 'Műhelymunka bezárása';
$string['switchphase50info'] = 'Ezzel a műhelymunkát le fogja zárni. Ennek következtében a kiszámított végleges értékelések bekerülnek az értékelésnaplóba. A tanulók megtekinthetik leadott munkáikat és értékeléseiket.';
$string['switchphaseauto'] = 'Átkapcsolás ütemezve';
$string['switchphasenext'] = 'Átváltás a következő szakaszra';
$string['taskassesspeers'] = 'Csoporttársak értékelése';
$string['taskassesspeersdetails'] = 'összesen: {$a->total}<br />függőben: {$a->todo}';
$string['taskassessself'] = 'Önértékelés';
$string['taskconclusion'] = 'A tevékenység összegzésének megírása';
$string['taskdone'] = 'Feladat végrehajtva';
$string['taskfail'] = 'Feladat sikertelen';
$string['taskinfo'] = 'Feladat adatai';
$string['taskinstructauthors'] = 'Utasítások megadása a leadott munkákhoz';
$string['taskinstructreviewers'] = 'Utasítások megadása az értékeléshez';
$string['taskintro'] = 'Műhelymunka leírásának beállítása';
$string['tasksubmit'] = 'Munkájának leadása';
$string['tasktodo'] = 'Elvégzendő feladat';
$string['toolbox'] = 'A műhelymunka eszközkészlete';
$string['undersetup'] = 'Még tart a műhelymunka beállítása. Várja meg következő szakaszba lépést!';
$string['useexamples'] = 'Példák használata';
$string['useexamples_desc'] = 'Az értékelés gyakorlásához példamunkák használata';
$string['useexamples_help'] = 'Bekapcsolása esetén a felhasználók próbálkozhatnak egy vagy több példamunka értékelésével, vagy értékelésüket egybevethetik a referenciaértékeléssel. Ez az értékelés nem számít bele az értékelésre adott értékelésbe.';
$string['usepeerassessment'] = 'Csoporttársi értékelés használata';
$string['usepeerassessment_desc'] = 'A tanulók értékelhetik mások munkáját';
$string['usepeerassessment_help'] = 'Bekapcsolása esetén a felhasználók megkaphatják mások munkáit értékelésre, melyre a saját leadott munkájukra kapott értékelés mellé egy másikat is kapnak.';
$string['userdatecreated'] = 'leadás dátuma: <span>{$a}</span>';
$string['userdatemodified'] = 'módosítás dátuma: <span>{$a}</span>';
$string['userplan'] = 'Műhelymunka-tervező';
$string['userplan_help'] = 'A műhelymunka-tervezőn a tevékenység minden szakasza megjelenik a hozzájuk tartozó feladatok felsorolásával együtt. Az aktuális szakasz kiemelten látszik, a feladatok teljesítését pipa jelzi.';
$string['userplanaccessibilityskip'] = 'Ugrás a mostani feladatokra';
$string['userplanaccessibilitytitle'] = 'Műhelymunka ütemterve {$a} szakasszal';
$string['userplancurrentphase'] = 'Jelenlegi szakaszra';
$string['useselfassessment'] = 'Önértékelés használata';
$string['useselfassessment_desc'] = 'A tanulók értékelhetik saját munkájukat';
$string['useselfassessment_help'] = 'Bekapcsolása esetén a felhasználók saját leadott munkájukat kaphatják meg értékelésre, melyre a saját leadott munkájukra kapott értékelés mellé egy másikat is kapnak.';
$string['viewworkshopsummary'] = 'Műhelymunka összegzésének megtekintése';
$string['weightinfo'] = 'Súly: {$a}';
$string['withoutsubmission'] = 'Érrtékelő saját leadott munka nélkül';
$string['workshop:addinstance'] = 'Új műhelymunka hozzáadása';
$string['workshop:allocate'] = 'Leadott munkák kiosztása ellenőrzésre';
$string['workshop:deletesubmissions'] = 'Leadások törlése';
$string['workshop:editdimensions'] = 'Értékelő űrlapok szerkesztése';
$string['workshop:exportsubmissions'] = 'Leadott munkák exportálása';
$string['workshop:ignoredeadlines'] = 'Az időkorlátozás figyelmen kívül hagyása';
$string['workshop:manageexamples'] = 'Leadott példamunkák kezelése';
$string['workshop:overridegrades'] = 'Számított értékelések felülírása';
$string['workshop:peerassess'] = 'Csoporttársi értékelés';
$string['workshop:publishsubmissions'] = 'Leadott munkák közzététele';
$string['workshop:submit'] = 'Leadás';
$string['workshop:switchphase'] = 'Szakasz átváltása';
$string['workshop:view'] = 'Műhelymunka megtekintése';
$string['workshop:viewallassessments'] = 'Az összes értékelés megtekintése';
$string['workshop:viewallsubmissions'] = 'Az összes leadott munka megtekintése';
$string['workshop:viewauthornames'] = 'Szerzők nevének megtekintése';
$string['workshop:viewauthorpublished'] = 'Közzétett leadott munkák szerzőinek megtekintése';
$string['workshop:viewpublishedsubmissions'] = 'Közzétett leadott munkák megtekintése';
$string['workshop:viewreviewernames'] = 'Érrtékelők nevének megtekintése';
$string['workshopname'] = 'A műhelymunka neve';
$string['yourassessmentfor'] = '{$a} értékelése';
$string['yourgrades'] = 'Értékelései';
$string['yoursubmission'] = 'Saját leadott munkája';
$string['yoursubmissionwithassessments'] = 'Leadott munkája értékelésekkel';
