<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_fordson', language 'es_mx', version '4.1'.
 *
 * @package     theme_fordson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityiconsize'] = 'Tamaño del Ícono de Actividad';
$string['activityiconsize_desc'] = 'Ajustar el tamaño de los íconos de actividades usadas en cursos.';
$string['activitylinkstitle'] = 'Actividades';
$string['activitylinkstitle_desc'] = 'Ver todas las actividades en el Curso';
$string['activitymenu'] = 'Mostrar Menú de Actividades Agrupadas';
$string['activitymenu_desc'] = 'Mostrar los listados de actividades agrupadas en los páneles del estudiante y del profesor. Este menú muestra una lista agrupada de todas las actividades para el estudiante y para el profesor.';
$string['advancedsettings'] = 'Configuraciones avanzadas';
$string['alert'] = 'Alerta en Página Inicial';
$string['alert_desc'] = 'Este es un mensaje especial de alerta que aparecerá en la página inicial.';
$string['backgroundimage'] = 'Imagen del fondo de página por defecto';
$string['backgroundimage_desc'] = 'Imagen del fondo para páginas';
$string['backtotop'] = 'Regresar a Superior y DeslizamientoEspía';
$string['badges'] = 'Insignias';
$string['badges_desc'] = 'Premiar a sus estudiantes';
$string['blockdisplay'] = 'Opciones de Ubicación de Visualización del Bloque';
$string['blockdisplay_desc'] = 'Elija como mostrar bloques en la página inicial y las páginas del curso. Fordson añade  un panel de bloque colapsible de 3 columnas que puede ser ocultado por el usuario. Elija la opción Por Defecto de Boost para usar una única columna al lado derecho para bloques. La opción Por Defecto de Boost también mueve el botón para Añadir un Bloque al Cajón de Navegación a la izquierda de la página. Nosotros también recomendamos usar la opción de "Por defecto de Boost Columna Única" cuando se use cualquier diseño de página de Boost de las configuraciones de arriba.';
$string['blockdisplay_off'] = 'Por defecto de Boost Columna Única';
$string['blockdisplay_on'] = 'Por defecto de Fordson Tres Columnas';
$string['blockwidthfordson'] = 'Ancho de Columna del Bloque';
$string['blockwidthfordson_desc'] = 'Ajustar el ancho de la columna del bloque.';
$string['blog'] = 'URL de Blog';
$string['blogdesc'] = 'Ingrese la URL del blog de su institución. (poe ejemplo, http://dearbornschools.org)';
$string['bodybackground'] = 'Color del Fondo del Cuerpo';
$string['bodybackground_desc'] = 'El color principal a usar para el fondo';
$string['brandColour'] = 'Color distintivo';
$string['brandColour_desc'] = 'Su color distintivo principal';
$string['branddanger'] = 'Peligro Distintivo';
$string['branddanger_desc'] = 'Color distintivo para alertas de peligro y páneles, etc';
$string['brandemail'] = 'Email de organización';
$string['brandemaildesc'] = 'Dirección Email de la Organización que aparece en el pie de página.';
$string['brandinfo'] = 'Información Distintiva';
$string['brandinfo_desc'] = 'Color distintivo para alertasinformativas y páneles, etc';
$string['brandorganization'] = 'Nombre de Organización';
$string['brandorganizationdesc'] = 'Nombre de la Organización que aparece en el pie de página.';
$string['brandphone'] = 'Teléfono de la Organización';
$string['brandphonedesc'] = 'Número telefónico de la Organización que aparece en el pie de página.';
$string['brandprimary'] = 'Primario Distintivo';
$string['brandprimary_desc'] = 'Su principal color distintivo';
$string['brandsuccess'] = 'Éxito distintivo';
$string['brandsuccess_desc'] = 'Color distintivo para alertas exitosas, páneles positivos, botones, etc';
$string['brandwarning'] = 'Advertencia Distintiva';
$string['brandwarning_desc'] = 'Color distintivo para alertas de advertencia y páneles, etc';
$string['brandwebsite'] = 'Sitio Web de la Organización';
$string['brandwebsitedesc'] = 'Dirección de sitio web que aparece en pie de página para la organización.';
$string['breadcrumbbkg'] = 'Color del Fondo de Ruta de Navegación';
$string['breadcrumbbkg_desc'] = 'Color del fondo de ruta de navegación.';
$string['cardbkg'] = 'Color del Fondo del Contenido';
$string['cardbkg_desc'] = 'Color del fondo del contenido para bloques y contenido del curso.';
$string['catsicon'] = 'Ícono de Categoría';
$string['catsicon_desc'] = 'Elegir un ícono para representar categorías de curso. \'\'Folder\'\' = Carpeta.';
$string['choosereadme'] = 'Fordson proporciona una experiencia visual única al tema predeterminado Boost, con características de personalización tales como selectores de color, navegación mejorada  y experiencia de página inicial mejorada.';
$string['collapsibletopics'] = 'Formato de Curso de Tópicos Colapsable';
$string['collapsibletopics_desc'] = 'Si Usted instala el Formato de Tópicos Colapsable ( <a href="https://moodle.org/plugins/format_collapsibletopics">format_collapsibletopics</a> ) el tema Fordson puede proporcionar una vista mejorada del formato del curso y estilizado especial que se integra mejor con el aspecto general de Fordson. Se ha desarrollado cuidado  y atención especial para proporcionar una más suave experiencia del usuario para os usuarios de todas las edades y habilidades.';
$string['colours_desc'] = 'Los selectores de color le permitirán a Usted personalizar la apariencia de los elementos principales en la página. Si Usted está usando una Preconfiguración diferente a la que es por defecto, Usted necesitará quitar cualquier color personalizado abajo para los mejores resultados, ya que estos anularían las preconfiguraciones, causando resultados indeseables. Generalmente, la Preconfiguración tendrá colores por defecto que Usted querrá ver antes de personalizarlos aquí.';
$string['colours_headingsub'] = 'Configuraciones de Color';
$string['colours_settings'] = 'Colores';
$string['configtitle'] = 'Fordson';
$string['contentsettings'] = 'Áreas de contenido';
$string['courseactivities'] = 'Actividades del Curso';
$string['courseblockpanelbtn'] = 'Bloques del Curso';
$string['courseblockpanelbtnclose'] = 'Cerrar';
$string['courseboxheight'] = 'Altura del Título del Curso';
$string['courseboxheight_desc'] = 'Controlar la altura del Título del curso en la Portada y en categorías de curso.';
$string['courseeditingcog'] = 'Mostrar Menú de Configuraciones por Defecto del Curso';
$string['courseeditingcog_desc'] = 'Si usa el Panel de Gestión del Curso, el menú por defecto está oculto. Al activar esto,  Usted puede mostrar el menú por defecto al igual que el panel para gestión del curso del profesor. Esto es ideal si Usted usa un plugin de terceros que emplee el menú del curso para acceder a las configuraciones.';
$string['coursehome'] = 'Inicio';
$string['courseinfo'] = 'Descripción del Curso';
$string['coursemanage'] = 'Configuraciones del Curso';
$string['coursemanage_desc'] = 'Gestionar todo su curso';
$string['coursemanagementbutton'] = 'Gestión del Curso';
$string['coursemanagementinfo'] = 'Menú del Panel de Administración del Curso';
$string['coursemanagementinfodesc'] = 'Esta configuración proporciona un Pánel Único y Organizado de Administración del Curso que puede ser accesado desde cualquier parte de un curso por profesores para acceder a sus enlaces de gestión del curso. Los estudiantes también pueden acceder a un Tablero de Curso del Estudiante que incluye información relevante al curso. Es altamente recomendable mantener esto activado.';
$string['coursemanagementtextbox'] = 'Mensaje de Gestión del Curso';
$string['coursemanagementtextbox_desc'] = 'Añadir un mensaje para profesores en el panel de gestión del curso en todas las páginas del curso.';
$string['coursemanagementtoggle'] = 'Mostrar Páneles de Manejo  del Curso para Estudiante y Profesor';
$string['coursemanagementtoggle_desc'] = 'Esto muestra los enlaces de Administración del Curso en un panel organizado para profesores que proporciona un tablero de todos los enlaces que necesitan ellos para gestionar sus cursos y usuarios. También mostrará un panel de vista general del curso para estudiantes con calificaciones, finalización del curso y otros ítems del curso.';
$string['coursestaff'] = 'Profesores del Curso';
$string['coursestyle1'] = 'Mosaico Estilo Uno';
$string['coursestyle10'] = 'Visualización de Curso Moodle por Defecto';
$string['coursestyle2'] = 'Mosaico Estilo Dos';
$string['coursestyle3'] = 'Mosaico Estilo Tres';
$string['coursestyle4'] = 'Mosaico Estilo Cuatro c/ resumen de curso';
$string['coursestyle5'] = 'Estilo Uno Horizontal';
$string['coursestyle6'] = 'Detalles Completos Fondo Imagen Horizontal';
$string['coursestyle7'] = 'Título y Profesor Solamente Fondo Imagen Horizontal';
$string['coursestyle8'] = 'Dos Columnas Horizontal';
$string['coursestyle9'] = 'Entrenamiento Corporativo - mínimo con barra de progreso de finalización';
$string['coursetileinfo'] = 'Opciones de Visualización de Curso';
$string['coursetileinfodesc'] = 'Estas configuraciones le permiten personalizar el como se mostrarán en la portada y también como categorías de curso.';
$string['coursetilestyle'] = 'Visualización Mosaico Curso';
$string['coursetilestyle_desc'] = 'Cuando se ven categorías de curso, Usted puede elegir entre los estilos siguientes para mostrar cursos.  . <a href="https://goo.gl/fMXzSo" target="_new">Instrucciones para Fordson </a>';
$string['createinfo'] = 'Botón del Creador de Curso Especial';
$string['createinfodesc'] = 'El botón aparece en la página inicial cuando un usuario puede crear nuevos cursos. Aquellos con el rol de Creador de Curso a nivel del sitio verán este botón.';
$string['currentinparentheses'] = '(actual)';
$string['customloginheading'] = 'Página Personalizada para Ingreso';
$string['customlogininfo'] = 'Configuraciones de Página Personalizada para Ingreso';
$string['customlogininfo_desc'] = 'Esto le permite crear una página personalizada para ingresar al sitio. Otras configuraciones en el tema que se mostrarán en la página para ingresar al sitio incluyen las siguientes:<br>
<b>* Administración del sitio > Seguridad > Políticas del sitio > Forzar a los usuarios a Ingresar = Asegúrese de que esté activado para que los usuarios sean llevados a su página personalizada para ingresar al sitio.<br>
* Administración del sitio > Apariencia > Logos > Logo = Suba aquí una imagen y aparecerá arriba del formato para ingresar.<br>
* Fordson > Configuraciones Personalizadas de Imagen > La Imagen por Deefecto para Ingresar puede ser usada para cambiar la imagen del fondo para la página para ingresar. <br>
* Fordson > Áreas de Contenido > Alerta de Página Inicial puede ser usada para proporcionar un aviso en la parte superior de la página. </b>';
$string['dashactivityoverview'] = 'VISTA GENERAL DE ACTIVIDADES';
$string['displaybottom'] = 'Mostrar al Fondo de la Página';
$string['displaymycourses'] = 'Mostrar cursos inscritos';
$string['displaymycoursesdesc'] = 'Mostrar cursos inscritos para usuarios en la barra de navegación superior.';
$string['displaythiscourse'] = 'Mostrar Este Menú de Curso';
$string['displaythiscoursedesc'] = 'Mostrar saltar-a-sección en el emnú del curso para usuarios en la barra de navegación superior. Esto contiene ítems de menú que previamente se eencontraban en el cajón de navegación.';
$string['displaytop'] = 'Mostrar en la Parte Superior de la Página';
$string['drawerbkg'] = 'Color del fondo del Cajón Lateral';
$string['drawerbkg_desc'] = 'Color del fondo del Cajón Lateral para el menú del lado izquierdo de la página.';
$string['easyenrollmentintegration'] = 'Plugin Inscripción Fácil';
$string['easyenrollmentintegration_desc'] = 'El plugin de Inscripción Fácil (<a href="https://moodle.org/plugins/enrol_easy"> Easy Enrollment Plugin</a>) le permite a los estudiantes  inscribirse en cursos directamente desde la página inicial de Moodle. El plugin de inscripción usa un código de 6 dígitos o un código QR autogenerado con soporte de cámara web para inscribir estudiantes. El estudiante ingresa el código o escanea el código QR y es inscrito instantáneamente dentro del curso o grupo del curso  deseado. Este plugin se auto-activa una vez que  instale Easy Enrollmente (Inscripción Fácil) y lo active en la Administración del Sitio. Solamente es activado si el plugin es instalado y configurado apropiadamente.';
$string['editoff'] = 'Desactivar Edición';
$string['editon'] = 'Activar Edición';
$string['enablecategoryicon'] = 'Íconos de Visualización de Categoría';
$string['enablecategoryicon_desc'] = 'Cuando se activa esto, se mostrarán categorías de curso como íconos';
$string['enhancedmydashboard'] = 'Mi Tablero Mejorado';
$string['enhancedmydashboard_desc'] = 'Activar esto mejorará la página de Mi Tablero para que incluya todas las características de Fordson, tales como el Formato para Inscripción Fácil, deslizadores de bloque, Barra de Navegación por Íconos, Texto Personalizado de Página Inicial, Carrousel y más.';
$string['enrollcoursecard'] = 'Acceder';
$string['facebook'] = 'URL de Facebook';
$string['facebookdesc'] = 'Ingrese la URL de su página de Facebook (por ejemplo https://www.facebook.com/moodle).';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Cambiar el favicon para Fordson. Las imágenes con un fondo transparente y altura de 32 pixeles funcionan mejor. Tipos permitidos: PNG, JPG, ICO';
$string['feature1info'] = 'Destacada Uno';
$string['feature2info'] = 'Destacada Dos';
$string['feature3info'] = 'Destacada Tres';
$string['featureimage'] = 'Imágen Destacada';
$string['featureimage_desc'] = 'Esta imagen aparecerá junto al texto destacado en una fila.';
$string['featureinfo_desc'] = 'Una destacada consiste de una imagen y texto que aparecerán en la página personalizada de ingreso en una fila. Usted debe añadir tanto una imagen como texto para que aparezca la destacada.';
$string['featuretext'] = 'Texto destacado';
$string['featuretext_desc'] = 'Este texto aparecerá junto a la imagen destacada en una fila. Use un Heading4 para generar un título especial dentro de la caja_de_texto. En el Editor Atto, H4 es Encabezado Mediano.';
$string['flickr'] = 'URL de Flickr';
$string['flickrdesc'] = 'Ingrese la URL de su página de Flickr (por ejemplo https://www.flickr.com/groups/unam/)';
$string['footerbkg'] = 'Color del Fondo del Pie de Página';
$string['footerbkg_desc'] = 'Color del Fondo del Pie de Página para el fondo de la página.';
$string['footerdesc'] = 'Los ítems debajo le permiten proporcionar un marcado personalizado al pie de página del tema.';
$string['footerheading'] = 'Pie de página';
$string['footerheadingsocial'] = 'Íconos Sociales';
$string['footerheadingsub'] = 'Personalizar el pie de página de la página inicial';
$string['footnote'] = 'Nota al pie';
$string['footnotedesc'] = 'Editor de contenido para pie de página principal';
$string['fploginform'] = 'Color del Formato para Ingreso';
$string['fploginform_desc'] = 'Color del fondo del formato para ingreso en la página de inicio personalizada.';
$string['fpsignup'] = 'Apuntarse';
$string['fptextbox'] = 'Caja de texto de Usuario autenticado en Página Inicial';
$string['fptextbox_desc'] = 'Esta caja-de-texto aparece en la página inicial una vez que el  usuario se autentica y es ideal para poner un mensaje de BienVenida y proporcionar instrucciones para al alumno.';
$string['fptextboxlogout'] = 'Caja de texto de Visitante en Página Inicial';
$string['fptextboxlogout_desc'] = 'Esta caja-de-texto aparece en la página inicial para visitantes y es ideal para poner un mensaje de BienVenida o un enlace hacia la página para ingresar al sitio.';
$string['frontpagemycoursessorting'] = 'Ordenamiento por Último Acceso de Mis Cursos';
$string['frontpagemycoursessorting_desc'] = 'Cuando se activa, esta característica ordenará la visualización de la Portada para Mis Cursos (cursos inscritos) por el último acceso del usuario. Esto anulará la configuración de "Ordenar mis cursos" de la Navegación. Si no se seleccionara, entonces Mis Cursos en la Portada se mostrará como normalmente es. Esto incluye a Mis cursos mostrados en los menúes desplegables en la parte superior de la página tanto como a Mis Cursos Inscritos mostrados en la Página Inicial del Sitio. Esto no afecta al Tablero o al bloque del Tablero.';
$string['generalcontentinfo'] = 'Configuraciones de Visualización de Contenido General';
$string['generalcontentinfodesc'] = 'Estas opciones inferiores le ayudan a personalizar la forma en la que el contenido es mostrado y activar características adicionales para Fordson.';
$string['generalsettings'] = 'Configuraciones Generales';
$string['googleplus'] = 'URL de Google +';
$string['googleplusdesc'] = 'Ingrese la URL de su perfil de Google+ (por ejemplo https://google.com/)';
$string['gutterwidth'] = 'Separación del Contenido';
$string['gutterwidth_desc'] = 'Esta configuración controla que tanto espaciamiento es usado a la izquierda y la derecha del contenido principal.';
$string['headerdefaultimage'] = 'Imagen del encabezado por defecto';
$string['headerdefaultimage_desc'] = 'Imagen por defecto para encabezados de curso y páginas que no son de curso';
$string['headerimagepadding'] = 'Altura de Imagen del encabezado';
$string['headerimagepadding_desc'] = 'Controla la separación y la altura de la imagen del encabezado para cursos.';
$string['headerlogo'] = 'Logo del Encabezado';
$string['headerlogo_desc'] = 'Este logo será mostrado en la parte superior de la página en el área del encabezado. Usa escalamiento de la imagen responsivo de bootstrap.';
$string['homemyclasses'] = 'Inicio de Clase';
$string['homemycomp'] = 'Inicio de Competencia';
$string['homemycourses'] = 'Inicio del Curso';
$string['homemycred'] = 'Inicio de Credencial';
$string['homemylectures'] = 'Inicio de Conferencia-Clase';
$string['homemylessons'] = 'Inicio de Lección';
$string['homemymodules'] = 'Incio de Módulo';
$string['homemyplans'] = 'Inicio de Plan';
$string['homemyprofessionaldevelopment'] = 'Inicio DP';
$string['homemyprograms'] = 'Inicio de Programa';
$string['homemytraining'] = 'Inicio de Entrenamiento';
$string['homemyunits'] = 'Inicio de Unidad';
$string['iconnavheading'] = 'Navegación por Íconos';
$string['iconnavheadingsub'] = 'Crear botones con íconos para usar en la página inicial. Los enlaces pueden ir a cualquier lado.';
$string['iconwidth'] = 'Ancho de Ícono en Página inicial';
$string['iconwidth_desc'] = 'Ancho de los 8 íconos individuales en la barra de navegación por íconos en la página inicial.';
$string['iconwidthinfo'] = 'Configuración del Ancho de Botón de Ícono';
$string['iconwidthinfodesc'] = 'Seleccionar un ancho que permita que su texto del enlace quepa adentro del los botones de navegación pro íconos.';
$string['ilearnsecurebrowser'] = 'Este examen está asegurado con el Navegador Seguro de iLearn ( iLearn Secure Browser). Debe usarse una Chromebook que use la App iLearn para intentar este examen';
$string['imagesettings'] = 'Configuraciones de imagen personalizada';
$string['instagram'] = 'URL de  Instagram';
$string['instagramdesc'] = 'Ingrese la URL de su página de Instagram (por ejemplo https://www.instagram.com/unam_mx)';
$string['integrationinfo'] = 'Integraciones de plugin';
$string['integrationinfo_desc'] = 'Fordson puede activar características avanzadas y mejor integración con ciertos plugins. Las configuraciones inferiores le permitirán usar el comportamiento predeterminado del plugin para activar características avanzadas que han implementado los desarrolladores de Fordson.';
$string['integrationoff'] = 'Desactivar Integración';
$string['integrationon'] = 'Activar Integración';
$string['jitsibuttontext'] = 'Botón de Encabezado de Reunión Jitsi automática';
$string['jitsibuttontextdesc'] = 'Añadir texto para un botón que será añadido a la parte superior de cualquier curso Moodle- El botón llevará a los usuarios a una sala de reunión Jitsi que forma la URL del nombre del curso y el número ID del curso. Usted necesita tener un Servidor de Conferencia Web Jitsi.';
$string['jitsibuttonurl'] = 'URL de Servidor Jitsi';
$string['jitsibuttonurldesc'] = 'Ejemplo de servidor público: https://meet.jit.si <br> NO AÑADA UNA DIAGONAL AL FINAL <br> Esta URL será usada para el botón que automáticamente será añadido a cada Curso Moodle en el área del Encabezado. Nosotros recomendamos encarecidamente que Usted configure su propio servidor Jitsi y que force el ingreso a la Sala de Reunión Jitsi.';
$string['layoutinfo'] = 'Configuraciones del Aspecto';
$string['layoutinfodesc'] = 'Controlar el aspecto de la página al elegir un diseño';
$string['learningcontentpadding'] = 'Espaciamiento del Contenido de Aprendizaje';
$string['learningcontentpadding_desc'] = 'Esto controla cuanto espacio hay entre la parte superior de la página y el contenido principal del curso. Generalmente, Usted querrá que esto sea menor que la altura de la imagen del encabezado.';
$string['linkedin'] = 'URL de  Linkedln';
$string['linkedindesc'] = 'Ingrese la URL de su perfil de LinkedIn (por ejemplo https://www.linkedin.com/company/921517/)';
$string['loginimage'] = 'Imagen de Ingreso por defecto';
$string['loginimage_desc'] = 'Imagen del fondo para la página para ingresar al sitio';
$string['loginnavicon1'] = 'Ícono Uno';
$string['loginnavicon2'] = 'Ícono Dos';
$string['loginnavicon3'] = 'Ícono Tres';
$string['loginnavicon4'] = 'Ícono Cuatro';
$string['loginnavicontext'] = 'Texto del Ícono';
$string['loginnavicontextdesc'] = 'Teexto que aparecerá debajo del ícono. Manténgalo corto para mejores resultados.';
$string['loginnavicontitletext'] = 'Título del Ícono';
$string['loginnavicontitletextdesc'] = 'Texto a aparecer deebajo del ícono a manera dee título.';
$string['logintopimage'] = 'Imagen de Banner de Página para Ingresar';
$string['logintopimage_desc'] = 'Esta imagen aparece en la página para ingresar a la derecha del formato  para ingreesar. Esto es ideal para un logo o un banneer con un fondo transparente.';
$string['marketboxbuttoncolor'] = 'Color del Botón de Caja Promocional';
$string['marketboxbuttoncolor_desc'] = 'El color del fondo para el botón de la Caja Promocional.';
$string['marketboxcolor'] = 'Color del Fondo de Caja Promocional';
$string['marketboxcolor_desc'] = 'El color del Fondo para la Caja Promocional.';
$string['marketboxcontentcolor'] = 'El Color del Fondo del Contenido de la Caja Promocional';
$string['marketboxcontentcolor_desc'] = 'El color del fondo para el contenido del bloque promocional. Esto es en donde el texto aparece en el bloque promocional y puede ser diferente del color del fondo de la caja para llamar la atención hacia el texto.';
$string['marketing1'] = 'Bloque Promocional Uno';
$string['marketing2'] = 'Bloque Promocional Dos';
$string['marketing3'] = 'Bloque Promocional Tres';
$string['marketing4'] = 'Bloque Promocional Cuatro';
$string['marketing5'] = 'Bloque Promocional Cinco';
$string['marketing6'] = 'Bloque Promocional Seis';
$string['marketing7'] = 'Bloque Promocional Siete';
$string['marketing8'] = 'Bloque Promocional Ocho';
$string['marketing9'] = 'Bloque Promocional Nueve';
$string['marketingbuttontext'] = 'Texto del Enlace';
$string['marketingbuttontextdesc'] = 'Texto a aparecer en el botón.';
$string['marketingbuttonurl'] = 'URL del enlace';
$string['marketingbuttonurldesc'] = 'URL a donde apuntará el botón.';
$string['marketingcontent'] = 'Contenido';
$string['marketingcontentdesc'] = 'Contenido a mostrar en la caja Promocional. Hágalo corto y dulce.';
$string['marketingdesc'] = 'Este tema proporciona la opción de habilitar tres puntos de "publicidad" o "anuncio" justamente debajo del carrusel. Estos le permiten identificar fácilmente información importante para sus usuarios y proporcionarles enlaces directos.';
$string['marketingheading'] = 'Mosaicos Promocionales';
$string['marketingheadingsub'] = 'Tres lugares en la Portada para añadir información y enlaces';
$string['marketingheight'] = 'Altura de Imágenes Promocionales';
$string['marketingheightdesc'] = 'Si Usted quiere mostrar imágenes en las cajas Promocionales Usted puede especificar aquí sus alturas.';
$string['marketingicon'] = 'Ícono del Enlace';
$string['marketingicondesc'] = 'Nombre del ícono que desea usar en el Botón de URL publicitario. La lista está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>.Simplemente ingrese lo que está después de "fa-", como por ejemplo "star"(estrella), "book"(libro), "home" (casa).';
$string['marketingimage'] = 'Imagen';
$string['marketingimage_desc'] = 'Esto proporciona la opción de mostrar una imagen en el bloque promocinal';
$string['marketinginfodesc'] = 'Ingrese las configuraciones para su bloque publicitario. Usted debe incluir un título para que aparezca el Bloque Publicitario. El título activará los Bloques Publicitarios individuales.';
$string['marketingstyle'] = 'Selector de Estilo de Loseta Promocional';
$string['marketingstyle1'] = 'Resaltado de Barra Superior';
$string['marketingstyle2'] = 'Nota Postit';
$string['marketingstyle3'] = 'Simplicidad';
$string['marketingstyle4'] = 'Sombra En Caja';
$string['marketingstyle_desc'] = 'Elija entre los siguientes estilos promocionales. Estos cambiarán el aspecto de las cajas promocionales en la página inicial del sitio.';
$string['marketingtitle'] = 'Título';
$string['marketingtitledesc'] = 'Título a mostrar en este bloque promocional. Usted debe incluir un título para que aparezca el Bloque Promocional.';
$string['marketingurltarget'] = 'Destino del Enlace';
$string['marketingurltargetdesc'] = 'Elegir como se debe abrir el enlace';
$string['marketingurltargetnew'] = 'Página Nueva';
$string['marketingurltargetparent'] = 'Marco Paterno';
$string['marketingurltargetself'] = 'Página Actual';
$string['markettextbg'] = 'Fondo del texto de Mosaico Promocional';
$string['markettextbg_desc'] = 'Color del fondo para el texto de los mosaicos promocionales.';
$string['menusettings'] = 'Configuraciones del Menú';
$string['myclasses'] = 'Mis Clases';
$string['mycomp'] = 'Mis Competencias';
$string['mycourses'] = 'Mis Cursos';
$string['mycoursesinfo'] = 'Lista Dinámica de Cursos Inscritos y Menúes de Navegación de Curso';
$string['mycoursesinfodesc'] = 'Muestra una lista dinámica de cursos inscritos al usuario en la barra de navegación superior. Esto también controla el menú desplegable de navegación del curso para cada curso individual.';
$string['mycoursetitle'] = 'Terminología';
$string['mycoursetitledesc'] = 'Cambiar la terminología para el enlace hacia "Mis Cursos" en el menú desplegable';
$string['mycred'] = 'Mis Credenciales';
$string['mygradestext'] = 'Mis Calificaciones';
$string['mylectures'] = 'Mis Lecturas-Clases';
$string['mylessons'] = 'Mis Lecciones';
$string['mymodules'] = 'Mis Módulos';
$string['myplans'] = 'Mis Planes';
$string['myprofessionaldevelopment'] = 'Mi Desarrollo Profesional (DP)';
$string['myprograms'] = 'Mis Programas';
$string['myprogresspercentage'] = '% Completo';
$string['myprogresstext'] = 'Mi Progreso';
$string['mytraining'] = 'Mi Entrenamiento';
$string['myunits'] = 'Mis Unidades';
$string['navbarcolorswitch'] = 'Alternar Color Barra de Navegación';
$string['navbarcolorswitch_desc'] = 'Esta característica cambia el color de la barra de navegación basándose en rol del usuario. Un estudiante verá un color y el profesor verá otro color. Esto es útil cuando un profesor cambia de roles y ayuda a distinguir entre una vista del estudiante y una vista del profesor.';
$string['navbarcolorswitch_off'] = 'No cambiar el color de la Barra de Navegación basándose en rol.';
$string['navbarcolorswitch_on'] = 'Cambiar el color de la Barra de Navegación basándose en rol.';
$string['navdrawerbtn'] = 'Navegación';
$string['navicon'] = 'Ícono';
$string['navicon1'] = 'Página inicial Ícono Uno';
$string['navicon2'] = 'Página inicial Ícono Dos';
$string['navicon3'] = 'Página inicial Ícono Tres';
$string['navicon4'] = 'Página inicial Ícono Cuatro';
$string['navicon5'] = 'Página inicial Ícono Cinco';
$string['navicon6'] = 'Página inicial Ícono Seis';
$string['navicon7'] = 'Página inicial Ícono Siete';
$string['navicon8'] = 'Página inicial Ícono Ocho';
$string['naviconbutton1textdefault'] = 'Tablero';
$string['naviconbutton2textdefault'] = 'Calendario';
$string['naviconbutton3textdefault'] = 'Insignias';
$string['naviconbutton4textdefault'] = 'Todos los Cursos';
$string['naviconbuttoncreatetextdefault'] = 'Crear un Curso';
$string['naviconbuttontext'] = 'Texto del Enlace';
$string['naviconbuttontextdesc'] = 'Texto que aparece debajo del ícono.';
$string['naviconbuttonurl'] = 'URL del Enlace';
$string['naviconbuttonurldesc'] = 'URL a donde apuntará el botón. Usted puede enlazar hacia cualquier sitio incluyendo sitios web externos; simplemente ingrese la URL apropiada. Si su sitio Moodle está dentro de un subdirectorio, la URL por defecto no funcionará. Por favor ajuste la URL para que refleje el subdirectorio. Por ejemplo, si "moodle" era su carpeta del subdirectorio, entonces la URL necesitaría ser cambiada a /moodle/my/';
$string['navicondesc'] = 'Nombre del ícono que desea usar. La lista está <a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>.Simplemente ingrese lo que está después de "fa-", como por ejemplo "star"(estrella), "book"(libro), "home" (casa).';
$string['naviconslidedesc'] = 'Texto de ícono sugerido: arrow-circle-down (flecha-círculo-abajo). O elija de la lista que está <<a href="https://fontawesome.com/v4.7.0/icons/" target="_new">aquí</a>.Simplemente ingrese lo que está después de "fa-", como por ejemplo "star"(estrella), "book"(libro), "home" (casa).';
$string['noenrolments'] = 'Usted no tiene inscripciones actuales';
$string['nomycourses'] = 'Usted no está inscrito en ningun curso.';
$string['pagelayout'] = 'Selector de Aspecto';
$string['pagelayout1'] = 'Aspecto de Boost por defecto';
$string['pagelayout2'] = 'Ancho-Completo / Imagen en Encabezado Superior';
$string['pagelayout3'] = 'Contenido Centrado / Imagen en Encabezado Superior Superpuesta';
$string['pagelayout4'] = 'Contenido Centrado / Imagen en Encabezado a Pantalla Completa';
$string['pagelayout5'] = 'Aspecto de Boost por Defecto / Imagen en Encabezado dentro de Caja de Título del Curso';
$string['pagelayout_desc'] = 'Elija entre los siguientes aspectos.  Algunos diseños de página necesitan ajustes adicionales en la Página de Ajustes de Preconfiguración. Asegúrese de poner atención a: Espaciado de Contenido de Aprendizaje, Altura de Imagen en Encabezado y Relleno de Contenido, ya que estos ayudarán a ajustar la colocación de imagen del encabezado y relleno a la izquierda y derecha del contenido principal de aprendizaje. <a href="https://goo.gl/fMXzSo" target="_new">Instrucciones para Fordson</a>';
$string['pinterest'] = 'URL de Pinterest';
$string['pinterestdesc'] = 'Ingrese la URL de su página de Pinterest. (por ejemplo http://pinterest.com/mi_escuela)';
$string['pluginname'] = 'Fordson';
$string['preset'] = 'Preconfiguración del Tema';
$string['preset_desc'] = 'Elegir una preconfiguración para cambiar ampliamente la apariencia del tema.  <a href="https://goo.gl/fMXzSo" target="_new">Instrucciones para Fordson </a>';
$string['presetadjustmentsettings'] = 'Ajustes de Pre-configuración';
$string['presetfiles'] = 'Archivos de preconfiguración adicional del tema';
$string['presetfiles_desc'] = 'Los archivos preconfigurados pueden usarse para alterar dramáticamente la apariencia del tema.
Vea https://docs.moodle.org/dev/Boost_Presets para información sobre crear y compartir sus propios archivos  de pre-configuración.';
$string['presets_settings'] = 'Preconfiguraciones';
$string['privacy:metadata'] = 'El Tema Fordson no almacena ningún dato del usuario individual.';
$string['qbank'] = 'Banco de Preguntas';
$string['qbank_desc'] = 'Crear y organizar preguntas para examen';
$string['rawscss'] = 'SCSS Crudo';
$string['rawscss_desc'] = 'Use este campo para proporcionar código SCSS que será inyectado al final de la hoja de estilo.';
$string['rawscsspre'] = 'SCSS inicial crudo';
$string['rawscsspre_desc'] = 'En este campo Usted puede proporcionar código inicializador SCSS. Será inyectado antes de cualquier otra cosa.
   La mayor parte del tiempo Usted usará esta configuración para definir variables.';
$string['region-fp-a'] = 'Columna A';
$string['region-fp-b'] = 'Columna B';
$string['region-fp-c'] = 'Columna C';
$string['region-side-pre'] = 'Derecha';
$string['section_mods'] = 'Módulos:';
$string['sectionlayout'] = 'Selector de Estilo de Sección';
$string['sectionlayout1'] = 'Por Defecto de Boost';
$string['sectionlayout2'] = 'Tarjeta_de_Nota Enérgica (Bold Notecard)';
$string['sectionlayout3'] = 'Pestañas de Carpeta';
$string['sectionlayout4'] = 'Tablero con Clip';
$string['sectionlayout5'] = 'Caja Simple';
$string['sectionlayout6'] = 'Título Resaltado de Sección';
$string['sectionlayout7'] = 'Estudiante Universitario';
$string['sectionlayout8'] = 'Estudiante Corporativo';
$string['sectionlayout_desc'] = 'Elija entre los siguientes estilos de sección de tópico/semana. <a href="https://goo.gl/fMXzSo" target="_new"><a href="https://goo.gl/fMXzSo" target="_new">Instructions for Fordson</a></a>';
$string['setting_navdrawersettings'] = 'Configuraciones del Cajón de Navegación';
$string['setting_navdrawersettings_desc'] = 'Habilitar la característica del cajón de navegación del tema Boost. Fordson no requiere del cajón de navegación para la navegación. Lo hemos remplazado con un men{u desplegable de saltar-a-sección. Usted puede re-habilitar el cajón de navegación debajo.';
$string['showactivitynav'] = 'Mostrar Navegación en Actividad';
$string['showactivitynav_desc'] = 'Des-seleccione esto para desactivar navegación al fondo de las páginas de actividad.';
$string['showblockregions'] = 'Mostrar Regiones de Bloque de Portada Adicionales';
$string['showblockregions_desc'] = 'Activar tres regiones más de bloques en la portada del sitio. Estas aparecen abajito de la barra de navegación por íconos.';
$string['showcourseadminstudents'] = 'Mostrar engrane de Administración de Curso al Estudiante';
$string['showcourseadminstudents_desc'] = 'Esto muestra las configuraciones del curso a estudiantes. Esto es necesario si Usted quiere permitirles des-inscribirse (darse de baja) de cursos.';
$string['showcourseheaderimage'] = 'Mostrar Imágenes del Curso';
$string['showcourseheaderimage_desc'] = 'Permitirle a los profesores que personalicen la imagen del encabezado al subir un archivo de imagen en las configuraciones del curso.';
$string['showcustomlogin'] = 'Activar Ingreso Personalizado';
$string['showcustomlogin_desc'] = 'Usted debe activar esto para activar las configuracionees personalizadas debajo.';
$string['showloginform'] = 'Mostrar Formato para Ingresar';
$string['showloginform_desc'] = 'Desactivar esto para ocultar el formato de ingreso personalizado en la página inicial para usuarios que se han salido del sitio.';
$string['shownavclosed'] = 'Cajón del Navegador Cerrado por Defecto';
$string['shownavclosed_desc'] = 'Mostrar el cajón de navegación colapsado para todos los usuarios por defecto en cada página.';
$string['shownavdrawer'] = 'Mostrar Cajón de Navegación';
$string['shownavdrawer_desc'] = 'Fordson ha eliminado la nececidad del cajón de navegación al utilizar un menú desplegable para la navegación adentro del curso. Si Usted necesita usar el cajón de navegación, Usted puede activar esta casilla para re-habilitarlo.';
$string['showonlygroupteachers'] = 'Mostrar Solamente Profesores del Grupo';
$string['showonlygroupteachers_desc'] = 'Cuando se habilita, solamente los profesores del mismo grupo que el estudiante serán mostrados en el Panel de Gestión del Curso para el Estudiante.';
$string['showslideshow'] = 'Activar Carrousel';
$string['showslideshow_desc'] = 'Activar esta opción para activar la característica del carrousel.';
$string['showstudentcompletion'] = 'Mostrar Finalización del Estudiante';
$string['showstudentcompletion_desc'] = 'Mostrar el radial de finalización del estudiante en el panel del tablero del estudiante. Aun con esto activado, el curso debe de tener activado (el seguimiento de) la finalización para que se muestre.';
$string['showstudentgrades'] = 'Mostrar Calificaciones del Estudiante';
$string['showstudentgrades_desc'] = 'Mostrar enlace hacia el Libro de calificaciones del estudiante en el panel del tablero del estudiante.  Aun con esto activado, el curso debe de tener activado el \'Mostrar Calificaciones del estudiante\' para que se muestre.';
$string['siteadminquicklink'] = 'Administración del Sitio';
$string['skype'] = 'Cuenta de Skype';
$string['skypedesc'] = 'Ingrese el nombre_de_usuario de Skype de su cuenta de Skype de su organización';
$string['slide1info'] = 'Imagen 1';
$string['slide1infodesc'] = 'Detalles de Imagen 1.';
$string['slide2info'] = 'Imagen 2';
$string['slide2infodesc'] = 'Detalles de Imagen 2.';
$string['slide3info'] = 'Imagen 3';
$string['slide3infodesc'] = 'Detalles de Imagen 3.';
$string['slidecontent'] = 'Descripción de la imagen';
$string['slidecontent_desc'] = 'Añadirle una descripción a esta imagen.';
$string['slideimage'] = 'Imagen de la imagen';
$string['slideimage_desc'] = 'Añadirle una imagen de fondo a esta imagen.';
$string['sliderinfo'] = 'Botón de Ícono Deslizador Especial';
$string['sliderinfodesc'] = 'Este botón mostrará/ocultará una caja_de_texto especial que se desliza hacia abajo desde la Barra de navegación por íconos. Esto es ideal para cursos destacados, proporcionar ayuda, o enlistar entrenamiento necesario para el \'\'staff\'\'.';
$string['slideshowheight'] = 'Altura del Carrousel';
$string['slideshowheight_desc'] = 'Ajustar la altura del Carrousel en la página inicial del sitio/Tablero. Esta configuración es ignorada en la página Personalizada para Ingreso. en la Página Personalizada para Ingreso la altura de la imagen está determinada por el tamaño de la págin ay el ancho.';
$string['slideshowpages'] = 'Páginas del Carrusel de Imágenes';
$string['slideshowpages0'] = 'Mostrar solamente en la página para ingreso personalizada';
$string['slideshowpages1'] = 'Mostrar solamente en  Página Inicial y en Tablero';
$string['slideshowpages2'] = 'Mostrar en todos lados';
$string['slideshowpages_desc'] = 'Determinar en cuales páginas principales debería aparecer el carrusel de imágenes. Si usa en carrusel en la página de inicio personalizada, se recomienda que solamente suba imágenes y que no use las opciones inferiores de texto de imagen. NOTA: El carrusel no aparecerá en dispositivos móviles.';
$string['slideshowsettings'] = 'Carrusel';
$string['slideshowspacer'] = 'Espaciador en Carrusel de imágenes en Página para Ingresar Personalizada';
$string['slideshowspacer_desc'] = 'En la página para ingresar personalizada esta configuración es usada para añadir separación debajo del formato para ingresar en caso de que Usted ponga texto en las imágenes.';
$string['slidetextbox'] = 'Caja de texto de Diapositiva';
$string['slidetextbox_desc'] = 'El contenido de esta caja_de_texto se mostrará cuando sea presionado el botón de Deslizar.';
$string['slidetitle'] = 'Título de la Imagen';
$string['slidetitle_desc'] = 'Ingresar un título para esta imagen.';
$string['sociallink'] = 'Enlace hacia Social Personalizado';
$string['sociallinkdesc'] = 'Ingrese la URL de su enlace a medios sociales personalizados. (por ejemplo http://unam.mx)';
$string['sociallinkicon'] = 'Ícono de Enlace';
$string['sociallinkicondesc'] = 'Ingrese el nombre del ícono FontAwesome para su enlace<br />Una lista completa de los íconos de  FontAwesome puede encontrase en https://fontawesome.com/v4.7.0/icons/';
$string['socialnetworks'] = 'Redes Sociales';
$string['studentdashboardtextbox'] = 'Mensaje del Tablero del estudiante';
$string['studentdashboardtextbox_desc'] = 'Añadir un mensaje para estudiantes en el panel del tablero del estudiante en todas las páginas de curso.';
$string['studentdashbutton'] = 'Tablero del Curso';
$string['textcontentinfo'] = 'Contenido Personalizado';
$string['textcontentinfodesc'] = 'Usar las cajas_de_texto inferiores para añadir una información personalizada para usuarios.';
$string['thiscourse'] = 'Este Curso';
$string['thismyclasses'] = 'Esta Clase';
$string['thismycomp'] = 'Esta Competencia';
$string['thismycourses'] = 'Este Curso';
$string['thismycred'] = 'Esta Credencial';
$string['thismylectures'] = 'Esta Lectura-Clase';
$string['thismylessons'] = 'Esta Lección';
$string['thismymodules'] = 'Este Módulo';
$string['thismyplans'] = 'Este Plan';
$string['thismyprofessionaldevelopment'] = 'Este DP';
$string['thismyprograms'] = 'Este Programa';
$string['thismytraining'] = 'Este Entrenamiento';
$string['thismyunits'] = 'Esta Unidad';
$string['titletooltip'] = 'Herramientita del Título del curso';
$string['titletooltip_desc'] = 'Si se usa Recortar Título del Curso, Usted puede usar herramientitas (tooltips) que mostrarán el título completo del curso dentro de una herramientita. Active esta casilla para activar herramientitas.';
$string['togglemarketing'] = 'Posición de Mosaico Promocional';
$string['togglemarketing_desc'] = 'Determinar en donde estarán localizados los Mosaicos Promocionales en la página inicial.';
$string['topnavbarbg'] = 'Barra de Navegación Superior por Defecto';
$string['topnavbarbg_desc'] = 'Color del fondo del contenido para la barra de navegación superior.';
$string['topnavbarteacherbg'] = 'Barra de Navegación Superior para Rol de Profesor';
$string['topnavbarteacherbg_desc'] = 'Color del fondo del contenido para la barra de navegación superior cuando un usuario es profesor. Esta característica debe ser activada en las Configuraciones del Menú. Por favor vea la configuración de navbarcolorswitch';
$string['trimsummary'] = 'Acortar Resumen del Curso';
$string['trimsummary_desc'] = 'Ingrese un número para acortar el largo del resumen. Este número representa los caracteres que se  mostrarán.';
$string['trimtitle'] = 'Acortar Título del Curso';
$string['trimtitle_desc'] = 'Ingrese un número para acortar el largo del título. Este número representa los caracteres que se  mostrarán.';
$string['tumblr'] = 'URL de Tumblr';
$string['tumblrdesc'] = 'Ingrese la URL de su Tumblr. (por ejemplo https://www.tumblr.com/tagged/unam)';
$string['twitter'] = 'URL de Twitter';
$string['twitterdesc'] = 'Escriba la URL de su canal de Twitter (ejemplos:  https://twitter.com/UNAM_MX ;  https://twitter.com/IPN_MX ; https://twitter.com/uamx ; https://twitter.com/UVMMEXICO)';
$string['userlinks'] = 'Enlaces del Usuario';
$string['userlinks_desc'] = 'Gestionar sus estudiantes';
$string['viewfcfmodules'] = 'Ver Actividades y Recursos';
$string['viewsectionmodules'] = 'Ver Módulos de Sección';
$string['vimeo'] = 'URL de Vimeo';
$string['vimeodesc'] = 'Ingrese la URL de su canal de Vimeo (por ejemplo https://vimeo.com/user22057869)';
$string['vk'] = 'URL de VKontakte';
$string['vkdesc'] = 'Ingrese la URL de su página de Vkontakte (por ejemplo http://www.vk.com/)';
$string['website'] = 'URL de Sitio Web';
$string['websitedesc'] = 'Ingrese la URL de su propio sitio web )por ejemplo, http://unam.mx)';
$string['youtube'] = 'URL de YouTube';
$string['youtubedesc'] = 'Ingrese la URL de su canal de YouTube (por ejemplo https://www.youtube.com/user/unam)';
