<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'error', language 'es', version '4.1'.
 *
 * @package     error
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['TODO'] = 'A hacer';
$string['activityisscheduledfordeletion'] = 'Eliminación de la actividad en progreso...';
$string['agedigitalconsentmapinvalidage'] = '"{$a}" no es un valor válido para edad.';
$string['agedigitalconsentmapinvalidcomma'] = '"{$a}" tiene más o menos de una coma separadora.';
$string['agedigitalconsentmapinvalidcountry'] = '"{$a}" no es un valor válido para país.';
$string['agedigitalconsentmapinvaliddefault'] = 'Falta el valor predeterminado (*).';
$string['agelocationverificationdisabled'] = 'Verificación de ubicación y edad deshabilitadas';
$string['alreadyloggedin'] = 'Actualmente ha iniciado sesión como {$a}, necesita salir antes de volver a entrar con un usuario diferente.';
$string['authnotexisting'] = 'El plugin de autorización no existe';
$string['backupcontainexternal'] = 'Este fichero de copia de seguridad contiene nombres de Equipos de Red externos que no están configurados localmente';
$string['backuptablefail'] = '¡Las tablas de copia de seguridad NO pueden ser configuradas correctamente!';
$string['blockcannotconfig'] = 'Este bloque no soporta configuración global';
$string['blockcannotinistantiate'] = 'Problema en la instanciación del objeto bloque';
$string['blockcannotread'] = 'No se ha podido leer los datos para el blockid= {$a}';
$string['blockdoesnotexist'] = 'Este bloque no existe';
$string['blockdoesnotexistonpage'] = 'Este bloque (id={$a->instanceid}) no existe en esta página ({$a->url}).';
$string['blocknameconflict'] = 'Conflicto de nombres: el bloque {$a->name} tiene el mismo nombre que el bloque: {$a->conflict}';
$string['callbackrejectcomment'] = 'El módulo rechaza agregar este comentario';
$string['cannotaddcoursemodule'] = 'No ha sido posible añadir un nuevo módulo de curso';
$string['cannotaddcoursemoduletosection'] = 'No se ha podido añadir el nuevo módulo de curso a esa sección';
$string['cannotaddmodule'] = 'No se pudo agregar el módulo {$a} a la lista de módulos.';
$string['cannotaddnewmodule'] = 'No se pudo agregar un nuevo módulo de {$a}';
$string['cannotaddrss'] = 'No tiene permiso para agregar canales rss';
$string['cannotaddthisblocktype'] = 'No puede agregar un bloque {$a} a esta página.';
$string['cannotassignrole'] = 'No se ha posido asignar rol en el curso';
$string['cannotassignrolehere'] = 'Usted no tiene permitido asignar este rol (id = {$a->roleid}) en este contexto ({$a->context})';
$string['cannotassignselfasparent'] = '¡No se puede asignar a si mismo como padre!';
$string['cannotcallscript'] = 'No puede llamar a este script de esa forma';
$string['cannotcallusgetselecteduser'] = 'Usted no puede llamar user_selector::get_selected_user si multi selección es verdadero.';
$string['cannotcreatebackupdir'] = 'No se ha podido crear la carpeta de datos de copia de seguridad. El administrador del sitio necesita arreglar los permisos de ficheros.';
$string['cannotcreatecategory'] = 'Esta categoría no fue insertada';
$string['cannotcreatedboninstall'] = '<p> No se puede crear la base de datos. </p><p> La base de datos especificada no existe y el usuario indicado no tiene permiso para crear la base de datos. </p><p> El administrador del sitio debe comprobar la configuración de base de datos. </p>';
$string['cannotcreategroup'] = 'Error creando grupo';
$string['cannotcreatelangbase'] = 'Error: No se ha podido crear el directorio base de las traducciones';
$string['cannotcreatelangdir'] = 'No se ha podido crear el directorio de las traducciones';
$string['cannotcreateorfindstructs'] = 'Error al encontrar o crear estructuras de la sección de este curso';
$string['cannotcreatepopupwin'] = 'Elemento no definido (no se pudo crear ventana desplegable)';
$string['cannotcreatesitedir'] = 'No se pudo crear el directorio del sitio. El administrador necesita fijar los permisos de archivos.';
$string['cannotcreatetempdir'] = 'No se he podido crear el directorio temporal';
$string['cannotcreateuploaddir'] = 'No se pudo crear directorio de subida. El administrador necesita ajustar los permisos de archivos.';
$string['cannotcustomisefiltersblockuser'] = 'Usted no puede personalizar filtros de ajustes en contextos de usuario o de bloque.';
$string['cannotdeletebackupids'] = 'No se pudieron eliminar ids de copias de seguridad anteriores';
$string['cannotdeletecategorycourse'] = 'Fallo al borrar el curso \'{$a}\'.';
$string['cannotdeletecategoryquestions'] = 'No se ha podido borrar las preguntas de la categoría \'{$a\'}';
$string['cannotdeletecourse'] = 'No tiene los permisos para borrar este curso';
$string['cannotdeletecustomfield'] = 'Error al eliminar datos de campos personalizados';
$string['cannotdeletedir'] = 'No se puede eliminar ({$a})';
$string['cannotdeletefile'] = 'No se ha podido borrar este fichero';
$string['cannotdeleterole'] = 'No se ha podido borrar, porque {$a}';
$string['cannotdeleterolewithid'] = 'No puede eliminar el rol con ID {$a}';
$string['cannotdeletethisrole'] = 'No se puede eliminar este rol porque es utilizado por el sistema, o porque es el último rol con privilegios de administrador.';
$string['cannotdisableformat'] = 'El formato predeterminado no se puede deshabilitar.';
$string['cannotdownloadcomponents'] = 'No se ha podido descargar los componentes';
$string['cannotdownloadlanguageupdatelist'] = 'No se puede descargar la lista de actualizaciones del idioma desde download.moodle.org';
$string['cannotdownloadzipfile'] = 'No se ha podido descargar el fichero ZIP';
$string['cannoteditcomment'] = '¡Este comentario no es suyo para editar!';
$string['cannoteditcommentexpired'] = 'No puede editar esto. ¡El tiempo ha pasado!';
$string['cannoteditpostorblog'] = 'No puede enviar o editar blogs';
$string['cannoteditsiteform'] = 'No puede editar el sitio del curso utilizando este formulario';
$string['cannotedituserpreferences'] = 'No se ha podido editar las preferencias de éste usuario';
$string['cannotedityourprofile'] = 'Lo sentimos, no puede editar su perfil propio';
$string['cannotexecduringupgrade'] = 'No se puede ejecutar durante la actualización';
$string['cannotfindcategory'] = 'No puedo encontrar el registro de la categoría de la base de datos con ID - {$a}';
$string['cannotfindcomponent'] = 'No se ha podido encontrar el componente';
$string['cannotfindcontext'] = 'No se ha podido encontrar el contexto';
$string['cannotfindcourse'] = 'No se ha podido encontrar el curso';
$string['cannotfinddocs'] = 'No se puede encontrar "{$a}" archivos de documentos de idioma';
$string['cannotfindgradeitem'] = 'No se puede encontrar grade_item';
$string['cannotfindgroup'] = 'No ha sido posible encontrar el grupo';
$string['cannotfindhelp'] = 'No se puede encontrar "{$a}" archivos de ayuda de idioma';
$string['cannotfindinfo'] = 'No se puede encontrar información para: "{$a}"';
$string['cannotfindlang'] = 'No se puede encontrar el paquete de idioma "{$a}"!';
$string['cannotfindteacher'] = 'No se ha podido encontrar al profesor';
$string['cannotfinduser'] = 'No se puede encontrar el usuario con nombre "{$a}"';
$string['cannotgeoplugin'] = 'No se puede conectar al servidor geoPlugin en https://www.geoplugin.com. Verifique la configuración de su proxy o instale el archivo de datos MaxMind GeoLite City.';
$string['cannotgetblock'] = 'No se pudo recuperar bloques de la base de datos';
$string['cannotgetcats'] = 'No se pudo obtener el registro de la categoría';
$string['cannotgetdata'] = 'No se pudo obtener información';
$string['cannotgradeuser'] = 'No se pudo calificar este usuario';
$string['cannothaveparentcate'] = 'La categoría del curso no pueden tener una categoría padre!';
$string['cannotimport'] = 'Error de importación';
$string['cannotimportformat'] = 'Lo sentimos, la importación de este formato aún no está implementado!';
$string['cannotimportgrade'] = 'Error al importar calificaciones';
$string['cannotinsertgrade'] = 'No se puede insertar el ítem de calificación sin el id de curso';
$string['cannotinsertrate'] = 'No se puede insertar una nueva valoración ({$a->id} = {$a->rating})';
$string['cannotinsertrecord'] = 'No se pudo insertar el ID del nuevo registro {$a}';
$string['cannotmailconfirm'] = 'Error al enviar el correo electrónico de confirmación de cambio de contraseña';
$string['cannotmanualctrack'] = 'La actividad no prevé seguimiento manual de finalización';
$string['cannotmapfield'] = 'Colisión del mapeo detectada - dos campos se mapean al mismo ítem de calificación {$a}';
$string['cannotmarktopic'] = 'No se pudo marcar el tema de este curso';
$string['cannotmigratedatacomments'] = 'No se pueden migrar los comentarios del módulo de datos';
$string['cannotmodulename'] = 'No puedo obtener el nombre del módulo del constructor de navegación';
$string['cannotmoduletype'] = 'No puedo obtener el tipo del módulo del constructor de navegación';
$string['cannotmovecategory'] = 'No se ha podido mover la categoría';
$string['cannotmovecourses'] = 'No se pueden mover los cursos de la categoría en la que están a otra.';
$string['cannotmoverolewithid'] = 'No puedo mover el rol con ID {$a}';
$string['cannotopencsv'] = 'No se ha podido abrir el fichero CSV';
$string['cannotopenfile'] = 'No se puede abrir el archivo ({$a})';
$string['cannotopenforwrit'] = 'No se puede abrir para escribir: {$a}';
$string['cannotopentemplate'] = 'No se ha podido abrir el fichero de plantilla ({$a})';
$string['cannotopenzip'] = 'No se puede abrir el archivo zip, probablemente debido a un error de extensión zip en el sistema operativo de 64 bits.';
$string['cannotoverridebaserole'] = 'No se pueden anular los permisos del rol base';
$string['cannotoverriderolehere'] = 'Usted no tiene permitido anular este rol (id = {$a->roleid}) en este contexto ({$a->context})';
$string['cannotreadfile'] = 'No se puede leer el archivo ({$a})';
$string['cannotreadtmpfile'] = 'Error leyendo fichero temporal';
$string['cannotreaduploadfile'] = 'No se puede leer el fichero subido';
$string['cannotremovefrommeta'] = '¡No se puede eliminar el curso seleccionado de este meta curso!';
$string['cannotreprocessgrades'] = 'No se pudieron procesar de nuevo las calificaciones para esta actividad {$a}';
$string['cannotresetguestpwd'] = 'No se puede restablecer la contraseña de invitado';
$string['cannotresetmail'] = 'Error al restablecer la contraseña y enviársela por correo.';
$string['cannotresetthisrole'] = 'No se puede restablecer este rol';
$string['cannotrestore'] = 'Ha ocurrido un error y la restauración no se pudo completar!';
$string['cannotrestoreadminorcreator'] = 'Usted necesita ser un usuario creador o  administrador para restaurar a un curso nuevo!';
$string['cannotrestoreadminoredit'] = 'Usted necesita ser un usuario profesor o  administrador para restaurar en el curso seleccionado!';
$string['cannotsaveagreement'] = 'No se puede guardar su acuerdo';
$string['cannotsaveblock'] = 'Error al salvar la configuración del bloque';
$string['cannotsavecomment'] = 'No se ha podido guardar el comentario';
$string['cannotsavedata'] = 'No se ha podido guardar los datos';
$string['cannotsavefile'] = '¡No se ha podido guardar el fichero "{$a}"!';
$string['cannotsavemd5file'] = 'No se ha podido guardar el fichero md5';
$string['cannotsavezipfile'] = 'No se ha podido guardar el fichero ZIP';
$string['cannotservefile'] = 'No se puede entregar el archivo debido a un problema de configuración del servidor.';
$string['cannotsetparentforcatoritem'] = 'No se puede establecer el padre para la categoría o ítem del curso!';
$string['cannotsetpassword'] = 'No se puede establecer la contraseña del usuario!';
$string['cannotsetprefgrade'] = 'No se puede establecer la preferencia para la vista de agregación a {$a} para esta categoría de calificación';
$string['cannotsettheme'] = 'No se puede establecer el tema!';
$string['cannotsetupblock'] = 'Las tablas de los bloques NO se pudieron establecer de forma exitosa!';
$string['cannotsetupcapformod'] = 'No se pueden establecer los permisos para {$a}';
$string['cannotsetupcapforplugin'] = 'No se pueden establecer los permisos para {$a}';
$string['cannotshowhidecoursesincategory'] = 'No se puede mostrar/ocultar los cursos en la categoría {$a}';
$string['cannotsignup'] = 'No puede crear una nueva cuenta porque actualmente ha iniciado sesión como {$a}.';
$string['cannotswitcheditmodeon'] = 'No se pudo activar el modo de edición';
$string['cannotunassigncap'] = 'No se puede revocar la asignación de capacidad obsoleta {$a->cap} del rol {$a->role}';
$string['cannotunassignrolefrom'] = 'No se puede revocar la asignación de este usuario del Id de rol: {$a}';
$string['cannotunzipfile'] = 'No se puede descomprimir el archivo';
$string['cannotupdatemod'] = 'No se puede actualizar {$a}';
$string['cannotupdatepasswordonextauth'] = 'No se pudo actualizar la contraseña de la identificación externa: {$a}. Vea los registros del servidor para más detalles.';
$string['cannotupdateprofile'] = 'Error al actualizar el registro de usuario';
$string['cannotupdaterecord'] = 'No se puede actualizar el ID de registro {$a}';
$string['cannotupdaterss'] = 'No se puede actualizar RSS';
$string['cannotupdatesubcourse'] = 'No se puede actualizar un curso hijo!';
$string['cannotupdateusermsgpref'] = 'No se puede actualizar las preferencias de mensajes del usuario';
$string['cannotupdateuseronexauth'] = 'No se pudo actualizar la los datos de usuario de la identificación externa: {$a}. Vea los registros del servidor para más detalles';
$string['cannotuploadfile'] = 'Error al procesar el archivo subido';
$string['cannotuseadmin'] = 'Usted necesita ser un usuario administrador para usar esta página';
$string['cannotuseadminadminorteacher'] = 'Usted necesita ser un usuario profesor o administrador para usar esta página';
$string['cannotusepage'] = 'Sólo profesores y administradores pueden usar esta página';
$string['cannotusepage2'] = 'Lo sentimos, usted no puede usar esta página';
$string['cannotviewcategory'] = 'No tiene permisos para ver la lista de cursos.';
$string['cannotviewprofile'] = 'No puede ver el perfil de este usuario';
$string['cannotviewreport'] = 'Usted no puede ver este informe';
$string['cannotwritefile'] = 'No se puede escribir en el archivo ({$a})';
$string['categoryerror'] = 'Error de categoría';
$string['categoryidnumbertaken'] = 'El número ID ya está en uso por otra categoría';
$string['categorynamerequired'] = 'Se requiere un nombre para la categoría';
$string['categorytoolong'] = 'Nombre de categoría demasiado largo';
$string['commentmisconf'] = 'ID del comentario está mal configurado';
$string['componentisuptodate'] = 'El componente está actualizado';
$string['confirmationnotenabled'] = 'La confirmación del usuario no está activada en este sitio';
$string['confirmsesskeybad'] = 'Lo sentimos, pero su clave de sesión no ha podido ser confirmada para llevar a cabo esta acción. Esta característica de seguridad previene contra la ejecución en su nombre (accidental o maliciosa) de funciones importantes. Por favor, asegúrese de que realmente deseaba ejecutar esta función.';
$string['contenttypenotfound'] = 'El tipo de banco de contenido \'{$a}\' no existe o no es reconocido.';
$string['contentvisibilitynotfound'] = 'La visibilidad del contenido con valor \'{$a}\' no existe o no se reconoce.';
$string['couldnotassignrole'] = 'Al intentar asignarle un rol, ha ocurrido un error grave no especificado';
$string['couldnotupdatenoexistinguser'] = 'No se puede actualizar el usuario - el usuario no existe';
$string['couldnotverifyagedigitalconsent'] = 'Ocurrió un error al tratar de verificar la edad de consentimiento digital.<br />Por favor póngase en contacto con el administrador.';
$string['countriesphpempty'] = 'Error: El archivo countries.php en el paquete de idioma {$a} está vacío o no existe.';
$string['coursedoesnotbelongtocategory'] = 'El curso no pertenece a esta categoría';
$string['courseformatnotfound'] = 'El formato de curso \'{$a}\' no existe o no se reconoce.';
$string['coursegroupunknown'] = 'No se ha especificado el curso correspondiente al grupo {$a}';
$string['courseidnotfound'] = 'El ID del curso no existe.';
$string['courseidnumbertaken'] = 'El número ID ya se está usando en otro curso ({$a})';
$string['coursemisconf'] = 'El curso está mal configurado';
$string['courserequestdisabled'] = 'Lo sentimos, pero la solicitud de cursos ha sido deshabilitada por el administrador.';
$string['csvcolumnduplicates'] = 'Detectadas columnas duplicadas';
$string['csvemptyfile'] = 'El archivo CSV está vacío';
$string['csvfewcolumns'] = 'No hay suficientes columnas; por favor, verifique el ajuste del delimitador';
$string['csvfileerror'] = 'Algo está mal con el formato del archivo CSV. Por favor revise que coincidan el número de encabezados y de columnas, y que el delimitador y la codificación del archivo sean correctas. {$a}';
$string['csvinvalidcols'] = '<b>Archivo CSV invalido:</b> La primera línea debe incluir "Campos de Cabecera" y el archivo debe ser de tipo<br />"Campos expandidos/Separados por comas"<br />o<br /> "Campos expandidos con Código de Resultado CAVV/Separados por comas"';
$string['csvinvalidcolsnum'] = 'Archivo CSV invalido - cada línea debe incluir 49 o 70 campos';
$string['csvloaderror'] = 'Un error ocurrió durante la carga del archivo CSV: {$a}';
$string['csvnodata'] = 'Archivo CSV inválido - El archivo CSV tiene encabezados pero no contiene ningún dato.';
$string['csvweirdcolumns'] = 'Formato de archivo CSV no válido: el número de columnas no es constante.';
$string['dbconnectionfailed'] = '<p>Error:La conexión con la base de datos falló</p>
<p>Es posible que la base de datos esté sobrecargada o no funcione correctamente. </p>
<p>El administrador del sitio debe comprobar que los detalles de la base de datos han sido correctamente especificados en config.php </p>{$a}';
$string['dbdriverproblem'] = '<p>Error: Se ha detectado un problema en el controlador de la base de datos</p>
<p>El administrador del sitio debe comprobar la configuración del servidor</p><p>{$a}</p>';
$string['dbsessionbroken'] = 'Se ha detectado un serio problema en la sesión de la base de datos. <br /> <br /> Por favor notifique al administrador del servidor.';
$string['dbsessionhandlerproblem'] = 'Configurar una sesión en la base de datos ha fallado. Por favor notifique al administrador del servidor.';
$string['dbsessionmysqlpacketsize'] = 'Se ha detectado un serio problema en la sesión. Por favor notifique al administrador del servidor. Este problema es muy probablemente causado por un valor pequeño en la opción max_allowed_packet de la configuración de MySQL.';
$string['dbupdatefailed'] = 'Fallo en la actualización de la base de datos';
$string['ddldependencyerror'] = '{$a->targettype} "{$a->targetname}" no puede ser modificado. Dependencia encontrada con {$a->offendingtype} "{$a->offendingname}"';
$string['ddlexecuteerror'] = 'Error de ejecución DDL sql';
$string['ddlfieldalreadyexists'] = 'El campo "{$a}" ya existe';
$string['ddlfieldnotexist'] = 'El campo"{$a->fieldname}" no existe en la tabla "{$a->tablename}"';
$string['ddltablealreadyexists'] = 'La tabla "{$a}" ya existe';
$string['ddltablenotexist'] = 'La tabla "{$a}"no existe';
$string['ddlunknownerror'] = 'Error desconocido en la librería DDL';
$string['ddlxmlfileerror'] = 'Se encontró errores en los archivos de la base de datos XML';
$string['ddsequenceerror'] = 'Definición incorrecta de la tabla "{$a}"; sólo puede haber una columna automática y debe definirse como una clave.';
$string['destinationcmnotexit'] = 'El módulo del curso destino no existe';
$string['detectedbrokenplugin'] = 'El complemento "{$a}" es defectuoso o no está actualizado; lo sentimos pero no puede continuar.';
$string['dmlexceptiononinstall'] = '<p>Se ha producido un error de base de datos [{$a->errorcode}].<br />{$a->debuginfo}</p>';
$string['dmlparseexception'] = 'Error al analizar consulta SQL';
$string['dmlreadexception'] = 'Error al leer de la base de datos';
$string['dmltransactionexception'] = 'Error en la transacción con la base de datos';
$string['dmlwriteexception'] = 'Error escribiendo a la base de datos';
$string['downgradedcore'] = '¡ERROR! El código que está usando es MÁS ANTIGUO que la versión que construyó estas bases de datos.';
$string['downloadedfilecheckfailed'] = 'Ha fallado la comprobación del archivo descargado';
$string['duplicatefieldname'] = 'Se ha detectado un nombre duplicado del campo "{$a}"';
$string['duplicatenosupport'] = 'La actividad de
\'{$a->modname}\' no se pudo duplicar debido a que el módulo  {$a->modtype} no soporta copia de seguridad y restauración.';
$string['duplicateparaminsql'] = 'ERROR: parámetro duplicado en la consulta';
$string['duplicaterolename'] = 'Ya hay un rol con ese nombre!';
$string['duplicateroleshortname'] = 'Ya hay un rol con ese nombre corto!';
$string['duplicateusername'] = 'Nombre de usuario duplicado - registro pasado por alto';
$string['emailfail'] = 'Enviar el correo electrónico fallo';
$string['encryption_decryptfailed'] = 'Falló en la desencriptación';
$string['encryption_encryptfailed'] = 'Falló en la encriptación';
$string['encryption_invalidkey'] = 'Clave inválida';
$string['encryption_keyalreadyexists'] = 'La clave ya existe';
$string['encryption_nokey'] = 'Clave no encontrada';
$string['encryption_wrongmethod'] = 'Los datos no coinciden con un método de encriptación soportado';
$string['enddatebeforestartdate'] = 'La fecha de finalización del curso debe ser después de la de inicio del curso.';
$string['error'] = 'Ha ocurrido un error';
$string['error_question_answers_missing_in_db'] = 'Error al buscar la respuesta  correspondiente a "{$a->answer}" en la tabla question_answers de la base de datos. Esto sucede porque mientras estaba restaurando la pregunta con la id {$a->filequestionid} del fichero de copia, se ha encontrado una pregunta existente con la id  {$a->dbquestionid} en la base de datos.';
$string['errorcleaningdirectory'] = 'Error limpiando el directorio "{$a}"';
$string['errorcopyingfiles'] = 'Error copiando ficheros';
$string['errorcreatingdirectory'] = 'Error creando el directorio "{$a}"';
$string['errorcreatingfile'] = 'Error al crear el archivo  "{$a}"';
$string['errorcreatingrole'] = 'Error al crear el rol';
$string['errorfetchingrssfeed'] = 'Error al obtener el canal RSS.';
$string['erroronline'] = 'Error en la línea {$a}';
$string['erroroutput'] = 'Error de salida, deshabilite la redirección automática.';
$string['errorparsingxml'] = 'Error al analizar XML: {$a->errorstring} en la línea {$a->errorline}, carácter {$a->errorchar}';
$string['errorprocessingarchive'] = 'Error procesando archivo histórico';
$string['errorreadingfile'] = 'Error al leer el archivo  "{$a}"';
$string['errorsavingrequest'] = 'Se produjo un error al intentar salvar su petición.';
$string['errorsettinguserpref'] = 'Error al ajustar las preferencias de usuario';
$string['errorunzippingfiles'] = 'Error al descomprimir archivos';
$string['expiredkey'] = 'Clave expirada';
$string['externalauthpassworderror'] = 'Contraseña no vacía para autentificación externa';
$string['externalfilenolocation'] = 'El archivo externo no tiene una ruta para localizarlo';
$string['failtoloadblocks'] = 'Uno o más bloques están registrados en la base de datos, pero todos ellos fallaron al cargarse!';
$string['fieldrequired'] = '"{$a}" es un campo requerido';
$string['fileexists'] = 'El fichero existe';
$string['filemismatch'] = 'No coinciden nombres de archivos no básicos. EL archivo "{$a->current}" debe ser {$a->file}';
$string['filenotfound'] = 'Lo sentimos, el archivo solicitado no se encuentra';
$string['filenotreadable'] = 'El fichero no es legible';
$string['filterdoesnothavelocalconfig'] = 'El filtro {$a} no permite configuración local';
$string['filternotactive'] = 'El filtro {$a} no se encuentra activo';
$string['filternotenabled'] = '¡Filtro no habilitado!';
$string['filternotinstalled'] = 'El filtro {$a} no se encuentra instalado';
$string['forumblockingtoomanyposts'] = 'Ha excedido el umbral de tiempo para enviar mensajes a este foro';
$string['functionalityremoved'] = 'Está intentando acceder a funcionalidad que ha sido eliminada.';
$string['generalexceptionmessage'] = 'Excepción - {$a}';
$string['gradecantregrade'] = 'Ha ocurrido un error durante el cálculo de las calificaciones: {$a}';
$string['gradepubdisable'] = 'Publicación de calificaciones deshabilitada';
$string['gradesneedregrading'] = 'Las calificaciones de este curso necesitan ser recalculadas';
$string['groupalready'] = 'El usuario ya pertence al grupo {$a}';
$string['groupexistforcourse'] = 'En este curso ya hay un grupo "{$a}".';
$string['groupexistforcoursewithidnumber'] = '{$a->problemgroup}: El grupo "{$a->name}" con un idnumber "{$a->idnumber}" ya existe en este curso';
$string['grouphasidnumber'] = 'El Grupo "{$a}" tiene un idnumber y este pudo haber sido creado automáticamente por un sistema externo. Usted no tiene permiso para remover este grupo.';
$string['groupinghasidnumber'] = 'El Agrupamiento "{$a}" tiene un idnumber y este pudo haber sido creado automáticamente por un sistema externo. Usted no tiene permiso para remover este agrupamiento.';
$string['groupingnotaddederror'] = 'El agrupamiento "{$a}" no se ha añadido';
$string['groupnotaddederror'] = 'No se ha agregado el grupo "{$a}".';
$string['groupnotaddedtogroupingerror'] = 'El grupo "{$a->groupname}" no se ha añadido al agrupamiento "{$a->groupingname}"';
$string['groupunknown'] = 'El grupo {$a} no está asociado al curso especificado';
$string['groupusernotmember'] = 'El usuario no es miembro de este grupo';
$string['guestcantaccessprofiles'] = 'Los invitados no pueden acceder a los perfiles de los usuarios. Acceda al sistema con un usuario para continuar.';
$string['guestnocomment'] = 'A los invitados no se les permite publicar comentarios!';
$string['guestnoeditprofile'] = 'Los usuarios invitados no pueden editar su perfil';
$string['guestnoeditprofileother'] = 'No se puede editar el perfil de los usuarios invitados';
$string['guestnorate'] = 'A los invitados no se les permite evaluar entradas';
$string['guestsarenotallowed'] = 'Los usuarios invitados no tienen permitido hacer esto';
$string['hackdetected'] = 'Ataque de intrusión detectado!';
$string['hashpoolproblem'] = 'Contenido incorrecto del archivo de los \'hash pool\'';
$string['headersent'] = 'Las cabeceras ya han sido enviadas';
$string['idnumbertaken'] = 'Este número ID ya está en uso';
$string['idnumbertoolong'] = 'Número ID es demasiado largo';
$string['importformatnotimplement'] = 'Lo sentimos, la importación de este formato aún no está implementada!';
$string['incorrectext'] = 'El archivo tiene una extensión incorrecta';
$string['inplaceeditableerror'] = 'Error al llamar al procesador de actualización';
$string['installproblem'] = 'Generalmente no es posible recuperarse de los errores encontrados durante la instalación; es posible que tenga que crear una nueva base de datos o usar un prefijo de base de datos diferente si desea volver a intentar hacer la instalación.';
$string['internalauthpassworderror'] = 'Política de contraseña ausente o no válida para autentificación interna';
$string['invalidaccess'] = 'Esta página no se ha accedido correctamente';
$string['invalidaccessparameter'] = 'Parámetro de acceso invalido';
$string['invalidaction'] = 'Parámetro de acción invalido';
$string['invalidactivityid'] = 'ID de actividad no válido';
$string['invalidadminsettingname'] = 'Configuración de admin ({$a}) no válida';
$string['invalidargorconf'] = 'No hay argumentos válidos suministrados o la configuración del servidor es incorrecta';
$string['invalidarguments'] = 'No hay argumentos válidos suministrados';
$string['invalidblockinstance'] = 'Instancia de bloque no válida para: {$a}';
$string['invalidbulkenrolop'] = 'Se ha solicitado una petición de alta masiva inválida';
$string['invalidcategory'] = 'Categoría incorrecta!';
$string['invalidcategoryid'] = '¡ID de categoría incorrecto!';
$string['invalidcomment'] = 'El comentario es incorrecto';
$string['invalidcommentarea'] = 'Ára de comentarios inválida';
$string['invalidcommentid'] = 'ID de comentario inválido';
$string['invalidcommentitemid'] = 'ID de elemento de comentario no válido';
$string['invalidcommentparam'] = 'Parámetros de comentario inválidos';
$string['invalidcomponent'] = 'Componente del nombre inválido';
$string['invalidconfirmdata'] = 'La confirmación de los datos no es válida';
$string['invalidcontentid'] = 'ID de contenido inválido';
$string['invalidcontext'] = 'Contexto no válido';
$string['invalidcountrycode'] = 'Código de país inválido: {$a}';
$string['invalidcourse'] = 'Curso no válido';
$string['invalidcourseformat'] = 'Formato de curso inválido';
$string['invalidcourseid'] = 'Está intentando usar una ID de curso no válida';
$string['invalidcourselevel'] = 'Nivel de contexto incorrecto';
$string['invalidcoursemodule'] = 'ID de módulo de curso no válida';
$string['invalidcoursemoduleid'] = 'ID de módulo de curso no válido: {$a}';
$string['invalidcoursenameshort'] = 'El nombre corto del curso no es valido';
$string['invaliddata'] = 'La información suministrada es invalida';
$string['invaliddatarootpermissions'] = 'Se han detectado permisos no válidos al tratar de crear un  directorio. Active la depuración (debugging) para más detalles.';
$string['invaliddevicetype'] = 'Tipo de dispositivo inválido';
$string['invalidelementid'] = '¡ID de elemento incorrecto!';
$string['invalidentry'] = 'Esta no es una entrada valida!';
$string['invalidevent'] = 'Evento invalido';
$string['invalidfieldname'] = '"{$a}" no es un nombre válido';
$string['invalidfiletype'] = '"{$a}" no es un tipo de archivo válido';
$string['invalidformatpara'] = 'Formato incorrecto para el parámetro de selección';
$string['invalidformdata'] = 'Formulario de datos incorrecto';
$string['invalidfunction'] = 'Función incorrecta';
$string['invalidgradeitemid'] = 'ID de elemento de calificación incorrecto';
$string['invalidgroupid'] = 'ID de grupo especificado incorrecto';
$string['invalidipformat'] = 'Formato de dirección IP no válido';
$string['invaliditemid'] = 'ID de elemento incorrecto';
$string['invalidkey'] = 'Clave incorrecta';
$string['invalidlanguagecode'] = 'Código de idioma inválido: {$a}';
$string['invalidlegacy'] = 'Definición del rol de legado incorrecto para el tipo: {$a}';
$string['invalidmd5'] = 'La variable de comprobación era incorrecta - inténtelo de nuevo';
$string['invalidmode'] = 'Modo no válido ({$a})';
$string['invalidmodule'] = 'Módulo no válido';
$string['invalidmoduleid'] = 'ID de módulo no válido: {$a}';
$string['invalidmodulename'] = 'Nombre de módulo no válido: {$a}';
$string['invalidnum'] = 'Valor numérico no válido';
$string['invalidnumkey'] = 'La matriz $conditions no puede contener claves numéricas. ¡Por favor corrija el código!';
$string['invalidoutcome'] = 'ID de resultado incorrecto';
$string['invalidpagesize'] = 'Tamaño de página incorrecto';
$string['invalidpasswordpolicy'] = 'Directiva de contraseñas errónea';
$string['invalidpaymentmethod'] = 'Método de pago incorrecto: {$a}';
$string['invalidpersistenterror'] = 'Error: {$a}';
$string['invalidqueryparam'] = 'ERROR: Número incorrecto de parámetros de consulta. Se esperaban {$a->expected}, se tienen {$a->actual}.';
$string['invalidratingarea'] = 'Área de valoración inválida';
$string['invalidrecord'] = 'No se puede encontrar registro de datos en la tabla {$a} de la base de datos.';
$string['invalidrecordunknown'] = 'No se puede encontrar el registro de datos en la base de datos.';
$string['invalidrequest'] = 'Petición no válida';
$string['invalidrole'] = 'Rol no válido';
$string['invalidroleid'] = 'ID de rol no válido';
$string['invalidscaleid'] = 'ID de escala incorrecto';
$string['invalidsection'] = 'El registro del módulo del curso contiene una sección no válida';
$string['invalidsesskey'] = 'Lo más probable es que se haya agotado el tiempo de espera de su sesión. Inicie sesión de nuevo.';
$string['invalidshortname'] = 'Nombre corto de curso no válido';
$string['invalidsourcefield'] = 'El campo de origen del archivo borrador es inválido';
$string['invalidstatedetected'] = 'Algo ha salido mal: {$a}. Esto normalmente no debería suceder.';
$string['invalidurl'] = 'URL no válida';
$string['invaliduser'] = 'Usuario no válido';
$string['invaliduserdata'] = 'Datos de usuario no válidos: {$a}';
$string['invaliduserfield'] = 'Campo de usuario no válido: {$a}';
$string['invaliduserid'] = 'ID de usuario no válido';
$string['invalidusername'] = 'El nombre de usuario indicado contiene carácteres no válidos';
$string['invalidusernameblank'] = 'El nombre de usuario no puede estar vacío';
$string['invalidxmlfile'] = '"{$a}" no es un archivo XML válido';
$string['iplookupfailed'] = 'No se puede encontrar información geográfica sobre esta dirección IP {$a}';
$string['iplookupprivate'] = 'No se puede mostrar la búsqueda de la dirección IP privada';
$string['ipmismatch'] = 'No coincide la dirección IP del cliente';
$string['listcantmovedown'] = 'No se pudo mover el elemento hacia abajo, ya que es el último de sus pares.';
$string['listcantmoveleft'] = 'No se pudo mover a la izquierda el elemento ya que no tiene padre.';
$string['listcantmoveright'] = 'No se ha podido mover a la derecha el ítem. Póngalo debajo de otro compañero y luego podrá pasarlo a la derecha.';
$string['listcantmoveup'] = 'No se pudo subir el elemento ya que es el primero de sus iguales.';
$string['listnochildren'] = 'No se han encontrado hijos del ítem.';
$string['listnoitem'] = 'Elemento no encontrado';
$string['listnopeers'] = 'No se han encontrado iguales del ítem.';
$string['listupdatefail'] = 'La operación de la base de datos falló al editar la jerarquía de la lista';
$string['logfilenotavailable'] = 'Registros no disponibles';
$string['loginasnoenrol'] = 'No puede usar las opciones matricular o dar de baja  cuando está en curso una sesión "Entrar como"';
$string['loginasonecourse'] = 'No puede entrar a este curso.<br /> Debe terminar la sesión "Entrar como" antes de entrar a cualquier otro curso.';
$string['maxareabytes'] = 'El fichero es más grande que el espacio disponible en esta área.';
$string['maxbytesfile'] = 'El archivo {$a->file} es demasiado grande. El tamaño de subida máximo es {$a->size}.';
$string['maxdraftitemids'] = 'Sus subidas de archivos están limitadas temporalmente tras subir una gran cantidad de archivos. Por favor espere e inténtelo de nuevo después.';
$string['messageundeliveredbynotificationsettings'] = 'Este mensaje no pudo enviarse porque los mensajes personales entre usuarios (en las configuraciones de Notificación) han sido deshabilitados por un administrador del sitio.';
$string['messagingdisable'] = 'El envío de mensajes esta deshabilitado en este sitio';
$string['mimetexisnotexist'] = 'Su sistema no está configurado para ejecutar mimeTeX. Necesita obtener el código fuente en C desde <a href="https://www.forkosh.com/mimetex.zip">https://www.forkosh.com/mimetex.zip</a>, compilarlo y colocar el ejecutable dentro de su directorio moodle/filter/tex/.';
$string['mimetexnotexecutable'] = 'MimeTeX personalizado no es ejecutable!';
$string['missing_moodle_backup_xml_file'] = 'La copia de seguridad no tiene el archivo XML: {$a}';
$string['missingcategoryrole'] = 'No se pudo asignar el rol al usuario: falta rol para la categoría.';
$string['missingfield'] = 'Falta el campo "{$a}"';
$string['missingkeyinsql'] = 'ERROR: falta el parámetro "{$a}" en su consulta';
$string['missingparam'] = 'Un parámetro necesario ({$a}) faltaba';
$string['missingparameter'] = 'Falta parámetro';
$string['missingrequiredfield'] = 'Falta algún campo necesario';
$string['missinguseranditemid'] = 'Falta el userid y el itemid';
$string['missingvarname'] = 'Un nombre de variable necesario esta faltando!';
$string['mixedtypesqlparam'] = 'Error: Tipos mezclados de parámetros de consulta SQL';
$string['mnetdisable'] = 'MNET esta deshabilitado';
$string['mnetlocal'] = 'Los usuarios MNET remotos no pueden iniciar sesión localmente';
$string['moduledisable'] = 'Este módulo ({$a}) ha sido deshabilitado para este curso en particular';
$string['moduledoesnotexist'] = 'Este módulo no existe';
$string['moduleinstancedoesnotexist'] = 'La instancia de este módulo no existe';
$string['modulemissingcode'] = 'El módulo {$a} carece del código necesario para llevar a cabo esta función';
$string['movecatcontentstoroot'] = 'No se permite mover el contenido de la categoría a la raíz (root). ¡Debe mover los contenidos hacia una categoría existente!';
$string['movecatcontentstoselected'] = 'Algunos de los contenidos de categoría no se pueden mover dentro de la categoría seleccionada.';
$string['movecategorynotpossible'] = 'No puede mover la categoría \'{$a}\' a la categoría seleccionada.';
$string['movecategoryownparent'] = 'No puede hacer que la categoría \'{$a}\' sea "padre" de si misma.';
$string['movecategoryparentconflict'] = 'No se puede hacer que la categoría \'{$a}\' sea una subcategoría de una de sus propias subcategorías.';
$string['mssqlrcsmodemissing'] = 'La base de datos no está usando el modo READ_COMMITTED_SNAPSHOT esperado, lo que puede llevar a resultados erróneos, especialmente en escenarios de alta concurrencia. Por favor habilítelo para un correcto comportamiento. Para más información vea la documentación <a href="https://docs.moodle.org/es/Installing_MSSQL_for_PHP">Instalando MSSQL para PHP</a>.';
$string['multiplerecordsfound'] = 'Múltiples registros encontrados, sólo un registro se esperaba.';
$string['multiplerestorenotallow'] = 'Múltiples ejecuciones de restaurar no son permitidas!';
$string['mustbeloggedin'] = 'Usted debe haber iniciado sesión para poder hacer esto';
$string['mustbeteacher'] = 'Sólo los profesores pueden ver esta página';
$string['myisamproblem'] = 'Las tablas de la base de datos están utilizando el motor MyISAM: se recomienda usar un motor compatible con ACID que permita transacción completa, tal como InnoDB.';
$string['needcopy'] = 'Debe copiar algo primero!';
$string['needcoursecategroyid'] = 'O bien un ID de curso o de una categoría debe de especificarse';
$string['needphpext'] = 'Usted necesita añadir soporte {$a} a su instalación de PHP';
$string['noadmins'] = 'No administradores!';
$string['noblocks'] = 'No se encontraron bloques!';
$string['nocapabilitytousethisservice'] = 'El usuario no tiene los permisos necesarios para utilizar este servicio';
$string['nocategorydelete'] = '¡La categoría \'{$a}\' no puede eliminarse!';
$string['nocontext'] = 'Lo sentimos, ese curso no es un contexto válido';
$string['nodata'] = 'Sin datos';
$string['noexistingcategory'] = 'Categoría inexistente';
$string['nofile'] = 'El fichero no ha sido especificado';
$string['nofiltersenabled'] = 'No hay filtros habilitados';
$string['nofolder'] = 'El directorio solicitado no existe';
$string['noformdesc'] = 'No se encontró el archivo de descripción del formulario formslib para esta actividad.';
$string['noguest'] = '¡Sin invitados aquí!';
$string['noinstances'] = 'En este curso no aparece {$a}.';
$string['nologinas'] = 'No está autorizado a iniciar sesión como ese usuario';
$string['nonmeaningfulcontent'] = 'No contenido significativo';
$string['noparticipants'] = 'No se encontraron participantes en este curso';
$string['noparticipatorycms'] = 'Lo sentimos, no dispone de módulos de participación en cursos sobre los que informar';
$string['nopermissions'] = 'Lo sentimos, pero no tiene los permisos para hacer esto ({$a}).';
$string['nopermissiontoaccesspage'] = 'No tiene permiso para acceder a esta página.';
$string['nopermissiontocomment'] = 'No puede añadir comentarios';
$string['nopermissiontodelentry'] = '¡No puede borrar este comentario!';
$string['nopermissiontoeditcomment'] = 'No puede editar comentarios de otras personas!';
$string['nopermissiontohide'] = 'No tiene permiso para ocultar!';
$string['nopermissiontoimportact'] = 'Usted no tiene los permisos necesarios para importar actividades a este curso';
$string['nopermissiontolock'] = '¡No tiene permisos para bloquear!';
$string['nopermissiontomanagegroup'] = 'No tiene el permiso necesario para gestionar grupos';
$string['nopermissiontorate'] = 'La evaluación de ítems no es permitida!';
$string['nopermissiontoshow'] = '¡No tiene permiso para ver esto!';
$string['nopermissiontounlock'] = '¡No tiene permiso para desbloquear!';
$string['nopermissiontoupdatecalendar'] = 'Lo sentimos, no tiene permisos para actualizar los eventos del calendario.';
$string['nopermissiontoviewcalendar'] = 'Lo sentimos, pero no tiene permisos para ver el evento de calendario.';
$string['nopermissiontoviewgrades'] = 'No se pueden ver las calificaciones.';
$string['nopermissiontoviewletergrade'] = 'Le falta permisos para revisar las calificaciones con letra';
$string['nopermissiontoviewpage'] = 'No está autorizado a ver esta página';
$string['nosite'] = 'No se puede encontrar un curso de nivel superior!';
$string['nositeid'] = 'Sin ID de sitio';
$string['nostartdatenoenddate'] = 'Solamente se puede establecer una fecha de finalización del curso si se ha establecido una fecha de inicio.';
$string['nostatstodisplay'] = 'Lo siento, no hay datos disponibles para mostrar';
$string['notallowedtoupdateprefremotely'] = 'No está autorizado para actualizar esta preferencia de usuario de forma remota';
$string['notavailable'] = 'No disponible en este momento';
$string['notlocalisederrormessage'] = '{$a}';
$string['notmemberofgroup'] = 'Usted no es un miembro de este grupo en este curso';
$string['notownerofkey'] = 'No es el propietario de esta llave';
$string['nousers'] = '¡Usuario inexistente!';
$string['oauth1accesstoken'] = 'Error de OAuth 1.0. No obtuvimos la ficha (token) para acceso.';
$string['oauth1requesttoken'] = 'Error de OAuth 1.0. No obtuvimos la ficha (token) para acceso - el proveedor de servicios podría estar fuera de servicio temporalmente.';
$string['oauth2refreshtokenerror'] = 'No se pudo refrescar el token OAuth 2. Estado HTTP para endpoint remoto: {$a}';
$string['oauth2refreshtokentaskerror'] = 'No se pudo refrescar el token OAuth 2 para uno o más emisores. Vea la salida generada por la tarea para los detalles.';
$string['oauth2upgradetokenerror'] = 'No se pudo actualizar el token OAuth 2. Estado HTTP para endpoint remoto: {$a}';
$string['onlyadmins'] = 'Sólo los administradores pueden hacer eso';
$string['onlyeditingteachers'] = 'Sólo los profesores editores pueden hacer eso';
$string['onlyeditown'] = 'Sólo puede editar su propia información';
$string['opensslsealerror'] = 'OPENSSL no puede sellar los datos';
$string['opensslsignerror'] = 'OpenSSL no puede firmar datos';
$string['orderidnotfound'] = 'ID de la orden {$a} no se encuentra';
$string['pagenotexist'] = '<p>Ha ocurrido un error inusual al intentar ver una página que no existe:</p>{$a}';
$string['pagenotexisttitle'] = 'Error 404: Archivo no encontrado';
$string['pathdoesnotstartslash'] = 'No hay argumentos válidos suministrados, la ruta no comienza con diagonal!';
$string['pleasereport'] = 'Si tiene tiempo, por favor háganos saber qué estaba intentando hacer cuando tuvo lugar el error:';
$string['pluginrequirementsnotmet'] = 'No se ha podido instalar el plugin "{$a->pluginname}" ({$a->pluginversion}). Necesita una nueva versión de Moodle (actualmente usted está usando {$a->currentmoodle}, y necesita {$a->requiremoodle}).';
$string['pluginunsupported'] = 'El plugin "{$a->pluginname}" {$a->pluginversion} no soporta esta versión de Moodle {$a->moodleversion}. Busque información del plugin para encontrar versiones soportadas.';
$string['prefixcannotbeempty'] = '<p>Error: El prefijo de la tabla de la base de datos no puede estar vacío ({$a})</p>
<p>El administrador del sitio debe arreglar este problema.</p>';
$string['prefixtoolong'] = '<p>Error: El prefijo de la tabla de la base de datos es demasiado larga ({$a->dbfamily})</p>
<p>El administrador del sitio debe arreglar este problema. La longitud máxima para los prefijos de tabla en {$a->dbfamily} es de {$a->maxlength} caracteres. </p>';
$string['privatefilesupload'] = 'Ya no se permite subir archivos directamente al área de archivos privados del usuario. Suba los archivos a un área de borrador y después mueva los archivos con core_user::add_user_private_files';
$string['processingstops'] = 'El procesamiento acaba aquí. Se pasan por alto los demás registros.';
$string['protected_cc_not_supported'] = 'No se admiten cartuchos protegidos.';
$string['querystringcannotbeempty'] = 'La cadena de consulta no puede estar vacía.';
$string['redirecterrordetected'] = 'Detectada redirección no admitida: ejecución del script terminada';
$string['refoundto'] = 'Puede ser reembolsado a {$a}';
$string['refoundtoorigi'] = 'Reembolsado a la cantidad original: {$a}';
$string['registrationdisabled'] = 'El registro está deshabilitado en este sitio';
$string['remotedownloaderror'] = '<p>Falló la descarga del componente a su servidor. Se recomienda verificar los ajustes del proxy, extensión PHP cURL.</p>
<p>Debe descargar el <a href="{$a->url}">{$a->url}</a> archivo manualmente, copiarlo en "{$a->dest}" en su servidor y descomprimirlo allí.</p>';
$string['remotedownloadnotallowed'] = 'No está permitido descargar los componentes a su servidor (allow_url_fopen está deshabilitado).<br /><br />Debe descargar el archivo <a href="{$a->url}">{$a->url}</a> manualmente, y copiarlo a "{$a->dest}"';
$string['reportnotavailable'] = 'Este tipo de informe sólo está disponible para el curso del sitio';
$string['requirecorrectaccess'] = 'Puerto o URL no válidos.';
$string['requireloginerror'] = 'Curso o actividad no accesible.';
$string['restore_path_element_missingmethod'] = 'No se encuentra el método de restauración {$a}. Debe ser definido por un programador.';
$string['restore_path_element_noobject'] = 'El objeto de restauración {$a} no es un objeto.';
$string['restorechecksumfailed'] = 'Ha ocurrido algún problema con la información de restauración almacenada en su sesión. Por favor, compruebe los límites del tamaño de la memoria PHP/paquete DB. Restauración detenida.';
$string['restrictedcontextexception'] = 'Lo sentimos, la ejecución de una función externa viola la restricción del contexto.';
$string['restricteduser'] = 'Lo sentimos, su cuenta "{$a}" no puede hacer esto';
$string['reverseproxyabused'] = 'Proxy inverso habilitado para que no se pueda acceder directamente al servidor.<br/>Comuníquese con el administrador del servidor.';
$string['rpcerror'] = 'Su configuración MNET ha fallado. Éste es el mensaje de error para pasar a su administrador: {$a}';
$string['scheduledbackupsdisabled'] = 'Las copias de seguridad programadas han sido deshabilitadas por el administrador del sitio';
$string['secretalreadyused'] = 'El enlace de confirmación de cambio de clave ha sido utilizando anteriormente. La clave no ha sido modificada';
$string['sectionnotexist'] = 'Esta sección no existe';
$string['sendmessage'] = 'Enviar mensaje';
$string['sendmessagesent'] = 'Gracias por su retroalimentación acerca de:<br>{$a}';
$string['serverconnection'] = 'Error conectando al servidor';
$string['servicedonotexist'] = 'El servicio no existe';
$string['sessioncannotobtainlock'] = '<p>No se pudo obtener el bloqueo para el ID de sesión {$a->id} dentro de {$a->acquiretimeout}.</p>
<p>Es probable que otra página ({$a->whohaslock}) aún se esté ejecutando en otra pestaña del navegador, o que no liberó el bloqueo debido a un error.</p>
<p>Puede esperar hasta que se agote el tiempo de espera del bloqueo de la sesión ({$a->lockexpire}) o puede reiniciar la sesión de su navegador. Si este error persiste, notifique al administrador del servidor.</p>';
$string['sessioncookiesdisable'] = 'Uso incorrecto de <b>require_key_login()</b> - las \'cookies\' de sesión deben estar deshabilitadas.';
$string['sessiondiskfull'] = 'La partición de sesiones está llena. No es posible iniciar sesión en este momento. Por favor notifique al administrador del servidor.';
$string['sessionerroruser'] = 'Su sesión ha excedido el tiempo límite. Por favor, acceda de nuevo.';
$string['sessionerroruser2'] = 'Se ha detectado un error del servidor que afecta a su inicio de sesión. Por favor, acceda de nuevo o reinicie su navegador.';
$string['sessionexpired'] = 'La sesión expiró';
$string['sessionhandlerproblem'] = 'El gestor de sesión está mal configurado';
$string['sessionipnomatch'] = 'Lo sentimos, pero su número IP parece haber cambiado desde su primer acceso. Esta norma de seguridad previene que los crackers roben su identidad mientras usted está dentro de este sitio. Los usuarios normales no deberían ver este mensaje, así que por favor pida ayuda al administrador del sitio.';
$string['sessionipnomatch2'] = '<p>Lo sentimos, pero su dirección IP, parece haber cambiado desde la primera vez que inicio su sesión. Esta característica de seguridad impide a los \'crackers\' robar su identidad mientras está conectado a este sitio. Usted puede ver este error si utiliza redes wifi o si está en itinerancia (roaming) entre redes diferentes. Por favor, pregunte al administrador del sitio para obtener más ayuda. </p>
<p>Si desea continuar por favor presione la tecla F5 para refrescar esta página.</p>';
$string['sessionwaiterr'] = 'Tiempo de espera para el bloqueo de sesión.Espere a que finalice su solicitud actual y vuelva a intentarlo más tarde.';
$string['shortnametaken'] = 'El nombre corto ({$a}) ya ha sido utilizado para otro curso';
$string['sitepolicynotagreed'] = 'No ha aceptado la política del sitio: <a href="{$a}">Haga clic aquí para abrir la política del sitio.</a>';
$string['socksnotsupported'] = 'Proxy SOCKS5 no está soportado en PHP4';
$string['spellcheckernotconf'] = 'Corrector de ortografía no configurado';
$string['sslonlyaccess'] = 'Disculpe, por razones de seguridad sólo se permiten conexiones https.';
$string['statscatchupmode'] = 'La estadística está en este momento en modo \'catchup\'. Hasta el momento se ha(n) procesado {$a->daysdone} día(s) y {$a->dayspending} están pendientes de procesamiento. Por favor, vuelva a comprobarlo más tarde.';
$string['statsdisable'] = 'Las estadísticas no están habilitadas.';
$string['statsnodata'] = 'No hay datos disponibles para esa combinación de curso y período de tiempo';
$string['storedfilecannotcreatefile'] = 'No se puede crear el archivo local de agrupación de archivos local. Por favor verifique los permisos en dataroot y el espacio en disco disponible.';
$string['storedfilecannotcreatefiledirs'] = 'No se pueden crear directorios de agrupaciones de archivos locales. Por favor verifique los permisos en dataroot.';
$string['storedfilecannotread'] = 'No se puede leer el archivo. Bien el archivo no existe o hay problemas de permisos.';
$string['storedfilecannotreadfile'] = 'No se pudo leer el archivo \'{$a}\'. O bien el archivo no existe o bien hay un problema de permisos.';
$string['storedfilenotcreated'] = 'No se puede crear el archivo {$a->contextid}/{$a->component}/{$a->filearea}/{$a->itemid}{$a->filepath}{$a->filename}';
$string['storedfileproblem'] = 'Excepción desconocida relacionadas con los archivos locales ({$a})';
$string['tagdisabled'] = 'Las etiquetas están deshabilitadas';
$string['tagnotfound'] = 'No se ha encontrado la marca especificada en la base de datos';
$string['targetdatabasenotempty'] = 'La base de datos destino no está vacía. La transferencia a sido cancelada por razones de seguridad.';
$string['textconditionsnotallowed'] = 'No se permiten comparaciones de las condiciones de columna de texto. Por favor, use sql_compare_text () en la consulta.';
$string['themenotinstall'] = '¡Este tema no está instalado!';
$string['tokengenerationfailed'] = 'No se puede generar una nueva ficha.';
$string['transactionvoid'] = 'La transacción no puede ser anulada porque ya ha sido anulada';
$string['unenrolerror'] = 'Se produjo un error al intentar dar de baja a esta persona';
$string['unicodeupgradeerror'] = 'Lo sentimos, su base de datos aún no está en Unicode, y esta versión de Moodle no puede migrar su base de datos a Unicode. Por favor, actualícese a Moodle 1.7.x y lleve a cabo la migración Unicode desde la página de Administración. Una vez lo haya hecho, podrá migrar a Moodle {$a}';
$string['unknowaction'] = 'Acción desconocida';
$string['unknowcategory'] = 'Categoría desconocida!';
$string['unknowcontext'] = 'Este es un contexto desconocido ({$a}) en get_child_contexts!';
$string['unknowformat'] = 'Formato desconocido ({$a})';
$string['unknownbackupexporterror'] = 'Error desconocido al preparar la información para importar';
$string['unknownblockregion'] = 'La región bloqueada \'{$a}\' no es reconocida en esta paǵina.';
$string['unknowncategory'] = 'Categoría desconocida con número de ID de categoría "{$a}"';
$string['unknowncontext'] = 'Este es un contexto desconocido.';
$string['unknowncourse'] = 'No existe un curso llamado "{$a}"';
$string['unknowncourseidnumber'] = 'ID del Curso "{$a}" desconocido';
$string['unknowncourserequest'] = 'Petición de curso desconocida';
$string['unknowncoursesection'] = 'Sección de curso desconocida en el curso "{$a}"';
$string['unknownevent'] = 'Evento desconocido';
$string['unknownfiletype'] = 'Error tipo de filtro desconocido';
$string['unknowngroup'] = 'Grupo "{$a}" desconocido';
$string['unknownhelp'] = 'Tópico de ayuda {$a} desconocido';
$string['unknownjsinrequirejs'] = 'No se puede encontrar la librería de JavaScript {$a}.';
$string['unknownmodulename'] = 'Nombre de módulo desconocido para el formulario';
$string['unknownrole'] = 'Rol desconocido "{$a}"';
$string['unknownsortcolumn'] = 'Columna de ordenación desconocida {$a}';
$string['unknownuseraction'] = 'Lo siento, no entiendo esta acción del usuario';
$string['unknownuserselector'] = 'Selector de usuario desconocido';
$string['unknoworder'] = 'Orden desconocido';
$string['unknowparamtype'] = 'Tipo de parámetro {$a} desconocido';
$string['unknowquestiontype'] = 'Tipo de pregunta {$a} no soportado';
$string['unknowuploadaction'] = 'Error: acción de subir ({$a}) desconocida';
$string['unspecifycourseid'] = 'Debe especificar Id de curso, nombre corto o Número de Id';
$string['unsupportedevent'] = 'Tipo de evento no soportado';
$string['unsupportedstate'] = 'Estado de finalización no soportado';
$string['unsupportedwebserver'] = 'Lo sentimos, el software del servidor Web ({$a}) no es compatible.';
$string['upgraderequires19'] = 'Error: Una nueva versión de Moodle se ha instalado en el servidor, por desgracia la actualización desde la versión anterior no esta soportada. <br /> Por favor, actualice primero a la versión más reciente 1.9.x. Usted también puede regresar a la versión anterior por medio de reinstalar los archivos originales.';
$string['upgraderunning'] = 'El sitio está siendo actualizado, por favor inténtelo de nuevo más tarde.';
$string['urlnotdefinerss'] = 'URL no definida para el canal RSS';
$string['useradmineditadmin'] = 'Sólo los administradores pueden modificar las cuentas de otros administradores';
$string['useradminodelete'] = 'Las cuentas de los administradores no pueden ser eliminadas.';
$string['userautherror'] = 'Conector de identificación desconocido';
$string['userauthunsupported'] = 'Conector de identificación no admitido aquí';
$string['useremailduplicate'] = 'Dirección duplicada';
$string['userisfilteredout'] = '¡Este usuario no coincide con los filtros y las preferencias de la tabla!';
$string['usermustbemnet'] = 'Los usuarios en la lista de control de acceso MNET deben ser usuarios MNET remotos';
$string['usernamelowercase'] = 'El nombre de usuario debe estar en minúsculas';
$string['usernotaddederror'] = 'Usuario no añadido - error';
$string['usernotaddedregistered'] = 'Usuario no añadido - ya registrado';
$string['usernotavailable'] = 'Los detalles de este usuario no están disponibles para usted';
$string['usernotdeletedadmin'] = 'Usuario no borrado ya que no se pueden borrar cuentas de administrador';
$string['usernotdeleteddeleted'] = 'Ese usuario ya ha sido borrado.';
$string['usernotdeletederror'] = 'Usuario no borrado - error';
$string['usernotdeletedmissing'] = 'Usuario no borrado - no se ha podido encontrar el nombre usuario';
$string['usernotdeletedoff'] = 'Usuario no borrado - borrado no permitido';
$string['usernotfullysetup'] = 'El usuario no está completamente configurado';
$string['usernotincourse'] = '¡Éste usuario no está en este curso!';
$string['usernotrenamedadmin'] = 'No se puede renombrar cuentas de administrador';
$string['usernotrenamedexists'] = 'Usuario no renombrado - el nuevo nombre de usuario ya está en uso';
$string['usernotrenamedmissing'] = 'Usuario no renombrado - no se ha podido encontrar el viejo nombre de usuario';
$string['usernotrenamedoff'] = 'Usuario no renombrado - renombrado no permitido';
$string['usernotupdatedadmin'] = 'No se puede actualizar cuentas de administrador';
$string['usernotupdatederror'] = 'Usuario no actualizado - error';
$string['usernotupdatednotexists'] = 'Usuario no actualizado - no existe';
$string['userquotalimit'] = 'Ha alcanzado su límite de cuota de ficheros.';
$string['userselectortoomany'] = 'user_selector tiene más de un usuario seleccionado, a pesar de que la opción de selección múltiple (multiselect) es falso.';
$string['verifyagedigitalconsentnotpossible'] = 'Lo sentimos, en este momento no es posible la verificación del consentimiento de edad digital.';
$string['wrongcall'] = 'El script esta siendo llamado incorrectamente';
$string['wrongcontextid'] = 'El ID de contexto es incorrecto (no lo encuentro)';
$string['wrongdestpath'] = 'Ruta de destino errónea';
$string['wrongroleid'] = 'Id de rol incorrecto';
$string['wrongsourcebase'] = 'Base de URL de origen errónea';
$string['wrongusernamepassword'] = 'Usuario/clave incorrecto';
$string['wrongzipfilename'] = 'Nombre de fichero ZIP incorrecto';
$string['wscouldnotcreateecoursenopermission'] = 'WS - No se pudo crear un curso - No tiene permiso';
$string['wwwrootmismatch'] = 'Acceso incorrecto detectado, a este servidor se le puede acceder solamente a través de la dirección "{$a}", lo siento. <br /> Por favor notifique al administrador del servidor.';
$string['wwwrootslash'] = '$CFG->wwwroot detectado incorrectamente en el archivo config.php, ya que no debe contener diagonales invertidas (). <br /> Por favor notifique al administrador del servidor.';
$string['xmldberror'] = 'Error XMLDB';
$string['youcannotdeletecategory'] = 'No puede eliminar la categoría \'{$a}\', porque no puede eliminar el contenido, ni puede moverlo a otro lugar.';
